/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_SMCTG_H
#define __S6J3360_SMCTG_H

#include "s6j3360io_basetypes.h"

/* SMCTG0 base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define SMCTG0	stcSMCTG0
#else /* __IO_DEFINE */
#define SMCTG0	(*((volatile stc_smctg0_t*)0xB48C5800))
#endif /* __IO_DEFINE */

/* PTRGS */
#define SMCTG0_PTRGS	(SMCTG0.unPTRGS.u16Register)  /*@rg@*/
#define SMCTG0_PTRGS_S10	(SMCTG0.unPTRGS.stcField.u1S10)  /*@bf@*/
#define SMCTG0_PTRGS_S11	(SMCTG0.unPTRGS.stcField.u1S11)  /*@bf@*/
#define SMCTG0_PTRGS_S12	(SMCTG0.unPTRGS.stcField.u1S12)  /*@bf@*/
#define SMCTG0_PTRGS_S13	(SMCTG0.unPTRGS.stcField.u1S13)  /*@bf@*/
#define SMCTG0_PTRGS_S14	(SMCTG0.unPTRGS.stcField.u1S14)  /*@bf@*/
#define SMCTG0_PTRGS_S15	(SMCTG0.unPTRGS.stcField.u1S15)  /*@bf@*/
#define SMCTG0_PTRGS_S20	(SMCTG0.unPTRGS.stcField.u1S20)  /*@bf@*/
#define SMCTG0_PTRGS_S21	(SMCTG0.unPTRGS.stcField.u1S21)  /*@bf@*/
#define SMCTG0_PTRGS_S22	(SMCTG0.unPTRGS.stcField.u1S22)  /*@bf@*/
#define SMCTG0_PTRGS_S23	(SMCTG0.unPTRGS.stcField.u1S23)  /*@bf@*/
#define SMCTG0_PTRGS_S24	(SMCTG0.unPTRGS.stcField.u1S24)  /*@bf@*/
#define SMCTG0_PTRGS_S25	(SMCTG0.unPTRGS.stcField.u1S25)  /*@bf@*/

typedef struct stc_smctg0_ptrgs_field{
    uint_io16_t		u1S10:1;
    uint_io16_t		u1S11:1;
    uint_io16_t		u1S12:1;
    uint_io16_t		u1S13:1;
    uint_io16_t		u1S14:1;
    uint_io16_t		u1S15:1;
    uint_io16_t		:2;
    uint_io16_t		u1S20:1;
    uint_io16_t		u1S21:1;
    uint_io16_t		u1S22:1;
    uint_io16_t		u1S23:1;
    uint_io16_t		u1S24:1;
    uint_io16_t		u1S25:1;
    uint_io16_t		:2;
}stc_smctg0_ptrgs_field_t;

typedef union un_smctg0_ptrgs{
    uint_io16_t		u16Register;
    stc_smctg0_ptrgs_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_smctg0_ptrgs_t;

/* PTRG */
#define SMCTG0_PTRG	(SMCTG0.unPTRG.u16Register)  /*@rg@*/
#define SMCTG0_PTRG_TR1	(SMCTG0.unPTRG.stcField.u1TR1)  /*@bf@*/
#define SMCTG0_PTRG_TR2	(SMCTG0.unPTRG.stcField.u1TR2)  /*@bf@*/

typedef struct stc_smctg0_ptrg_field{
    uint_io16_t		u1TR1:1;
    uint_io16_t		u1TR2:1;
    uint_io16_t		:14;
}stc_smctg0_ptrg_field_t;

typedef union un_smctg0_ptrg{
    uint_io16_t		u16Register;
    stc_smctg0_ptrg_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_smctg0_ptrg_t;


typedef struct stc_smctg0{
    un_smctg0_ptrgs_t	unPTRGS;	/* 0x00000000 */
    un_smctg0_ptrg_t	unPTRG;	/* 0x00000002 */
    uint_io8_t	au8Reserved0[1020];	/* 0x00000004 */
}stc_smctg0_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_smctg0_t	stcSMCTG0;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_SMCTG_H */
