#include "Barcode_Scanner.h"
#include "api_RS485.h"
#include "string.h"
#include "init.h"
#include "Display_Info.h"
#include "R485_Communication_Matrix.h"
#define UART_RX_MAX_DEPTH (1024)    // 4K

typedef struct
{
    uint32_t read_pos;
    uint32_t write_pos;
    uint8_t  Rx_Buffer [ UART_RX_MAX_DEPTH ];
} UARTRxBuf_t;

static UARTRxBuf_t      UARTRxBuf;
static UARTRxBuf_t      UARTRxBuf1;
static uint8_t  mDataBufPtr[1024]   = {0};
static uint32_t mDataBufLen   = 0;
static uint8_t  mDataBufPtr1[1024]   = {0};
static uint32_t mDataBufLen1   = 0;
uint8_t  BarCode[256] = {0};
uint8_t  BarCode1[256] = {0};
uint32_t readNum = 0;
uint32_t readNum1 = 0;

static uint32_t Protocol_UartRead(uint8_t *pData, uint32_t len);//485
static uint32_t Protocol_UartRead1(uint8_t *pData, uint32_t len);//扫码枪
static uint32_t Protocol_UartRead2(uint8_t *pData, uint32_t len);//esp32
uint8_t nowdata[4];
uint8_t lastdata[4];
uint8_t checkresult;
uint8_t sendmsg[8];
uint8_t timenum = 0;
uint8_t firstflag = 0;
uint8_t RS485_data[64];
uint8_t checknumwrong = 3;
uint8_t zhenduanflag = 0;
uint8_t clearOdoFlag = 0;
uint8_t connectbleFlag = 0;
uint8_t Auto_ONOFF = 0;

uint8_t key_array[4];
uint8_t seed_value[4];
uint8_t zhenduansendStep = 0;
uint8_t line_stdio = 2;
uint8_t powerstdio = 0;
uint8_t get_num_buf[34];
uint8_t comparestart;
uint8_t blename[5];
uint16_t lightnumber = 0;
void get_key(void)
{
    // key_array[0] = seed_value[0] | seed_value[3];
    // key_array[1] = (seed_value[1] >> 1) | (seed_value[2] << 1);
    // key_array[2] = (seed_value[2] >> 2) | (seed_value[1] << 2);
    // key_array[3] = (seed_value[3] >> 3) | (seed_value[0] << 3);
    // key_value = ((uint32_t)key_array[0] << 24U);
    // key_value = key_value | ((uint32_t)key_array[1] << 16U);
    // key_value = key_value | ((uint32_t)key_array[2] << 8U);
    // key_value = key_value | (uint32_t)key_array[3];
}
void datacheck(void)
{
    uint8_t  dataopenBuff  [ 11 ] ={0x07,0x36,0xAD,0x0F,0x0F,0x11,0x01,0x02,0x03,0x04,0xE6};
    uint8_t  datacloseBuff [ 11 ] ={0x07,0x36,0x33,0x0F,0x0F,0x11,0x01,0x02,0x03,0x04,0x6C};
    if(memcmp(BarCode,dataopenBuff,11) == 0)
    {
        POWER_CTRL_KL15 = 1;
    }
    else
    {
        if(memcmp(BarCode,datacloseBuff,11) == 0)
        {
            POWER_CTRL_KL15 = 0;
        }
    }
    memset(BarCode, 0, sizeof(BarCode));


}
uint8_t cmpresult = 3;
void BarCodeDataGet(void)
{

    if((mDataBufPtr1[0] == 0x59) && (mDataBufPtr1[1] == 0x59)&&(mDataBufPtr1[39] != 0x0))
    {
        memcpy(barcode_Msg,&mDataBufPtr1[6],34);
        memcpy(barcode_Msg1,&mDataBufPtr1[6],34);
    }
    else
    {
        memcpy(barcode_Msg1,&mDataBufPtr1[6],34);
        memset(barcode_Msg,0,34);
    }
}
uint8_t GetDataCompare(void)
{
    
    for(int i = 0;i<34;i++)
    {
        if(get_num_buf[i] == barcode_Msg1[i] )
        {
            cmpresult = 0;
            // u8compareresult = 0;
        }
        else
        {
            cmpresult = 1;
            return cmpresult;
            // u8compareresult = 1;
        }
        
    }
    return cmpresult;
    
}
void UART_Put(uint32_t Value)
{
    uint32_t nextPos = 0u;
    
    nextPos = (UARTRxBuf.write_pos + 1) % UART_RX_MAX_DEPTH;

    if ( nextPos == UARTRxBuf.read_pos )
    {
        //队列已满，无法插入队列
        // UARTRxBuf.write_pos  = 0;
        // RS485_TX_finish = 0;
    }
    else
    {
        UARTRxBuf.Rx_Buffer [ UARTRxBuf.write_pos ] = Value;
        UARTRxBuf.write_pos                         = (UARTRxBuf.write_pos + 1) % UART_RX_MAX_DEPTH;
    }
    // RS485_TX_finish = 0;
    // LINE_OUT_NEG_09 = 1;
    // RS485_TX_finish = 0;
    // RS485_send_time = 0;
    RS485_send_time = 0;
    return;
}
void UART_Put1(uint32_t Value)
{
    uint32_t nextPos = 0u;
    
    nextPos = (UARTRxBuf1.write_pos + 1) % UART_RX_MAX_DEPTH;

    if ( nextPos == UARTRxBuf1.read_pos )
    {
        //队列已满，无法插入队列
        // UARTRxBuf.write_pos  = 0;
        // RS485_TX_finish = 0;
    }
    else
    {
        UARTRxBuf1.Rx_Buffer [ UARTRxBuf1.write_pos ] = Value;
        UARTRxBuf1.write_pos                         = (UARTRxBuf1.write_pos + 1) % UART_RX_MAX_DEPTH;
    }
    // RS485_TX_finish = 0;
    // LINE_OUT_NEG_09 = 1;
    // RS485_TX_finish = 0;
    return;
}

void UART_Put2(uint32_t Value)
{
    uint32_t nextPos = 0u;
    
    nextPos = (UARTRxBuf.write_pos + 1) % UART_RX_MAX_DEPTH;

    if ( nextPos == UARTRxBuf.read_pos )
    {
        //队列已满，无法插入队列
        // UARTRxBuf.write_pos  = 0;
        // RS485_TX_finish = 0;
    }
    else
    {
        UARTRxBuf.Rx_Buffer [ UARTRxBuf.write_pos ] = Value;
        UARTRxBuf.write_pos                         = (UARTRxBuf.write_pos + 1) % UART_RX_MAX_DEPTH;
    }
    RS485_send_time = 0;
    return;
}
#define min(a, b) (((a) < (b)) ? (a) : (b))
void Recv_Byte(void)
{
    int      i = 0;
    int      j = 0;
    uint32_t len;

    readNum = Protocol_UartRead(mDataBufPtr + mDataBufLen, 1024 - mDataBufLen);
    
    if (readNum > 0)
    {
        mDataBufLen += readNum;

        while(mDataBufLen)
        {
            // 查找帧头0x07
            i = 0;
            while(i < mDataBufLen && mDataBufPtr[i] != 0x07)
                i++;

            // 如果没有找到帧头，处理全部剩余数据
            if (i >= mDataBufLen)
            {
                len = mDataBufLen;
                // 复制数据到BarCode（可选）
                memset(BarCode, 0, sizeof(BarCode));
                memcpy(BarCode, mDataBufPtr, min(len, sizeof(BarCode)));
            }
            // 找到帧头但数据不足
            else if (i + 11 > mDataBufLen)
            {
                // 数据不足，等待更多数据
                break;
            }
            // 找到帧头且数据足够
            else
            {
                // 复制数据，确保不越界
                memset(BarCode, 0, sizeof(BarCode));
                for(j = 0; j < mDataBufLen; j++)
                {
                    BarCode[j] = mDataBufPtr[i + j];  // 从帧头后一个位置开始复制
                }
                len = 11;  // 处理11个字节（帧头+10字节数据）
            }

            // 移动剩余数据
            if (len > 0 && len <= mDataBufLen)
            {
                memcpy(mDataBufPtr, mDataBufPtr + len, mDataBufLen - len);
            }
            mDataBufLen -= len;
            
            // 处理数据
            datacheck();
        }
    }
}

static uint32_t Protocol_UartRead(uint8_t *pData, uint32_t len)
{
    uint32_t i       = 0;
    uint32_t DataLen = 0u;
    uint32_t ReadLen = 0u;

    if ( UARTRxBuf.write_pos == UARTRxBuf.read_pos )
    {
        return 0;    //队列空
    }

    if ( UARTRxBuf.write_pos > UARTRxBuf.read_pos )
    {
        DataLen = UARTRxBuf.write_pos - UARTRxBuf.read_pos;
    }
    else
    {
        DataLen = UART_RX_MAX_DEPTH - (UARTRxBuf.read_pos - UARTRxBuf.write_pos);
    }

    if ( len > DataLen )
    {
        ReadLen = DataLen;
    }
    else
    {
        ReadLen = len;
    }

    for ( i = 0u; i < ReadLen; i++ )
    {
        pData [ i ]        = UARTRxBuf.Rx_Buffer [ UARTRxBuf.read_pos ];
        UARTRxBuf.read_pos = (UARTRxBuf.read_pos + 1) % UART_RX_MAX_DEPTH;
    }

    return i;
}
void Recv_Byte1(void)
{
    int      i = 0;
    int      j = 0;
    uint32_t      len;
    readNum1 = Protocol_UartRead1(mDataBufPtr1 + mDataBufLen1, 1024 - mDataBufLen1);
    // if (readNum1 > 0)
    // {
    // BarCodeDataGet();
    // }
    if (readNum1 > 0)
    {
        mDataBufLen1 += readNum1;

        while(mDataBufLen1)
        {
            memset(BarCode1, 0, sizeof(BarCode1));
            for(i = 0; i < mDataBufLen1; i++)
            {
                    // if((mDataBufPtr1[i] == 0x0 ) && (mDataBufPtr1[i - 1] == 0x0))
                    // {
                        // if( i < 1)
                        // {
                        //     break;
                        // }
                        // memset(BarCode1, 0, sizeof(BarCode1));
                        
                        for(j = 0; j < mDataBufLen1; j++)
                        {
                            BarCode1[j] = mDataBufPtr1[j];
                        }
                        
                    
                    // }
                
                
            }

            // 解析协议
            len = mDataBufLen1;
            if ( (len > 0) && (len < mDataBufLen1) )
            {
                // 将未解析的数据移到头部
                // Move unparsed data to the head
                
                memcpy(mDataBufPtr1, mDataBufPtr1 + len, mDataBufLen1 - len);
                
                // memcpy(nowdata,mDataBufPtr + len,len);
                // datacheck();
            }
            
            mDataBufLen1 -= len;
            
        }
        BarCodeDataGet();
    }
    
    
}

static uint32_t Protocol_UartRead1(uint8_t *pData, uint32_t len)
{
    uint32_t i       = 0;
    uint32_t DataLen = 0u;
    uint32_t ReadLen = 0u;

    if ( UARTRxBuf1.write_pos == UARTRxBuf1.read_pos )
    {
        return 0;    //队列空
    }

    if ( UARTRxBuf1.write_pos > UARTRxBuf1.read_pos )
    {
        DataLen = UARTRxBuf1.write_pos - UARTRxBuf1.read_pos;
    }
    else
    {
        DataLen = UART_RX_MAX_DEPTH - (UARTRxBuf1.read_pos - UARTRxBuf1.write_pos);
    }

    if ( len > DataLen )
    {
        ReadLen = DataLen;
    }
    else
    {
        ReadLen = len;
    }

    for ( i = 0u; i < ReadLen; i++ )
    {
        pData [ i ]        = UARTRxBuf1.Rx_Buffer [ UARTRxBuf1.read_pos ];
        UARTRxBuf1.read_pos = (UARTRxBuf1.read_pos + 1) % UART_RX_MAX_DEPTH;
    }

    return i;
}


void Recv_Byte2(void)
{
    int      i = 0;
    int      j = 0;
    uint32_t      len;
    readNum1 = Protocol_UartRead2(mDataBufPtr1 + mDataBufLen1, 1024 - mDataBufLen1);
    // if (readNum1 > 0)
    // {
    // BarCodeDataGet();
    // }
    if (readNum1 > 0)
    {
        mDataBufLen1 += readNum1;

        while(mDataBufLen1)
        {
            memset(BarCode1, 0, sizeof(BarCode1));
            for(i = 0; i < mDataBufLen1; i++)
            {
                    // if((mDataBufPtr1[i] == 0x0 ) && (mDataBufPtr1[i - 1] == 0x0))
                    // {
                        // if( i < 1)
                        // {
                        //     break;
                        // }
                        // memset(BarCode1, 0, sizeof(BarCode1));
                        
                        for(j = 0; j < mDataBufLen1; j++)
                        {
                            BarCode1[j] = mDataBufPtr1[j];
                        }
                        
                    
                    // }
                
                
            }

            // 解析协议
            len = mDataBufLen1;
            if ( (len > 0) && (len < mDataBufLen1) )
            {
                // 将未解析的数据移到头部
                // Move unparsed data to the head
                
                memcpy(mDataBufPtr1, mDataBufPtr1 + len, mDataBufLen1 - len);
                
                // memcpy(nowdata,mDataBufPtr + len,len);
                // datacheck();
            }
            
            mDataBufLen1 -= len;
            
        }
        BarCodeDataGet();
    }
    
    
}

static uint32_t Protocol_UartRead2(uint8_t *pData, uint32_t len)
{
    uint32_t i       = 0;
    uint32_t DataLen = 0u;
    uint32_t ReadLen = 0u;

    if ( UARTRxBuf1.write_pos == UARTRxBuf1.read_pos )
    {
        return 0;    //队列空
    }

    if ( UARTRxBuf1.write_pos > UARTRxBuf1.read_pos )
    {
        DataLen = UARTRxBuf1.write_pos - UARTRxBuf1.read_pos;
    }
    else
    {
        DataLen = UART_RX_MAX_DEPTH - (UARTRxBuf1.read_pos - UARTRxBuf1.write_pos);
    }

    if ( len > DataLen )
    {
        ReadLen = DataLen;
    }
    else
    {
        ReadLen = len;
    }

    for ( i = 0u; i < ReadLen; i++ )
    {
        pData [ i ]        = UARTRxBuf1.Rx_Buffer [ UARTRxBuf1.read_pos ];
        UARTRxBuf1.read_pos = (UARTRxBuf1.read_pos + 1) % UART_RX_MAX_DEPTH;
    }

    return i;
}
