#include "api_RS485.h"
#include "R485_Communication_Matrix.h"
#include "string.h"
#define R485_BUF_SIZE (1024 * 4 )
#define R485_UART_PORT (1)
#define R485_TX_OUT_MCU R485_TX
#define R485_RX_IN_MCU R485_RX
#define R485_DATA_PACKAGE_MIN_LEN 0x07 /* 帧头 2 ID 1 数据长度 1 校验和 1 帧尾 2*/
#define R485_DATA_LEN 0x40
static void RS485_Receive_Data_Analysis(void);
static void R485_TX_Init(void);
static void R485_RX_Init(void);
static RS485DataPacket stRS485DataRx;
static RS485ValidDataPacket_st_t stRS485RxVldData[RS485_Rx_ID_Idx_Max];
static uint32_t u32RS485RxDataBegin = 0;
static uint32_t u32RS485RxDataRe = 0;
static uint32_t u32RS485RxDataValidLenTem = 0;
static uint32_t u32RS485DataBufLen = 0;
static uint8_t RS485DataBuf[RS485_RX_BUF_LEN];
static uint32_t u32RS485RxDataValidLen = 0;
static uint8_t RS485ValidData[RS485_RX_DATA_LEN];
static uint8_t u8RS485RecVldID[RS485_Rx_ID_Idx_Max];
uint32_t RS485_send_time = 0;
uint32_t RS485_send_num = 0;
uint8_t RS485_TX_finish = 0;
// static RS485_Tx_Data_Ctrl_st_t stRS485TxData[RS485_Tx_ID_Idx_Max];
_ID0X40h_Data R485_ID40h;
_ID0X48h_Data R485_ID48h;
_ID0X41h_Data R485_ID41h;
_ID0X49h_Data R485_ID49h;
_ID0X42h_Data R485_ID42h;
_ID0X4Ah_Data R485_ID4Ah;
_ID0X4Dh_Data R485_ID4Dh;
LineSta       LineGetSta;

void R485_TX_Init(void)
{

}

void R485_RX_Init(void)
{
    // for (uint8_t i = 0; i < RS485_Rx_ID_Idx_Max; i++)
    // {
    //     stRS485RxVldData[i].u16LostTime = 0;
    //     stRS485RxVldData[i].u8Status = R485_Lost;
    //     stRS485RxVldData[i].u8Received = 0;
    //     stRS485RxVldData[i].u8ReceivedFlag = 0;
    //     memset(stRS485RxVldData[i].u8RecVal, 0, RS485_RX_DATA_LEN);
    // }
}
void bsp_R485_Init(void)
{

    // uart_config_t uart_config = {
    //     .baud_rate = 115200,
    //     .data_bits = UART_DATA_8_BITS,
    //     .parity = UART_PARITY_DISABLE,
    //     .stop_bits = UART_STOP_BITS_1,
    //     .flow_ctrl = UART_HW_FLOWCTRL_DISABLE,
    //     .source_clk = UART_SCLK_DEFAULT,
    // };
    // /* Install UART driver  */
    // uart_driver_install(R485_UART_PORT, R485_BUF_SIZE, R485_BUF_SIZE, 0, NULL, 0);   /* port rxbuff txbuff evetnqueue queuesize iarmflag */
    // uart_param_config(R485_UART_PORT, &uart_config);    /* port uartconfig */
    // ESP_ERROR_CHECK(uart_set_pin(R485_UART_PORT, R485_TX_OUT_MCU, R485_RX_IN_MCU, UART_PIN_NO_CHANGE, UART_PIN_NO_CHANGE)); /* port tx rx rts cts */
    // ESP_ERROR_CHECK(uart_set_mode(R485_UART_PORT, UART_MODE_RS485_HALF_DUPLEX));
    // R485_TX_Init();
    // R485_RX_Init();
    // ESP_LOGI("485", "Init");
}

void Uart_Uninstall(void)
{
    // uart_driver_delete(R485_UART_PORT);
}



uint8_t Yadi_CAL_Data_Sum(uint8_t* pu8LinData, uint16_t u8LinLen)
{
    uint8_t u8LinSum = 0U;
    uint16_t i = 0;

    for (i = 0; i < u8LinLen; i++)
    {
        u8LinSum = (uint8_t)(u8LinSum + pu8LinData[i]);
    }

    return u8LinSum;
}

static const uint16_t crc16_table[256]={
    0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50A5, 0x60C6, 0x70E7,
    0x8108, 0x9129, 0xA14A, 0xB16B, 0xC18C, 0xD1AD, 0xE1CE, 0xF1EF,
    0x1231, 0x0210, 0x3273, 0x2252, 0x52B5, 0x4294, 0x72F7, 0x62D6,
    0x9339, 0x8318, 0xB37B, 0xA35A, 0xD3BD, 0xC39C, 0xF3FF, 0xE3DE,
    0x2462, 0x3443, 0x0420, 0x1401, 0x64E6, 0x74C7, 0x44A4, 0x5485,
    0xA56A, 0xB54B, 0x8528, 0x9509, 0xE5EE, 0xF5CF, 0xC5AC, 0xD58D,
    0x3653, 0x2672, 0x1611, 0x0630, 0x76D7, 0x66F6, 0x5695, 0x46B4,
    0xB75B, 0xA77A, 0x9719, 0x8738, 0xF7DF, 0xE7FE, 0xD79D, 0xC7BC,
    0x48C4, 0x58E5, 0x6886, 0x78A7, 0x0840, 0x1861, 0x2802, 0x3823,
    0xC9CC, 0xD9ED, 0xE98E, 0xF9AF, 0x8948, 0x9969, 0xA90A, 0xB92B,
    0x5AF5, 0x4AD4, 0x7AB7, 0x6A96, 0x1A71, 0x0A50, 0x3A33, 0x2A12,
    0xDBFD, 0xCBDC, 0xFBBF, 0xEB9E, 0x9B79, 0x8B58, 0xBB3B, 0xAB1A,
    0x6CA6, 0x7C87, 0x4CE4, 0x5CC5, 0x2C22, 0x3C03, 0x0C60, 0x1C41,
    0xEDAE, 0xFD8F, 0xCDEC, 0xDDCD, 0xAD2A, 0xBD0B, 0x8D68, 0x9D49,
    0x7E97, 0x6EB6, 0x5ED5, 0x4EF4, 0x3E13, 0x2E32, 0x1E51, 0x0E70,
    0xFF9F, 0xEFBE, 0xDFDD, 0xCFFC, 0xBF1B, 0xAF3A, 0x9F59, 0x8F78,
    0x9188, 0x81A9, 0xB1CA, 0xA1EB, 0xD10C, 0xC12D, 0xF14E, 0xE16F,
    0x1080, 0x00A1, 0x30C2, 0x20E3, 0x5004, 0x4025, 0x7046, 0x6067,
    0x83B9, 0x9398, 0xA3FB, 0xB3DA, 0xC33D, 0xD31C, 0xE37F, 0xF35E,
    0x02B1, 0x1290, 0x22F3, 0x32D2, 0x4235, 0x5214, 0x6277, 0x7256,
    0xB5EA, 0xA5CB, 0x95A8, 0x8589, 0xF56E, 0xE54F, 0xD52C, 0xC50D,
    0x34E2, 0x24C3, 0x14A0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
    0xA7DB, 0xB7FA, 0x8799, 0x97B8, 0xE75F, 0xF77E, 0xC71D, 0xD73C,
    0x26D3, 0x36F2, 0x0691, 0x16B0, 0x6657, 0x7676, 0x4615, 0x5634,
    0xD94C, 0xC96D, 0xF90E, 0xE92F, 0x99C8, 0x89E9, 0xB98A, 0xA9AB,
    0x5844, 0x4865, 0x7806, 0x6827, 0x18C0, 0x08E1, 0x3882, 0x28A3,
    0xCB7D, 0xDB5C, 0xEB3F, 0xFB1E, 0x8BF9, 0x9BD8, 0xABBB, 0xBB9A,
    0x4A75, 0x5A54, 0x6A37, 0x7A16, 0x0AF1, 0x1AD0, 0x2AB3, 0x3A92,
    0xFD2E, 0xED0F, 0xDD6C, 0xCD4D, 0xBDAA, 0xAD8B, 0x9DE8, 0x8DC9,
    0x7C26, 0x6C07, 0x5C64, 0x4C45, 0x3CA2, 0x2C83, 0x1CE0, 0x0CC1,
    0xEF1F, 0xFF3E, 0xCF5D, 0xDF7C, 0xAF9B, 0xBFBA, 0x8FD9, 0x9FF8,
    0x6E17, 0x7E36, 0x4E55, 0x5E74, 0x2E93, 0x3EB2, 0x0ED1, 0x1EF0
};

uint16_t RS485_CRC16_Calc(const uint8_t *in_data,uint32_t len)
{
	uint16_t crc = 0x5555;
   
    for (uint32_t i = 0; i < len; i++) 
	{
        crc = (crc << 8) ^ crc16_table[((crc >> 8) ^ in_data[i]) & 0x00ff];
    }

    return crc;
}


void R485_RX_task(void* pvParameters)
{
//    int rxBytes = uart_read_bytes(R485_UART_PORT, &RxDataBuf[0], 1, portMAX_DELAY);
//    if (rxBytes > 0)
//    {
//        size_t rxBytes1 = 0;
//        int rxBytes2 = 0;
//        uint32_t i = 0;
//        uint32_t j = 0;
//        uart_get_buffered_data_len(R485_UART_PORT, &rxBytes1);
//        rxBytes2 = 0;
//        if (rxBytes1 > 0)
//        {
//            rxBytes2 = uart_read_bytes(R485_UART_PORT, &RxDataBuf[rxBytes], rxBytes1, 0);
       
//        rxBytes2 += rxBytes;
//        uds_uart_rx_write(RxDataBuf, rxBytes2);
//        stRS485DataRx.length = rxBytes2;
//        memcpy(stRS485DataRx.RS485Data, RxDataBuf, rxBytes2);
//        RS485_Receive_Data_Analysis();
//         }
//    }
}



static void RS485_Receive_Data_Analysis(void)
{
    // if ((u32RS485DataBufLen + stRS485DataRx.length) >= RS485_RX_BUF_LEN)
    // {
    //     u32RS485DataBufLen = 0;
    //     RS485DataBuf[0] = 0;
    // }
    // else
    // {
    //     memcpy(&RS485DataBuf[u32RS485DataBufLen], stRS485DataRx.RS485Data, stRS485DataRx.length);
    //     u32RS485DataBufLen += stRS485DataRx.length;
    // }

    // if (u32RS485DataBufLen > 4)
    // {
    //     u32RS485RxDataBegin = 0;
    //     while (u32RS485RxDataBegin < (u32RS485DataBufLen - 4))
    //     {
    //         if ((RS485DataBuf[0 + u32RS485RxDataBegin] != 'Y') ||
    //             (RS485DataBuf[1 + u32RS485RxDataBegin] != 'D') ||
    //             ((RS485DataBuf[2 + u32RS485RxDataBegin] != RS485_RECEIVE_ID_0X40) &&
    //                 (RS485DataBuf[2 + u32RS485RxDataBegin] != RS485_RECEIVE_ID_0X41) &&
    //                 (RS485DataBuf[2 + u32RS485RxDataBegin] != RS485_RECEIVE_ID_0X42) &&
    //                 (RS485DataBuf[2 + u32RS485RxDataBegin] != RS485_RECEIVE_ID_0X45) &&
    //                 (RS485DataBuf[2 + u32RS485RxDataBegin] != OTA_MODE_RX_ID)))
    //         {
    //             u32RS485RxDataBegin++;
    //             continue;
    //         }

    //         u32RS485RxDataValidLenTem = RS485DataBuf[3 + u32RS485RxDataBegin];
    //         if (u32RS485RxDataValidLenTem != RS485_RX_DATA_LEN)
    //         {
    //             if (RS485DataBuf[2 + u32RS485RxDataBegin] != OTA_MODE_RX_ID)
    //             {
    //                 u32RS485RxDataBegin++;
    //                 continue;
    //             }
    //         }

    //         u32RS485RxDataRe = u32RS485DataBufLen - u32RS485RxDataBegin;
    //         if (u32RS485RxDataRe >= (u32RS485RxDataValidLenTem + 5))
    //         {
    //             uint8_t u8YadiDataSum = 0;
    //             u8YadiDataSum = Yadi_CAL_Data_Sum(&RS485DataBuf[2 + u32RS485RxDataBegin], (u32RS485RxDataValidLenTem + 2));
    //             if (u8YadiDataSum != RS485DataBuf[u32RS485RxDataValidLenTem + 4 + u32RS485RxDataBegin])
    //             {
    //                 u32RS485RxDataBegin++;
    //                 continue;
    //             }
    //         }
    //         else
    //         {
    //             break;
    //         }
    //         u32RS485RxDataRe = u32RS485DataBufLen - u32RS485RxDataBegin;
    //         if (u32RS485RxDataRe >= (u32RS485RxDataValidLenTem + 7))
    //         {
    //             if ((RS485DataBuf[u32RS485RxDataValidLenTem + 5 + u32RS485RxDataBegin] != 0x4B) ||
    //                 (RS485DataBuf[u32RS485RxDataValidLenTem + 6 + u32RS485RxDataBegin] != 0x4A))
    //             {
    //                 u32RS485RxDataBegin++;
    //                 continue;
    //             }
    //             else
    //             {
    //                 switch (RS485DataBuf[2 + u32RS485RxDataBegin])
    //                 {
    //                     case RS485_RECEIVE_ID_0X40:
    //                         {
    //                             if (stRS485RxVldData[RS485_Rx_ID40_Idx].u8Received == 0)
    //                             {
    //                                 memcpy(stRS485RxVldData[RS485_Rx_ID40_Idx].u8RecVal, &RS485DataBuf[4 + u32RS485RxDataBegin], u32RS485RxDataValidLenTem);
    //                                 stRS485RxVldData[RS485_Rx_ID40_Idx].u8Received = 1;

    //                                 stRS485TxData[RS485_Tx_ID48_Idx].u8TxTime = 10; //ms
    //                                 stRS485TxData[RS485_Tx_ID48_Idx].u8TxEnable = 1;
    //                             }
    //                             break;
    //                         }
    //                     case RS485_RECEIVE_ID_0X41:
    //                         {
    //                             if (stRS485RxVldData[RS485_Rx_ID41_Idx].u8Received == 0)
    //                             {
    //                                 memcpy(stRS485RxVldData[RS485_Rx_ID41_Idx].u8RecVal, &RS485DataBuf[4 + u32RS485RxDataBegin], u32RS485RxDataValidLenTem);
    //                                 stRS485RxVldData[RS485_Rx_ID41_Idx].u8Received = 1;

    //                                 stRS485TxData[RS485_Tx_ID49_Idx].u8TxTime = 10; //ms
    //                                 stRS485TxData[RS485_Tx_ID49_Idx].u8TxEnable = 1;
    //                             }
    //                             break;
    //                         }
    //                     case RS485_RECEIVE_ID_0X42:
    //                         {
    //                             if (stRS485RxVldData[RS485_Rx_ID42_Idx].u8Received == 0)
    //                             {
    //                                 memcpy(stRS485RxVldData[RS485_Rx_ID42_Idx].u8RecVal, &RS485DataBuf[4 + u32RS485RxDataBegin], u32RS485RxDataValidLenTem);
    //                                 stRS485RxVldData[RS485_Rx_ID42_Idx].u8Received = 1;

    //                                 stRS485TxData[RS485_Tx_ID4A_Idx].u8TxTime = 10; //ms
    //                                 stRS485TxData[RS485_Tx_ID4A_Idx].u8TxEnable = 1;
    //                             }
    //                             break;
    //                         }
    //                     case RS485_RECEIVE_ID_0X45:
    //                         {
    //                             {
    //                                 stRS485RxVldData[RS485_Rx_ID45_Idx].u8Received = 1;

    //                                 stRS485TxData[RS485_Tx_ID4D_Idx].u8TxTime = 10; //ms
    //                                 stRS485TxData[RS485_Tx_ID4D_Idx].u8TxEnable = 1;
    //                             }
    //                             break;
    //                         }

    //                     case OTA_MODE_RX_ID:
    //                         ota_message_init(&stRS485DataRx.RS485Data[4], u32RS485RxDataValidLenTem);
    //                         break;

    //                     default:
    //                         {
    //                             break;
    //                         }
    //                 }

    //                 u32RS485RxDataValidLen = u32RS485RxDataValidLenTem;
    //                 u32RS485RxDataBegin += (u32RS485RxDataValidLenTem + 7);


    //                 continue;
    //             }
    //         }
    //         else
    //         {
    //             break;
    //         }
    //     }

    //     if (u32RS485RxDataBegin > 0)
    //     {
    //         memcpy(RS485DataBuf, &RS485DataBuf[u32RS485RxDataBegin], (u32RS485DataBufLen - u32RS485RxDataBegin));
    //         u32RS485DataBufLen -= u32RS485RxDataBegin;
    //     }
    // }
}


uint32_t R485_Send(const uint16_t cmdID, const uint8_t* pData, uint8_t len)
{
    uint8_t dataBuf[128];
    int i = 0;
    uint16_t checksum = 0;
    uint32_t frameLen;
    // if (len + R485_DATA_PACKAGE_MIN_LEN > 71)
    // {
    //     return 0;
    // }

    // if (len != 64)
    // {
    //     return 0;
    // }

    dataBuf[0] = 0x59; /* 帧头 */
    dataBuf[1] = 0x44;
    dataBuf[2] = cmdID;         /* ID */
    // dataBuf[3] = R485_DATA_LEN; /* 长度 固定64Byte */
    dataBuf[3] = len;
    frameLen = 4;
    // 数据 Data
    for (i = 0; i < len; ++i)
    {
        dataBuf[frameLen] = pData[i];
        frameLen++;
    }

    // checksum = Yadi_CAL_Data_Sum(&dataBuf[2], R485_DATA_LEN + 2);
    checksum = Yadi_CAL_Data_Sum(&dataBuf[2], len + 2);
    // checksum = 0;
    dataBuf[frameLen] = checksum;
    frameLen++;
    dataBuf[frameLen] = 0X4B;
    frameLen++;
    dataBuf[frameLen] = 0X4A;
    frameLen++;
    // if (frameLen != 71)
    // {
    //     return 0;
    // }
    uint8_t sendresult = 0;
    sendresult = UART_Ch0_Send_Multiple_Byte(dataBuf,frameLen);
    RS485_TX_finish = 1;
    // while(1)
    // {
       if(sendresult == 0)
       {

            return sendresult;
       }
       else
       {
        sendresult = UART_Ch0_Send_Multiple_Byte(dataBuf,frameLen);
       }
        return sendresult;
    // }
    
}

uint32_t R485_AIMA_Send(void)
{
    uint8_t dataBuf[] = {
        0xEF, 0xDD, 0x8D, 0x05, 0x80, 0x13, 0x01, 0x00, 0x00, 0xA0,
        0x00, 0x24, 0xFF, 0x30, 0x03, 0xE8, 0x03, 0x00, 0x00, 0xFF,
        0x55, 0x03, 0x40, 0x81, 0x00, 0x90, 0x9D, 0xEE  
    };
    uint8_t sendresult = 0;
    sendresult = UART_Ch0_Send_Multiple_Byte(dataBuf,28);
    RS485_TX_finish = 1;
    // while(1)
    // {
       if(sendresult == 0)
       {

            return sendresult;
       }
       else
       {
        sendresult = UART_Ch0_Send_Multiple_Byte(dataBuf,28);
       }
        return sendresult;
    // }
    
}



uint8_t sendmsgAll[8];
uint32_t sendnum = 1;
void RS485_User_Tx_Data(void)
{


#if (0)
            uint8_t flag = 0;
            uint32_t sendfinishflag = 0;
            // if(firstflag = 0)
            // {
                memcpy(lastdata,nowdata,4);
            // }
            // m
            sendmsgAll[0] =  (uint8_t)sendnum & 0xFF;
            sendmsgAll[1] =  ((uint8_t)(sendnum >>8)) & 0xFF;
            sendmsgAll[2] =  ((uint8_t)(sendnum >>16)) & 0xFF;
            sendmsgAll[3] =  ((uint8_t)(sendnum >>24)) & 0xFF;

            sendmsgAll[4] =  ((uint8_t)(sendnum)) & 0xFF;
            sendmsgAll[5] =  ((uint8_t)(sendnum >>8)) & 0xFF;
            sendmsgAll[6] =  ((uint8_t)(sendnum >>16)) & 0xFF;
            sendmsgAll[7] =  ((uint8_t)(sendnum >>24)) & 0xFF;
            
            if(RS485_TX_finish == 0)
            {
                    // LINE_OUT_NEG_09 = 1;
                    switch (RS485_send_num)
                    {
                        case RS485_Tx_ID48_Idx:
                            
                            sendfinishflag = R485_Send(0x70, sendmsgAll, 8);
                            RS485_TX_finish = 1;
                            if(sendfinishflag == 0)
                            {
                                
                                if(RS485_TX_finish == 1)
                                {
                                    // RS485_send_num++;
                                    // lastdata[0] =  (uint8_t)sendnum & 0xFF;
                                    // lastdata[1] =  ((uint8_t)(sendnum >>8)) & 0xFF;
                                    // lastdata[2] =  ((uint8_t)(sendnum >>16)) & 0xFF;
                                    // lastdata[3] =  ((uint8_t)(sendnum >>24)) & 0xFF;
                                    nowdata[0] =  (uint8_t)sendnum & 0xFF;
                                    nowdata[1] =  ((uint8_t)(sendnum >>8)) & 0xFF;
                                    nowdata[2] =  ((uint8_t)(sendnum >>16)) & 0xFF;
                                    nowdata[3] =  ((uint8_t)(sendnum >>24)) & 0xFF;
                                    sendnum++;
                                    
                                }
                                
                            }
                            break;
                        case RS485_Tx_ID49_Idx:
                        
                            sendfinishflag = R485_Send(0x71, sendmsgAll, 8);
                            RS485_TX_finish = 1;
                            if(sendfinishflag == 0)
                            {
                                
                                if(RS485_TX_finish == 1)
                                {
                                    // sendnum++;
                                    RS485_send_num ++;
                                }
                                
                            }
                            // uart_wait_tx_done(R485_UART_PORT, 100);
                            break;
                        case RS485_Tx_ID4A_Idx:
                            sendfinishflag = R485_Send(0x72, sendmsgAll, sizeof(sendmsgAll));
                            RS485_TX_finish = 1;
                            if(sendfinishflag == 0)
                            {
                                RS485_TX_finish = 1;
                                if(RS485_TX_finish == 1)
                                {
                                    RS485_send_num++;
                                }
                            }
                            break;
                        case 3:
                            sendfinishflag = R485_Send(0x73, sendmsgAll, sizeof(sendmsgAll));
                            RS485_TX_finish = 1;
                            if(sendfinishflag == 0)
                            {
                                RS485_TX_finish = 1;
                                if(RS485_TX_finish == 1)
                                {
                                    RS485_send_num++;
                                }
                            }
                            break;
                            case 4:
                            sendfinishflag = R485_Send(0x74, sendmsgAll, sizeof(sendmsgAll));
                            RS485_TX_finish = 1;
                            if(sendfinishflag == 0)
                            {
                                RS485_TX_finish = 1;
                                if(RS485_TX_finish == 1)
                                {
                                    RS485_send_num++;
                                }
                            }
                            break;
                        default:
                        // sendnum++;
                            RS485_send_num = 0;
                            break;
                    RS485_TX_finish = 1; 
                     }

            }
            
#endif
#if(1)
            uint8_t flag = 0;
            uint32_t sendfinishflag = 0;

                // if(RS485_send_time > 3000)
                // {
                    switch (RS485_send_num)
                    {
                        case RS485_Tx_ID48_Idx:
                        
                            sendfinishflag = R485_Send_test(); 
                            RS485_TX_finish = 1;
                            if(sendfinishflag == 0)
                            {
                                if(RS485_TX_finish == 1)
                                {
                                    // sendnum++;
                                    RS485_send_time = 0;
                                    // RS485_send_num ++;
                                }

                            }
                            break;
                        default:
                            flag = 1;
                            RS485_send_time = 0;
                            RS485_send_num = 0;
                            break;
                     }
                
            

#endif
}
void backsend(void)
{
    if(RS485_send_time>=10)
    {
        RS485_send_time = 0;
        RS485_TX_finish = 0;
        sendnum--;
        RS485_send_num--;
    }
}
/**
 * @brief R485状态计时函数
 */
void R485_Timer_Handel(void)
{
    // for (uint8_t i = 0; i < RS485_Rx_ID_Idx_Max; i++)
    // {
    //     if (stRS485RxVldData[i].u8Status != R485_Lost)
    //     {
    //         if (stRS485RxVldData[i].u16LostTime <= R485_LOST_TIEMR_VAL)
    //         {
    //             stRS485RxVldData[i].u16LostTime++;
    //         }
    //         else
    //         {
    //             stRS485RxVldData[i].u8Status = R485_Lost;
    //             memset(stRS485RxVldData[i].u8RecVal, 0, RS485_RX_DATA_LEN);
    //             switch (i)
    //             {
    //                 case RS485_Rx_ID40_Idx:
    //                     memset(R485_ID40h.Msg, 0, RS485_RX_DATA_LEN);
    //                     break;
    //                 case RS485_Rx_ID41_Idx:
    //                     memset(R485_ID41h.Msg, 0, RS485_RX_DATA_LEN);
    //                     break;
    //                 case RS485_Rx_ID42_Idx:
    //                     memset(R485_ID42h.Msg, 0, RS485_RX_DATA_LEN);
    //                     break;
    //                 default:
    //                     break;
    //             }
    //         }
    //     }
    // }
}




