#ifndef UART_H__
#define UART_H__
/*-----------------use for RH850_F1KM_S1 --------------------*/
//#include "dr7f701684.dvf.h"
#include "r_typedefs.h"
#include "Barcode_Scanner.h"
#define UART_VERSION   0X20 
/***************************************************************/
/***************************************************************/
/**根据实际应用调整buf大小**/
#define UART_30_SEND_MAX 512UL
#define UART_31_SEND_MAX 512UL
#define UART_32_SEND_MAX 1UL
#define UART_33_SEND_MAX 1UL

/***************************************************************/
typedef enum
{
    MODE_NONE = 0U,
    MODE_LIN_MASTER,
    MODE_LIN_SLAVE,
    MODE_UART,
    MODE_MAX,
} UART_LIN_Mode_en_t;

typedef enum
{
    UART_LSB = 0U,
    UART_MSB,

} UART_Order_en_t;

typedef enum
{
    UART_PARITY_DISABLE = 0U,
    UART_PARITY_EVEN,
    UART_PARITY_0,
    UART_PARITY_ODD,

} UART_Parity_en_t;

typedef enum
{
    UART_POLARITY_NORMAL = 0U,
    UART_POLARITY_IN_INVERT,
    UART_POLARITY_OUT_INVERT,
    UART_POLARITY_IN_OUT_INVERT,

} UART_Polarity_en_t;

typedef enum
{
    UART_RLIN30 = 0U,
    UART_RLIN31,
    UART_RLIN32,
    UART_RLIN33,
    UART_RLIN_MAX,
} UART_Channel_en_t;

typedef void (*UART_Confirm)(void);
typedef void (*UART_Read_Msg)(uint16_t u16UARTData);
typedef void (*UART_Error_Handle)(uint8_t u8ErrorFlag);

typedef struct
{
    uint32_t u32UARTbps;                /*通道实际波特率*/
    UART_LIN_Mode_en_t enUARTLINMode;   /*通道模式*/
    UART_Order_en_t enUARTOrder;        /*Valid only in UART mode*/
    UART_Parity_en_t en2UARTParity;     /*Valid only in UART mode*/
    UART_Polarity_en_t en2UARTPolarity; /*Valid only in UART mode*/
    UART_Confirm pfnUARTConfirmCallBack;
    UART_Read_Msg pfnUARTReadMsgCallBack;
    UART_Error_Handle pfnUARTErrHandleCallBack;

} UART_Channel_Config_st_t;

typedef struct
{
    uint8_t u8LINID;     /*要发送的ID*/
    uint8_t u8LINLen;    /*数据长度*/
    uint8_t *pu8LINData; /*数据指针*/

} LIN_Data_st_t;

/****************************************************************/

void UART_CH0_TX_ISR(void);
void UART_CH1_TX_ISR(void);
void UART_CH2_TX_ISR(void);
void UART_CH3_TX_ISR(void);
void UART_CH0_RX_ISR(void);
void UART_CH1_RX_ISR(void);
void UART_CH2_RX_ISR(void);
void UART_CH3_RX_ISR(void);
void UART_CH0_Err_ISR(void);
void UART_CH1_Err_ISR(void);
void UART_CH2_Err_ISR(void);
void UART_CH3_Err_ISR(void);

/*
0：idle
1：busy
*/
uint8_t UART_Ch0_Get_TX_Busy_Flag(void);
uint8_t UART_Ch1_Get_TX_Busy_Flag(void);
uint8_t UART_Ch2_Get_TX_Busy_Flag(void);
uint8_t UART_Ch3_Get_TX_Busy_Flag(void);

/*
Data：要发送数据的指针，
返回0 ：操作成功 。返回1：操作失败
*/
uint32_t UART_Ch0_Send_Multiple_Byte(uint8_t *Data, uint32_t Len);
uint32_t UART_Ch1_Send_Multiple_Byte(uint8_t *Data, uint32_t Len);
uint32_t UART_Ch2_Send_Multiple_Byte(uint8_t *Data, uint32_t Len);
uint32_t UART_Ch3_Send_Multiple_Byte(uint8_t *Data, uint32_t Len);

/* 返回设置成功的波特率，返回0xFFFFFFFF表示设置失败。*/
extern uint32_t UART_Init(UART_Channel_en_t enUARTCh, UART_Channel_Config_st_t *penUARTCfg);
/*休眠时调用*/
extern void UART_Sleep_Init(UART_Channel_en_t enUARTCh);
/* 返回设置成功的波特率，返回0xFFFFFFFF表示设置失败。*/
extern uint32_t UART_LIN_Init(UART_Channel_en_t enUARTCh, UART_Channel_Config_st_t *penUARTCfg);

/*
0：idle
1：busy
*/
extern uint8_t LIN_Ch0_Get_Busy_Flag(void);
extern uint8_t LIN_Ch1_Get_Busy_Flag(void);
extern uint8_t LIN_Ch2_Get_Busy_Flag(void);
extern uint8_t LIN_Ch3_Get_Busy_Flag(void);
/*返回0 ：操作成功 。返回1：操作失败*/
extern uint32_t LIN_Ch0_Send_Header_Send_Response(LIN_Data_st_t *pstLINData);
extern uint32_t LIN_Ch1_Send_Header_Send_Response(LIN_Data_st_t *pstLINData);
extern uint32_t LIN_Ch2_Send_Header_Send_Response(LIN_Data_st_t *pstLINData);
extern uint32_t LIN_Ch3_Send_Header_Send_Response(LIN_Data_st_t *pstLINData);
/*返回0 ：操作成功 。返回1：操作失败*/
extern uint32_t LIN_Ch0_Send_Header_Recieve_Response(LIN_Data_st_t *pstLINData);
extern uint32_t LIN_Ch1_Send_Header_Recieve_Response(LIN_Data_st_t *pstLINData);
extern uint32_t LIN_Ch2_Send_Header_Recieve_Response(LIN_Data_st_t *pstLINData);
extern uint32_t LIN_Ch3_Send_Header_Recieve_Response(LIN_Data_st_t *pstLINData);

#endif
