/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_TPU_H
#define __S6J3360_TPU_H

#include "s6j3360io_basetypes.h"

/* TPU0 base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define TPU0	stcTPU0
#else /* __IO_DEFINE */
#define TPU0	(*((volatile stc_tpu0_t*)0xB0408000))
#endif /* __IO_DEFINE */

/* UNLOCK */
#define TPU0_UNLOCK	(TPU0.unUNLOCK.u32Register)  /*@rg@*/
#define TPU0_UNLOCK_UNLOCK	TPU0_UNLOCK  /*@bfrg@*/

typedef union un_tpu0_unlock{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tpu0_unlock_t;

/* LST */
#define TPU0_LST	(TPU0.unLST.u32Register)  /*@rg@*/
#define TPU0_LST_LST	(TPU0.unLST.stcField.u1LST)  /*@bf@*/

typedef struct stc_tpu0_lst_field{
    uint_io32_t		u1LST:1;
    uint_io32_t		:31;
}stc_tpu0_lst_field_t;

typedef union un_tpu0_lst{
    uint_io32_t		u32Register;
    stc_tpu0_lst_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tpu0_lst_t;

/* CFG */
#define TPU0_CFG	(TPU0.unCFG.u32Register)  /*@rg@*/
#define TPU0_CFG_INTE	(TPU0.unCFG.stcField.u1INTE)  /*@bf@*/
#define TPU0_CFG_GLBPS	(TPU0.unCFG.stcField.u6GLBPS)  /*@bf@*/
#define TPU0_CFG_GLBPSE	(TPU0.unCFG.stcField.u1GLBPSE)  /*@bf@*/
#define TPU0_CFG_DBGE	(TPU0.unCFG.stcField.u1DBGE)  /*@bf@*/

typedef struct stc_tpu0_cfg_field{
    uint_io32_t		u1INTE:1;
    uint_io32_t		:15;
    uint_io32_t		u6GLBPS:6;
    uint_io32_t		:1;
    uint_io32_t		u1GLBPSE:1;
    uint_io32_t		u1DBGE:1;
    uint_io32_t		:7;
}stc_tpu0_cfg_field_t;

typedef union un_tpu0_cfg{
    uint_io32_t		u32Register;
    stc_tpu0_cfg_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tpu0_cfg_t;

/* TIR */
#define TPU0_TIR	(TPU0.unTIR.u32Register)  /*@rg@*/
#define TPU0_TIR_IR0	(TPU0.unTIR.stcField.u1IR0)  /*@bf@*/
#define TPU0_TIR_IR1	(TPU0.unTIR.stcField.u1IR1)  /*@bf@*/
#define TPU0_TIR_IR2	(TPU0.unTIR.stcField.u1IR2)  /*@bf@*/
#define TPU0_TIR_IR3	(TPU0.unTIR.stcField.u1IR3)  /*@bf@*/
#define TPU0_TIR_IR4	(TPU0.unTIR.stcField.u1IR4)  /*@bf@*/
#define TPU0_TIR_IR5	(TPU0.unTIR.stcField.u1IR5)  /*@bf@*/
#define TPU0_TIR_IR6	(TPU0.unTIR.stcField.u1IR6)  /*@bf@*/
#define TPU0_TIR_IR7	(TPU0.unTIR.stcField.u1IR7)  /*@bf@*/

typedef struct stc_tpu0_tir_field{
    uint_io32_t		u1IR0:1;
    uint_io32_t		u1IR1:1;
    uint_io32_t		u1IR2:1;
    uint_io32_t		u1IR3:1;
    uint_io32_t		u1IR4:1;
    uint_io32_t		u1IR5:1;
    uint_io32_t		u1IR6:1;
    uint_io32_t		u1IR7:1;
    uint_io32_t		:24;
}stc_tpu0_tir_field_t;

typedef union un_tpu0_tir{
    uint_io32_t		u32Register;
    stc_tpu0_tir_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tpu0_tir_t;

/* TST */
#define TPU0_TST	(TPU0.unTST.u32Register)  /*@rg@*/
#define TPU0_TST_ST0	(TPU0.unTST.stcField.u1ST0)  /*@bf@*/
#define TPU0_TST_ST1	(TPU0.unTST.stcField.u1ST1)  /*@bf@*/
#define TPU0_TST_ST2	(TPU0.unTST.stcField.u1ST2)  /*@bf@*/
#define TPU0_TST_ST3	(TPU0.unTST.stcField.u1ST3)  /*@bf@*/
#define TPU0_TST_ST4	(TPU0.unTST.stcField.u1ST4)  /*@bf@*/
#define TPU0_TST_ST5	(TPU0.unTST.stcField.u1ST5)  /*@bf@*/
#define TPU0_TST_ST6	(TPU0.unTST.stcField.u1ST6)  /*@bf@*/
#define TPU0_TST_ST7	(TPU0.unTST.stcField.u1ST7)  /*@bf@*/

typedef struct stc_tpu0_tst_field{
    uint_io32_t		u1ST0:1;
    uint_io32_t		u1ST1:1;
    uint_io32_t		u1ST2:1;
    uint_io32_t		u1ST3:1;
    uint_io32_t		u1ST4:1;
    uint_io32_t		u1ST5:1;
    uint_io32_t		u1ST6:1;
    uint_io32_t		u1ST7:1;
    uint_io32_t		:24;
}stc_tpu0_tst_field_t;

typedef union un_tpu0_tst{
    uint_io32_t		u32Register;
    stc_tpu0_tst_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tpu0_tst_t;

/* TIE */
#define TPU0_TIE	(TPU0.unTIE.u32Register)  /*@rg@*/
#define TPU0_TIE_IE0	(TPU0.unTIE.stcField.u1IE0)  /*@bf@*/
#define TPU0_TIE_IE1	(TPU0.unTIE.stcField.u1IE1)  /*@bf@*/
#define TPU0_TIE_IE2	(TPU0.unTIE.stcField.u1IE2)  /*@bf@*/
#define TPU0_TIE_IE3	(TPU0.unTIE.stcField.u1IE3)  /*@bf@*/
#define TPU0_TIE_IE4	(TPU0.unTIE.stcField.u1IE4)  /*@bf@*/
#define TPU0_TIE_IE5	(TPU0.unTIE.stcField.u1IE5)  /*@bf@*/
#define TPU0_TIE_IE6	(TPU0.unTIE.stcField.u1IE6)  /*@bf@*/
#define TPU0_TIE_IE7	(TPU0.unTIE.stcField.u1IE7)  /*@bf@*/

typedef struct stc_tpu0_tie_field{
    uint_io32_t		u1IE0:1;
    uint_io32_t		u1IE1:1;
    uint_io32_t		u1IE2:1;
    uint_io32_t		u1IE3:1;
    uint_io32_t		u1IE4:1;
    uint_io32_t		u1IE5:1;
    uint_io32_t		u1IE6:1;
    uint_io32_t		u1IE7:1;
    uint_io32_t		:24;
}stc_tpu0_tie_field_t;

typedef union un_tpu0_tie{
    uint_io32_t		u32Register;
    stc_tpu0_tie_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tpu0_tie_t;

/* TCN0[0-7] */
#define TPU0_TCN00	(TPU0.unTCN00.u32Register)  /*@rg@*/
#define TPU0_TCN00_ECPL	(TPU0.unTCN00.stcField.u24ECPL)  /*@bf@*/
#define TPU0_TCN00_IRC	(TPU0.unTCN00.stcField.u1IRC)  /*@bf@*/
#define TPU0_TCN00_IEC	(TPU0.unTCN00.stcField.u1IEC)  /*@bf@*/
#define TPU0_TCN00_IES	(TPU0.unTCN00.stcField.u1IES)  /*@bf@*/
#define TPU0_TCN00_CONT	(TPU0.unTCN00.stcField.u1CONT)  /*@bf@*/
#define TPU0_TCN00_STOP	(TPU0.unTCN00.stcField.u1STOP)  /*@bf@*/
#define TPU0_TCN00_START	(TPU0.unTCN00.stcField.u1START)  /*@bf@*/

#define TPU0_TCN01	(TPU0.unTCN01.u32Register)  /*@rg@*/
#define TPU0_TCN01_ECPL	(TPU0.unTCN01.stcField.u24ECPL)  /*@bf@*/
#define TPU0_TCN01_IRC	(TPU0.unTCN01.stcField.u1IRC)  /*@bf@*/
#define TPU0_TCN01_IEC	(TPU0.unTCN01.stcField.u1IEC)  /*@bf@*/
#define TPU0_TCN01_IES	(TPU0.unTCN01.stcField.u1IES)  /*@bf@*/
#define TPU0_TCN01_CONT	(TPU0.unTCN01.stcField.u1CONT)  /*@bf@*/
#define TPU0_TCN01_STOP	(TPU0.unTCN01.stcField.u1STOP)  /*@bf@*/
#define TPU0_TCN01_START	(TPU0.unTCN01.stcField.u1START)  /*@bf@*/

#define TPU0_TCN02	(TPU0.unTCN02.u32Register)  /*@rg@*/
#define TPU0_TCN02_ECPL	(TPU0.unTCN02.stcField.u24ECPL)  /*@bf@*/
#define TPU0_TCN02_IRC	(TPU0.unTCN02.stcField.u1IRC)  /*@bf@*/
#define TPU0_TCN02_IEC	(TPU0.unTCN02.stcField.u1IEC)  /*@bf@*/
#define TPU0_TCN02_IES	(TPU0.unTCN02.stcField.u1IES)  /*@bf@*/
#define TPU0_TCN02_CONT	(TPU0.unTCN02.stcField.u1CONT)  /*@bf@*/
#define TPU0_TCN02_STOP	(TPU0.unTCN02.stcField.u1STOP)  /*@bf@*/
#define TPU0_TCN02_START	(TPU0.unTCN02.stcField.u1START)  /*@bf@*/

#define TPU0_TCN03	(TPU0.unTCN03.u32Register)  /*@rg@*/
#define TPU0_TCN03_ECPL	(TPU0.unTCN03.stcField.u24ECPL)  /*@bf@*/
#define TPU0_TCN03_IRC	(TPU0.unTCN03.stcField.u1IRC)  /*@bf@*/
#define TPU0_TCN03_IEC	(TPU0.unTCN03.stcField.u1IEC)  /*@bf@*/
#define TPU0_TCN03_IES	(TPU0.unTCN03.stcField.u1IES)  /*@bf@*/
#define TPU0_TCN03_CONT	(TPU0.unTCN03.stcField.u1CONT)  /*@bf@*/
#define TPU0_TCN03_STOP	(TPU0.unTCN03.stcField.u1STOP)  /*@bf@*/
#define TPU0_TCN03_START	(TPU0.unTCN03.stcField.u1START)  /*@bf@*/

#define TPU0_TCN04	(TPU0.unTCN04.u32Register)  /*@rg@*/
#define TPU0_TCN04_ECPL	(TPU0.unTCN04.stcField.u24ECPL)  /*@bf@*/
#define TPU0_TCN04_IRC	(TPU0.unTCN04.stcField.u1IRC)  /*@bf@*/
#define TPU0_TCN04_IEC	(TPU0.unTCN04.stcField.u1IEC)  /*@bf@*/
#define TPU0_TCN04_IES	(TPU0.unTCN04.stcField.u1IES)  /*@bf@*/
#define TPU0_TCN04_CONT	(TPU0.unTCN04.stcField.u1CONT)  /*@bf@*/
#define TPU0_TCN04_STOP	(TPU0.unTCN04.stcField.u1STOP)  /*@bf@*/
#define TPU0_TCN04_START	(TPU0.unTCN04.stcField.u1START)  /*@bf@*/

#define TPU0_TCN05	(TPU0.unTCN05.u32Register)  /*@rg@*/
#define TPU0_TCN05_ECPL	(TPU0.unTCN05.stcField.u24ECPL)  /*@bf@*/
#define TPU0_TCN05_IRC	(TPU0.unTCN05.stcField.u1IRC)  /*@bf@*/
#define TPU0_TCN05_IEC	(TPU0.unTCN05.stcField.u1IEC)  /*@bf@*/
#define TPU0_TCN05_IES	(TPU0.unTCN05.stcField.u1IES)  /*@bf@*/
#define TPU0_TCN05_CONT	(TPU0.unTCN05.stcField.u1CONT)  /*@bf@*/
#define TPU0_TCN05_STOP	(TPU0.unTCN05.stcField.u1STOP)  /*@bf@*/
#define TPU0_TCN05_START	(TPU0.unTCN05.stcField.u1START)  /*@bf@*/

#define TPU0_TCN06	(TPU0.unTCN06.u32Register)  /*@rg@*/
#define TPU0_TCN06_ECPL	(TPU0.unTCN06.stcField.u24ECPL)  /*@bf@*/
#define TPU0_TCN06_IRC	(TPU0.unTCN06.stcField.u1IRC)  /*@bf@*/
#define TPU0_TCN06_IEC	(TPU0.unTCN06.stcField.u1IEC)  /*@bf@*/
#define TPU0_TCN06_IES	(TPU0.unTCN06.stcField.u1IES)  /*@bf@*/
#define TPU0_TCN06_CONT	(TPU0.unTCN06.stcField.u1CONT)  /*@bf@*/
#define TPU0_TCN06_STOP	(TPU0.unTCN06.stcField.u1STOP)  /*@bf@*/
#define TPU0_TCN06_START	(TPU0.unTCN06.stcField.u1START)  /*@bf@*/

#define TPU0_TCN07	(TPU0.unTCN07.u32Register)  /*@rg@*/
#define TPU0_TCN07_ECPL	(TPU0.unTCN07.stcField.u24ECPL)  /*@bf@*/
#define TPU0_TCN07_IRC	(TPU0.unTCN07.stcField.u1IRC)  /*@bf@*/
#define TPU0_TCN07_IEC	(TPU0.unTCN07.stcField.u1IEC)  /*@bf@*/
#define TPU0_TCN07_IES	(TPU0.unTCN07.stcField.u1IES)  /*@bf@*/
#define TPU0_TCN07_CONT	(TPU0.unTCN07.stcField.u1CONT)  /*@bf@*/
#define TPU0_TCN07_STOP	(TPU0.unTCN07.stcField.u1STOP)  /*@bf@*/
#define TPU0_TCN07_START	(TPU0.unTCN07.stcField.u1START)  /*@bf@*/

typedef struct stc_tpu0_tcn0n_field{
    uint_io32_t		u24ECPL:24;
    uint_io32_t		:2;
    uint_io32_t		u1IRC:1;
    uint_io32_t		u1IEC:1;
    uint_io32_t		u1IES:1;
    uint_io32_t		u1CONT:1;
    uint_io32_t		u1STOP:1;
    uint_io32_t		u1START:1;
}stc_tpu0_tcn0n_field_t;

typedef union un_tpu0_tcn0n{
    uint_io32_t		u32Register;
    stc_tpu0_tcn0n_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tpu0_tcn0n_t;

/* TCN1[0-7] */
#define TPU0_TCN10	(TPU0.unTCN10.u32Register)  /*@rg@*/
#define TPU0_TCN10_PS	(TPU0.unTCN10.stcField.u2PS)  /*@bf@*/
#define TPU0_TCN10_TMOD	(TPU0.unTCN10.stcField.u1TMOD)  /*@bf@*/
#define TPU0_TCN10_FRT	(TPU0.unTCN10.stcField.u1FRT)  /*@bf@*/
#define TPU0_TCN10_PL	(TPU0.unTCN10.stcField.u1PL)  /*@bf@*/

#define TPU0_TCN11	(TPU0.unTCN11.u32Register)  /*@rg@*/
#define TPU0_TCN11_PS	(TPU0.unTCN11.stcField.u2PS)  /*@bf@*/
#define TPU0_TCN11_TMOD	(TPU0.unTCN11.stcField.u1TMOD)  /*@bf@*/
#define TPU0_TCN11_FRT	(TPU0.unTCN11.stcField.u1FRT)  /*@bf@*/
#define TPU0_TCN11_PL	(TPU0.unTCN11.stcField.u1PL)  /*@bf@*/

#define TPU0_TCN12	(TPU0.unTCN12.u32Register)  /*@rg@*/
#define TPU0_TCN12_PS	(TPU0.unTCN12.stcField.u2PS)  /*@bf@*/
#define TPU0_TCN12_TMOD	(TPU0.unTCN12.stcField.u1TMOD)  /*@bf@*/
#define TPU0_TCN12_FRT	(TPU0.unTCN12.stcField.u1FRT)  /*@bf@*/
#define TPU0_TCN12_PL	(TPU0.unTCN12.stcField.u1PL)  /*@bf@*/

#define TPU0_TCN13	(TPU0.unTCN13.u32Register)  /*@rg@*/
#define TPU0_TCN13_PS	(TPU0.unTCN13.stcField.u2PS)  /*@bf@*/
#define TPU0_TCN13_TMOD	(TPU0.unTCN13.stcField.u1TMOD)  /*@bf@*/
#define TPU0_TCN13_FRT	(TPU0.unTCN13.stcField.u1FRT)  /*@bf@*/
#define TPU0_TCN13_PL	(TPU0.unTCN13.stcField.u1PL)  /*@bf@*/

#define TPU0_TCN14	(TPU0.unTCN14.u32Register)  /*@rg@*/
#define TPU0_TCN14_PS	(TPU0.unTCN14.stcField.u2PS)  /*@bf@*/
#define TPU0_TCN14_TMOD	(TPU0.unTCN14.stcField.u1TMOD)  /*@bf@*/
#define TPU0_TCN14_FRT	(TPU0.unTCN14.stcField.u1FRT)  /*@bf@*/
#define TPU0_TCN14_PL	(TPU0.unTCN14.stcField.u1PL)  /*@bf@*/

#define TPU0_TCN15	(TPU0.unTCN15.u32Register)  /*@rg@*/
#define TPU0_TCN15_PS	(TPU0.unTCN15.stcField.u2PS)  /*@bf@*/
#define TPU0_TCN15_TMOD	(TPU0.unTCN15.stcField.u1TMOD)  /*@bf@*/
#define TPU0_TCN15_FRT	(TPU0.unTCN15.stcField.u1FRT)  /*@bf@*/
#define TPU0_TCN15_PL	(TPU0.unTCN15.stcField.u1PL)  /*@bf@*/

#define TPU0_TCN16	(TPU0.unTCN16.u32Register)  /*@rg@*/
#define TPU0_TCN16_PS	(TPU0.unTCN16.stcField.u2PS)  /*@bf@*/
#define TPU0_TCN16_TMOD	(TPU0.unTCN16.stcField.u1TMOD)  /*@bf@*/
#define TPU0_TCN16_FRT	(TPU0.unTCN16.stcField.u1FRT)  /*@bf@*/
#define TPU0_TCN16_PL	(TPU0.unTCN16.stcField.u1PL)  /*@bf@*/

#define TPU0_TCN17	(TPU0.unTCN17.u32Register)  /*@rg@*/
#define TPU0_TCN17_PS	(TPU0.unTCN17.stcField.u2PS)  /*@bf@*/
#define TPU0_TCN17_TMOD	(TPU0.unTCN17.stcField.u1TMOD)  /*@bf@*/
#define TPU0_TCN17_FRT	(TPU0.unTCN17.stcField.u1FRT)  /*@bf@*/
#define TPU0_TCN17_PL	(TPU0.unTCN17.stcField.u1PL)  /*@bf@*/

typedef struct stc_tpu0_tcn1n_field{
    uint_io32_t		u2PS:2;
    uint_io32_t		u1TMOD:1;
    uint_io32_t		u1FRT:1;
    uint_io32_t		u1PL:1;
    uint_io32_t		:27;
}stc_tpu0_tcn1n_field_t;

typedef union un_tpu0_tcn1n{
    uint_io32_t		u32Register;
    stc_tpu0_tcn1n_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tpu0_tcn1n_t;

/* TCC[0-7] */
#define TPU0_TCC0	(TPU0.unTCC0.u32Register)  /*@rg@*/
#define TPU0_TCC0_TCC	(TPU0.unTCC0.stcField.u24TCC)  /*@bf@*/

#define TPU0_TCC1	(TPU0.unTCC1.u32Register)  /*@rg@*/
#define TPU0_TCC1_TCC	(TPU0.unTCC1.stcField.u24TCC)  /*@bf@*/

#define TPU0_TCC2	(TPU0.unTCC2.u32Register)  /*@rg@*/
#define TPU0_TCC2_TCC	(TPU0.unTCC2.stcField.u24TCC)  /*@bf@*/

#define TPU0_TCC3	(TPU0.unTCC3.u32Register)  /*@rg@*/
#define TPU0_TCC3_TCC	(TPU0.unTCC3.stcField.u24TCC)  /*@bf@*/

#define TPU0_TCC4	(TPU0.unTCC4.u32Register)  /*@rg@*/
#define TPU0_TCC4_TCC	(TPU0.unTCC4.stcField.u24TCC)  /*@bf@*/

#define TPU0_TCC5	(TPU0.unTCC5.u32Register)  /*@rg@*/
#define TPU0_TCC5_TCC	(TPU0.unTCC5.stcField.u24TCC)  /*@bf@*/

#define TPU0_TCC6	(TPU0.unTCC6.u32Register)  /*@rg@*/
#define TPU0_TCC6_TCC	(TPU0.unTCC6.stcField.u24TCC)  /*@bf@*/

#define TPU0_TCC7	(TPU0.unTCC7.u32Register)  /*@rg@*/
#define TPU0_TCC7_TCC	(TPU0.unTCC7.stcField.u24TCC)  /*@bf@*/

typedef struct stc_tpu0_tccn_field{
    uint_io32_t		u24TCC:24;
    uint_io32_t		:8;
}stc_tpu0_tccn_field_t;

typedef union un_tpu0_tccn{
    uint_io32_t		u32Register;
    stc_tpu0_tccn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_tpu0_tccn_t;


typedef struct stc_tpu0{
    un_tpu0_unlock_t	unUNLOCK;	/* 0x00000000 */
    un_tpu0_lst_t	unLST;	/* 0x00000004 */
    un_tpu0_cfg_t	unCFG;	/* 0x00000008 */
    un_tpu0_tir_t	unTIR;	/* 0x0000000C */
    un_tpu0_tst_t	unTST;	/* 0x00000010 */
    un_tpu0_tie_t	unTIE;	/* 0x00000014 */
    uint_io8_t	au8Reserved0[24];	/* 0x00000018 */
    un_tpu0_tcn0n_t	unTCN00;	/* 0x00000030 */
    un_tpu0_tcn0n_t	unTCN01;	/* 0x00000034 */
    un_tpu0_tcn0n_t	unTCN02;	/* 0x00000038 */
    un_tpu0_tcn0n_t	unTCN03;	/* 0x0000003C */
    un_tpu0_tcn0n_t	unTCN04;	/* 0x00000040 */
    un_tpu0_tcn0n_t	unTCN05;	/* 0x00000044 */
    un_tpu0_tcn0n_t	unTCN06;	/* 0x00000048 */
    un_tpu0_tcn0n_t	unTCN07;	/* 0x0000004C */
    un_tpu0_tcn1n_t	unTCN10;	/* 0x00000050 */
    un_tpu0_tcn1n_t	unTCN11;	/* 0x00000054 */
    un_tpu0_tcn1n_t	unTCN12;	/* 0x00000058 */
    un_tpu0_tcn1n_t	unTCN13;	/* 0x0000005C */
    un_tpu0_tcn1n_t	unTCN14;	/* 0x00000060 */
    un_tpu0_tcn1n_t	unTCN15;	/* 0x00000064 */
    un_tpu0_tcn1n_t	unTCN16;	/* 0x00000068 */
    un_tpu0_tcn1n_t	unTCN17;	/* 0x0000006C */
    un_tpu0_tccn_t	unTCC0;	/* 0x00000070 */
    un_tpu0_tccn_t	unTCC1;	/* 0x00000074 */
    un_tpu0_tccn_t	unTCC2;	/* 0x00000078 */
    un_tpu0_tccn_t	unTCC3;	/* 0x0000007C */
    un_tpu0_tccn_t	unTCC4;	/* 0x00000080 */
    un_tpu0_tccn_t	unTCC5;	/* 0x00000084 */
    un_tpu0_tccn_t	unTCC6;	/* 0x00000088 */
    un_tpu0_tccn_t	unTCC7;	/* 0x0000008C */
    uint_io8_t	au8Reserved1[32624];	/* 0x00000090 */
}stc_tpu0_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_tpu0_t	stcTPU0;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 32768(0x8000) bytes */


#endif /* __S6J3360_TPU_H */
