#ifndef _BSP_BUTTON_
#define _BSP_BUTTON_

#define    OFF        0
#define    ON         1
#define    ERROR       9
#define    ERROR_END   10

#define GreaterThan(time) (ButtomCurrent.Time > time)
#define LessThan(time)    (ButtomCurrent.Time < time)

#define BetweenTime(start,end) (GreaterThan(start) && LessThan(end))

#define SetStartTime(time) (ButtomCurrent.Time = time)

extern  uint8_t         SW_Data[10];
extern  uint8_t         SW_Data_Short[10];
extern  uint8_t         HW_Data[10];
extern  uint8_t         HJYB_Data[10];
extern  uint8_t         DAY_Data[10];
extern  uint8_t         NUM1_Data[10];
extern  uint8_t         NUM2_Data[10];
extern  uint8_t         NUM3_Data[10];
extern  uint8_t         NUM4_Data[21];
extern  uint8_t         NUM5_Data[10];
extern  uint8_t         NUM6_Data[10];
extern  uint8_t         NUM7_Data[10];
extern  uint8_t         NUM8_Data[20];
extern  uint8_t         NUM9_Data[20];
extern  uint8_t         NUM10_Data[20];
extern  uint8_t         CSW_Data[10];

extern volatile  uint16_t  ErrorCode;

extern uint8_t SendSW_HW;
extern uint8_t TFTUp_Switch;

extern uint8_t Key27Buffer[128];
typedef struct
{
    uint8_t   Flag;      // ���±�־
    uint16_t  Time;      // ���¼�ʱ
    uint8_t   Statu;     // ����״̬
    uint8_t   Until;       // ������־
  // uint8_t   Value;     // ����ֵ
  //  unsigned int Alarm           :  1 ; // 
  //  unsigned int SpeedUp         :  1 ; // 
  //  unsigned int SpeedDown       :  1 ; //  
}Class;
typedef enum HJ_FuelScaleNum
{
    HJ_FuelNull,
    HJ_FuelOne,
    HJ_FuelTwo,
    HJ_FuelThree,
    HJ_FuelFour,
    HJ_FuelFive,
    HJ_FuelFour_a,
    HJ_FuelThree_a,
    HJ_FuelTwo_a,
    HJ_FuelOne_a,
    HJ_FuelNull_a,
}HJ_FuelScale;

typedef enum 
{
    HJ_MODE_ShortPush,
    HJ_MODE_LongPush,
    HJ_SET_ShortPush,
    HJ_SET_LongPush,
    HJ_SETMODE_LongPush_5S,
    HJ_SETMODE_LongPush_2S,
}HJ_SwitchOutPut;

typedef struct//union 
{
    Class        S30             ; // 30��
    Class        S15             ; // 15��
    Class        Auto            ; // �Լ�
    uint8_t      Alarm           ; // ����
    Class        SpeedUp         ; // ����+
    Class        SpeedDown       ; // ����-
    uint8_t      SpeedValue      ; // ���ٰ���ֵ
    Class        LED/*Up*/       ; // LED
    uint8_t      LEDValue        ; // LED����ֵ
    Class        FuelWaterUp     ; // ˮ�Ͱ���ֵ+
    Class        FuelWaterDown   ; // ˮ�Ͱ���ֵ-
    uint8_t      FuelWaterValue  ; // ˮ�Ͱ���ֵ
    Class        TFTUp           ; // TFT+
    Class        TFTDown         ; // TFT-
    Class        Other           ; // ����
    uint8_t      OtherValue      ; // ��������ֵ
    Class        End             ; // ����
    uint8_t      Count           ; // ����
    Class        EOL             ; // EOL����   
    Class        Back_light      ; // ����   
    Class        Luminosity      ; // ����
    Class        Menu            ; // �˵�
    Class        Up              ; // ��
    Class        Down            ; // ��
    Class        OK              ; // OK
    Class        EOLClear        ; // EOL����ȫ0
    Class        Auto_AddBegin            ;
}_BUTTON;
extern _BUTTON Botton;


typedef struct//union 
{
    uint8_t      Statu           ; // ״̬
    uint8_t      Flag            ; // ��־λ
}_Eol;
extern uint8_t SetOilState;
extern _Eol EOL;
extern void APP_SPEED_OUTPUT(void);
extern void APP_CAN_Output_Show (void);
extern void APP_LED_OUTPUT(void) ;
extern void APP_OIL_TEMP(void);
extern void APP_TFT_OUTPUT(void);
extern void APP_LCD_OUTPUT(void);
extern void APP_EOL(void); 
extern void Delay(uint16_t msec); 
extern void APP_AUTO(void);
extern void APP_ELSE(void);
extern void APP_END(void);
extern void Buzzer_Alarm();
extern void User_Delay(uint16_t Delay_Time);
extern void Get_Button_Value(void);
extern void Stage_Manage(void);
extern void Button_Statu_Manage(void);
extern void LedCtrl(uint8_t uiLedNo, uint8_t uiLedState);
extern void GetPartNum(void);
extern uint8_t CurrNum;
extern uint8_t Key27Step;
extern uint8_t Write2EStep;
extern uint8_t ReceiveData[8];
extern uint8_t UdsKeyData[8];
extern uint8_t HJ_CurvSpeedNum;
extern uint16_t HJ_CureSpeedNum;
extern uint8_t HJ_CurFuelNum;
extern uint8_t HJ_SettingNum;
extern uint8_t Othercount;
extern uint8_t HJ_SetTimeStep_0;
extern uint8_t HJ_SetTimeStep_1;
extern uint8_t HJ_SetTimeStep_2;
extern uint8_t HJ_SetTimeStep_3;
extern uint8_t HJ_SetTimeFinish;
extern uint16_t OthercountTime;
extern uint8_t laohuaflag;
extern uint16_t laohuatime;
extern uint16_t time1;
extern uint16_t count1;
extern uint8_t Auto_add_flag;
extern uint8_t Auto_reducte_flag;
extern uint8_t LED_High_Beam_STATUS(void);
#endif // #define _BSP_BUTTON_