/*
 * APP_Data_Process.c
 *
 *  Created on: 2012-6-17
 *      Author: qitiancun
 */
#define GLOBALS_APP_PROCESS
#include "../App_Headers/includes.h"



/*-------------------------------------------------------------------------
* Function Name  : App_State_Init
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void App_State_Init(void)
{
    
}
/*-------------------------------------------------------------------------
* Function Name  : App_Load_Data
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void App_Load_Data(void)
{
    App_Read_EE_Memory(DFLASH_RADIO_ADDR- DFLASH_PROGRAM_OFFSET,(INT8U *)&Radio,8);
    check = App_CreateCheckSun((INT8U*)&Radio.VehRadio,Radio.bFlag,6);
    
    if((Radio.bFlag != 0x55)||(check != Radio.bCheckSun))
    { 
        Radio.RevRadio = 40; 
        Radio.VehRadio = 568;
        Radio.VehNum = 4;
    } 
}

/*-------------------------------------------------------------------------
* Function Name  : App_SCI_Proc
* Description    : ݴ
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
INT8U App_CreateCheckSun(INT8U *pData,INT8U checkbyte,INT8U len)
{
  	INT8U Check=0,i;
  	Check = 0xff ^ checkbyte;
  	for(i=0;i<len;i++)
  	{
  		Check = Check ^ pData[i];
  	}
  	return Check;
}

void App_Uds_Calc_Key(INT32U seed)
{
	aaaa = 0xb5;//00000000 00000000 00000000 10110101
	bbbb = 0xa3;//00000000 00000000 00000000 10100011   
	cccc = 0xf1;//00000000 00000000 00000000 11110001		
	dddd = 0x36;//00000000 00000000 00000000 00110110 

	dwSeed4 = (INT8U)( seed & 0x000000ff);        //00000000 00000000 00000000 000000ff
	dwSeed3 = (INT8U)((seed & 0x0000ff00) >> 8);  //00000000 00000000 0000ff00 00000000
	dwSeed2 = (INT8U)((seed & 0x00ff0000) >> 16); //00000000 00ff0000 00000000 00000000
	dwSeed1 = (INT8U)((seed & 0xff000000) >> 24); //ff000000 00000000 00000000 00000000		


	dwKey1 = (INT8U)((aaaa * (dwSeed1 * dwSeed1)) + (bbbb * (dwSeed2 * dwSeed2)) + (cccc * (dwSeed1 * dwSeed2)));
	dwKey2 = (INT8U)((aaaa *             dwSeed1) + (bbbb *             dwSeed2) + (dddd * (dwSeed1 * dwSeed2))); 
	dwKey3 = (INT8U)((aaaa * (dwSeed3 * dwSeed4)) + (bbbb * (dwSeed4 * dwSeed4)) + (cccc * (dwSeed3 * dwSeed4))); 
	dwKey4 = (INT8U)((aaaa * (dwSeed3 * dwSeed4)) + (bbbb *             dwSeed4) + (dddd * (dwSeed3 * dwSeed4))); 

	CalcKey = (dwKey1 << 24UL) | (dwKey2 << 16UL) | (dwKey3 << 8UL) | dwKey4;
}

void UDS_Receive_Main(unsigned char *buf)
{
    switch(EOLStep)
    {
        case 0:
        {
            if((buf[1] == 0x62) && (buf[2] == 0x02) && (buf[3] == 0x1F) && (buf[4] != EOLMode))
            {
                EOLStep = 1;
            }
            else
            {
                EOLStep = 0;
                EOLError = 0;
            }
        }
        break;

        case 1:
        {
            if((buf[1] == 0x50) && (buf[2] == 0x03))
            {
                EOLStep = 2;
                EOLError = 0;
            }
            else
            {
                EOLError++;
            }
        }
        break;

        case 2:
        {
            if((buf[1] == 0x67) && (buf[2] == 0x01))
            {
                GetSeed = buf[3];
                GetSeed = GetSeed << 8;
                GetSeed |= buf[4];
                GetSeed = GetSeed << 8;
                GetSeed |= buf[5];
                GetSeed = GetSeed << 8;
                GetSeed |= buf[6];

                EOLStep = 3;
                EOLError = 0;
            }
            else
            {
                EOLError++;
            }
        }
        break;

        case 3:
        {
            if((buf[1] == 0x67) && (buf[2] == 0x02))
            {
                EOLStep = 4;
                EOLError = 0;
            }
            else
            {
                EOLError++;
            }
        }
        break;

        case 4:
        {
            if((buf[1] == 0x6E) && (buf[2] == 0x02) && (buf[3] == 0x1F))
            {
                EOLStep = 5;
                EOLError = 0;
            }
            else
            {
                EOLError++;
            }
        }
        break;

        case 5:
        {
            if((buf[1] == 0x51) && (buf[2] == 0x01))
            {
                EOLStep = 0;
                EOLError = 0;
            }
            else
            {
                EOLError++;
            }
        }
        break;

        default:
        {
            EOLStep = 0;
            EOLError = 0;
        }
    }

    if(EOLError >= 5)
    {
        EOLStep = 0;
        EOLError = 0;
    }



}


void Service_10_03_Proc(void)
{
    /*
    CanMessageID18DA17F9.ID = 0x18DA17F9;
    CanMessageID18DA17F9.ID_EN = 1;
    CanMessageID18DA17F9.Length = 8;

    CanMessageID18DA17F9.Msg[0] = 0x02;
    CanMessageID18DA17F9.Msg[1] = 0x10;
    CanMessageID18DA17F9.Msg[2] = 0x03;
    */
}

void Service_11_01_Proc(void)
{
    /*
    CanMessageID18DA17F9.ID = 0x18DA17F9;
    CanMessageID18DA17F9.ID_EN = 1;
    CanMessageID18DA17F9.Length = 8;

    CanMessageID18DA17F9.Msg[0] = 0x02;
    CanMessageID18DA17F9.Msg[1] = 0x11;
    CanMessageID18DA17F9.Msg[2] = 0x01;
    */
}

void Service_22_Proc(void)
{
    /*
    CanMessageID18DA17F9.ID = 0x18DA17F9;
    CanMessageID18DA17F9.ID_EN = 1;
    CanMessageID18DA17F9.Length = 8;

    CanMessageID18DA17F9.Msg[0] = 0x03;
    CanMessageID18DA17F9.Msg[1] = 0x22;
    CanMessageID18DA17F9.Msg[2] = 0x02;
    CanMessageID18DA17F9.Msg[3] = 0x1F;
    */
}

void Service_27_01_Proc(void)
{
    /*
    CanMessageID18DA17F9.ID = 0x18DA17F9;
    CanMessageID18DA17F9.ID_EN = 1;
    CanMessageID18DA17F9.Length = 8;

    CanMessageID18DA17F9.Msg[0] = 0x02;
    CanMessageID18DA17F9.Msg[1] = 0x27;
    CanMessageID18DA17F9.Msg[2] = 0x01;
    */
}

void Service_27_02_Proc(void)
{
    /*
    CanMessageID18DA17F9.ID = 0x18DA17F9;
    CanMessageID18DA17F9.ID_EN = 1;
    CanMessageID18DA17F9.Length = 8;

    App_Uds_Calc_Key(GetSeed);

    CanMessageID18DA17F9.Msg[0] = 0x06;
    CanMessageID18DA17F9.Msg[1] = 0x27;
    CanMessageID18DA17F9.Msg[2] = 0x02;
    CanMessageID18DA17F9.Msg[3] = (unsigned char)(CalcKey >> 24);
    CanMessageID18DA17F9.Msg[4] = (unsigned char)(CalcKey >> 16);
    CanMessageID18DA17F9.Msg[5] = (unsigned char)(CalcKey >> 8);
    CanMessageID18DA17F9.Msg[6] = (unsigned char)(CalcKey);
    */
}

void Service_2E_Proc(void)
{
    /*
    CanMessageID18DA17F9.ID = 0x18DA17F9;
    CanMessageID18DA17F9.ID_EN = 1;
    CanMessageID18DA17F9.Length = 8;

    CanMessageID18DA17F9.Msg[0] = 0x04;
    CanMessageID18DA17F9.Msg[1] = 0x2E;
    CanMessageID18DA17F9.Msg[2] = 0x02;
    CanMessageID18DA17F9.Msg[3] = 0x1F;
    CanMessageID18DA17F9.Msg[4] = EOLMode;
    */
}

void UDS_Service_Main(void)
{
    switch(EOLStep)
    {
        case 0:
        {
            Service_22_Proc();
        }
        break;

        case 1:
        {
            Service_10_03_Proc();
        }
        break;

        case 2:
        {
            Service_27_01_Proc();
        }
        break;

        case 3:
        {
            Service_27_02_Proc();
        }
        break;

        case 4:
        {
            Service_2E_Proc();
        }   
        break;

        case 5:
        {
            Service_11_01_Proc();
        }   
        break;

        default:
        {
            EOLStep = 0;
            EOLError = 0;
        }
    }
}