

#ifdef        GLOBALS_APP_TEST
    #define   EXTERN_APP_TEST
    
#else
    #define   EXTERN_APP_TEST     extern
#endif

#ifndef APP_TEDT_H_
#define APP_TEDT_H_

#define Motorola                0
#define Intel                   1

#define Offset_Minus            0
#define Offset_Plus             1

#define Value_Minus             0
#define Value_Plus              1

typedef struct{
    int val;
    unsigned char fval;
}s_CurValue;

typedef struct{
    CAN_message *canMsg;
    unsigned char StartByte;
    unsigned char StartBit;
    unsigned char SignalLen;
    unsigned int  Offset;
    unsigned char fOffset;
    unsigned int Factor_1;/*Denominator of Resolution*/  /*���ȵķ�ĸ*/
    unsigned int Factor_2;/*Numerator of Resolution*/    /*���ȵķ���*/
    s_CurValue *CurValue; 
    unsigned char fFormat;
}s_CAN_List;

enum
{
    ENUM_VSpeed = 0,//����
    GEAR,
    ENUM_EleDial1,
    ENUM_EleDial2,
    ENUM_Current1,
    ENUM_Current2,
    Motor_error,
    Battery_error,
    Charge_status,
    Cruise_control,
    Ready,
    ECM_MotorOverTempFaul,//103
    BMS_ChargeUnderVoltageInd1,//200
    BMS_ChargeUnderVoltageInd2,//200
    BMS_BattryInsulationFault,//205
    CAN_List_Num,
};
                                                                                    
EXTERN_APP_TEST volatile s_CurValue CurValueStr[CAN_List_Num];

static const s_CAN_List CAN_List[] = 
{
    {&CanMsg_101, 1,  0,  16,   0,   Offset_Plus,    1,       1, &CurValueStr[ENUM_VSpeed          ], Intel},
    {&CanMsg_067, 5,  0,  3,    0,   Offset_Plus,    1,       1, &CurValueStr[GEAR                 ], Intel},
    {&CanMsg_067, 1,  0,  16,   0,   Offset_Plus,    1,       1, &CurValueStr[Motor_error          ], Intel},
    {&CanMsg_067, 3,  6,  1,    0,   Offset_Plus,    1,       1, &CurValueStr[Charge_status        ], Intel},
    {&CanMsg_067, 4,  2,  1,    0,   Offset_Plus,    1,       1, &CurValueStr[Cruise_control       ], Intel},
    {&CanMsg_067, 3,  4,  1,    0,   Offset_Plus,    1,       1, &CurValueStr[Ready                ], Intel},
    {&CanMsg_067, 3,  2,  2,    0,   Offset_Plus,    1,       1, &CurValueStr[ECM_MotorOverTempFaul], Intel},



    {&CanMsg_1023FFA7, 0,  0, 16,    0,   Offset_Plus,    10,    1, &CurValueStr[ENUM_EleDial1], Intel},
    {&CanMsg_1023FFA8, 0,  0, 16,    0,   Offset_Plus,    10,    1, &CurValueStr[ENUM_EleDial2], Intel},
    {&CanMsg_1020FFA7, 2,  0, 16,    500, Offset_Minus,   10,    1, &CurValueStr[ENUM_Current1], Intel},
    {&CanMsg_1020FFA8, 2,  0, 16,    500, Offset_Minus,   10,    1, &CurValueStr[ENUM_Current2], Intel},
    {&CanMsg_1028FFA7, 0,  0, 2,     0,   Offset_Plus,    1,     1, &CurValueStr[Battery_error], Intel},
    {&CanMsg_1028FFA7, 3,  2, 2,     0,   Offset_Plus,    1,     1, &CurValueStr[BMS_BattryInsulationFault], Intel},
    {&CanMsg_1028FFA7, 0,  6, 2,     0,   Offset_Plus,    1,     1, &CurValueStr[BMS_ChargeUnderVoltageInd1], Intel},
    {&CanMsg_1028FFA8, 0,  6, 2,     0,   Offset_Plus,    1,     1, &CurValueStr[BMS_ChargeUnderVoltageInd2], Intel},
};


extern unsigned int Key_Dodging_flag;
extern unsigned int lost_flag;
extern unsigned int CAN_init_flag;
extern unsigned int water_value;
extern unsigned int count_flag_a;
extern unsigned int speed_value;
EXTERN_APP_TEST             void                APP_Button_Proc(void);
EXTERN_APP_TEST             void                Message_Value_Calculate(s_CAN_List list);

void Bits_Operation(CAN_message *Message, unsigned char StartByte, unsigned char StartBit, unsigned char Length, unsigned char Value);  /*Do not span bytes*/



#endif /* API_CAN_H_ */
