#include "RTE_CAN.h"
#include "CAN_Lib.h"
#include "CAN_APP.h"
#include "CAN_Communication_Matrix.h"
#include "Analog_Signals.h"
#include "RSCAN.h"
#include "Key.h"
#include "Display_Info.h"
#include "string.h"
#include "RSCAN.h"
uint8_t CrcCheckSum(uint8_t *data, uint8_t len)
{
    uint8_t crc        = 0xff;
    uint8_t CRC_POLY   = 0x2f;
    uint8_t crcxor     = 0xff;
    uint8_t bit_index  = 0;
    uint8_t byte_index = 0;

    for ( byte_index = 0; byte_index < len; ++byte_index )
    {
        crc ^= data [ byte_index ];
        for ( bit_index = 0; bit_index < 8; ++bit_index )
        {
            if ( (crc & 0x80) != 0 )
                crc = (crc << 1) ^ CRC_POLY;
            else
                crc = (crc << 1);
        }
    }

    crc = crc ^ crcxor;

    return crc;
}



void CAN_MSG_COUNTER_PLUS(void)
{
}
void  Can_Set_Buff_200(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg220Union *pCANMsg;

    pCANMsg = (CANMsg220Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }

    pCANMsg->Sig.Vspeeed = Vspeed;

}
void  Can_Set_Buff_481(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg481Union *pCANMsg;

    pCANMsg = (CANMsg481Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }
    pCANMsg->Sig.Year   = 1;
    pCANMsg->Sig.Month  = 1;
    pCANMsg->Sig.Day    = 1;
    pCANMsg->Sig.Minute = 0;
    pCANMsg->Sig.Second = 0;
    pCANMsg->Sig.Hour   = Hour;

}

void  Can_Set_Buff_020(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg020Union *pCANMsg;

    pCANMsg = (CANMsg020Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }


    pCANMsg->Sig.Eletricity_H = Eletricity >> 8;
    pCANMsg->Sig.Eletricity_L = Eletricity & 0xff;
}

void  Can_Set_Buff_042(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg042Union *pCANMsg;

    pCANMsg = (CANMsg042Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }
    if(Tcs == 1)/*TCS指示灯开启*/
    {
        pCANMsg->Sig.TCS = 0;
        pCANMsg->Sig.Tcs_mode = 1;
    }
    else if(Tcs == 2)/*禁止TCS指示灯开启*/
    {
        pCANMsg->Sig.Tcs_mode = 0;
        pCANMsg->Sig.TCS = 1;
    }
    else if(Tcs == 3)/*全亮*/
    {
        pCANMsg->Sig.TCS = 0;
        pCANMsg->Sig.Tcs_mode = 0;
    }
    else/*熄灭*/
    {
        pCANMsg->Sig.TCS = 1;
        pCANMsg->Sig.Tcs_mode = 1;
    }
    pCANMsg->Msg[7] = 0xff;
}

void  Can_Set_Buff_480(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg480Union *pCANMsg;

    pCANMsg = (CANMsg480Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }
    pCANMsg->Sig.Signal_Gps = Signal_GPS;
    pCANMsg->Sig.Signal_4g = Signal_4G;
    if(bluetooth_phone==1)
    {
        pCANMsg->Sig.Blooth_phone = 1;

    }else if(bluetooth_phone==0)
    {
        pCANMsg->Sig.Blooth_phone = 0;
    }

}

void  Can_Set_Buff_280(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg280Union *pCANMsg;

    pCANMsg = (CANMsg280Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }
    if(Energy_recovery == 2)
    {
        pCANMsg->Sig.Energy_status = 1;
        pCANMsg->Sig.Energy_recovery = 2;
        //pCANMsg->Sig.Side_bracket = 1;
    }
    else if(Energy_recovery == 1)
    {
        pCANMsg->Sig.Energy_status = 1;
        pCANMsg->Sig.Energy_recovery = 1;
    }
    else if(Energy_recovery == 3)
    {
        pCANMsg->Sig.Energy_status = 1;
        pCANMsg->Sig.Energy_recovery = 3;
    }
    else
    {
        ;
    }

    // if(Tcs == 1)
    // {
    //     pCANMsg->Sig.Tcs_Status = 1;
    // }
    if(Side_bracket == 1)
    {
        pCANMsg->Sig.Side_bracket280 = 1;
    }
    if(Side_bracket == 0)
    {
        pCANMsg->Sig.Side_bracket280 = 0;
    }

}

void  Can_Set_Buff_202(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg202Union *pCANMsg;

    pCANMsg = (CANMsg202Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }
    if(Gear == 0)
    {
        pCANMsg->Sig.Gear = 0;
    }
    else if(Gear == 1)
    {
        pCANMsg->Sig.Gear = 1;
    }
    else if(Gear == 2)
    {
        pCANMsg->Sig.Gear = 2;
    }

    if(Cruiste == 1)
    {
        pCANMsg->Sig.Cruiste = 1;
    }

    if(Ready == 1)
    {
        pCANMsg->Sig.Ready = 1;
    }
    else if(Ready == 2)
    {
        pCANMsg->Sig.Ready = 2;
    }
    else if(Ready == 3 )
    {
        pCANMsg->Sig.Ready = 3;
    }

    if(Fault == 1)
    {
        pCANMsg->Sig.Fault = 1;
    }

    if(Hill_Descent_control == 1)
    {
        pCANMsg->Sig.Hill_Descent_control = 1;
    }
    else if(Hill_Descent_control == 0)
    {
        pCANMsg->Sig.Hill_Descent_control = 0;
    }

    if(Side_bracket == 1)
    {
        pCANMsg->Sig.Side_bracket202 = 0;
    }
    // pCANMsg->Msg[1]=0Xff;
}
void  Can_Set_Buff_001(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg001Union *pCANMsg;

    pCANMsg = (CANMsg001Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }
    if(Motor_hert == 1)
    {
        pCANMsg->Sig.Motor_hert = 1;
    }
    if(( Energy_recovery== 2) || ( Energy_recovery== 1) || ( Energy_recovery== 3))/*能量回收*/
    {
        pCANMsg->Sig.Msg_0x001_2b3t = 1;
    }
    if(motor_hot == 1)
    {
        pCANMsg->Sig.Msg_0x001_2b4t = 1;
    }
}

void  Can_Set_Buff_021(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg021Union *pCANMsg;

    pCANMsg = (CANMsg021Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }

    if(Battery_temp == 1)
    {
        pCANMsg->Sig.Battery_temp = 1;
    }
        if(Battery_temp == 1)
    {
        pCANMsg->Sig.Battery_temp = 1;
    }
}
/*学卡请求*/
uint8_t Data_284_chacard[8]= {0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00};/*查卡*/
uint8_t Data_284_tiancard[8]= {0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00};/*添卡*/
uint8_t Data_284_shancard[8]= {0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00};/*删卡*/

void  Can_Set_Buff_284(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg284Union *pCANMsg;

    pCANMsg = (CANMsg284Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }

    if(NFC_C_card == 1)
    {
        pCANMsg->Sig.NFC_C_card = 1;
    }
    else if((NFC_C_card == 2))
    {
        pCANMsg->Sig.NFC_C_card = 2;
    }
//添卡请求

    if(Student_Card==1)
    {
        for(i = 0u; i < 8u; i++)
        {
            pCANMsg->Msg[i] = Data_284_tiancard[i];
        }
    }
    else if(Student_Card==2)
    {
        for(i = 0u; i < 8u; i++)
        {
            pCANMsg->Msg[i] = Data_284_tiancard[i];
        }
    }
    else if(Student_Card==3)
    {
        for(i = 0u; i < 8u; i++)
        {
            pCANMsg->Msg[i] = Data_284_tiancard[i];
        }
    }
    else if(Student_Card==4)
    {
        for(i = 0u; i < 8u; i++)
        {
            pCANMsg->Msg[i] = Data_284_tiancard[i];
        }
    }
    else if(Student_Card==5)
    {
        for(i = 0u; i < 8u; i++)
        {
            pCANMsg->Msg[i] = Data_284_tiancard[i];
        }
        Student_Card_can_command=0;
        Student_Card=0;
        

    }
    /*查卡指令发送*/
    if(Query_Card==1)
    {
        for(i = 0u; i < 8u; i++)
        {
            pCANMsg->Msg[i] = Data_284_chacard[i];
        }
    }
    else if(Query_Card==2)
    {
        for(i = 0u; i < 8u; i++)
        {
            pCANMsg->Msg[i] = Data_284_chacard[i];
        }
    }
    else if(Query_Card==3)
    {
        for(i = 0u; i < 8u; i++)
        {
            pCANMsg->Msg[i] = Data_284_chacard[i];
        }
    }
    else if(Query_Card==4)
    {
        for(i = 0u; i < 8u; i++)
        {
            pCANMsg->Msg[i] = Data_284_chacard[i];
        }
    }
    else if(Query_Card==5)
    {
        for(i = 0u; i < 8u; i++)
        {
            pCANMsg->Msg[i] = Data_284_chacard[i];
        }
        Query_Card_can_command=2;
        Query_Card=0;
        
    }
    


}
void Student_Card_Triggers(void) 
{
    // switch(Student_Card)
    // {
    //     case 1:

    //         break;
    //     case 2:
    //         break;
    // }
}
/*软件版本号*/
extern uint8_t Data_786_1[8]= {0x03,0x22,0x10,0x24,0xAA,0xAA,0xAA,0xAA};
extern uint8_t Data_786_2[8]= {0x30,0x00,0x00,0xAA,0xAA,0xAA,0xAA,0xAA};
/*硬件版本号*/
extern uint8_t Data_786_3[8]= {0x03,0x22,0xF1,0x93,0xAA,0xAA,0xAA,0xAA};
extern uint8_t Data_786_4[8]= {0x30,0x00,0x00,0xAA,0xAA,0xAA,0xAA,0xAA};
/*解锁UID*/
extern uint8_t Data_786_5[8]= {0x02,0x10,0x02,0xAA,0xAA,0xAA,0xAA,0xAA};
extern uint8_t Data_786_6[8]= {0x02,0x27,0x05,0xAA,0xAA,0xAA,0xAA,0xAA};
extern uint8_t Data_786_7[8]= {0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA};
extern uint8_t Data_786_8[8]= {0x10,0x23,0x2E,0x10,0x88,0x32,0x30,0x30};
extern uint8_t Data_786_9[8]= {0x21,0x30,0x30,0x30,0x30,0x30,0x30,0x30};
extern uint8_t Data_786_10[8]= {0x22,0x30,0x31,0x32,0x30,0x32,0x35,0x30};
extern uint8_t Data_786_11[8]= {0x23,0x36,0x31,0x39,0x30,0x30,0x30,0x30};
extern uint8_t Data_786_12[8]= {0x24,0x30,0x30,0x30,0x30,0x30,0x30,0x31};
extern uint8_t Data_786_13[8]= {0x25,0x31,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA};
extern uint8_t Data_786_14[8]= {0x03,0x22,0x10,0x88,0xAA,0xAA,0xAA,0xAA};
extern uint8_t Data_786_15[8]= {0x30,0x00,0x00,0xAA,0xAA,0xAA,0xAA,0xAA};
extern uint8_t Data_786_16[8]= {0x02,0x3E,0x00,0xAA,0xAA,0xAA,0xAA,0xAA};

uint8_t UIDStep;
uint8_t uidWrite;
uint8_t UIDGetstep = 0;
uint8_t u8getUIDmsg[8];
uint8_t UIDNumber[15] = {2,0,0,0,0,0,0,0,0,0,0,1,2,0,0xFF};
void get_seed_msg(void);
void UID_ADD(void)
{
    for(uint8_t i = 17; i > 1; i--)
    {
        if(UIDNumber2[i] < 9)
        {
            UIDNumber2[i] += 1;
            return;
        }
        else
        {
            UIDNumber2[i] = 0;
        }
    }
}
uint8_t uidwriteStep = 0;
void  Can_Set_Buff_786(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg786Union *pCANMsg;

    pCANMsg = (CANMsg786Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }

    if(Diagnosis_banbenhao_flag == 1)
    {
        // pCANMsg->Sig.diagnosis0 = 0x03;
        for(uint8_t i = 0;i < 8;i++)
        {
            pCANMsg->Msg[i] = Data_786_1[i];
            
        }
        Diagnosis_banbenhao_flag_=1;

    }
     if(Diagnosis_banbenhao_flag == 2)
    {
        for(uint8_t i = 0;i < 8;i++)
        {
            pCANMsg->Msg[i] = Data_786_2[i];
                  
        }
        Diagnosis_banbenhao_flag_=2;  
    }
    else if(Diagnosis_banbenhao_flag == 3)
    {

        for(uint8_t i = 0;i < 8;i++)
        {
            pCANMsg->Msg[i] = Data_786_3[i];
            
        }
        Diagnosis_banbenhao_flag_=3;

    }
    else if(Diagnosis_banbenhao_flag == 4)
    {

        for(uint8_t i = 0;i < 8;i++)
        {
            pCANMsg->Msg[i] = Data_786_4[i];
            
        }
        Diagnosis_banbenhao_flag_= 4;
        Diagnosis_banbenhao_flag = 0;
    }

    if(uidWrite == 1)
    {
        switch (UIDStep)
        {
            case 0:
                // for(uint8_t i = 0;i < 8;i++)
                // {
                //     pCANMsg->Msg[i] = Data_786_5[i];
                // }
                UIDStep++;
                break;
            case 1:
                // for(uint8_t i = 0;i < 8;i++)
                // {
                //     pCANMsg->Msg[i] = Data_786_6[i];
                // }
                UIDStep++;
                break;
            case 2:
                // if(UIDGetstep == 1)
                // {
                //     Data_786_7[0] = 0x06;
                //     Data_786_7[1] = 0x27;
                //     Data_786_7[2] = 0x06;
                //     Data_786_7[3] = seedresult[0];
                //     Data_786_7[4] = seedresult[1];
                //     Data_786_7[5] = seedresult[2];
                //     Data_786_7[6] = seedresult[3];
                //     Data_786_7[7] = 0xAA;
                //     for(uint8_t i = 0;i < 8;i++)
                //     {
                //         pCANMsg->Msg[i] = Data_786_7[i];
                //     }
                    UIDStep++;
                    UIDGetstep = 2;
                // }
                break;
            case 3:
                for(uint8_t i = 0;i < 8;i++)
                {
                    pCANMsg->Msg[i] = Data_786_8[i];
                }
                UIDStep++;
                break;
            case 4:
                if(UIDGetstep == 3)
                {
                   for(uint8_t i = 0;i < 8;i++)
                   {
                       pCANMsg->Msg[i] = Data_786_9[i];
                   }
                   UIDStep++;
                }
                break;
            case 5:
                Data_786_10[5] = 0x30 + UIDNumber2[0];
                Data_786_10[6] = 0x30 + UIDNumber2[1];
                Data_786_10[7] = 0x30 + UIDNumber2[2];
                for(uint8_t i = 0;i < 8;i++)
                   {
                       pCANMsg->Msg[i] = Data_786_10[i];
                   }
                UIDStep++;
                break;
            case 6:
                Data_786_11[1] = 0x30 + UIDNumber2[3];
                Data_786_11[2] = 0x30 + UIDNumber2[4];
                Data_786_11[3] = 0x30 + UIDNumber2[5];
                Data_786_11[4] = 0x30 + UIDNumber2[6];
                Data_786_11[5] = 0x30 + UIDNumber2[7];
                Data_786_11[6] = 0x30 + UIDNumber2[8];
                Data_786_11[7] = 0x30 + UIDNumber2[9];
                for(uint8_t i = 0;i < 8;i++)
                   {
                       pCANMsg->Msg[i] = Data_786_11[i];
                   }
                UIDStep++;
                break;
            case 7:
                Data_786_12[1] = 0x30 + UIDNumber2[10];
                Data_786_12[2] = 0x30 + UIDNumber2[11];
                Data_786_12[3] = 0x30 + UIDNumber2[12];
                Data_786_12[4] = 0x30 + UIDNumber2[13];
                Data_786_12[5] = 0x30 + UIDNumber2[14];
                Data_786_12[6] = 0x30 + UIDNumber2[15];
                Data_786_12[7] = 0x30 + UIDNumber2[16];
                for(uint8_t i = 0;i < 8;i++)
                   {
                       pCANMsg->Msg[i] = Data_786_12[i];
                   }
                UIDStep++;
                break;
            case 8:
                Data_786_13[1] = 0x30 + UIDNumber2[17];
                for(uint8_t i = 0;i < 8;i++)
                   {
                       pCANMsg->Msg[i] = Data_786_13[i];
                   }
                UIDGetstep = 4;
                UIDStep++;
                break;
            default:
                UIDStep = 0;
                break;
        }
    }

    if(writeflag == 1)
    {
        switch (uidwriteStep)
        {
            case 0:
                for(uint8_t i = 0;i < 8;i++)
                {
                    pCANMsg->Msg[i] = Data_786_14[i];
                }
            break;

            case 1:
                for(uint8_t i = 0;i < 8;i++)
                {
                    pCANMsg->Msg[i] = Data_786_15[i];
                }
            break;

            default:
            break;
            // case 6:
            //     for(uint8_t i = 0;i < 8;i++)
            //     {
            //         pCANMsg->Msg[i] = Data_786_16[i];
            //     }
            //     writeflag = 0;
            // break;
        }
    }
}

void  Can_Set_Buff_207(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg207Union *pCANMsg;

    pCANMsg = (CANMsg207Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }
    if(Tcs == 1)    //TCS
    {
        pCANMsg->Sig.Tcs_mode = 1;
        pCANMsg->Sig.TCS = 0;
    }
    else if(Tcs == 2)   //禁止TCS
    {
        pCANMsg->Sig.Tcs_mode = 0;
        pCANMsg->Sig.TCS = 1;
    }
    else if(Tcs == 3)   //禁止TCS
    {
        pCANMsg->Sig.Tcs_mode = 0;
        pCANMsg->Sig.TCS = 0;
    }
    else    //熄灭
    {
        pCANMsg->Sig.Tcs_mode = 1;
        pCANMsg->Sig.TCS = 1;
    }
}

void CAN_Msg_Steps_100ms()
{
    if(Student_Card_can_command==1)
    {
        Student_Card++;
    }
    else
    {
        Student_Card=0;
    }   
    if(Query_Card_can_command==1)
    {
        Query_Card++;
    }
    else
    {
        Query_Card=0;
    }
    
}