
#ifndef RH850_MACROS_H__
#define RH850_MACROS_H__

#include "r_device.h"

/******************************************************************************
Peripheral IRQs(Sort in alphabetical order)
******************************************************************************/
#define   INTADCA0ERR                  ((volatile uint16_t *)&INTC2ICADCA0ERR)
#define   INTADCA0I0                   ((volatile uint16_t *)&INTC1ICADCA0I0)
#define   INTADCA0I1                   ((volatile uint16_t *)&INTC1ICADCA0I1)
#define   INTADCA0I2                   ((volatile uint16_t *)&INTC1ICADCA0I2)
#define   INTADCA0I2_2                 ((volatile uint16_t *)&INTC2ICADCA0I2_2)
#define   INTAPE                       ((volatile uint16_t *)&INTC2ICAPE)
#define   INTCSIG0IC                   ((volatile uint16_t *)&INTC1ICCSIG0IC)
#define   INTCSIG0IC_2                 ((volatile uint16_t *)&INTC2ICCSIG0IC_2)
#define   INTCSIG0IR                   ((volatile uint16_t *)&INTC1ICCSIG0IR)
#define   INTCSIG0IR_2                 ((volatile uint16_t *)&INTC2ICCSIG0IR_2)
#define   INTCSIG0IRE                  ((volatile uint16_t *)&INTC2ICCSIG0IRE)
#define   INTCSIH0IC                   ((volatile uint16_t *)&INTC1ICCSIH0IC)
#define   INTCSIH0IJC                  ((volatile uint16_t *)&INTC2ICCSIH0IJC)
#define   INTCSIH0IJC_1                ((volatile uint16_t *)&INTC1ICCSIH0IJC_1)
#define   INTCSIH0IR                   ((volatile uint16_t *)&INTC1ICCSIH0IR)
#define   INTCSIH0IRE                  ((volatile uint16_t *)&INTC1ICCSIH0IRE)
#define   INTCSIH1IC                   ((volatile uint16_t *)&INTC2ICCSIH1IC)
#define   INTCSIH1IC_1                 ((volatile uint16_t *)&INTC1ICCSIH1IC_1)
#define   INTCSIH1IJC                  ((volatile uint16_t *)&INTC2ICCSIH1IJC)
#define   INTCSIH1IJC_1                ((volatile uint16_t *)&INTC1ICCSIH1IJC_1)
#define   INTCSIH1IR                   ((volatile uint16_t *)&INTC2ICCSIH1IR)
#define   INTCSIH1IR_1                 ((volatile uint16_t *)&INTC1ICCSIH1IR_1)
#define   INTCSIH1IRE                  ((volatile uint16_t *)&INTC2ICCSIH1IRE)
#define   INTCSIH1IRE_1                ((volatile uint16_t *)&INTC1ICCSIH1IRE_1)
#define   INTCSIH2IC                   ((volatile uint16_t *)&INTC2ICCSIH2IC)
#define   INTCSIH2IC_1                 ((volatile uint16_t *)&INTC1ICCSIH2IC_1)
#define   INTCSIH2IJC                  ((volatile uint16_t *)&INTC2ICCSIH2IJC)
#define   INTCSIH2IJC_1                ((volatile uint16_t *)&INTC1ICCSIH2IJC_1)
#define   INTCSIH2IR                   ((volatile uint16_t *)&INTC2ICCSIH2IR)
#define   INTCSIH2IR_1                 ((volatile uint16_t *)&INTC1ICCSIH2IR_1)
#define   INTCSIH2IRE                  ((volatile uint16_t *)&INTC2ICCSIH2IRE)
#define   INTCSIH2IRE_1                ((volatile uint16_t *)&INTC1ICCSIH2IRE_1)
#define   INTCSIH3IC                   ((volatile uint16_t *)&INTC2ICCSIH3IC)
#define   INTCSIH3IC_1                 ((volatile uint16_t *)&INTC1ICCSIH3IC_1)
#define   INTCSIH3IJC                  ((volatile uint16_t *)&INTC2ICCSIH3IJC)
#define   INTCSIH3IJC_1                ((volatile uint16_t *)&INTC1ICCSIH3IJC_1)
#define   INTCSIH3IR                   ((volatile uint16_t *)&INTC2ICCSIH3IR)
#define   INTCSIH3IR_1                 ((volatile uint16_t *)&INTC1ICCSIH3IR_1)
#define   INTCSIH3IRE                  ((volatile uint16_t *)&INTC2ICCSIH3IRE)
#define   INTCSIH3IRE_1                ((volatile uint16_t *)&INTC1ICCSIH3IRE_1)
#define   INTCWEND                     ((volatile uint16_t *)&INTC2ICCWEND)
#define   INTCXP10RI                   ((volatile uint16_t *)&INTC2ICCXP10RI)
#define   INTCXP10SI                   ((volatile uint16_t *)&INTC2ICCXP10SI)
#define   INTCXP10TI                   ((volatile uint16_t *)&INTC2ICCXP10TI)
#define   INTCXP11RI                   ((volatile uint16_t *)&INTC2ICCXP11RI)
#define   INTCXP11SI                   ((volatile uint16_t *)&INTC2ICCXP11SI)
#define   INTCXP11TI                   ((volatile uint16_t *)&INTC2ICCXP11TI)
#define   INTCXP12RI                   ((volatile uint16_t *)&INTC2ICCXP12RI)
#define   INTCXP12SI                   ((volatile uint16_t *)&INTC2ICCXP12SI)
#define   INTCXP12TI                   ((volatile uint16_t *)&INTC2ICCXP12TI)
#define   INTDCUTDI                    ((volatile uint16_t *)&INTC1ICDCUTDI)
#define   INTDMA0                      ((volatile uint16_t *)&INTC2ICDMA0)
#define   INTDMA1                      ((volatile uint16_t *)&INTC2ICDMA1)
#define   INTDMA10                     ((volatile uint16_t *)&INTC2ICDMA10)
#define   INTDMA11                     ((volatile uint16_t *)&INTC2ICDMA11)
#define   INTDMA12                     ((volatile uint16_t *)&INTC2ICDMA12)
#define   INTDMA13                     ((volatile uint16_t *)&INTC2ICDMA13)
#define   INTDMA14                     ((volatile uint16_t *)&INTC2ICDMA14)
#define   INTDMA15                     ((volatile uint16_t *)&INTC2ICDMA15)
#define   INTDMA2                      ((volatile uint16_t *)&INTC2ICDMA2)
#define   INTDMA3                      ((volatile uint16_t *)&INTC2ICDMA3)
#define   INTDMA4                      ((volatile uint16_t *)&INTC2ICDMA4)
#define   INTDMA5                      ((volatile uint16_t *)&INTC2ICDMA5)
#define   INTDMA6                      ((volatile uint16_t *)&INTC2ICDMA6)
#define   INTDMA7                      ((volatile uint16_t *)&INTC2ICDMA7)
#define   INTDMA8                      ((volatile uint16_t *)&INTC2ICDMA8)
#define   INTDMA9                      ((volatile uint16_t *)&INTC2ICDMA9)
#define   INTDPE                       ((volatile uint16_t *)&INTC2ICDPE)
#define   INTENCA0I0                   ((volatile uint16_t *)&INTC2ICENCA0I0)
#define   INTENCA0I1                   ((volatile uint16_t *)&INTC2ICENCA0I1)
#define   INTENCA0IEC                  ((volatile uint16_t *)&INTC2ICENCA0IEC)
#define   INTENCA0IOV                  ((volatile uint16_t *)&INTC2ICENCA0IOV)
#define   INTENCA0IUD                  ((volatile uint16_t *)&INTC2ICENCA0IUD)
#define   INTFLENDNM                   ((volatile uint16_t *)&INTC2ICFLENDNM)
#define   INTFLERR                     ((volatile uint16_t *)&INTC2ICFLERR)
#define   INTKR0                       ((volatile uint16_t *)&INTC2ICKR0)
#define   INTOSTM0                     ((volatile uint16_t *)&INTC2ICOSTM0)
#define   INTP0                        ((volatile uint16_t *)&INTC2ICP0)
#define   INTP1                        ((volatile uint16_t *)&INTC2ICP1)
#define   INTP10                       ((volatile uint16_t *)&INTC2ICP10)
#define   INTP11                       ((volatile uint16_t *)&INTC2ICP11)
#define   INTP12                       ((volatile uint16_t *)&INTC2ICP12)
#define   INTP13                       ((volatile uint16_t *)&INTC2ICP13)
#define   INTP2                        ((volatile uint16_t *)&INTC2ICP2)
#define   INTP3                        ((volatile uint16_t *)&INTC2ICP3)
#define   INTP4                        ((volatile uint16_t *)&INTC2ICP4)
#define   INTP5                        ((volatile uint16_t *)&INTC2ICP5)
#define   INTP6                        ((volatile uint16_t *)&INTC2ICP6)
#define   INTP7                        ((volatile uint16_t *)&INTC2ICP7)
#define   INTP8                        ((volatile uint16_t *)&INTC2ICP8)
#define   INTPWGAG00                   ((volatile uint16_t *)&INTC2ICPWGAG00)
#define   INTPWGAG01                   ((volatile uint16_t *)&INTC2ICPWGAG01)
#define   INTQFULL                     ((volatile uint16_t *)&INTC2ICQFULL)
#define   INTRCAN0ERR                  ((volatile uint16_t *)&INTC1ICRCAN0ERR)
#define   INTRCAN0REC                  ((volatile uint16_t *)&INTC1ICRCAN0REC)
#define   INTRCAN0TRX                  ((volatile uint16_t *)&INTC1ICRCAN0TRX)
#define   INTRCAN1ERR                  ((volatile uint16_t *)&INTC2ICRCAN1ERR)
#define   INTRCAN1REC                  ((volatile uint16_t *)&INTC2ICRCAN1REC)
#define   INTRCAN1TRX                  ((volatile uint16_t *)&INTC2ICRCAN1TRX)
#define   INTRCAN2ERR                  ((volatile uint16_t *)&INTC2ICRCAN2ERR)
#define   INTRCAN2REC                  ((volatile uint16_t *)&INTC2ICRCAN2REC)
#define   INTRCAN2TRX                  ((volatile uint16_t *)&INTC2ICRCAN2TRX)
#define   INTRCAN3ERR                  ((volatile uint16_t *)&INTC2ICRCAN3ERR)
#define   INTRCAN3REC                  ((volatile uint16_t *)&INTC2ICRCAN3REC)
#define   INTRCAN3TRX                  ((volatile uint16_t *)&INTC2ICRCAN3TRX)
#define   INTRCAN4ERR                  ((volatile uint16_t *)&INTC2ICRCAN4ERR)
#define   INTRCAN4REC                  ((volatile uint16_t *)&INTC2ICRCAN4REC)
#define   INTRCAN4TRX                  ((volatile uint16_t *)&INTC2ICRCAN4TRX)
#define   INTRCAN5ERR                  ((volatile uint16_t *)&INTC2ICRCAN5ERR)
#define   INTRCAN5REC                  ((volatile uint16_t *)&INTC2ICRCAN5REC)
#define   INTRCAN5TRX                  ((volatile uint16_t *)&INTC2ICRCAN5TRX)
#define   INTRCANGERR0                 ((volatile uint16_t *)&INTC1ICRCANGERR0)
#define   INTRCANGRECC0                ((volatile uint16_t *)&INTC1ICRCANGRECC0)
#define   INTRIIC0EE                   ((volatile uint16_t *)&INTC2ICRIIC0EE)
#define   INTRIIC0RI                   ((volatile uint16_t *)&INTC2ICRIIC0RI)
#define   INTRIIC0TEI                  ((volatile uint16_t *)&INTC2ICRIIC0TEI)
#define   INTRIIC0TI                   ((volatile uint16_t *)&INTC2ICRIIC0TI)
#define   INTRIIC1EE                   ((volatile uint16_t *)&INTC2ICRIIC1EE)
#define   INTRIIC1RI                   ((volatile uint16_t *)&INTC2ICRIIC1RI)
#define   INTRIIC1TEI                  ((volatile uint16_t *)&INTC2ICRIIC1TEI)
#define   INTRIIC1TI                   ((volatile uint16_t *)&INTC2ICRIIC1TI)
#define   INTRLIN20                    ((volatile uint16_t *)&INTC2ICRLIN20)
#define   INTRLIN21                    ((volatile uint16_t *)&INTC2ICRLIN21)
#define   INTRLIN22                    ((volatile uint16_t *)&INTC2ICRLIN22)
#define   INTRLIN30                    ((volatile uint16_t *)&INTC2ICRLIN30)
#define   INTRLIN30UR0                 ((volatile uint16_t *)&INTC2ICRLIN30UR0)
#define   INTRLIN30UR1                 ((volatile uint16_t *)&INTC2ICRLIN30UR1)
#define   INTRLIN30UR2                 ((volatile uint16_t *)&INTC2ICRLIN30UR2)
#define   INTRLIN31                    ((volatile uint16_t *)&INTC2ICRLIN31)
#define   INTRLIN31UR0                 ((volatile uint16_t *)&INTC2ICRLIN31UR0)
#define   INTRLIN31UR1                 ((volatile uint16_t *)&INTC2ICRLIN31UR1)
#define   INTRLIN31UR2                 ((volatile uint16_t *)&INTC2ICRLIN31UR2)
#define   INTRLIN32                    ((volatile uint16_t *)&INTC2ICRLIN32)
#define   INTRLIN32UR0                 ((volatile uint16_t *)&INTC2ICRLIN32UR0)
#define   INTRLIN32UR1                 ((volatile uint16_t *)&INTC2ICRLIN32UR1)
#define   INTRLIN32UR2                 ((volatile uint16_t *)&INTC2ICRLIN32UR2)
#define   INTRLIN33                    ((volatile uint16_t *)&INTC2ICRLIN33)
#define   INTRLIN33UR0                 ((volatile uint16_t *)&INTC2ICRLIN33UR0)
#define   INTRLIN33UR1                 ((volatile uint16_t *)&INTC2ICRLIN33UR1)
#define   INTRLIN33UR2                 ((volatile uint16_t *)&INTC2ICRLIN33UR2)
#define   INTRTCA01S                   ((volatile uint16_t *)&INTC2ICRTCA01S)
#define   INTRTCA0AL                   ((volatile uint16_t *)&INTC2ICRTCA0AL)
#define   INTRTCA0R                    ((volatile uint16_t *)&INTC2ICRTCA0R)
#define   INTSENT0RI                   ((volatile uint16_t *)&INTC2ICSENT0RI)
#define   INTSENT0SI                   ((volatile uint16_t *)&INTC2ICSENT0SI)
#define   INTSENT1RI                   ((volatile uint16_t *)&INTC2ICSENT1RI)
#define   INTSENT1SI                   ((volatile uint16_t *)&INTC2ICSENT1SI)
#define   INTTAPA0IPEK0                ((volatile uint16_t *)&INTC1ICTAPA0IPEK0)
#define   INTTAPA0IPEK0_2              ((volatile uint16_t *)&INTC2ICTAPA0IPEK0_2)
#define   INTTAPA0IVLY0                ((volatile uint16_t *)&INTC1ICTAPA0IVLY0)
#define   INTTAPA0IVLY0_2              ((volatile uint16_t *)&INTC2ICTAPA0IVLY0_2)
#define   INTTAUB0I0                   ((volatile uint16_t *)&INTC2ICTAUB0I0)
#define   INTTAUB0I1                   ((volatile uint16_t *)&INTC2ICTAUB0I1)
#define   INTTAUB0I10                  ((volatile uint16_t *)&INTC2ICTAUB0I10)
#define   INTTAUB0I11                  ((volatile uint16_t *)&INTC2ICTAUB0I11)
#define   INTTAUB0I12                  ((volatile uint16_t *)&INTC2ICTAUB0I12)
#define   INTTAUB0I13                  ((volatile uint16_t *)&INTC2ICTAUB0I13)
#define   INTTAUB0I14                  ((volatile uint16_t *)&INTC2ICTAUB0I14)
#define   INTTAUB0I15                  ((volatile uint16_t *)&INTC2ICTAUB0I15)
#define   INTTAUB0I2                   ((volatile uint16_t *)&INTC2ICTAUB0I2)
#define   INTTAUB0I3                   ((volatile uint16_t *)&INTC2ICTAUB0I3)
#define   INTTAUB0I4                   ((volatile uint16_t *)&INTC2ICTAUB0I4)
#define   INTTAUB0I5                   ((volatile uint16_t *)&INTC2ICTAUB0I5)
#define   INTTAUB0I6                   ((volatile uint16_t *)&INTC2ICTAUB0I6)
#define   INTTAUB0I7                   ((volatile uint16_t *)&INTC2ICTAUB0I7)
#define   INTTAUB0I8                   ((volatile uint16_t *)&INTC2ICTAUB0I8)
#define   INTTAUB0I9                   ((volatile uint16_t *)&INTC2ICTAUB0I9)
#define   INTTAUD0I0                   ((volatile uint16_t *)&INTC1ICTAUD0I0)
#define   INTTAUD0I0_2                 ((volatile uint16_t *)&INTC2ICTAUD0I0_2)
#define   INTTAUD0I1                   ((volatile uint16_t *)&INTC2ICTAUD0I1)
#define   INTTAUD0I10                  ((volatile uint16_t *)&INTC1ICTAUD0I10)
#define   INTTAUD0I10_2                ((volatile uint16_t *)&INTC2ICTAUD0I10_2)
#define   INTTAUD0I11                  ((volatile uint16_t *)&INTC2ICTAUD0I11)
#define   INTTAUD0I12                  ((volatile uint16_t *)&INTC1ICTAUD0I12)
#define   INTTAUD0I12_2                ((volatile uint16_t *)&INTC2ICTAUD0I12_2)
#define   INTTAUD0I13                  ((volatile uint16_t *)&INTC2ICTAUD0I13)
#define   INTTAUD0I14                  ((volatile uint16_t *)&INTC1ICTAUD0I14)
#define   INTTAUD0I14_2                ((volatile uint16_t *)&INTC2ICTAUD0I14_2)
#define   INTTAUD0I15                  ((volatile uint16_t *)&INTC2ICTAUD0I15)
#define   INTTAUD0I2                   ((volatile uint16_t *)&INTC1ICTAUD0I2)
#define   INTTAUD0I2_2                 ((volatile uint16_t *)&INTC2ICTAUD0I2_2)
#define   INTTAUD0I3                   ((volatile uint16_t *)&INTC2ICTAUD0I3)
#define   INTTAUD0I4                   ((volatile uint16_t *)&INTC1ICTAUD0I4)
#define   INTTAUD0I4_2                 ((volatile uint16_t *)&INTC2ICTAUD0I4_2)
#define   INTTAUD0I5                   ((volatile uint16_t *)&INTC2ICTAUD0I5)
#define   INTTAUD0I6                   ((volatile uint16_t *)&INTC1ICTAUD0I6)
#define   INTTAUD0I6_2                 ((volatile uint16_t *)&INTC2ICTAUD0I6_2)
#define   INTTAUD0I7                   ((volatile uint16_t *)&INTC2ICTAUD0I7)
#define   INTTAUD0I8                   ((volatile uint16_t *)&INTC1ICTAUD0I8)
#define   INTTAUD0I8_2                 ((volatile uint16_t *)&INTC2ICTAUD0I8_2)
#define   INTTAUD0I9                   ((volatile uint16_t *)&INTC2ICTAUD0I9)
#define   INTTAUJ0I0                   ((volatile uint16_t *)&INTC2ICTAUJ0I0)
#define   INTTAUJ0I1                   ((volatile uint16_t *)&INTC2ICTAUJ0I1)
#define   INTTAUJ0I2                   ((volatile uint16_t *)&INTC2ICTAUJ0I2)
#define   INTTAUJ0I3                   ((volatile uint16_t *)&INTC2ICTAUJ0I3)
#define   INTTAUJ1I0                   ((volatile uint16_t *)&INTC2ICTAUJ1I0)
#define   INTTAUJ1I1                   ((volatile uint16_t *)&INTC2ICTAUJ1I1)
#define   INTTAUJ1I2                   ((volatile uint16_t *)&INTC2ICTAUJ1I2)
#define   INTTAUJ1I3                   ((volatile uint16_t *)&INTC2ICTAUJ1I3)
#define   INTTAUJ2I0                   ((volatile uint16_t *)&INTC2ICTAUJ2I0)
#define   INTTAUJ2I1                   ((volatile uint16_t *)&INTC2ICTAUJ2I1)
#define   INTTAUJ2I2                   ((volatile uint16_t *)&INTC2ICTAUJ2I2)
#define   INTTAUJ2I3                   ((volatile uint16_t *)&INTC2ICTAUJ2I3)
#define   INTTAUJ3I0                   ((volatile uint16_t *)&INTC2ICTAUJ3I0)
#define   INTTAUJ3I1                   ((volatile uint16_t *)&INTC2ICTAUJ3I1)
#define   INTTAUJ3I2                   ((volatile uint16_t *)&INTC2ICTAUJ3I2)
#define   INTTAUJ3I3                   ((volatile uint16_t *)&INTC2ICTAUJ3I3)
#define   INTWDTA0                     ((volatile uint16_t *)&INTC2ICWDTA0)
#define   INTWDTA1                     ((volatile uint16_t *)&INTC2ICWDTA1)

/******************************************************************************
Macros
******************************************************************************/
#define   nop()                             __NOP()

#define   software_reset()                  RH850_Software_Reset()
#define   hardware_reset()                  RH850_Hardware_Reset()

#define   enable_interrupt()                __EI()
#define   disable_interrupt()               __DI()

#define   peripheral_IRQ_enable(i)          RH850_Peripheral_IRQ_Enable((i))
#define   peripheral_IRQ_disable(i)         RH850_Peripheral_IRQ_Disable((i))
#define   peripheral_IRQ_flag_clear(i)      RH850_Peripheral_IRQ_Flag_Clear((i))

#define   system_idle()                     RH850_Enter_Idle_Mode()
#define   system_stop()                     RH850_Enter_Stop_Mode()

#define   system_startup_mode()      RH850_Get_startup_mode()

/******************************************************************************
Functions
******************************************************************************/
extern void RH850_Software_Reset(void);
extern void RH850_Hardware_Reset(void);

extern void RH850_Peripheral_IRQ_Enable(volatile uint16_t *pInt);
extern void RH850_Peripheral_IRQ_Disable(volatile uint16_t *pInt);
extern void RH850_Peripheral_IRQ_Flag_Clear(volatile uint16_t *pInt);

extern void RH850_Enter_Idle_Mode(void);
extern void RH850_Enter_Stop_Mode(void);

extern uint8_t RH850_Get_startup_mode(void);

#endif

