/******************************************************************************
 * $Revision: 422 $
 * $Date:: 2017-04-07 15:58:41 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************/
/** \file exceptions.h
 **
 ** Assignment of exception vectors to exception handlers. These vectors will
 ** be set to the BootROM Hardware Interface configuration registers to re-map
 ** the exception vectors of the ARM exception table inside the BootROM.
 **
 ** The default configuration assigns the exception handlers implemented in
 ** exceptions.c. Optionally, user handlers can be assigned.
 **
 ** \note Setting the exception vectors will only work if the high-boot
 **       option is enabled for the R5F core (HIVECS == 1, see ARM TRM). This
 **       means, the exception table is located at 0xFFFF0000, inside the
 **       build-in BootROM.
 **
 ** History:
 **   - 2015-09-01  0.01  HS  Initial version for Traveo
 *****************************************************************************/

#ifndef __EXCEPTIONS_H__
#define __EXCEPTIONS_H__

// File version 0xYYXX = vYY.XX
#define EXCEPTIONS_H_VERSION          0x0001

#ifndef __FILE_VERSION_CHECK__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "base_types.h"

/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define')                           */
/*****************************************************************************/

/** Undefined Instruction Exception Handler */
#define EXCEPTIONS_EXC_HANDLER_UNDEF_INSTR     DefaultUndefinedInstructionExceptionHandler
/** Supervisor Call Exception Handler */
#define EXCEPTIONS_EXC_HANDLER_SVC             DefaultSupervisorCallExceptionHandler
/** Prefetch Abort Exception Handler */
#define EXCEPTIONS_EXC_HANDLER_PABORT          DefaultPrefetchAbortExceptionHandler
/** Data Abort Exception Handler */
#define EXCEPTIONS_EXC_HANDLER_DABORT          DefaultDataAbortExceptionHandler     //DefaultDataAbortExceptionHandler

/** Supervisor Callback Function */
#define EXCEPTIONS_SVC_HANDLER_CB              NULL


/*****************************************************************************/
/* Global type definitions ('typedef')                                       */
/*****************************************************************************/
typedef void (*svc_hdl_func_ptr_t)(uint32_t u32ServiceNumber) ;


/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source)           */
/*****************************************************************************/

/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source)             */
/*****************************************************************************/
extern void Exceptions_Init(void);

#endif /* __FILE_VERSION_CHECK__ */
#endif /* __EXCEPTIONS_H__ */
