

#ifndef BSP_FUELCALCULATE_H_
    #define BSP_FUELCALCULATE_H_
    
    typedef struct  /* qitiancun 2018-8-31 */
    {
        unsigned short  FuelAdValue;
        unsigned short  FuelVrefAdValue;
        unsigned int    Vcc;
        unsigned int    fuelVcpu;
        unsigned short  FuelVrefAdBuf[ 7 ];
        unsigned short  FuelAdBuf[ 7 ];
        unsigned char   FuelAdIndex;
        unsigned char   Resolution;
        unsigned char   Threshold;
        unsigned short  LowVoltageLimit;
        unsigned int    R4;
        unsigned int    R5;
        unsigned int    R6;
        int             VrefAdFilterCount;
        int             FuelAdFilterCount;
    }_AdcResult;

    typedef struct 
    {
        unsigned int    R_Value;
        unsigned char   valid;
    }R_Value_t;

    extern          _AdcResult       g_AdcResult;
    extern          unsigned int     FuelFormula(void);
    extern          R_Value_t        App_CalFuelResistor(unsigned short g_Fuel_VREF_AdcVal,unsigned short g_Fuel_AdcVal,int FilterFactor);
    extern          void             FuelParameterInit(void);
    
#endif /* BSP_FUELCALCULATE_H_ */
