/**************************************************************************//**
  * \file     Sys_Tick.h
  * \brief    System tick timer header file
  * \details
  * \author   Zhang Xuan
  * \version  V1.0.0
  * \date     19-Jul-2018
  * \par      History:
  *           V1.0.0 Initial release
  * \par      Copyright:
  *           (c) Heilongjiang TYW Electronics co., LTD
******************************************************************************/

#ifndef _SYS_TICK_H_
#define _SYS_TICK_H_

/* Includes ------------------------------------------------------------------*/

/* C binding of definitions if building with C++ compiler */
#ifdef __cplusplus
extern  {
#endif

/* Exported types ------------------------------------------------------------*/
/* Sys Tick Interrupt Call Back Function */
typedef void (*Sys_Tick_Int_Call_Back_ptr_t)(void);

/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
#define   SYS_TICK_INT_INTERVAL             (50UL)    /* 50us */

/* Exported functions ------------------------------------------------------- */

extern void Sys_Tick_Timer_Start(void);
extern void Sys_Tick_Timer_Stop(void);
extern void Sys_Tick_Timer_Call_Back_Reg(Sys_Tick_Int_Call_Back_ptr_t pfnCallBack);
extern void Sys_Tick_Timer_ISR(void);

#ifdef __cplusplus
}
#endif

#endif /* _GPIO_H_ */


