#ifndef GPIO_H__
#define GPIO_H__
/*-----------------use for RH850_F1KM_S1 --------------------*/
#include "dr7f701684.dvf.h"
#include "r_typedefs.h"
typedef struct
{
    uint16_t PIN_0 : 1;
    uint16_t PIN_1 : 1;
    uint16_t PIN_2 : 1;
    uint16_t PIN_3 : 1;
    uint16_t PIN_4 : 1;
    uint16_t PIN_5 : 1;
    uint16_t PIN_6 : 1;
    uint16_t PIN_7 : 1;
    uint16_t PIN_8 : 1;
    uint16_t PIN_9 : 1;
    uint16_t PIN_10 : 1;
    uint16_t PIN_11 : 1;
    uint16_t PIN_12 : 1;
    uint16_t PIN_13 : 1;
    uint16_t PIN_14 : 1;
    uint16_t PIN_15 : 1;
} GPIO_Bit_st_t;

typedef union
{
    uint16_t UINT16;
    GPIO_Bit_st_t BIT;
} GPIO_Port_Pin_en_t;

#define PORTPM0_DIR ((volatile GPIO_Port_Pin_en_t *)(&PORTPM0))
#define PORTPM8_DIR ((volatile GPIO_Port_Pin_en_t *)(&PORTPM8))
#define PORTPM9_DIR ((volatile GPIO_Port_Pin_en_t *)(&PORTPM9))
#define PORTPM10_DIR ((volatile GPIO_Port_Pin_en_t *)(&PORTPM10))
#define PORTPM11_DIR ((volatile GPIO_Port_Pin_en_t *)(&PORTPM11))
#define PORTAPM0_DIR ((volatile GPIO_Port_Pin_en_t *)(&PORTAPM0))

#define PORTPM0_IN ((volatile GPIO_Port_Pin_en_t *)(&PORTPPR0))
#define PORTPM8_IN ((volatile GPIO_Port_Pin_en_t *)(&PORTPPR8))
#define PORTPM9_IN ((volatile GPIO_Port_Pin_en_t *)(&PORTPPR9))
#define PORTPM10_IN ((volatile GPIO_Port_Pin_en_t *)(&PORTPPR10))
#define PORTPM11_IN ((volatile GPIO_Port_Pin_en_t *)(&PORTPPR11))
#define PORTAPM0_IN ((volatile GPIO_Port_Pin_en_t *)(&PORTAPPR0))

#define PORTPM0_OUT ((volatile GPIO_Port_Pin_en_t *)(&PORTP0))
#define PORTPM8_OUT ((volatile GPIO_Port_Pin_en_t *)(&PORTP8))
#define PORTPM9_OUT ((volatile GPIO_Port_Pin_en_t *)(&PORTP9))
#define PORTPM10_OUT ((volatile GPIO_Port_Pin_en_t *)(&PORTP10))
#define PORTPM11_OUT ((volatile GPIO_Port_Pin_en_t *)(&PORTP11))
#define PORTAPM0_OUT ((volatile GPIO_Port_Pin_en_t *)(&PORTAP0))

/*************************************************************************************/
/*************************************************************************************/
/*************************************************************************************/

/* --- PORT  Data Direction --- */
/****  PORT P0****/
#define GPIO_DIR_PORT00_PIN00 PORTPM0_DIR->BIT.PIN_0
#define GPIO_DIR_PORT00_PIN01 PORTPM0_DIR->BIT.PIN_1
#define GPIO_DIR_PORT00_PIN02 PORTPM0_DIR->BIT.PIN_2
#define GPIO_DIR_PORT00_PIN03 PORTPM0_DIR->BIT.PIN_3
#define GPIO_DIR_PORT00_PIN04 PORTPM0_DIR->BIT.PIN_4
#define GPIO_DIR_PORT00_PIN05 PORTPM0_DIR->BIT.PIN_5
#define GPIO_DIR_PORT00_PIN06 PORTPM0_DIR->BIT.PIN_6
#define GPIO_DIR_PORT00_PIN07 PORTPM0_DIR->BIT.PIN_7
#define GPIO_DIR_PORT00_PIN08 PORTPM0_DIR->BIT.PIN_8
#define GPIO_DIR_PORT00_PIN09 PORTPM0_DIR->BIT.PIN_9
#define GPIO_DIR_PORT00_PIN10 PORTPM0_DIR->BIT.PIN_10
#define GPIO_DIR_PORT00_PIN11 PORTPM0_DIR->BIT.PIN_11
#define GPIO_DIR_PORT00_PIN12 PORTPM0_DIR->BIT.PIN_12
#define GPIO_DIR_PORT00_PIN13 PORTPM0_DIR->BIT.PIN_13
#define GPIO_DIR_PORT00_PIN14 PORTPM0_DIR->BIT.PIN_14
#define GPIO_DIR_PORT00_PIN15 PORTPM0_DIR->BIT.PIN_15

/****  PORT P8****/
#define GPIO_DIR_PORT08_PIN00 PORTPM8_DIR->BIT.PIN_0
#define GPIO_DIR_PORT08_PIN01 PORTPM8_DIR->BIT.PIN_1
#define GPIO_DIR_PORT08_PIN02 PORTPM8_DIR->BIT.PIN_2
#define GPIO_DIR_PORT08_PIN03 PORTPM8_DIR->BIT.PIN_3
#define GPIO_DIR_PORT08_PIN04 PORTPM8_DIR->BIT.PIN_4
#define GPIO_DIR_PORT08_PIN05 PORTPM8_DIR->BIT.PIN_5
#define GPIO_DIR_PORT08_PIN06 PORTPM8_DIR->BIT.PIN_6
#define GPIO_DIR_PORT08_PIN07 PORTPM8_DIR->BIT.PIN_7
#define GPIO_DIR_PORT08_PIN08 PORTPM8_DIR->BIT.PIN_8
#define GPIO_DIR_PORT08_PIN09 PORTPM8_DIR->BIT.PIN_9
#define GPIO_DIR_PORT08_PIN10 PORTPM8_DIR->BIT.PIN_10
#define GPIO_DIR_PORT08_PIN11 PORTPM8_DIR->BIT.PIN_11
#define GPIO_DIR_PORT08_PIN12 PORTPM8_DIR->BIT.PIN_12
#define GPIO_DIR_PORT08_PIN13 PORTPM8_DIR->BIT.PIN_13
#define GPIO_DIR_PORT08_PIN14 PORTPM8_DIR->BIT.PIN_14
#define GPIO_DIR_PORT08_PIN15 PORTPM8_DIR->BIT.PIN_15

/****  PORT P9****/
#define GPIO_DIR_PORT09_PIN00 PORTPM9_DIR->BIT.PIN_0
#define GPIO_DIR_PORT09_PIN01 PORTPM9_DIR->BIT.PIN_1
#define GPIO_DIR_PORT09_PIN02 PORTPM9_DIR->BIT.PIN_2
#define GPIO_DIR_PORT09_PIN03 PORTPM9_DIR->BIT.PIN_3
#define GPIO_DIR_PORT09_PIN04 PORTPM9_DIR->BIT.PIN_4
#define GPIO_DIR_PORT09_PIN05 PORTPM9_DIR->BIT.PIN_5
#define GPIO_DIR_PORT09_PIN06 PORTPM9_DIR->BIT.PIN_6
#define GPIO_DIR_PORT09_PIN07 PORTPM9_DIR->BIT.PIN_7
#define GPIO_DIR_PORT09_PIN08 PORTPM9_DIR->BIT.PIN_8
#define GPIO_DIR_PORT09_PIN09 PORTPM9_DIR->BIT.PIN_9
#define GPIO_DIR_PORT09_PIN10 PORTPM9_DIR->BIT.PIN_10
#define GPIO_DIR_PORT09_PIN11 PORTPM9_DIR->BIT.PIN_11
#define GPIO_DIR_PORT09_PIN12 PORTPM9_DIR->BIT.PIN_12
#define GPIO_DIR_PORT09_PIN13 PORTPM9_DIR->BIT.PIN_13
#define GPIO_DIR_PORT09_PIN14 PORTPM9_DIR->BIT.PIN_14
#define GPIO_DIR_PORT09_PIN15 PORTPM9_DIR->BIT.PIN_15

/****  PORT P10****/
#define GPIO_DIR_PORT10_PIN00 PORTPM10_DIR->BIT.PIN_0
#define GPIO_DIR_PORT10_PIN01 PORTPM10_DIR->BIT.PIN_1
#define GPIO_DIR_PORT10_PIN02 PORTPM10_DIR->BIT.PIN_2
#define GPIO_DIR_PORT10_PIN03 PORTPM10_DIR->BIT.PIN_3
#define GPIO_DIR_PORT10_PIN04 PORTPM10_DIR->BIT.PIN_4
#define GPIO_DIR_PORT10_PIN05 PORTPM10_DIR->BIT.PIN_5
#define GPIO_DIR_PORT10_PIN06 PORTPM10_DIR->BIT.PIN_6
#define GPIO_DIR_PORT10_PIN07 PORTPM10_DIR->BIT.PIN_7
#define GPIO_DIR_PORT10_PIN08 PORTPM10_DIR->BIT.PIN_8
#define GPIO_DIR_PORT10_PIN09 PORTPM10_DIR->BIT.PIN_9
#define GPIO_DIR_PORT10_PIN10 PORTPM10_DIR->BIT.PIN_10
#define GPIO_DIR_PORT10_PIN11 PORTPM10_DIR->BIT.PIN_11
#define GPIO_DIR_PORT10_PIN12 PORTPM10_DIR->BIT.PIN_12
#define GPIO_DIR_PORT10_PIN13 PORTPM10_DIR->BIT.PIN_13
#define GPIO_DIR_PORT10_PIN14 PORTPM10_DIR->BIT.PIN_14
#define GPIO_DIR_PORT10_PIN15 PORTPM10_DIR->BIT.PIN_15

/****  PORT P11****/
#define GPIO_DIR_PORT11_PIN00 PORTPM11_DIR->BIT.PIN_0
#define GPIO_DIR_PORT11_PIN01 PORTPM11_DIR->BIT.PIN_1
#define GPIO_DIR_PORT11_PIN02 PORTPM11_DIR->BIT.PIN_2
#define GPIO_DIR_PORT11_PIN03 PORTPM11_DIR->BIT.PIN_3
#define GPIO_DIR_PORT11_PIN04 PORTPM11_DIR->BIT.PIN_4
#define GPIO_DIR_PORT11_PIN05 PORTPM11_DIR->BIT.PIN_5
#define GPIO_DIR_PORT11_PIN06 PORTPM11_DIR->BIT.PIN_6
#define GPIO_DIR_PORT11_PIN07 PORTPM11_DIR->BIT.PIN_7
#define GPIO_DIR_PORT11_PIN08 PORTPM11_DIR->BIT.PIN_8
#define GPIO_DIR_PORT11_PIN09 PORTPM11_DIR->BIT.PIN_9
#define GPIO_DIR_PORT11_PIN10 PORTPM11_DIR->BIT.PIN_10
#define GPIO_DIR_PORT11_PIN11 PORTPM11_DIR->BIT.PIN_11
#define GPIO_DIR_PORT11_PIN12 PORTPM11_DIR->BIT.PIN_12
#define GPIO_DIR_PORT11_PIN13 PORTPM11_DIR->BIT.PIN_13
#define GPIO_DIR_PORT11_PIN14 PORTPM11_DIR->BIT.PIN_14
#define GPIO_DIR_PORT11_PIN15 PORTPM11_DIR->BIT.PIN_15
/******PORT   AP0********/
#define GPIO_DIR_APORT00_PIN00 PORTAPM0_DIR->BIT.PIN_0
#define GPIO_DIR_APORT00_PIN01 PORTAPM0_DIR->BIT.PIN_1
#define GPIO_DIR_APORT00_PIN02 PORTAPM0_DIR->BIT.PIN_2
#define GPIO_DIR_APORT00_PIN03 PORTAPM0_DIR->BIT.PIN_3
#define GPIO_DIR_APORT00_PIN04 PORTAPM0_DIR->BIT.PIN_4
#define GPIO_DIR_APORT00_PIN05 PORTAPM0_DIR->BIT.PIN_5
#define GPIO_DIR_APORT00_PIN06 PORTAPM0_DIR->BIT.PIN_6
#define GPIO_DIR_APORT00_PIN07 PORTAPM0_DIR->BIT.PIN_7
#define GPIO_DIR_APORT00_PIN08 PORTAPM0_DIR->BIT.PIN_8
#define GPIO_DIR_APORT00_PIN09 PORTAPM0_DIR->BIT.PIN_9
#define GPIO_DIR_APORT00_PIN10 PORTAPM0_DIR->BIT.PIN_10
#define GPIO_DIR_APORT00_PIN11 PORTAPM0_DIR->BIT.PIN_11
#define GPIO_DIR_APORT00_PIN12 PORTAPM0_DIR->BIT.PIN_12
#define GPIO_DIR_APORT00_PIN13 PORTAPM0_DIR->BIT.PIN_13
#define GPIO_DIR_APORT00_PIN14 PORTAPM0_DIR->BIT.PIN_14
#define GPIO_DIR_APORT00_PIN15 PORTAPM0_DIR->BIT.PIN_15

/* --- PORT  Data Output Value --- */

/****  PORT P0****/
#define GPIO_OUT_PORT00_PIN00 PORTPM0_OUT->BIT.PIN_0
#define GPIO_OUT_PORT00_PIN01 PORTPM0_OUT->BIT.PIN_1
#define GPIO_OUT_PORT00_PIN02 PORTPM0_OUT->BIT.PIN_2
#define GPIO_OUT_PORT00_PIN03 PORTPM0_OUT->BIT.PIN_3
#define GPIO_OUT_PORT00_PIN04 PORTPM0_OUT->BIT.PIN_4
#define GPIO_OUT_PORT00_PIN05 PORTPM0_OUT->BIT.PIN_5
#define GPIO_OUT_PORT00_PIN06 PORTPM0_OUT->BIT.PIN_6
#define GPIO_OUT_PORT00_PIN07 PORTPM0_OUT->BIT.PIN_7
#define GPIO_OUT_PORT00_PIN08 PORTPM0_OUT->BIT.PIN_8
#define GPIO_OUT_PORT00_PIN09 PORTPM0_OUT->BIT.PIN_9
#define GPIO_OUT_PORT00_PIN10 PORTPM0_OUT->BIT.PIN_10
#define GPIO_OUT_PORT00_PIN11 PORTPM0_OUT->BIT.PIN_11
#define GPIO_OUT_PORT00_PIN12 PORTPM0_OUT->BIT.PIN_12
#define GPIO_OUT_PORT00_PIN13 PORTPM0_OUT->BIT.PIN_13
#define GPIO_OUT_PORT00_PIN14 PORTPM0_OUT->BIT.PIN_14
#define GPIO_OUT_PORT00_PIN15 PORTPM0_OUT->BIT.PIN_15

/****  PORT P8****/
#define GPIO_OUT_PORT08_PIN00 PORTPM8_OUT->BIT.PIN_0
#define GPIO_OUT_PORT08_PIN01 PORTPM8_OUT->BIT.PIN_1
#define GPIO_OUT_PORT08_PIN02 PORTPM8_OUT->BIT.PIN_2
#define GPIO_OUT_PORT08_PIN03 PORTPM8_OUT->BIT.PIN_3
#define GPIO_OUT_PORT08_PIN04 PORTPM8_OUT->BIT.PIN_4
#define GPIO_OUT_PORT08_PIN05 PORTPM8_OUT->BIT.PIN_5
#define GPIO_OUT_PORT08_PIN06 PORTPM8_OUT->BIT.PIN_6
#define GPIO_OUT_PORT08_PIN07 PORTPM8_OUT->BIT.PIN_7
#define GPIO_OUT_PORT08_PIN08 PORTPM8_OUT->BIT.PIN_8
#define GPIO_OUT_PORT08_PIN09 PORTPM8_OUT->BIT.PIN_9
#define GPIO_OUT_PORT08_PIN10 PORTPM8_OUT->BIT.PIN_10
#define GPIO_OUT_PORT08_PIN11 PORTPM8_OUT->BIT.PIN_11
#define GPIO_OUT_PORT08_PIN12 PORTPM8_OUT->BIT.PIN_12
#define GPIO_OUT_PORT08_PIN13 PORTPM8_OUT->BIT.PIN_13
#define GPIO_OUT_PORT08_PIN14 PORTPM8_OUT->BIT.PIN_14
#define GPIO_OUT_PORT08_PIN15 PORTPM8_OUT->BIT.PIN_15

/****  PORT P9****/
#define GPIO_OUT_PORT09_PIN00 PORTPM9_OUT->BIT.PIN_0
#define GPIO_OUT_PORT09_PIN01 PORTPM9_OUT->BIT.PIN_1
#define GPIO_OUT_PORT09_PIN02 PORTPM9_OUT->BIT.PIN_2
#define GPIO_OUT_PORT09_PIN03 PORTPM9_OUT->BIT.PIN_3
#define GPIO_OUT_PORT09_PIN04 PORTPM9_OUT->BIT.PIN_4
#define GPIO_OUT_PORT09_PIN05 PORTPM9_OUT->BIT.PIN_5
#define GPIO_OUT_PORT09_PIN06 PORTPM9_OUT->BIT.PIN_6
#define GPIO_OUT_PORT09_PIN07 PORTPM9_OUT->BIT.PIN_7
#define GPIO_OUT_PORT09_PIN08 PORTPM9_OUT->BIT.PIN_8
#define GPIO_OUT_PORT09_PIN09 PORTPM9_OUT->BIT.PIN_9
#define GPIO_OUT_PORT09_PIN10 PORTPM9_OUT->BIT.PIN_10
#define GPIO_OUT_PORT09_PIN11 PORTPM9_OUT->BIT.PIN_11
#define GPIO_OUT_PORT09_PIN12 PORTPM9_OUT->BIT.PIN_12
#define GPIO_OUT_PORT09_PIN13 PORTPM9_OUT->BIT.PIN_13
#define GPIO_OUT_PORT09_PIN14 PORTPM9_OUT->BIT.PIN_14
#define GPIO_OUT_PORT09_PIN15 PORTPM9_OUT->BIT.PIN_15

/****  PORT P10****/
#define GPIO_OUT_PORT10_PIN00 PORTPM10_OUT->BIT.PIN_0
#define GPIO_OUT_PORT10_PIN01 PORTPM10_OUT->BIT.PIN_1
#define GPIO_OUT_PORT10_PIN02 PORTPM10_OUT->BIT.PIN_2
#define GPIO_OUT_PORT10_PIN03 PORTPM10_OUT->BIT.PIN_3
#define GPIO_OUT_PORT10_PIN04 PORTPM10_OUT->BIT.PIN_4
#define GPIO_OUT_PORT10_PIN05 PORTPM10_OUT->BIT.PIN_5
#define GPIO_OUT_PORT10_PIN06 PORTPM10_OUT->BIT.PIN_6
#define GPIO_OUT_PORT10_PIN07 PORTPM10_OUT->BIT.PIN_7
#define GPIO_OUT_PORT10_PIN08 PORTPM10_OUT->BIT.PIN_8
#define GPIO_OUT_PORT10_PIN09 PORTPM10_OUT->BIT.PIN_9
#define GPIO_OUT_PORT10_PIN10 PORTPM10_OUT->BIT.PIN_10
#define GPIO_OUT_PORT10_PIN11 PORTPM10_OUT->BIT.PIN_11
#define GPIO_OUT_PORT10_PIN12 PORTPM10_OUT->BIT.PIN_12
#define GPIO_OUT_PORT10_PIN13 PORTPM10_OUT->BIT.PIN_13
#define GPIO_OUT_PORT10_PIN14 PORTPM10_OUT->BIT.PIN_14
#define GPIO_OUT_PORT10_PIN15 PORTPM10_OUT->BIT.PIN_15

/****  PORT P11****/
#define GPIO_OUT_PORT11_PIN00 PORTPM11_OUT->BIT.PIN_0
#define GPIO_OUT_PORT11_PIN01 PORTPM11_OUT->BIT.PIN_1
#define GPIO_OUT_PORT11_PIN02 PORTPM11_OUT->BIT.PIN_2
#define GPIO_OUT_PORT11_PIN03 PORTPM11_OUT->BIT.PIN_3
#define GPIO_OUT_PORT11_PIN04 PORTPM11_OUT->BIT.PIN_4
#define GPIO_OUT_PORT11_PIN05 PORTPM11_OUT->BIT.PIN_5
#define GPIO_OUT_PORT11_PIN06 PORTPM11_OUT->BIT.PIN_6
#define GPIO_OUT_PORT11_PIN07 PORTPM11_OUT->BIT.PIN_7
#define GPIO_OUT_PORT11_PIN08 PORTPM11_OUT->BIT.PIN_8
#define GPIO_OUT_PORT11_PIN09 PORTPM11_OUT->BIT.PIN_9
#define GPIO_OUT_PORT11_PIN10 PORTPM11_OUT->BIT.PIN_10
#define GPIO_OUT_PORT11_PIN11 PORTPM11_OUT->BIT.PIN_11
#define GPIO_OUT_PORT11_PIN12 PORTPM11_OUT->BIT.PIN_12
#define GPIO_OUT_PORT11_PIN13 PORTPM11_OUT->BIT.PIN_13
#define GPIO_OUT_PORT11_PIN14 PORTPM11_OUT->BIT.PIN_14
#define GPIO_OUT_PORT11_PIN15 PORTPM11_OUT->BIT.PIN_15
/******PORT   AP0********/
#define GPIO_OUT_APORT00_PIN00 PORTAPM0_OUT->BIT.PIN_0
#define GPIO_OUT_APORT00_PIN01 PORTAPM0_OUT->BIT.PIN_1
#define GPIO_OUT_APORT00_PIN02 PORTAPM0_OUT->BIT.PIN_2
#define GPIO_OUT_APORT00_PIN03 PORTAPM0_OUT->BIT.PIN_3
#define GPIO_OUT_APORT00_PIN04 PORTAPM0_OUT->BIT.PIN_4
#define GPIO_OUT_APORT00_PIN05 PORTAPM0_OUT->BIT.PIN_5
#define GPIO_OUT_APORT00_PIN06 PORTAPM0_OUT->BIT.PIN_6
#define GPIO_OUT_APORT00_PIN07 PORTAPM0_OUT->BIT.PIN_7
#define GPIO_OUT_APORT00_PIN08 PORTAPM0_OUT->BIT.PIN_8
#define GPIO_OUT_APORT00_PIN09 PORTAPM0_OUT->BIT.PIN_9
#define GPIO_OUT_APORT00_PIN10 PORTAPM0_OUT->BIT.PIN_10
#define GPIO_OUT_APORT00_PIN11 PORTAPM0_OUT->BIT.PIN_11
#define GPIO_OUT_APORT00_PIN12 PORTAPM0_OUT->BIT.PIN_12
#define GPIO_OUT_APORT00_PIN13 PORTAPM0_OUT->BIT.PIN_13
#define GPIO_OUT_APORT00_PIN14 PORTAPM0_OUT->BIT.PIN_14
#define GPIO_OUT_APORT00_PIN15 PORTAPM0_OUT->BIT.PIN_15

/* --- PORT  Data Input Value --- */
/****  PORT P0****/
#define GPIO_IN_PORT00_PIN00 PORTPM0_IN->BIT.PIN_0
#define GPIO_IN_PORT00_PIN01 PORTPM0_IN->BIT.PIN_1
#define GPIO_IN_PORT00_PIN02 PORTPM0_IN->BIT.PIN_2
#define GPIO_IN_PORT00_PIN03 PORTPM0_IN->BIT.PIN_3
#define GPIO_IN_PORT00_PIN04 PORTPM0_IN->BIT.PIN_4
#define GPIO_IN_PORT00_PIN05 PORTPM0_IN->BIT.PIN_5
#define GPIO_IN_PORT00_PIN06 PORTPM0_IN->BIT.PIN_6
#define GPIO_IN_PORT00_PIN07 PORTPM0_IN->BIT.PIN_7
#define GPIO_IN_PORT00_PIN08 PORTPM0_IN->BIT.PIN_8
#define GPIO_IN_PORT00_PIN09 PORTPM0_IN->BIT.PIN_9
#define GPIO_IN_PORT00_PIN10 PORTPM0_IN->BIT.PIN_10
#define GPIO_IN_PORT00_PIN11 PORTPM0_IN->BIT.PIN_11
#define GPIO_IN_PORT00_PIN12 PORTPM0_IN->BIT.PIN_12
#define GPIO_IN_PORT00_PIN13 PORTPM0_IN->BIT.PIN_13
#define GPIO_IN_PORT00_PIN14 PORTPM0_IN->BIT.PIN_14
#define GPIO_IN_PORT00_PIN15 PORTPM0_IN->BIT.PIN_15

/****  PORT P8****/
#define GPIO_IN_PORT08_PIN00 PORTPM8_IN->BIT.PIN_0
#define GPIO_IN_PORT08_PIN01 PORTPM8_IN->BIT.PIN_1
#define GPIO_IN_PORT08_PIN02 PORTPM8_IN->BIT.PIN_2
#define GPIO_IN_PORT08_PIN03 PORTPM8_IN->BIT.PIN_3
#define GPIO_IN_PORT08_PIN04 PORTPM8_IN->BIT.PIN_4
#define GPIO_IN_PORT08_PIN05 PORTPM8_IN->BIT.PIN_5
#define GPIO_IN_PORT08_PIN06 PORTPM8_IN->BIT.PIN_6
#define GPIO_IN_PORT08_PIN07 PORTPM8_IN->BIT.PIN_7
#define GPIO_IN_PORT08_PIN08 PORTPM8_IN->BIT.PIN_8
#define GPIO_IN_PORT08_PIN09 PORTPM8_IN->BIT.PIN_9
#define GPIO_IN_PORT08_PIN10 PORTPM8_IN->BIT.PIN_10
#define GPIO_IN_PORT08_PIN11 PORTPM8_IN->BIT.PIN_11
#define GPIO_IN_PORT08_PIN12 PORTPM8_IN->BIT.PIN_12
#define GPIO_IN_PORT08_PIN13 PORTPM8_IN->BIT.PIN_13
#define GPIO_IN_PORT08_PIN14 PORTPM8_IN->BIT.PIN_14
#define GPIO_IN_PORT08_PIN15 PORTPM8_IN->BIT.PIN_15

/****  PORT P9****/
#define GPIO_IN_PORT09_PIN00 PORTPM9_IN->BIT.PIN_0
#define GPIO_IN_PORT09_PIN01 PORTPM9_IN->BIT.PIN_1
#define GPIO_IN_PORT09_PIN02 PORTPM9_IN->BIT.PIN_2
#define GPIO_IN_PORT09_PIN03 PORTPM9_IN->BIT.PIN_3
#define GPIO_IN_PORT09_PIN04 PORTPM9_IN->BIT.PIN_4
#define GPIO_IN_PORT09_PIN05 PORTPM9_IN->BIT.PIN_5
#define GPIO_IN_PORT09_PIN06 PORTPM9_IN->BIT.PIN_6
#define GPIO_IN_PORT09_PIN07 PORTPM9_IN->BIT.PIN_7
#define GPIO_IN_PORT09_PIN08 PORTPM9_IN->BIT.PIN_8
#define GPIO_IN_PORT09_PIN09 PORTPM9_IN->BIT.PIN_9
#define GPIO_IN_PORT09_PIN10 PORTPM9_IN->BIT.PIN_10
#define GPIO_IN_PORT09_PIN11 PORTPM9_IN->BIT.PIN_11
#define GPIO_IN_PORT09_PIN12 PORTPM9_IN->BIT.PIN_12
#define GPIO_IN_PORT09_PIN13 PORTPM9_IN->BIT.PIN_13
#define GPIO_IN_PORT09_PIN14 PORTPM9_IN->BIT.PIN_14
#define GPIO_IN_PORT09_PIN15 PORTPM9_IN->BIT.PIN_15

/****  PORT P10****/
#define GPIO_IN_PORT10_PIN00 PORTPM10_IN->BIT.PIN_0
#define GPIO_IN_PORT10_PIN01 PORTPM10_IN->BIT.PIN_1
#define GPIO_IN_PORT10_PIN02 PORTPM10_IN->BIT.PIN_2
#define GPIO_IN_PORT10_PIN03 PORTPM10_IN->BIT.PIN_3
#define GPIO_IN_PORT10_PIN04 PORTPM10_IN->BIT.PIN_4
#define GPIO_IN_PORT10_PIN05 PORTPM10_IN->BIT.PIN_5
#define GPIO_IN_PORT10_PIN06 PORTPM10_IN->BIT.PIN_6
#define GPIO_IN_PORT10_PIN07 PORTPM10_IN->BIT.PIN_7
#define GPIO_IN_PORT10_PIN08 PORTPM10_IN->BIT.PIN_8
#define GPIO_IN_PORT10_PIN09 PORTPM10_IN->BIT.PIN_9
#define GPIO_IN_PORT10_PIN10 PORTPM10_IN->BIT.PIN_10
#define GPIO_IN_PORT10_PIN11 PORTPM10_IN->BIT.PIN_11
#define GPIO_IN_PORT10_PIN12 PORTPM10_IN->BIT.PIN_12
#define GPIO_IN_PORT10_PIN13 PORTPM10_IN->BIT.PIN_13
#define GPIO_IN_PORT10_PIN14 PORTPM10_IN->BIT.PIN_14
#define GPIO_IN_PORT10_PIN15 PORTPM10_IN->BIT.PIN_15

/****  PORT P11****/
#define GPIO_IN_PORT11_PIN00 PORTPM11_IN->BIT.PIN_0
#define GPIO_IN_PORT11_PIN01 PORTPM11_IN->BIT.PIN_1
#define GPIO_IN_PORT11_PIN02 PORTPM11_IN->BIT.PIN_2
#define GPIO_IN_PORT11_PIN03 PORTPM11_IN->BIT.PIN_3
#define GPIO_IN_PORT11_PIN04 PORTPM11_IN->BIT.PIN_4
#define GPIO_IN_PORT11_PIN05 PORTPM11_IN->BIT.PIN_5
#define GPIO_IN_PORT11_PIN06 PORTPM11_IN->BIT.PIN_6
#define GPIO_IN_PORT11_PIN07 PORTPM11_IN->BIT.PIN_7
#define GPIO_IN_PORT11_PIN08 PORTPM11_IN->BIT.PIN_8
#define GPIO_IN_PORT11_PIN09 PORTPM11_IN->BIT.PIN_9
#define GPIO_IN_PORT11_PIN10 PORTPM11_IN->BIT.PIN_10
#define GPIO_IN_PORT11_PIN11 PORTPM11_IN->BIT.PIN_11
#define GPIO_IN_PORT11_PIN12 PORTPM11_IN->BIT.PIN_12
#define GPIO_IN_PORT11_PIN13 PORTPM11_IN->BIT.PIN_13
#define GPIO_IN_PORT11_PIN14 PORTPM11_IN->BIT.PIN_14
#define GPIO_IN_PORT11_PIN15 PORTPM11_IN->BIT.PIN_15
/******PORT   AP0********/
#define GPIO_IN_APORT00_PIN00 PORTAPM0_IN->BIT.PIN_0
#define GPIO_IN_APORT00_PIN01 PORTAPM0_IN->BIT.PIN_1
#define GPIO_IN_APORT00_PIN02 PORTAPM0_IN->BIT.PIN_2
#define GPIO_IN_APORT00_PIN03 PORTAPM0_IN->BIT.PIN_3
#define GPIO_IN_APORT00_PIN04 PORTAPM0_IN->BIT.PIN_4
#define GPIO_IN_APORT00_PIN05 PORTAPM0_IN->BIT.PIN_5
#define GPIO_IN_APORT00_PIN06 PORTAPM0_IN->BIT.PIN_6
#define GPIO_IN_APORT00_PIN07 PORTAPM0_IN->BIT.PIN_7
#define GPIO_IN_APORT00_PIN08 PORTAPM0_IN->BIT.PIN_8
#define GPIO_IN_APORT00_PIN09 PORTAPM0_IN->BIT.PIN_9
#define GPIO_IN_APORT00_PIN10 PORTAPM0_IN->BIT.PIN_10
#define GPIO_IN_APORT00_PIN11 PORTAPM0_IN->BIT.PIN_11
#define GPIO_IN_APORT00_PIN12 PORTAPM0_IN->BIT.PIN_12
#define GPIO_IN_APORT00_PIN13 PORTAPM0_IN->BIT.PIN_13
#define GPIO_IN_APORT00_PIN14 PORTAPM0_IN->BIT.PIN_14
#define GPIO_IN_APORT00_PIN15 PORTAPM0_IN->BIT.PIN_15
/***************************************************************/
/***************************************************************/
typedef enum
{
    GPIO_PORT_GROUP_0 = 0U,
    GPIO_PORT_GROUP_8 = 8U,
    GPIO_PORT_GROUP_9 = 9U,
    GPIO_PORT_GROUP_10 = 10U,
    GPIO_PORT_GROUP_11 = 11U,
    GPIO_PORT_GROUP_AP0 = 50U,

} GPIO_Port_en_t;
typedef enum
{
    GPIO_PIN_0 = 0X0U,
    GPIO_PIN_1,
    GPIO_PIN_2,
    GPIO_PIN_3,
    GPIO_PIN_4,
    GPIO_PIN_5,
    GPIO_PIN_6,
    GPIO_PIN_7,
    GPIO_PIN_8,
    GPIO_PIN_9,
    GPIO_PIN_10,
    GPIO_PIN_11,
    GPIO_PIN_12,
    GPIO_PIN_13,
    GPIO_PIN_14,
    GPIO_PIN_15,
} GPIO_PIN_en_t;

typedef enum
{
    GPIO_Input_Buf_Close = 0U,
    GPIO_Input_Buf_Open,
} GPIO_Buf_Control_en_t;

typedef enum
{
    GPIO_MODE_PORT = 0U,
    GPIO_MODE_ALTER_SOFTWARE,
    GPIO_MODE_ALTER_DIRECT,
} GPIO_Mode_en_t;

typedef enum
{
    GPIO_ALTER_FUN_1 = 0U,
    GPIO_ALTER_FUN_2,
    GPIO_ALTER_FUN_3,
    GPIO_ALTER_FUN_4,
    GPIO_ALTER_FUN_5,
    GPIO_ALTER_FUN_6,
    GPIO_ALTER_FUN_7,
} GPIO_Alter_Fuction_en_t;

typedef enum
{
    GPIO_DIR_OUT = 0U,
    GPIO_DIR_IN
} GPIO_Direction_en_t;
typedef enum
{
    GPIO_Level_Low = 0U,
    GPIO_Level_High,
} GPIO_Level_en_t;
typedef enum
{
    GPIO_PULL_NONE = 0U,
    GPIO_PULL_UP,
    GPIO_PULL_DOWN,
} GPIO_Pull_en_t;
typedef enum
{
    GPIO_Drive_Slow = 0U,
    GPIO_Drive_Fast,
} GPIO_Strength_en_t;
typedef enum
{
    GPIO_Char_Schmitt1 = 0UL,
    GPIO_Char_Schmitt4,
} GPIO_Characteristics_en_t;

typedef struct
{
    GPIO_Port_en_t enGPIOPort;
    GPIO_PIN_en_t enGPIOPIN;
    GPIO_Characteristics_en_t enGPIOCharacter;
    GPIO_Pull_en_t enGPIOPull;
    GPIO_Level_en_t enGPIOOutputValue;
    GPIO_Mode_en_t enGPIOMode;
    GPIO_Direction_en_t enGPIODir;
    GPIO_Alter_Fuction_en_t enGPIOAltFun;

} GPIO_Config_st_t;

typedef enum
{
    GPIO_WAKEUP_MODE = 0U,
    GPIO_SLEEP_MODE,

} GPIO_Config_Mode_en_t;

typedef enum
{

    GPIO_WAKEUP_PIN_P0_1 = 0X00U,
    GPIO_WAKEUP_PIN_P0_2 = 0X01U,
    /*Only one of P0_5 and P0_6 can be used*/
    GPIO_WAKEUP_PIN_P0_5 = 0X02U,
    GPIO_WAKEUP_PIN_P0_6 = 0X02U,
    /*Only one of P0_7 and P0_10 can be used*/
    GPIO_WAKEUP_PIN_P0_7 = 0X03U,
    GPIO_WAKEUP_PIN_P0_10 = 0X03U,
    GPIO_WAKEUP_PIN_P0_9 = 0X04U,
    GPIO_WAKEUP_PIN_P8_0 = 0X04U,
    GPIO_WAKEUP_PIN_P0_13 = 0X05U,
    GPIO_WAKEUP_PIN_P8_1 = 0X05U,
    GPIO_WAKEUP_PIN_P0_3 = 0X0AU,
    GPIO_WAKEUP_PIN_P0_4 = 0X0BU,
    GPIO_WAKEUP_PIN_P8_2 = 0X06U,
    GPIO_WAKEUP_PIN_P8_3 = 0X07U,
    GPIO_WAKEUP_PIN_P8_4 = 0X08U,

} GPIO_Wakeup_PIN_en_t;
typedef enum
{
    GPIO_WAKEUP_NONE = 0X0U,
    GPIO_WAKEUP_RISING_EDGE,
    GPIO_WAKEUP_FALLING_EDGE,
    GPIO_WAKEUP_BOTH_EDGE,
    GPIO_WAKEUP_LOW_LEVEL,
    GPIO_WAKEUP_HIGH_LEVEL,

} GPIO_Wakeup_Trigger_Mode_en_t;

/**/
extern void GPIO_Init(GPIO_Config_Mode_en_t enGPIOConfigMode);
extern void GPIO_Wakeup_PIN_Set(GPIO_Wakeup_PIN_en_t enGPIOWakeupPIN, GPIO_Wakeup_Trigger_Mode_en_t enGPIOTrigger);
extern void GPIO_Config(GPIO_Config_st_t *pstGPIOConfig);
extern void GPIO_SET_KEPP(void);

#endif
