#include "RTE_CAN.h"
#include "CAN_Lib.h"
#include "CAN_APP.h"
#include "CAN_Communication_Matrix.h"
#include "Analog_Signals.h"
#include "RSCAN.h"
#include "Check_Ctrl.h"
#include "Display_Info.h"
#include "RTE_GPIO.h"
extern uint8_t cycleflag;
const uint8_t crc8_table[256] = {
    0x00, 0x1D, 0x3A, 0x27, 0x74, 0x69, 0x4E, 0x53, 0xE8, 0xF5, 0xD2, 0xCF, 0x9C, 0x81, 0xA6, 0xBB,
    0xCD, 0xD0, 0xF7, 0xEA, 0xB9, 0xA4, 0x83, 0x9E, 0x25, 0x38, 0x1F, 0x02, 0x51, 0x4C, 0x6B, 0x76,
    0x87, 0x9A, 0xBD, 0xA0, 0xF3, 0xEE, 0xC9, 0xD4, 0x6F, 0x72, 0x55, 0x48, 0x1B, 0x06, 0x21, 0x3C,
    0x4A, 0x57, 0x70, 0x6D, 0x3E, 0x23, 0x04, 0x19, 0xA2, 0xBF, 0x98, 0x85, 0xD6, 0xCB, 0xEC, 0xF1,
    0x13, 0x0E, 0x29, 0x34, 0x67, 0x7A, 0x5D, 0x40, 0xFB, 0xE6, 0xC1, 0xDC, 0x8F, 0x92, 0xB5, 0xA8,
    0xDE, 0xC3, 0xE4, 0xF9, 0xAA, 0xB7, 0x90, 0x8D, 0x36, 0x2B, 0x0C, 0x11, 0x42, 0x5F, 0x78, 0x65,
    0x94, 0x89, 0xAE, 0xB3, 0xE0, 0xFD, 0xDA, 0xC7, 0x7C, 0x61, 0x46, 0x5B, 0x08, 0x15, 0x32, 0x2F,
    0x59, 0x44, 0x63, 0x7E, 0x2D, 0x30, 0x17, 0x0A, 0xB1, 0xAC, 0x8B, 0x96, 0xC5, 0xD8, 0xFF, 0xE2,
    0x26, 0x3B, 0x1C, 0x01, 0x52, 0x4F, 0x68, 0x75, 0xCE, 0xD3, 0xF4, 0xE9, 0xBA, 0xA7, 0x80, 0x9D,
    0xEB, 0xF6, 0xD1, 0xCC, 0x9F, 0x82, 0xA5, 0xB8, 0x03, 0x1E, 0x39, 0x24, 0x77, 0x6A, 0x4D, 0x50,
    0xA1, 0xBC, 0x9B, 0x86, 0xD5, 0xC8, 0xEF, 0xF2, 0x49, 0x54, 0x73, 0x6E, 0x3D, 0x20, 0x07, 0x1A,
    0x6C, 0x71, 0x56, 0x4B, 0x18, 0x05, 0x22, 0x3F, 0x84, 0x99, 0xBE, 0xA3, 0xF0, 0xED, 0xCA, 0xD7,
    0x35, 0x28, 0x0F, 0x12, 0x41, 0x5C, 0x7B, 0x66, 0xDD, 0xC0, 0xE7, 0xFA, 0xA9, 0xB4, 0x93, 0x8E,
    0xF8, 0xE5, 0xC2, 0xDF, 0x8C, 0x91, 0xB6, 0xAB, 0x10, 0x0D, 0x2A, 0x37, 0x64, 0x79, 0x5E, 0x43,
    0xB2, 0xAF, 0x88, 0x95, 0xC6, 0xDB, 0xFC, 0xE1, 0x5A, 0x47, 0x60, 0x7D, 0x2E, 0x33, 0x14, 0x09,
    0x7F, 0x62, 0x45, 0x58, 0x0B, 0x16, 0x31, 0x2C, 0x97, 0x8A, 0xAD, 0xB0, 0xE3, 0xFE, 0xD9, 0xC4
};
uint8_t CRC8_CheckSum(uint8_t data[], uint8_t len)    
{
    uint8_t crc = 0xFFu;  // 初始值为0xFF

    for (uint8_t i = 0; i < len; i++) {
        crc = crc8_table[crc ^ data[i]];  // 逐字节查表
    }
    
    return crc ^ 0xFFu;  // 最终异或0xFF
}
uint8_t CrcCheckSum(uint8_t *data, uint8_t len)
{
    uint8_t crc        = 0xff;
    uint8_t CRC_POLY   = 0x2f;
    uint8_t crcxor     = 0xff;
    uint8_t bit_index  = 0;
    uint8_t byte_index = 0;

    for ( byte_index = 0; byte_index < len; ++byte_index )
    {
        crc ^= data [ byte_index ];
        for ( bit_index = 0; bit_index < 8; ++bit_index )
        {
            if ( (crc & 0x80) != 0 )
                crc = (crc << 1) ^ CRC_POLY;
            else
                crc = (crc << 1);
        }
    }

    crc = crc ^ crcxor;

    return crc;
}

void Can_Write_Fun_APP(void)
{
}

void Can_Abort_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
}

void CAN_QuickTimer_Init(void)
{
}

void NODE_26D_SET_Confirm(void)
{
}

void Can_BusOff_Fun(void)
{
}

void Can_BusOffRecover(void)
{
}

void Can_Set_Buff_260(uint8_t CopyData [])
{

}

void Can_Set_Buff_280(uint8_t CopyData [])
{

}

void Can_Set_Buff_380(uint8_t CopyData [])
{

}

void Can_Set_Buff_385(uint8_t CopyData [])
{

}

void Can_Set_Buff_52E(uint8_t CopyData [])
{

}

void Can_Set_Buff_69B(uint8_t CopyData [])
{

}

void Can_Set_Buff_28A(uint8_t CopyData [])
{

}

void Can_Set_Buff_2E1(uint8_t CopyData [])
{

}
void Can_Set_Buff_228(uint8_t CopyData [])
{

}

void Can_Set_Buff_211(uint8_t CopyData [])
{

}
void Can_Set_Buff_341(uint8_t CopyData [])
{

}
void Can_Set_Buff_128(uint8_t CopyData [])
{

}
void Can_Set_Buff_24A(uint8_t CopyData [])
{

}
void Can_Set_Buff_35A(uint8_t CopyData [])
{

}

void Can_Set_Buff_135(uint8_t CopyData [])
{

}
void Can_Set_Buff_153(uint8_t CopyData [])
{

}
void Can_Set_Buff_131(uint8_t CopyData [])
{

}
void Can_Set_Buff_139(uint8_t CopyData [])
{

}
void Can_Set_Buff_431(uint8_t CopyData [])
{

}
void Can_Set_Buff_5e0(uint8_t CopyData [])
{

}
void Can_Set_Buff_236(uint8_t CopyData [])
{

}

void Can_Set_Buff_168(uint8_t CopyData [])
{

}
void Can_Set_Buff_0F6(uint8_t CopyData [])
{

}
void Can_Set_Buff_0E1(uint8_t CopyData [])
{

}
void Can_Set_Buff_036(uint8_t CopyData [])
{

}

void Can_Set_Buff_0B6(uint8_t CopyData [])
{

}

void Can_Set_Buff_320(uint8_t CopyData [])
{

}

void Can_Set_Buff_152(uint8_t CopyData [])
{

}

void Can_Set_Buff_1A1(uint8_t CopyData [])
{

}

void Can_Set_Buff_75F(uint8_t CopyData [])
{
}

void Can_Set_Buff_389(uint8_t CopyData [])
{

}
void init_CAN_Frame(CAN_Frame_st_t* msg, uint32_t can_id, uint8_t can_len, uint8_t can_frame_ide, const uint8_t* data)
{
    for (uint32_t i = 0; i < can_len; i++) {
        msg->unCANData.u8CANData[i] = 0;
    }

    msg->u32CANID = can_id;
    msg->u8CANLEN = can_len;
    // msg->u8CANFrameIDE = can_frame_ide;
    msg->u8CANFrameIDE = 0;
    for (uint32_t i = 0; i < can_len; i++) {
        msg->unCANData.u8CANData[i] = data[i];
    }
}

void can_mid(CAN_Frame_st_t Msg)
{
    CAN_Frame_st_t m_msg;

    init_CAN_Frame(&m_msg, Msg.u32CANID, Msg.u8CANLEN, Msg.u8CANFrameIDE, Msg.unCANData.u8CANData);

    RSCAN0_CH4_Set_FIFO0_Data(&m_msg);
}
uint8_t rolaconter = 0;
void can_submit(void)
{
    //车速
    CAN_Frame_st_t m_msg1;// 车速 母线电流
    uint8_t data1[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C20FFD2


    //氛围灯
    CAN_Frame_st_t m_msg2;// 氛围灯 报警器报警状态 整车状态 自动大灯功能设置
    uint8_t data2[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C10FFD3
    CAN_Frame_st_t m_msg3;// 氛围灯 整车操作状态反馈
    uint8_t data3[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C22FFD2


    //时间
    CAN_Frame_st_t m_msg4;
    uint8_t data4[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C50FFD0


    //功率
    CAN_Frame_st_t m_msg5;// 总电池电压
    uint8_t data5[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C10FFD1

    //故障灯
    CAN_Frame_st_t m_msg6;
    uint8_t data6[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C50FFD2

    CAN_Frame_st_t m_msg8;
    uint8_t data8[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C50FFD2

    CAN_Frame_st_t m_msg9;
    uint8_t data9[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C50FFD2
    if(MENU_CHECK_STEP == 0)
    {
        /* N档 */
        data6[4] = 0x00;
        init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);
        /* TCS */
        data3[4] = 0x00;
        init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);
    }
    switch (MENU_CHECK_STEP)
    {
        case 1:
            /* 车速 */  
            data1[0] = 0x37;
            data1[1] = 0xE0;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0x0F;
            data2[1] = 0xA0;

            /* 水温开路 */
            data2[4] = 0x09;
            data2[5] = 0x1A;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x00;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data4[1] = 0x00;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x00;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x01;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x00;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0x01;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 2:
            /* 车速 */  
            data1[0] = 0x3D;
            data1[1] = 0xA8;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0x2E;
            data2[1] = 0xE0;

            /* 水温1格 */  
            data2[4] = 0x0B;
            data2[5] = 0x0E;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x00;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data4[1] = 0x00;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x00;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x02;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x00;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0x28;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 3:
            /* 车速 */  
            data1[0] = 0x43;
            data1[1] = 0x38;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0x4E;
            data2[1] = 0x20;

            /* 水温2格 */  
            data2[4] = 0x0D;
            data2[5] = 0x02;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x00;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data4[1] = 0x00;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x00;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x03;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x00;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0xA0;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 4:
            /* 车速 */  
            data1[0] = 0x48;
            data1[1] = 0xE8;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0x6D;
            data2[1] = 0x60;

            /* 水温3格 */  
            data2[4] = 0x0D;
            data2[5] = 0xCA;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x00;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data4[1] = 0x00;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x00;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x04;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x00;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0xC4;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 5:
            /* 车速 */  
            data1[0] = 0x4E;
            data1[1] = 0x22;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0x8C;
            data2[1] = 0xA0;

            /* 水温4格 */  
            data2[4] = 0x0E;
            data2[5] = 0x60;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x00;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data4[1] = 0x00;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x00;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x05;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x00;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0xD0;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 6:
            /* 车速 */  
            data1[0] = 0x53;
            data1[1] = 0xE8;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0xAB;
            data2[1] = 0xE0;

            /* 水温5格 */  
            data2[4] = 0x0E;
            data2[5] = 0xC4;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x00;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data4[1] = 0x00;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x00;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x06;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x00;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0xDA;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 7:
            /* 车速 */  
            data1[0] = 0x59;
            data1[1] = 0x40;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0xBB;
            data2[1] = 0x80;

            /* 水温6格 */  
            data2[4] = 0x0F;
            data2[5] = 0x28;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x00;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data4[1] = 0x00;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x00;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x06;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x00;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0xDA;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 8:
            /* 车速 */  
            data1[0] = 0x5F;
            data1[1] = 0x00;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0xBB;
            data2[1] = 0x80;

            /* 水温6格 */  
            data2[4] = 0x0F;
            data2[5] = 0x28;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x04;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data4[1] = 0x00;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x00;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x06;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x00;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0xDA;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 9:
            /* 车速 */  
            data1[0] = 0x6E;
            data1[1] = 0x90;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0xBB;
            data2[1] = 0x80;

            /* 水温6格 */  
            data2[4] = 0x0F;
            data2[5] = 0x28;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x00;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data4[1] = 0x02;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x00;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x06;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x00;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0xDA;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 10:
            /* 车速 */  
            data1[0] = 0x6E;
            data1[1] = 0x90;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0xBB;
            data2[1] = 0x80;

            /* 水温6格 */  
            data2[4] = 0x0F;
            data2[5] = 0x28;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x00;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data4[1] = 0x04;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x00;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x06;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x00;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0xDA;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 11:
           /* 车速 */  
            data1[0] = 0x6E;
            data1[1] = 0x90;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0xBB;
            data2[1] = 0x80;

            /* 水温6格 */  
            data2[4] = 0x0F;
            data2[5] = 0x28;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x00;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data4[1] = 0x00;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x01;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x06;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x00;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0xDA;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 12:
            /* 车速 */  
            data1[0] = 0x6E;
            data1[1] = 0x90;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0xBB;
            data2[1] = 0x80;

            /* 水温6格 */  
            data2[4] = 0x0F;
            data2[5] = 0x28;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x00;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data4[1] = 0x00;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x00;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x06;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x02;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0xDA;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 13:
            /* 车速 */  
            data1[0] = 0x6E;
            data1[1] = 0x90;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0xBB;
            data2[1] = 0x80;

            /* 水温6格 */  
            data2[4] = 0x0F;
            data2[5] = 0x28;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x00;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data5[0] = 0x00;
            data5[1] = 0x00;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x00;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x06;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x00;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0xDA;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 14:
            /* 车速 */  
            data1[0] = 0x6E;
            data1[1] = 0x90;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0xBB;
            data2[1] = 0x80;

            /* 水温6格 */  
            data2[4] = 0x0F;
            data2[5] = 0x28;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x00;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯 */
            data4[1] = 0x00;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x00;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x06;
            data6[1] = 0x00;
            /* S档 */
            data6[4] = 0x00;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0xDA;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        case 15:
            /* 车速 */  
            data1[0] = 0x6E;
            data1[1] = 0x90;
            init_CAN_Frame(&m_msg1, 0x141, 8, 1, data1);

            /* 转速 */  
            data2[0] = 0xBB;
            data2[1] = 0x80;

            /* 水温6格 */  
            data2[4] = 0x0F;
            data2[5] = 0x28;
            init_CAN_Frame(&m_msg2, 0x101, 8, 1, data2);

            /* TCS */
            data3[4] = 0x04;
            init_CAN_Frame(&m_msg3, 0x402, 8, 1, data3);

            /* 变速箱指示灯/变速箱故障指示灯 */
            data4[1] = 0x06;
            init_CAN_Frame(&m_msg4, 0x322, 8, 1, data4);

            /* 故障码TCU指示灯 */
            data5[2] = 0x01;
            init_CAN_Frame(&m_msg5, 0x323, 8, 1, data5);

            /* D档 */
            data6[0] = 0x06;
            data6[1] = 0x10;
            /* S档 */
            data6[4] = 0x02;
            init_CAN_Frame(&m_msg6, 0x321, 8, 1, data6);

            /* 水温指示灯 */
            data9[7] = 0xDA;
            init_CAN_Frame(&m_msg9, 0x240, 8, 1, data9);
            break;
        default:
            break;
    }
    if(MENU_CHECK_STEP != 0 && MENU_CHECK_STEP <= 15)
    {
        can_mid(m_msg1);
        can_mid(m_msg2);
        can_mid(m_msg3);
        can_mid(m_msg4);
        can_mid(m_msg5);
        can_mid(m_msg6);
        can_mid(m_msg9);
    }
    else if(MENU_CHECK_STEP == 0)
    {
        can_mid(m_msg3);
        can_mid(m_msg6);
    }
}
uint8_t u8get714msg[8];
uint8_t u8getuidmsg[8];
uint8_t u8getUIDmsg[8];
uint8_t SWtestresult = 0;
uint8_t HWtestresult = 0;
uint8_t PNtestresult = 0;
uint8_t ruanjianbanbenhao[7];
uint8_t yingjianbanbenhao[7];
uint8_t lingjianhao[19];
uint8_t UIDcode1[33];
uint8_t UIDcode2[33];
uint8_t zhenduanstep = 0;
extern uint8_t getmsgfinish;
extern uint32_t send0x714time;
uint8_t readstopflag;
uint8_t begin714;
uint8_t UIDdelay;
uint8_t swbegin;
uint8_t hwbegin;
uint8_t pnbegin;
uint8_t swtimebegin;
void send_uid_fuc()
{
    CAN_Frame_st_t m_msg7;
    uint8_t data7[8] = {0, 0, 0, 0, 0, 0, 0, 0};

    switch (zhenduanstep)
    {
        case 0:
            if(UIDdelay < 10)
            {
                UIDdelay++;
            }
            else
            {
                data7[0] = 0x03;
                data7[1] = 0x22;
                data7[2] = 0xF1;
                data7[3] = 0x95;
                data7[4] = 0xAA;
                data7[5] = 0xAA;
                data7[6] = 0xAA;
                data7[7] = 0xAA;
                init_CAN_Frame(&m_msg7, 0x660, 8, 1, data7);
                can_mid(m_msg7);
                swbegin = 1;
                zhenduanstep++;
            }
            break;
        case 1:
                data7[0] = 0x30;
                data7[1] = 0x00;
                data7[2] = 0x00;
                data7[3] = 0xAA;
                data7[4] = 0xAA;
                data7[5] = 0xAA;
                data7[6] = 0xAA;
                data7[7] = 0xAA;
                init_CAN_Frame(&m_msg7, 0x660, 8, 1, data7); 
                can_mid(m_msg7);
                zhenduanstep++;
            break;
        case 2:
                data7[0] = 0x03;
                data7[1] = 0x22;
                data7[2] = 0xF1;
                data7[3] = 0x93;
                data7[4] = 0xAA;
                data7[5] = 0xAA;
                data7[6] = 0xAA;
                data7[7] = 0xAA;
                init_CAN_Frame(&m_msg7, 0x660, 8, 1, data7); 
                can_mid(m_msg7);
                swbegin = 0;
                hwbegin = 1;
                zhenduanstep++;
            break;
        case 3:
                data7[0] = 0x30;
                data7[1] = 0x00;
                data7[2] = 0x00;
                data7[3] = 0xAA;
                data7[4] = 0xAA;
                data7[5] = 0xAA;
                data7[6] = 0xAA;
                data7[7] = 0xAA;
                init_CAN_Frame(&m_msg7, 0x660, 8, 1, data7); 
                can_mid(m_msg7);
                zhenduanstep++;
            break;
        case 4:
                data7[0] = 0x03;
                data7[1] = 0x22;
                data7[2] = 0xF1;
                data7[3] = 0x87;
                data7[4] = 0xAA;
                data7[5] = 0xAA;
                data7[6] = 0xAA;
                data7[7] = 0xAA;
                init_CAN_Frame(&m_msg7, 0x660, 8, 1, data7); 
                can_mid(m_msg7);
                swbegin = 0;
                hwbegin = 0;
                pnbegin = 1;
                zhenduanstep++;
            break;
        case 5:
                data7[0] = 0x30;
                data7[1] = 0x00;
                data7[2] = 0x00;
                data7[3] = 0xAA;
                data7[4] = 0xAA;
                data7[5] = 0xAA;
                data7[6] = 0xAA;
                data7[7] = 0xAA;
                init_CAN_Frame(&m_msg7, 0x660, 8, 1, data7); 
                can_mid(m_msg7);
                zhenduanstep++;
            break;
        case 6:
                pnbegin = 0;
                swtimebegin = 1;
                data7[0] = 0x03;
                data7[1] = 0x22;
                data7[2] = 0x10;
                data7[3] = 0x24;
                data7[4] = 0xAA;
                data7[5] = 0xAA;
                data7[6] = 0xAA;
                data7[7] = 0xAA;
                init_CAN_Frame(&m_msg7, 0x660, 8, 1, data7); 
                can_mid(m_msg7);
                zhenduanstep++;
            break;
        case 7:
                data7[0] = 0x30;
                data7[1] = 0x00;
                data7[2] = 0x00;
                data7[3] = 0xAA;
                data7[4] = 0xAA;
                data7[5] = 0xAA;
                data7[6] = 0xAA;
                data7[7] = 0xAA;
                init_CAN_Frame(&m_msg7, 0x660, 8, 1, data7); 
                can_mid(m_msg7);
                zhenduanstep++;
            break;
        case 8:
                data7[0] = 0x30;
                data7[1] = 0x00;
                data7[2] = 0x00;
                data7[3] = 0xAA;
                data7[4] = 0xAA;
                data7[5] = 0xAA;
                data7[6] = 0xAA;
                data7[7] = 0xAA;
                init_CAN_Frame(&m_msg7, 0x660, 8, 1, data7); 
                can_mid(m_msg7);
                zhenduanstep++;
            break;
        default:
                send0x714time = 0;
                begin714 = 1;
            break;
    }

}
uint8_t UIDNumber[19] = {84,89,87,0,0,0,0,0,0,0,0,0,0,1,2,0,2,5,0xFF};
uint8_t UIDNumber2[15] = {0,5,2,2,0,0,0,0,0,0,0,0,0,1,0xFF};
uint8_t change = 13;
uint8_t writeflag = 0;
uint8_t UIDStep;
uint8_t UIDTime;
uint8_t seedresult[4] = {0};
void get_seed_msg(void);
uint8_t getseedresult = 0;
void UIDWrite(void)
{
}
void Get_ID_0x794_Msg(void)
{

}

uint8_t UDSStep;
void Get_SW_msg(void)
{
    u8getuidmsg[0] = Get_CAN_CH0_ID_668_byte0_Sig();
    u8getuidmsg[1] = Get_CAN_CH0_ID_668_byte1_Sig();
    u8getuidmsg[2] = Get_CAN_CH0_ID_668_byte2_Sig();
    u8getuidmsg[3] = Get_CAN_CH0_ID_668_byte3_Sig();
    u8getuidmsg[4] = Get_CAN_CH0_ID_668_byte4_Sig();
    u8getuidmsg[5] = Get_CAN_CH0_ID_668_byte5_Sig();
    u8getuidmsg[6] = Get_CAN_CH0_ID_668_byte6_Sig();
    u8getuidmsg[7] = Get_CAN_CH0_ID_668_byte7_Sig();

    if((u8getuidmsg[0] == 0x10) && (u8getuidmsg[4] == 0x95))
    {
        memset(ruanjianbanbenhao,0xFF,sizeof(ruanjianbanbenhao));
        ruanjianbanbenhao[0] = u8getuidmsg[5];
        ruanjianbanbenhao[1] = u8getuidmsg[6];
        ruanjianbanbenhao[2] = u8getuidmsg[7];
        UDSStep = 2;
    }
    else if((u8getuidmsg[0] == 0x21))
    {
        ruanjianbanbenhao[3] = u8getuidmsg[1];
        ruanjianbanbenhao[4] = u8getuidmsg[2];
        ruanjianbanbenhao[5] = u8getuidmsg[3];
        ruanjianbanbenhao[6] = 0xff;
        General_Number_Disp(ruanjianbanbenhao, 95, 50);
        UDSStep = 4;
    }
}

uint8_t uidtimebanbenhao[13];
void Get_SW_Time_msg(void)
{
    u8getuidmsg[0] = Get_CAN_CH0_ID_668_byte0_Sig();
    u8getuidmsg[1] = Get_CAN_CH0_ID_668_byte1_Sig();
    u8getuidmsg[2] = Get_CAN_CH0_ID_668_byte2_Sig();
    u8getuidmsg[3] = Get_CAN_CH0_ID_668_byte3_Sig();
    u8getuidmsg[4] = Get_CAN_CH0_ID_668_byte4_Sig();
    u8getuidmsg[5] = Get_CAN_CH0_ID_668_byte5_Sig();
    u8getuidmsg[6] = Get_CAN_CH0_ID_668_byte6_Sig();
    u8getuidmsg[7] = Get_CAN_CH0_ID_668_byte7_Sig();

    if((u8getuidmsg[0] == 0x10) && (u8getuidmsg[4] == 0x24))
    {
        memset(uidtimebanbenhao,0xFF,sizeof(uidtimebanbenhao));
        uidtimebanbenhao[0] = u8getuidmsg[5];
        uidtimebanbenhao[1] = u8getuidmsg[6];
        uidtimebanbenhao[2] = u8getuidmsg[7];
        // UDSStep = 2;
    }
    else if((u8getuidmsg[0] == 0x21))
    {
        uidtimebanbenhao[3] = u8getuidmsg[1];
        uidtimebanbenhao[4] = u8getuidmsg[2];
        uidtimebanbenhao[5] = u8getuidmsg[3];
        uidtimebanbenhao[6] = u8getuidmsg[4];
        uidtimebanbenhao[7] = u8getuidmsg[5];
        uidtimebanbenhao[8] = u8getuidmsg[6];
        // General_Number_Disp(uidtimebanbenhao, 100, 50);
        // UDSStep = 4;
    }
    else if((u8getuidmsg[0] == 0x22))
    {
        uidtimebanbenhao[9]  = u8getuidmsg[1];
        uidtimebanbenhao[10] = u8getuidmsg[2];
        uidtimebanbenhao[11] = u8getuidmsg[3];
        uidtimebanbenhao[12] = 0xFF;
        General_Number_Disp(uidtimebanbenhao, 95, 85);
        swtimebegin = 0;
    }
}

void Get_HW_msg(void)
{
    u8getuidmsg[0] = Get_CAN_CH0_ID_668_byte0_Sig();
    u8getuidmsg[1] = Get_CAN_CH0_ID_668_byte1_Sig();
    u8getuidmsg[2] = Get_CAN_CH0_ID_668_byte2_Sig();
    u8getuidmsg[3] = Get_CAN_CH0_ID_668_byte3_Sig();
    u8getuidmsg[4] = Get_CAN_CH0_ID_668_byte4_Sig();
    u8getuidmsg[5] = Get_CAN_CH0_ID_668_byte5_Sig();
    u8getuidmsg[6] = Get_CAN_CH0_ID_668_byte6_Sig();
    u8getuidmsg[7] = Get_CAN_CH0_ID_668_byte7_Sig();
    if((u8getuidmsg[0] == 0x10) && (u8getuidmsg[4] == 0x93))
    {
        memset(yingjianbanbenhao,0xFF,sizeof(yingjianbanbenhao));
        yingjianbanbenhao[0] = u8getuidmsg[5];
        yingjianbanbenhao[1] = u8getuidmsg[6];
        yingjianbanbenhao[2] = u8getuidmsg[7];
        UDSStep = 6;
    }
    else if(u8getuidmsg[0] == 0x21)
    {
        yingjianbanbenhao[3] = u8getuidmsg[1];
        yingjianbanbenhao[4] = u8getuidmsg[2];
        yingjianbanbenhao[5] = u8getuidmsg[3];
        yingjianbanbenhao[6] = 0xFF;
        General_Number_Disp(yingjianbanbenhao, 95, 120);
        UDSStep = 8;
    }
}

void Get_PN_msg(void)
{
    u8getuidmsg[0] = Get_CAN_CH0_ID_668_byte0_Sig();
    u8getuidmsg[1] = Get_CAN_CH0_ID_668_byte1_Sig();
    u8getuidmsg[2] = Get_CAN_CH0_ID_668_byte2_Sig();
    u8getuidmsg[3] = Get_CAN_CH0_ID_668_byte3_Sig();
    u8getuidmsg[4] = Get_CAN_CH0_ID_668_byte4_Sig();
    u8getuidmsg[5] = Get_CAN_CH0_ID_668_byte5_Sig();
    u8getuidmsg[6] = Get_CAN_CH0_ID_668_byte6_Sig();
    u8getuidmsg[7] = Get_CAN_CH0_ID_668_byte7_Sig();
    if((u8getuidmsg[0] == 0x10) && (u8getuidmsg[4] == 0x87))
    {
        memset(lingjianhao,0xFF,sizeof(lingjianhao));
        lingjianhao[0] = u8getuidmsg[5];
        lingjianhao[1] = u8getuidmsg[6];
        lingjianhao[2] = u8getuidmsg[7];
    }
    else if((u8getuidmsg[0] == 0x21))
    {
        lingjianhao[3] = u8getuidmsg[1];
        lingjianhao[4] = u8getuidmsg[2];
        lingjianhao[5] = u8getuidmsg[3];
        lingjianhao[6] = u8getuidmsg[4];
        lingjianhao[7] = u8getuidmsg[5];
        lingjianhao[8] = u8getuidmsg[6];
        lingjianhao[9] = u8getuidmsg[7];
    }
    else if((u8getuidmsg[0] == 0x22))
    {
        lingjianhao[10] = u8getuidmsg[1];
        lingjianhao[11] = u8getuidmsg[2];
        lingjianhao[12] = u8getuidmsg[3];
        lingjianhao[13] = u8getuidmsg[4];
        lingjianhao[14] = u8getuidmsg[5];
        lingjianhao[15] = u8getuidmsg[6];
        lingjianhao[16] = u8getuidmsg[7];
    }
    else if((u8getuidmsg[0] == 0x23))
    {
        lingjianhao[17] = u8getuidmsg[1];
        lingjianhao[18] = 0xFF;
        General_Number_Disp(lingjianhao, 70, 155);
        pnbegin = 0;
    }
}

uint8_t writebeing = 1;
uint8_t UIDresult = 0;
void Get_UID_msg(void)
{
    // u8get714msg[0] = Get_CAN_CH0_ID_7A9_byte0_Sig();
    // u8get714msg[1] = Get_CAN_CH0_ID_7A9_byte1_Sig();
    // u8get714msg[2] = Get_CAN_CH0_ID_7A9_byte2_Sig();
    // u8get714msg[3] = Get_CAN_CH0_ID_7A9_byte3_Sig();
    // u8get714msg[4] = Get_CAN_CH0_ID_7A9_byte4_Sig();
    // u8get714msg[5] = Get_CAN_CH0_ID_7A9_byte5_Sig();
    // u8get714msg[6] = Get_CAN_CH0_ID_7A9_byte6_Sig();
    // u8get714msg[7] = Get_CAN_CH0_ID_7A9_byte7_Sig();
    // if((u8get714msg[0] == 0x10) && (u8get714msg[4] == 0x01) && (UIDresult == 0))
    // {
    //     memset(UIDcode1,0xFF,sizeof(UIDcode1));
    //     // memcpy(UIDcode1,&u8get714msg[1],32);
    //     UIDcode1[0] = u8get714msg[5];
    //     UIDcode1[1] = u8get714msg[6];
    //     UIDcode1[2] = u8get714msg[7];
    //     UIDresult = 1;
    // }
    // if((u8get714msg[0] == 0x21) && (UIDresult == 1))
    // {
    //    UIDcode1[3] = u8get714msg[1];
    //    UIDcode1[4] = u8get714msg[2];
    //    UIDcode1[5] = u8get714msg[3];
    //    UIDcode1[6] = u8get714msg[4];
    //    UIDcode1[7] = u8get714msg[5];
    //    UIDcode1[8] = u8get714msg[6];
    //    UIDcode1[9] = u8get714msg[7];
    //    UIDresult = 2;
    // }
    // else if((u8get714msg[0] == 0x22) && (UIDresult == 2))
    // {
    //     UIDcode1[10] = u8get714msg[1];
    //     UIDcode1[11] = u8get714msg[2];
    //     UIDcode1[12] = u8get714msg[3];
    //     UIDcode1[13] = u8get714msg[4];
    //     UIDcode1[14] = u8get714msg[5];
    //     UIDcode1[15] = u8get714msg[6];
    //     UIDcode1[16] = u8get714msg[7];
    //     UIDresult = 3;
    // }
    // else if((u8get714msg[0] == 0x23) && (UIDresult == 3))
    // {
    //     UIDcode1[17] = u8get714msg[1];
    //     UIDcode1[18] = u8get714msg[2];
    //     UIDcode1[19] = u8get714msg[3];
    //     UIDcode1[20] = u8get714msg[4];
    //     UIDcode1[21] = u8get714msg[5];
    //     UIDcode1[22] = u8get714msg[6];
    //     UIDcode1[23] = u8get714msg[7];
    //     UIDresult = 4;
    // }
    // else if((u8get714msg[0] == 0x24) && (UIDresult == 4))
    // {
    //     UIDcode1[24] = u8get714msg[1];
    //     UIDcode1[25] = u8get714msg[2];
    //     UIDcode1[26] = u8get714msg[3];
    //     UIDcode1[27] = u8get714msg[4];
    //     UIDcode1[28] = u8get714msg[5];
    //     UIDcode1[29] = u8get714msg[6];
    //     UIDcode1[30] = u8get714msg[7];
    //     UIDresult = 5;
    // }
    // else if((u8get714msg[0] == 0x25) && (UIDresult == 5))
    // {
    //     UIDcode1[31] = u8get714msg[1];
    //     UIDcode1[32] = 0xFF;
    //     // for(int i = 0;i<33;i++)
    //     // {
    //     //     if(UIDcode2[i] != UIDcode1[i])
    //     //     {
    //     UIDresult = 6;
    //     if(writebeing)
    //     {
    //         General_Number_Disp(UIDcode1, 95, 225);
    //         writebeing = 0;
    //     }
    // }
}


uint32_t ValidSeedKey;
uint32_t GenerateKey(uint8_t *Seed)
{
    unsigned char i = 0u;
	unsigned char T1[4u] = { 0u };
	unsigned char T2[4u] = { 0u };
	unsigned char Xor[4u] = { 0u };
    unsigned char arr[4u] = { 0u };
	unsigned char KeyConst[4u] = { 0u };
	unsigned char KeyConst_L1[4u] = { 0xACu, 0x89u, 0x18u, 0xF2u };
    unsigned char iSeedArray[4u] = { 0u };
    for (i = 0u; i < 4u; i++)
	{
        iSeedArray[i] = Seed[i];
    }

	Xor[0u] = iSeedArray[2u];
	Xor[1u] = iSeedArray[3u];
	Xor[2u] = iSeedArray[0u];
	Xor[3u] = iSeedArray[1u];

	for (i = 0u; i < 4u; i++)
	{
		KeyConst[i] = KeyConst_L1[i];
	}

	for (i = 0u; i < 4u; i++)
	{
		T1[i] = iSeedArray[i] ^ KeyConst[i];
		T2[i] = Xor[i] ^ KeyConst[i];
		arr[i] = (T1[i] + T2[i]) & 0xFFu;
	}
    ValidSeedKey = ((uint32_t)arr[0u] <<24u) + ((uint32_t)arr[1u] << 16u) + ((uint32_t)arr[2u] << 8u) + ((uint32_t)arr[3u] );
    return ValidSeedKey;
}

// void CalculateKey(void)
// {
//     unsigned char i = 0u;
//     unsigned char T1[4u] = { 0u };
//     unsigned char T2[4u] = { 0u };
//     unsigned char Xor[4u] = { 0u };
//     unsigned char arr[4u] = { 0u };
//     unsigned char KeyConst[4u] = { 0u };
//     unsigned char KeyConst_L1[4u] = { 0xACu, 0x89u, 0x18u, 0xF2u };
//     unsigned char iSeedArray[4u] = { 0u };
//     for (i = 0u; i < 4u; i++)
//     {
//         iSeedArray[i] = Seed[i];
//     }

//     Xor[0u] = iSeedArray[2u];
//     Xor[1u] = iSeedArray[3u];
//     Xor[2u] = iSeedArray[0u];
//     Xor[3u] = iSeedArray[1u];

//     for (i = 0u; i < 4u; i++)
//     {
//         KeyConst[i] = KeyConst_L1[i];
//     }

//     for (i = 0u; i < 4u; i++)
//     {
//         T1[i] = iSeedArray[i] ^ KeyConst[i];
//         T2[i] = Xor[i] ^ KeyConst[i];
//         arr[i] = (T1[i] + T2[i]) & 0xFFu;
//     }
//     ValidSeedKey = ((uint32_t)arr[0u] <<24u) + ((uint32_t)arr[1u] << 16u) + ((uint32_t)arr[2u] << 8u) + ((uint32_t)arr[3u] );
//    
// }
uint8_t chaengUDSstep = 0;
uint8_t seednum[4] = {0};
uint32_t UDS_time = 0;
extern uint32_t fakedelay;
uint8_t resettime = 0;
uint8_t resetflag = 0;
extern uint32_t fakedelay;
uint32_t resetpowtime = 0;
uint32_t FUresetpowtime = 0;
uint8_t vspeedpeizhi = 0;
uint8_t trackmode = 0;
uint32_t testseed;
void get_seed_msg(void)
{
    // if(getseedresult == 1)
    // {
    //     return ;
    // }
    // u8get714msg[0] = Get_CAN_CH0_ID_7A9_byte0_Sig();
    // u8get714msg[1] = Get_CAN_CH0_ID_7A9_byte1_Sig();
    // u8get714msg[2] = Get_CAN_CH0_ID_7A9_byte2_Sig();
    // u8get714msg[3] = Get_CAN_CH0_ID_7A9_byte3_Sig();
    // u8get714msg[4] = Get_CAN_CH0_ID_7A9_byte4_Sig();
    // u8get714msg[5] = Get_CAN_CH0_ID_7A9_byte5_Sig();
    // u8get714msg[6] = Get_CAN_CH0_ID_7A9_byte6_Sig();
    // u8get714msg[7] = Get_CAN_CH0_ID_7A9_byte7_Sig();
    // if(u8get714msg[1] == 0x67 && u8get714msg[2] == 0x01)
    // {
    //     memcpy(seednum,&u8get714msg[3],4);
    //     testseed = GenerateKey(seednum);
    //     seedresult[0] = (uint8_t)(testseed >> 24);
    //     seedresult[1] = (uint8_t)(testseed >> 16);
    //     seedresult[2] = (uint8_t)(testseed >> 8);
    //     seedresult[3] = (uint8_t)testseed ;
    //     getseedresult = 1;
        
    // }
    // getseedresult = 1;
}