#include "CAN_Communication_Matrix.h"
#include "CAN_APP.h"
#include "RSCAN.h"
#include "Key.h"

/* 2022/11/19 14:29:55 */
st_CanMsgOp CAN_CH4_CanMsgOp;
st_CanMsgTxOp CAN_CH4_CanMsgTxOp;
#define CAN_CH4 &CAN_CH4_CanMsgOp
uint8_t count = 0;

const st_CAN_SendAttribute    CAN_CH4_CANSendAttr[CAN_CH4_ID_SEND_TOTAL] =
{
    {0x200, 100ul*1000ul, 5ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_4, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_200, (void *)0},//车速
    {0x481, 500ul*1000ul, 10ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_5, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_481, (void *)0},//时间
    {0x020, 100ul*1000ul, 15ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_6, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_020, (void *)0},//电量
    {0x042, 10ul*1000ul, 20ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_7, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_042, (void *)0},//tcs
    {0x480, 500ul*1000ul, 25ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_8, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_480, (void *)0},//GPS,4G,电话，蓝牙指示灯
    {0x280, 100ul*1000ul, 30ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_9, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_280, (void *)0},//tcs，能量回收
    {0x202, 100ul*1000ul, 35ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_10, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_202, (void *)0},//档位，续航里程，ready
    {0x001, 100ul*1000ul, 40ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_11, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_001, (void *)0},//电机过热
    {0x021, 100ul*1000ul, 45ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_12, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_021, (void *)0},//电池过热
    {0x284, 100ul*1000ul, 50ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_13, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_284, (void *)0},//NFC
    {0x786, 100ul*1000ul, 55ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_14, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_786, (void *)0},//诊断
};

const st_CANMsgAttribute CAN_CH4_CAN_MSG_CONST_ARRAY[CAN_CH4_ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x250ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x450ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x451ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x750ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },

};

uint8_t  Co_Can_ConvertSubID_CAN_CH4(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH4_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH4_ID_250_Msg:
        u8Result = CAN_CH4_ID_250_Msg_Count;
        break;
    case CAN_CH4_ID_450_Msg:
        u8Result = CAN_CH4_ID_450_Msg_Count;
    break;
    case CAN_CH4_ID_451_Msg:
        u8Result = CAN_CH4_ID_451_Msg_Count;
    break;
    case CAN_CH4_ID_750_Msg:
        u8Result = CAN_CH4_ID_750_Msg_Count;
    break;
    default :
        u8Result = CAN_CH4_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}

//TCS模式设置
uint8_t Get_CAN_CH4_ID_250_TCS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_250_Msg_Count,0u) >> 5u)));
}
//小计
uint8_t Get_CAN_CH4_ID_450_Trip(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_450_Msg_Count, 7u) >> 0u) & 0xFFu));
}
//总计
uint8_t Get_CAN_CH4_ID_450_Mileage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_450_Msg_Count, 3u) >> 0u) & 0xFFu));
}

//诊断返回信息1_3

uint8_t Get_CAN_CH4_ID_750_Diagnosis_return750_1_5(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_750_Msg_Count, 5u) >> 0u) & 0xFFu));

}
uint8_t Get_CAN_CH4_ID_750_Diagnosis_return750_1_6(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_750_Msg_Count, 6u) >> 0u) & 0xFFu));
}
uint8_t Get_CAN_CH4_ID_750_Diagnosis_return750_1_7(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_750_Msg_Count, 7u) >> 0u) & 0xFFu));

}
//诊断返回信息2_7

uint8_t Get_CAN_CH4_ID_750_Diagnosis_return2_1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_750_Msg_Count, 1u) >> 0u) & 0xFFu));
}
uint8_t Get_CAN_CH4_ID_750_Diagnosis_return2_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_750_Msg_Count, 2u) >> 0u) & 0xFFu));
}
uint8_t Get_CAN_CH4_ID_750_Diagnosis_return2_3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_750_Msg_Count, 3u) >> 0u) & 0xFFu));
}
uint8_t Get_CAN_CH4_ID_750_Diagnosis_return2_4(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_750_Msg_Count, 4u) >> 0u) & 0xFFu));
}
uint8_t Get_CAN_CH4_ID_750_Diagnosis_return2_5(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_750_Msg_Count, 5u) >> 0u) & 0xFFu));

}
uint8_t Get_CAN_CH4_ID_750_Diagnosis_return2_6(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_750_Msg_Count, 6u) >> 0u) & 0xFFu));
}
uint8_t Get_CAN_CH4_ID_750_Diagnosis_return2_7(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_750_Msg_Count, 7u) >> 0u) & 0xFFu));

}


//诊断返回信息3_3
uint8_t Get_CAN_CH4_ID_750_Diagnosis_return3_1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_750_Msg_Count, 1u) >> 0u) & 0xFFu));
    // 读取CAN通道4，ID为750的消息的字节5
}
uint8_t Get_CAN_CH4_ID_750_Diagnosis_return3_2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_750_Msg_Count, 2u) >> 0u) & 0xFFu));
}
uint8_t Get_CAN_CH4_ID_750_Diagnosis_return3_3(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH4,CAN_CH4_ID_750_Msg_Count, 3u) >> 0u) & 0xFFu));

}


void Can_ID_750_Receive(uint8_t CopyData[])
{
    
    Get_CAN_CH4_ID_750_Diagnosis_return1();

}