#ifndef CAN_RECV_LIB_H_
#define CAN_RECV_LIB_H_

typedef struct {
    uint32_t ID;                                        //ID;
    uint16_t Peroid;                                    //ڣλms;
    uint16_t TimeoutMax;                                //ʱʱ䣬λms;
    uint16_t TimeoutLv[3];                              //ּʱʱ䣬0ãֵTimeoutMaxTimeoutLv[0] = 100ڸñ100msûյʱFrameTimeoutFunc(1);
    uint8_t RecoverContinueCnts;                        //ĳʱյRecoverContinueCntsжĻָڲPeroid*1.201Ϊյ1ļжĻָ;
    void (*FrameAnalysisFunc)(uint8_t *data);          //յʱøûص;
    void (*FrameTimeoutFunc)(uint8_t Lv);              //TimeoutMaxʱʱFrameTimeoutFunc(0),TimeoutLv[0]ʱʱFrameTimeoutFunc(1),TimeoutLv[1]ʱʱFrameTimeoutFunc(2),TimeoutLv[2]ʱʱFrameTimeoutFunc(3);
    uint8_t (*FrameGetCheckSum)(uint8_t *data);           //ձʱøú1ʾchecksumȷ0ʾ򲻻FrameAnalysisFunc
}INIT_CAN_FRAME;

typedef struct {
    uint32_t ID;        
    uint8_t Data[64];
    uint8_t DataLen;
    uint8_t FrameValid;
}RECV_CAN_FRAME;

typedef struct {
    uint32_t ID;        
    uint8_t Data[256];
    uint8_t DataLen;
}Multiple_CAN_FRAME;

typedef struct {
    uint32_t ID;        
    uint8_t Data[64];	
    uint8_t DataLen;	
}Core_CAN_FRAME;

typedef enum {
    CAN_FRAME_STATE_NORMAL,
    CAN_FRAME_STATE_TIME_OUT,
}CAN_FRAME_STATE;

extern uint8_t *GetCanRecvModuleVersion(void);                  //ȡ汾
extern void InitCanFrame(uint8_t n, INIT_CAN_FRAME *data);      //ʼCanձĲ
extern void RecvCanFrame(RECV_CAN_FRAME *data);                 //Canже
extern uint8_t GetCanFrameState(uint32_t ID);                   //ȡCANǰ״̬
extern uint16_t GetCanFrameAliveTime(uint32_t ID);              //ȡCANʣʱ
extern void CanRecvLibTimerCall(uint32_t n);                     //ʱã1msһΣ1
extern void AnalysisCanData(void);                             //ʱ
extern void ResetAllCanFrameTime(void);                        //λCanĵĳʱʱ䣬״ϵBusoffָ
extern uint8_t GetAllCanFrameTimeout(void);                     //ȡбǷȫʱ

extern uint8_t GetCheckSumRightCnts(uint32_t ID);               //ȡchecksumȷ5
extern uint8_t GetCheckSumErrorCnts(uint32_t ID);               //ȡchecksum10


#endif 
