#include "common_include.h"
#include "bsp_app_led_output.h"

void InitTelltale_SQFL(void)
{
#if (PRO_SQFL)
    SetTelltalePos("ABS",             ABS);
    SetTelltalePos("AirBag",          AirBag);
    SetTelltalePos("AutoHoldYellow",  AutoHoldYellow);
    SetTelltalePos("AutoHoldGreen",   AutoHoldGreen);
    SetTelltalePos("AutoHoldWhite",   AutoHoldWhite);
    SetTelltalePos("BatteryCharge",   BatteryCharge);
    SetTelltalePos("CheckEngine",     CheckEngine);
    SetTelltalePos("DpfGpf",          DpfGpf);
    SetTelltalePos("EPB",             EPB);  
    SetTelltalePos("ESC",             ESC);
    SetTelltalePos("EscOff",          EscOff);

    SetTelltalePos("FcaYellow",       FcaYellow);
    //SetTelltalePos("FcaRed",          FcaRed);

    SetTelltalePos("HBAGreen",        HBAGreen);
    //SetTelltalePos("HBAWhite",        HBAWhite);
    
    SetTelltalePos("HighBeam",        HighBeam);
    SetTelltalePos("Immobilizer",     Immobilizer);

    SetTelltalePos("IsgGreen",        IsgGreen);
    SetTelltalePos("IsgYellow",       IsgYellow);
    SetTelltalePos("IsgWhite",        IsgWhite);

    SetTelltalePos("LdwLkaGray",      LdwLkaGray);
    SetTelltalePos("LdwLkaGreen",     LdwLkaGreen);
    SetTelltalePos("LdwLkaYellow",    LdwLkaYellow);


    SetTelltalePos("LfaHdaGray",      LfaHdaGray);
    SetTelltalePos("LfaHdaGreen",     LfaHdaGreen);
    SetTelltalePos("LfaHdaWhite",     LfaHdaWhite);
    
    SetTelltalePos("LowBeam",         LowBeam);
    
    SetTelltalePos("MasterSymbol",    MasterSymbol);
    SetTelltalePos("Mdps",            Mdps);

    SetTelltalePos("OilPressure",     OilPressure);
    SetTelltalePos("ParkingBreak",    ParkingBreak);
    SetTelltalePos("RearFog",         RearFog);
    SetTelltalePos("SeatBelt",        SeatBelt);   
    SetTelltalePos("TailLamp",        TailLamp);    
    SetTelltalePos("Tpms",            Tpms);    
    SetTelltalePos("LeftTurn",        LeftTurn);
    SetTelltalePos("RightTurn",       RightTurn);
    SetTelltalePos("IceWarning",      IceWarning);
    
    SetTelltalePos("LowFuel",     DMS_RestoreDefault);
    
    if(IsHaveSportPlus()) {
        SetTelltalePos("ECO",             DMS_Led_ECO);
        SetTelltalePos("COMFORT",         DMS_Led_Comfort);
        SetTelltalePos("SPORT",           DMS_Led_Sport);
        SetTelltalePos("SMART Comfort",   DMS_Led_Smart_ComfortColor);
        SetTelltalePos("SMART Eco",       DMS_Led_Smart_EcoColor);
        SetTelltalePos("SMART Sport",     DMS_Led_Smart_SportColor);
        SetTelltalePos("SMART Smart",     DMS_Led_Smart_SmartColor);
        SetTelltalePos("SPORT+",          DMS_Led_SportPlus);
    } 
    else {
        SetTelltalePos("ECO",             DMS_Led_ECO);
        SetTelltalePos("COMFORT",         DMS_Led_Comfort);
        SetTelltalePos("SMART Comfort",   DMS_Led_Smart_ComfortColor);
        SetTelltalePos("SMART Eco",       DMS_Led_Smart_EcoColor);
        SetTelltalePos("SMART Sport",     DMS_Led_Smart_SportColor);
        SetTelltalePos("SMART Smart",     DMS_Led_Smart_SmartColor);
        SetTelltalePos("SPORT",           DMS_Led_Sport);
    }
#endif    

}


