#define GLOBAL_BSP_SLEEP
#include "common_include.h"



/*-------------------------------------------------------------------------
* Function Name  : bsp_System_sleep
* Description   :
* Input      : None
* Output     : None
* Return     : None
* onther     :
--------------------------------------------------------------------------*/
void bsp_System_sleep(void)
{
    bsp_GpioSleepCtrl();
    ADC_Wakup_Init();
    bsp_CAN_Sleep( 0u );

    bsp_tx_msgbuf_abort( 1 );
    bsp_CAN_Sleep( 1 );
    bsp_McuPowerSave();
}

/*-------------------------------------------------------------------------
* Function Name  : ADC_Wakup_CallBack
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void ADC_Wakup_CallBack(uint8_t channel)
{
    Eic_Disable((stc_eic00_t *) &EIC00, 17);
}

/*-------------------------------------------------------------------------
* Function Name  : ADC_Wakup_Init
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void ADC_Wakup_Init(void)
{
    // stc_port_pin_config_t stc_port_pin_config1_10= { .enOutputFunction      = PortOutputResourceGPIO,
    //     .enOutputDrive         = PortOutputDriveA,
    //     .enPullResistor        = PortPullResistorNone,
    //     .enInputLevel          = PortInputLevelCmosA,
    //     .bInputEnable          = TRUE,
    //     .bNoiseFilterEnable    = FALSE,
    //     .enGpioDirection       = PortGpioInput,
    // .enGpioInitOutputLevel = PortGpioLow};
    // Port_SetPinConfig( 1, 10, &stc_port_pin_config1_10 );
    
    stc_eic_config_t      stcEicConfig;
    // EIC Configuration
    stcEicConfig.enRequestEvent               = EicRisingEdge;          // Detect rising edge
    stcEicConfig.bInputNoiseFilterEnable      = TRUE;                   // Enable the noise filter
    stcEicConfig.bDmaRequestEnable            = FALSE;                  // Disable the DMA request
    stcEicConfig.pfnCallback                  = &ADC_Wakup_CallBack;    // using interrupts
    
    Port_SelectInputPort( &RIC.unRESIN268, PortInputPortA );
    
    Eic_Init((stc_eic00_t *) &EIC00, 17, &stcEicConfig);
    
    Eic_Enable((stc_eic00_t *) &EIC00, 17);
    
    Port_EnableInput();
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_GpioSleepCtrl
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
*
--------------------------------------------------------------------------*/
void bsp_GpioSleepCtrl(void)
{     
    stc_port_pin_config_t stc_port_pin_config_out;
    
    stc_port_pin_config_out.enOutputFunction      = PortOutputResourceGPIO;
    stc_port_pin_config_out.enOutputDrive         = PortOutputDriveA;
    stc_port_pin_config_out.enPullResistor        = PortPullResistorNone;
    stc_port_pin_config_out.enInputLevel          = PortInputLevelCmosA;
    stc_port_pin_config_out.bInputEnable          = FALSE;
    stc_port_pin_config_out.bNoiseFilterEnable    = TRUE;
    stc_port_pin_config_out.enGpioDirection       = PortGpioOutput;

    stc_port_pin_config_t GpioInputConfig = {
        .enOutputFunction      = PortOutputResourceGPIO,
        .enPullResistor        = PortPullResistorNone,
        .bInputEnable          = TRUE,
        .enGpioDirection       = PortGpioInput
    };
    
    /* ------------------- LOW ----------------------------------*/
    stc_port_pin_config_out.enGpioInitOutputLevel = PortGpioLow;
    
    //P_B+Green&WhiteLamp_OUT   2    
    Port_SetPinConfig( 0, 0, &stc_port_pin_config_out );
    
    //P_BackLightBlueLamp_OUT   3    
    Port_SetPinConfig( 0, 1, &stc_port_pin_config_out ); 
    
    //P_SpeedCLU_OUT   4    
    Port_SetPinConfig( 0, 2, &stc_port_pin_config_out ); 
    
    //P_BackLightGreenLamp_OUT   6    
    Port_SetPinConfig( 0, 4, &stc_port_pin_config_out ); 
    
    //P_BackLightRedLamp_OUT   7    
    Port_SetPinConfig( 0, 5, &stc_port_pin_config_out ); 
    
    //L_ScreenXcsBIT_OUT   8    
    Port_SetPinConfig( 0, 6, &stc_port_pin_config_out ); 
    
    //L_ScreenXwrBIT_OUT   11    
    Port_SetPinConfig( 0, 7, &stc_port_pin_config_out ); 
    
    //L_ScreenXrdBIT_OUT   12    
    Port_SetPinConfig( 0, 8, &stc_port_pin_config_out );
    
    //L_AUTO_HOLDWhiteSampSW_OUT   13    
    Port_SetPinConfig( 0, 9, &stc_port_pin_config_out ); 
    
    //L_ScreenA0BIT_OUT   14    
    Port_SetPinConfig( 0, 10, &stc_port_pin_config_out ); 

    //L_ScreenXresBIT_OUT   15    
    Port_SetPinConfig( 0, 11, &stc_port_pin_config_out ); 
    
    //L_ScreenTeBIT_OUT   16    
    Port_SetPinConfig( 0, 12, &stc_port_pin_config_out ); 

    //L_AUTO_HOLDWhiteSampSW_OUT   19    
    Port_SetPinConfig( 0, 13, &stc_port_pin_config_out ); 
    
    //L_AUTO_HOLDGreenSampSW_OUT   20    
    Port_SetPinConfig( 0, 14, &stc_port_pin_config_out ); 

    Port_SetPinConfig( 0, 15, &stc_port_pin_config_out );     
    
    //L_BD433Ctrl_OUT  60 
    Port_SetPinConfig( 1, 0, &stc_port_pin_config_out ); 

    //L_BiasBitSW_OUT  62 
    Port_SetPinConfig( 1, 2, &stc_port_pin_config_out ); 

    //P_PCMAH(+)_OUT  63 
    Port_SetPinConfig( 1, 3, &stc_port_pin_config_out ); 
    
    //P_IGN+Green&WhiteLamp_OUT   85 
    Port_SetPinConfig( 1, 15, &stc_port_pin_config_out );
    
    //P_BackLightLamp2_OUT   86  
    Port_SetPinConfig( 1, 16, &stc_port_pin_config_out );
    
    //P_BackLightLamp1_OUT   87  
    Port_SetPinConfig( 1, 17, &stc_port_pin_config_out );
    
    //L_APOWER_OUT   91  
    Port_SetPinConfig( 1, 19, &stc_port_pin_config_out );
    
    //L_D_OutBitSW_OUT   94
    //Port_SetPinConfig( 1, 22, &stc_port_pin_config_out );
    
    //L_N_OutBitSW_OUT   95 
    Port_SetPinConfig( 1, 23, &stc_port_pin_config_out );

    //L_BiasBitSW   96
    Port_SetPinConfig( 1, 24, &stc_port_pin_config_out );
    
    //L_COMMLCD_OUT   100  
    Port_SetPinConfig( 1, 26, &stc_port_pin_config_out );
    
    //L_SDLCD_OUT   101  
    Port_SetPinConfig( 1, 27, &stc_port_pin_config_out );
    
    //L_SCLLCD_OUT   102  
    Port_SetPinConfig( 1, 28, &stc_port_pin_config_out );
    
    //L_CSBLCD_OUT   103  
    Port_SetPinConfig( 1, 29, &stc_port_pin_config_out );
    
    //L_SD0LCD_OUT   104  
    Port_SetPinConfig( 1, 30, &stc_port_pin_config_out );
    
    //L_SCL0LCD_OUT   105  
    Port_SetPinConfig( 1, 31, &stc_port_pin_config_out );
    
    //L_CSB0LCD_OUT   106  
  //  Port_SetPinConfig( 2, 0, &stc_port_pin_config_out );
    
    //L_SEG0LCD_OUT   107  
    Port_SetPinConfig( 2, 1, &stc_port_pin_config_out );

#if ((SQFL) || (NQ5C) || (NQ5C_HEV) || (OE) || (BDC_PE) || (CN7C_PE) || (QYC))
    //L_ONEBitCLU_OUT   114  
    Port_SetPinConfig( 2, 4, &stc_port_pin_config_out );
#endif    
    
    //L_CLKBitCLU_OUT   115  
    Port_SetPinConfig( 2, 5, &stc_port_pin_config_out );
    
    //L_SerinBitCLU_OUT   116  
    Port_SetPinConfig( 2, 6, &stc_port_pin_config_out );
    
    //L_RESBitCLU_OUT   117  
    Port_SetPinConfig( 2, 7, &stc_port_pin_config_out );

#if ((SQFL) || (NQ5C) || (NQ5C_HEV) || (OE) || (BDC_PE) || (CN7C_PE) || (QYC))
    //L_LATCHBitCLU_OUT   118  
    Port_SetPinConfig( 2, 8, &stc_port_pin_config_out );
#endif     
    
    //L_LDWSYellowSampSW_IN   121  
    Port_SetPinConfig( 2, 9, &stc_port_pin_config_out );
    
    //L_LDWSWhiteSampSW_IN   122  
    Port_SetPinConfig( 2, 10, &stc_port_pin_config_out ); 
    
    //L_LDWSGreenSampSW_IN   123  
    Port_SetPinConfig( 2, 11, &stc_port_pin_config_out );
    
    //L_FuelSender_OUT   124  
    Port_SetPinConfig( 2, 12, &stc_port_pin_config_out ); 
    
    //L_61194Ctrl_OUT   125  
    Port_SetPinConfig( 2, 13, &stc_port_pin_config_out ); 
    
    //P_OUT   126  
    Port_SetPinConfig( 2, 14, &stc_port_pin_config_out ); 
    
    //D0   127 
    Port_SetPinConfig( 2, 15, &stc_port_pin_config_out ); 
    
    //D0   128 
    Port_SetPinConfig( 2, 16, &stc_port_pin_config_out ); 
    
    //D0   129 
    Port_SetPinConfig( 2, 17, &stc_port_pin_config_out ); 
    
    //D0   130 
    Port_SetPinConfig( 2, 18, &stc_port_pin_config_out );
    
    //D0   132 
    Port_SetPinConfig( 2, 20, &stc_port_pin_config_out );

    //D0   136 
    Port_SetPinConfig( 2, 22, &stc_port_pin_config_out );
    
    //D0   137 
    Port_SetPinConfig( 2, 23, &stc_port_pin_config_out );
    
    //D0   138 
    Port_SetPinConfig( 2, 24, &stc_port_pin_config_out );
    
    //D0   139 
    Port_SetPinConfig( 2, 25, &stc_port_pin_config_out );
    
    //L_P_OutBitSW_OUT   140 
    Port_SetPinConfig( 2, 26, &stc_port_pin_config_out );
    
    //L_N_OutBitSW_OUT   141 
    Port_SetPinConfig( 2, 27, &stc_port_pin_config_out );
    
    //L_AIR_BAG+OffLampBitSW_OUT  142  
    Port_SetPinConfig( 2, 28, &stc_port_pin_config_out );
    
    //L_D_OutBitSW_OUT  143  
    Port_SetPinConfig( 2, 3, &stc_port_pin_config_out ); 
    
    //L_ILLBitSW_OUT   64  
    Port_SetPinConfig( 1, 4, &stc_port_pin_config_out );
    
    /*----------------- OUT HIGH  -----------------------------*/
    stc_port_pin_config_out.enGpioInitOutputLevel = PortGpioHigh;
    
    //SCL   74  
    Port_SetPinConfig( 1, 8, &stc_port_pin_config_out );
    
    //SDA   77  
    Port_SetPinConfig( 1, 9, &stc_port_pin_config_out );
    
    //L_P_OutBitSW_OUT   97  
    Port_SetPinConfig( 1, 25, &stc_port_pin_config_out );
#if (NU2)    
    /*----------------- Input  -----------------------------*/
    //L_ONEBitCLU_OUT   114  
    Port_SetPinConfig( 2, 4, &GpioInputConfig );
    
    //L_LATCHBitCLU_OUT   118  
    Port_SetPinConfig( 2, 8, &GpioInputConfig );
#endif    
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_McuPowerSave
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
*
--------------------------------------------------------------------------*/
void bsp_McuPowerSave(void)
{
    uint32_t ErrorFlag;
    
    SYSC0_PROTKEYR  = SYSC_KEY_UNLOCK;  
    SYSC0_8.unSPECFGR.stcField    =   (stc_sysc0_8_specfgr_field_t)
    {
        .u1PSSPADCTRL   = 1, /**/
        .u1HOLDIO_PD2   = 1,
        .u1EXVRSTCNT    = 0  
    };
    
    /* ر */
    SWDG_PROT = 0xEDACCE55u; 
    SWDG_CFG_LOCK = 0u;	
    SWDG_PROT = 0xEDACCE55u; 
    SWDG_CFG  = 0x00000004u;
    SWDG_PROT = 0xEDACCE55u; 
    SWDG_CFG_LOCK = 1u;
    
    /*------------------------------------------------------------------
    //  ConfigureClocks_Stop
    //------------------------------------------------------------------*/
    if (SYSC_SSCG0CGCNTR_SSCGCGSTS == 2u)  /* Gear up status: 0 - stop gear at min freq*/
    {
        SYSC0_PROTKEYR = SYSC_KEY_UNLOCK;   
        SYSC_SSCG0CGCNTR_SSCGCGSTR  =   1u;
    }
    
    if (SYSC_PLL0CGCNTR_PLLCGSTS == 2u)  /* Gear up status: 0 - stop gear at min freq*/
    {
        SYSC0_PROTKEYR = SYSC_KEY_UNLOCK; 
        SYSC_PLL0CGCNTR_PLLCGSTR    =   1u;                  /* Start gear operation (PLL0) */
    }

    /* Ensure that PLL clock gearing has also finished*/
    while ((SYSC_PLL0CGCNTR_PLLCGSTS) != 0)                 /* 00-stop gear at min freq or glock gear not used*/
    {

    }
    
    while ((SYSC_SSCG0CGCNTR_SSCGCGSTS) != 0)               /*00-stop gear at min freq or glock gear not used*/
    {

    }
    
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK; 
    SYSC0_1.unRUNCKSRER.stcField    =   (stc_sysc0_1_runcksrer_field_t)
    {                                                                
        .u1SSCG0EN  =   0u,  /* disable SSCG0                                  */
        .u1PLL0EN   =   0u,  /* disable PLL0                                   */
        .u1SOSCEN   =   0u,  /* enable Sub Oscillation                         */
        .u1MOSCEN   =   1u,  /* enable Main Oscillation                        */
        .u1CROSCEN  =   0u,  /* Enable oscillation of the high-speed CR clock. */
        .u1SCROSCEN =   1u,   /* Enable oscillation of the low-speed CR clock.  */
    };
    
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK; 
    SYSC0_1.unRUNCKSELR.stcField    =   (stc_sysc0_1_runckselr_field_t)
    {    
        .u3CDMCUCCSL  = 0  /* Clock domain MCUC clock = High-speed CR clock*/
    }; 
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK; 
    SYSC1.unRUNCKSELR0.stcField     =   (stc_sysc1_runckselr0_field_t)
    {    
        .u4HSSPICSL =   0,  /* Hsspi clock domain = High-speed CR clock  */
        .u1LAPP1ACSL=   0u,  /* LAPP1A clock = CD0                        */
        .u1LAPP0ACSL=   0u,  /* LAPP0A clock = CD0                        */
        .u1LCP1ACSL =   0u,  /* LCP1A clock = CD0                         */
        .u1LCP0ACSL =   0u,  /* LCP0A clock = CD0                         */
        .u3CD0CSL   =   0u,   /* CD0 clock domain = High-speed CR clock    */
    }; 
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;  
    SYSC1.unRUNCKSELR1.stcField     =   (stc_sysc1_runckselr1_field_t)
    {     
        .u4CD4CSL   =  0,  /* CD4 clock domain = High-speed CR clock   */
        .u4CD3CSL   =  0,  /* CD3 clock domain = High-speed CR clock   */
        .u4CD2CSL   =  0,  /* CD2 clock domain = High-speed CR clock   */
        .u4CD1CSL   =  0   /* CD1 clock domain = High-speed CR clock   */
    };  
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;    
    SYSC1.unRUNCKSELR2.stcField     =   (stc_sysc1_runckselr2_field_t)
    {     
        .u3TRCCSL   =  0,  /* TRC clock = High-speed CR clock         */
        .u4CD5CSL   =  0   /* CD5 clock domain = High-speed CR clock  */
    }; 
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;  
    SYSC1.unRUNCKDIVR0.stcField     =   (stc_sysc1_runckdivr0_field_t)
    {  
        .u3HPMDIV = 0, /*No division  */
        .u5SYSDIV = 0  /*No division  */
    }; 
    
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK; 
    SYSC0_1.unRUNCKDIVR.stcField    =   (stc_sysc0_1_runckdivr_field_t)
    {    
        .u5MCUCHDIV  = 0  /* AHB No division*/
    }; 
    

    /*ȡ״̬λ*/
    ErrorFlag = SYSC0_SYSRUNPEFR;
    while ((ErrorFlag & 0x7FBu) != 0u)
    {
        ErrorFlag = SYSC0_SYSRUNPEFR;
    }
    
    /* RUN Profile update enable*/
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;   
    SYSC1_RUNENR_0_RUNEN1 = 0xABu;
    
    /* Write the trigger value to apply the RUN profile*/
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK;   
    SYSC0_TRGRUNCNTR = 0xABu;
    
    /* Wait until the RUN profile is applied*/
    while (SYSC0_SYSSTSR_RUNDF0 == 0u)
    {
        
    }
    
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK;  
    SYSC0_SYSICLR_RUNDFCLR0 = 1u;
    
    /*------------------------------------------------------------------*/
    /*  SamplePSS_RTCshutdown*/
    /*------------------------------------------------------------------*/
    
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK; 
    SYSC0_1.unPSSPDCFGR.stcField    =   (stc_sysc0_1_psspdcfgr_field_t)
    { 
        .u1PD2EN   = 0,
        .u1PD4_0EN = 1,
        .u1PD4_1EN = 1,
    };
    
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK;  
    SYSC0_1.unPSSCKSRER.stcField    =   (stc_sysc0_1_psscksrer_field_t)
    { 
        .u1SSCG0EN  = 0, 
        .u1PLL0EN   = 0,
        .u1SCROSCEN = 1, /*Low-speed CR clock oscillation enable       */
        .u1SOSCEN   = 0, /*ʹ 32.768                                 */
        .u1MOSCEN   = 1, /*ʹ 8M                                     */
        .u1CROSCEN  = 0  /*High-speed CR clock oscillation enable bit  */
    };
    
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK;  
    SYSC0_1.unPSSCKSELR.stcField    =   (stc_sysc0_1_pssckselr_field_t)
    { 
        .u3CDMCUCCSL  = 7,  /*Ƿ 7 L-Fixed */
    };

    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK;  
    SYSC0_1.unPSSCKER.stcField    =   (stc_sysc0_1_psscker_field_t)
    { 
        .u1ENCLKMCUCH  = 0u, /*Disable APB AHB clock oscillation.*/
    };
    
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK; 
    SYSC0_1.unPSSCKDIVR.stcField    =   (stc_sysc0_1_pssckdivr_field_t)
    { 
        .u5MCUCHDIV  = 0u,  /*APB No division*/
    };
    
    /*//
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC0_1.unPSSPLL0CNTR.stcField    =   (stc_sysc0_1_psspll0cntr_field_t)
    {
        .u1PLL0ISEL = 0,  //Main clock
        .u8PLL0DIVN = 7,  //Multiply by 7
        .u4PLL0DIVM = 8,  //Divided by 8
        .u2PLL0DIVL = 0
    };
    
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK; 
    SYSC0_1.unPSSSSCG0CNTR0.stcField    =   (stc_sysc0_1_psssscg0cntr0_field_t)
    {
        .u1SSCG0ISEL = 1,  //High-speed CR clock
        .u8SSCG0DIVN = 7,  //Multiply by 7
        .u4SSCG0DIVM = 8,  //Divided by 8
        .u2SSCG0DIVL = 0
    };
    */
    
    //SYSC0_PROTKEYR = SYSC_KEY_UNLOCK; 
    //SYSC0_1.unRUNLVDCFGR.stcField    =   (stc_sysc0_1_psslvdcfgr_field_t)
    //{
    //    .u1LVDL1S = 0,
    //    .u3LVDL1V = 0,
    //    .u1LVDL1E = 0,
    //    .u1LVDH1S = 0,
    //    .u3LVDH1V = 0,
    //    .u1LVDH1E = 0,
    //    .u1LVDH2S = 0,
    //    .u3LVDH2V = 0,
    //    .u1LVDH2E = 0
    //};
    
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK; /*SSCG0 ʱ*/
    SYSC0_1.unPSSSSCG0CNTR1.stcField    =   (stc_sysc0_1_psssscg0cntr1_field_t)
    {
        .u1SSCG0SSEN = 0,
        .u2SSCG0FREQ = 0,
        .u1SSCG0MODE = 0,
        .u10SSCG0RATE = 0  
    };
    
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK; 
    SYSC0_1.unPSSLVDCFGR.stcField    =   (stc_sysc0_1_psslvdcfgr_field_t)
    {
        .u1LVDL1S = 0,
        .u3LVDL1V = 0,
        .u1LVDL1E = 0,
        .u1LVDH1S = 0,
        .u3LVDH1V = 0,
        .u1LVDH1E = 0,
        .u1LVDH2S = 0,
        .u3LVDH2V = 0,
        .u1LVDH2E = 0
    };
    
    //SYSC0_PROTKEYR = SYSC_KEY_UNLOCK;
    //SYSC0_1.unRUNLVDCFGR.stcField    =   (stc_sysc0_1_runlvdcfgr_field_t)
    //{
    //    .u1LVDL1S = 0,
    //    .u3LVDL1V = 0,
    //    .u1LVDL1E = 0,
    //    .u1LVDH1S = 0,
    //    .u3LVDH1V = 0,
    //    .u1LVDH1E = 0,
    //    .u1LVDH2S = 0,
    //    .u3LVDH2V = 0,
    //    .u1LVDH2E = 0
    //};
       
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK;  
    SYSC0_1.unPSSCSVCFGR.stcField    =   (stc_sysc0_1_psscsvcfgr_field_t)
    {
        .u1SSCG0CSVE = 0,
        .u1PLL0CSVE = 0,
        .u1SCRCSVE = 0,
        .u1CRCSVE = 0,
        .u1MOCSVE = 0,
        .u1SOCSVE = 0,
    };

    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK; 
    SYSC0_1.unPSSREGCFGR.stcField    =   (stc_sysc0_1_pssregcfgr_field_t)
    {
        .u1RMSEL = 1,  /* Standby mode */
    };
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;  
    SYSC1.unPSSCKSELR0.stcField    =   (stc_sysc1_pssckselr0_field_t)
    {
        .u3CD0CSL    = 1,  /*CD0 = Low-speed CR clock  */
        .u1LCP0ACSL  = 0,  /*CD0                       */
        .u1LCP1ACSL  = 0,  /*CD0                       */
        .u1LAPP0ACSL = 0,  /*CD0                       */
        .u1LAPP1ACSL = 0,  /*CD0                       */
        .u4HSSPICSL  = 1   /*Low-speed CR clock        */
    };
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1.unPSSCKSELR1.stcField     =   (stc_sysc1_pssckselr1_field_t)
    {  
        .u4CD4CSL   =   1,  /*Low-speed CR clock   */
        .u4CD3CSL   =   1,  /*Low-speed CR clock   */
        .u4CD2CSL   =   1,  /*Low-speed CR clock   */
        .u4CD1CSL   =   1   /*Low-speed CR clock   */
    };
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1.unPSSCKSELR2.stcField     =   (stc_sysc1_pssckselr2_field_t)
    {    
        .u3TRCCSL   =   1,  /* TRC clock = Low-speed CR clock          */                                                      
        .u4CD5CSL   =   1   /* CD5 clock domain = Low-speed CR clock   */
    };
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;  
    SYSC1.unPSSCKER1.stcField       =   (stc_sysc1_psscker1_field_t) 
    {      
        .u1ENCLKCD3B1   =   0,  /* CD3B1   Graphics Subsystem \ Hyperbus Interface (GDC)        */
        .u1ENCLKCD3B0   =   0,  /* CD3B0                                                          */
        .u1ENCLKCD3A1   =   0,  /* CD3A1                                                          */
        .u1ENCLKCD3A0   =   0,  /* CD3A0                                                          */
        .u1ENCLKCD3     =   0,  /* CD3                                                            */
        .u1ENCLKCD2B1   =   0,  /* CD2B1   Graphics Subsystem \ FPD-LINK Converter              */
        .u1ENCLKCD2B0   =   0,  /* CD2B0                                                          */
        .u1ENCLKCD2A1   =   0,  /* CD2A1                                                          */
        .u1ENCLKCD2A0   =   0,  /* CD2A0                                                          */
        .u1ENCLKCD2     =   0,  /* CD2                                                            */
        .u1ENCLKCD1B1   =   0,  /* CD1B1   Hyperbus Interface (MCU) \ Hyperbus Interface (GDC)  */
        .u1ENCLKCD1B0   =   0,  /* CD1B0                                                          */
        .u1ENCLKCD1A1   =   0,  /* CD1A1                                                          */
        .u1ENCLKCD1A0   =   0,  /* CD1A0                                                          */
        .u1ENCLKCD1     =   0,  /* CD1                                                            */
        .u1ENCLKHSSPI   =   0   /* HSSPI                                                          */
    };
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1.unPSSCKER2.stcField       =   (stc_sysc1_psscker2_field_t)
    {     
        .u1ENCLKCD5B1   =   0,  /* CD5B1   Sound Waveform Generator \ Stereo Audio DAC           */
        .u1ENCLKCD5B0   =   0,  /* CD5B0                                                           */
        .u1ENCLKCD5A1   =   0,  /* CD5A1                                                           */
        .u1ENCLKCD5A0   =   0,  /* CD5A0                                                           */
        .u1ENCLKCD5     =   0,  /* CD5                                                             */
        .u1ENCLKCD4B1   =   0,  /* CD4B1   Inter IC Sound (I2S) \ PCMPWM \ Stereo Audio DAC      */
        .u1ENCLKCD4B0   =   0,  /* CD4B0                                                           */
        .u1ENCLKCD4A1   =   0,  /* CD4A1                                                           */
        .u1ENCLKCD4A0   =   0,  /* CD4A0                                                           */
        .u1ENCLKCD4     =   0   /* CD4                                                             */
    };
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK; 
    SYSC1.unPSSCKER0.stcField       =   (stc_sysc1_psscker0_field_t) 
    {      
        .u1ENCLKCPU0    =   0,      /* CPU0                       */
        .u1ENCLKATB     =   0,      /* ATB                        */
        .u1ENCLKDBG     =   0,      /* DBG                        */
        .u1ENCLKTRC     =   0,      /* TRC    debug            */
        .u1ENCLKHPM2    =   0,      /* HPM2                       */
        .u1ENCLKHPM     =   0,      /* HPM                        */
        .u1ENCLKDMA     =   0,      /* DMA                        */
        .u1ENCLKMEMC    =   0,      /* MEMC                       */
        .u1ENCLKEXTBUS  =   0,      /* EXTBUS                     */
        .u1ENCLKSYSC1   =   0,      /* SYSC1                      */
        .u1ENCLKHAPP0A0 =   0,      /* HAPP0A0                    */
        .u1ENCLKHAPP0A1 =   0,      /* HAPP0A1                    */
        .u1ENCLKHAPP1B0 =   0,      /* HAPP1B0                    */
        .u1ENCLKHAPP1B1 =   0,      /* HAPP1B1                    */
        .u1ENCLKLLPBM   =   0,      /* LLPBM                      */
        .u1ENCLKLLPBM2  =   0,      /* LLPBM2                     */
        .u1ENCLKLCP     =   0,      /* LCP                        */
        .u1ENCLKLCP0    =   0,      /* LCP0                       */
        .u1ENCLKLCP1    =   0,      /* LCP1                       */
        .u1ENCLKLAPP0   =   0,      /* LAPP0                      */
        .u1ENCLKLAPP1   =   0,      /* LAPP1                      */
        .u1ENCLKLCP0A   =   0,      /* LCP0A                      */
        .u1ENCLKLCP1A   =   0,      /* LCP1A   ------------ADC  */
        .u1ENCLKLAPP0A  =   0,      /* LAPP0A                     */
        .u1ENCLKLAPP1A  =   0       /* LAPP1A                     */
    };
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1_PSSCKDIVR0 = 0x00000000u; 	
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1_PSSCKDIVR1 = 0x00000000u; 	
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1_PSSCKDIVR2 = 0x00000000u; 	
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1_PSSCKDIVR3 = 0x00000000u; 	
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1_PSSCKDIVR4 = 0x00000000u; 	
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1_PSSCKDIVR5 = 0x00000000u; 	
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1_PSSCKDIVR6 = 0x00000000u; 	
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1_PSSCKDIVR7 = 0x00000000u; 	
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1_PSSCKDIVR8 = 0x00000000u; 	
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1_PSSCKDIVR9 = 0x00000000u; 	
    
    ErrorFlag = SYSC0_SYSPSSPEFR;
    while((ErrorFlag & 0x7FBu) != 0u)
    {
        ErrorFlag = SYSC0_SYSPSSPEFR;
    }
    
    /* PSS profile update enable*/
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK;  
    SYSC0_SYSICLR_PSSDFCLR0      = 1u;
    
    SYSC1_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC1_PSSENR_0_PSSEN1 = 0xBAu;
    SYSC0_PROTKEYR = SYSC_KEY_UNLOCK;
    SYSC0_PSSENR_0_PSSEN0 = 0xBAu;
    
    while (SYSC0_SYSSTSR_PSSSTS0 == 1u) {
        ;
    }
    
    DSB();
    ISB();
    
    __WFI();
    TestBackupRam = 0xaabbccddu;
    IRQ_DISABLE_LOCAL();
    HWDG_TRG0 = 123456u;
    HWDG_TRG1 = 123456u;
    IRQ_RESTORE();
}
