/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_WFCFG_H
#define __S6J3360_WFCFG_H

#include "s6j3360io_basetypes.h"

/* WFCFG base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define WFCFG	stcWFCFG
#else /* __IO_DEFINE */
#define WFCFG	(*((volatile stc_wfcfg_t*)0xB0412000))
#endif /* __IO_DEFINE */

/* CPR */
#define WFCFG_CPR	(WFCFG.unCPR.u32Register)  /*@rg@*/
#define WFCFG_CPR_CPR	WFCFG_CPR  /*@bfrg@*/

typedef union un_wfcfg_cpr{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_cpr_t;

/* CR */
#define WFCFG_CR	(WFCFG.unCR.u32Register)  /*@rg@*/
#define WFCFG_CR_FAWC	(WFCFG.unCR.stcField.u4FAWC)  /*@bf@*/
#define WFCFG_CR_WE	(*(volatile uint_io8_t*)0xB1190048)  /*@bfbba@*/
#define WFCFG_CR_SWFRST	(*(volatile uint_io8_t*)0xB1190050)  /*@bfbba@*/

typedef struct stc_wfcfg_cr_field{
    uint_io32_t		u4FAWC:4;
    uint_io32_t		:4;
    uint_io32_t		u1WE:1;
    uint_io32_t		:7;
    uint_io32_t		u1SWFRST:1;
    uint_io32_t		:15;
}stc_wfcfg_cr_field_t;

typedef union un_wfcfg_cr{
    uint_io32_t		u32Register;
    stc_wfcfg_cr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_cr_t;

/* WCR */
#define WFCFG_WCR	(WFCFG.unWCR.u32Register)  /*@rg@*/
#define WFCFG_WCR_DMAEN	(*(volatile uint_io8_t*)0xB1190080)  /*@bfbba@*/

typedef struct stc_wfcfg_wcr_field{
    uint_io32_t		u1DMAEN:1;
    uint_io32_t		:31;
}stc_wfcfg_wcr_field_t;

typedef union un_wfcfg_wcr{
    uint_io32_t		u32Register;
    stc_wfcfg_wcr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_wcr_t;

/* WSR */
#define WFCFG_WSR	(WFCFG.unWSR.u32Register)  /*@rg@*/
#define WFCFG_WSR_ST	(WFCFG.unWSR.stcField.u2ST)  /*@bf@*/

typedef struct stc_wfcfg_wsr_field{
    uint_io32_t		u2ST:2;
    uint_io32_t		:30;
}stc_wfcfg_wsr_field_t;

typedef union un_wfcfg_wsr{
    uint_io32_t		u32Register;
    stc_wfcfg_wsr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_wsr_t;

/* EEIR */
#define WFCFG_EEIR	(WFCFG.unEEIR.u32Register)  /*@rg@*/
#define WFCFG_EEIR_EEIR	(WFCFG.unEEIR.stcField.u7EEIR)  /*@bf@*/

typedef struct stc_wfcfg_eeir_field{
    uint_io32_t		u7EEIR:7;
    uint_io32_t		:25;
}stc_wfcfg_eeir_field_t;

typedef union un_wfcfg_eeir{
    uint_io32_t		u32Register;
    stc_wfcfg_eeir_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_eeir_t;

/* ICR */
#define WFCFG_ICR	(WFCFG.unICR.u32Register)  /*@rg@*/
#define WFCFG_ICR_RDYIE	(*(volatile uint_io8_t*)0xB1190120)  /*@bfbba@*/
#define WFCFG_ICR_HANGIE	(*(volatile uint_io8_t*)0xB1190121)  /*@bfbba@*/
#define WFCFG_ICR_RDYIC	(*(volatile uint_io8_t*)0xB1190128)  /*@bfbba@*/
#define WFCFG_ICR_HANGIC	(*(volatile uint_io8_t*)0xB1190129)  /*@bfbba@*/

typedef struct stc_wfcfg_icr_field{
    uint_io32_t		u1RDYIE:1;
    uint_io32_t		u1HANGIE:1;
    uint_io32_t		:6;
    uint_io32_t		u1RDYIC:1;
    uint_io32_t		u1HANGIC:1;
    uint_io32_t		:22;
}stc_wfcfg_icr_field_t;

typedef union un_wfcfg_icr{
    uint_io32_t		u32Register;
    stc_wfcfg_icr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_icr_t;

/* SR */
#define WFCFG_SR	(WFCFG.unSR.u32Register)  /*@rg@*/
#define WFCFG_SR_RDY	(*(volatile uint_io8_t*)0xB1190140)  /*@bfbba@*/
#define WFCFG_SR_SERS	(*(volatile uint_io8_t*)0xB1190143)  /*@bfbba@*/
#define WFCFG_SR_ESPS	(*(volatile uint_io8_t*)0xB1190145)  /*@bfbba@*/
#define WFCFG_SR_RDYINT	(*(volatile uint_io8_t*)0xB1190148)  /*@bfbba@*/
#define WFCFG_SR_HANGINT	(*(volatile uint_io8_t*)0xB1190149)  /*@bfbba@*/
#define WFCFG_SR_WERINT	(*(volatile uint_io8_t*)0xB119014C)  /*@bfbba@*/

typedef struct stc_wfcfg_sr_field{
    uint_io32_t		u1RDY:1;
    uint_io32_t		:2;
    uint_io32_t		u1SERS:1;
    uint_io32_t		:1;
    uint_io32_t		u1ESPS:1;
    uint_io32_t		:2;
    uint_io32_t		u1RDYINT:1;
    uint_io32_t		u1HANGINT:1;
    uint_io32_t		:2;
    uint_io32_t		u1WERINT:1;
    uint_io32_t		:19;
}stc_wfcfg_sr_field_t;

typedef union un_wfcfg_sr{
    uint_io32_t		u32Register;
    stc_wfcfg_sr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_sr_t;

/* SECIR */
#define WFCFG_SECIR	(WFCFG.unSECIR.u32Register)  /*@rg@*/
#define WFCFG_SECIR_SECIE	(*(volatile uint_io8_t*)0xB1190160)  /*@bfbba@*/
#define WFCFG_SECIR_SECIC	(*(volatile uint_io8_t*)0xB1190168)  /*@bfbba@*/
#define WFCFG_SECIR_SECINT	(*(volatile uint_io8_t*)0xB1190170)  /*@bfbba@*/
#define WFCFG_SECIR_SYN	(WFCFG.unSECIR.stcField.u7SYN)  /*@bf@*/

typedef struct stc_wfcfg_secir_field{
    uint_io32_t		u1SECIE:1;
    uint_io32_t		:7;
    uint_io32_t		u1SECIC:1;
    uint_io32_t		:7;
    uint_io32_t		u1SECINT:1;
    uint_io32_t		:7;
    uint_io32_t		u7SYN:7;
    uint_io32_t		:1;
}stc_wfcfg_secir_field_t;

typedef union un_wfcfg_secir{
    uint_io32_t		u32Register;
    stc_wfcfg_secir_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_secir_t;

/* EEAR */
#define WFCFG_EEAR	(WFCFG.unEEAR.u32Register)  /*@rg@*/
#define WFCFG_EEAR_EEAR	WFCFG_EEAR  /*@bfrg@*/

typedef union un_wfcfg_eear{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_eear_t;

/* EMENR */
#define WFCFG_EMENR	(WFCFG.unEMENR.u32Register)  /*@rg@*/
#define WFCFG_EMENR_EMEN	(*(volatile uint_io8_t*)0xB11901C0)  /*@bfbba@*/
#define WFCFG_EMENR_AEE	(*(volatile uint_io8_t*)0xB11901C8)  /*@bfbba@*/

typedef struct stc_wfcfg_emenr_field{
    uint_io32_t		u1EMEN:1;
    uint_io32_t		:7;
    uint_io32_t		u1AEE:1;
    uint_io32_t		:23;
}stc_wfcfg_emenr_field_t;

typedef union un_wfcfg_emenr{
    uint_io32_t		u32Register;
    stc_wfcfg_emenr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_emenr_t;

/* SEQCM */
#define WFCFG_SEQCM	(WFCFG.unSEQCM.u32Register)  /*@rg@*/
#define WFCFG_SEQCM_OPC	(WFCFG.unSEQCM.stcField.u4OPC)  /*@bf@*/
#define WFCFG_SEQCM_ERS	(WFCFG.unSEQCM.au8Byte[2])  /*@bfbyte@*/

typedef struct stc_wfcfg_seqcm_field{
    uint_io32_t		u4OPC:4;
    uint_io32_t		:12;
    uint_io32_t		u8ERS:8;
    uint_io32_t		:8;
}stc_wfcfg_seqcm_field_t;

typedef union un_wfcfg_seqcm{
    uint_io32_t		u32Register;
    stc_wfcfg_seqcm_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_seqcm_t;

/* ARBERR */
#define WFCFG_ARBERR	(WFCFG.unARBERR.u32Register)  /*@rg@*/
#define WFCFG_ARBERR_ARBERR	(*(volatile uint_io8_t*)0xB11902C0)  /*@bfbba@*/

typedef struct stc_wfcfg_arberr_field{
    uint_io32_t		u1ARBERR:1;
    uint_io32_t		:31;
}stc_wfcfg_arberr_field_t;

typedef union un_wfcfg_arberr{
    uint_io32_t		u32Register;
    stc_wfcfg_arberr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_arberr_t;

/* ARBCLR */
#define WFCFG_ARBCLR	(WFCFG.unARBCLR.u32Register)  /*@rg@*/
#define WFCFG_ARBCLR_ARBCLR	(*(volatile uint_io8_t*)0xB11902E0)  /*@bfbba@*/

typedef struct stc_wfcfg_arbclr_field{
    uint_io32_t		u1ARBCLR:1;
    uint_io32_t		:31;
}stc_wfcfg_arbclr_field_t;

typedef union un_wfcfg_arbclr{
    uint_io32_t		u32Register;
    stc_wfcfg_arbclr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_arbclr_t;

/* BERR */
#define WFCFG_BERR	(WFCFG.unBERR.u32Register)  /*@rg@*/
#define WFCFG_BERR_DED	(*(volatile uint_io8_t*)0xB1190300)  /*@bfbba@*/
#define WFCFG_BERR_CRWE	(*(volatile uint_io8_t*)0xB1190301)  /*@bfbba@*/
#define WFCFG_BERR_SIZE	(*(volatile uint_io8_t*)0xB1190302)  /*@bfbba@*/
#define WFCFG_BERR_RWE	(*(volatile uint_io8_t*)0xB1190304)  /*@bfbba@*/
#define WFCFG_BERR_RESA	(*(volatile uint_io8_t*)0xB1190305)  /*@bfbba@*/
#define WFCFG_BERR_UNACC	(*(volatile uint_io8_t*)0xB1190306)  /*@bfbba@*/
#define WFCFG_BERR_ECRWL	(*(volatile uint_io8_t*)0xB1190307)  /*@bfbba@*/
#define WFCFG_BERR_ACCIGN	(*(volatile uint_io8_t*)0xB1190308)  /*@bfbba@*/
#define WFCFG_BERR_NWTM	(*(volatile uint_io8_t*)0xB1190309)  /*@bfbba@*/
#define WFCFG_BERR_RORW	(*(volatile uint_io8_t*)0xB119030A)  /*@bfbba@*/
#define WFCFG_BERR_ERSERR	(*(volatile uint_io8_t*)0xB119030B)  /*@bfbba@*/

typedef struct stc_wfcfg_berr_field{
    uint_io32_t		u1DED:1;
    uint_io32_t		u1CRWE:1;
    uint_io32_t		u1SIZE:1;
    uint_io32_t		:1;
    uint_io32_t		u1RWE:1;
    uint_io32_t		u1RESA:1;
    uint_io32_t		u1UNACC:1;
    uint_io32_t		u1ECRWL:1;
    uint_io32_t		u1ACCIGN:1;
    uint_io32_t		u1NWTM:1;
    uint_io32_t		u1RORW:1;
    uint_io32_t		u1ERSERR:1;
    uint_io32_t		:20;
}stc_wfcfg_berr_field_t;

typedef union un_wfcfg_berr{
    uint_io32_t		u32Register;
    stc_wfcfg_berr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_berr_t;

/* BERRCLR */
#define WFCFG_BERRCLR	(WFCFG.unBERRCLR.u32Register)  /*@rg@*/
#define WFCFG_BERRCLR_DEDCLR	(*(volatile uint_io8_t*)0xB1190320)  /*@bfbba@*/
#define WFCFG_BERRCLR_CRWECLR	(*(volatile uint_io8_t*)0xB1190321)  /*@bfbba@*/
#define WFCFG_BERRCLR_SIZECLR	(*(volatile uint_io8_t*)0xB1190322)  /*@bfbba@*/
#define WFCFG_BERRCLR_RWECLR	(*(volatile uint_io8_t*)0xB1190324)  /*@bfbba@*/
#define WFCFG_BERRCLR_RESACLR	(*(volatile uint_io8_t*)0xB1190325)  /*@bfbba@*/
#define WFCFG_BERRCLR_UNACCLR	(*(volatile uint_io8_t*)0xB1190326)  /*@bfbba@*/
#define WFCFG_BERRCLR_ECRWLCLR	(*(volatile uint_io8_t*)0xB1190327)  /*@bfbba@*/
#define WFCFG_BERRCLR_ACCIGNCLR	(*(volatile uint_io8_t*)0xB1190328)  /*@bfbba@*/
#define WFCFG_BERRCLR_NWTMCLR	(*(volatile uint_io8_t*)0xB1190329)  /*@bfbba@*/
#define WFCFG_BERRCLR_RORWCLR	(*(volatile uint_io8_t*)0xB119032A)  /*@bfbba@*/
#define WFCFG_BERRCLR_ERSERRCLR	(*(volatile uint_io8_t*)0xB119032B)  /*@bfbba@*/

typedef struct stc_wfcfg_berrclr_field{
    uint_io32_t		u1DEDCLR:1;
    uint_io32_t		u1CRWECLR:1;
    uint_io32_t		u1SIZECLR:1;
    uint_io32_t		:1;
    uint_io32_t		u1RWECLR:1;
    uint_io32_t		u1RESACLR:1;
    uint_io32_t		u1UNACCLR:1;
    uint_io32_t		u1ECRWLCLR:1;
    uint_io32_t		u1ACCIGNCLR:1;
    uint_io32_t		u1NWTMCLR:1;
    uint_io32_t		u1RORWCLR:1;
    uint_io32_t		u1ERSERRCLR:1;
    uint_io32_t		:20;
}stc_wfcfg_berrclr_field_t;

typedef union un_wfcfg_berrclr{
    uint_io32_t		u32Register;
    stc_wfcfg_berrclr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_berrclr_t;

/* WARBR */
#define WFCFG_WARBR	(WFCFG.unWARBR.u32Register)  /*@rg@*/
#define WFCFG_WARBR_WERINTE	(*(volatile uint_io8_t*)0xB1190340)  /*@bfbba@*/
#define WFCFG_WARBR_WERINTCLR	(*(volatile uint_io8_t*)0xB1190348)  /*@bfbba@*/
#define WFCFG_WARBR_WERINT	(*(volatile uint_io8_t*)0xB1190350)  /*@bfbba@*/
#define WFCFG_WARBR_WERSTS	(*(volatile uint_io8_t*)0xB1190358)  /*@bfbba@*/

typedef struct stc_wfcfg_warbr_field{
    uint_io32_t		u1WERINTE:1;
    uint_io32_t		:7;
    uint_io32_t		u1WERINTCLR:1;
    uint_io32_t		:7;
    uint_io32_t		u1WERINT:1;
    uint_io32_t		:7;
    uint_io32_t		u1WERSTS:1;
    uint_io32_t		:7;
}stc_wfcfg_warbr_field_t;

typedef union un_wfcfg_warbr{
    uint_io32_t		u32Register;
    stc_wfcfg_warbr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_warbr_t;

/* UCESR */
#define WFCFG_UCESR	(WFCFG.unUCESR.u32Register)  /*@rg@*/
#define WFCFG_UCESR_SYN	(WFCFG.unUCESR.stcField.u7SYN)  /*@bf@*/

typedef struct stc_wfcfg_ucesr_field{
    uint_io32_t		:24;
    uint_io32_t		u7SYN:7;
    uint_io32_t		:1;
}stc_wfcfg_ucesr_field_t;

typedef union un_wfcfg_ucesr{
    uint_io32_t		u32Register;
    stc_wfcfg_ucesr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_ucesr_t;

/* UCEAR */
#define WFCFG_UCEAR	(WFCFG.unUCEAR.u32Register)  /*@rg@*/
#define WFCFG_UCEAR_UCEA	WFCFG_UCEAR  /*@bfrg@*/

typedef union un_wfcfg_ucear{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_ucear_t;

/* DBEIR */
#define WFCFG_DBEIR	(WFCFG.unDBEIR.u32Register)  /*@rg@*/
#define WFCFG_DBEIR_DBEIR	WFCFG_DBEIR  /*@bfrg@*/

typedef union un_wfcfg_dbeir{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_wfcfg_dbeir_t;


typedef struct stc_wfcfg{
    un_wfcfg_cpr_t	unCPR;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[4];	/* 0x00000004 */
    un_wfcfg_cr_t	unCR;	/* 0x00000008 */
    uint_io8_t	au8Reserved1[4];	/* 0x0000000C */
    un_wfcfg_wcr_t	unWCR;	/* 0x00000010 */
    un_wfcfg_wsr_t	unWSR;	/* 0x00000014 */
    uint_io8_t	au8Reserved2[4];	/* 0x00000018 */
    un_wfcfg_eeir_t	unEEIR;	/* 0x0000001C */
    uint_io8_t	au8Reserved3[4];	/* 0x00000020 */
    un_wfcfg_icr_t	unICR;	/* 0x00000024 */
    un_wfcfg_sr_t	unSR;	/* 0x00000028 */
    un_wfcfg_secir_t	unSECIR;	/* 0x0000002C */
    un_wfcfg_eear_t	unEEAR;	/* 0x00000030 */
    uint_io8_t	au8Reserved4[4];	/* 0x00000034 */
    un_wfcfg_emenr_t	unEMENR;	/* 0x00000038 */
    uint_io8_t	au8Reserved5[24];	/* 0x0000003C */
    un_wfcfg_seqcm_t	unSEQCM;	/* 0x00000054 */
    un_wfcfg_arberr_t	unARBERR;	/* 0x00000058 */
    un_wfcfg_arbclr_t	unARBCLR;	/* 0x0000005C */
    un_wfcfg_berr_t	unBERR;	/* 0x00000060 */
    un_wfcfg_berrclr_t	unBERRCLR;	/* 0x00000064 */
    un_wfcfg_warbr_t	unWARBR;	/* 0x00000068 */
    un_wfcfg_ucesr_t	unUCESR;	/* 0x0000006C */
    un_wfcfg_ucear_t	unUCEAR;	/* 0x00000070 */
    uint_io8_t	au8Reserved6[4];	/* 0x00000074 */
    un_wfcfg_dbeir_t	unDBEIR;	/* 0x00000078 */
    uint_io8_t	au8Reserved7[132];	/* 0x0000007C */
}stc_wfcfg_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_wfcfg_t	stcWFCFG;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 256(0x100) bytes */


#endif /* __S6J3360_WFCFG_H */
