/******************************************************************************
 * $Revision: 423 $
 * $Date:: 2017-04-07 16:03:30 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************/
/** \file hwdg.h
 **
 ** Sample program for hardware watchdog timer.
 **
 ** History:
 **   - 2014-05-16  0.01  HS  Initial version for Traveo
 *****************************************************************************/

#ifndef __HWDG_H__
#define __HWDG_H__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "base_types.h"

/* C binding of definitions if building with C++ compiler */
#ifdef __cplusplus
extern "C" {
#endif

/**
 *****************************************************************************
 ** \defgroup HwdgGroup Hardware watchdog (HWDG)
 **
 ** \brief This section describes the interface for the Hardware Watchdog.
 **
 ** Provided functions of Hwdg module:
 **
 ** - Hwdg_Init()
 ** - Hwdg_GetResetCause()
 ** - Hwdg_Clear()
 ** - Hwdg_GetCounterValue()
 **
 ** Hwdg_Init() is used to initialize Hwdg with parameter pstcConfig of type #stc_hwdg_config_t.
 ** This function can be used only once after a reset.
 ** Hwdg_GetResetCause() is used to get Hwdg reset cause. Must be use before
 ** calling Hwdg_Init().
 ** Hwdg_Clear() is used to clear watchdog counter.
 ** Hwdg_GetCounterValue() is used to current watchdog counter.
 **
 ** If application use this module, it has to use these APIs by combining.
 **
 *****************************************************************************/
/*! @{ */


/*****************************************************************************/
/* Global pre-processor symbols/macros ('#define')                           */
/*****************************************************************************/

/*****************************************************************************/
/* Global type definitions ('typedef')                                       */
/*****************************************************************************/
typedef struct stc_hwdg_config
{
    /*! Callback to get prior warning notification in case of WDG error */
    func_ptr_t              pfnPreWarnCallback;
    /*! Callback to get NMI notification in case of WDG error */
    func_ptr_t              pfnNmiCallback;
} stc_hwdg_config_t;

/**
 *****************************************************************************
 ** \brief HWDG reset cause
 *****************************************************************************/
typedef struct stc_hwdg_reset_cause
{
    /*! HWDG counter was triggered while HWDG was still unlocked */
    boolean_t bHwdgTriggerWhileUnlocked;
    /*! HWDG counter was triggered before lower limit was reached */
    boolean_t bHwdgTriggerTooEarly;
    /*! HWDG counter reached upper limit */
    boolean_t bHwdgNotTriggered;
    /*! The trigger functions were called in the wrong order */
    boolean_t bHwdgTriggerSequenceViolated;
    /*! The key value for trigger 0 or 1 was wrong */
    boolean_t bHwdgWrongTriggerValue;
} stc_hwdg_reset_cause_t;

/*****************************************************************************/
/* Global variable declarations ('extern', definition in C source)           */
/*****************************************************************************/

/*****************************************************************************/
/* Global function prototypes ('extern', definition in C source)             */
/*****************************************************************************/
en_result_t Hwdg_Init(const stc_hwdg_config_t *pstcConfig);
en_result_t Hwdg_GetResetCause(stc_hwdg_reset_cause_t* pstcResetCause);
en_result_t Hwdg_Clear(uint8_t u8TrgVal0, uint8_t u8TrgVal1);
uint32_t Hwdg_GetCounterValue(void);

/*! @} */
#ifdef __cplusplus
}
#endif

#endif /* __HWDG_H__ */
