
#include "NVS_Test.h"

uint32_t BenCiXieRuNum = 0U;
uint32_t TotalExecutionNum = 0U;
uint32_t LastNum = 0U;
uint32_t BeforeLastNum = 0U;
uint32_t ReceivedValue = 0U;
uint8_t RenWuDelay = 0U;
uint8_t errNum = 0U;
uint32_t JieShouDaoValue = 0U;
uint32_t JieShouDaoHistoryVal = 0U;
uint16_t BenCiShangDianZhiXingCount = 0U;
uint16_t huifudelayCount = 0U;
uint8_t StopFlag = 0U;
uint32_t RS485TXBenCiXieRuNum = 0u;
uint32_t RS485TXTotalExecutionNum = 0u;
uint8_t RerequestCount = 0U;
uint8_t UARTRxBufClean = 0u;

static void NVS_Test_BenCiXieRuNum(void);
static void NVS_Test_Rerequest(void);

void NVS_Test_Init(void)
{
    BenCiXieRuNum = 0U;
    TotalExecutionNum = 0U;
    LastNum = 0xFFFFFFFFU;
    BeforeLastNum = 0xFFFFFFFFU;
    ReceivedValue = 0U;    
    RenWuDelay = 0U;
    errNum = 0U;
    JieShouDaoValue = 0U;
    RS485_TX_finish = 2U;  /*发出的RS485信号标志位，初始化为2，不发不收*/
    BenCiShangDianZhiXingCount = 0U;
    huifudelayCount = 0U;
    StopFlag = 0U;
    RS485TXBenCiXieRuNum = 0u;
    RS485TXTotalExecutionNum = 0u;
    RerequestCount = 0U;
    UARTRxBufClean = 0U;
}

void NVS_Test_Service(void)
{
    

    if(RS485_TX_finish == 2U)
    {
        if (errNum == 0U)
        {
            BeforeLastNum = LastNum;
            LastNum = BenCiXieRuNum;
            NVS_Test_BenCiXieRuNum();
            RS485_TX_finish = 0U;/*上电后满足等待时间后，开始发第一帧信号*/
            RS485TXBenCiXieRuNum = BenCiXieRuNum;
            RS485TXTotalExecutionNum = TotalExecutionNum;
            huifudelayCount = 0u;
        } 
    }
    else if(RS485_TX_finish == 0U)
    {
        huifudelayCount = 0u;/*执行发的功能*/
    }
    else
    {   
        if(RS485_TX_finish == 3U)
        {
            
            huifudelayCount = 0u;
            UARTRxBufClean = 0U;
            if (TotalExecutionNum != 0U)
            {
                if(JieShouDaoValue != LastNum)
                {
                    if ((JieShouDaoValue == BeforeLastNum) && (BenCiShangDianZhiXingCount == 0U))
                    {
                        ;
                    }
                    else
                    {
                        errNum ++;
                    }
                    
                }
            }
            if (errNum == 0U)
            {
                StopFlag = 0u;
                RerequestCount = 0U;
                BenCiShangDianZhiXingCount ++;
                BeforeLastNum = LastNum;
                LastNum = BenCiXieRuNum;
                NVS_Test_BenCiXieRuNum();
                TotalExecutionNum ++;
                RS485TXBenCiXieRuNum = BenCiXieRuNum;
                RS485TXTotalExecutionNum = TotalExecutionNum;
                RS485_TX_finish = 0U;/*执行读的功能，对比完没问题再重新外发*/
            }
            else
            {
                if(RerequestCount < 3U)
                {
                    NVS_Test_Rerequest();
                    errNum = 0U;
                    RerequestCount ++;
                }
                else
                {
                    RS485_TX_finish = 0xFFU;/*不再执行任何收发操作*/
                }
            }
        }
        else
        {
            if (huifudelayCount > 400u)
            {
                if (UARTRxBufClean < 3u)
                {
                    UARTRxBufClean ++;
                }
                else
                {
                    RS485_UARTRxBuf_Clean();
                    UARTRxBufClean = 0U;
                }
                /*超过了8s没有回复,请求重发*/
                NVS_Test_Rerequest();
                huifudelayCount = 0;
            }
            else
            {
                huifudelayCount ++ ;/*等待仪表回复*/
            }
        }
    }
}

void NVS_Test_DelayCount(void)
{
    RenWuDelay ++ ;
}

static void NVS_Test_BenCiXieRuNum(void)
{
    uint32_t hahaha = (((BenCiXieRuNum * 7U) / 3U) + 257U);

    if (hahaha < 0xFFFFFFFF)
    {
        BenCiXieRuNum = hahaha;
    }
    else
    {
        BenCiXieRuNum = 1u;
    }
    
}

static void NVS_Test_Rerequest(void)
{
    StopFlag = 1u;
    RS485TXBenCiXieRuNum = 0xFFFFEEEEU;
    RS485TXTotalExecutionNum = 0xFFFFEEEEU;
    RS485_TX_finish = 0U;
}
