#include "main.h"
#include "Task.h"
#include "TYW_stdint.h"
#include "GenDelay.h"
#include "COM_CAN.h"
#include "RTE_GPIO.h"
#include "DoCAN_ISO15765.h"
#include "Flash_synchronizer.h"
#include "RTE_ADC.h"
#include "init.h"
#include "TFT_LCD.h"
#include "TM035HFZGZx.h"
#include "UDS_ISO14229_Server.h"
#include "CAN_Lib.h"
#include "Display_Info.h"
#include "Key.h"
#include "Check_Ctrl.h"
#include "FreIn_User.h"
#include "../UART/UART.h"
#include "string.h"
#include "api_RS485.h"
#include "RTE_WDT.h"
#include "R485_Communication_Matrix.h"
/*******************************************************************************
 *                                                                              *
 *   ϵͳ��������ģʽ(SYS_MODE_OFF / SYS_MODE_ON / SYS_MODE_STANDBY )�����б�   *
 *                                                                              *
 *******************************************************************************/

/*==============================================================================
αʵʱ����
------------------------------------------------------------------------------*/
uint8_t time100ms = 0;
uint8_t finish = 0;
uint8_t AutoFlag = 0;
uint32_t send0x42time = 0;
uint32_t bleOFFtoONtime = 0;
uint8_t startONfalg = 0;
uint32_t startIGONtime = 0;
uint8_t compareresult;
extern uint8_t keyopenble;
const unsigned char gImage_cuo1[] = {24, 24,0X00,0X00,0X00,0X00,0X30,0X70,0XE0,0XC0,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0XC0,0X70,0X30,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X83,0XC7,0X66,0X38,0X38,0X7C,0XE6,0XC3,0X81,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0C,0X0C,0X06,0X03,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X03,0X07,0X0E,0X0C,0X00,0X00,0X00,0X00,};
const unsigned char gImage_dui1[] = {24, 24,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0XC0,0XE0,0X40,0X00,0X00,0X00,0X00,0X08,0X18,0X30,0X70,0XC0,0X80,0X00,0X00,0X80,0XC0,0XE0,0X70,0X38,0X1C,0X0E,0X07,0X03,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X03,0X07,0X03,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};
void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void)
{    
    SD_FMQ = 1;
    DoCAN_Communication_Service( );
    if ( CAN_Msg_Tx_Enable != 0 )
    {
        UDS_Server_Application_Service( );
    }
    
    TFT_LCD_Display_Update_Service( );
    Fre_In_Service(FRE_VEHICLE);
    //Fre_In_Service(FRE_ENGINE);
}
/*============================================================================*/

/*==============================================================================
2ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_2ms_Tasks_Group(void)
{
    Can_Write_Fun(2);    //报文外发
    COM_RX_Process( );
    RTE_ADC_Services( );
        Get_static_Current();
}

/*==============================================================================
2ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_5ms_Tasks_Group(void)
{
}

/*==============================================================================
10ms����ִ������ ��0��
------------------------------------------------------------------------------*/
// uint8_t testdata[3] = {0,1,2};
uint8_t Openble[11] = {0};
uint32_t clearodotime;
uint32_t devicename = 0;
uint8_t sartigon = 0;
uint8_t sendflag = 0;
void Sys_Run_Mode_10ms_Tasks_Group(void)
{
    // BusOff_Service( );
    Key_Service( );
    if(devicename<0xFFFF)
    {
        devicename++;
    }
    else
    {
        devicename = 0;
    }
    if(firstpowerflag == 2)
    {
        if(clearOdoFlag == 0)
        {
         backsend();
            // RS485_TX_finish = 0;
            if(RS485_TX_finish == 0)
            {
                LINE_OUT_NEG_09 = 1;
                if(LINE_OUT_NEG_09 == 1)
                {
                    if(connectbleFlag == 0)
                    {
                        if(zhenduanflag == 0)
                        {
                            // R485_Send_Line_0x47(MENU_CHECK_STEP);
                            RS485_User_Tx_Data();
                            comparestart = 0;
                        }
                        else if(zhenduanflag == 1)
                        {
                            R485_Send_0x47();
                            comparestart = 0;
                        }
                        else if(zhenduanflag == 2)
                        {
                            R485_Sendcheck_0x47();
                        }
                        else
                        {
                            ;
                        }
                    }
                    else
                    { 
                                //   if(send0x42time<0xFFFFFFFF)
                                // {
                                //     send0x42time++;
                                // }
                                // if(bleOFFtoONtime<0xFFFFFFFF)
                                // {
                                //     bleOFFtoONtime++;
                                // }
                        if(RS485_TX_finish == 0)
                        {
                            
                            if(startONfalg == 0)
                            {
                                 if(send0x42time<130)
                                {
                                    // if(sendflag == 1)
                                    // {
                                        R485_Send_0x42();
                                    //     sendflag = 0;
                                    // }
                                    

                                    
                                    queren = 0;
                                }
                                else
                                {
                                    // bleOFFtoONtime = 0;
                                    LINE_OUT_NEG_01 = 0;
                                    LINE_OUT_NEG_02 = 0;
                                    LINE_OUT_NEG_03 = 0;
                                    LINE_OUT_NEG_04 = 0; 
                                    startONfalg = 1;
                                    Display_TFT_Clear();
                                }
                            }
                            else
                            {
                            if(startIGONtime  >= 50)
                            {
                                LINE_OUT_NEG_01 = 1;
                                LINE_OUT_NEG_02 = 1;
                                LINE_OUT_NEG_03 = 1;
                                LINE_OUT_NEG_04 = 1; 
                                if(startIGONtime >= 100)
                                {
                                    Openble[0] = 0x59;
                                    Openble[1] = 0x44;
                                    Openble[2] = 0xA;
                                    Openble[3] = 0x8A;
                                    Openble[4] = 0xA;
                                    Openble[5] = 0xA;
                                    Openble[6] = name2;
                                    Openble[7] = name1;
                                    Openble[8] = 1;
                                    Openble[9] = 0x4B;
                                    Openble[10] = 0x4A;
                                    
                                        // RS485_User_Tx_Data();
                                    if(sendflag == 1)
                                    {
                                        R485_Send_0x41();
                                        sendflag = 0;
                                    }
                                    else
                                    {
                                        R485_Send_0x80();
                                        sendflag = 1;
                                    }
                                    blename[4] = 0xFF;
                                    // if(send0x42time % 20 == 0)
                                    // {
                                        UART_Ch2_Send_Multiple_Byte(Openble,sizeof(Openble));
                                        // if(startIGONtime > 500)
                                        // {
                                        //     queren = 1;
                                        // }
                                        
                                    // }
                                }


                            }
                            }
                            RS485_send_time = 0;
                            RS485_TX_finish = 1;  
                        }
                        else
                        {

                        }
                                 
                    }
                    
                    
                }
                // else
                // {
                //     RS485_TX_finish = 0;
                // }
                
            }
            else
            {
                // backsend();
                LINE_OUT_NEG_09 = 0;
                if(LINE_OUT_NEG_09 == 0)
                {
                    Recv_Byte();
                }
                
                
                
            }
            
        }
        else
        {
            MENU_CHECK_STEP = 3;
            backsend();
            RS485_User_Tx_Data();
            if(clearodotime < 3000)
                clearodotime++;
            if(clearodotime >= 1500)
            {
                // Port_SetPortPinLevel(2,9,PortGpioHigh);
                queren = 1;
            }
        }
    }
   

}

/*==============================================================================
20ms����ִ������ ��0��
------------------------------------------------------------------------------*/
uint8_t time100mssend = 0;
void Sys_Run_Mode_20ms_Tasks_Group0(void)
{
    
    // uint8_t data[8] = {0};
    // uint32_t SpdN = 0;
    // _CAN_Msg canMag;
    
    // //Total_Check( );
    // canMag.MsgID          = 0x8FFF00B;
    // FT_VehSpeedCalc_Main(FT_CurVehSpeed, &SpdN, SPEED_TO_CANMESSAGE);
    // FT_Fill_VehSpeedCANMessage(SpdN, data);
    // canMag.MsgDLC = 8u;
    // canMag.MsgPro = 1u;
    // memcpy(canMag.Msg, data, 8);
    // Can_Write(&canMag);
    if(time100mssend < 2)
    {
        time100mssend++;
    }
    else
    {
        // firstIGON = 0;
        
        time100mssend = 0;
    } 

}

/*==============================================================================
50ms����ִ������ ��0��
------------------------------------------------------------------------------*/
uint8_t powerstu = 0;
uint32_t timerms = 0;
void Sys_Run_Mode_50ms_Tasks_Group(void)
{
    static uint32_t timer_100ms = 0;
    if(timer_100ms <=1000)
    {
        timer_100ms++;
    }
    if(timerms <=1000)
    {
        timerms++;
    }
    
    
    
    // if ( timer_100ms >= 500 )
    // {
    //     if(powerstu == 0)
    //     {
    //         LINE_OUT_NEG_01 = 1;
    //         LINE_OUT_NEG_02 = 1;
    //         LINE_OUT_NEG_03 = 1;
    //         LINE_OUT_NEG_04 = 1;
    //         powerstu = 1;
    //         timer_100ms = 0;
    //         firstIGON = 1;
    //         timerms = 0;
    //     }
    //     else
    //     {
    //         LINE_OUT_NEG_01 = 0;
    //         LINE_OUT_NEG_02 = 0;
    //         LINE_OUT_NEG_03 = 0;
    //         LINE_OUT_NEG_04 = 0;
    //         powerstu = 0;
    //         timer_100ms = 400;
    //         firstIGON = 1;
    //         timerms = 0;
    //     }
        
    //     // Read_IPK_Session_Type( );//请求仪表发送 软硬件版本号 等数据。  
            
    // }
    if(timerms >=60)
    {
        firstIGON = 0;
    }
    firstIGON = 0;
       
        
}

/*==============================================================================
100ms����ִ������ ��0��
------------------------------------------------------------------------------*/
uint16_t u16LJSText;
uint32_t AutoTime = 160;
uint32_t ONOFFtime;
uint8_t compareresult;
uint8_t flashtime = 0;
uint8_t showtime = 0;
uint8_t bleuarttime = 0;
void Sys_Run_Mode_100ms_Tasks_Group(void)
{
    static uint32_t loc_timer = 0;
    loc_timer++;
    if ( loc_timer >= 3 )
    {
        loc_timer = 0;
        // HW_CHECK_IPK_EXIST( );
        Recv_Byte1();
    }
    Display_PageNum();

    can_submit();

    // Freln_Duty_HZ_Service();
    if(RS485_send_time<0xFFFFFFFF)
    {
        RS485_send_time++;
    }
    if(firstpowerflag == 2)
    {
        if(AutoFlag == 1)
        {
            if(AutoTime <= 200)
            {
                AutoTime++;
            }
            else
            {
                MENU_CHECK_STEP_ADD( );   
                if(MENU_CHECK_STEP == 0)
                {
                    MENU_CHECK_STEP = 0;
                }
                if(MENU_CHECK_STEP == 13)
                {
                    AutoTime = 0;
                }
                else
                {
                    AutoTime = 160;
                }
                
            }
            
        }
        if(Auto_ONOFF == 1)
        {
            if(ONOFFtime <=160)
            {
                ONOFFtime++;
            }
            else
            {
                
                if(LINE_OUT_NEG_01 == 1)
                {
                    LINE_OUT_NEG_01 = 0;
                    LINE_OUT_NEG_04 = 0;
                    ONOFFtime = 0;
                }
                else
                {
                    LINE_OUT_NEG_01 = 1;
                    LINE_OUT_NEG_04 = 1;
                    ONOFFtime = 0;
                }
            }
        }
        if(flashtime < 3)
        {
            flashtime++;
        }
        else
        {
            if(comparestart == 1)
            {
                compareresult = GetDataCompare();
                // Display_TFT_Clear();
                if(compareresult == 1)
                {
                    TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_cuo1 );
                    // comparestart = 2;
                }
                else
                {
                    TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_dui1 );  
                    // comparestart = 2;
                }
                comparestart = 0;
                // Display_TFT_Clear();
            }
            else if(comparestart == 0)
            {
                    Total_Check( );
                    if(zhenduanflag == 3)
                    {
                        if(compareresult == 1)
                        {
                            TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_cuo1 );
                            // comparestart = 2;
                        }
                        else
                        {
                            TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_dui1 );  
                            // comparestart = 2;
                        }
                        // comparestart = 1;
                    }
            

            }
            else
            {
                Total_Check();
            }
            flashtime = 0;
        }
        // if(recvflag111 == 1)
        // {
        //     blename[4] = 0xff;
        //     General_Number_Disp(blename, 3, 165); 
        //     recvflag111 = 0;
            
        // }
    }

         if(firstpowerflag == 1)
    {
        zhenduanflag = 2;
        Total_Check();
        firstpowerflag = 2;
        Display_TFT_Clear();
        if(compareresult == 1 && comparestart == 0)
        {
        //     Total_Check();
            
            if(compareresult == 1)
            {
                TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_cuo1 );
                // comparestart = 2;
            }
            else
            {
                TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_dui1 );  
                // comparestart = 2;
            }
            Total_Check();
            firstpowerflag = 3;
            // zhendlag = 5;
        }
         
    }
    else
    {
        if(compareresult == 1)
        {
            Total_Check();
            firstpowerflag = 3;
             zhenduanflag = 2;
            if(compareresult == 1)
            {
                TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_cuo1 );
                // comparestart = 2;
            }
            else
            {
                TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_dui1 );  
                // comparestart = 2;
            }
            // Total_Check();
            // zhenduanflag = 5;
        }
        // zhenduanflag = 2;
    }   
    //u16LJSText = TFT_LCD_REQ_FIFO_MAX_DEPTH;
}
/*=================================================================*/

/*******************************************************************************
 *                                                                              *
 *                           ��ȷ��50us��ʱ�����б�                             *
 *                                                                              *
 *******************************************************************************/
/*==============================================================================
��ȷ��50us��ʱ���� ��ֹ�����޸��б��е�����
------------------------------------------------------------------------------*/
void Sys_Exact_50us_Tasks(void)
{
    GenDelay_Tick( );
    DoCAN_Timer_Update(50u);
}
/*============================================================================*/

/*******************************************************************************
 *                                                                              *
 *                           ��ȷ��100ms��ʱ�����б�                            *
 *                                                                              *
 *******************************************************************************/
/*==============================================================================
��ȷ��100ms��ʱ���� ��ֹ�����޸��б��е�����
------------------------------------------------------------------------------*/
void Sys_Exact_100ms_Tasks(void)
{
    if(connectbleFlag == 1)
    {
        if(send0x42time<0xFFFFFFFF)
        {
            send0x42time++;
        }
        if(bleOFFtoONtime<0xFFFFFFFF)
        {
            bleOFFtoONtime++;
        }
    }
    if(startONfalg)
    {
        if(startIGONtime < 0xFFFFFFFF)
        {
            startIGONtime++;
        }
    }
    // CHECK_IPK_COUNT( );
    
}
/*============================================================================*/
void Sys_Enter_Sleep_Mode(void)
{
    // Sys_Sleep_Init( );
}

void init_CAN_Frame(CAN_Frame_st_t* msg, uint32_t can_id, uint8_t can_len, uint8_t can_frame_ide, const uint8_t* data)
{
    for (uint32_t i = 0; i < can_len; i++) {
        msg->unCANData.u8CANData[i] = 0;
    }

    msg->u32CANID = can_id;
    msg->u8CANLEN = can_len;
    msg->u8CANFrameIDE = can_frame_ide;

    for (uint32_t i = 0; i < can_len; i++) {
        msg->unCANData.u8CANData[i] = data[i];
    }
}

void can_mid(CAN_Frame_st_t Msg)
{
    CAN_Frame_st_t m_msg;

    init_CAN_Frame(&m_msg, Msg.u32CANID, Msg.u8CANLEN, Msg.u8CANFrameIDE, Msg.unCANData.u8CANData);

    RSCAN0_CH4_Set_FIFO0_Data(&m_msg);
}

void can_submit(void)
{
    //车速
    CAN_Frame_st_t m_msg1;// 车速 母线电流
    uint8_t data1[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C20FFD2


    //氛围灯
    CAN_Frame_st_t m_msg2;// 氛围灯 报警器报警状态 整车状态 自动大灯功能设置
    uint8_t data2[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C10FFD3
    CAN_Frame_st_t m_msg3;// 氛围灯 整车操作状态反馈
    uint8_t data3[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C22FFD2


    //时间
    CAN_Frame_st_t m_msg4;// 时间显示
    uint8_t data4[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C50FFD0


    //功率
    CAN_Frame_st_t m_msg5;// 总电池电压
    uint8_t data5[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C10FFD1

    //故障灯
    CAN_Frame_st_t m_msg6;
    uint8_t data6[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C50FFD2

    //TCS灯开启 T动力灯
    CAN_Frame_st_t m_msg7;// 自定义能量回收功能设置反馈  
    uint8_t data7[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C5AFFD2

    //ready 边撑指示灯 巡航灯 跛行模式灯 氛围灯红
    CAN_Frame_st_t m_msg8;//  刹车开关信号反馈
    uint8_t data8[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C23FFD2


    //电池
    CAN_Frame_st_t m_msg9;// 主电池电量百分比（SOC）
    uint8_t data9[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C11FFD1
    CAN_Frame_st_t m_msg10;// 副电池电量百分比（SOC）
    uint8_t data10[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C11FFD7


    //消除报警
    CAN_Frame_st_t m_msg11;// 与ALM通信丢失 蓝牙图标
    uint8_t data11[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C23FFD3
    CAN_Frame_st_t m_msg12;// 与IOT通信丢失 GMS GPS 图标
    uint8_t data12[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C23FFD0

    // 与BMS通信丢失 总电池电量 0x0C11FFD1
    // 与控制器通讯丢失 整车状态 0x0C22FFD2


    //自动大灯功能设置       xxxxxxxxxxxxxx
    CAN_Frame_st_t m_msg13;// 自动大灯功能设置
    uint8_t data13[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C10FFD3


    //陡坡缓降灯
    CAN_Frame_st_t m_msg14;// 陡坡缓降
    uint8_t data14[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C25FFD2

    //坐桶开启
    CAN_Frame_st_t m_msg15;
    uint8_t data15[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C27FFD3


    //ABS
    CAN_Frame_st_t m_msg16;//ABS功能设置反馈
    uint8_t data16[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0C50FFDC
    CAN_Frame_st_t m_msg17;//ABS故障 激活 可回复
    uint8_t data17[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0CC0FFDC

    //abs驱动tcs
    CAN_Frame_st_t m_msg18;//abs 驱动tcs
    uint8_t data18[8] = {0, 0, 0, 0, 0, 0, 0, 0};//0x0CA0FFDC

    switch (MENU_CHECK_STEP)
    {
        case  0:
            data1[2] = 0;
            data1[3] = 0;//母线电流

            data1[6] = (10000 >> 8) & 0xFF;
            data1[7] = 10000 & 0xFF;  
            init_CAN_Frame(&m_msg1, 0x0C20FFD2, 8, 1, data1); // 车速 00 
        
            data2[0] = 0;
            data2[5] = 1;
            init_CAN_Frame(&m_msg2, 0x0C10FFD3, 8, 1, data2); // 报警器报警状态 整车状态

            data3[1] = 0;
            init_CAN_Frame(&m_msg3, 0x0C22FFD2, 8, 1, data3); // 整车操作状态反馈

            data4[0] = 0;
            data4[1] = 1;
            data4[2] = 1;
            data4[3] = 0;
            data4[4] = 0;
            data4[5] = 0;
            data4[6] = 0;
            data4[7] = 0;
            init_CAN_Frame(&m_msg4, 0x0C50FFD0, 8, 1, data4); // 时间显示


            data8[0] = 1 << 6;
            data8[1] = 1 << 4;
            init_CAN_Frame(&m_msg8, 0x0C23FFD2, 8, 1, data8); // ready 刹车开关信号反馈

            data9[4] = 2;
            init_CAN_Frame(&m_msg9, 0x0C11FFD1, 8, 1, data9); // 总电池电量

   
            data5[4] = 0;
            data5[5] = 0;
            init_CAN_Frame(&m_msg5, 0x0C10FFD1, 8, 1, data5); // 总电池电压


  
            init_CAN_Frame(&m_msg11, 0x0C23FFD3, 8, 1, data11); // 解除报警 蓝牙

            init_CAN_Frame(&m_msg12, 0x0C23FFD0, 8, 1, data12); // 解除报警 gps gms

            init_CAN_Frame(&m_msg13, 0x0C10FFD3, 8, 1, data13); // 自动大灯功能设置

            init_CAN_Frame(&m_msg14, 0x0C25FFD2, 8, 1, data14); // 陡坡缓降

            init_CAN_Frame(&m_msg15, 0x0C27FFD3, 8, 1, data15); // 坐桶开启

            init_CAN_Frame(&m_msg6, 0x0C50FFD2, 8, 1, data6); // 整车故障灯

            data7[0] = 1 << 5;
            init_CAN_Frame(&m_msg7, 0x0C5AFFD2, 8, 1, data7); // TCS 能量

            //ABS
            data16[0] = 1 << 2;
            init_CAN_Frame(&m_msg16, 0x0C50FFDC, 8, 1, data16); // ABS功能设置反馈
            data17[7] = 1 << 4;
            init_CAN_Frame(&m_msg17, 0x0CC0FFDC, 8, 1, data17); // ABS故障 激活 可回复

            //abs驱动tcs
            init_CAN_Frame(&m_msg18, 0x0CA0FFDC, 8, 1, data18); // abs驱动tcs


            break;
        case  1://步骤1
            data1[2] = 0 & 0xFF;  
            data1[3] = (0 >> 8) & 0xFF;//母线电流

            data1[7] = (10000 >> 8) & 0xFF;
            data1[6] = 10000 & 0xFF;  
            init_CAN_Frame(&m_msg1, 0x0C20FFD2, 8, 1, data1); // 车速 00
        
            data2[0] = 3;
            init_CAN_Frame(&m_msg2, 0x0C10FFD3, 8, 1, data2); // 报警器报警状态 整车状态 free

            data3[1] = 4 << 2;
            init_CAN_Frame(&m_msg3, 0x0C22FFD2, 8, 1, data3); // 整车操作状态反馈

            data4[0] = 0;
            data4[1] = 1;
            data4[2] = 1;
            data4[3] = 0;
            data4[4] = 0;
            data4[5] = 0;
            data4[6] = 0;
            data4[7] = 0;
            init_CAN_Frame(&m_msg4, 0x0C50FFD0, 8, 1, data4); // 时间显示00 00

            init_CAN_Frame(&m_msg8, 0x0C23FFD2, 8, 1, data8); // ready 刹车开关信号反馈

            data9[4] = 2;
            init_CAN_Frame(&m_msg9, 0x0C11FFD1, 8, 1, data9); // 总电池电量

            data5[4] = 1500 & 0xFF;  
            data5[5] = (1500 >> 8) & 0xFF;
            init_CAN_Frame(&m_msg5, 0x0C10FFD1, 8, 1, data5); // 总电池电压
            
  
            init_CAN_Frame(&m_msg11, 0x0C23FFD3, 8, 1, data11); // 解除报警 蓝牙

            init_CAN_Frame(&m_msg12, 0x0C23FFD0, 8, 1, data12); // 解除报警 gps gms

            init_CAN_Frame(&m_msg13, 0x0C10FFD3, 8, 1, data13); // 自动大灯功能设置

            init_CAN_Frame(&m_msg14, 0x0C25FFD2, 8, 1, data14); // 陡坡缓降

            init_CAN_Frame(&m_msg15, 0x0C27FFD3, 8, 1, data15); // 坐桶开启

            init_CAN_Frame(&m_msg6, 0x0C50FFD2, 8, 1, data6); // 整车故障灯

            data7[0] = 1 << 5;
            init_CAN_Frame(&m_msg7, 0x0C5AFFD2, 8, 1, data7); // TCS

            //ABS
            data16[0] = 1 << 2;
            init_CAN_Frame(&m_msg16, 0x0C50FFDC, 8, 1, data16); // ABS功能设置反馈
            data17[7] = 1 << 4;
            init_CAN_Frame(&m_msg17, 0x0CC0FFDC, 8, 1, data17); // ABS故障 激活 可回复

            //abs驱动tcs
            init_CAN_Frame(&m_msg18, 0x0CA0FFDC, 8, 1, data18); // abs驱动tcs
            break;
        case  2:
            data1[2] = 5100 & 0xFF;  
            data1[3] = (5100 >> 8) & 0xFF;//母线电流

            data1[7] = (10133 >> 8) & 0xFF;
            data1[6] = 10133 & 0xFF;  
            init_CAN_Frame(&m_msg1, 0x0C20FFD2, 8, 1, data1); // 车速 11
        
            data2[0] = 3;
            init_CAN_Frame(&m_msg2, 0x0C10FFD3, 8, 1, data2); // 报警器报警状态 整车状态 sport

            data3[1] = 3 << 2;
            init_CAN_Frame(&m_msg3, 0x0C22FFD2, 8, 1, data3); // 驾驶模式 挡位反馈

            data4[0] = 0;
            data4[1] = 1;
            data4[2] = 1;
            data4[3] = 11;
            data4[4] = 11;
            data4[5] = 0;
            data4[6] = 0;
            data4[7] = 0;
            init_CAN_Frame(&m_msg4, 0x0C50FFD0, 8, 1, data4); // 时间显示 11 11

            init_CAN_Frame(&m_msg8, 0x0C23FFD2, 8, 1, data8); // ready 刹车开关信号反馈

            data9[4] = 30;
            init_CAN_Frame(&m_msg9, 0x0C11FFD1, 8, 1, data9); // 总电池电量


            data5[4] = 750 & 0xFF;  
            data5[5] = (750 >> 8) & 0xFF;
            init_CAN_Frame(&m_msg5, 0x0C10FFD1, 8, 1, data5); // 总电池电压
            
  
            init_CAN_Frame(&m_msg11, 0x0C23FFD3, 8, 1, data11); // 解除报警 蓝牙

            init_CAN_Frame(&m_msg12, 0x0C23FFD0, 8, 1, data12); // 解除报警 gps gms

            init_CAN_Frame(&m_msg13, 0x0C10FFD3, 8, 1, data13); // 自动大灯功能设置

            init_CAN_Frame(&m_msg14, 0x0C25FFD2, 8, 1, data14); // 陡坡缓降

            init_CAN_Frame(&m_msg15, 0x0C27FFD3, 8, 1, data15); // 坐桶开启

            init_CAN_Frame(&m_msg6, 0x0C50FFD2, 8, 1, data6); // 整车故障灯

            data7[0] = 1 << 5;
            init_CAN_Frame(&m_msg7, 0x0C5AFFD2, 8, 1, data7); // TCS

            //ABS
            data16[0] = 1 << 2;
            init_CAN_Frame(&m_msg16, 0x0C50FFDC, 8, 1, data16); // ABS功能设置反馈
            data17[7] = 1 << 4;
            init_CAN_Frame(&m_msg17, 0x0CC0FFDC, 8, 1, data17); // ABS故障 激活 可回复

            //abs驱动tcs
            init_CAN_Frame(&m_msg18, 0x0CA0FFDC, 8, 1, data18); // abs驱动tcs
            break;
        case  3:
            data1[2] = 5100 & 0xFF;  
            data1[3] = (5100 >> 8) & 0xFF;//母线电流

            data1[7] = (10266 >> 8) & 0xFF;
            data1[6] = 10266 & 0xFF;  
            init_CAN_Frame(&m_msg1, 0x0C20FFD2, 8, 1, data1); // 车速 22

            data2[0] = 3;
            data2[1] = 1 << 4;
            init_CAN_Frame(&m_msg2, 0x0C10FFD3, 8, 1, data2); // 驾驶模式 整车状态 ttfar

            data3[1] = 1 << 2;
            init_CAN_Frame(&m_msg3, 0x0C22FFD2, 8, 1, data3); // 驾驶模式 挡位反馈

            data4[0] = 0;
            data4[1] = 1;
            data4[2] = 1;
            data4[3] = 22;
            data4[4] = 22;
            data4[5] = 0;
            data4[6] = 0;
            data4[7] = 0;
            init_CAN_Frame(&m_msg4, 0x0C50FFD0, 8, 1, data4); // 时间显示

            init_CAN_Frame(&m_msg8, 0x0C23FFD2, 8, 1, data8); // ready 刹车开关信号反馈

            data9[4] = 44;
            init_CAN_Frame(&m_msg9, 0x0C11FFD1, 8, 1, data9); // 总电池电量

            data5[4] = 1500 & 0xFF;  
            data5[5] = (1500 >> 8) & 0xFF;
            init_CAN_Frame(&m_msg5, 0x0C10FFD1, 8, 1, data5); // 总电池电压
            
  
            init_CAN_Frame(&m_msg11, 0x0C23FFD3, 8, 1, data11); // 解除报警 蓝牙

            init_CAN_Frame(&m_msg12, 0x0C23FFD0, 8, 1, data12); // 解除报警 gps gms

            data13[1] = 1 << 4;
            init_CAN_Frame(&m_msg13, 0x0C10FFD3, 8, 1, data13); // 自动大灯功能设置

            init_CAN_Frame(&m_msg14, 0x0C25FFD2, 8, 1, data14); // 陡坡缓降

            init_CAN_Frame(&m_msg15, 0x0C27FFD3, 8, 1, data15); // 坐桶开启

            init_CAN_Frame(&m_msg6, 0x0C50FFD2, 8, 1, data6); // 整车故障灯

            data7[0] = 1 << 5;
            init_CAN_Frame(&m_msg7, 0x0C5AFFD2, 8, 1, data7); // TCS

            //ABS
            data16[0] = 1 << 2;
            init_CAN_Frame(&m_msg16, 0x0C50FFDC, 8, 1, data16); // ABS功能设置反馈
            data17[7] = 1 << 4;
            init_CAN_Frame(&m_msg17, 0x0CC0FFDC, 8, 1, data17); // ABS故障 激活 可回复

            //abs驱动tcs
            init_CAN_Frame(&m_msg18, 0x0CA0FFDC, 8, 1, data18); // abs驱动tcs
            break;
        case 4:
            data1[2] = 5100 & 0xFF;  
            data1[3] = (5100 >> 8) & 0xFF;//母线电流

            data1[7] = (10399 >> 8) & 0xFF;
            data1[6] = 10399 & 0xFF;  
            init_CAN_Frame(&m_msg1, 0x0C20FFD2, 8, 1, data1); // 车速 33

            data2[0] = 3;
            init_CAN_Frame(&m_msg2, 0x0C10FFD3, 8, 1, data2); // 驾驶模式 整车状态

            //data3[1] = 0 << 2;
            init_CAN_Frame(&m_msg3, 0x0C22FFD2, 8, 1, data3); // 驾驶模式 挡位反馈

            data4[0] = 0;
            data4[1] = 1;
            data4[2] = 1;
            data4[3] = 13;
            data4[4] = 33;
            data4[5] = 0;
            data4[6] = 0;
            data4[7] = 0;
            init_CAN_Frame(&m_msg4, 0x0C50FFD0, 8, 1, data4); // 时间显示

            data8[0] = 1 << 6 | 2 << 4;
            data8[1] = 1 << 4;
            init_CAN_Frame(&m_msg8, 0x0C23FFD2, 8, 1, data8); // ready 刹车开关信号反馈 巡航灯 氛围灯红

            data9[4] = 66;
            init_CAN_Frame(&m_msg9, 0x0C11FFD1, 8, 1, data9); // 总电池电量


            // data5[4] = 150 & 0xFF;  
            // data5[5] = (150 >> 8) & 0xFF;
            init_CAN_Frame(&m_msg5, 0x0C10FFD1, 8, 1, data5); // 总电池电压
            
  
            init_CAN_Frame(&m_msg11, 0x0C23FFD3, 8, 1, data11); // 解除报警 蓝牙

            init_CAN_Frame(&m_msg12, 0x0C23FFD0, 8, 1, data12); // 解除报警 gps gms

            init_CAN_Frame(&m_msg13, 0x0C10FFD3, 8, 1, data13); // 自动大灯功能设置

            init_CAN_Frame(&m_msg14, 0x0C25FFD2, 8, 1, data14); // 陡坡缓降

            init_CAN_Frame(&m_msg15, 0x0C27FFD3, 8, 1, data15); // 坐桶开启

            init_CAN_Frame(&m_msg6, 0x0C50FFD2, 8, 1, data6); // 整车故障灯

            data7[0] = 1 << 5 | 1 << 2;
            init_CAN_Frame(&m_msg7, 0x0C5AFFD2, 8, 1, data7); // TCS T动力

            //ABS
            data16[0] = 1 << 2;
            init_CAN_Frame(&m_msg16, 0x0C50FFDC, 8, 1, data16); // ABS功能设置反馈
            data17[7] = 1 << 4;
            init_CAN_Frame(&m_msg17, 0x0CC0FFDC, 8, 1, data17); // ABS故障 激活 可回复

            //abs驱动tcs
            init_CAN_Frame(&m_msg18, 0x0CA0FFDC, 8, 1, data18); // abs驱动tcs
            break;
        case 5:
            data1[2] = 4900 & 0xFF;  
            data1[3] = (4900 >> 8) & 0xFF;//母线电流

            data1[7] = (10532 >> 8) & 0xFF;
            data1[6] = 10532 & 0xFF;  
            init_CAN_Frame(&m_msg1, 0x0C20FFD2, 8, 1, data1); // 车速 44

            data2[0] = 3;
            init_CAN_Frame(&m_msg2, 0x0C10FFD3, 8, 1, data2); // 驾驶模式 整车状态

            data3[0] = 1 << 3;
            data3[1] = 0 << 2;
            init_CAN_Frame(&m_msg3, 0x0C22FFD2, 8, 1, data3); // 驾驶模式 挡位反馈

            data4[0] = 0;
            data4[1] = 1;
            data4[2] = 1;
            data4[3] = 14;
            data4[4] = 44;
            data4[5] = 0;
            data4[6] = 0;
            data4[7] = 0;
            init_CAN_Frame(&m_msg4, 0x0C50FFD0, 8, 1, data4); // 时间显示

            init_CAN_Frame(&m_msg8, 0x0C23FFD2, 8, 1, data8); // ready 刹车开关信号反馈

            data9[4] = 88;
            init_CAN_Frame(&m_msg9, 0x0C11FFD1, 8, 1, data9); // 总电池电量

            data5[4] = 150 & 0xFF;  
            data5[5] = (150 >> 8) & 0xFF;
            init_CAN_Frame(&m_msg5, 0x0C10FFD1, 8, 1, data5); // 总电池电压
            
  
            init_CAN_Frame(&m_msg11, 0x0C23FFD3, 8, 1, data11); // 解除报警 蓝牙

            init_CAN_Frame(&m_msg12, 0x0C23FFD0, 8, 1, data12); // 解除报警 gps gms

            init_CAN_Frame(&m_msg13, 0x0C10FFD3, 8, 1, data13); // 自动大灯功能设置

            init_CAN_Frame(&m_msg14, 0x0C25FFD2, 8, 1, data14); // 陡坡缓降
            
            data15[0] = 1 << 3;
            init_CAN_Frame(&m_msg15, 0x0C27FFD3, 8, 1, data15); // 坐桶开启

            init_CAN_Frame(&m_msg6, 0x0C50FFD2, 8, 1, data6); // 整车故障灯

            data7[0] = 1 << 3;
            data7[1] = 1;
            init_CAN_Frame(&m_msg7, 0x0C5AFFD2, 8, 1, data7); // TCS

            //ABS
            data16[0] = 1 << 2;
            init_CAN_Frame(&m_msg16, 0x0C50FFDC, 8, 1, data16); // ABS功能设置反馈
            data17[7] = 1 << 4;
            init_CAN_Frame(&m_msg17, 0x0CC0FFDC, 8, 1, data17); // ABS故障 激活 可回复

            //abs驱动tcs
            init_CAN_Frame(&m_msg18, 0x0CA0FFDC, 8, 1, data18); // abs驱动tcs
            break;
        
        case 6:
            data1[2] = 4900 & 0xFF;  
            data1[3] = (4900 >> 8) & 0xFF;//母线电流

            data1[7] = (10665 >> 8) & 0xFF;
            data1[6] = 10665 & 0xFF;  
            init_CAN_Frame(&m_msg1, 0x0C20FFD2, 8, 1, data1); // 车速 55

            data2[0] = 3;
            init_CAN_Frame(&m_msg2, 0x0C10FFD3, 8, 1, data2); // 驾驶模式 整车状态

            data3[0] = 1 << 3;
            data3[1] = 0 << 2;
            init_CAN_Frame(&m_msg3, 0x0C22FFD2, 8, 1, data3); // 驾驶模式 挡位反馈

            data4[0] = 0;
            data4[1] = 1;
            data4[2] = 1;
            data4[3] = 15;
            data4[4] = 55;
            data4[5] = 0;
            data4[6] = 0;
            data4[7] = 0;
            init_CAN_Frame(&m_msg4, 0x0C50FFD0, 8, 1, data4); // 时间显示


            init_CAN_Frame(&m_msg8, 0x0C23FFD2, 8, 1, data8); // ready 刹车开关信号反馈

            data9[4] = 110;
            init_CAN_Frame(&m_msg9, 0x0C11FFD1, 8, 1, data9); // 总电池电量



            data5[4] = 750 & 0xFF;  
            data5[5] = (750 >> 8) & 0xFF;
            init_CAN_Frame(&m_msg5, 0x0C10FFD1, 8, 1, data5); // 总电池电压
            
  
            init_CAN_Frame(&m_msg11, 0x0C23FFD3, 8, 1, data11); // 解除报警 蓝牙

            init_CAN_Frame(&m_msg12, 0x0C23FFD0, 8, 1, data12); // 解除报警 gps gms

            init_CAN_Frame(&m_msg13, 0x0C10FFD3, 8, 1, data13); // 自动大灯功能设置

            data14[1] = 1 << 3;
            init_CAN_Frame(&m_msg14, 0x0C25FFD2, 8, 1, data14); // 陡坡缓降


            init_CAN_Frame(&m_msg15, 0x0C27FFD3, 8, 1, data15); // 坐桶开启

            init_CAN_Frame(&m_msg6, 0x0C50FFD2, 8, 1, data6); // 整车故障灯

            data7[0] = (1 << 5) | (1 << 3);
            init_CAN_Frame(&m_msg7, 0x0C5AFFD2, 8, 1, data7); // TCS

            //ABS
            data16[0] = 1 << 2;
            init_CAN_Frame(&m_msg16, 0x0C50FFDC, 8, 1, data16); // ABS功能设置反馈
            data17[7] = 1 << 4;
            init_CAN_Frame(&m_msg17, 0x0CC0FFDC, 8, 1, data17); // ABS故障 激活 可回复

            //abs驱动tcs
            init_CAN_Frame(&m_msg18, 0x0CA0FFDC, 8, 1, data18); // abs驱动tcs
            break;
        
        case 7:
            data1[2] = 4900 & 0xFF;  
            data1[3] = (4900 >> 8) & 0xFF;//母线电流

            data1[7] = (10798 >> 8) & 0xFF;
            data1[6] = 10798 & 0xFF;  
            init_CAN_Frame(&m_msg1, 0x0C20FFD2, 8, 1, data1); // 车速 66

            data2[0] = 3;
            init_CAN_Frame(&m_msg2, 0x0C10FFD3, 8, 1, data2); // 驾驶模式 整车状态

            data3[0] = 1 << 3;
            data3[1] = 0 << 2;
            init_CAN_Frame(&m_msg3, 0x0C22FFD2, 8, 1, data3); // 驾驶模式 挡位反馈

            data4[0] = 0;
            data4[1] = 1;
            data4[2] = 1;
            data4[3] = 16;
            data4[4] = 6;
            data4[5] = 0;
            data4[6] = 0;
            data4[7] = 0;
            init_CAN_Frame(&m_msg4, 0x0C50FFD0, 8, 1, data4); // 时间显示

            data8[0] = 1 << 2;
            init_CAN_Frame(&m_msg8, 0x0C23FFD2, 8, 1, data8); // ready 刹车开关信号反馈

            data9[4] = 132;
            init_CAN_Frame(&m_msg9, 0x0C11FFD1, 8, 1, data9); // 总电池电量


            data5[4] = 1500 & 0xFF;  
            data5[5] = (1500 >> 8) & 0xFF;
            init_CAN_Frame(&m_msg5, 0x0C10FFD1, 8, 1, data5); // 总电池电压
            
  
            init_CAN_Frame(&m_msg11, 0x0C23FFD3, 8, 1, data11); // 解除报警 蓝牙

            init_CAN_Frame(&m_msg12, 0x0C23FFD0, 8, 1, data12); // 解除报警 gps gms

            init_CAN_Frame(&m_msg13, 0x0C10FFD3, 8, 1, data13); // 自动大灯功能设置

            init_CAN_Frame(&m_msg14, 0x0C25FFD2, 8, 1, data14); // 陡坡缓降

            init_CAN_Frame(&m_msg15, 0x0C27FFD3, 8, 1, data15); // 坐桶开启

            init_CAN_Frame(&m_msg6, 0x0C50FFD2, 8, 1, data6); // 整车故障灯

            data7[0] = (1 << 5) | (1 << 3);
            init_CAN_Frame(&m_msg7, 0x0C5AFFD2, 8, 1, data7); // TCS


            //ABS
            data16[0] = 1 << 2;
            init_CAN_Frame(&m_msg16, 0x0C50FFDC, 8, 1, data16); // ABS功能设置反馈
            data17[7] = 1 << 4 | 1;
            init_CAN_Frame(&m_msg17, 0x0CC0FFDC, 8, 1, data17); // ABS故障 激活 可回复

            //abs驱动tcs
            init_CAN_Frame(&m_msg18, 0x0CA0FFDC, 8, 1, data18); // abs驱动tcs
            break;
        
        case 8:
            data1[7] = (10931 >> 8) & 0xFF;
            data1[6] = 10931 & 0xFF;  
            init_CAN_Frame(&m_msg1, 0x0C20FFD2, 8, 1, data1); // 车速 77

            data2[0] = 3;
            init_CAN_Frame(&m_msg2, 0x0C10FFD3, 8, 1, data2); // 驾驶模式 整车状态 

            //data3[1] = 0 << 2;
            init_CAN_Frame(&m_msg3, 0x0C22FFD2, 8, 1, data3); // 驾驶模式 挡位反馈

            data4[0] = 0;
            data4[1] = 1;
            data4[2] = 1;
            data4[3] = 17;
            data4[4] = 7;
            data4[5] = 0;
            data4[6] = 0;
            data4[7] = 0;
            init_CAN_Frame(&m_msg4, 0x0C50FFD0, 8, 1, data4); // 时间显示

            data8[0] = 2 << 4;
            init_CAN_Frame(&m_msg8, 0x0C23FFD2, 8, 1, data8); // ready 刹车开关信号反馈 氛围灯红

            data9[4] = 154;
            init_CAN_Frame(&m_msg9, 0x0C11FFD1, 8, 1, data9); // 总电池电量



            init_CAN_Frame(&m_msg5, 0x0C10FFD1, 8, 1, data5); // 总电池电压
            
            init_CAN_Frame(&m_msg11, 0x0C23FFD3, 8, 1, data11); // 解除报警 蓝牙

            init_CAN_Frame(&m_msg12, 0x0C23FFD0, 8, 1, data12); // 解除报警 gps gms

            init_CAN_Frame(&m_msg13, 0x0C10FFD3, 8, 1, data13); // 自动大灯功能设置

            init_CAN_Frame(&m_msg14, 0x0C25FFD2, 8, 1, data14); // 陡坡缓降

            init_CAN_Frame(&m_msg15, 0x0C27FFD3, 8, 1, data15); // 坐桶开启

            data6[0] = 1;
            init_CAN_Frame(&m_msg6, 0x0C50FFD2, 8, 1, data6); // 整车故障灯

            data7[0] = (1 << 5) | (1 << 3);
            init_CAN_Frame(&m_msg7, 0x0C5AFFD2, 8, 1, data7); // TCS

            //ABS
            data16[0] = 1 << 2;
            init_CAN_Frame(&m_msg16, 0x0C50FFDC, 8, 1, data16); // ABS功能设置反馈
            data17[7] = 1 << 4;
            init_CAN_Frame(&m_msg17, 0x0CC0FFDC, 8, 1, data17); // ABS故障 激活 可回复

            //abs驱动tcs
            init_CAN_Frame(&m_msg18, 0x0CA0FFDC, 8, 1, data18); // abs驱动tcs
            break;
        
        case 9:
            data1[7] = (11067 >> 8) & 0xFF;
            data1[6] = 11067 & 0xFF;  
            init_CAN_Frame(&m_msg1, 0x0C20FFD2, 8, 1, data1); // 车速 88

            data2[0] = 3;
            init_CAN_Frame(&m_msg2, 0x0C10FFD3, 8, 1, data2); // 驾驶模式 整车状态

            data3[1] = 0 << 2;
            init_CAN_Frame(&m_msg3, 0x0C22FFD2, 8, 1, data3); // 驾驶模式 挡位反馈

            data4[0] = 0;
            data4[1] = 1;
            data4[2] = 1;
            data4[3] = 18;
            data4[4] = 8;
            data4[5] = 0;
            data4[6] = 0;
            data4[7] = 0;
            init_CAN_Frame(&m_msg4, 0x0C50FFD0, 8, 1, data4); // 时间显示


            init_CAN_Frame(&m_msg8, 0x0C23FFD2, 8, 1, data8); // ready 刹车开关信号反馈

            data9[4] = 176;
            init_CAN_Frame(&m_msg9, 0x0C11FFD1, 8, 1, data9); // 总电池电量


            init_CAN_Frame(&m_msg5, 0x0C10FFD1, 8, 1, data5); // 总电池电压
            
            init_CAN_Frame(&m_msg11, 0x0C23FFD3, 8, 1, data11); // 解除报警 蓝牙

            init_CAN_Frame(&m_msg12, 0x0C23FFD0, 8, 1, data12); // 解除报警 gps gms

            init_CAN_Frame(&m_msg13, 0x0C10FFD3, 8, 1, data13); // 自动大灯功能设置

            init_CAN_Frame(&m_msg14, 0x0C25FFD2, 8, 1, data14); // 陡坡缓降

            init_CAN_Frame(&m_msg15, 0x0C27FFD3, 8, 1, data15); // 坐桶开启

            init_CAN_Frame(&m_msg6, 0x0C50FFD2, 8, 1, data6); // 整车故障灯

            data7[0] = (1 << 5) | (1 << 3);
            init_CAN_Frame(&m_msg7, 0x0C5AFFD2, 8, 1, data7); // TCS

            //ABS
            data16[0] = 1 << 2;
            init_CAN_Frame(&m_msg16, 0x0C50FFDC, 8, 1, data16); // ABS功能设置反馈
            data17[7] = 1 << 4;
            init_CAN_Frame(&m_msg17, 0x0CC0FFDC, 8, 1, data17); // ABS故障 激活 可回复

            //abs驱动tcs
            init_CAN_Frame(&m_msg18, 0x0CA0FFDC, 8, 1, data18); // abs驱动tcs
            break;
        
        case 10:// 全亮 全亮 全亮 全亮 全亮 全亮 全亮
            data1[7] = (11200 >> 8) & 0xFF;
            data1[6] = 11200 & 0xFF;  
            init_CAN_Frame(&m_msg1, 0x0C20FFD2, 8, 1, data1); // 车速 99

            data2[0] = 3;
            init_CAN_Frame(&m_msg2, 0x0C10FFD3, 8, 1, data2); // 驾驶模式 整车状态

            data3[1] = 0 << 2;
            init_CAN_Frame(&m_msg3, 0x0C22FFD2, 8, 1, data3); // 驾驶模式 挡位反馈

            data4[0] = 0;
            data4[1] = 1;
            data4[2] = 1;
            data4[3] = 19;
            data4[4] = 9;
            data4[5] = 0;
            data4[6] = 0;
            data4[7] = 0;
            init_CAN_Frame(&m_msg4, 0x0C50FFD0, 8, 1, data4); // 时间显示 19 09

            data8[0] = 1 << 6 | 2 << 4 | 1 << 2;
            data8[1] = 1 << 4;
            init_CAN_Frame(&m_msg8, 0x0C23FFD2, 8, 1, data8); // ready 刹车开关信号反馈

            data9[4] = 198;
            init_CAN_Frame(&m_msg9, 0x0C11FFD1, 8, 1, data9); // 总电池电量


            init_CAN_Frame(&m_msg5, 0x0C10FFD1, 8, 1, data5); // 总电池电压
            
            init_CAN_Frame(&m_msg11, 0x0C23FFD3, 8, 1, data11); // 解除报警 蓝牙

            init_CAN_Frame(&m_msg12, 0x0C23FFD0, 8, 1, data12); // 解除报警 gps gms

            init_CAN_Frame(&m_msg13, 0x0C10FFD3, 8, 1, data13); // 自动大灯功能设置

            data14[1] = 1 << 3;
            init_CAN_Frame(&m_msg14, 0x0C25FFD2, 8, 1, data14); // 陡坡缓降

            data15[0] = 1 << 3;
            init_CAN_Frame(&m_msg15, 0x0C27FFD3, 8, 1, data15); // 坐桶开启

            data6[0] = 1;
            init_CAN_Frame(&m_msg6, 0x0C50FFD2, 8, 1, data6); // 整车故障灯

            data7[0] = (1 << 5) | (1 << 3);
            init_CAN_Frame(&m_msg7, 0x0C5AFFD2, 8, 1, data7); // TCS


            //ABS
            data16[0] = 1 << 2;
            init_CAN_Frame(&m_msg16, 0x0C50FFDC, 8, 1, data16); // ABS功能设置反馈
            data17[7] = 1 << 4 | 1;
            init_CAN_Frame(&m_msg17, 0x0CC0FFDC, 8, 1, data17); // ABS故障 激活 可回复

            //abs驱动tcs
            init_CAN_Frame(&m_msg18, 0x0CA0FFDC, 8, 1, data18); // abs驱动tcs
            break;
        case 11:
            data1[7] = (11200 >> 8) & 0xFF;
            data1[6] = 11200 & 0xFF;  
            init_CAN_Frame(&m_msg1, 0x0C20FFD2, 8, 1, data1); // 车速 99

            data2[0] = 3;
            init_CAN_Frame(&m_msg2, 0x0C10FFD3, 8, 1, data2); // 驾驶模式 整车状态

            data3[1] = 0 << 2;
            init_CAN_Frame(&m_msg3, 0x0C22FFD2, 8, 1, data3); // 驾驶模式 挡位反馈


            init_CAN_Frame(&m_msg4, 0x0C50FFD0, 8, 1, data4); // 时间显示 00

            data8[0] = 1 << 6 | 2 << 4 | 1 << 2;
            data8[1] = 1 << 4;
            init_CAN_Frame(&m_msg8, 0x0C23FFD2, 8, 1, data8); // ready 刹车开关信号反馈

            data9[4] = 200;
            init_CAN_Frame(&m_msg9, 0x0C11FFD1, 8, 1, data9); // 总电池电量


            init_CAN_Frame(&m_msg5, 0x0C10FFD1, 8, 1, data5); // 总电池电压
            
            init_CAN_Frame(&m_msg11, 0x0C23FFD3, 8, 1, data11); // 解除报警 蓝牙

            init_CAN_Frame(&m_msg12, 0x0C23FFD0, 8, 1, data12); // 解除报警 gps gms

            init_CAN_Frame(&m_msg13, 0x0C10FFD3, 8, 1, data13); // 自动大灯功能设置

            data14[1] = 1 << 3;
            init_CAN_Frame(&m_msg14, 0x0C25FFD2, 8, 1, data14); // 陡坡缓降

            data15[0] = 1 << 3;
            init_CAN_Frame(&m_msg15, 0x0C27FFD3, 8, 1, data15); // 坐桶开启

            data6[0] = 1;
            init_CAN_Frame(&m_msg6, 0x0C50FFD2, 8, 1, data6); // 整车故障灯

            data7[0] = (1 << 5) | (1 << 3);
            init_CAN_Frame(&m_msg7, 0x0C5AFFD2, 8, 1, data7); // TCS


            //ABS
            data16[0] = 1 << 2;
            init_CAN_Frame(&m_msg16, 0x0C50FFDC, 8, 1, data16); // ABS功能设置反馈
            data17[7] = 1 << 4 | 1;
            init_CAN_Frame(&m_msg17, 0x0CC0FFDC, 8, 1, data17); // ABS故障 激活 可回复

            //abs驱动tcs
            init_CAN_Frame(&m_msg18, 0x0CA0FFDC, 8, 1, data18); // abs驱动tcs
            break;
        case 12://进不去
    
            break;
        case 13:
            break;
        case 14:

            break;
        default:
            break;
    }
    if(MENU_CHECK_STEP != 0)
    {
        can_mid(m_msg1);
        can_mid(m_msg2);
        can_mid(m_msg3);
        can_mid(m_msg4);
        can_mid(m_msg5);
        can_mid(m_msg6);
        can_mid(m_msg7);
        can_mid(m_msg8);
        can_mid(m_msg9);
        can_mid(m_msg11);
        can_mid(m_msg12);
        // can_mid(m_msg13);
        can_mid(m_msg14);
        can_mid(m_msg15);
        can_mid(m_msg16);
        can_mid(m_msg17);
        can_mid(m_msg18);
    }
}
