/************************************************ ******************************

******************************************************************************/

//#include "r_typedefs.h"

#include "rh850_macros.h"
#include "Simulated_8080.h"

D8080_data_t D8080_data;

void SIM_8080_P_OUT_DATA(D8080_data_t data)
{
    GPIO_OUT_PORT08_PIN00 = data.bits.d0;
    GPIO_OUT_PORT08_PIN01 = data.bits.d1;
    GPIO_OUT_PORT08_PIN02 = data.bits.d2;
    GPIO_OUT_PORT08_PIN03 = data.bits.d3;
    GPIO_OUT_PORT08_PIN04 = data.bits.d4;
    GPIO_OUT_PORT08_PIN05 = data.bits.d5;
    GPIO_OUT_PORT08_PIN06 = data.bits.d6;
    GPIO_OUT_PORT08_PIN07 = data.bits.d7;
}

void Sim_8080_Init(void)
{
    SIM_8080_P_nCS = 1;
    for ( int i = 0; i < 80; i++ )
    {
        nop( );
    }
    SIM_8080_P_A0  = 1;
    SIM_8080_P_nRD = 1;
    SIM_8080_P_nWR = 1;

    SIM_8080_P_DIR_OUT;
    D8080_data.data = 0x00;
    SIM_8080_P_OUT_DATA(D8080_data);
}

/******************************************************************************
??���理��??YGV642_SPI_Byte_Write
��|  ����??������痢?����SPI������������YGV642��?����1����?������?��
?��  ����??Data??��?��?�����̧�����?��
����?������??����
******************************************************************************/
void Sim_8080_Command_Write(uint8_t Cmd)
{
    SIM_8080_P_A0  = 0;    // Command Config_0X20D
    SIM_8080_P_nCS = 0;    // Selecte chip
    SIM_8080_P_nWR = 0;    // Prepare for command transfer
    for ( int i = 0; i < 80; i++ )
    {
        nop( );
    }

    D8080_data.data = Cmd;
    SIM_8080_P_OUT_DATA(D8080_data);    // Set command
    for ( int i = 0; i < 80; i++ )
    {
        nop( );
    }
    SIM_8080_P_nWR = 1;    // Latch command
    for ( int i = 0; i < 80; i++ )
    {
        nop( );
    }
    SIM_8080_P_nCS = 1;    // Release chip

    D8080_data.data = 0;
    SIM_8080_P_OUT_DATA(D8080_data);    // Set command
}

void Sim_8080_Data_Write(uint8_t Dat)
{
    SIM_8080_P_A0  = 1;    // Data transmission
    SIM_8080_P_nCS = 0;    // Selecte chip
    SIM_8080_P_nWR = 0;    // Prepare for data transfer
    for ( int i = 0; i < 80; i++ )
    {
        nop( );
    }

    D8080_data.data = Dat;
    SIM_8080_P_OUT_DATA(D8080_data);
    for ( int i = 0; i < 80; i++ )
    {
        nop( );
    }
    SIM_8080_P_nWR = 1;    // Latch data
    for ( int i = 0; i < 80; i++ )
    {
        nop( );
    }
    SIM_8080_P_nCS = 1;    // Release chip

    D8080_data.data = 0x00;
    SIM_8080_P_OUT_DATA(D8080_data);
}

uint8_t Sim_8080_Data_Read(void)
{
    uint8_t Dat;
    SIM_8080_P_A0  = 1;    // Data read
    SIM_8080_P_nCS = 0;    // Selecte chip
    SIM_8080_P_DIR_IN;     // Data input
    for ( int i = 0; i < 80; i++ )
    {
        nop( );
    }
    SIM_8080_P_nRD = 0;    // Prepare for data read
    for ( int i = 0; i < 80; i++ )
    {
        nop( );
    }
    Dat            = SIM_8080_P_IN_DATA;    // Read data
    SIM_8080_P_nRD = 1;                     // Stop data reading
    for ( int i = 0; i < 80; i++ )
    {
        nop( );
    }
    SIM_8080_P_nCS = 1;    // Release chip
    SIM_8080_P_DIR_OUT;    // Data output

    D8080_data.data = 0x00;
    SIM_8080_P_OUT_DATA(D8080_data);
    return Dat;
}
