#include "main.h"
#include "Task.h"
#include "TYW_stdint.h"
#include "GenDelay.h"
#include "COM_CAN.h"
#include "RTE_GPIO.h"
#include "DoCAN_ISO15765.h"
#include "Flash_synchronizer.h"
#include "RTE_ADC.h"
#include "init.h"
#include "TFT_LCD.h"
#include "TM035HFZGZx.h"
#include "UDS_ISO14229_Server.h"
#include "CAN_Lib.h"
#include "Display_Info.h"
#include "Key.h"
#include "Check_Ctrl.h"
#include "CAN_APP.h"
/*******************************************************************************
 *                                                                              *
 *   ϵͳ��������ģʽ(SYS_MODE_OFF / SYS_MODE_ON / SYS_MODE_STANDBY )�����б�   *
 *                                                                              *
 *******************************************************************************/

/*==============================================================================
αʵʱ����
------------------------------------------------------------------------------*/
#define CAN_SEND_TIME 2     //*10ms
#define CAN_SEND_BEGIN_TIME 100     //*10ms
void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void)
{    
    // DoCAN_Communication_Service( );
    // UDS_Server_Application_Service( );
    TFT_LCD_Display_Update_Service( );
    Get_PN_msg();
    if(SWINtestresult == 1)
    {
        Get_SWIN_msg();
    }
    if(SWtestresult == 1)
    {
        Get_SW_msg();
    }
    if(HWtestresult == 1)
    {
        Get_HW_msg();
    }
}
/*============================================================================*/

/*==============================================================================
2ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_2ms_Tasks_Group(void)
{
    Can_Write_Fun(2);    //报文外发
    COM_RX_Process( );
    RTE_ADC_Services( );
    Get_static_Current();
}

/*==============================================================================
2ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_5ms_Tasks_Group(void)
{
}

/*==============================================================================
10ms����ִ������ ��0��
------------------------------------------------------------------------------*/
uint32_t send0x714time = 0;
extern uint8_t HWtestresult;
extern uint8_t PNtestresult;
extern uint8_t fuelreset1;
extern uint8_t fuelreset2;
extern uint8_t fuelreset3;
extern uint8_t fuelreset4;
uint8_t UDS_DisableFlagnumber;
uint8_t IGtinmed;
void Sys_Run_Mode_10ms_Tasks_Group(void)
{
    if((resettime < 250) && (writeflag == 0))
    {
        resettime++;
    }
    if((writeflag == 0) && (begin714 == 1))
    {
        uidreset();
        UIDRead();
    }

    if(MENU_CHECK_STEP == 1 && fuelreset1 == 0)
    {
        fuelreset1 = 1;
    }
    else if(MENU_CHECK_STEP == 2 && fuelreset2 == 0)
    {
        fuelreset2 = 1;
    }
    else if(MENU_CHECK_STEP == 3 && fuelreset3 == 0)
    {
        fuelreset3 = 1;
    }
    else if(MENU_CHECK_STEP == 4 && fuelreset4 == 0)
    {
        fuelreset4 = 1;
    }
    if(MENU_CHECK_STEP == 0)
    {
        fuelreset1 = 0;
        fuelreset2 = 0;
        fuelreset3 = 0;
        fuelreset4 = 0;
    }
    if(fuelreset1 == 1 || fuelreset2 == 1 || fuelreset3 == 1 || fuelreset4 == 1)
    {

    }
    BusOff_Service( );
    Key_Service( );


    if(MENU_CHECK_STEP == 0)
    {
        if(send0x714time < 4)
        {
            send0x714time++;
        }
        else
        {
            if(begin714 == 0)
            {
                send0x714time = 0;
            }
        }
    }
    else
    {
        send0x714time = 0;
    }

    can_submit();

    if(writeflag == 1)
    {
        UIDWrite();
    }

    if(IGtinmed <= CAN_SEND_BEGIN_TIME) 
    {
        IGtinmed++;
    }
    else
    {
        // if(UDS_DisableFlag == 0)
        // {
            UDS_DisableFlagnumber++;
            if(UDS_DisableFlagnumber >= CAN_SEND_TIME)
            {
                UDS_DisableFlagnumber = 0;
                UDS_Process_Service();
                CAN_Service();
            }
        // }
    }


    //刷数字、刷英文拼写。
    //GUI_General_Digit_Display(123456789, Num_09, 10, 0, BackLightDigitNum09PosX, 79);
    //GUI_General_Digit_Display(123456789, Num_10_03, 10, 0, BackLightDigitNum09PosX, 79+24*1);
    //GUI_General_Digit_Display(123456789, Num_13, 10, 0, BackLightDigitNum09PosX, 79+24*2);
    //GUI_General_Digit_Display(123456789, Num_30, 10, 0, BackLightDigitNum09PosX, 79+24*3);

    //GUI_Display_Version_Code_Service((0), (79+24*0), "Please  Check  the  Driver", Letter_Num_11, PCodeText_Space_size);
    //GUI_Display_Version_Code_Service((0), (79+24*1), "ABCDEFGHIJKLMNOPQRST", Letter_Num_11, PCodeText_Space_size);
    //GUI_Display_Version_Code_Service((0), (79+24*2), "UVWXYZ  / ' @ - ", Letter_Num_11, PCodeText_Space_size);
    //GUI_Display_Version_Code_Service((0), (79+24*3), "abcdefghijklmnopqrstuvwxyz", Letter_Num_11, PCodeText_Space_size);
    //GUI_Display_Version_Code_Service((0), (79+24*4), "0123456789  18FEAB21", Letter_Num_11, PCodeText_Space_size);
}

/*==============================================================================
20ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_20ms_Tasks_Group0(void)
{
    //Total_Check( );
}

/*==============================================================================
50ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_50ms_Tasks_Group(void)
{
    static uint32_t timer_100ms = 0;

    timer_100ms++;
    
    // Buzzer_Init();
    if ( timer_100ms == 1 )
    {
        // Read_IPK_Session_Type( );//请求仪表发送 软硬件版本号 等数据。  
            
    }
    else if ( timer_100ms == 2 )
    {
        timer_100ms = 0;
    }
}

/*==============================================================================
100ms����ִ������ ��0��
------------------------------------------------------------------------------*/
uint16_t u16LJSText;
uint8_t time300ms;
void Sys_Run_Mode_100ms_Tasks_Group(void)
{
    static uint32_t loc_timer = 0;
    loc_timer++;
    if ( loc_timer >= 15 )
    {
        loc_timer = 0;
        // HW_CHECK_IPK_EXIST( );
    }
    // if(time300ms < 20)
    // {
    //     time300ms++;
    // }
    // else
    // {
        
    //     time300ms = 0;
    // }
    
    // Get_ID_0x794_Msg();
    // Display_PageNum();


    //硬线车速输出懒得改名了
    Buzzer_Start();
    Total_Check( );
    //u16LJSText = TFT_LCD_REQ_FIFO_MAX_DEPTH;
}
/*=================================================================*/

/*******************************************************************************
 *                                                                              *
 *                           ��ȷ��50us��ʱ�����б�                             *
 *                                                                              *
 *******************************************************************************/
/*==============================================================================
��ȷ��50us��ʱ���� ��ֹ�����޸��б��е�����
------------------------------------------------------------------------------*/
void Sys_Exact_50us_Tasks(void)
{
    GenDelay_Tick( );
    DoCAN_Timer_Update(50u);
}
/*============================================================================*/

/*******************************************************************************
 *                                                                              *
 *                           ��ȷ��100ms��ʱ�����б�                            *
 *                                                                              *
 *******************************************************************************/
/*==============================================================================
��ȷ��100ms��ʱ���� ��ֹ�����޸��б��е�����
------------------------------------------------------------------------------*/
void Sys_Exact_100ms_Tasks(void)
{
    CHECK_IPK_COUNT( );
}
/*============================================================================*/
void Sys_Enter_Sleep_Mode(void)
{
    // Sys_Sleep_Init( );
}
