

uint8_t isNeedSaveDTC = 0u;
uint8_t HVoltageStatus = 0u;
uint8_t LVoltageStatus = 0u;
uint8_t KEYStatus = 0u;

/**
  *DTCб
  */
const uint32_t DTCList[19][2] =
{
    {U10A187, 1u},
    {U108087, 1u},
    {U108387, 1u},
    {U108A87, 1u},
    {U108287, 1u},
    {U108987, 0u},
    {U108B87, 0u},
    {U108487, 1u},
    {U108587, 1u},
    {U108687, 1u},
    {U108787, 1u},
    {U108887, 1u},
    {U109287, 1u},
    {B110516, 1u},
    {B110617, 1u},
    {B110762, 1u},
    {B110880, 1u},
    {B110915, 1u},
    {B110A15, 1u},
};

/**
  *DTC״̬
  */
uint8_t DTCUpdataStatusList[19] = {0u};

/**
  *DTCʱ
  */
uint16_t DTCTimerList[19] = {0u};

/**
  *msgб
  */
uint16_t msgList[12][4] =
{
    {0x288u, 8u,   40u, 0u},
    {0x330u, 8u,  100u, 0u},
    {0x2E0u, 8u,  100u, 0u},
    {0x501u, 8u, 1000u, 0u},
    {0x35Eu, 8u,  100u, 0u},
    {0x2D9u, 8u,  100u, 0u},
    {0x32Au, 8u,  100u, 0u},
    {0x262u, 8u,   40u, 0u},
    {0x258u, 8u,   40u, 0u},
    {0x268u, 8u,   50u, 0u},
    {0x326u, 8u,  100u, 0u},
    {0x347u, 8u,  500u, 0u},
    /*{0x217u, 8u,  100u, 0u},
    {0x257u, 8u,  100u, 0u},
    {0x65Fu, 8u,  500u, 0u},*/


};

/**
  *DTC
  *@param timer ʱӵʱ䣬λms
  */
void TestDTC(uint16_t timer)
{
    TestDTC_B110762(timer);                                                 /*ź쳣*/
    if(getKL15Status())
    {
        if(!getEngStatus())
        {
            TestDTC_B110516(timer);                                         /*ģѹ*/
            TestDTC_B110617(timer);                                         /*ģѹ*/
            if(!getPowerStatus())
            {
                TestDTC_U10A187();                                          /*can߹ر*/
                TestDTC_B110880();                                          /*̰ס*/
                TestDTC_B110915(timer);                                     /*ȼźЧ(ֵ)*/
                TestDTC_B110A15(timer);                                     /*ȼźЧ(ֵ)*/
                if(!getBusoffStatus())
                {
                    if(isDTCEnable())
                    {
                        TestDTC_U108087();                                  /*BCMڵ㶪ʧ*/
                        TestDTC_U108387();                                  /*ACڵ㶪ʧ*/
                        TestDTC_U108A87();                                  /*RRSڵ㶪ʧ*/
                        TestDTC_U108287();                                  /*HUڵ㶪ʧ*/
                        TestDTC_U108987();                                  /*ӦѲڵ㶪ʧ*/
                        TestDTC_U108B87();                                  /*ϵͳڵ㶪ʧ*/
                        TestDTC_U108487();                                  /*ͨѶʧ*/
                        TestDTC_U108587();                                  /*복ģͨѶʧ*/
                        TestDTC_U108687();                                  /*פƶϵͳͨѶʧ*/
                        TestDTC_U108787();                                  /*ԶƵԪϵͳͨѶʧ*/
                        TestDTC_U108887();                                  /*뷢ϵͳͨѶʧ*/
                        TestDTC_U109287();                                  /*̥ѹϵͳͨѶʧ*/
                    }
                }
            }
            if(isNeedSaveDTC)
            {
                SaveDTCData();
                isNeedSaveDTC = 0u;
            }
        }
    }
}

/**
  *can߹ر
  */
void TestDTC_U10A187(void)
{

}

/**
  *ģѹ
  *@param timer ʱӵʱ䣬λms
  */
void TestDTC_B110516(uint16_t timer)
{

}

/**
  *ģѹ
  *@param timer ʱӵʱ䣬λms
  */
void TestDTC_B110617(uint16_t timer)
{

}

/**
  *BCMڵ㶪ʧ
  */
void TestDTC_U108087(void)
{
    if(DTCList[cnU108087][1u])
    {
        if(getMSGStatus(cnMSG288))
        {
            ChangeDTCData(cnU108087, DTCError);
        }
        else
        {
            ChangeDTCData(cnU108087, DTCNoError);
        }
    }
}

/**
  *ACڵ㶪ʧ
  */
void TestDTC_U108387(void)
{
    if(DTCList[cnU108387][1u])
    {
        if(getMSGStatus(cnMSG330))
        {
            ChangeDTCData(cnU108387, DTCError);
        }
        else
        {
            ChangeDTCData(cnU108387, DTCNoError);
        }
    }
}

/**
  *RRSڵ㶪ʧ
  */
void TestDTC_U108A87(void)
{
    if(DTCList[cnU108A87][1u])
    {
        if(getMSGStatus(cnMSG2E0))
        {
            ChangeDTCData(cnU108A87, DTCError);
        }
        else
        {
            ChangeDTCData(cnU108A87, DTCNoError);
        }
    }
}

/**
  *HUڵ㶪ʧ
  */
void TestDTC_U108287(void)
{
    if(DTCList[cnU108287][1u])
    {
        if(getMSGStatus(cnMSG501))
        {
            ChangeDTCData(cnU108287, DTCError);
        }
        else
        {
            ChangeDTCData(cnU108287, DTCNoError);
        }
    }
}

/**
  *ӦѲڵ㶪ʧ
  */
void TestDTC_U108987(void)
{
    if(DTCList[cnU108987][1u])
    {
        if(getMSGStatus(cnMSG35E))
        {
            ChangeDTCData(cnU108987, DTCError);
        }
        else
        {
            ChangeDTCData(cnU108987, DTCNoError);
        }
    }
}

/**
  *ϵͳڵ㶪ʧ
  */
void TestDTC_U108B87(void)
{
    if(DTCList[cnU108B87][1u])
    {
        if(getMSGStatus(cnMSG2D9))
        {
            ChangeDTCData(cnU108B87, DTCError);
        }
        else
        {
            ChangeDTCData(cnU108B87, DTCNoError);
        }
    }
}

/**
  *ͨѶʧ
  */
void TestDTC_U108487(void)
{
    if(DTCList[cnU108487][1u])
    {
        if(getMSGStatus(cnMSG32A))
        {
            ChangeDTCData(cnU108487, DTCError);
        }
        else
        {
            ChangeDTCData(cnU108487, DTCNoError);
        }
    }
}

/**
  *복ģͨѶʧ
  */
void TestDTC_U108587(void)
{
    if(DTCList[cnU108587][1u])
    {
        if(getMSGStatus(cnMSG262))
        {
            ChangeDTCData(cnU108587, DTCError);
        }
        else
        {
            ChangeDTCData(cnU108587, DTCNoError);
        }
    }
}

/**
  *Կ׽ϵͳͨѶʧ
  */
void TestDTC_U108687(void)
{
    if(DTCList[cnU108687][1u])
    {
        if(getMSGStatus(cnMSG258))
        {
            ChangeDTCData(cnU108687, DTCError);
        }
        else
        {
            ChangeDTCData(cnU108687, DTCNoError);
        }
    }
}

/**
  *ԶƵԪϵͳͨѶʧ
  */
void TestDTC_U108787(void)
{
    if(DTCList[cnU108787][1u])
    {
        if(getMSGStatus(cnMSG268))
        {
            ChangeDTCData(cnU108787, DTCError);
        }
        else
        {
            ChangeDTCData(cnU108787, DTCNoError);
        }
    }
}

/**
  *뷢ϵͳͨѶʧ
  */
void TestDTC_U108887(void)
{
    if(DTCList[cnU108887][1u])
    {
        if(getMSGStatus(cnMSG326))
        {
            ChangeDTCData(cnU108887, DTCError);
        }
        else
        {
            ChangeDTCData(cnU108887, DTCNoError);
        }
    }
}

/**
  *̥ѹϵͳͨѶʧ
  */
void TestDTC_U109287(void)
{
    if(DTCList[cnU109287][1u])
    {
        if(getMSGStatus(cnMSG347))
        {
            ChangeDTCData(cnU109287, DTCError);
        }
        else
        {
            ChangeDTCData(cnU109287, DTCNoError);
        }
    }
}

/**
  *ź쳣
  */
void TestDTC_B110762(uint16_t timer)
{
    uint8_t Status = Get_ID_288_Sig_BCM_PowerStatusFeedback();
    if(Status > 1u)
    {
        Status = 1u;
    }
    else
    {
        Status = 0u;
    }
    if(DTCList[cnB110762][1u])
    {
        if(getKL15Status() != Status)
        {
            if(DTCTimerList[cnB110762] == 1000u)
            {
                ChangeDTCData(cnB110762, DTCError);
            }
            else
            {
                DTCTimerList[cnB110762] += timer;
            }
        }
        else
        {
            DTCTimerList[cnB110762] = 0u;
            ChangeDTCData(cnB110762, DTCNoError);
        }
    }
}

/**
  *̰ס
  */
void TestDTC_B110880(void)
{
    if(DTCList[cnB110880][1u])
    {
        if(KEYStatus != 0u)
        {
            ChangeDTCData(cnB110880, DTCError);
        }
        else
        {
            ChangeDTCData(cnB110880, DTCNoError);
        }
    }
}

/**
  *ȼźЧ(ֵ)
  */
void TestDTC_B110915(uint16_t timer)
{

}

/**
  *ȼźЧ(ֵ)
  */
void TestDTC_B110A15(uint16_t timer)
{

}

/**
  *ȡ30ѹ״̬
  *@return 30ѹ״̬ 0Ϊѹ,1Ϊѹ,2Ϊѹ
  */
uint8_t getPowerStatus(void)
{

    return 0;
}

/**
  *ȡbusoff״̬
  *@return busoff״̬ 0Ϊ,1Ϊ쳣
  */
uint8_t getBusoffStatus(void)
{

    return 0;//();
}

/**
  *ȡ״̬
  *@return EngStatus 0Ϊδ,1Ϊ
  */
uint8_t getEngStatus(void)
{
    uint8_t status = 0u;

    if (status>0)
    {
        status = 1u;
    }
    return status;
}

/**
  *ð״̬
  *@param Statues λ 1Ϊ 0Ϊɿ, 7Ϊλ
  */
void set_DTC_Key_Statues(uint8_t Statues)
{
    if((Statues & 0x80u) == 0x80u)
    {
        KEYStatus = KEYStatus | (Statues & 0x7Fu);
    }
    else
    {
        KEYStatus = KEYStatus & (~Statues);
    }
}

/**
  *ȡ״̬
  *@param cnMsgID ±
  *@return ״̬ 0Ϊ,1Ϊ
  */
uint8_t getMSGStatus(uint8_t cnMsgID)
{
    uint8_t enResult;
    if(msgList[cnMsgID][2] < 200u)
    {
        if(msgList[cnMsgID][3] < 200u * OfflineLoopMultiple)
        {
            enResult = 0u;
        }
        else
        {
            enResult = 1u;
        }
    }
    else
    {
        if(msgList[cnMsgID][3] < msgList[cnMsgID][2] * OfflineLoopMultiple)
        {
            enResult = 0u;
        }
        else
        {
            enResult = 1u;
        }
    }
    return enResult;
}

/**
  *DTC״̬
  *@param DTCNum DTC
  *@param DTCStatus DTC״̬
  */
void ChangeDTCData(uint8_t DTCNum, uint8_t DTCStatus)
{
    if(DTCTestIsOpen())
    {
        if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCNoTestLastClear) == DTCNoTestLastClear)
        {
            DTCToDFlashInfo.DTC[DTCNum].DTCStatus = (uint8_t) (DTCToDFlashInfo.DTC[DTCNum].DTCStatus & (~DTCNoTestLastClear));
        }
        if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCNoTestThisCycle) == DTCNoTestThisCycle)
        {
            DTCToDFlashInfo.DTC[DTCNum].DTCStatus = (uint8_t) (DTCToDFlashInfo.DTC[DTCNum].DTCStatus & (~DTCNoTestThisCycle));
        }
        if(DTCStatus == DTCError)
        {
            if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCError) != DTCError)
            {
                DTCToDFlashInfo.DTC[DTCNum].DTCStatus |= DTCError;
                if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCErrorThisCycle) != DTCErrorThisCycle)
                {
                    DTCToDFlashInfo.DTC[DTCNum].DTCStatus |= DTCErrorThisCycle;
                    DTCToDFlashInfo.DTC[DTCNum].DTCAgeing = 0u;
                    DTCToDFlashInfo.DTC[DTCNum].DTCPendingCount++;
                    if(DTCToDFlashInfo.DTC[DTCNum].DTCPendingCount >= MaxDTCPendingCount)
                    {
                        if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCConfirmed) != DTCConfirmed)
                        {
                            DTCToDFlashInfo.DTC[DTCNum].DTCStatus |= DTCConfirmed;
                        }
                    }
                }
                if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCPending) != DTCPending)
                {
                    DTCToDFlashInfo.DTC[DTCNum].DTCStatus |= DTCPending;
                }
                if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCErrorLastClear) != DTCErrorLastClear)
                {
                    DTCToDFlashInfo.DTC[DTCNum].DTCStatus |= DTCErrorLastClear;
                }
                DTCToDFlashInfo.DTC[DTCNum].Snapshot.OdometerValue = 0;//() / 10u;
                DTCToDFlashInfo.DTC[DTCNum].Snapshot.SystemSupplyVoltage = (uint8_t)(getKL30Voltage() / 100u);
                DTCToDFlashInfo.DTC[DTCNum].Snapshot.VehicleSpeed = getSpeed();
                //DTCToDFlashInfo.DTC[DTCNum].Snapshot.DTCLocalTime = (year<<26)|(month<<22)|(hour<<17)|(hour<<12)|(minute<<6)|second;
                DTCToDFlashInfo.DTC[DTCNum].Snapshot.DTCLocalTime_second = Get_ID_501_Sig_HU_LocalTimeSecond();
                DTCToDFlashInfo.DTC[DTCNum].Snapshot.DTCLocalTime_minute = Get_ID_501_Sig_HU_LocalTimeMinute();
                DTCToDFlashInfo.DTC[DTCNum].Snapshot.DTCLocalTime_hour   = Get_ID_501_Sig_HU_LocalTimeHour();
                DTCToDFlashInfo.DTC[DTCNum].Snapshot.DTCLocalTime_day    = Get_ID_501_Sig_HU_LocalTimeDate();
                DTCToDFlashInfo.DTC[DTCNum].Snapshot.DTCLocalTime_month  = Get_ID_501_Sig_HU_LocalTimeMonth();
                DTCToDFlashInfo.DTC[DTCNum].Snapshot.DTCLocalTime_year   = Get_ID_501_Sig_HU_LocalTimeYear();
                DTCUpdataStatusList[DTCNum] = 1u;
                isNeedSaveDTC = 1u;
            }
        }
        else
        {
            if((uint8_t)(DTCToDFlashInfo.DTC[DTCNum].DTCStatus & DTCError) == DTCError)
            {
                DTCToDFlashInfo.DTC[DTCNum].DTCStatus &= DTCNoError;
                DTCUpdataStatusList[DTCNum] = 1u;
                isNeedSaveDTC = 1u;
            }
        }
    }
}

/**
  *DTC״̬
  */
void SaveDTCData(void)
{
    (void)WriteDFlashData(0x05u, (uint32_t *)&DTCToDFlashInfo.Flag, sizeof(DTCToDFlashInfo) , NoNeedWait);
}
