
#include "Power_Controls.h"

uint16_t PowerCountNum = 0U;
uint8_t KL1530ON = 0U;
uint8_t ControlsStatus = DUAN_DIAN_STATE;
uint16_t ShangDianOffset = 0u;


void Power_Controls_Init(void)
{
    KL1530ON = 1U;        /*默认上电，给所有继电器通电*/
}

void Power_Control_Count(void)
{
    if (PowerCountNum <= (SHANG_DIAN_TIMES + ShangDianOffset))
    {
        KL1530ON = 1U;
        PowerCountNum ++;
    }
    else if ((PowerCountNum > (SHANG_DIAN_TIMES + ShangDianOffset)) && (PowerCountNum < (SHANG_DIAN_TIMES + ShangDianOffset + DUAN_DIAN_TIMES)))
    {
        KL1530ON = 0U;
        PowerCountNum ++;
    }
    else 
    {
        KL1530ON = 0U;
        PowerCountNum = 0U;
        if(ShangDianOffset < 300U)
        {
            /*上电总时长小于90s+25s*/
            ShangDianOffset = ((ShangDianOffset + 5) *10 / 7);
        }
        else
        {
            ShangDianOffset /= 20u; 
        }
    }
}


void Power_KL15_KL30_Controls(void)
{
    if(ControlsStatus == 1U)
    {
        if (KL1530ON == 1U)
        {
            LINE_OUT_NEG_01 = 1U;
            LINE_OUT_NEG_02 = 1U;
            LINE_OUT_NEG_03 = 1U;
            LINE_OUT_NEG_04 = 1U;
        }
        else
        {
            LINE_OUT_NEG_01 = 0U;
            LINE_OUT_NEG_02 = 0U;
            LINE_OUT_NEG_03 = 0U;
            LINE_OUT_NEG_04 = 0U;
        }
    }
    else
    {
        if (KL1530ON == 1U)
        {
            LINE_OUT_NEG_01 = 1U;
        }
        else
        {
            LINE_OUT_NEG_01 = 0U;
        }
    }
}

