#define  GLOBALS_API_DEV
#include "../App_Headers/includes.h"

/*-------------------------------------------------------------------------
* Function Name  : Api_Sys_Init
* Description    : 系统初始化
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void Api_Sys_Init(void)
{
   DisableInterrupts;
   Api_Clock_Init();     
   Api_Flash_Init();   
   Api_IO_init();
   Api_CAN_Init();   
   Api_Timer0_Init(TPM_DIV1);     
   Api_SCI_Init();
   Api_LCD_Init();
   Api_Motor_Init();   
   EnableInterrupts;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_Clock_Init
* Description    : 系统时钟初始化
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void Api_Clock_Init(void)
{
    INT32U    dwTime = null;
    MODE      = NormalChip;
    DIRECT    = InitDIRECT;           //初始化直接页寄存器
    IVBR      = InitIVBR;             //初始化中断向量基地址
    CPMUOSC_OSCE   = Enable;                //使能外部振荡器
    while(!CPMUFLG_UPOSC)                   //等待振荡稳定
    {
        dwTime++;
        if(dwTime > 10000)
        {
            dwTime = null;
            break;
        }
    }
    ECLKCTL_NECLK  = Enable;               //禁止ECLK输出
    CPMUPROT       = InitCPMUPROT;         //禁止时钟保护   
    CPMUREFDIV     = InitCPMUREFDIV;       //设置分频系数
    CPMUSYNR       = InitCPMUSYNR;         //设置乘系数
    CPMUPOSTDIV    = InitCPMUPOSTDIV;      //设置分频参数
    CPMUPLL        = InitCPMUPLL;          //PLL频率调节
    //CPMUCOP        = InitCPMUCOP;               //开启看门狗
    CPMUCLKS       = InitCPMUCLKS;         //在停止模式下振荡运行 选择PLL时钟
    CPMUCLKS_PLLSEL = Enable;
                
    CPMUOSC_OSCE   = Enable;               //使能外部振荡器
    while(!CPMUFLG_UPOSC)                  //等待振荡稳定
    { 
       dwTime++;
       _FEED_COP();
       if(dwTime > 10000)
       {
           dwTime = null;
           break;
       }
    }
    CPMUCLKS_PSTP  = Enable;               //伪停止模式
    CPMUCLKS_RTIOSCSEL = Enable;           //RTI STOP MODE 继续运行 
    CPMUCLKS_PRE   = Enable;               
    CPMUCLKS_COPOSCSEL = !Enable;           //COP STOP MODE 运行 
    CPMUCLKS_PCE   = !Enable; 
    
    CPMUPROT       = Enable;               //使能时钟保护
    CPMUHTCTL      = Disable;              //温度保护禁止
    //中断
    CPMUINT_OSCIE  = Disable;              //Osc
    CPMUINT_LOCKIE = Disable;              //Lock
    //RTI
    CPMURTI_RTDEC  = True;                 //十进制
    CPMURTI_RTR    = 0x03;                 //400*10^3
    
    CPMUINT_RTIE   = Enable;               //RTI  
    CPMULVCTL_LVIE = Disable;              //LV
    IRQCR          = Disable;              //IRQ  
}

/*-------------------------------------------------------------------------
* Function Name  : Api_IO_init
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void Api_IO_init(void)
{       
    /*PUCR   = 0x40;  //上拉驱动使能 禁止下拉
    
    DDR1AD = 0x00;   
    PER1AD = 0xD0;   
        
    DDRA   = 0xff;
                        
    DDRB   = 0xff;    
             
    DDRU   = 0xf0;    
    PERU   = 0x0F;
    PPSU   = 0x00;
         
    DDRR   = 0x70;        
    PERR   = 0x00;  
    PPSR   = 0x00;   
      
    DDRV   = 0xff;   
    PERV   = 0x00;
    PPSV   = 0x00;                   

    DDRH   = 0xff;
    PERH   = 0x00;
    PPSH   = 0x00;
    
    DDRS   = 0x00;
    PERS   = 0x00;
    PPSS   = 0x00;  //选择上拉 还是下拉
    RDRS   = 0x00;  //驱动能力选择          
    PTSRR  = 0x10;  //控制IIC OR SPI  
    
    WOMS   = 0x00;
    PIES   = 0x00;
    PIFS   = 0x00;
    SPICR1 = 0x00;
    SPICR2 = 0x01;
 
    PTPRR  = 0x06;
    DDRP   = 0xf2; 
    PERP   = 0x00;    
    PPSP   = 0x00; 
    
    DDRT   = 0xff;    
    PERT   = 0x00;
    PPST   = 0x00; 
         
    PT1AD  = 0x00;
    PORTA  = 0x00;
    PORTB  = 0x00;
    PTT    = 0x00;
    PTH    = 0x00;
    PTU    = 0x00;
    PTP    = 0x00;
    PTR    = 0x00;  
    PTS    = 0x00; 
    PTV    = 0x00;
    ATDDIEN = 0xff;*/
    
     PUCR   = 0x40;  //上拉驱动使能 禁止下拉
    
    DDR1AD = 0x70;   
    PER1AD = 0x0e;   
        
    DDRA   = 0xff;
                        
    DDRB   = 0xff;    
             
    DDRU   = 0xff;    
    PERU   = 0x00;
    PPSU   = 0x00;
         
    DDRR   = 0x70;        
    PERR   = 0x00;  
    PPSR   = 0x00;   
      
    DDRV   = 0xff;   
    PERV   = 0x00;
    PPSV   = 0x00;                   

    DDRH   = 0xff;
    PERH   = 0x00;
    PPSH   = 0x00;
    
    DDRS   = 0x00;
    PERS   = 0x00;
    PPSS   = 0x00;  //选择上拉 还是下拉
    RDRS   = 0x00;  //驱动能力选择          
    PTSRR  = 0x10;  //控制IIC OR SPI  
    
    WOMS   = 0x00;
    PIES   = 0x00;
    PIFS   = 0x00;
    SPICR1 = 0x00;
    SPICR2 = 0x01;
 
    PTPRR  = 0x06;
    DDRP   = 0xf2; 
    PERP   = 0x00;    
    PPSP   = 0x00; 
    
    DDRT   = 0xff;    
    PERT   = 0x00;
    PPST   = 0x00; 
         
    PT1AD  = 0x00;
    PORTA  = 0x00;
    PORTB  = 0x00;
    PTT    = 0x00;
    PTH    = 0x00;
    PTU    = 0x00;
    PTP    = 0x00;
    PTR    = 0x00;  
    PTS    = 0x00; 
    PTV    = 0x00;
    ATDDIEN = 0xff;  
}
