/*
 * Var_Type.h
 *
 *  Created on: 2012-3-23
 *      Author: qitiancun
 */

#ifndef VAR_TYPE_H_
#define VAR_TYPE_H_

    #define             ADEveLen        10
    typedef             unsigned char   INT8U;
    typedef   volatile  unsigned char   VINT8U;
    typedef             unsigned int    INT16U;
    typedef   volatile  unsigned int    VINT16U;
    typedef             unsigned long   INT32U;
    
    typedef struct
    {
        INT8U ProceF;  //������־λ
        INT32U id;
        INT8U Len;
        INT8U Data[8];
    }CanMsg;

    
    
    typedef union 
    {
         struct
         {
              //1 word
              INT32U     EngRunAtv :1;
              INT32U     EngSpdStat:2;
              INT32U     EngCltTmpV:1;
              INT32U     EngCltTmp :1;
              INT32U     FlLvlPctV :1;              
              INT32U     VehSpdAvgDrvnV :1;              
              INT32U     ABSAtv         :1;
              INT32U     ABSMlfIO       :1;
              INT32U     EBDMlfIO       :1;
              INT32U     IgnKyInstAtv   :1;              
              INT32U     IgnKyPstn      :2;
              INT32U     HhBmIO         :1;
              INT32U     LwBmIO         :1;
              INT32U     FtFgLtIO       :1;
              //2 word
              INT32U     PnLgtAtv       :1;
              INT32U     RrFgLtIO       :1;
              INT32U     RtTrnLmpAtv    :1;
              INT32U     LftTrnLmpAtv   :1;              
              INT32U     TDLckSwAtv     :1;
              INT32U     RSDOpnSwAtv    :1;
              INT32U     PDOpnSwAtv     :1;
              INT32U     DDOpnSwAtv     :1;              
              INT32U     EPSIO          :1;
              INT32U     NetCtlKeep     :1;
              INT32U     NetDataKeep    :1;
              INT32U     CanDataSend:1;
              INT32U     Reserved2:1;
              INT32U     Reserved3:1;
              INT32U     Reserved4:1;
              INT32U     Reserved5:1;
              
              //3 word
              INT32U     MotorReset:1;
              INT32U     MotorInit:1;
              INT32U     Safety:1;  
              INT32U     RunStar  :1;
              INT32U     TmpFlash:1;
              INT32U     CanState:1;
              INT32U     Led:1;
              INT32U     DoorOpen:1;
              INT32U     KeyEn:1;
              INT32U     LampEn:1;
              INT32U     AccKmValid:1;
              INT32U     Perilous:1;   //Σ���ź�
              INT32U     RS232RV_Full:1;
              INT32U     ClearAcc:1;
              INT32U     Reserved20:1;
              INT32U     Reserved21:1;
              //4 word
              INT32U     Reserved22:1;
              INT32U     Reserved23:1;
              INT32U     Reserved24:1;
              INT32U     Reserved25:1;
              INT32U     Reserved26:1;
              INT32U     Reserved27:1;
              INT32U     Reserved28:1;
              INT32U     Reserved29:1;
              INT32U     Reserved30:1;
              INT32U     Reserved31:1;
              INT32U     Reserved32:1;
              INT32U     Reserved33:1;
              INT32U     Reserved34:1;
              INT32U     Reserved35:1;
              INT32U     Reserved36:1;
              INT32U     Reserved37:1;
         }FlagBits;
         INT32U FlagArry[3];
    }CarFlagType;
        
    typedef union
    {
         struct
         {
              INT8U     bit0:1;
              INT8U     bit1:1;
              INT8U     bit2:1;
              INT8U     bit3:1;
              INT8U     bit4:1;
              INT8U     bit5:1;
              INT8U     bit6:1;
              INT8U     bit7:1;
              INT8U     bit8:1;
              INT8U     bit9:1;
              INT8U     bit10:1;
              INT8U     bit11:1;
              INT8U     bit12:1;
              INT8U     bit13:1;
              INT8U     bit14:1;
              INT8U     bit15:1;
         }bits;
         INT16U w;
    }WordBit;

 
    
    typedef union 
    {
        struct
        {
            INT16U d16H;
            INT16U d16L; 
        }dw;
        INT32U dw32;
    }ULONG;

    typedef union 
    {
        struct
        {
            INT8U d8H;
            INT8U d8L; 
        }bytes;
        INT16U int16u;
    }TwoINT8U;
    
    typedef struct
    {
         INT8U     bDat[256];
         INT16U    wSectorStartAdd;
         INT16U    wBlockAdd;
    }tDFlashBuff;
    
    typedef struct
    {
         INT8U    Col;
         INT16U   isFlash;  //�Ƿ���˸
         INT8U    FlashEn;  //��˸ʹ��
         INT8U    TEnable7;
         INT16U   OverTime7;    //��ʱ����
         INT16U   Time7;          
         INT8U    TEnable6;
         INT16U   OverTime6;    //��ʱ����
         INT16U   Time6;         
         INT8U    TEnable5;
         INT16U   OverTime5;    //��ʱ����
         INT16U   Time5;
         INT8U    TEnable4;
         INT16U   OverTime4;    //��ʱ����
         INT16U   Time4;         
         INT8U    TEnable3;
         INT16U   OverTime3;    //��ʱ����
         INT16U   Time3;
         INT8U    TEnable2;
         INT16U   OverTime2;    //��ʱ����
         INT16U   Time2;
         INT8U    TEnable1;
         INT16U   OverTime1;    //��ʱ����
         INT16U   Time1;  
         INT8U    TEnable0;
         INT16U   OverTime0;    //��ʱ����
         INT16U   Time0;  
         
         INT8U    AutoEnable;
         INT16U   OverAutoTime;    //��ʱ����
         INT16U   AutoTime;
              
         INT8U    HalfSeconds; //1/10��             
         INT8U    Seconds;
         INT8U    Minutes;
         INT8U    Hours;
    }ClockType;

    typedef union 
    {
        INT16U duty;
        INT16U cycle;
        INT16U time;
    }EcuType; 
     
   	typedef struct
  	{
  		INT8U  Frame_Head[2];      //����֡ͷ
  		INT8U  Frame_Check;     //У����
  		INT8U  Frame_Type;      //����֡����
  		INT8U  Dir;
  		INT8U  Bak2;
  		INT8U  Frame_Len;
  		INT8U  Frame_Data[33];
  		INT8U  Frame_CheckSun;
  		INT8U  Frame_END[2];
  	}SciFrameType;
    typedef struct  //                          
    {
        INT8U       bFlag;
        INT16U      VehRadio;    //
        INT16U      VehNum;    //
        INT16U      RevRadio;    //
        INT8U       bCheckSun;      
    }RadioMeter;
      
    typedef struct                             
    {
		    INT16U         PushTime_1;
		    INT16U         PushTime_2;
		    INT8U          CAN_Step;
		    INT8U          StepAuto;
            INT8U          StepAutodir;
		    INT8U          CheckDispOk;
    }KeyType; 
    
    
    typedef struct 
    {
        INT32U  ID;
        INT8U   Length;
        INT8U   ID_EN;
        INT8U   Msg[8];       
    }CAN_message; 
    
    typedef struct{
        INT8U   Led;
        INT8U   Trip;
        INT8U   WF;
        INT8U   Radar;
    }Max_Page;


    typedef union {
        INT8U Data[8];
        struct
        {
            INT8U : 8;
            INT8U : 8;
            INT8U : 8;
            INT8U : 8;
            
            INT8U : 8; //
            INT8U : 8;
            INT8U : 8;
            INT8U : 8;
        } BIT;
    } TX_0x18DAF917;
          	           
#endif /* VAR_TYPE_H_ */
