
#ifndef CLOCK_H__
#define CLOCK_H__

typedef enum
{
    CLOCK_IDLE,      /* Clock is stopped */
    CLOCK_START,     /* Clock is starting */
    CLOCK_RUN,       /* Clock is running */
}Clock_Status_en_t;

/* Clock source config */
#define   CLOCK_MAIN_OSC_RUN_IN_SLEEP_MODE  (0U)

/* Clock source */
#define   CLOCK_MAIN_OSC_FREQ_HZ            (8000000UL)   /* MainOSC   */
#define   CLOCK_FAST_CR_OSC_FREQ_HZ         (8000000UL)   /* HS IntOSC */
#define   CLOCK_SLOW_CR_OSC_FREQ_HZ         (240000UL)    /* LS IntOSC */

/* PLL */
#define   CLOCK_CPLL1_FREQ_HZ               (120000000UL) /* CPLL1OUT  */
#define   CLOCK_PPLL_FREQ_HZ                (80000000UL)  /* PPLLOUT   */

/* Clock domain */
#define   CLOCK_WDTA_FREQ_HZ                (CLOCK_SLOW_CR_OSC_FREQ_HZ / 128UL)    /* C_AWO_WDTA */
#define   CLOCK_TAUJ_FREQ_HZ                (CLOCK_PPLL_FREQ_HZ / 2UL)             /* C_AWO_TAUJ */
#if CLOCK_MAIN_OSC_RUN_IN_SLEEP_MODE
  #define CLOCK_RTCA_FREQ_HZ                (CLOCK_MAIN_OSC_FREQ_HZ / 8UL)         /* C_AWO_RTCA */
#else
  #define CLOCK_RTCA_FREQ_HZ                (CLOCK_SLOW_CR_OSC_FREQ_HZ)            /* C_AWO_RTCA */
#endif
#define   CLOCK_ADCA_FREQ_HZ                (CLOCK_PPLL_FREQ_HZ / 2UL)             /* C_AWO_ADCA */
#define   CLOCK_FOUT_FREQ_HZ                (0UL)                                  /* C_AWO_FOUT */

#define   CLOCK_CPU_FREQ_HZ                 (CLOCK_CPLL1_FREQ_HZ)                  /* C_ISO_CPUCLK */
#define   CLOCK_PERI1_FREQ_HZ               (CLOCK_PPLL_FREQ_HZ)                   /* C_ISO_PERI1  */
#define   CLOCK_PERI2_FREQ_HZ               (CLOCK_PPLL_FREQ_HZ / 2UL)             /* C_ISO_PERI2  */
#define   CLOCK_LIN_FREQ_HZ                 (CLOCK_PPLL_FREQ_HZ / 2UL)             /* C_ISO_LIN    */
#define   CLOCK_CAN_FREQ_HZ                 (CLOCK_PPLL_FREQ_HZ / 2UL)             /* C_ISO_CAN    */
#define   CLOCK_CANOSC_FREQ_HZ              (CLOCK_MAIN_OSC_FREQ_HZ)               /* C_ISO_CANOSC */
#define   CLOCK_CSI_FREQ_HZ                 (CLOCK_PPLL_FREQ_HZ)                   /* C_ISO_CSI    */
#define   CLOCK_IIC_FREQ_HZ                 (CLOCK_PPLL_FREQ_HZ / 2UL)             /* C_ISO_IIC    */



extern void Clock_Run_Mode_Init(void);
extern void Clock_Sleep_Mode_Init(void);

extern Clock_Status_en_t Clock_Get_Main_OSC_Status(void);

#endif
