#include "common_include.h"
#include "bsp_app_led_output.h"
#include "bsp_app_tft_output.h"

float DisplayValue;
#define CLK_FREQ 330000000      //freq * 10
#define PWM_DIV_NUM 1024       
const uint16_t SpeedOutputFreqList[] = {0, 1416, 2831, 4247, 5662, 7078, 8493, 9909, 11324, 12740, 14156, 15571, 16987, 18413, 19829, 21245}; //output freq x 100, 134:1.34Hz 
uint16_t DisplayDestVehicleSpeed = 0;
uint16_t g_Cycle;
uint16_t g_Duty;
void Speed20(uint8_t uiAutoCheckFlag)
{
    
#if (CAN_2ND) 
    //CGW_PC4.msg.bits.F_N_ENG = 1;  
    WHL_SPD11.msg.bits.WHL_SPD_FL = 0x280;//20
    WHL_SPD11.msg.bits.WHL_SPD_RL = 0x280;//20
    CGW_PC4.msg.bits.N =0xFA0;//1000  ת    
    HEV_PC4.msg.bits.CR_Ems_EngSpd_rpm = 0xFA0;
#if (PRO_CN7)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (PRO_JAPE2)
Speed_Output_Update(PWMCH_SPEED_OUT, 2400, 50);
#endif
#endif
#if (CAN_3RD)
    WHL_01_10ms.WHL_SpdFLVal = 0x280;//20
    WHL_01_10ms.WHL_SpdRLVal = 0x280;//20
    EMS_01_10ms.ENG_EngSpdVal = 0xFA0;//1000  ת 
	EMS_07_10ms.HEV_EngSpdVal = 0xFA0;//1000  ת 
    EMS_02_10ms.ENG_AccelPdlVal=0x2B;//
    HCU_03_10ms.HCU_HEVRdyDis = 0x1;
#endif
    if (uiAutoCheckFlag == 0) {
        User_Delay(200);
        if(CheckCurrent.Value == FINISH)
        {
            if(Frequeice.Value > 121 && Frequeice.Value < 161)
            {
                Freque_Flag = 1;
            }
            else
            {
                Freque_Flag = 2;
            }
        }
    }   
}
void Speed40(uint8_t uiAutoCheckFlag)
{
#if (CAN_2ND) 
    //CGW_PC4.msg.bits.F_N_ENG = 1;  
    WHL_SPD11.msg.bits.WHL_SPD_FL = 0x500;//40
    WHL_SPD11.msg.bits.WHL_SPD_RL = 0x500;//40
    CGW_PC4.msg.bits.N=0x1F40;//2000  ת 
    HEV_PC4.msg.bits.CR_Ems_EngSpd_rpm = 0x1F40;
#if (PRO_CN7)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (PRO_JAPE2)
Speed_Output_Update(PWMCH_SPEED_OUT, 1200, 600);
#endif
#endif
#if (CAN_3RD)
    WHL_01_10ms.WHL_SpdFLVal = 0x500;//40
    WHL_01_10ms.WHL_SpdRLVal = 0x500;//40
    EMS_01_10ms.ENG_EngSpdVal = 0x1F40;//2000  ת
	EMS_07_10ms.HEV_EngSpdVal = 0x1F40;//2000  ת
    EMS_02_10ms.ENG_AccelPdlVal=0x81;//
    HCU_03_10ms.HCU_HEVRdyDis = 0x1;
#endif
    if (uiAutoCheckFlag == 0) {
        User_Delay(200);
        if(CheckCurrent.Value == FINISH)
        {
            if(Frequeice.Value > 250 && Frequeice.Value < 303)
            {
                Freque_Flag = 1;
            }
            else
            {
                Freque_Flag = 2;
            }
        }
    } 
}
void Speed60(void)
{
#if (CAN_2ND) 
    //CGW_PC4.msg.bits.F_N_ENG = 1;  
    WHL_SPD11.msg.bits.WHL_SPD_FL = 0x780;//60
    WHL_SPD11.msg.bits.WHL_SPD_RL = 0x780;//60
    CGW_PC4.msg.bits.N =0x2EE0;//3000  ת
    HEV_PC4.msg.bits.CR_Ems_EngSpd_rpm = 0x2EE0;
#if (PRO_CN7)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (PRO_JAPE2)
Speed_Output_Update(PWMCH_SPEED_OUT, 800, 400);
#endif
    User_Delay(200);
    if(CheckCurrent.Value == FINISH)
    {
        if(Frequeice.Value > 390 && Frequeice.Value < 452)
        {
            Freque_Flag = 1;
        }
        else
        {
            Freque_Flag = 2;
        }
    }
#endif
#if (CAN_3RD)
    WHL_01_10ms.WHL_SpdFLVal = 0x780;//60
    WHL_01_10ms.WHL_SpdRLVal = 0x780;//60
    EMS_01_10ms.ENG_EngSpdVal = 0x2EE0;//3000  ת
	EMS_07_10ms.HEV_EngSpdVal = 0x2EE0;//3000  ת
    EMS_02_10ms.ENG_AccelPdlVal=0xD7;//
    HCU_03_10ms.HCU_HEVRdyDis = 0x1;
    User_Delay(200);
    if(CheckCurrent.Value == FINISH)
    {
        if(Frequeice.Value > 394 && Frequeice.Value < 455)
        {
            Freque_Flag = 1;
        }
        else
        {
            Freque_Flag = 2;
        }
    }
#endif
}
void Speed80(void)
{
#if (CAN_2ND) 
    //CGW_PC4.msg.bits.F_N_ENG = 1;  
    WHL_SPD11.msg.bits.WHL_SPD_FL = 0xA00;//80
    WHL_SPD11.msg.bits.WHL_SPD_RL = 0xA00;//80
    CGW_PC4.msg.bits.N=0x3E80;//4000 ת
    HEV_PC4.msg.bits.CR_Ems_EngSpd_rpm = 0x3E80;
#if (PRO_CN7)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (PRO_JAPE2)
Speed_Output_Update(PWMCH_SPEED_OUT, 580, 290);
#endif
    User_Delay(200);
    if(CheckCurrent.Value == FINISH)
    {
        if(Frequeice.Value > 536 && Frequeice.Value < 596)
        {
            Freque_Flag = 1;
        }
        else
        {
            Freque_Flag = 2;
        }
    }    
#endif
#if (CAN_3RD)
    WHL_01_10ms.WHL_SpdFLVal = 0xA00;//80
    WHL_01_10ms.WHL_SpdRLVal = 0xA00;//80
    EMS_01_10ms.ENG_EngSpdVal = 0x3E80;//4000 ת
	EMS_07_10ms.HEV_EngSpdVal = 0x3E80;//4000 ת
    EMS_02_10ms.ENG_AccelPdlVal=0x12D;//
    HCU_03_10ms.HCU_HEVRdyDis = 0x1;
    User_Delay(200);
    if(CheckCurrent.Value == FINISH)
    {
        if(Frequeice.Value > 536 && Frequeice.Value < 596)
        {
            Freque_Flag = 1;
        }
        else
        {
            Freque_Flag = 2;
        }
    }
#endif
}
void Speed100(void)
{
#if (CAN_2ND) 
     //CGW_PC4.msg.bits.F_N_ENG = 1;  
     WHL_SPD11.msg.bits.WHL_SPD_FL = 0xC80;//100
     WHL_SPD11.msg.bits.WHL_SPD_RL = 0xC80;//100
     CGW_PC4.msg.bits.N =0x4E20;//5000  ת
     HEV_PC4.msg.bits.CR_Ems_EngSpd_rpm = 0x4E20;
#if (PRO_CN7)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (PRO_JAPE2)
Speed_Output_Update(PWMCH_SPEED_OUT, 460, 230);
#endif
     User_Delay(200);
     if(CheckCurrent.Value == FINISH)
     {
         if(Frequeice.Value > 677 && Frequeice.Value < 737)
         {
             Freque_Flag = 1;
         }
         else
         {
             Freque_Flag = 2;
         }
     }
#endif
#if (CAN_3RD)
    WHL_01_10ms.WHL_SpdFLVal = 0xC80;//100
    WHL_01_10ms.WHL_SpdRLVal = 0xC80;//100
    EMS_01_10ms.ENG_EngSpdVal = 0x4E20;//5000  ת
	EMS_07_10ms.HEV_EngSpdVal = 0x4E20;//5000  ת
    EMS_02_10ms.ENG_AccelPdlVal=0x183;//
    HCU_03_10ms.HCU_HEVRdyDis = 0x1;
    User_Delay(200);
    if(CheckCurrent.Value == FINISH)
    {
        if(Frequeice.Value > 677 && Frequeice.Value < 737)
        {
            Freque_Flag = 1;
        }
        else
        {
            Freque_Flag = 2;
        }
    }
#endif
}
void Speed120(void)
{
#if (CAN_2ND) 
    //CGW_PC4.msg.bits.F_N_ENG = 1;  
    WHL_SPD11.msg.bits.WHL_SPD_FL = 0xF00;//120
    WHL_SPD11.msg.bits.WHL_SPD_RL = 0xF00;//120
    CGW_PC4.msg.bits.N =0x5DC0;//6000  ת
    HEV_PC4.msg.bits.CR_Ems_EngSpd_rpm = 0x5DC0;
#if (PRO_CN7)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (PRO_JAPE2)
Speed_Output_Update(PWMCH_SPEED_OUT, 380, 190);
#endif
    User_Delay(200);
    if(CheckCurrent.Value == FINISH)
    {
        if(Frequeice.Value > 809 && Frequeice.Value < 889)
        {
            Freque_Flag = 1;
        }
        else
        {
            Freque_Flag = 2;
        }
    }
#endif
#if (CAN_3RD)
    WHL_01_10ms.WHL_SpdFLVal = 0xF00;//120
    WHL_01_10ms.WHL_SpdRLVal = 0xF00;//120
    EMS_01_10ms.ENG_EngSpdVal = 0x5DC0;//6000  ת
	EMS_07_10ms.HEV_EngSpdVal = 0x5DC0;//6000  ת
    EMS_02_10ms.ENG_AccelPdlVal=0x1D9;//
    HCU_03_10ms.HCU_HEVRdyDis = 0x1;
    User_Delay(200);
    if(CheckCurrent.Value == FINISH)
    {
        if(Frequeice.Value > 809 && Frequeice.Value < 889)
        {
            Freque_Flag = 1;
        }
        else
        {
            Freque_Flag = 2;
        }
    }
#endif
}
void Speed140(void)
{
#if (CAN_2ND) 
    //CGW_PC4.msg.bits.F_N_ENG = 1;  
    WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1180;//140
    WHL_SPD11.msg.bits.WHL_SPD_RL = 0x1180;//140
    CGW_PC4.msg.bits.N =0x6D60;//7000  ת
    HEV_PC4.msg.bits.CR_Ems_EngSpd_rpm = 0x6D60;
#if (PRO_CN7)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (PRO_JAPE2)
Speed_Output_Update(PWMCH_SPEED_OUT, 330, 165);
#endif
    User_Delay(200);
    if(CheckCurrent.Value == FINISH)
    {
        if(Frequeice.Value > 950 && Frequeice.Value < 1039)
        {
            Freque_Flag = 1;
        }
        else
        {
            Freque_Flag = 2;
        }
    } 
#endif
#if (CAN_3RD)
    WHL_01_10ms.WHL_SpdFLVal = 0x1180;//140
    WHL_01_10ms.WHL_SpdRLVal = 0x1180;//140
    EMS_01_10ms.ENG_EngSpdVal = 0x6D60;//7000  ת
	EMS_07_10ms.HEV_EngSpdVal = 0x6D60;//7000  ת
    EMS_02_10ms.ENG_AccelPdlVal=0x22F;//
    HCU_03_10ms.HCU_HEVRdyDis = 0x1;
    User_Delay(200);
    if(CheckCurrent.Value == FINISH)
    {
        if(Frequeice.Value > 950 && Frequeice.Value < 1039)
        {
            Freque_Flag = 1;
        }
        else
        {
            Freque_Flag = 2;
        }
    }
#endif
}
void Speed160(void)
{
#if (CAN_2ND) 
    //CGW_PC4.msg.bits.F_N_ENG = 1;  
    WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1400;//160
    WHL_SPD11.msg.bits.WHL_SPD_RL = 0x1400;//160
    CGW_PC4.msg.bits.N=0x7D00;//8000  ת 
    HEV_PC4.msg.bits.CR_Ems_EngSpd_rpm = 0x7D00;
#if (PRO_CN7)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (PRO_JAPE2)
Speed_Output_Update(PWMCH_SPEED_OUT, 290, 145);
#endif
    User_Delay(200);
    if(CheckCurrent.Value == FINISH)
    {
        if(Frequeice.Value > 1082 && Frequeice.Value < 1182)
        {
            Freque_Flag = 1;
        }
        else
        {
            Freque_Flag = 2;
        }
    }
#endif
#if (CAN_3RD)
    WHL_01_10ms.WHL_SpdFLVal = 0x1400;//160
    WHL_01_10ms.WHL_SpdRLVal = 0x1400;//160
    EMS_01_10ms.ENG_EngSpdVal = 0x7D00;//8000  ת 
	EMS_07_10ms.HEV_EngSpdVal = 0x7D00;//8000  ת 
    EMS_02_10ms.ENG_AccelPdlVal=0x285;//
    HCU_03_10ms.HCU_HEVRdyDis = 0x1;
    User_Delay(200);
    if(CheckCurrent.Value == FINISH)
    {
        if(Frequeice.Value > 1082 && Frequeice.Value < 1182)
        {
            Freque_Flag = 1;
        }
        else
        {
            Freque_Flag = 2;
        }
    }
#endif
}
void Speed180(void)
{
#if (CAN_2ND)
     //CGW_PC4.msg.bits.F_N_ENG = 1;  
     WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1680;//180
     WHL_SPD11.msg.bits.WHL_SPD_RL = 0x1680;//180
     CGW_PC4.msg.bits.N =0x7D00;//8000  ת 
     HEV_PC4.msg.bits.CR_Ems_EngSpd_rpm = 0x7D00;
#if (PRO_CN7)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (PRO_JAPE2)
Speed_Output_Update(PWMCH_SPEED_OUT, 260, 130);
#endif
     User_Delay(200);
     if(CheckCurrent.Value == FINISH)
     {
         if(Frequeice.Value > 1200 && Frequeice.Value < 1324)
         {
             Freque_Flag = 1;
         }
         else
         {
             Freque_Flag = 2;
         }
     }
#endif
#if (CAN_3RD)
     WHL_01_10ms.WHL_SpdFLVal = 0x1680;//180
     WHL_01_10ms.WHL_SpdRLVal = 0x1680;//180
     EMS_01_10ms.ENG_EngSpdVal = 0x7D00;//8000  ת 
 	 EMS_07_10ms.HEV_EngSpdVal = 0x7D00;//8000  ת 
     EMS_02_10ms.ENG_AccelPdlVal=0x2DB;//
     HCU_03_10ms.HCU_HEVRdyDis = 0x1;
     User_Delay(200);
     if(CheckCurrent.Value == FINISH)
     {
         if(Frequeice.Value > 1224 && Frequeice.Value < 1324)
         {
             Freque_Flag = 1;
         }
         else
         {
             Freque_Flag = 2;
         }
     }
#endif
}
void Speed200(void)
{
#if (CAN_2ND) 
     //CGW_PC4.msg.bits.F_N_ENG = 1;  
     WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1900;//200
     WHL_SPD11.msg.bits.WHL_SPD_RL = 0x1900;//200
     CGW_PC4.msg.bits.N =0x7D00;//8000  ת 
     HEV_PC4.msg.bits.CR_Ems_EngSpd_rpm = 0x7D00;
#if (PRO_CN7)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (PRO_JAPE2)
Speed_Output_Update(PWMCH_SPEED_OUT, 230, 115);
#endif
     User_Delay(200);
     if(CheckCurrent.Value == FINISH)
     {
         if(Frequeice.Value > 1365 && Frequeice.Value < 1465)
         {
             Freque_Flag = 1;
         }
         else
         {
             Freque_Flag = 2;
         }
     }
#endif
#if (CAN_3RD)
    WHL_01_10ms.WHL_SpdFLVal = 0x1900;//200
    WHL_01_10ms.WHL_SpdRLVal = 0x1900;//200
    EMS_01_10ms.ENG_EngSpdVal = 0x7D00;//8000  ת 
	EMS_07_10ms.HEV_EngSpdVal = 0x7D00;//8000  ת 
    EMS_02_10ms.ENG_AccelPdlVal=0x331;//
    HCU_03_10ms.HCU_HEVRdyDis = 0x1;
    User_Delay(200);
    if(CheckCurrent.Value == FINISH)
    {
        if(Frequeice.Value > 1365 && Frequeice.Value < 1465)
        {
            Freque_Flag = 1;
        }
        else
        {
            Freque_Flag = 2;
        }
    }
#endif
}
void Speed220(void)
{
#if (CAN_2ND) 
     //CGW_PC4.msg.bits.F_N_ENG = 1;  
     WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1B80;//220
     WHL_SPD11.msg.bits.WHL_SPD_RL = 0x1B80;//220
     CGW_PC4.msg.bits.N =0x7D00;//8000  ת 
     HEV_PC4.msg.bits.CR_Ems_EngSpd_rpm = 0x7D00;
#if (PRO_CN7)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (PRO_JAPE2)
Speed_Output_Update(PWMCH_SPEED_OUT, 215, 107);
#endif
     User_Delay(200);
     if(CheckCurrent.Value == FINISH)
     {
         if(Frequeice.Value > 1485 && Frequeice.Value < 1607)
         {
             Freque_Flag = 1;
         }
         else
         {
             Freque_Flag = 2;
         }
     }
#endif
#if (CAN_3RD)
     WHL_01_10ms.WHL_SpdFLVal = 0x1B80;//220
     WHL_01_10ms.WHL_SpdRLVal = 0x1B80;//220
     EMS_01_10ms.ENG_EngSpdVal = 0x7D00;//8000  ת 
 	 EMS_07_10ms.HEV_EngSpdVal = 0x7D00;//8000  ת 
     EMS_02_10ms.ENG_AccelPdlVal=0x387;//
     HCU_03_10ms.HCU_HEVRdyDis = 0x1;
     User_Delay(200);
     if(CheckCurrent.Value == FINISH)
     {
         if(Frequeice.Value > 1507 && Frequeice.Value < 1607)
         {
             Freque_Flag = 1;
         }
         else
         {
             Freque_Flag = 2;
         }
     }
#endif
}
void Speed240(void)
{
    if(g_SpeedMaxCheckSteps < 12)
        return;
#if (CAN_2ND) 
     //CGW_PC4.msg.bits.F_N_ENG = 1;  
     WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1E00;//240
     WHL_SPD11.msg.bits.WHL_SPD_RL = 0x1E00;//240
     CGW_PC4.msg.bits.N =0x7D00;//8000  ת 
     HEV_PC4.msg.bits.CR_Ems_EngSpd_rpm = 0x7D00;
#if (PRO_CN7)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (PRO_JAPE2)
Speed_Output_Update(PWMCH_SPEED_OUT, 195, 97);
#endif
     User_Delay(200);
     if(CheckCurrent.Value == FINISH)
     {
         if(Frequeice.Value > 1600 && Frequeice.Value < 1758)
         {
             Freque_Flag = 1;
         }
         else
         {
             Freque_Flag = 2;
         }
     }
#endif
#if (CAN_3RD)
     WHL_01_10ms.WHL_SpdFLVal = 0x1E00;//240
     WHL_01_10ms.WHL_SpdRLVal = 0x1E00;//240
     EMS_01_10ms.ENG_EngSpdVal = 0x7D00;//8000  ת 
 	 EMS_07_10ms.HEV_EngSpdVal = 0x7D00;//8000  ת 
     EMS_02_10ms.ENG_AccelPdlVal=0x3FE;//
     HCU_03_10ms.HCU_HEVRdyDis = 0x1;
     User_Delay(200);
     if(CheckCurrent.Value == FINISH)
     {
         if(Frequeice.Value > 1648 && Frequeice.Value < 1748)
         {
             Freque_Flag = 1;
         }
         else
         {
             Freque_Flag = 2;
         }
     }
#endif
}
void Speed260(void)
{
    if(g_SpeedMaxCheckSteps < 13)
        return;
#if (CAN_2ND) 
     WHL_SPD11.msg.bits.WHL_SPD_FL = 0x2080;//260
     WHL_SPD11.msg.bits.WHL_SPD_RL = 0x2080;//260
     CGW_PC4.msg.bits.N =0x7D00;//8000  ת 
     HEV_PC4.msg.bits.CR_Ems_EngSpd_rpm = 0x7D00;
#if (PRO_CN7)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (PRO_JAPE2)
Speed_Output_Update(PWMCH_SPEED_OUT, 180, 90);
#endif
     User_Delay(200);
     if(CheckCurrent.Value == FINISH)
     {
         if(Frequeice.Value > 1740 && Frequeice.Value < 1900)
         {
             Freque_Flag = 1;
         }
         else
         {
             Freque_Flag = 2;
         }
     }
#endif
#if (CAN_3RD)
     WHL_01_10ms.WHL_SpdFLVal = 0x2080;//260
     WHL_01_10ms.WHL_SpdRLVal = 0x2080;//260
     EMS_01_10ms.ENG_EngSpdVal = 0x7D00;//8000  ת 
 	 EMS_07_10ms.HEV_EngSpdVal = 0x7D00;//8000  ת 
     EMS_02_10ms.ENG_AccelPdlVal=0x3FE;//
     HCU_03_10ms.HCU_HEVRdyDis = 0x1;
     User_Delay(200);
     if(CheckCurrent.Value == FINISH)
     {
         if(Frequeice.Value > 1780 && Frequeice.Value < 1900)
         {
             Freque_Flag = 1;
         }
         else
         {
             Freque_Flag = 2;
         }
     }
#endif
}
uint32_t ODO; 
uint16_t DisplaySpeed , DisplaySpeed1 , DisplaySpeed2; 

void APP_CAN_Output_Show (void)
{
#if (CAN_2ND)     
    DisplaySpeed1 = CanFDDataStruct.CF_Clu_Vanz_L ;  
    DisplaySpeed2 = CanFDDataStruct.CF_Clu_Vanz_H ; 
   
    DisplaySpeed2 = DisplaySpeed2 << 8 ;
    DisplaySpeed = DisplaySpeed1 | DisplaySpeed2 ;   //Ҫʾ   DisplaySpeed     SCCٶ
    DisplayValue = DisplaySpeed;
    SpeedCurrent.Value = DisplayValue / 2 + 0.5;
    
    //       
    ODO = CanFDDataStruct.CF_Clu_Odometer1 | CanFDDataStruct.CF_Clu_Odometer2 << 8 | CanFDDataStruct.CF_Clu_Odometer3 <<16 ; 
    ODO = ODO/10 ; //Ҫʾ  ODO
#endif  
#if (CAN_3RD)
    DisplaySpeed1 = WHL_01_10ms.WHL_SpdFLVal ;  
    DisplaySpeed2 = WHL_01_10ms.WHL_SpdRLVal ;   //WHL_SpdRLVal
    DisplaySpeed = DisplaySpeed1 + DisplaySpeed2;
    DisplayDestVehicleSpeed = (DisplaySpeed1 + DisplaySpeed2) / 2  * 3125 / 100000 ;   //Ҫʾ   DisplaySpeed     SCCٶ
    if (((DisplayDestVehicleSpeed % 10u) > 4u) && (DisplayDestVehicleSpeed > 100u)) {
        SpeedCurrent.Value = DisplayDestVehicleSpeed + 10u - (DisplayDestVehicleSpeed % 10u);
    } else {
        SpeedCurrent.Value = DisplayDestVehicleSpeed; 
    }

#endif
    /*
    if(( CanFDDataStruct.CF_Clu_AvgFCI_L != 0x3) && ( CanFDDataStruct.CF_Clu_AvgFCI_H != 0xFF ))   
    {
    AvgFCI1 = CanFDDataStruct.CF_Clu_AvgFCI_L ; // ƽ
    AvgFCI2 = CanFDDataStruct.CF_Clu_AvgFCI_H ;  // ƽ
    AvgFCI2 = AvgFCI2  << 8 ;
    AvgFCI = AvgFCI1 | AvgFCI2 ;   //Ҫʾ AvgFCI 
}
    */
}
void SpeedSWFun()
{
    // for(int i = 0; i < g_uiLedNum; i++)
    // {
    //     if(LedCurrent.count == g_stLedOut[i].uiIndex)
    //     {
    //         g_stLedOut[i].pFunc();
    //         strcpy(g_szLedName,g_stLedOut[i].szFuncName);
    //         break;
    //     }
    // }
     for(int i = 0; i < g_uiLedNum; i++)
    {
        if(LedCurrent.count == g_stLedOut[i].uiIndex)
        {
            g_stLedOut[i].pFunc();
            strcpy(g_szLedName,g_stLedOut[i].szFuncName);
            break;
        }
    }

}

uint8_t g_SpeedMaxCheckSteps = 0;
unsigned int DisPlayPowerNumBer = 0; 
unsigned int DisPlaySpeedNumBer = 0; 
void APP_SPEED_OUTPUT(void) // ת    ʮ ֹͣ  
{
    Default_flag=0;
    SpeedCurrent.statu = UNFINISH;  //δ
    if(g_SpeedCheckDeriction == 0) {
        // if(SpeedCurrent.count == g_SpeedMaxCheckSteps)
        //     SpeedCurrent.statu = FINISH;  //һ־
        // switch(SpeedCurrent.count) 
        // {
        //     case 0:
        //         Speed_Output_Update(PWMCH_SPEED_OUT, 0, 0);
        //         break;
        //     case 1:          
        //         Speed20(0);
        //         break;
        //     case 2:
        //         Speed40(0);
        //         break;
        //     case 3:
        //         Speed60();
        //         break;
        //     case 4:
        //         Speed80();
        //         break;
        //     case 5:
        //         Speed100();
        //         break;
        //     case 6:
        //         Speed120();
        //         break;
        //     case 7:
        //         Speed140();
        //         break;
        //     case 8:
        //         Speed160();
        //         break;
        //     case 9:
        //         Speed180();
        //         break;
        //     case 10:
        //         Speed200();
        //         break;
        //     case 11:
        //         Speed220();
        //         break;
        //     case 12:
        //         Speed240();
        //         break;
        //     case 13:
        //         Speed260();
        //         break;    
        //     default:
        //         break;
        // }
        // for(int i = 0; i < g_uiLedNum; i++)
        // {
        //     if(LedCurrent.count == g_stLedOut[i].uiIndex)
        //     {
        //         g_stLedOut[i].pFunc();
        //         strcpy(g_szLedName,g_stLedOut[i].szFuncName);
        //         break;
        //     }
        // }
    }
    else if(g_SpeedCheckDeriction == 1) {
        //if(SpeedCurrent.count == 0)
        //    SpeedCurrent.statu = FINISH;  //һ־
        

    }
    SpeedSWFun();

#if (CAN_2ND)     
    CurRpm = CGW_PC4.msg.bits.N;
#endif
#if (CAN_3RD)
    CurRpm = EMS_01_10ms.ENG_EngSpdVal;
#endif
    APP_CAN_Output_Show();
}




