#include <math.h>
#include <string.h>
#include <stdlib.h>
#include "ResistorCalculate.h"
#include "fuelconfig.h"
#include "common_include.h"

#pragma location="BACKUP_RAM_CONTENT"
uint8_t FuelSaveData[1024];
#pragma location="BACKUP_RAM_CONTENT"
uint16_t FuelSaveLen;
#pragma location="BACKUP_RAM_CONTENT"
uint8_t DrivingRangeSaveData[1024];
#pragma location="BACKUP_RAM_CONTENT"
uint16_t DrivingRangeSaveLen;

#pragma location="BACKUP_RAM_CONTENT"
uint8_t AfcValided[3];

#pragma location="BACKUP_RAM_CONTENT"
uint8_t EndWasStarted;

uint16_t DispayDTE;
uint16_t g_Fuel_AdcVal = 0;
uint16_t g_Fuel_VREF_AdcVal = 0;
uint16_t FuelResistance = 0;
uint32_t FuelConsume = 0;
uint32_t FuelConsumeSum = 0;
uint16_t FuelRFinal = 0;
R_Value_t FuelRVal;
uint8_t FuelStep = 0;
uint16_t FuelCapacity = 0;
FuelStruct FuelInit;
AFC_INIT AFCInit;
AFC_PARA AFCPara;
void SetFuelInit(void)
{
//fuel init
    FuelStep = 0;
    FuelCapacity = 0;
    FuelInit.FuelShortCircuitR = 20;
    FuelInit.FuelOpenCircuitR = 3500;
    FuelInit.LowFuelWarningResistance = 2410;
    FuelInit.LowFuelWarningReleaseResistance = 2278;
	FuelInit.LowFuelWarningFuelCapacity = 6500;
    FuelInit.FullFuelStopCapacity = 58200;      //S/F
    FuelInit.EmptyFuelStopCapacity = 2700;     //S/E
    FuelInit.DisplayZoneBoundary[0] = DISPLAY_BOUNDARY_FIRST; 	
    FuelInit.DisplayZoneBoundary[1] = DISPLAY_BOUNDARY_SECOND;	
    FuelInit.DisplayZoneBoundary[2] = DISPLAY_BOUNDARY_THIRD;	
    FuelInit.DisplayZoneBoundary[3] = DISPLAY_BOUNDARY_FOURTH;	
    FuelInit.DisplayZoneBoundary[4] = DISPLAY_BOUNDARY_FIFTH;	
    FuelInit.DisplayZoneBoundary[5] = DISPLAY_BOUNDARY_SIXTH;	
    FuelInit.DisplayZoneBoundary[6] = DISPLAY_BOUNDARY_SEVENTH;
    FuelInit.DisplayZoneBoundary[7] = DISPLAY_BOUNDARY_EIGHTH;		
    FuelInit.DisplayZoneBoundary[8] = DISPLAY_BOUNDARY_NINTH;	
    FuelInit.DisplayZoneBoundary[9] = DISPLAY_BOUNDARY_TENTH;	
    FuelInit.DisplayZoneBoundary[10] = DISPLAY_BOUNDARY_ELEVENTH;	

    FuelInit.FuelCapacityBoundary[0] = BOUNDARY_FUEL_FIRST;	
    FuelInit.FuelCapacityBoundary[1] = BOUNDARY_FUEL_SECOND;	
    FuelInit.FuelCapacityBoundary[2] = BOUNDARY_FUEL_THIRD;		
    FuelInit.FuelCapacityBoundary[3] = BOUNDARY_FUEL_FOURTH;	
    FuelInit.FuelCapacityBoundary[4] = BOUNDARY_FUEL_FIFTH;		
    FuelInit.FuelCapacityBoundary[5] = BOUNDARY_FUEL_SIXTH;		
    FuelInit.FuelCapacityBoundary[6] = BOUNDARY_FUEL_SEVENTH;
    FuelInit.FuelCapacityBoundary[7] = BOUNDARY_FUEL_EIGHTH;	
    FuelInit.FuelCapacityBoundary[8] = BOUNDARY_FUEL_NINTH;	  
    FuelInit.FuelCapacityBoundary[9] = BOUNDARY_FUEL_TENTH;	
    FuelInit.FuelCapacityBoundary[10] = BOUNDARY_FUEL_ELEVENTH;
    SetFuelSaveData(FuelSaveData, FuelSaveLen);
    InitFuelParamter(&FuelInit);
    SetFuelSensorRecoverGroupCnt(40);
    SetFuelSensorOpenCircuitGroupCnt(240);
    SetFuelSensorShortCircuitGroupCnt(240);
    
    AFCInit.CurODO = TripCPara.TotalODO;
	AFCInit.DteFactoryAfc = 13500;
    SetDrivingRangeSaveData(DrivingRangeSaveData, DrivingRangeSaveLen);
    InitAFC(&AFCInit);
    SetAFC_AutoReset(DISPLAY_AFC_ACCUMULATED_INFO, AFC_AUTO_RESET_OFF);         //fixed off
    SetAFC_AutoReset(DISPLAY_AFC_DRIVE_INFO, AFC_AUTO_RESET_IGN_OFF_4HOUR);     //fixed reset after ign off 4 hours
//fule init end
}

uint8_t LastFuelEconomyUnit = 0;
void ExecFuel(void)
{
    FUEL_IN_EN(PortGpioHigh);
    if (CurIgnSt == EVENT_IGN_ON) {
        SetPowerSt(1);
    } else {
        SetPowerSt(0);
    }
    
    FuelFSM(FuelRFinal);        
    
    if (((FuelConsumeSum * 128 / 1000)) >= 128) {
        AFCPara.FuleConsume = 128;
        FuelConsumeSum -= 1000;
    } else {
        AFCPara.FuleConsume = 0;
    }
    AFCPara.CurODO = TripCPara.TotalODO; 
    AFCPara.Speed = InputOutputSingal.CalcODOVehicleSpeed;
    AFCPara.RPM = InputOutputSingal.RPM;
    
    AFCPara.AFC_AutoResetIgnOffSec = 0;
    AFCPara.AFC_Short_AutoResetIgnOffSec = 0;

    SetAFCPara(&AFCPara);
    FuelResistance = GetFuelResistance();
    if (FuelResistance) {
        FuelStep = GetFuelStepPointer();//GetFuelStep();
        FuelCapacity = StepToCapacity(FuelStep);
    }
    DispayDTE = GetDRMileage();
    
    if (Can0DataStruct.ENG_STAT == 3) {
        EndWasStarted = 1;
    }
    
    if ((EndWasStarted) && (GetAfcValid(DISPLAY_AFC_FUEL_ECONOMY))) {
        AfcValided[DISPLAY_AFC_FUEL_ECONOMY] = 1;
    } else {
        AfcValided[DISPLAY_AFC_FUEL_ECONOMY] = 0;
    }
    
    if ((EndWasStarted) && (GetAfcValid(DISPLAY_AFC_ACCUMULATED_INFO))) {
        AfcValided[DISPLAY_AFC_ACCUMULATED_INFO] = 1;
    } else if (GetAfcValid(DISPLAY_AFC_ACCUMULATED_INFO) == 0) {
        AfcValided[DISPLAY_AFC_ACCUMULATED_INFO] = 0;
    }
    
    if ((EndWasStarted) && (GetAfcValid(DISPLAY_AFC_DRIVE_INFO))) {
        AfcValided[DISPLAY_AFC_DRIVE_INFO] = 1;
    } else {
        AfcValided[DISPLAY_AFC_DRIVE_INFO] = 0;
    }
    
    if ((AfcValided[DISPLAY_AFC_FUEL_ECONOMY] == 1) || (LastFuelEconomyUnit) && (LastFuelEconomyUnit != MMCanUsmPara.AVNFuelEconomyUnit_km)) {
        if (MMCanUsmPara.AVNFuelEconomyUnit_km == FUEL_ECONOMY_UNIT_KM_KML) {
            TripCPara.FuelEconomyAFC = GetAFC_KML(DISPLAY_AFC_FUEL_ECONOMY);
        } else {
            TripCPara.FuelEconomyAFC = GetAFC_100KM(DISPLAY_AFC_FUEL_ECONOMY);
        }
    }
    
    if ((AfcValided[DISPLAY_AFC_ACCUMULATED_INFO] == 1) || (LastFuelEconomyUnit) && (LastFuelEconomyUnit != MMCanUsmPara.AVNFuelEconomyUnit_km)) {
        if (MMCanUsmPara.AVNFuelEconomyUnit_km == FUEL_ECONOMY_UNIT_KM_KML) {
            TripCPara.AccumulatedInfoAFC = GetAFC_KML(DISPLAY_AFC_ACCUMULATED_INFO);
        } else {
            TripCPara.AccumulatedInfoAFC = GetAFC_100KM(DISPLAY_AFC_ACCUMULATED_INFO);
        }
    }
    
    if ((AfcValided[DISPLAY_AFC_DRIVE_INFO] == 1) || (LastFuelEconomyUnit) && (LastFuelEconomyUnit != MMCanUsmPara.AVNFuelEconomyUnit_km)) {
        if (MMCanUsmPara.AVNFuelEconomyUnit_km == FUEL_ECONOMY_UNIT_KM_KML) {
            TripCPara.DriveInfoAFC = GetAFC_KML(DISPLAY_AFC_DRIVE_INFO);
        } else {
            TripCPara.DriveInfoAFC = GetAFC_100KM(DISPLAY_AFC_DRIVE_INFO);
        }
    }  
    LastFuelEconomyUnit = MMCanUsmPara.AVNFuelEconomyUnit_km;
}

