#ifndef CAN_H_
#define CAN_H_


#define  UNFINISH    1
#define  FINISH      2

#define ROLE_TYPE_CAN_BOARD   0
#define ROLE_TYPE_CHECK_BENCH 1

extern uint8_t RxFinish;
extern Multiple_CAN_FRAME MultiplePack;
extern Core_CAN_FRAME CorePack;
extern uint8_t MyRecvCount;


extern uint8_t g_uiBufIndex;
extern void InitBuf(void);
extern void CheckRecvCan0Frame(stc_canfd_msg_t *stc_msg);
#define CanSendCan0Msg(id, Signal, Len, isClear)\
if(g_uiBufIndex <= BUF_39) {\
  CanFD_Send_StandMsg(CANFD0_Type, id, g_uiBufIndex++, TX_ISR_EN, (uint8_t *)&Signal, Len);\
    if(1 == isClear)\
      Can_Clear((uint8_t *)&Signal, sizeof(Signal));\
}

#define CanSendCan1Msg(id, Signal, Len, isClear)\
if(g_uiBufIndex <= BUF_39) {\
  CanFD_Send_StandMsg(CANFD1_Type, id, g_uiBufIndex++, TX_ISR_EN, (uint8_t *)&Signal, Len);\
    if(1 == isClear)\
      Can_Clear((uint8_t *)&Signal, sizeof(Signal));\
}
#if (ROLE_TYPE_CHECK_BENCH)
#define CanSendCan2Msg(id, Signal, Len, isClear)\
{\
  CanFD_Send_StandMsg(CANFD2_Type, id, BUF_40, TX_ISR_EN, (uint8_t *)&Signal, Len);\
    if(1 == isClear)\
      Can_Clear((uint8_t *)&Signal, sizeof(Signal));\
}
#endif
#if (ROLE_TYPE_CAN_BOARD)
#define CanSendCan2Msg(id, Signal, Len, isClear)\
{\
  CanFD_Send_StandMsg(CANFD0_Type, id, BUF_40, TX_ISR_EN, (uint8_t *)Signal, Len);\
    if(1 == isClear)\
      Can_Clear((uint8_t *)&Signal, sizeof(Signal));\
}
#endif

enum {
    CMD_IDLE,    
    CMD_EXPORT_DATA,
    CMD_EXPORT_DATA_STEP1,
    CMD_EXPORT_DATA_STEP2,
    CMD_EXPORT_DATA_STEP3,
    CMD_EXPORT_DATA_STEP4,
    CMD_EXPORT_DATA_STEP5,
};

enum {
    INIT_RECV,
    INIT_SEND,    
};

enum {
    SM_SEND_INIT = 1,
    SM_SEND_BEGIN,
    SM_SEND_DATA,
    SM_SEND_END,
};

enum {
    LED1,
    LED2,
    LED3,
    LED4,
    LED5,
    LED6,
    LED7,
    LED8,
};


enum {
    STATE_OFF,
    STATE_ON,
};
extern void InitStateMachine(uint8_t uiInitType);
extern void ExecStateMachine(uint8_t *data, uint8_t len);
extern void SendCan2Message(void);


typedef struct
{   
    //byte 0
    uint8_t MsgCheck_CcanState                 :1;    
    uint8_t MsgCheck_McanState                 :1;
    uint8_t MsgCheck_CcanMsgOut                :1;
    uint8_t MsgCheck_McanMsgOut                :1;
    uint8_t                                    :4;

    //byte 1
    uint8_t SW_VER                             :1;    
    uint8_t HW_VER                             :1;
    uint8_t CB_VER                             :1;
    uint8_t                                    :5;


    //byte 2
    uint8_t TripC_SW1                          :1;    
    uint8_t                                    :7;

    //byte 3
    uint8_t TripC_SW2                          :1;    
    uint8_t                                    :7;

    //byte 4
    uint8_t ENG_STATE                          :1;    
    uint8_t                                    :7;

    //byte 5
    uint8_t GEAR_P                             :1;    
    uint8_t GEAR_R                             :1;
    uint8_t GEAR_N                             :1;
    uint8_t GEAR_D                             :1;
    uint8_t GEAR_S                             :1;        
    uint8_t                                    :3;        

    //byte 6      
    uint8_t                                    :8;        

    //byte 7
    uint8_t GND_SIGNAL3                        :1;    
    uint8_t                                    :7;

    //byte 8
    uint8_t RHEO_01                            :1;    
    uint8_t RHEO_02                            :1;
    uint8_t RHEO_03                            :1;
    uint8_t RHEO_04                            :1;
    uint8_t RHEO_05                            :1;
    uint8_t RHEO_06                            :1;
    uint8_t RHEO_07                            :1;
    uint8_t RHEO_08                            :1;
									           
    //byte 9                                   
    uint8_t RHEO_09                            :1;
    uint8_t RHEO_10                            :1;
    uint8_t RHEO_11                            :1;    
    uint8_t RHEO_12                            :1;
    uint8_t RHEO_13                            :1;
    uint8_t RHEO_14                            :1;
    uint8_t RHEO_15                            :1;
    uint8_t RHEO_16                            :1;

    //byte 10
    uint8_t RHEO_17                            :1;
    uint8_t RHEO_18                            :1;
    uint8_t RHEO_19                            :1;
    uint8_t RHEO_20                            :1;
    uint8_t                                    :4;

    //byte 11
    uint8_t Detent                             :1;    
    uint8_t                                    :7;

    //byte 12
    uint8_t SPEED_020_FREQ                     :1;
    uint8_t SPEED_040_FREQ                     :1;
    uint8_t SPEED_060_FREQ                     :1;
    uint8_t SPEED_080_FREQ                     :1;
    uint8_t SPEED_100_FREQ                     :1;
    uint8_t SPEED_120_FREQ                     :1;
    uint8_t SPEED_140_FREQ                     :1;
    uint8_t SPEED_160_FREQ                     :1;

    //byte 13
    uint8_t SPEED_180_FREQ                     :1;
    uint8_t SPEED_200_FREQ                     :1;
    uint8_t SPEED_220_FREQ                     :1;
    uint8_t SPEED_240_FREQ                     :1;
    uint8_t SPEED_260_FREQ                     :1;
    uint8_t                                    :3;

    //byte 14
    uint8_t BackLight_01_ILL                   :1;
    uint8_t BackLight_02_ILL                   :1;
    uint8_t BackLight_03_ILL                   :1;
    uint8_t BackLight_04_ILL                   :1;
    uint8_t BackLight_05_ILL                   :1;
    uint8_t BackLight_06_ILL                   :1;
    uint8_t BackLight_07_ILL                   :1;
    uint8_t BackLight_08_ILL                   :1;

    //byte 15
    uint8_t BackLight_09_ILL                   :1;
    uint8_t BackLight_10_ILL                   :1;
    uint8_t BackLight_11_ILL                   :1;
    uint8_t BackLight_12_ILL                   :1;
    uint8_t BackLight_13_ILL                   :1;
    uint8_t BackLight_14_ILL                   :1;
    uint8_t BackLight_15_ILL                   :1;
    uint8_t BackLight_16_ILL                   :1;

    //byte 16
    uint8_t BackLight_17_ILL                   :1;
    uint8_t BackLight_18_ILL                   :1;
    uint8_t BackLight_19_ILL                   :1;
    uint8_t BackLight_20_ILL                   :1;
    uint8_t                                    :3;
    uint8_t StaticCurrent                      :1;

    //byte 17
    uint8_t Eol_State                          :1;
    uint8_t                                    :7;

    //byte 18
    uint8_t End_State                          :1;
    uint8_t                                    :7;
    uint8_t Reserve[29];
}ST_CHECK_RESULT;  

extern ST_CHECK_RESULT g_stCheckResult;
#endif
