/******************************************************************************
 * $Revision: 423 $
 * $Date:: 2017-04-07 16:03:30 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************
 ** \file bt_rlt_generated.c
 **
 ** Generated file for bt_rlt.c module, including variables and functions
 ** for internal data and interrupt handling. The individual ISRs for each
 ** peripheral are calling the generic handler in bt_rlt.c.
 **
 ** \note This file must not be added to the build files - it will be included
 **       by bt_rlt.c automatically!
 **
 ** History:
 **   - 2014-06-26  0.01  HS  Initial version for Traveo
 *****************************************************************************/

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "common_include.h"
#include "bsp_bt_rlt.h"

/*****************************************************************************/
/* Local pre-processor symbols/macros ('#define')                            */
/*****************************************************************************/

/** Macro to return the number of enabled RLT instances */
#define RLT_INSTANCE_COUNT (uint32_t)(sizeof(m_astcRltInstanceDataLut) / sizeof(m_astcRltInstanceDataLut[0]))

/*****************************************************************************/
/* Global variable definitions (declared in header file with 'extern')       */
/*****************************************************************************/


/*****************************************************************************/
/* Local type definitions ('typedef')                                        */
/*****************************************************************************/

/* Enumeration to define an index for each enabled RLT instance */
typedef enum en_rlt_instance_index
{
    RltInstanceIndexRlt0,
    RltInstanceIndexRlt1,
    RltInstanceIndexRlt2,
    RltInstanceIndexRlt3,
    RltInstanceIndexRlt4,
    RltInstanceIndexRlt5,
    RltInstanceIndexRlt6,
    RltInstanceIndexRlt7,
    RltInstanceIndexRlt8,
    RltInstanceIndexRlt9,
    RltInstanceIndexRlt10,
    RltInstanceIndexRlt11,
    RltInstanceIndexRlt12,
    RltInstanceIndexRlt13,
    RltInstanceIndexRlt14,
    RltInstanceIndexRlt15,
    RltInstanceIndexRlt16,
    RltInstanceIndexRlt17,
    RltInstanceIndexRlt18,
    RltInstanceIndexRlt19,
    RltInstanceIndexRlt20,
    RltInstanceIndexRlt21,
    RltInstanceIndexRlt22,
    RltInstanceIndexRlt23,
    RltInstanceIndexRlt24,
    RltInstanceIndexRlt25,
    RltInstanceIndexRlt26,
    RltInstanceIndexRlt27,
    RltInstanceIndexRlt28,
    RltInstanceIndexRlt29,
    RltInstanceIndexRlt30,
    RltInstanceIndexRlt31,
    RltInstanceIndexMax
} en_rlt_instance_index_t;
    
/* RLT instance data type */
typedef struct stc_rlt_instance_data
{
    volatile stc_btn_rt_t* pstcInstance;   /*!< pointer to registers of an instance */
    stc_rlt_intern_data_t stcInternData;   /*!< module internal data of instance */
} stc_rlt_instance_data_t;

/*****************************************************************************/
/* Local variable definitions ('static')                                     */
/*****************************************************************************/

/* Look-up table for all enabled RLT instances and their internal data */
static stc_rlt_instance_data_t m_astcRltInstanceDataLut[] =
{
    {&BT00_RT, { NULL }},
    {&BT01_RT, { NULL }},
    {&BT02_RT, { NULL }},
    {&BT03_RT, { NULL }},
    {&BT04_RT, { NULL }},
    {&BT05_RT, { NULL }},
    {&BT06_RT, { NULL }},
    {&BT07_RT, { NULL }},
    {&BT08_RT, { NULL }},
    {&BT09_RT, { NULL }},
    {&BT10_RT, { NULL }},
    {&BT11_RT, { NULL }},
    {&BT12_RT, { NULL }},
    {&BT13_RT, { NULL }},
    {&BT14_RT, { NULL }},
    {&BT15_RT, { NULL }},
    {&BT16_RT, { NULL }},
    {&BT17_RT, { NULL }},
    {&BT18_RT, { NULL }},
    {&BT19_RT, { NULL }},
    {&BT20_RT, { NULL }},
    {&BT21_RT, { NULL }},
    {&BT22_RT, { NULL }},
    {&BT23_RT, { NULL }},
    {&BT24_RT, { NULL }},
    {&BT25_RT, { NULL }},
    {&BT26_RT, { NULL }},
    {&BT27_RT, { NULL }},
    {&BT28_RT, { NULL }},
    {&BT29_RT, { NULL }},
    {&BT30_RT, { NULL }},
    {&BT31_RT, { NULL }},
};

/*****************************************************************************/
/* Local function prototypes ('static')                                      */
/*****************************************************************************/

/*****************************************************************************/
/* Function implementation - global ('extern') and local ('static')          */
/*****************************************************************************/

/**
 *****************************************************************************
 ** \brief Return the internal data for a certain RLT instance.
 **
 ** \param pstcRlt Pointer to RLT instance
 **
 ** \return Pointer to internal data or NULL if instance is not enabled (or not known)
 **
 *****************************************************************************/
stc_rlt_intern_data_t* BtRltGetInternDataPtr(volatile stc_btn_rt_t* pstcRlt) 
{
    uint32_t u32Instance;
   
    for (u32Instance = 0; u32Instance < RLT_INSTANCE_COUNT; u32Instance++)
    {
        if (pstcRlt == m_astcRltInstanceDataLut[u32Instance].pstcInstance)
        {
            return &m_astcRltInstanceDataLut[u32Instance].stcInternData;
        }
    }

    return NULL;
}

/**
 *****************************************************************************
 ** Definition of all individual ISRs for each enabled RLT instance.
 **
 ** The individual ISR calls the generic IRQ handler with
 ** the instance pointer and its internal data to handle the interrupt.
 *****************************************************************************/
FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt0(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_100;
    BtRltIrqHandler((stc_btn_rt_t*)&BT00_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt0].stcInternData));
    BtRltIrqHandler((stc_btn_rt_t*)&BT08_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt8].stcInternData));
    BtRltIrqHandler((stc_btn_rt_t*)&BT09_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt9].stcInternData));
    BtRltIrqHandler((stc_btn_rt_t*)&BT10_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt10].stcInternData));
    BtRltIrqHandler((stc_btn_rt_t*)&BT11_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt11].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt1(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_101;
    BtRltIrqHandler((stc_btn_rt_t*)&BT01_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt1].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt2(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_102;
    BtRltIrqHandler((stc_btn_rt_t*)&BT02_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt2].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt3(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_103;
    BtRltIrqHandler((stc_btn_rt_t*)&BT03_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt3].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt4(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_104;
    BtRltIrqHandler((stc_btn_rt_t*)&BT04_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt4].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt5(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_105;
    BtRltIrqHandler((stc_btn_rt_t*)&BT05_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt5].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt6(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_106;
    BtRltIrqHandler((stc_btn_rt_t*)&BT06_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt6].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt7(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_107;
    BtRltIrqHandler((stc_btn_rt_t*)&BT07_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt7].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt12(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_108;
    BtRltIrqHandler((stc_btn_rt_t*)&BT12_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt12].stcInternData));
    BtRltIrqHandler((stc_btn_rt_t*)&BT20_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt20].stcInternData));
    BtRltIrqHandler((stc_btn_rt_t*)&BT21_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt21].stcInternData));
    BtRltIrqHandler((stc_btn_rt_t*)&BT22_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt22].stcInternData));
    BtRltIrqHandler((stc_btn_rt_t*)&BT23_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt23].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt13(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_109;
    BtRltIrqHandler((stc_btn_rt_t*)&BT13_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt13].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt14(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_110;
    BtRltIrqHandler((stc_btn_rt_t*)&BT14_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt14].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt15(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_111;
    BtRltIrqHandler((stc_btn_rt_t*)&BT15_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt15].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt16(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_112;
    BtRltIrqHandler((stc_btn_rt_t*)&BT16_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt16].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt17(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_113;
    BtRltIrqHandler((stc_btn_rt_t*)&BT17_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt17].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt18(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_114;
    BtRltIrqHandler((stc_btn_rt_t*)&BT18_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt18].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt19(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_115;
    BtRltIrqHandler((stc_btn_rt_t*)&BT19_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt19].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}


FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt24(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_116;
    BtRltIrqHandler((stc_btn_rt_t*)&BT24_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt24].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt25(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_117;
    BtRltIrqHandler((stc_btn_rt_t*)&BT25_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt25].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt26(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_118;
    BtRltIrqHandler((stc_btn_rt_t*)&BT26_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt26].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt27(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_119;
    BtRltIrqHandler((stc_btn_rt_t*)&BT27_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt27].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt28(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_120;
    BtRltIrqHandler((stc_btn_rt_t*)&BT28_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt28].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt29(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_121;
    BtRltIrqHandler((stc_btn_rt_t*)&BT29_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt29].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt30(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_122;
    BtRltIrqHandler((stc_btn_rt_t*)&BT30_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt30].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

FN_IRQ_NOT_NESTED void Rlt_Isr_Rlt31(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_123;
    BtRltIrqHandler((stc_btn_rt_t*)&BT31_RT, &(m_astcRltInstanceDataLut[RltInstanceIndexRlt31].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}

void BSP_ReloadTimer_Init(uint8_t ch, en_rlt_clock_prescaler_t RltDiv, uint32_t ReloadValue, func_ptr_t Callback)
{
    stc_rlt_config_t stcRltConfig = 
    { 
        .enPrescaler            = RltDiv,                     // Clock further divided by 16
        .enOperationMode        = RltSoftwareTriggerOnly,     // Trigger with Software
        .b32bitTimerModeEnable  = FALSE,                      // 16bit mode
        .bOutputPolarityInverse = FALSE,                      // normal polarity
        .bOneshotEnable         = FALSE,                      // run cyclic
        .bGateInputEnable       = FALSE,                      // trigger input
        .pfnTriggerCallback     = NULL,                       // use callback for interrupt
        .pfnUnderflowCallback   = Callback
    };
    
    // Init Timer with above configuration
    Bt_Rlt_Init(m_astcRltInstanceDataLut[ch].pstcInstance, &stcRltConfig);
    
    // Start RLT by software trigger, and loads RLT_RELOAD_VALUE
    Bt_Rlt_Start(m_astcRltInstanceDataLut[ch].pstcInstance, NULL, ReloadValue, TRUE);
}

