/*
 * Var_Type.h
 *
 *  Created on: 2012-3-23
 *      Author: qitiancun
 */

#ifndef VAR_TYPE_H_
#define VAR_TYPE_H_

    #define             ADEveLen        10
    typedef             unsigned char   INT8U;
    typedef   volatile  unsigned char   VINT8U;
    typedef             unsigned int    INT16U;
    typedef   volatile  unsigned int    VINT16U;
    typedef             unsigned long   INT32U;
    

    typedef union 
    {
         struct
         {

              INT8U     Reserved0:1;
              INT8U     Reserved1:1;
              INT8U     Reserved2:1;
              INT8U     Reserved3:1;
              INT8U     Reserved4:1;
              INT8U     Reserved5:1;
              INT8U     Reserved6:1;
              INT8U     Reserved7:1;
         }bits;
         INT32U flag[3];
    }_SysFlag;
        
        
        
 typedef  union{
  byte bbyte; 
  struct {
  INT8U   a0 :1;
  INT8U   a1 :1;
  INT8U   a2 :1;
  INT8U   a3 :1;
  INT8U   a4 :1;
  INT8U   a5 :1;
  INT8U   a6 :1;
  INT8U   a7 :1;
  } bbit;
} MSG_DATA; 
        
  	typedef struct 
  	{
  		INT32U id;  		
  		INT16U cycl;
  		INT8U  dlc;
  		INT8U  prio;	
  		MSG_DATA  data[8];
  	}_CanMsg;
    
    
    typedef struct
    {
         INT8U    TEnable7;
         INT16U   OverTime7;    //定时极限
         INT16U   Time7;          
         INT8U    TEnable6;
         INT16U   OverTime6;    //定时极限
         INT16U   Time6;         
         INT8U    TEnable5;
         INT16U   OverTime5;    //定时极限
         INT16U   Time5;
         INT8U    TEnable4;
         INT16U   OverTime4;    //定时极限
         INT16U   Time4;         
         INT8U    TEnable3;
         INT16U   OverTime3;    //定时极限
         INT16U   Time3;
         INT8U    TEnable2;
         INT16U   OverTime2;    //定时极限
         INT16U   Time2;
         INT8U    TEnable1;
         INT16U   OverTime1;    //定时极限
         INT16U   Time1;  
         INT8U    TEnable0;
         INT16U   OverTime0;    //定时极限
         INT16U   Time0;  
         INT8U    TEnable;
         INT16U   OverTime;    
         INT16U   Time;               
         INT8U    HalfSeconds; //1/10秒             
         INT8U    Seconds;
         INT8U    Minutes;
         INT8U    Hours;
    }_Clock;
 
    
 
   typedef struct                               
   {
       INT16U      id;
       INT8U       msg[8];
       INT8U       dlc;                  
   }_SendCanMsg; 
   
    typedef struct
    {
        INT8U ProceF;  //处理标志位
        INT8U Data[8];
    }__RevCanMsg;
             
             
    typedef struct                             
    {
      INT8U          LED_STEP;
      INT16U         PushTime1;  
      INT16U         PushTime2;
      INT16U         PushTime3;  
      INT16U         PushTime4;  
      INT16U         PushTime5;  
      INT16U         PushTime6; 
      INT16U         PushTime7;     
      INT16U         PushTime8; 
      INT16U         PushTime9;     
      INT16U         PushTime10; 
    }_Button; 
             
             
#endif /* VAR_TYPE_H_ */
