#ifndef __APP_TFT_TRIPC_H__
#define __APP_TFT_TRIPC_H__

#define DISPLAY_AFC_FUEL_ECONOMY 0
#define DISPLAY_AFC_ACCUMULATED_INFO 1
#define DISPLAY_AFC_DRIVE_INFO 2
//language 
/****************************************************************************************
*           ||һ|ж|ŷ|||ô|ī|  |˹ |й  |ӡ |
*           |DOM |GEN |MID |EEC |AUS |USA |CAN   |MEX   |BRAZIL|RUSSIA |CHINA |INDIA|
*HU_LanguageInfo|0x1 |0x2 |0x8 |0x3 |0x1d|0x2 |0x2   |0x15  |0x1a  |0x10   |0x4   |0x3  |
****************************************************************************************/
enum {
    AREA_CHINA,
    AREA_DOM,
    AREA_GEN,
};

#define CHINESE 1
#define ENGLISH 2
#define KOREAN  3

#define LANGUAGE_CHINA  1
#define LANGUAGE_GEN    2
#define LANGUAGE_DOM    3

//language end

typedef struct {
        uint16_t ECS     :1;
        uint16_t LKA_LDW :1;
        uint16_t TPMS    :1;
        uint16_t ESC     :1;
        uint16_t MDPS    :1;
        uint16_t AHLS    :1;
        uint16_t EPB     :1;
        uint16_t _SCC     :1;
        uint16_t Reserved :1;
        uint16_t EVP      :1;
        uint16_t _AT      :1;
        uint16_t _4WD     :1;
        uint16_t AFL      :1;
        uint16_t PSB      :1;
        uint16_t AIR_BAG  :1;
        uint16_t ABS      :1;
}EOL_STRUCT;
extern EOL_STRUCT EolStruct;

typedef struct {
    uint8_t ModuleFCA;
    uint8_t ModuleFCARecvCnt;
    uint8_t ModuleDAW;
    uint8_t ModuleDAWRecvCnt;
    uint8_t ModuleAVN_AV;
    uint8_t ModuleAVN_TBT;
    uint8_t ModuleBCW;
    uint8_t ModuleBCWRecvCnt;
    uint8_t ModuleHBA;
    uint8_t ModuleHBARecvCnt;
    uint8_t ModuleISLW;
    uint8_t ModuleISLWRecvCnt;
    uint8_t ModuleTPMS;
    uint8_t ModuleTPMSRecvCnt;
    uint8_t ModuleDCT;
    uint8_t ModuleDCTRecvCnt;
}SOFTWARE_VARIANT_CODING_STRUCT;
extern SOFTWARE_VARIANT_CODING_STRUCT SoftwareVariantCoding;

enum {
    TRIP_C_FUEL_ECONOMY,
    TRIP_C_ACCUMULATED_INFO,
    TRIP_C_DRIVE_INFO,
    TRIP_C_DIGITAL_SPEEDOMETER,
    //TRIP_C_AUTO_STOP,
    //TRIP_C_DRIVE_MODE,
    //TRIP_C_TRANSMISSION_TEMPERATURE,
    TRIP_C_TOTAL,
};

enum {
    DA_LKA = 0,
    DA_DAW,
};

typedef struct {
    uint32_t TotalODO;
    uint32_t TotalODOTemp;
    uint8_t CurTripCItem;
    uint16_t FuelEconomyAFC;
    uint16_t DestFuelEconomyIFC;
    uint16_t CurFuelEconomyIFC;
    uint32_t AccumulatedInfoODO;
    uint16_t AccumulatedInfoAFC;
    uint32_t AccumulatedInfoTimerSeconds;
    uint32_t DriveInfoODO;
    uint16_t DriveInfoAFC;
    uint32_t DriveInfoTimerSeconds;
    uint16_t Speed;
    int32_t ServiceReminderKm;
    int32_t ServiceReminderSeconds;
    uint8_t CurDriveMode;
    uint8_t TransmissionTemperatureLv;
    uint8_t Recent600msSpeedIndex;
    uint16_t Recent600msSpeed[30][4];
    uint8_t Recent600msFCOIndex;
    uint16_t Recent600msFCO[60];
}TRIP_C_STRUCT;
extern TRIP_C_STRUCT TripCPara;
 
extern uint8_t SaveODOValid;
extern uint8_t SaveAFCValid;
extern uint8_t SaveServiceRemainderValid;

extern const uint32_t Num20List[];
extern const uint32_t Num47List[];

extern uint16_t CalcIFC(void);
extern void CalcODO(void);
extern void UpdateCenterTripC(void);
extern void UpdateLKA(void);
extern void UpdateDaw(void);



#endif