#include "common_include.h"
#include "bsp_app_led_output.h"

void InitTelltale_SU2IFL(void)
{
#if (PRO_SU2IFL)
    SetTelltalePos("High Beam",        HighBeam);
    SetTelltalePos("HBA Green",        HBAGreen);
    SetTelltalePos("HBA White",        HBAWhite);
    SetTelltalePos("Low Beam",         LowBeam);    
    SetTelltalePos("Turn Left",        LeftTurn);
    SetTelltalePos("Turn Right",       RightTurn);
    SetTelltalePos("Tail Lamp",        TailLamp);  
    SetTelltalePos("Front Fog",        FrontFog);
    SetTelltalePos("Rear Fog",          RearFog); //Except IA ?
    SetTelltalePos("Master Symbol",    MasterSymbol);    
    if (IsHaveDBC()) {
        SetTelltalePos("DBC Green",        DBCGreen);
        SetTelltalePos("DBC Yellow",       DBCYellow);
    }
    SetTelltalePos("TPMS",                 Tpms);    
    SetTelltalePos("EPB",                   EPB);
    SetTelltalePos("Over Speed",      OverSpeed); //I3 Region only
    SetTelltalePos("Immobilizer",   Immobilizer);
    SetTelltalePos("Parking Break",    ParkingBreak);//Ҫ
    SetTelltalePos("ABS",              ABS);
    SetTelltalePos("Seat Belt",        SeatBelt);
    SetTelltalePos("InteriorLamp",      InteriorLamp);
    SetTelltalePos("FCA Yellow",       FcaYellow);
    SetTelltalePos("FCA RedBlink",     FcaRed);
    SetTelltalePos("DPF/GPF",          DpfGpf);    
    SetTelltalePos("MDPS",             Mdps);
    SetTelltalePos("Battery Charge",   BatteryCharge);    
    SetTelltalePos("Air Bag",          AirBag);
    SetTelltalePos("Oil Pressure",     OilPressure);
    SetTelltalePos("GLOW DSL",         Glow); //DSL ONLY
    SetTelltalePos("LED Lamp Fail",    LedLampFail);
    SetTelltalePos("SCR DSL",          SCR);  //DSL ONLY
    SetTelltalePos("ECall",            Ecall);
    SetTelltalePos("ESC OFF",          EscOff);
    SetTelltalePos("ESC",              ESC);    
    SetTelltalePos("Check Engine",     CheckEngine);
    SetTelltalePos("Water Saperator",  WaterSaperator);//DSL ONLY
    SetTelltalePos("AllLedOpen",          AllLedOpen);
    SetTelltalePos("LOW FUEL",         DMS_RestoreDefault);
#endif
}


