/******************************************************************************
 * $Revision: 423 $
 * $Date:: 2017-04-07 16:03:30 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************
 ** \file frt_generated.c
 **
 ** Generated file for frt.c module, including variables and functions
 ** for internal data and interrupt handling. The individual ISRs for each
 ** peripheral are calling the generic handler in frt.c.
 **
 ** \note This file must not be added to the build files - it will be included
 **       by frt.c automatically!
 **
 ** History:
 **   - 2014-06-26  0.01  HS  Initial version for Traveo
 *****************************************************************************/

#ifndef __FRT_GENERATED_C__
#define __FRT_GENERATED_C__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include <interrupts.h>

/*****************************************************************************/
/* Local pre-processor symbols/macros ('#define')                            */
/*****************************************************************************/

/** Macro to return the number of enabled FRT instances */
#define FRT_INSTANCE_COUNT (uint32_t)(sizeof(m_astcFrtInstanceDataLut) / sizeof(m_astcFrtInstanceDataLut[0]))

/*****************************************************************************/
/* Global variable definitions (declared in header file with 'extern')       */
/*****************************************************************************/


/*****************************************************************************/
/* Local type definitions ('typedef')                                        */
/*****************************************************************************/

/* Enumeration to define an index for each enabled FRT instance */
typedef enum en_frt_instance_index
{
    #if (PDL_PERIPHERAL_ENABLE_FRT0 == PDL_ON)
    FrtInstanceIndexFrt0,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT1 == PDL_ON)
    FrtInstanceIndexFrt1,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT2 == PDL_ON)
    FrtInstanceIndexFrt2,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT3 == PDL_ON)
    FrtInstanceIndexFrt3,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT4 == PDL_ON)
    FrtInstanceIndexFrt4,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT8 == PDL_ON)
    FrtInstanceIndexFrt8,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT9 == PDL_ON)
    FrtInstanceIndexFrt9,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT10 == PDL_ON)
    FrtInstanceIndexFrt10,
    #endif
    FrtInstanceIndexMax
} en_frt_instance_index_t;
    
/* FRT instance data type */
typedef struct stc_frt_instance_data
{
    volatile stc_frtn_t* pstcInstance;   /* pointer to registers of an instance */
    stc_frt_intern_data_t stcInternData; /* module internal data of instance */
} stc_frt_instance_data_t;

/*****************************************************************************/
/* Local variable definitions ('static')                                     */
/*****************************************************************************/

/* Look-up table for all enabled FRT instances and their internal data */
static stc_frt_instance_data_t m_astcFrtInstanceDataLut[] =
{
    #if (PDL_PERIPHERAL_ENABLE_FRT0 == PDL_ON)
    {
        &FRT00,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT1 == PDL_ON)
    {
        &FRT01,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT2 == PDL_ON)
    {
        &FRT02,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT3 == PDL_ON)
    {
        &FRT03,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT4 == PDL_ON)
    {
        &FRT04,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT8 == PDL_ON)
    {
        &FRT08,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT9 == PDL_ON)
    {
        &FRT09,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_FRT10 == PDL_ON)
    {
        &FRT10,         /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    #endif
};

/*****************************************************************************/
/* Local function prototypes ('static')                                      */
/*****************************************************************************/

/*****************************************************************************/
/* Function implementation - global ('extern') and local ('static')          */
/*****************************************************************************/

/**
 *****************************************************************************
 ** \brief Return the internal data for a certain FRT instance.
 **
 ** \param pstcFrt Pointer to FRT instance
 **
 ** \return Pointer to internal data or NULL if instance is not enabled (or not known)
 **
 *****************************************************************************/
static stc_frt_intern_data_t* FrtGetInternDataPtr(volatile stc_frtn_t* pstcFrt) 
{
    uint32_t u32Instance;
   
    for (u32Instance = 0; u32Instance < FRT_INSTANCE_COUNT; u32Instance++)
    {
        if (pstcFrt == m_astcFrtInstanceDataLut[u32Instance].pstcInstance)
        {
            return &m_astcFrtInstanceDataLut[u32Instance].stcInternData;
        }
    }

    return NULL;
}

/**
 *****************************************************************************
 ** Definition of all individual ISRs for each enabled FRT instance.
 **
 ** The individual ISR calls the generic IRQ handler with
 ** the instance pointer and its internal data to handle the interrupt.
 *****************************************************************************/
#if (PDL_PERIPHERAL_ENABLE_FRT0 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Frt_Isr_Frt0, INTERRUPTS_IRQ_NUMBER_150)
{
    FrtIrqHandler((stc_frtn_t*)&FRT00, &(m_astcFrtInstanceDataLut[FrtInstanceIndexFrt0].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_FRT1 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Frt_Isr_Frt1, INTERRUPTS_IRQ_NUMBER_151)
{
    FrtIrqHandler((stc_frtn_t*)&FRT01, &(m_astcFrtInstanceDataLut[FrtInstanceIndexFrt1].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_FRT2 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Frt_Isr_Frt2, INTERRUPTS_IRQ_NUMBER_152)
{
    FrtIrqHandler((stc_frtn_t*)&FRT02, &(m_astcFrtInstanceDataLut[FrtInstanceIndexFrt2].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_FRT3 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Frt_Isr_Frt3, INTERRUPTS_IRQ_NUMBER_153)
{
    FrtIrqHandler((stc_frtn_t*)&FRT03, &(m_astcFrtInstanceDataLut[FrtInstanceIndexFrt3].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_FRT4 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Frt_Isr_Frt4, INTERRUPTS_IRQ_NUMBER_154)
{
    FrtIrqHandler((stc_frtn_t*)&FRT04, &(m_astcFrtInstanceDataLut[FrtInstanceIndexFrt4].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_FRT8 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Frt_Isr_Frt8, INTERRUPTS_IRQ_NUMBER_156)
{
    FrtIrqHandler((stc_frtn_t*)&FRT08, &(m_astcFrtInstanceDataLut[FrtInstanceIndexFrt8].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_FRT9 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Frt_Isr_Frt9, INTERRUPTS_IRQ_NUMBER_157)
{
    FrtIrqHandler((stc_frtn_t*)&FRT09, &(m_astcFrtInstanceDataLut[FrtInstanceIndexFrt9].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_FRT10 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Frt_Isr_Frt10, INTERRUPTS_IRQ_NUMBER_158)
{
    FrtIrqHandler((stc_frtn_t*)&FRT10, &(m_astcFrtInstanceDataLut[FrtInstanceIndexFrt10].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#endif  // __FRT_GENERATED_C__

