#include "common_include.h"

volatile    _NM_BusOffCtlInfo  NM_BusOffCtl;


void   NM_D_Init(uint8_t state);
void   NM_D_Online();
void   NM_D_Offline();
void   NM_D_BusOff_Recover();
    
    
/*-------------------------------------------------------------------------
* Function Name  : NM_D_BusOff_Recover
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_D_BusOff_Recover(void)
{
    if(CANFD1_Type->unPSR.stcField.u1BO) //CHECK BUSOFF EVENT
    {
        NetWorkStatus.BusOffEvent = 1;
        if(NM_BusOffCtl.RecoverTime == 0)
        {
            NM_BusOffCtl.RecoverTime = 37;
            bsp_tx_msgbuf_abort(1);
            CANFD1_Type->unCCCR.stcField.u1INIT = 0;
        }
        if(NM_BusOffCtl.RecoverTime > 0)
        {
            NM_BusOffCtl.RecoverTime --;
        }
    }
    else
    {
        NM_BusOffCtl.RecoverTime = 0;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : NM_D_Init
* Description    : CAN Init and handle data link layer
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_D_Init(uint8_t state)
{
    stc_port_pin_config_t   stc_port_pin_config_out;
    stc_port_pin_config_out.enOutputFunction      = PortOutputResourceGPIO;
    stc_port_pin_config_out.enOutputDrive         = PortOutputDriveA;
    stc_port_pin_config_out.enPullResistor        = PortPullResistorNone;
    stc_port_pin_config_out.enInputLevel          = PortInputLevelCmosA;
    stc_port_pin_config_out.bInputEnable          = FALSE;
    stc_port_pin_config_out.bNoiseFilterEnable    = TRUE;
    stc_port_pin_config_out.enGpioDirection       = PortGpioOutput;
    
    switch(state)
    {
        case BusInit:
            //stb
#if (CAN_2ND)			
            stc_port_pin_config_out.enGpioInitOutputLevel = PortGpioHigh;
            Port_SetPinConfig( 1, 22, &stc_port_pin_config_out );
            //en
            stc_port_pin_config_out.enGpioInitOutputLevel = PortGpioHigh;
            // Port_SetPinConfig( 1, 21, &stc_port_pin_config_out );
#endif
#if (CAN_3RD)	
			stc_port_pin_config_out.enGpioInitOutputLevel = PortGpioLow;
            Port_SetPinConfig( 1, 2, &stc_port_pin_config_out );
            //en
            //stc_port_pin_config_out.enGpioInitOutputLevel = PortGpioHigh;
            //Port_SetPinConfig( 1, 21, &stc_port_pin_config_out );	
#endif	
            // bsp_CAN1_Init();
            break;
        case BusSleep:
            bsp_tx_msgbuf_abort( 1 );
            bsp_CAN_Sleep( 1 );
            break;
        default:
            ;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : NM_D_Online
* Description    : Enable app msg send and set app msg send delay timer
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_D_Online(void)
{
    AppMsgSendRequest = 1;
}

/*-------------------------------------------------------------------------
* Function Name  : NM_D_Offline
* Description    : Disable app msg send
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void NM_D_Offline(void)
{
    AppMsgSendRequest = 0;
    
    if (AppMsgTime[MSG_0x1DF].AppTime < 10) {
        AppMsgTime[MSG_0x1DF].AppTime = 10;
    }
    
    if (AppMsgTime[MSG_0x1D4].AppTime < 10) {
        AppMsgTime[MSG_0x1D4].AppTime = 10;
    }
    
    if (AppMsgTime[MSG_0x1D5].AppTime < 10) {
        AppMsgTime[MSG_0x1D5].AppTime = 10;
    }
}
