

#include "r_typedefs.h"
#include "dr7f701684.dvf.h"

/*-----------------use for RH850_F1KM_S1 --------------------*/
#include "rh850_macros.h"
#include "RSCAN.h"
#include "RSCAN_Table.h"

#define RSCAN_CKSCLK_IPERI2_CLKC         40000000UL /*PPLLCLK2*/
#define RSCAN_CKSCLK_ICANOSC_CLK_XIN_CAN 8000000UL  /*MainOSC*/
#define RSCAN_F_CAN                      RSCAN_CKSCLK_IPERI2_CLKC

#define RSCAN0_BASE_ADDRESS 0xFFD00000UL

/*--------------500K-----------------------------*/
#define RSCAN0_500K_BAUD_RATE 500U    //波特率,单位kbps
#define RSCAN0_500K_T_SEG1    12U     //时间段1的Tq数
#define RSCAN0_500K_T_SEG2    3U      //时间段2的Tq数
#define RSCAN0_500K_SJW       3U      //同步跳转宽度

#define RSCAN_500K_BIT_RATE_DIV (RSCAN_F_CAN / (RSCAN0_500K_BAUD_RATE) / (RSCAN0_500K_T_SEG1 + RSCAN0_500K_T_SEG2 + 1UL) / 1000UL)

/*-----------------250K---------------------------------*/
#define RSCAN0_250K_BAUD_RATE 250U    //波特率,单位kbps
#define RSCAN0_250K_T_SEG1    13U     //11 //时间段1的Tq数
#define RSCAN0_250K_T_SEG2    2U      //4	 //时间段2的Tq数
#define RSCAN0_250K_SJW       1U      //2 //3

#define RSCAN_250K_BIT_RATE_DIV (RSCAN_F_CAN / (RSCAN0_250K_BAUD_RATE) / (RSCAN0_250K_T_SEG1 + RSCAN0_250K_T_SEG2 + 1UL) / 1000UL)
/*------------------------------------------------*/
#if ( (RSCAN0_500K_T_SEG2 < 2U) || (RSCAN0_250K_T_SEG2 < 2U) )
    #error RSCAN0 Time Segment 2 error!!!
#endif
#if ( (RSCAN0_500K_T_SEG1 < 4U) || (RSCAN0_250K_T_SEG1 < 4U) )
    #error RSCAN0 Time Segment 1 error!!!
#endif
#if ( (RSCAN0_500K_SJW < 1U) || (RSCAN0_250K_SJW < 1U) )
    #error RSCAN0 Resynchronization Jump Width error!!!
#endif
#if ( (RSCAN_500K_BIT_RATE_DIV < 1U) || (RSCAN_250K_BIT_RATE_DIV > 1024U) )
    #error RSCAN0 Communication speed  error!!!
#endif

/*---------------------------------------*/

/*---------------------------------------*/

/***************************************************/
/**COMPLETE**/
#define RSCAN_ABORT_CPLT_AND 0X06U
#define RSCAN_ABORT_CPLT     0X02U
#define RSCAN_TX_CPLT_AND    0X04U
#define RSCAN_TX_CPLT        0X04U
/***************************************************/

/*RCFDC0CFDGCFG*/
/*CMPOC*/
#define RSCAN_OVERFLOW_NO_STORED (0U << 5U)
#define RSCAN_OVERFLOW_STORED    (1U << 5U)
/*DCS*/
#define RSCAN_CLOCK_SOURCE_CLKC       (0U << 4U)
#define RSCAN_CLOCK_SOURCE_CLK_XINCAN (1U << 4U)
/*TPRI*/
#define RSCAN_TX_PRIORITY_ID         (0U)
#define RSCAN_TX_PRIORITY_BUFFER_NUM (1U)

/*RCFDC0CFDC0NCFG*/
#define RSCAN_500K_NTSEG2 ((RSCAN0_500K_T_SEG2 - 1U) << 24U)
#define RSCAN_500K_NTSEG1 ((RSCAN0_500K_T_SEG1 - 1U) << 16U)
#define RSCAN_500K_NSJW   ((RSCAN0_500K_SJW - 1U) << 11U)
#define RSCAN_500K_NBRP   (RSCAN_500K_BIT_RATE_DIV - 1U)

#define RSCAN_250K_NTSEG2 ((RSCAN0_250K_T_SEG2 - 1U) << 24U)
#define RSCAN_250K_NTSEG1 ((RSCAN0_250K_T_SEG1 - 1U) << 16U)
#define RSCAN_250K_NSJW   ((RSCAN0_250K_SJW - 1U) << 11U)
#define RSCAN_250K_NBRP   (RSCAN_250K_BIT_RATE_DIV - 1U)

/*RCFDCnCFDCFCCk*/

/*Transmit/Receive FIFO Buffer Depth Configuration*/
#define RSCAN_TR_FIFO_DEPTH_0   (0UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_4   (1UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_8   (2UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_16  (3UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_32  (4UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_48  (5UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_64  (6UL << 21UL)
#define RSCAN_TR_FIFO_DEPTH_128 (7UL << 21UL)
/*Transmit/Receive FIFO Mode Select*/
#define RSCAN_TR_FIFO_MODE_RX (0UL << 8UL)
#define RSCAN_TR_FIFO_MODE_TX (1UL << 8UL)
/*Transmit/Receive FIFO Transmit Interrupt Enable*/
#define RSCAN_TR_FIFO_TX_INT_DIS (0UL << 2UL)
#define RSCAN_TR_FIFO_TX_INT_EN  (1UL << 2UL)
/*Transmit/Receive FIFO Receive Interrupt Enable*/
#define RSCAN_TR_FIFO_RX_INT_DIS (0UL << 1UL)
#define RSCAN_TR_FIFO_RX_INT_EN  (1UL << 1UL)
/*Transmit/Receive FIFO Buffer Enable*/
#define RSCAN_TR_FIFO_DIS (0UL)
#define RSCAN_TR_FIFO_EN  (1UL)

/*RCFDCnCFDCmCTR*/
/*Transmit Abort Interrupt Enable*/
#define RSCAN_ABORT_INT_DIS (0UL << 16U)
#define RSCAN_ABORT_INT_EN  (1UL << 16U)
/*Bus Off Recovery Mode Select*/
#define RSCAN_RECOVER_11898                         (0UL << 21U)
#define RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_ENTRY    (1UL << 21U)
#define RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END      (1UL << 21U)
#define RSCAN_RECOVER_ENTRY_HALT_BY_PROGRAM_REQUEST (1UL << 21U)

typedef struct
{

    /*具体接收内容*/
    CAN_Frame_st_t stReceiveContent;
    /*是否接收到新数据
    0：数据没有更新
    1：接收到新数据，已更新*/
    uint8_t u8CANReceiveStatus;

} CAN_Frame_Receive_st_t;

/*------------------------------------------------------------*/
RSCAN0_Config_st_t g_stRSCAN0Config;
/*------------------------------------------------------------*/

static uint32_t RSCAN0_CH_Baud_Rate_Cal(RSCAN_Channel_Config_st_t *pstRSCANChannelConfig)
{
    uint32_t u32RegisterBuf = 0UL;
    if ( pstRSCANChannelConfig->u32RSCANChEn )
    {
        if ( pstRSCANChannelConfig->enRSCANChBps == RSCAN_Baud_Rate_500K )
        {
            u32RegisterBuf = (RSCAN_500K_NTSEG2 | RSCAN_500K_NTSEG1 | RSCAN_500K_NSJW | RSCAN_500K_NBRP);
        }
        else if ( pstRSCANChannelConfig->enRSCANChBps == RSCAN_Baud_Rate_250K )
        {
            u32RegisterBuf = (RSCAN_250K_NTSEG2 | RSCAN_250K_NTSEG1 | RSCAN_250K_NSJW | RSCAN_250K_NBRP);
        }
    }

    return u32RegisterBuf;
}
/*
返回值：
0：设置失败
1：设置成功
*/
uint8_t RSCAN0_CH_Init(const RSCANFD_Filter_st_t pstRSCANFilter [], RSCAN0_Config_st_t *pstRSCANConfig)
{
    uint32_t i                        = 0UL;
    uint8_t  j                        = 0UL;
    uint32_t u32CANFDCalBuf           = 0UL;
    uint8_t  u8Status                 = 1U;
    uint32_t u32RSCANChannelRuleTotal = 0UL;

    volatile RSCANFD_Filter_st_t *pstCANFDRule;

    if ( pstRSCANConfig->stRSCANCh0.u32RSCANChEn )
    {
        if ( pstRSCANConfig->stRSCANCh0.u32RSCANChRuleSize > 255 )
        {
            u8Status = 0U;
        }
    }
    if ( pstRSCANConfig->stRSCANCh1.u32RSCANChEn )
    {
        if ( pstRSCANConfig->stRSCANCh1.u32RSCANChRuleSize > 255 )
        {
            u8Status = 0U;
        }
    }
    if ( pstRSCANConfig->stRSCANCh2.u32RSCANChEn )
    {
        if ( pstRSCANConfig->stRSCANCh2.u32RSCANChRuleSize > 255 )
        {
            u8Status = 0U;
        }
    }
    if ( pstRSCANConfig->stRSCANCh3.u32RSCANChEn )
    {
        if ( pstRSCANConfig->stRSCANCh3.u32RSCANChRuleSize > 255 )
        {
            u8Status = 0U;
        }
    }
    if ( pstRSCANConfig->stRSCANCh4.u32RSCANChEn )
    {
        if ( pstRSCANConfig->stRSCANCh4.u32RSCANChRuleSize > 255 )
        {
            u8Status = 0U;
        }
    }
    if ( pstRSCANConfig->stRSCANCh5.u32RSCANChEn )
    {
        if ( pstRSCANConfig->stRSCANCh5.u32RSCANChRuleSize > 255 )
        {
            u8Status = 0U;
        }
    }
    if ( u8Status == 1U )
    {
        u32RSCANChannelRuleTotal = pstRSCANConfig->stRSCANCh0.u32RSCANChRuleSize + pstRSCANConfig->stRSCANCh1.u32RSCANChRuleSize + pstRSCANConfig->stRSCANCh2.u32RSCANChRuleSize + pstRSCANConfig->stRSCANCh3.u32RSCANChRuleSize + pstRSCANConfig->stRSCANCh4.u32RSCANChRuleSize + pstRSCANConfig->stRSCANCh5.u32RSCANChRuleSize;
        if ( u32RSCANChannelRuleTotal > 1024 )
        {
            u8Status = 0UL;
        }
    }

    if ( u8Status == 1U )
    {
        /* Waiting for CAN RAM initialization is completed */
        while ( RCFDC0CFDGSTS & 0x08UL )
        {
            ;
        }
        /* Waiting for CAN entry global reset mdoe */
        RCFDC0CFDGCTR &= 0xfffffff9UL;
        RCFDC0CFDGCTR |= 0x01UL;

        while ( (RCFDC0CFDGSTS & 0x07UL) != 0X01UL )
        {
            ;
        }

        /* Waiting for CAN entry channel reset mdoe */
        /*CAN0   CHANNEL 0*/
        if ( pstRSCANConfig->stRSCANCh0.u32RSCANChEn )
        {
            RCFDC0CFDC0CTR &= 0xfffffff9UL;
            RCFDC0CFDC0CTR |= 0x01UL;
        }
        /*CAN0   CHANNEL 1*/
        if ( pstRSCANConfig->stRSCANCh1.u32RSCANChEn )
        {
            RCFDC0CFDC1CTR &= 0xfffffff9UL;
            RCFDC0CFDC1CTR |= 0x01UL;
        }
        if ( pstRSCANConfig->stRSCANCh2.u32RSCANChEn )
        {
            RCFDC0CFDC2CTR &= 0xfffffff9UL;
            RCFDC0CFDC2CTR |= 0x01UL;
        }
        if ( pstRSCANConfig->stRSCANCh3.u32RSCANChEn )
        {
            RCFDC0CFDC3CTR &= 0xfffffff9UL;
            RCFDC0CFDC3CTR |= 0x01UL;
        }
        if ( pstRSCANConfig->stRSCANCh4.u32RSCANChEn )
        {
            RCFDC0CFDC4CTR &= 0xfffffff9UL;
            RCFDC0CFDC4CTR |= 0x01UL;
        }
        if ( pstRSCANConfig->stRSCANCh5.u32RSCANChEn )
        {
            RCFDC0CFDC5CTR &= 0xfffffff9UL;
            RCFDC0CFDC5CTR |= 0x01UL;
        }

        /*  waiting */
        if ( pstRSCANConfig->stRSCANCh0.u32RSCANChEn )
        {
            while ( (RCFDC0CFDC0STS & 0x07UL) != 0X01UL )
            {
                ;
            }
        }
        if ( pstRSCANConfig->stRSCANCh1.u32RSCANChEn )
        {
            while ( (RCFDC0CFDC1STS & 0x07UL) != 0X01UL )
            {
                ;
            }
        }
        if ( pstRSCANConfig->stRSCANCh2.u32RSCANChEn )
        {
            while ( (RCFDC0CFDC2STS & 0x07UL) != 0X01UL )
            {
                ;
            }
        }
        if ( pstRSCANConfig->stRSCANCh3.u32RSCANChEn )
        {
            while ( (RCFDC0CFDC3STS & 0x07UL) != 0X01UL )
            {
                ;
            }
        }
        if ( pstRSCANConfig->stRSCANCh4.u32RSCANChEn )
        {
            while ( (RCFDC0CFDC4STS & 0x07UL) != 0X01UL )
            {
                ;
            }
        }
        if ( pstRSCANConfig->stRSCANCh5.u32RSCANChEn )
        {
            while ( (RCFDC0CFDC5STS & 0x07UL) != 0X01UL )
            {
                ;
            }
        }

        /* Select the channel mode as Classical CAN only mode */
        if ( pstRSCANConfig->stRSCANCh0.u32RSCANChEn )
        {
            RCFDC0CFDC0FDCFG = 0x40000000UL;
        }
        if ( pstRSCANConfig->stRSCANCh1.u32RSCANChEn )
        {
            RCFDC0CFDC1FDCFG = 0x40000000UL;
        }
        if ( pstRSCANConfig->stRSCANCh2.u32RSCANChEn )
        {
            RCFDC0CFDC2FDCFG = 0x40000000UL;
        }
        if ( pstRSCANConfig->stRSCANCh3.u32RSCANChEn )
        {
            RCFDC0CFDC3FDCFG = 0x40000000UL;
        }
        if ( pstRSCANConfig->stRSCANCh4.u32RSCANChEn )
        {
            RCFDC0CFDC4FDCFG = 0x40000000UL;
        }
        if ( pstRSCANConfig->stRSCANCh5.u32RSCANChEn )
        {
            RCFDC0CFDC5FDCFG = 0x40000000UL;
        }

        /* Global Configuration Register*/
        RCFDC0CFDGCFG = (RSCAN_OVERFLOW_NO_STORED | RSCAN_CLOCK_SOURCE_CLKC | RSCAN_TX_PRIORITY_ID);

        /*Channel Nominal Bit Rate Configuration Register*/

        RCFDC0CFDC0NCFG = RSCAN0_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh0));
        RCFDC0CFDC1NCFG = RSCAN0_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh1));
        RCFDC0CFDC2NCFG = RSCAN0_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh2));
        RCFDC0CFDC3NCFG = RSCAN0_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh3));
        RCFDC0CFDC4NCFG = RSCAN0_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh4));
        RCFDC0CFDC5NCFG = RSCAN0_CH_Baud_Rate_Cal(&(pstRSCANConfig->stRSCANCh5));

        /*-------Receive rule setting----*/

        pstCANFDRule = ( volatile RSCANFD_Filter_st_t * )(&(RCFDC0CFDGAFLID0));

        /*Receive Rule Configuration Register */
        RCFDC0CFDGAFLCFG0 = 0UL;
        RCFDC0CFDGAFLCFG1 = 0UL;

        u32CANFDCalBuf = 0UL;

        u32CANFDCalBuf |= ( uint32_t )(pstRSCANConfig->stRSCANCh0.u32RSCANChRuleSize << 24U); /* Channel0 Filter num */
        u32CANFDCalBuf |= ( uint32_t )(pstRSCANConfig->stRSCANCh1.u32RSCANChRuleSize << 16U); /* Channel1 Filter num */
        u32CANFDCalBuf |= ( uint32_t )(pstRSCANConfig->stRSCANCh2.u32RSCANChRuleSize << 8U);  /* Channel2 Filter num */
        u32CANFDCalBuf |= ( uint32_t )(pstRSCANConfig->stRSCANCh3.u32RSCANChRuleSize << 0U);  /* Channel3 Filter num */

        RCFDC0CFDGAFLCFG0 = u32CANFDCalBuf;

        u32CANFDCalBuf = 0UL;
        u32CANFDCalBuf |= ( uint32_t )(pstRSCANConfig->stRSCANCh4.u32RSCANChRuleSize << 24U); /* Channel4 Filter num */
        u32CANFDCalBuf |= ( uint32_t )(pstRSCANConfig->stRSCANCh5.u32RSCANChRuleSize << 16U); /* Channel5 Filter num */
        u32CANFDCalBuf |= ( uint32_t )(0UL << 8U);                                            /* Channel6 Filter num */
        u32CANFDCalBuf |= ( uint32_t )(0UL << 0U);                                            /* Channel7 Filter num */

        RCFDC0CFDGAFLCFG1 = u32CANFDCalBuf;

        /*Receive Rule Entry Control Register*/
        RCFDC0CFDGAFLECTR |= 0x00000100UL; /* Enable receive rule */

        for ( i = 0UL; i < u32RSCANChannelRuleTotal; i++ )
        {
            j = ( uint8_t )(i & 0x0FUL);
            if ( j == 0UL )
            {
                RCFDC0CFDGAFLECTRLL = (i >> 4U); /* Configuration Page  AFLPN[5:0]*/
            }
            pstCANFDRule [ j ] = pstRSCANFilter [ i ];
        }
        /*disable writing data to the receive rule table.*/
        RCFDC0CFDGAFLECTR &= 0xFFFFFEFFUL;

        /*-------Buffer setting----*/
        /*receive buffer*/
        RCFDC0CFDRMNB = 0x00UL; /*no use*/
        /*receive FIFO buffer*/
        RCFDC0CFDRFCC0 = 0x00UL; /*no use*/
        RCFDC0CFDRFCC1 = 0x00UL;
        RCFDC0CFDRFCC2 = 0x00UL;
        RCFDC0CFDRFCC3 = 0x00UL;
        RCFDC0CFDRFCC4 = 0x00UL;
        RCFDC0CFDRFCC5 = 0x00UL;
        RCFDC0CFDRFCC6 = 0x00UL;
        RCFDC0CFDRFCC7 = 0x00UL;

        /*transmit/receive FIFO buffer*/
        if ( pstRSCANConfig->stRSCANCh0.u32RSCANChEn )
        {
            RCFDC0CFDCFCC0 = (RSCAN_TR_FIFO_DEPTH_64 | (0x1FUL << 16UL) | 0X1000UL | RSCAN_TR_FIFO_MODE_TX);

            RCFDC0CFDCFCC1 = (RSCAN_TR_FIFO_DEPTH_48 | (0x1EUL << 16UL) | 0X1000UL | RSCAN_TR_FIFO_MODE_TX);

            RCFDC0CFDCFCC2 = (RSCAN_TR_FIFO_DEPTH_16 | 0X1000UL | RSCAN_TR_FIFO_MODE_RX);
        }
        if ( pstRSCANConfig->stRSCANCh1.u32RSCANChEn )
        {
            RCFDC0CFDCFCC3 = (RSCAN_TR_FIFO_DEPTH_64 | (0x1FUL << 16UL) | 0X1000UL | RSCAN_TR_FIFO_MODE_TX);

            RCFDC0CFDCFCC4 = (RSCAN_TR_FIFO_DEPTH_48 | (0x1EUL << 16UL) | 0X1000UL | RSCAN_TR_FIFO_MODE_TX);

            RCFDC0CFDCFCC5 = (RSCAN_TR_FIFO_DEPTH_16 | 0X1000UL | RSCAN_TR_FIFO_MODE_RX);
        }
        if ( pstRSCANConfig->stRSCANCh2.u32RSCANChEn )
        {
            RCFDC0CFDCFCC6 = (RSCAN_TR_FIFO_DEPTH_64 | (0x1FUL << 16UL) | 0X1000UL | RSCAN_TR_FIFO_MODE_TX);

            RCFDC0CFDCFCC7 = (RSCAN_TR_FIFO_DEPTH_48 | (0x1EUL << 16UL) | 0X1000UL | RSCAN_TR_FIFO_MODE_TX);

            RCFDC0CFDCFCC8 = (RSCAN_TR_FIFO_DEPTH_16 | 0X1000UL | RSCAN_TR_FIFO_MODE_RX);
        }
        if ( pstRSCANConfig->stRSCANCh3.u32RSCANChEn )
        {
            RCFDC0CFDCFCC9 = (RSCAN_TR_FIFO_DEPTH_64 | (0x1FUL << 16UL) | 0X1000UL | RSCAN_TR_FIFO_MODE_TX);

            RCFDC0CFDCFCC10 = (RSCAN_TR_FIFO_DEPTH_48 | (0x1EUL << 16UL) | 0X1000UL | RSCAN_TR_FIFO_MODE_TX);

            RCFDC0CFDCFCC11 = (RSCAN_TR_FIFO_DEPTH_16 | 0X1000UL | RSCAN_TR_FIFO_MODE_RX);
        }
        if ( pstRSCANConfig->stRSCANCh4.u32RSCANChEn )
        {
            RCFDC0CFDCFCC12 = (RSCAN_TR_FIFO_DEPTH_64 | (0x1FUL << 16UL) | 0X1000UL | RSCAN_TR_FIFO_MODE_TX);

            RCFDC0CFDCFCC13 = (RSCAN_TR_FIFO_DEPTH_48 | (0x1EUL << 16UL) | 0X1000UL | RSCAN_TR_FIFO_MODE_TX);

            RCFDC0CFDCFCC14 = (RSCAN_TR_FIFO_DEPTH_16 | 0X1000UL | RSCAN_TR_FIFO_MODE_RX);
        }
        if ( pstRSCANConfig->stRSCANCh5.u32RSCANChEn )
        {
            RCFDC0CFDCFCC15 = (RSCAN_TR_FIFO_DEPTH_64 | (0x1FUL << 16UL) | 0X1000UL | RSCAN_TR_FIFO_MODE_TX);

            RCFDC0CFDCFCC16 = (RSCAN_TR_FIFO_DEPTH_48 | (0x1EUL << 16UL) | 0X1000UL | RSCAN_TR_FIFO_MODE_TX);

            RCFDC0CFDCFCC17 = (RSCAN_TR_FIFO_DEPTH_16 | 0X1000UL | RSCAN_TR_FIFO_MODE_RX);
        }

        /* transmit queue*/
        RCFDC0CFDTXQCC0 = 0UL; /*no use*/
        RCFDC0CFDTXQCC1 = 0UL;
        RCFDC0CFDTXQCC2 = 0UL;
        RCFDC0CFDTXQCC3 = 0UL;
        RCFDC0CFDTXQCC4 = 0UL;
        RCFDC0CFDTXQCC5 = 0UL;
        RCFDC0CFDTXQCC6 = 0UL;
        RCFDC0CFDTXQCC7 = 0UL;

        /*transmit history buffer*/
        RCFDC0CFDTHLCC0 = 0UL; /*no use*/
        RCFDC0CFDTHLCC1 = 0UL;
        RCFDC0CFDTHLCC2 = 0UL;
        RCFDC0CFDTHLCC3 = 0UL;
        RCFDC0CFDTHLCC4 = 0UL;
        RCFDC0CFDTHLCC5 = 0UL;

        /*Enable interrupt of buffer to be used*/
        /*transmit/receive FIFO */
        if ( pstRSCANConfig->stRSCANCh0.u32RSCANChEn )
        {
            RCFDC0CFDCFCC0 |= RSCAN_TR_FIFO_TX_INT_EN;
            RCFDC0CFDCFCC1 |= RSCAN_TR_FIFO_TX_INT_EN;
            RCFDC0CFDCFCC2 |= RSCAN_TR_FIFO_RX_INT_EN;
        }
        if ( pstRSCANConfig->stRSCANCh1.u32RSCANChEn )
        {
            RCFDC0CFDCFCC3 |= RSCAN_TR_FIFO_TX_INT_EN;
            RCFDC0CFDCFCC4 |= RSCAN_TR_FIFO_TX_INT_EN;
            RCFDC0CFDCFCC5 |= RSCAN_TR_FIFO_RX_INT_EN;
        }
        if ( pstRSCANConfig->stRSCANCh2.u32RSCANChEn )
        {
            RCFDC0CFDCFCC6 |= RSCAN_TR_FIFO_TX_INT_EN;
            RCFDC0CFDCFCC7 |= RSCAN_TR_FIFO_TX_INT_EN;
            RCFDC0CFDCFCC8 |= RSCAN_TR_FIFO_RX_INT_EN;
        }
        if ( pstRSCANConfig->stRSCANCh3.u32RSCANChEn )
        {
            RCFDC0CFDCFCC9 |= RSCAN_TR_FIFO_TX_INT_EN;
            RCFDC0CFDCFCC10 |= RSCAN_TR_FIFO_TX_INT_EN;
            RCFDC0CFDCFCC11 |= RSCAN_TR_FIFO_RX_INT_EN;
        }
        if ( pstRSCANConfig->stRSCANCh4.u32RSCANChEn )
        {
            RCFDC0CFDCFCC12 |= RSCAN_TR_FIFO_TX_INT_EN;
            RCFDC0CFDCFCC13 |= RSCAN_TR_FIFO_TX_INT_EN;
            RCFDC0CFDCFCC14 |= RSCAN_TR_FIFO_RX_INT_EN;
        }
        if ( pstRSCANConfig->stRSCANCh5.u32RSCANChEn )
        {
            RCFDC0CFDCFCC15 |= RSCAN_TR_FIFO_TX_INT_EN;
            RCFDC0CFDCFCC16 |= RSCAN_TR_FIFO_TX_INT_EN;
            RCFDC0CFDCFCC17 |= RSCAN_TR_FIFO_RX_INT_EN;
        }
        /** transmit abort interrupts**/
        if ( pstRSCANConfig->stRSCANCh0.u32RSCANChEn )
        {
            RCFDC0CFDC0CTR |= RSCAN_ABORT_INT_EN;
        }
        if ( pstRSCANConfig->stRSCANCh1.u32RSCANChEn )
        {
            RCFDC0CFDC1CTR |= RSCAN_ABORT_INT_EN;
        }
        if ( pstRSCANConfig->stRSCANCh2.u32RSCANChEn )
        {
            RCFDC0CFDC2CTR |= RSCAN_ABORT_INT_EN;
        }
        if ( pstRSCANConfig->stRSCANCh3.u32RSCANChEn )
        {
            RCFDC0CFDC3CTR |= RSCAN_ABORT_INT_EN;
        }
        if ( pstRSCANConfig->stRSCANCh4.u32RSCANChEn )
        {
            RCFDC0CFDC4CTR |= RSCAN_ABORT_INT_EN;
        }
        if ( pstRSCANConfig->stRSCANCh5.u32RSCANChEn )
        {
            RCFDC0CFDC5CTR |= RSCAN_ABORT_INT_EN;
        }

        /* transmit complete interrupts */
        if ( pstRSCANConfig->stRSCANCh0.u32RSCANChEn )
        {
            RCFDC0CFDTMIEC0 = 0xFFFFFFFFUL;
        }
        if ( pstRSCANConfig->stRSCANCh1.u32RSCANChEn )
        {
            RCFDC0CFDTMIEC1 = 0xFFFFFFFFUL;
        }
        if ( pstRSCANConfig->stRSCANCh2.u32RSCANChEn )
        {
            RCFDC0CFDTMIEC2 = 0xFFFFFFFFUL;
        }
        if ( pstRSCANConfig->stRSCANCh3.u32RSCANChEn )
        {
            RCFDC0CFDTMIEC3 = 0xFFFFFFFFUL;
        }
        if ( pstRSCANConfig->stRSCANCh4.u32RSCANChEn )
        {
            RCFDC0CFDTMIEC4 = 0xFFFFFFFFUL;
        }
        if ( pstRSCANConfig->stRSCANCh5.u32RSCANChEn )
        {
            RCFDC0CFDTMIEC5 = 0xFFFFFFFFUL;
        }

        /*Global interrupt*/
        /*	RCFDC0CFDGCTR = 0UL;*/

        /*Channel interrupt, bus off recovery, error indication*/
        if ( pstRSCANConfig->stRSCANCh0.u32RSCANChEn )
        {
            RCFDC0CFDC0CTR |= RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END;
        }
        if ( pstRSCANConfig->stRSCANCh1.u32RSCANChEn )
        {
            RCFDC0CFDC1CTR |= RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END;
        }
        if ( pstRSCANConfig->stRSCANCh2.u32RSCANChEn )
        {
            RCFDC0CFDC2CTR |= RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END;
        }
        if ( pstRSCANConfig->stRSCANCh3.u32RSCANChEn )
        {
            RCFDC0CFDC3CTR |= RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END;
        }
        if ( pstRSCANConfig->stRSCANCh4.u32RSCANChEn )
        {
            RCFDC0CFDC4CTR |= RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END;
        }
        if ( pstRSCANConfig->stRSCANCh5.u32RSCANChEn )
        {
            RCFDC0CFDC5CTR |= RSCAN_RECOVER_ENTRY_HALT_AT_BUSOFF_END;
        }

        /*Gateway, transmitter delay compensation, error state display, error occurrence counter*/

        RCFDC0CFDC0FDCFG = 0UL;
        RCFDC0CFDC1FDCFG = 0UL;
        RCFDC0CFDC2FDCFG = 0UL;
        RCFDC0CFDC3FDCFG = 0UL;
        RCFDC0CFDC4FDCFG = 0UL;
        RCFDC0CFDC5FDCFG = 0UL;

        /*Interrupt control register of interrupt controller*/

        //INTC1ICRCANGRECC0 = 0X4FUL;
        if ( pstRSCANConfig->stRSCANCh0.u32RSCANChEn )
        {
            peripheral_IRQ_enable(INTRCAN0REC);
            peripheral_IRQ_enable(INTRCAN0TRX);
        }
        if ( pstRSCANConfig->stRSCANCh1.u32RSCANChEn )
        {
            peripheral_IRQ_enable(INTRCAN1REC);
            peripheral_IRQ_enable(INTRCAN1TRX);
        }
        if ( pstRSCANConfig->stRSCANCh2.u32RSCANChEn )
        {
            peripheral_IRQ_enable(INTRCAN2REC);
            peripheral_IRQ_enable(INTRCAN2TRX);
        }
        if ( pstRSCANConfig->stRSCANCh3.u32RSCANChEn )
        {
            peripheral_IRQ_enable(INTRCAN3REC);
            peripheral_IRQ_enable(INTRCAN3TRX);
        }
        if ( pstRSCANConfig->stRSCANCh4.u32RSCANChEn )
        {
            peripheral_IRQ_enable(INTRCAN4REC);
            peripheral_IRQ_enable(INTRCAN4TRX);
        }
        if ( pstRSCANConfig->stRSCANCh5.u32RSCANChEn )
        {
            peripheral_IRQ_enable(INTRCAN5REC);
            peripheral_IRQ_enable(INTRCAN5TRX);
        }

        /*Transition to global operating mode*/
        RCFDC0CFDGCTR &= 0xFFFFFFFCUL;
        while ( (RCFDC0CFDGSTS & 0x07UL) != 0X00UL )
        {
            ;
        }

        /*Transition to channel communication mode*/
        if ( pstRSCANConfig->stRSCANCh0.u32RSCANChEn )
        {
            RCFDC0CFDC0CTR &= 0xFFFFFFFCUL;
        }
        if ( pstRSCANConfig->stRSCANCh1.u32RSCANChEn )
        {
            RCFDC0CFDC1CTR &= 0xFFFFFFFCUL;
        }
        if ( pstRSCANConfig->stRSCANCh2.u32RSCANChEn )
        {
            RCFDC0CFDC2CTR &= 0xFFFFFFFCUL;
        }
        if ( pstRSCANConfig->stRSCANCh3.u32RSCANChEn )
        {
            RCFDC0CFDC3CTR &= 0xFFFFFFFCUL;
        }
        if ( pstRSCANConfig->stRSCANCh4.u32RSCANChEn )
        {
            RCFDC0CFDC4CTR &= 0xFFFFFFFCUL;
        }
        if ( pstRSCANConfig->stRSCANCh5.u32RSCANChEn )
        {
            RCFDC0CFDC5CTR &= 0xFFFFFFFCUL;
        }

        if ( pstRSCANConfig->stRSCANCh0.u32RSCANChEn )
        {
            while ( (RCFDC0CFDC0STS & 0x80UL) == 0x0UL )
            {
            }
        }
        if ( pstRSCANConfig->stRSCANCh1.u32RSCANChEn )
        {
            while ( (RCFDC0CFDC1STS & 0x80UL) == 0x0UL )
            {
            }
        }
        if ( pstRSCANConfig->stRSCANCh2.u32RSCANChEn )
        {
            while ( (RCFDC0CFDC2STS & 0x80UL) == 0x0UL )
            {
            }
        }
        if ( pstRSCANConfig->stRSCANCh3.u32RSCANChEn )
        {
            while ( (RCFDC0CFDC3STS & 0x80UL) == 0x0UL )
            {
            }
        }
        if ( pstRSCANConfig->stRSCANCh4.u32RSCANChEn )
        {
            while ( (RCFDC0CFDC4STS & 0x80UL) == 0x0UL )
            {
            }
        }
        if ( pstRSCANConfig->stRSCANCh5.u32RSCANChEn )
        {
            while ( (RCFDC0CFDC5STS & 0x80UL) == 0x0UL )
            {
            }
        }

        /*Enable the applied receive FIFO buffer, transmit/receive
		FIFO, transmit queue or transmit history buffer*/

        /*transmit/receive FIFO */
        if ( pstRSCANConfig->stRSCANCh0.u32RSCANChEn )
        {
            RCFDC0CFDCFCC0 |= RSCAN_TR_FIFO_EN;
            RCFDC0CFDCFCC1 |= RSCAN_TR_FIFO_EN;
            RCFDC0CFDCFCC2 |= RSCAN_TR_FIFO_EN;
        }
        if ( pstRSCANConfig->stRSCANCh1.u32RSCANChEn )
        {
            RCFDC0CFDCFCC3 |= RSCAN_TR_FIFO_EN;
            RCFDC0CFDCFCC4 |= RSCAN_TR_FIFO_EN;
            RCFDC0CFDCFCC5 |= RSCAN_TR_FIFO_EN;
        }
        if ( pstRSCANConfig->stRSCANCh2.u32RSCANChEn )
        {
            RCFDC0CFDCFCC6 |= RSCAN_TR_FIFO_EN;
            RCFDC0CFDCFCC7 |= RSCAN_TR_FIFO_EN;
            RCFDC0CFDCFCC8 |= RSCAN_TR_FIFO_EN;
        }
        if ( pstRSCANConfig->stRSCANCh3.u32RSCANChEn )
        {
            RCFDC0CFDCFCC9 |= RSCAN_TR_FIFO_EN;
            RCFDC0CFDCFCC10 |= RSCAN_TR_FIFO_EN;
            RCFDC0CFDCFCC11 |= RSCAN_TR_FIFO_EN;
        }
        if ( pstRSCANConfig->stRSCANCh4.u32RSCANChEn )
        {
            RCFDC0CFDCFCC12 |= RSCAN_TR_FIFO_EN;
            RCFDC0CFDCFCC13 |= RSCAN_TR_FIFO_EN;
            RCFDC0CFDCFCC14 |= RSCAN_TR_FIFO_EN;
        }
        if ( pstRSCANConfig->stRSCANCh5.u32RSCANChEn )
        {
            RCFDC0CFDCFCC15 |= RSCAN_TR_FIFO_EN;
            RCFDC0CFDCFCC16 |= RSCAN_TR_FIFO_EN;
            RCFDC0CFDCFCC17 |= RSCAN_TR_FIFO_EN;
        }

        g_stRSCAN0Config = *pstRSCANConfig;
    }
    return u8Status;
}

void RSCAN0_CH0_Receive(CAN_Frame_st_t *pstCANFrame)
{
    if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANReadMsgCallBack )
    {
        g_stRSCAN0Config.stRSCANCh0.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
    }
}
void RSCAN0_CH1_Receive(CAN_Frame_st_t *pstCANFrame)
{
    if ( g_stRSCAN0Config.stRSCANCh1.pfnRSCANReadMsgCallBack )
    {
        g_stRSCAN0Config.stRSCANCh1.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
    }
}
void RSCAN0_CH2_Receive(CAN_Frame_st_t *pstCANFrame)
{
    if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANReadMsgCallBack )
    {
        g_stRSCAN0Config.stRSCANCh2.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
    }
}
void RSCAN0_CH3_Receive(CAN_Frame_st_t *pstCANFrame)
{
    if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANReadMsgCallBack )
    {
        g_stRSCAN0Config.stRSCANCh3.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
    }
}
void RSCAN0_CH4_Receive(CAN_Frame_st_t *pstCANFrame)
{
    if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANReadMsgCallBack )
    {
        g_stRSCAN0Config.stRSCANCh4.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
    }
}
void RSCAN0_CH5_Receive(CAN_Frame_st_t *pstCANFrame)
{
    if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANReadMsgCallBack )
    {
        g_stRSCAN0Config.stRSCANCh5.pfnRSCANReadMsgCallBack(pstCANFrame->u32CANID, pstCANFrame->u8CANLEN, pstCANFrame->unCANData.u8CANData);
    }
}

/**********************************************************/
RSCAN_SetState RSCAN0_CH0_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame)
{
    uint32_t u32RSCANDataBuf   = 0UL;
    uint32_t u32RSCANBufIndexK = (0UL + 3UL * 0UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (pstCANFrame->u8CANLEN > 8U) || (pstCANFrame == 0UL) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexK * 4UL + 0X178UL + RSCAN0_BASE_ADDRESS;

        if ( ((*(( uint32_t * )(u32RSCANAddress))) & 0x00000002UL) == 0x0U )
        //if ((RCFDC0CFDCFSTS3 & 0x00000002UL) == 0x0U)
        {

            u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
            u32RSCANDataBuf = u32RSCANDataBuf << 31U;
            u32RSCANDataBuf |= pstCANFrame->u32CANID;

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6400UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = u32RSCANDataBuf;
            //RCFDC0CFDCFID3 = u32RSCANDataBuf;

            u32RSCANDataBuf                      = pstCANFrame->u8CANLEN;
            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6404UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = ((u32RSCANDataBuf) << 28U);
            //RCFDC0CFDCFPTR3 = ((u32RSCANDataBuf) << 28U);

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6408UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = 0UL;
            //RCFDC0CFDCFFDCSTS3 = 0UL;

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X640CUL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData [ 0U ];
            //RCFDC0CFDCFDF0_3 = pstCANFrame->unCANData.u32CANData[0U];
            u32RSCANAddress += 0X04UL;
            (*(( uint32_t * )(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData [ 1U ];
            //RCFDC0CFDCFDF1_3 = pstCANFrame->unCANData.u32CANData[1U];

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x4UL + 0X1D8UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = 0XFFUL;
            //RCFDC0CFDCFPCTR3 = 0XFFUL;

            enRSCANStatus = RSCAN_SET_COMPLETE;
        }
        else
        {
            enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
        }
    }

    return enRSCANStatus;
}
RSCAN_SetState RSCAN0_CH1_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame)
{
    uint32_t u32RSCANDataBuf   = 0UL;
    uint32_t u32RSCANBufIndexK = (0UL + 3UL * 1UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (pstCANFrame->u8CANLEN > 8U) || (pstCANFrame == 0UL) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexK * 4UL + 0X178UL + RSCAN0_BASE_ADDRESS;

        if ( ((*(( uint32_t * )(u32RSCANAddress))) & 0x00000002UL) == 0x0U )
        //if ((RCFDC0CFDCFSTS3 & 0x00000002UL) == 0x0U)
        {

            u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
            u32RSCANDataBuf = u32RSCANDataBuf << 31U;
            u32RSCANDataBuf |= pstCANFrame->u32CANID;

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6400UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = u32RSCANDataBuf;
            //RCFDC0CFDCFID3 = u32RSCANDataBuf;

            u32RSCANDataBuf                      = pstCANFrame->u8CANLEN;
            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6404UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = ((u32RSCANDataBuf) << 28U);
            //RCFDC0CFDCFPTR3 = ((u32RSCANDataBuf) << 28U);

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6408UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = 0UL;
            //RCFDC0CFDCFFDCSTS3 = 0UL;

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X640CUL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData [ 0U ];
            //RCFDC0CFDCFDF0_3 = pstCANFrame->unCANData.u32CANData[0U];
            u32RSCANAddress += 0X04UL;
            (*(( uint32_t * )(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData [ 1U ];
            //RCFDC0CFDCFDF1_3 = pstCANFrame->unCANData.u32CANData[1U];

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x4UL + 0X1D8UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = 0XFFUL;
            //RCFDC0CFDCFPCTR3 = 0XFFUL;

            enRSCANStatus = RSCAN_SET_COMPLETE;
        }
        else
        {
            enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
        }
    }

    return enRSCANStatus;
}
RSCAN_SetState RSCAN0_CH2_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame)
{
    uint32_t u32RSCANDataBuf   = 0UL;
    uint32_t u32RSCANBufIndexK = (0UL + 3UL * 2UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (pstCANFrame->u8CANLEN > 8U) || (pstCANFrame == 0UL) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexK * 4UL + 0X178UL + RSCAN0_BASE_ADDRESS;

        if ( ((*(( uint32_t * )(u32RSCANAddress))) & 0x00000002UL) == 0x0U )
        //if ((RCFDC0CFDCFSTS3 & 0x00000002UL) == 0x0U)
        {

            u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
            u32RSCANDataBuf = u32RSCANDataBuf << 31U;
            u32RSCANDataBuf |= pstCANFrame->u32CANID;

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6400UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = u32RSCANDataBuf;
            //RCFDC0CFDCFID3 = u32RSCANDataBuf;

            u32RSCANDataBuf                      = pstCANFrame->u8CANLEN;
            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6404UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = ((u32RSCANDataBuf) << 28U);
            //RCFDC0CFDCFPTR3 = ((u32RSCANDataBuf) << 28U);

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6408UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = 0UL;
            //RCFDC0CFDCFFDCSTS3 = 0UL;

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X640CUL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData [ 0U ];
            //RCFDC0CFDCFDF0_3 = pstCANFrame->unCANData.u32CANData[0U];
            u32RSCANAddress += 0X04UL;
            (*(( uint32_t * )(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData [ 1U ];
            //RCFDC0CFDCFDF1_3 = pstCANFrame->unCANData.u32CANData[1U];

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x4UL + 0X1D8UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = 0XFFUL;
            //RCFDC0CFDCFPCTR3 = 0XFFUL;

            enRSCANStatus = RSCAN_SET_COMPLETE;
        }
        else
        {
            enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
        }
    }

    return enRSCANStatus;
}
RSCAN_SetState RSCAN0_CH3_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame)
{
    uint32_t u32RSCANDataBuf   = 0UL;
    uint32_t u32RSCANBufIndexK = (0UL + 3UL * 3UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (pstCANFrame->u8CANLEN > 8U) || (pstCANFrame == 0UL) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexK * 4UL + 0X178UL + RSCAN0_BASE_ADDRESS;

        if ( ((*(( uint32_t * )(u32RSCANAddress))) & 0x00000002UL) == 0x0U )
        //if ((RCFDC0CFDCFSTS3 & 0x00000002UL) == 0x0U)
        {

            u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
            u32RSCANDataBuf = u32RSCANDataBuf << 31U;
            u32RSCANDataBuf |= pstCANFrame->u32CANID;

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6400UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = u32RSCANDataBuf;
            //RCFDC0CFDCFID3 = u32RSCANDataBuf;

            u32RSCANDataBuf                      = pstCANFrame->u8CANLEN;
            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6404UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = ((u32RSCANDataBuf) << 28U);
            //RCFDC0CFDCFPTR3 = ((u32RSCANDataBuf) << 28U);

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6408UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = 0UL;
            //RCFDC0CFDCFFDCSTS3 = 0UL;

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X640CUL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData [ 0U ];
            //RCFDC0CFDCFDF0_3 = pstCANFrame->unCANData.u32CANData[0U];
            u32RSCANAddress += 0X04UL;
            (*(( uint32_t * )(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData [ 1U ];
            //RCFDC0CFDCFDF1_3 = pstCANFrame->unCANData.u32CANData[1U];

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x4UL + 0X1D8UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = 0XFFUL;
            //RCFDC0CFDCFPCTR3 = 0XFFUL;

            enRSCANStatus = RSCAN_SET_COMPLETE;
        }
        else
        {
            enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
        }
    }

    return enRSCANStatus;
}
RSCAN_SetState RSCAN0_CH4_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame)
{
    uint32_t u32RSCANDataBuf   = 0UL;
    uint32_t u32RSCANBufIndexK = (0UL + 3UL * 4UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (pstCANFrame->u8CANLEN > 8U) || (pstCANFrame == 0UL) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexK * 4UL + 0X178UL + RSCAN0_BASE_ADDRESS;

        if ( ((*(( uint32_t * )(u32RSCANAddress))) & 0x00000002UL) == 0x0U )
        //if ((RCFDC0CFDCFSTS3 & 0x00000002UL) == 0x0U)
        {

            u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
            u32RSCANDataBuf = u32RSCANDataBuf << 31U;
            u32RSCANDataBuf |= pstCANFrame->u32CANID;

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6400UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = u32RSCANDataBuf;
            //RCFDC0CFDCFID3 = u32RSCANDataBuf;

            u32RSCANDataBuf                      = pstCANFrame->u8CANLEN;
            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6404UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = ((u32RSCANDataBuf) << 28U);
            //RCFDC0CFDCFPTR3 = ((u32RSCANDataBuf) << 28U);

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6408UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = 0UL;
            //RCFDC0CFDCFFDCSTS3 = 0UL;

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X640CUL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData [ 0U ];
            //RCFDC0CFDCFDF0_3 = pstCANFrame->unCANData.u32CANData[0U];
            u32RSCANAddress += 0X04UL;
            (*(( uint32_t * )(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData [ 1U ];
            //RCFDC0CFDCFDF1_3 = pstCANFrame->unCANData.u32CANData[1U];

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x4UL + 0X1D8UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = 0XFFUL;
            //RCFDC0CFDCFPCTR3 = 0XFFUL;

            enRSCANStatus = RSCAN_SET_COMPLETE;
        }
        else
        {
            enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
        }
    }

    return enRSCANStatus;
}
RSCAN_SetState RSCAN0_CH5_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame)
{
    uint32_t u32RSCANDataBuf   = 0UL;
    uint32_t u32RSCANBufIndexK = (0UL + 3UL * 5UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (pstCANFrame->u8CANLEN > 8U) || (pstCANFrame == 0UL) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexK * 4UL + 0X178UL + RSCAN0_BASE_ADDRESS;

        if ( ((*(( uint32_t * )(u32RSCANAddress))) & 0x00000002UL) == 0x0U )
        //if ((RCFDC0CFDCFSTS3 & 0x00000002UL) == 0x0U)
        {

            u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
            u32RSCANDataBuf = u32RSCANDataBuf << 31U;
            u32RSCANDataBuf |= pstCANFrame->u32CANID;

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6400UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = u32RSCANDataBuf;
            //RCFDC0CFDCFID3 = u32RSCANDataBuf;

            u32RSCANDataBuf                      = pstCANFrame->u8CANLEN;
            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6404UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = ((u32RSCANDataBuf) << 28U);
            //RCFDC0CFDCFPTR3 = ((u32RSCANDataBuf) << 28U);

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X6408UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = 0UL;
            //RCFDC0CFDCFFDCSTS3 = 0UL;

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x80UL + 0X640CUL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData [ 0U ];
            //RCFDC0CFDCFDF0_3 = pstCANFrame->unCANData.u32CANData[0U];
            u32RSCANAddress += 0X04UL;
            (*(( uint32_t * )(u32RSCANAddress))) = pstCANFrame->unCANData.u32CANData [ 1U ];
            //RCFDC0CFDCFDF1_3 = pstCANFrame->unCANData.u32CANData[1U];

            u32RSCANAddress                      = u32RSCANBufIndexK * 0x4UL + 0X1D8UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )(u32RSCANAddress))) = 0XFFUL;
            //RCFDC0CFDCFPCTR3 = 0XFFUL;

            enRSCANStatus = RSCAN_SET_COMPLETE;
        }
        else
        {
            enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
        }
    }

    return enRSCANStatus;
}

/*********************************************************/
RSCAN_SetState RSCAN0_CH0_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame)
{
    uint8_t  i;
    uint32_t u32RSCANDataBuf   = 0UL;
    uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 0UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (pstCANFrame->u8CANLEN > 8U) || (pstCANFrame == 0UL) || (pstCANFrame->u8CANFrameIDE > 1U) || (enBufIndex >= RSCAN_CHANNEL_BUF_MAX) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexP + 0X350UL + RSCAN0_BASE_ADDRESS;
        if ( ((*(( uint8_t * )u32RSCANAddress)) & 0x08U) == 0x0U )
        //if ((RCFDC0CFDTMSTS0 & 0x08U) == 0x0U)
        {
            (*(( uint8_t * )u32RSCANAddress)) = 0UL;
            //RCFDC0CFDTMSTS0 = 0UL;
            u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
            u32RSCANDataBuf = u32RSCANDataBuf << 31U;
            u32RSCANDataBuf |= pstCANFrame->u32CANID;

            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8000UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = u32RSCANDataBuf;
            //RCFDC0CFDTMID0 = u32RSCANDataBuf;

            u32RSCANDataBuf                    = pstCANFrame->u8CANLEN;
            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8004UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = ( uint32_t )((u32RSCANDataBuf) << 28U);
            //RCFDC0CFDTMPTR0 = (uint32_t)((u32RSCANDataBuf) << 28U);

            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8008UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = 0UL;
            //RCFDC0CFDTMFDCTR0 = 0UL;

            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X800CUL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData [ 0U ];
            //RCFDC0CFDTMDF0_0 = pstCANFrame->unCANData.u32CANData[0U];
            u32RSCANAddress += 0X04UL;
            (*(( uint32_t * )u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData [ 1U ];
            //RCFDC0CFDTMDF1_0 = pstCANFrame->unCANData.u32CANData[1U];

            u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
            (*(( uint8_t * )u32RSCANAddress)) |= 0X01;
            //RCFDC0CFDTMC0 |= 0X01;

            enRSCANStatus = RSCAN_SET_COMPLETE;
        }
        else
        {
            enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
        }
    }
    return enRSCANStatus;
}
RSCAN_SetState RSCAN0_CH1_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame)
{
    uint8_t  i;
    uint32_t u32RSCANDataBuf   = 0UL;
    uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 1UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (pstCANFrame->u8CANLEN > 8U) || (pstCANFrame == 0UL) || (pstCANFrame->u8CANFrameIDE > 1U) || (enBufIndex >= RSCAN_CHANNEL_BUF_MAX) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexP + 0X350UL + RSCAN0_BASE_ADDRESS;
        if ( ((*(( uint8_t * )u32RSCANAddress)) & 0x08U) == 0x0U )
        //if ((RCFDC0CFDTMSTS0 & 0x08U) == 0x0U)
        {
            (*(( uint8_t * )u32RSCANAddress)) = 0UL;
            //RCFDC0CFDTMSTS0 = 0UL;
            u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
            u32RSCANDataBuf = u32RSCANDataBuf << 31U;
            u32RSCANDataBuf |= pstCANFrame->u32CANID;

            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8000UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = u32RSCANDataBuf;
            //RCFDC0CFDTMID0 = u32RSCANDataBuf;

            u32RSCANDataBuf                    = pstCANFrame->u8CANLEN;
            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8004UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = ( uint32_t )((u32RSCANDataBuf) << 28U);
            //RCFDC0CFDTMPTR0 = (uint32_t)((u32RSCANDataBuf) << 28U);

            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8008UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = 0UL;
            //RCFDC0CFDTMFDCTR0 = 0UL;
            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X800CUL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData [ 0U ];
            //RCFDC0CFDTMDF0_0 = pstCANFrame->unCANData.u32CANData[0U];
            u32RSCANAddress += 0X04UL;
            (*(( uint32_t * )u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData [ 1U ];
            //RCFDC0CFDTMDF1_0 = pstCANFrame->unCANData.u32CANData[1U];

            u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
            (*(( uint8_t * )u32RSCANAddress)) |= 0X01;
            //RCFDC0CFDTMC0 |= 0X01;

            enRSCANStatus = RSCAN_SET_COMPLETE;
        }
        else
        {
            enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
        }
    }
    return enRSCANStatus;
}
RSCAN_SetState RSCAN0_CH2_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame)
{
    uint8_t  i;
    uint32_t u32RSCANDataBuf   = 0UL;
    uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 2UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (pstCANFrame->u8CANLEN > 8U) || (pstCANFrame == 0UL) || (pstCANFrame->u8CANFrameIDE > 1U) || (enBufIndex >= RSCAN_CHANNEL_BUF_MAX) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexP + 0X350UL + RSCAN0_BASE_ADDRESS;
        if ( ((*(( uint8_t * )u32RSCANAddress)) & 0x08U) == 0x0U )
        //if ((RCFDC0CFDTMSTS0 & 0x08U) == 0x0U)
        {
            (*(( uint8_t * )u32RSCANAddress)) = 0UL;
            //RCFDC0CFDTMSTS0 = 0UL;
            u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
            u32RSCANDataBuf = u32RSCANDataBuf << 31U;
            u32RSCANDataBuf |= pstCANFrame->u32CANID;

            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8000UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = u32RSCANDataBuf;
            //RCFDC0CFDTMID0 = u32RSCANDataBuf;

            u32RSCANDataBuf                    = pstCANFrame->u8CANLEN;
            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8004UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = ( uint32_t )((u32RSCANDataBuf) << 28U);
            //RCFDC0CFDTMPTR0 = (uint32_t)((u32RSCANDataBuf) << 28U);

            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8008UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = 0UL;
            //RCFDC0CFDTMFDCTR0 = 0UL;
            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X800CUL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData [ 0U ];
            //RCFDC0CFDTMDF0_0 = pstCANFrame->unCANData.u32CANData[0U];
            u32RSCANAddress += 0X04UL;
            (*(( uint32_t * )u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData [ 1U ];
            //RCFDC0CFDTMDF1_0 = pstCANFrame->unCANData.u32CANData[1U];

            u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
            (*(( uint8_t * )u32RSCANAddress)) |= 0X01;
            //RCFDC0CFDTMC0 |= 0X01;

            enRSCANStatus = RSCAN_SET_COMPLETE;
        }
        else
        {
            enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
        }
    }
    return enRSCANStatus;
}
RSCAN_SetState RSCAN0_CH3_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame)
{
    uint8_t  i;
    uint32_t u32RSCANDataBuf   = 0UL;
    uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 3UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (pstCANFrame->u8CANLEN > 8U) || (pstCANFrame == 0UL) || (pstCANFrame->u8CANFrameIDE > 1U) || (enBufIndex >= RSCAN_CHANNEL_BUF_MAX) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexP + 0X350UL + RSCAN0_BASE_ADDRESS;
        if ( ((*(( uint8_t * )u32RSCANAddress)) & 0x08U) == 0x0U )
        //if ((RCFDC0CFDTMSTS0 & 0x08U) == 0x0U)
        {
            (*(( uint8_t * )u32RSCANAddress)) = 0UL;
            //RCFDC0CFDTMSTS0 = 0UL;
            u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
            u32RSCANDataBuf = u32RSCANDataBuf << 31U;
            u32RSCANDataBuf |= pstCANFrame->u32CANID;

            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8000UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = u32RSCANDataBuf;
            //RCFDC0CFDTMID0 = u32RSCANDataBuf;

            u32RSCANDataBuf                    = pstCANFrame->u8CANLEN;
            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8004UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = ( uint32_t )((u32RSCANDataBuf) << 28U);
            //RCFDC0CFDTMPTR0 = (uint32_t)((u32RSCANDataBuf) << 28U);

            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8008UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = 0UL;
            //RCFDC0CFDTMFDCTR0 = 0UL;
            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X800CUL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData [ 0U ];
            //RCFDC0CFDTMDF0_0 = pstCANFrame->unCANData.u32CANData[0U];
            u32RSCANAddress += 0X04UL;
            (*(( uint32_t * )u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData [ 1U ];
            //RCFDC0CFDTMDF1_0 = pstCANFrame->unCANData.u32CANData[1U];

            u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
            (*(( uint8_t * )u32RSCANAddress)) |= 0X01;
            //RCFDC0CFDTMC0 |= 0X01;

            enRSCANStatus = RSCAN_SET_COMPLETE;
        }
        else
        {
            enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
        }
    }
    return enRSCANStatus;
}
RSCAN_SetState RSCAN0_CH4_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame)
{
    uint8_t  i;
    uint32_t u32RSCANDataBuf   = 0UL;
    uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 4UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (pstCANFrame->u8CANLEN > 8U) || (pstCANFrame == 0UL) || (pstCANFrame->u8CANFrameIDE > 1U) || (enBufIndex >= RSCAN_CHANNEL_BUF_MAX) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexP + 0X350UL + RSCAN0_BASE_ADDRESS;
        if ( ((*(( uint8_t * )u32RSCANAddress)) & 0x08U) == 0x0U )
        //if ((RCFDC0CFDTMSTS0 & 0x08U) == 0x0U)
        {
            (*(( uint8_t * )u32RSCANAddress)) = 0UL;
            //RCFDC0CFDTMSTS0 = 0UL;
            u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
            u32RSCANDataBuf = u32RSCANDataBuf << 31U;
            u32RSCANDataBuf |= pstCANFrame->u32CANID;

            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8000UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = u32RSCANDataBuf;
            //RCFDC0CFDTMID0 = u32RSCANDataBuf;

            u32RSCANDataBuf                    = pstCANFrame->u8CANLEN;
            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8004UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = ( uint32_t )((u32RSCANDataBuf) << 28U);
            //RCFDC0CFDTMPTR0 = (uint32_t)((u32RSCANDataBuf) << 28U);

            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8008UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = 0UL;
            //RCFDC0CFDTMFDCTR0 = 0UL;
            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X800CUL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData [ 0U ];
            //RCFDC0CFDTMDF0_0 = pstCANFrame->unCANData.u32CANData[0U];
            u32RSCANAddress += 0X04UL;
            (*(( uint32_t * )u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData [ 1U ];
            //RCFDC0CFDTMDF1_0 = pstCANFrame->unCANData.u32CANData[1U];

            u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
            (*(( uint8_t * )u32RSCANAddress)) |= 0X01;
            //RCFDC0CFDTMC0 |= 0X01;

            enRSCANStatus = RSCAN_SET_COMPLETE;
        }
        else
        {
            enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
        }
    }
    return enRSCANStatus;
}
RSCAN_SetState RSCAN0_CH5_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame)
{
    uint8_t  i;
    uint32_t u32RSCANDataBuf   = 0UL;
    uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 5UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (pstCANFrame->u8CANLEN > 8U) || (pstCANFrame == 0UL) || (pstCANFrame->u8CANFrameIDE > 1U) || (enBufIndex >= RSCAN_CHANNEL_BUF_MAX) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexP + 0X350UL + RSCAN0_BASE_ADDRESS;
        if ( ((*(( uint8_t * )u32RSCANAddress)) & 0x08U) == 0x0U )
        //if ((RCFDC0CFDTMSTS0 & 0x08U) == 0x0U)
        {
            (*(( uint8_t * )u32RSCANAddress)) = 0UL;
            //RCFDC0CFDTMSTS0 = 0UL;
            u32RSCANDataBuf = pstCANFrame->u8CANFrameIDE;
            u32RSCANDataBuf = u32RSCANDataBuf << 31U;
            u32RSCANDataBuf |= pstCANFrame->u32CANID;

            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8000UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = u32RSCANDataBuf;
            //RCFDC0CFDTMID0 = u32RSCANDataBuf;

            u32RSCANDataBuf                    = pstCANFrame->u8CANLEN;
            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8004UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = ( uint32_t )((u32RSCANDataBuf) << 28U);
            //RCFDC0CFDTMPTR0 = (uint32_t)((u32RSCANDataBuf) << 28U);

            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X8008UL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = 0UL;
            //RCFDC0CFDTMFDCTR0 = 0UL;
            u32RSCANAddress                    = u32RSCANBufIndexP * 0X80UL + 0X800CUL + RSCAN0_BASE_ADDRESS;
            (*(( uint32_t * )u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData [ 0U ];
            //RCFDC0CFDTMDF0_0 = pstCANFrame->unCANData.u32CANData[0U];
            u32RSCANAddress += 0X04UL;
            (*(( uint32_t * )u32RSCANAddress)) = pstCANFrame->unCANData.u32CANData [ 1U ];
            //RCFDC0CFDTMDF1_0 = pstCANFrame->unCANData.u32CANData[1U];

            u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
            (*(( uint8_t * )u32RSCANAddress)) |= 0X01;
            //RCFDC0CFDTMC0 |= 0X01;

            enRSCANStatus = RSCAN_SET_COMPLETE;
        }
        else
        {
            enRSCANStatus = RSCAN_SET_ERROR_MSGFULL;
        }
    }
    return enRSCANStatus;
}

/********************************************************/
/*
0: Not in bus off state
1: In bus off state
*/
uint8_t RSCAN0_CH0_Get_Busoff_Status(void)
{
    uint8_t u8BusoffStatus = 0U;
    if ( RCFDC0CFDC0ERFL & 0x08UL )
    {
        u8BusoffStatus = 1U;
    }

    return u8BusoffStatus;
}

uint8_t RSCAN0_CH1_Get_Busoff_Status(void)
{
    uint8_t u8BusoffStatus = 0U;

    if ( RCFDC0CFDC1ERFL & 0x08UL )
    {
        u8BusoffStatus = 1U;
    }

    return u8BusoffStatus;
}
uint8_t RSCAN0_CH2_Get_Busoff_Status(void)
{
    uint8_t u8BusoffStatus = 0U;
    if ( RCFDC0CFDC2ERFL & 0x08UL )
    {
        u8BusoffStatus = 1U;
    }

    return u8BusoffStatus;
}
uint8_t RSCAN0_CH3_Get_Busoff_Status(void)
{
    uint8_t u8BusoffStatus = 0U;
    if ( RCFDC0CFDC3ERFL & 0x08UL )
    {
        u8BusoffStatus = 1U;
    }

    return u8BusoffStatus;
}
uint8_t RSCAN0_CH4_Get_Busoff_Status(void)
{
    uint8_t u8BusoffStatus = 0U;
    if ( RCFDC0CFDC4ERFL & 0x08UL )
    {
        u8BusoffStatus = 1U;
    }

    return u8BusoffStatus;
}
uint8_t RSCAN0_CH5_Get_Busoff_Status(void)
{
    uint8_t u8BusoffStatus = 0U;
    if ( RCFDC0CFDC5ERFL & 0x08UL )
    {
        u8BusoffStatus = 1U;
    }

    return u8BusoffStatus;
}

void RSCAN0_CH0_Busoff_Recover(void)
{
    if ( RSCAN0_CH0_Get_Busoff_Status( ) )
    {
        RCFDC0CFDC0ERFL &= 0xFFFFFFF7UL;
        RCFDC0CFDC0CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
        while ( (RCFDC0CFDC0STS & 0x87UL) != 0x80UL )
        {
        }
    }
}
void RSCAN0_CH1_Busoff_Recover(void)
{
    if ( RSCAN0_CH1_Get_Busoff_Status( ) )
    {
        RCFDC0CFDC1ERFL &= 0xFFFFFFF7UL;
        RCFDC0CFDC1CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
        while ( (RCFDC0CFDC1STS & 0x87UL) != 0x80UL )
        {
        }
    }
}
void RSCAN0_CH2_Busoff_Recover(void)
{
    if ( RSCAN0_CH2_Get_Busoff_Status( ) )
    {
        RCFDC0CFDC2ERFL &= 0xFFFFFFF7UL;
        RCFDC0CFDC2CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
        while ( (RCFDC0CFDC2STS & 0x87UL) != 0x80UL )
        {
        }
    }
}
void RSCAN0_CH3_Busoff_Recover(void)
{
    if ( RSCAN0_CH3_Get_Busoff_Status( ) )
    {
        RCFDC0CFDC3ERFL &= 0xFFFFFFF7UL;
        RCFDC0CFDC3CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
        while ( (RCFDC0CFDC3STS & 0x87UL) != 0x80UL )
        {
        }
    }
}
void RSCAN0_CH4_Busoff_Recover(void)
{
    if ( RSCAN0_CH4_Get_Busoff_Status( ) )
    {
        RCFDC0CFDC4ERFL &= 0xFFFFFFF7UL;
        RCFDC0CFDC4CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
        while ( (RCFDC0CFDC4STS & 0x87UL) != 0x80UL )
        {
        }
    }
}
void RSCAN0_CH5_Busoff_Recover(void)
{
    if ( RSCAN0_CH5_Get_Busoff_Status( ) )
    {
        RCFDC0CFDC5ERFL &= 0xFFFFFFF7UL;
        RCFDC0CFDC5CTR &= 0xFFFFFFF8UL; /*  CommunicationMode */
        while ( (RCFDC0CFDC5STS & 0x87UL) != 0x80UL )
        {
        }
    }
}

void RSCAN0_CH0_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
    uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 0UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (enBufIndex >= RSCAN_CHANNEL_BUF_MAX) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
        (*(( uint8_t * )u32RSCANAddress)) |= 0X02U;
        //RCFDC0CFDTMC0 |= 0X02;
    }
}
void RSCAN0_CH1_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
    uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 1UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (enBufIndex >= RSCAN_CHANNEL_BUF_MAX) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
        (*(( uint8_t * )u32RSCANAddress)) |= 0X02U;
        //RCFDC0CFDTMC0 |= 0X02;
    }
}
void RSCAN0_CH2_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
    uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 2UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (enBufIndex >= RSCAN_CHANNEL_BUF_MAX) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
        (*(( uint8_t * )u32RSCANAddress)) |= 0X02U;
        //RCFDC0CFDTMC0 |= 0X02;
    }
}
void RSCAN0_CH3_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
    uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 3UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (enBufIndex >= RSCAN_CHANNEL_BUF_MAX) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
        (*(( uint8_t * )u32RSCANAddress)) |= 0X02U;
        //RCFDC0CFDTMC0 |= 0X02;
    }
}
void RSCAN0_CH4_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
    uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 4UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (enBufIndex >= RSCAN_CHANNEL_BUF_MAX) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
        (*(( uint8_t * )u32RSCANAddress)) |= 0X02U;
        //RCFDC0CFDTMC0 |= 0X02;
    }
}
void RSCAN0_CH5_Abort(RSCAN_Channel_Buf_en_t enBufIndex)
{
    uint32_t u32RSCANBufIndexP = (enBufIndex + 32UL * 5UL);
    uint32_t u32RSCANAddress   = 0UL;

    RSCAN_SetState enRSCANStatus = RSCAN_SET_COMPLETE;

    if ( (enBufIndex >= RSCAN_CHANNEL_BUF_MAX) )
    {
        enRSCANStatus = RSCAN_SET_ERROR_PARAMETER;
    }
    if ( enRSCANStatus == RSCAN_SET_COMPLETE )
    {
        u32RSCANAddress = u32RSCANBufIndexP + 0X250UL + RSCAN0_BASE_ADDRESS;
        (*(( uint8_t * )u32RSCANAddress)) |= 0X02U;
        //RCFDC0CFDTMC0 |= 0X02;
    }
}
/*
如果CAN模块休眠了，但是芯片没休眠，CAN报文无法唤醒CAN模块。
*/
void RSCAN0_CH0_Sleep_Init(void)
{
    RCFDC0CFDC0CTR &= 0xfffffff9UL;
    RCFDC0CFDC0CTR |= 0x01UL;

    while ( (RCFDC0CFDC0STS & 0x07UL) != 0X01UL )
    {
        ;
    }
    RCFDC0CFDC0CTR |= 0x04UL;
    while ( (RCFDC0CFDC0STS & 0x07UL) != 0X04UL )
    {
        ;
    }
}
void RSCAN0_CH1_Sleep_Init(void)
{
    RCFDC0CFDC1CTR &= 0xfffffff9UL;
    RCFDC0CFDC1CTR |= 0x01UL;

    while ( (RCFDC0CFDC1STS & 0x07UL) != 0X01UL )
    {
        ;
    }
    RCFDC0CFDC1CTR |= 0x04UL;
    while ( (RCFDC0CFDC1STS & 0x07UL) != 0X04UL )
    {
        ;
    }
}
void RSCAN0_CH2_Sleep_Init(void)
{
    RCFDC0CFDC2CTR &= 0xfffffff9UL;
    RCFDC0CFDC2CTR |= 0x01UL;

    while ( (RCFDC0CFDC2STS & 0x07UL) != 0X01UL )
    {
        ;
    }
    RCFDC0CFDC2CTR |= 0x04UL;
    while ( (RCFDC0CFDC2STS & 0x07UL) != 0X04UL )
    {
        ;
    }
}
void RSCAN0_CH3_Sleep_Init(void)
{
    RCFDC0CFDC3CTR &= 0xfffffff9UL;
    RCFDC0CFDC3CTR |= 0x01UL;

    while ( (RCFDC0CFDC3STS & 0x07UL) != 0X01UL )
    {
        ;
    }
    RCFDC0CFDC3CTR |= 0x04UL;
    while ( (RCFDC0CFDC3STS & 0x07UL) != 0X04UL )
    {
        ;
    }
}
void RSCAN0_CH4_Sleep_Init(void)
{
    RCFDC0CFDC4CTR &= 0xfffffff9UL;
    RCFDC0CFDC4CTR |= 0x01UL;

    while ( (RCFDC0CFDC4STS & 0x07UL) != 0X01UL )
    {
        ;
    }
    RCFDC0CFDC4CTR |= 0x04UL;
    while ( (RCFDC0CFDC4STS & 0x07UL) != 0X04UL )
    {
        ;
    }
}
void RSCAN0_CH5_Sleep_Init(void)
{
    RCFDC0CFDC5CTR &= 0xfffffff9UL;
    RCFDC0CFDC5CTR |= 0x01UL;

    while ( (RCFDC0CFDC5STS & 0x07UL) != 0X01UL )
    {
        ;
    }
    RCFDC0CFDC5CTR |= 0x04UL;
    while ( (RCFDC0CFDC5STS & 0x07UL) != 0X04UL )
    {
        ;
    }
}

void RSCAN0_Sleep_Init(void)
{
    RCFDC0CFDGCTR &= 0xfffffff9UL;
    RCFDC0CFDGCTR |= 0x01UL;

    while ( (RCFDC0CFDGSTS & 0x07UL) != 0X01UL )
    {
        ;
    }

    RCFDC0CFDGCTR |= 0x04UL;
    while ( (RCFDC0CFDGSTS & 0x04UL) != 0X04UL )
    {
        ;
    }
}

uint8_t RSCAN0_CH0_TX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    u8ErrorCount         = ( uint8_t )(RCFDC0CFDC0STS >> 24U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH1_TX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    u8ErrorCount         = ( uint8_t )(RCFDC0CFDC1STS >> 24U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH2_TX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    u8ErrorCount         = ( uint8_t )(RCFDC0CFDC2STS >> 24U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH3_TX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    u8ErrorCount         = ( uint8_t )(RCFDC0CFDC3STS >> 24U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH4_TX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    u8ErrorCount         = ( uint8_t )(RCFDC0CFDC4STS >> 24U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH5_TX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    u8ErrorCount         = ( uint8_t )(RCFDC0CFDC5STS >> 24U);
    return u8ErrorCount;
}

uint8_t RSCAN0_CH0_RX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    u8ErrorCount         = ( uint8_t )(RCFDC0CFDC0STS >> 16U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH1_RX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    u8ErrorCount         = ( uint8_t )(RCFDC0CFDC1STS >> 16U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH2_RX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    u8ErrorCount         = ( uint8_t )(RCFDC0CFDC2STS >> 16U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH3_RX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    u8ErrorCount         = ( uint8_t )(RCFDC0CFDC3STS >> 16U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH4_RX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    u8ErrorCount         = ( uint8_t )(RCFDC0CFDC4STS >> 16U);
    return u8ErrorCount;
}
uint8_t RSCAN0_CH5_RX_Error_Count(void)
{
    uint8_t u8ErrorCount = 0U;
    u8ErrorCount         = ( uint8_t )(RCFDC0CFDC5STS >> 16U);
    return u8ErrorCount;
}
/*
RSCAN_Com_Status_en_t RSCAN0_CH0_Get_Communication_Status(void)
{
	RSCAN_Com_Status_en_t enRSCANComStatus = RSCAN_BUS_IDLE;

	if (RCFDC0CFDC0STS & 0x40UL)
	{
		enRSCANComStatus = RSCAN_BUS_RX;
	}
	if (RCFDC0CFDC0STS & 0x20UL)
	{
		enRSCANComStatus = RSCAN_BUS_TX;
	}
	if (RCFDC0CFDC0STS & 0x10UL)
	{
		enRSCANComStatus = RSCAN_BUS_OFF;
	}
	return enRSCANComStatus;
}
*/
/****************************************************/

/******************************************************************/

void RSCAN0_CH0_RX_ISR(void)
{
    if ( RCFDC0CFDCFSTS2 & 0X08UL )
    {
        CAN_Frame_Receive_st_t stCANFrameReceive;
        RCFDC0CFDCFSTS2 &= 0xFFFFFFF7UL;

        while ( (RCFDC0CFDCFSTS2 & 0x01UL) == 0U )
        {
            stCANFrameReceive.stReceiveContent.u32CANID                    = ( uint32_t )(RCFDC0CFDCFID2 & 0x1FFFFFFFUL);
            stCANFrameReceive.stReceiveContent.u8CANLEN                    = ( uint8_t )(RCFDC0CFDCFPTR2 >> 28U);
            stCANFrameReceive.stReceiveContent.u8CANFrameIDE               = ( uint8_t )((RCFDC0CFDCFID2 >> 31U));
            stCANFrameReceive.stReceiveContent.unCANData.u32CANData [ 0U ] = RCFDC0CFDCFDF0_2;
            stCANFrameReceive.stReceiveContent.unCANData.u32CANData [ 1U ] = RCFDC0CFDCFDF1_2;

            RCFDC0CFDCFPCTR2 = 0xFFU;

            RSCAN0_CH0_Receive(&stCANFrameReceive.stReceiveContent);
        }
    }
}

void RSCAN0_CH1_RX_ISR(void)
{
    if ( RCFDC0CFDCFSTS5 & 0X08UL )
    {
        CAN_Frame_Receive_st_t stCANFrameReceive;
        RCFDC0CFDCFSTS5 &= 0xFFFFFFF7UL;

        while ( (RCFDC0CFDCFSTS5 & 0x01UL) == 0U )
        {
            stCANFrameReceive.stReceiveContent.u32CANID                    = ( uint32_t )(RCFDC0CFDCFID5 & 0x1FFFFFFFUL);
            stCANFrameReceive.stReceiveContent.u8CANLEN                    = ( uint8_t )(RCFDC0CFDCFPTR5 >> 28U);
            stCANFrameReceive.stReceiveContent.u8CANFrameIDE               = ( uint8_t )((RCFDC0CFDCFID5 >> 31U));
            stCANFrameReceive.stReceiveContent.unCANData.u32CANData [ 0U ] = RCFDC0CFDCFDF0_5;
            stCANFrameReceive.stReceiveContent.unCANData.u32CANData [ 1U ] = RCFDC0CFDCFDF1_5;

            RCFDC0CFDCFPCTR5 = 0xFFU;

            RSCAN0_CH1_Receive(&stCANFrameReceive.stReceiveContent);
        }
    }
}

void RSCAN0_CH2_RX_ISR(void)
{
    if ( RCFDC0CFDCFSTS8 & 0X08UL )
    {
        CAN_Frame_Receive_st_t stCANFrameReceive;
        RCFDC0CFDCFSTS8 &= 0xFFFFFFF7UL;

        while ( (RCFDC0CFDCFSTS8 & 0x01UL) == 0U )
        {
            stCANFrameReceive.stReceiveContent.u32CANID                    = ( uint32_t )(RCFDC0CFDCFID8 & 0x1FFFFFFFUL);
            stCANFrameReceive.stReceiveContent.u8CANLEN                    = ( uint8_t )(RCFDC0CFDCFPTR8 >> 28U);
            stCANFrameReceive.stReceiveContent.u8CANFrameIDE               = ( uint8_t )((RCFDC0CFDCFID8 >> 31U));
            stCANFrameReceive.stReceiveContent.unCANData.u32CANData [ 0U ] = RCFDC0CFDCFDF0_8;
            stCANFrameReceive.stReceiveContent.unCANData.u32CANData [ 1U ] = RCFDC0CFDCFDF1_8;

            RCFDC0CFDCFPCTR8 = 0xFFU;

            RSCAN0_CH2_Receive(&stCANFrameReceive.stReceiveContent);
        }
    }
}

void RSCAN0_CH3_RX_ISR(void)
{
    if ( RCFDC0CFDCFSTS11 & 0X08UL )
    {
        CAN_Frame_Receive_st_t stCANFrameReceive;
        RCFDC0CFDCFSTS11 &= 0xFFFFFFF7UL;

        while ( (RCFDC0CFDCFSTS11 & 0x01UL) == 0U )
        {
            stCANFrameReceive.stReceiveContent.u32CANID                    = ( uint32_t )(RCFDC0CFDCFID11 & 0x1FFFFFFFUL);
            stCANFrameReceive.stReceiveContent.u8CANLEN                    = ( uint8_t )(RCFDC0CFDCFPTR11 >> 28U);
            stCANFrameReceive.stReceiveContent.u8CANFrameIDE               = ( uint8_t )((RCFDC0CFDCFID11 >> 31U));
            stCANFrameReceive.stReceiveContent.unCANData.u32CANData [ 0U ] = RCFDC0CFDCFDF0_11;
            stCANFrameReceive.stReceiveContent.unCANData.u32CANData [ 1U ] = RCFDC0CFDCFDF1_11;

            RCFDC0CFDCFPCTR11 = 0xFFU;

            RSCAN0_CH3_Receive(&stCANFrameReceive.stReceiveContent);
        }
    }
}

void RSCAN0_CH4_RX_ISR(void)
{
    if ( RCFDC0CFDCFSTS14 & 0X08UL )
    {
        CAN_Frame_Receive_st_t stCANFrameReceive;
        RCFDC0CFDCFSTS14 &= 0xFFFFFFF7UL;

        while ( (RCFDC0CFDCFSTS14 & 0x01UL) == 0U )
        {
            stCANFrameReceive.stReceiveContent.u32CANID                    = ( uint32_t )(RCFDC0CFDCFID14 & 0x1FFFFFFFUL);
            stCANFrameReceive.stReceiveContent.u8CANLEN                    = ( uint8_t )(RCFDC0CFDCFPTR14 >> 28U);
            stCANFrameReceive.stReceiveContent.u8CANFrameIDE               = ( uint8_t )((RCFDC0CFDCFID14 >> 31U));
            stCANFrameReceive.stReceiveContent.unCANData.u32CANData [ 0U ] = RCFDC0CFDCFDF0_14;
            stCANFrameReceive.stReceiveContent.unCANData.u32CANData [ 1U ] = RCFDC0CFDCFDF1_14;

            RCFDC0CFDCFPCTR14 = 0xFFU;

            RSCAN0_CH4_Receive(&stCANFrameReceive.stReceiveContent);
        }
    }
}

void RSCAN0_CH5_RX_ISR(void)
{
    if ( RCFDC0CFDCFSTS17 & 0X08UL )
    {
        CAN_Frame_Receive_st_t stCANFrameReceive;
        RCFDC0CFDCFSTS17 &= 0xFFFFFFF7UL;

        while ( (RCFDC0CFDCFSTS17 & 0x01UL) == 0U )
        {
            stCANFrameReceive.stReceiveContent.u32CANID                    = ( uint32_t )(RCFDC0CFDCFID17 & 0x1FFFFFFFUL);
            stCANFrameReceive.stReceiveContent.u8CANLEN                    = ( uint8_t )(RCFDC0CFDCFPTR17 >> 28U);
            stCANFrameReceive.stReceiveContent.u8CANFrameIDE               = ( uint8_t )((RCFDC0CFDCFID17 >> 31U));
            stCANFrameReceive.stReceiveContent.unCANData.u32CANData [ 0U ] = RCFDC0CFDCFDF0_17;
            stCANFrameReceive.stReceiveContent.unCANData.u32CANData [ 1U ] = RCFDC0CFDCFDF1_17;

            RCFDC0CFDCFPCTR17 = 0xFFU;

            RSCAN0_CH5_Receive(&stCANFrameReceive.stReceiveContent);
        }
    }
}

void RSCAN0_CH0_TX_ISR(void)
{

    if ( RCFDC0CFDCFSTS0 & 0X10UL )
    {
        RCFDC0CFDCFSTS0 &= 0XFFFFFFEFUL;
    }
    if ( RCFDC0CFDCFSTS1 & 0X10UL )
    {
        RCFDC0CFDCFSTS1 &= 0XFFFFFFEFUL;
    }

    if ( (RCFDC0CFDTMSTS0 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS0 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(0, 0);
        }
    }
    else if ( (RCFDC0CFDTMSTS0 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS0 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(0U);
        }
    }

    if ( (RCFDC0CFDTMSTS1 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS1 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(1, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS2 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS2 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(2, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS3 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS3 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(3, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS4 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS4 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(4, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS5 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS5 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(5, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS6 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS6 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(6, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS7 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS7 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(7, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS8 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS8 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(8, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS9 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS9 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(9, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS10 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS10 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(10, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS11 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS11 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(11, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS12 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS12 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(12, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS13 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS13 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(13, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS14 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS14 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(14, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS15 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS15 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(15, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS16 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS16 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(16, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS17 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS17 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(17, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS18 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS18 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(18, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS19 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS19 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(19, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS20 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS20 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(20, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS21 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS21 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(21, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS22 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS22 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(22, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS23 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS23 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(23, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS24 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS24 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(24, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS25 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS25 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(25, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS26 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS26 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(26, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS27 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS27 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(27, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS28 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS28 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(28, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS29 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS29 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(29, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS30 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS30 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(30, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS31 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS31 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(31, 0);
        }
    }
}

void RSCAN0_CH1_TX_ISR(void)
{

    if ( RCFDC0CFDCFSTS3 & 0X10UL )
    {
        RCFDC0CFDCFSTS3 &= 0XFFFFFFEFUL;
    }
    if ( RCFDC0CFDCFSTS4 & 0X10UL )
    {
        RCFDC0CFDCFSTS4 &= 0XFFFFFFEFUL;
    }

    if ( (RCFDC0CFDTMSTS32 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS32 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(0, 0);
        }
    }
    else if ( (RCFDC0CFDTMSTS32 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS32 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(0U);
        }
    }

    if ( (RCFDC0CFDTMSTS33 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS33 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(1U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS33 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS33 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(1U);
        }
    }

    if ( (RCFDC0CFDTMSTS34 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS34 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(2U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS34 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS34 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(2U);
        }
    }

    if ( (RCFDC0CFDTMSTS35 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS35 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(3U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS35 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS35 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(3U);
        }
    }

    if ( (RCFDC0CFDTMSTS36 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS36 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(4U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS36 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS36 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(4U);
        }
    }
    if ( (RCFDC0CFDTMSTS37 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS37 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(5U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS37 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS37 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(5U);
        }
    }
    if ( (RCFDC0CFDTMSTS38 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS38 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(6U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS38 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS38 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(6U);
        }
    }
    if ( (RCFDC0CFDTMSTS39 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS39 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(7U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS39 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS39 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(7U);
        }
    }
    if ( (RCFDC0CFDTMSTS40 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS40 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(8U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS40 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS40 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(8U);
        }
    }
    if ( (RCFDC0CFDTMSTS41 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS41 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(9U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS41 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS41 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(9U);
        }
    }
    if ( (RCFDC0CFDTMSTS42 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS42 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(10U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS42 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS42 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(10U);
        }
    }
    if ( (RCFDC0CFDTMSTS43 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS43 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(11U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS43 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS43 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(11U);
        }
    }
    if ( (RCFDC0CFDTMSTS44 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS44 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(12U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS44 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS44 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(12U);
        }
    }
    if ( (RCFDC0CFDTMSTS45 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS45 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(13U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS45 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS45 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(13U);
        }
    }
    if ( (RCFDC0CFDTMSTS46 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS46 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(14U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS46 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS46 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(14U);
        }
    }
    if ( (RCFDC0CFDTMSTS47 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS47 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(15U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS47 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS47 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(15U);
        }
    }
    if ( (RCFDC0CFDTMSTS48 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS48 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(16U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS48 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS48 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(16U);
        }
    }
    if ( (RCFDC0CFDTMSTS49 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS49 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(17U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS49 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS49 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(17U);
        }
    }
    if ( (RCFDC0CFDTMSTS50 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS50 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(18U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS50 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS50 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(18U);
        }
    }
    if ( (RCFDC0CFDTMSTS51 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS51 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(19U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS51 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS51 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(19U);
        }
    }
    if ( (RCFDC0CFDTMSTS52 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS52 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(20U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS52 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS52 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(20U);
        }
    }
    if ( (RCFDC0CFDTMSTS53 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS53 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(21U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS53 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS53 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(21U);
        }
    }
    if ( (RCFDC0CFDTMSTS54 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS54 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(22U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS54 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS54 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(22U);
        }
    }
    if ( (RCFDC0CFDTMSTS55 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS55 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(23U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS55 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS55 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(23U);
        }
    }

    if ( (RCFDC0CFDTMSTS56 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS56 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(24U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS56 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS56 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(24U);
        }
    }
    if ( (RCFDC0CFDTMSTS57 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS57 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(25U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS57 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS57 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(25U);
        }
    }
    if ( (RCFDC0CFDTMSTS58 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS58 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(26U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS58 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS58 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(26U);
        }
    }
    if ( (RCFDC0CFDTMSTS59 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS59 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(27U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS59 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS59 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(27U);
        }
    }
    if ( (RCFDC0CFDTMSTS60 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS60 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(28U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS60 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS60 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(28U);
        }
    }
    if ( (RCFDC0CFDTMSTS61 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS61 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(29U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS61 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS61 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(29U);
        }
    }
    if ( (RCFDC0CFDTMSTS62 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS62 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(30U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS62 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS62 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(30U);
        }
    }
    
    if ( (RCFDC0CFDTMSTS63 & RSCAN_TX_CPLT_AND) == RSCAN_TX_CPLT )
    {
        RCFDC0CFDTMSTS63 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANConfirmCallBack(31U, 0U);
        }
    }
    else if ( (RCFDC0CFDTMSTS63 & RSCAN_ABORT_CPLT_AND) == RSCAN_ABORT_CPLT )
    {
        RCFDC0CFDTMSTS63 = 0X0U;
        if ( g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh0.pfnRSCANAbortConfirmCallBack(31U);
        }
    }
}

void RSCAN0_CH2_TX_ISR(void)
{
    if ( RCFDC0CFDCFSTS6 & 0X10UL )
    {
        RCFDC0CFDCFSTS6 &= 0XFFFFFFEFUL;
    }
    if ( RCFDC0CFDCFSTS7 & 0X10UL )
    {
        RCFDC0CFDCFSTS7 &= 0XFFFFFFEFUL;
    }

    if ( (RCFDC0CFDTMSTS64 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS64 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(0, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS65 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS65 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(1, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS66 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS66 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(2, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS67 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS67 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(3, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS68 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS68 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(4, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS69 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS69 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(5, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS70 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS70 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(6, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS71 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS71 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(7, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS72 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS72 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(8, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS73 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS73 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(9, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS74 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS74 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(10, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS75 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS75 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(11, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS76 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS76 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(12, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS77 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS77 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(13, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS78 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS78 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(14, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS79 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS79 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(15, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS80 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS80 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(16, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS81 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS81 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(17, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS82 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS82 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(18, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS83 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS83 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(19, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS84 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS84 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(20, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS85 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS85 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(21, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS86 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS86 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(22, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS87 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS87 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(23, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS88 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS88 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(24, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS89 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS89 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(25, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS90 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS90 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(26, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS91 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS91 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(27, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS92 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS92 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(28, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS93 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS93 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(29, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS94 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS94 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(30, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS95 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS95 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh2.pfnRSCANConfirmCallBack(31, 0);
        }
    }
}

void RSCAN0_CH3_TX_ISR(void)
{

    if ( RCFDC0CFDCFSTS9 & 0X10UL )
    {
        RCFDC0CFDCFSTS9 &= 0XFFFFFFEFUL;
    }
    if ( RCFDC0CFDCFSTS10 & 0X10UL )
    {
        RCFDC0CFDCFSTS10 &= 0XFFFFFFEFUL;
    }

    if ( (RCFDC0CFDTMSTS96 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS96 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(0, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS97 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS97 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(1, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS98 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS98 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(2, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS99 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS99 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(3, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS100 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS100 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(4, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS101 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS101 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(5, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS102 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS102 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(6, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS103 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS103 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(7, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS104 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS104 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(8, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS105 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS105 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(9, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS106 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS106 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(10, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS107 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS107 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(11, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS108 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS108 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(12, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS109 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS109 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(13, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS110 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS110 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(14, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS111 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS111 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(15, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS112 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS112 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(16, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS113 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS113 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(17, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS114 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS114 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(18, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS115 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS115 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(19, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS116 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS116 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(20, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS117 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS117 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(21, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS118 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS118 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(22, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS119 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS119 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(23, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS120 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS120 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(24, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS121 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS121 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(25, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS122 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS122 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(26, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS123 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS123 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(27, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS124 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS124 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(28, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS125 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS125 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(29, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS126 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS126 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(30, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS127 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS127 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh3.pfnRSCANConfirmCallBack(31, 0);
        }
    }
}

void RSCAN0_CH4_TX_ISR(void)
{
    if ( RCFDC0CFDCFSTS12 & 0X10UL )
    {
        RCFDC0CFDCFSTS12 &= 0XFFFFFFEFUL;
    }
    if ( RCFDC0CFDCFSTS13 & 0X10UL )
    {
        RCFDC0CFDCFSTS13 &= 0XFFFFFFEFUL;
    }

    if ( (RCFDC0CFDTMSTS128 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS128 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(0, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS129 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS129 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(1, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS130 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS130 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(2, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS131 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS131 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(3, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS132 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS132 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(4, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS133 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS133 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(5, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS134 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS134 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(6, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS135 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS135 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(7, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS136 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS136 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(8, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS137 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS137 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(9, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS138 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS138 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(10, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS139 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS139 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(11, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS140 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS140 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(12, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS141 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS141 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(13, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS142 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS142 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(14, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS143 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS143 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(15, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS144 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS144 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(16, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS145 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS145 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(17, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS146 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS146 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(18, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS147 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS147 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(19, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS148 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS148 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(20, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS149 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS149 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(21, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS150 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS150 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(22, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS151 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS151 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(23, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS152 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS152 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(24, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS153 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS153 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(25, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS154 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS154 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(26, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS155 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS155 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(27, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS156 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS156 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(28, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS157 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS157 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(29, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS158 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS158 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(30, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS159 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS159 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh4.pfnRSCANConfirmCallBack(31, 0);
        }
    }
}

void RSCAN0_CH5_TX_ISR(void)
{
    if ( RCFDC0CFDCFSTS15 & 0X10UL )
    {
        RCFDC0CFDCFSTS15 &= 0XFFFFFFEFUL;
    }
    if ( RCFDC0CFDCFSTS16 & 0X10UL )
    {
        RCFDC0CFDCFSTS16 &= 0XFFFFFFEFUL;
    }

    if ( (RCFDC0CFDTMSTS160 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS160 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(0, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS161 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS161 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(1, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS162 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS162 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(2, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS163 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS163 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(3, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS164 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS164 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(4, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS165 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS165 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(5, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS166 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS166 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(6, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS167 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS167 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(7, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS168 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS168 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(8, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS169 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS169 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(9, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS170 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS170 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(10, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS171 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS171 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(11, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS172 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS172 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(12, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS173 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS173 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(13, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS174 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS174 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(14, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS175 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS175 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(15, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS176 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS176 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(16, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS177 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS177 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(17, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS178 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS178 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(18, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS179 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS179 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(19, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS180 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS180 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(20, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS181 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS181 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(21, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS182 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS182 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(22, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS183 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS183 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(23, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS184 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS184 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(24, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS185 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS185 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(25, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS186 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS186 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(26, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS187 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS187 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(27, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS188 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS188 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(28, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS189 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS189 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(29, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS190 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS190 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(30, 0);
        }
    }
    if ( (RCFDC0CFDTMSTS191 & 0x06U) != 0U )
    {
        RCFDC0CFDTMSTS191 &= 0XF9U;
        if ( g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack )
        {
            g_stRSCAN0Config.stRSCANCh5.pfnRSCANConfirmCallBack(31, 0);
        }
    }
}

/*********************************************************************/
