/****************************************************************************

  程序名称：多对象时间戳程序
  程序版本：REV  0.1
  最后修改：20190603
  设计编写：王祥福
  
  版本修订：
    REV 0.1    20190603    王祥福         创建文档

****************************************************************************/
//---------------------------------------------------------------------------
//  重定义保护
#ifndef __TIMESTAMP_H__
#define __TIMESTAMP_H__

//---------------------------------------------------------------------------
//  定义相关宏
#define MAX_TIMESTAMP_VAL        65535           //  时间戳的最大值

//---------------------------------------------------------------------------
//  相关数据类型
//  定义时间戳对象信息结构体
typedef struct
{
	unsigned int last_timesptamp;     //  上一次的时间戳值
	unsigned int time_cnt;            //  时间累计值
}STimeStampInfo;

//---------------------------------------------------------------------------
//  导出函数
//  时间累计调用函数,用户在1ms中断中调用该函数
void TimeStamp_TimeCntCallback(void);

//  开始一个时间戳对象
void TimeStamp_Reset(STimeStampInfo* pinfo);

//  统计时间戳对象
void TimeStamp_Update(STimeStampInfo* pinfo);

//  获得指定时间戳对象的累计时间
unsigned int TimeStamp_GetCntTime(STimeStampInfo* pinfo);

//---------------------------------------------------------------------------
#endif  //  __TIMESTAMP_H__

