#include "common_include.h"
#include "bsp_app_led_output.h"
#include "bsp_app_led_BN7R.h"
#include "bsp_app_led_NQ5C.h"
#include "bsp_app_led_PDEPE2.h"
#include "bsp_app_led_SQFL.h"
#include "bsp_app_led_SU2IFL.h"
#include "bsp_app_led_US4.h"
#include "bsp_app_led_NUPE.h"
#include "bsp_app_led_SP2CPE.h"
#include "bsp_Presskey.h"
extern uint8_t LowFuelFlag;
uint8_t g_uiLedNum = 0;
uint8_t g_uiLedIdx = 1;
uint8_t g_uiBCWFlag = 0;
uint8_t g_uiHEV_CheckFlag = 0;

ST_FUNC_OUT g_stLedOut[LED_MAX_NUM];
uint8_t g_szLedName[16];
uint16_t DisPlayCurMotorSpds;
uint16_t DisPlayCurSpeeds;
uint16_t DisPlayCurPowers;
uint16_t DisPlayCurElectricitys;
uint16_t DisPlayCurChargingTime_H;
uint16_t DisPlayCurChargingTime_M;
void Four_WD_Diag()
{
#if (CAN_2ND)
    
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif     
} 
uint16_t HJ_SWitchDownTime = 0;
uint8_t HJ_SWitchDownSetTimeFalg = 0;
uint8_t HJ_CurPushCount = 0;
uint16_t HJ_SWitchUpTime = 0;
uint8_t HJ_SWitchUpSetTimeFalg = 0;
void ClearOtherSWFlagFun()
{
    HJ_SWitchDownTime = 0;
    HJ_SWitchDownSetTimeFalg = 0;
    HJ_CurPushCount = 0;
    HJ_SWitchUpTime = 0;
    HJ_SWitchUpSetTimeFalg = 0;
}
void HJ_SWPush(HJ_SwitchOutPut SWitchSate, uint8_t SwPushCount, uint8_t SwSept) {
    if((SWitchSate == HJ_MODE_ShortPush) || (SWitchSate == HJ_SET_ShortPush)) {
        if(HJ_SWitchUpTime == 0) {
            if(SWitchSate == HJ_MODE_ShortPush) {
                Port_SetPortPinLevel(1, 24, PortGpioHigh);
                Port_SetPortPinLevel(2, 27, PortGpioLow);
            } else if(SWitchSate == HJ_SET_ShortPush) {
                Port_SetPortPinLevel(2, 12, PortGpioLow);
                Port_SetPortPinLevel(2, 27, PortGpioHigh);
            }
            if(HJ_SWitchDownSetTimeFalg == 0) {
            HJ_SWitchDownSetTimeFalg = 1;
            HJ_SWitchDownTime = 50;
            HJ_SWitchUpSetTimeFalg = 0;
            }
        } else {
            if(SWitchSate == HJ_MODE_ShortPush) {
                Port_SetPortPinLevel(2, 12, PortGpioLow);
                Port_SetPortPinLevel(2, 27, PortGpioLow);
            } else if(SWitchSate == HJ_SET_ShortPush) {
                Port_SetPortPinLevel(2, 12, PortGpioLow);
                Port_SetPortPinLevel(2, 27, PortGpioLow);
            }
        }
        
        if(HJ_SWitchDownTime == 0) {   
            if(HJ_SWitchUpSetTimeFalg == 0) {
                HJ_SWitchUpSetTimeFalg = 1;
                HJ_SWitchUpTime = 50;
                HJ_CurPushCount ++;
                HJ_SWitchDownSetTimeFalg = 0;
            } 
            
            if(HJ_CurPushCount == SwPushCount) {
                // HJ_CurPushCount = 0;
                // HJ_SWitchDownTime = 0;
                // HJ_SWitchDownSetTimeFalg = 0;
                // HJ_SWitchUpTime = 0;
                // HJ_SWitchUpSetTimeFalg = 0;
                ClearOtherSWFlagFun();
                if(SwSept == 1) {
                    HJ_SetTimeStep_1 ++;
                } else if (SwSept == 2) {
                    HJ_SetTimeStep_2 ++;
                } else if (SwSept == 3) {
                    HJ_SetTimeStep_3 ++;
                }
            }
        }
    } else if(SWitchSate == HJ_MODE_LongPush) {
        if(HJ_SWitchDownSetTimeFalg == 0) {
            HJ_SWitchDownSetTimeFalg = 1;
            HJ_SWitchDownTime = 2500;
        }
        if(HJ_SWitchDownTime > 0) {
            Port_SetPortPinLevel(2, 27, PortGpioLow);
            Port_SetPortPinLevel(2, 12, PortGpioHigh);
        } else if(HJ_SWitchDownTime == 0) {
            // Port_SetPortPinLevel(2, 27, PortGpioLow);
            // Port_SetPortPinLevel(2, 12, PortGpioLow);
            if(SwSept == 0) {
                HJ_SetTimeStep_0 ++;
            } else if(SwSept == 1) {
                HJ_SetTimeStep_1 ++;
            } else if (SwSept == 2) {
                HJ_SetTimeStep_2 ++;
            } else if (SwSept == 3) {
                HJ_SetTimeStep_3 ++;
            }
            HJ_SWitchDownSetTimeFalg = 0;
        }

    } else if(SWitchSate == HJ_SET_LongPush) {
        
        if(HJ_SWitchDownSetTimeFalg == 0) {
            HJ_SWitchDownSetTimeFalg = 1;
            HJ_SWitchDownTime = 2500;
        }
        if(HJ_SWitchDownTime > 0) {
            Port_SetPortPinLevel(2, 27, PortGpioHigh);
            Port_SetPortPinLevel(2, 12, PortGpioLow);
        } else if(HJ_SWitchDownTime == 0) {
            Port_SetPortPinLevel(2, 27, PortGpioLow);
            Port_SetPortPinLevel(2, 12, PortGpioLow);
            if(SwSept == 1) {
                HJ_SetTimeStep_1 ++;
            } else if (SwSept == 2) {
                HJ_SetTimeStep_2 ++;
            } else if (SwSept == 3) {
                HJ_SetTimeStep_3 ++;
            }
            HJ_SWitchDownSetTimeFalg = 0;
        }

    } else if(SWitchSate == HJ_SETMODE_LongPush_5S) {
        Port_SetPortPinLevel(2, 12, PortGpioHigh);
        Port_SetPortPinLevel(2, 27, PortGpioHigh);
        if(HJ_SWitchDownSetTimeFalg == 0) {
            HJ_SWitchDownSetTimeFalg = 1;
            HJ_SWitchDownTime = 5000;
        }
        
        if(HJ_SWitchDownTime == 0) {
            Port_SetPortPinLevel(2, 12, PortGpioLow);
            Port_SetPortPinLevel(2, 27, PortGpioLow);
            if(SwSept == 1) {
                HJ_SetTimeStep_1 ++;
            } else if (SwSept == 2) {
                HJ_SetTimeStep_2 ++;
            } else if (SwSept == 3) {
                HJ_SetTimeStep_3 ++;
            }
            HJ_SWitchDownSetTimeFalg = 0;
        }
    } else if(SWitchSate == HJ_SETMODE_LongPush_2S) {
        // Port_SetPortPinLevel(2, 12, PortGpioHigh);
        // Port_SetPortPinLevel(2, 27, PortGpioHigh);
        if(HJ_SWitchDownSetTimeFalg == 0) {
            HJ_SWitchDownSetTimeFalg = 1;
            HJ_SWitchDownTime = 2500;
        }
        if(HJ_SWitchDownTime > 0) {
            Port_SetPortPinLevel(2, 12, PortGpioHigh);
            Port_SetPortPinLevel(2, 27, PortGpioHigh);
        } else if(HJ_SWitchDownTime == 0) {
            Port_SetPortPinLevel(2, 12, PortGpioLow);
            Port_SetPortPinLevel(2, 27, PortGpioLow);
            if(SwSept == 1) {
                HJ_SetTimeStep_1 ++;
            } else if (SwSept == 2) {
                HJ_SetTimeStep_2 ++;
            } else if (SwSept == 3) {
                HJ_SetTimeStep_3 ++;
            }
            HJ_SWitchDownSetTimeFalg = 0;
            //ClearOtherSWFlagFun();
        
        }

    }
}
uint8_t FrontOilNum = 0xFF;
//uint8_t SetOilState = 0;
void HJ_FuelFun(HJ_FuelScale OilNum)
{
    // if(OilNum != FrontOilNum) {
    //     Iol_TempCurrent.enable = 1;
    //     MC1413_IGNOFF;
    //     MC1413_BOFF;
    //     //SetOilState = 0;
    // }
    // if(Iol_TempCurrent.enable == 1) {
    //     if(Iol_TempCurrent.Time > 500)
    //     {
    //         MC1413_IGNON;
    //         MC1413_BON;
    //     }
    //     if(Iol_TempCurrent.Time > 2500) {
    //         Iol_TempCurrent.Time = 0;
    //         Iol_TempCurrent.enable = 0;
    //         TestReadFuel();
    //         //SetOilState = 1;
    //         Othercount ++;
    //     }
    // }
    Iol_TempCurrent.enable = 1;
    if (Iol_TempCurrent.Time >= 1000) {
        Iol_TempCurrent.Time = 0;
        TestReadFuel();
    }
    
    FrontOilNum = OilNum;    
    
    LampState_L.Lamps.RELAY_F1 = 0;
    LampState_L.Lamps.RELAY_F2 = 0;
    LampState_L.Lamps.RELAY_F3 = 0;
    LampState_L.Lamps.RELAY_F4 = 0;
    LampState_L.Lamps.RELAY_F5 = 0; 
    LampState_L.Lamps.RELAY_F6 = 0;
    LampState_L.Lamps.RELAY_F7 = 0;
    LampState_L.Lamps.RELAY_F8 = 0;
    switch(OilNum)
    {
        case HJ_FuelNull:
        //LampState_L.Lamps.RELAY_F1 = 1;
        break;
        case HJ_FuelOne:
        LampState_L.Lamps.RELAY_F1 = 1;
        break;
        case HJ_FuelTwo:
        LampState_L.Lamps.RELAY_F2 = 1;
        break;
        case HJ_FuelThree:
        LampState_L.Lamps.RELAY_F3 = 1;
        break;
        case HJ_FuelFour:
        LampState_L.Lamps.RELAY_F4 = 1;
        break;
        case HJ_FuelFive:
        LampState_L.Lamps.RELAY_F5 = 1;
        break;
        case HJ_FuelFour_a:
        LampState_L.Lamps.RELAY_F4 = 1;
        break;
        case HJ_FuelThree_a:
        LampState_L.Lamps.RELAY_F3 = 1;
        break;
        case HJ_FuelTwo_a:
        LampState_L.Lamps.RELAY_F2 = 1;
        break;
        case HJ_FuelOne_a:
        LampState_L.Lamps.RELAY_F1 = 1;
        break;
        case HJ_FuelNull_a:
        //LampState_L.Lamps.RELAY_F4 = 1;
        //LampState_L.Lamps.RELAY_F1 = 1;
        break;
       
    }
}

//void HJ_SetGear(en_port_gpio_level_t LedState, uint8_t GearNum)
//{
//    switch(GearNum) 
//    {
//        case 0:
//        
//        break;
//
//        case 1:
//        Port_SetPortPinLevel(2, 14, PortGpioHigh); 
//        break;
//
//        case 2:
//        Port_SetPortPinLevel(2, 3, PortGpioHigh); 
//        break;
//
//        case 3:
//        Port_SetPortPinLevel(2, 20, PortGpioHigh); 
//        break;
//
//        case 4:
//        Port_SetPortPinLevel(2, 29, PortGpioHigh); 
//        break;
//
//        case 5:
//        Port_SetPortPinLevel(2, 27, PortGpioHigh); 
//        break;
//
//        case 6:
//        Port_SetPortPinLevel(2, 12, PortGpioHigh); 
//        break;
//
//        case 7:
//        Port_SetPortPinLevel(2, 20, PortGpioHigh); 
//        break;
//
//    }
//
//    
//}
//void HJ_SetLeftLed(en_port_gpio_level_t LedState)
//{
//    Port_SetPortPinLevel(2, 0, LedState); 
//}
void HJ_SetGear(void)
{
    //Port_SetPortPinLevel(2, 14, PortGpioLow); 
    //Port_SetPortPinLevel(2, 3, PortGpioLow); 
    //Port_SetPortPinLevel(2, 20, PortGpioLow); 
    //Port_SetPortPinLevel(2, 29, PortGpioLow); 
    //Port_SetPortPinLevel(2, 27, PortGpioLow); 
    //Port_SetPortPinLevel(2, 12, PortGpioLow); 
    //Port_SetPortPinLevel(2, 0, PortGpioLow);
   // HJ_SetLeftLed(PortGpioLow );
    switch (HJ_OtherKeyCurrent.count)
    {
        case 1:
        Port_SetPortPinLevel(2, 14, PortGpioLow); 
        Port_SetPortPinLevel(2, 3, PortGpioLow); 
        Port_SetPortPinLevel(2, 20, PortGpioLow); 
        Port_SetPortPinLevel(2, 29, PortGpioLow); 
        Port_SetPortPinLevel(2, 27, PortGpioLow); 
        Port_SetPortPinLevel(2, 12, PortGpioLow); 
        case 2:
        Port_SetPortPinLevel(2, 14, PortGpioHigh);
        break;

        case 3:
        Port_SetPortPinLevel(2, 3, PortGpioHigh); 

        //Port_SetPortPinLevel(2, 0, PortGpioHigh);
        break;

        case 4:
        Port_SetPortPinLevel(2, 20, PortGpioHigh); 
        break;

        case 5:
        Port_SetPortPinLevel(2, 29, PortGpioHigh); 
        break;

        case 6:
        Port_SetPortPinLevel(2, 27, PortGpioHigh); 
        break;

        case 7:
        Port_SetPortPinLevel(2, 12, PortGpioHigh); 
        break;

        case 8:
        
        case 9:
        Port_SetPortPinLevel(2, 12, PortGpioHigh);
        break;
        
        case 10:
        Port_SetPortPinLevel(2, 27, PortGpioHigh);
        break;

        case 11:
        Port_SetPortPinLevel(2, 29, PortGpioHigh); 
        break;


    }

    
}
/******************************************************************************************/
#define OFFSET 2730
uint8_t testabs = 0xff;
void HJ_LED(en_port_gpio_level_t LedState)
{
 //    Port_SetPortPinLevel(2, 14, PortGpioLow); 
 //   Port_SetPortPinLevel(2, 3, PortGpioLow); 
 //   Port_SetPortPinLevel(2, 20, PortGpioLow); 
 //   Port_SetPortPinLevel(2, 29, PortGpioLow); 
 //   Port_SetPortPinLevel(2, 27, PortGpioLow); 
 //   Port_SetPortPinLevel(2, 12, PortGpioLow); 


#if 1
    Port_SetPortPinLevel(2, 0, PortGpioLow);//左转
    Port_SetPortPinLevel(2, 1, PortGpioLow);//远光
    testabs = Port_SetPortPinLevel(2, 21, PortGpioHigh);//ABS
    Port_SetPortPinLevel(2, 28, PortGpioLow);//电故障 备用1
    Port_SetPortPinLevel(1, 13, PortGpioLow);//右转
    Port_SetPortPinLevel(0, 0, PortGpioLow);//机油压力
    Port_SetPortPinLevel(2, 13, PortGpioLow);//N档灯
    TCS_37B.msg.bits.TCS_Warning = 0;//TCS
    ISG_111.msg.bits.ISG_Ready = 0;//HEV灯

    ISG_111.msg.bits.ISG_Power_Enable = 0;//E、S灯
    ISG_111.msg.bits.ISG_Power = 0;

    Port_SetPortPinLevel(1, 25, PortGpioLow);//N自动启停,备用2

    //Port_SetPortPinLevel(1, 21, PortGpioLow);//测试
#endif
   // HJ_SetLeftLed(PortGpioLow );
    switch(HJ_OtherKeyCurrent.count) 
    {
        case 1:
        
        break;

        case 2:
        Port_SetPortPinLevel(2, 0, PortGpioHigh);//左转
        Port_SetPortPinLevel(1, 13, PortGpioHigh);//右转
         Port_SetPortPinLevel(1, 21, PortGpioHigh);//测试
        break;

        case 3:
        //胎压灯
        //燃油指示灯
        
        break;
        case 4:
        
        Port_SetPortPinLevel(2, 1, PortGpioHigh);//远光
        Port_SetPortPinLevel(1, 25, PortGpioHigh);//自动启停
        break;
        case 5: 
        
        Port_SetPortPinLevel(2, 21, PortGpioLow);//ABS
        Port_SetPortPinLevel(2, 28, PortGpioHigh);//电故障 备用1
        //MC1413_BON;;
        break;
        case 6:
        Port_SetPortPinLevel(2, 13, PortGpioHigh);//N档灯
        break;
        case 7:
        Port_SetPortPinLevel(0, 0, PortGpioHigh);//机油压力
        //  wifi
        break;
        case 8:
        ISG_111.msg.bits.ISG_Ready = 1;//HEV灯
        break;
        case 9:
        
        break;
        case 10:
        TCS_37B.msg.bits.TCS_Warning = 1;//TCS
        break;

        case 11:
        Port_SetPortPinLevel(2, 0, PortGpioHigh);//左转
        Port_SetPortPinLevel(2, 1, PortGpioHigh);//远光
        Port_SetPortPinLevel(2, 21, PortGpioLow);//ABS
        Port_SetPortPinLevel(1, 28, PortGpioHigh);//电故障 备用1
        Port_SetPortPinLevel(1, 13, PortGpioHigh);//右转
        Port_SetPortPinLevel(0, 0, PortGpioHigh);//机油压力
        Port_SetPortPinLevel(2, 13, PortGpioHigh);//N档灯
        TCS_37B.msg.bits.TCS_Warning = 1;//TCS
        ISG_111.msg.bits.ISG_Ready = 1;//HEV灯

        ISG_111.msg.bits.ISG_Power_Enable = 1;//E、S灯
        ISG_111.msg.bits.ISG_Power = 1;

        Port_SetPortPinLevel(1, 25, PortGpioHigh);//N自动启停

        break;
    
}
}






void HJ_VSpeed(uint8_t VSpeedNum)//车�?
{
  //  ABS1.msg.bits.ABS_VehSpd_L = (VSpeedNum >> 8);
    ABS1.msg.bits.ECU_Vehicle_Speed = VSpeedNum;
  //  ECU_101.msg.bits.ECU_Vehicle_Speed = VSpeedNum;
}

void HJ_ESpeed(uint16_t ESpeedNum)//�?�?
{
    ABS1.msg.bits.ECU_Engine_Speed_L = ESpeedNum & 0xFF;
    ABS1.msg.bits.ECU_Engine_Speed_H = (ESpeedNum>>8) & 0xFF;
   // ABS1.msg.bits.ABS_VehSpd_L = (ESpeedNum >> 8);
   // ABS1.msg.bits.ABS_VehSpd_H = (ESpeedNum & 0xFF);
}

//void HJ_SetLeftLed(en_port_gpio_level_t LedState)
//{
//    Port_SetPortPinLevel(2, 0, LedState); 
//}

//void HJ_SetRightLed(en_port_gpio_level_t LedState)
//{
//    Port_SetPortPinLevel(1, 13, LedState); 
//}
//dayun2508
/*************************************************************/
void HJ_SetHightLed(en_port_gpio_level_t LedState)
{
   Port_SetPortPinLevel(2, 1, LedState); 
}
/*************************************************************/
void HJ_ECU_Warning_Lamp(void)
{
    ECU_402.msg.bits.ECU_Warning_Lamp = 0x1;
}

void HJ_StartStopSystem(en_port_gpio_level_t LedState)
{
    //Port_SetPortPinLevel(2, 13, LedState); 

}

//switch(HJ_OtherKeyCurrent.count) 
//    {
//        case 0:
//         HJ_SetLeftLed(PortGpioHigh LedState);
//        break;
//
//        case 1:
//     //   HJ_SetLeftLed(PortGpioHigh);
//        break;
//
//        case 2:
//        
//
//
//    }


void HJ_VoltageNumLamp(void)
{
    ECU_401.msg.bits.ECU_Battery_Voltage = 0x1E;
}

void HJ_OilLamp(void)
{
    
}

void SpeedRpmMax()
{
    BMS_ChargeStatus.msg.bits.BMS_ChargeStatus = 0x2;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x0C;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x30;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xFA;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x0;
}

// void SpeedMaxFun()
// {
//     ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L
// }
void Gear_P()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_GearboxPositionDisp = 0xB;
    BMS_ChargeStatus.msg.bits.BMS_ChargeStatus = 0x2;
    BMS_6.msg.bits.BMS_RemainingChargeTime_L = 0x0;
    BMS_6.msg.bits.BMS_RemainingChargeTime_H = 0x16;
    AC_ExternalTemperature_C.msg.bits.AC_ExternalTemperature_C = 0x0;
    BMS_HVBatSOC.msg.bits.BMS_HVBatProcssVol_L = 0x03;
    BMS_HVBatSOC.msg.bits.BMS_HVBatProcssVol_H = 0xE8;
    BMS_HVBatSOC.msg.bits.BMS_BatPckCrnt_L = 0x27;
    BMS_HVBatSOC.msg.bits.BMS_BatPckCrnt_H = 0xD8;

#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif     
} 
void Gear_R()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_GearboxPositionDisp = 0x9;
    BMS_ChargeStatus.msg.bits.BMS_ChargeStatus = 0x2;
    BMS_6.msg.bits.BMS_RemainingChargeTime_L = 0x0;
    BMS_6.msg.bits.BMS_RemainingChargeTime_H = 0xC8;
    AC_ExternalTemperature_C.msg.bits.AC_ExternalTemperature_C = 0x10;
    BMS_HVBatSOC.msg.bits.BMS_HVBatProcssVol_L = 0x03;
    BMS_HVBatSOC.msg.bits.BMS_HVBatProcssVol_H = 0xE8;
    BMS_HVBatSOC.msg.bits.BMS_BatPckCrnt_L = 0x30;
    BMS_HVBatSOC.msg.bits.BMS_BatPckCrnt_H = 0x70;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif     
} 
void Gear_N()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_GearboxPositionDisp = 0xA;
    BMS_ChargeStatus.msg.bits.BMS_ChargeStatus = 0x2;
    BMS_6.msg.bits.BMS_RemainingChargeTime_L = 0x01;
    BMS_6.msg.bits.BMS_RemainingChargeTime_H = 0xE8;
    AC_ExternalTemperature_C.msg.bits.AC_ExternalTemperature_C = 0x7E;
    BMS_HVBatSOC.msg.bits.BMS_HVBatProcssVol_L = 0x03;
    BMS_HVBatSOC.msg.bits.BMS_HVBatProcssVol_H = 0xE8;
    BMS_HVBatSOC.msg.bits.BMS_BatPckCrnt_L = 0x39;
    BMS_HVBatSOC.msg.bits.BMS_BatPckCrnt_H = 0x08;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif      
} 
void Gear_D()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_GearboxPositionDisp = 0x1;
    BMS_ChargeStatus.msg.bits.BMS_ChargeStatus = 0x2;
    BMS_6.msg.bits.BMS_RemainingChargeTime_L = 0x1;
    BMS_6.msg.bits.BMS_RemainingChargeTime_H = 0xD7;
    AC_ExternalTemperature_C.msg.bits.AC_ExternalTemperature_C = 0x6C;
    BMS_HVBatSOC.msg.bits.BMS_HVBatProcssVol_L = 0x03;
    BMS_HVBatSOC.msg.bits.BMS_HVBatProcssVol_H = 0xE8;
    BMS_HVBatSOC.msg.bits.BMS_BatPckCrnt_L = 0x41;
    BMS_HVBatSOC.msg.bits.BMS_BatPckCrnt_H = 0xA0;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif     
} 
void Gear_OUT()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_GearboxPositionDisp = 0x2;
    BMS_ChargeStatus.msg.bits.BMS_ChargeStatus = 0x2;
    BMS_6.msg.bits.BMS_RemainingChargeTime_L = 0x0;
    BMS_6.msg.bits.BMS_RemainingChargeTime_H = 0x0;
    AC_ExternalTemperature_C.msg.bits.AC_ExternalTemperature_C = 0x66;
    BMS_HVBatSOC.msg.bits.BMS_HVBatProcssVol_L = 0x1F;
    BMS_HVBatSOC.msg.bits.BMS_HVBatProcssVol_H = 0x40;
    BMS_HVBatSOC.msg.bits.BMS_BatPckCrnt_L = 0x1F;
    BMS_HVBatSOC.msg.bits.BMS_BatPckCrnt_H = 0x40;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif     
} 
// void SafetyBelt()
// {
// #if (CAN_2ND)
//      Port_SetPortPinLevel(0, 0, PortGpioHigh);
//    //  ACU14.msg.bits.CF_SWL_Ind = 0x0;//Air Bag on   ?
// #endif
// }
void PowerLimitDisp()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_PowerLimitDisp = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0x0; 
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x0;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x0; 
    DisPlayCurMotorSpds = 0;
    DisPlayCurSpeeds = 0;

#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif     
}

void SwitchFb()
{
#if (CAN_2ND)
    AVAS_SwitchFb.msg.bits.AVAS_SwitchFb = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0x85;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x98;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x0;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0xA0;
    DisPlayCurMotorSpds = 1100;
    DisPlayCurSpeeds = 11;

#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif     
}

void SmartSystemWarning()
{
#if (CAN_2ND)
    PEPS_1.msg.bits.PEPS_SmartSystemWarning_1_3 = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0x8E;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x30;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x01;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x50;
    DisPlayCurMotorSpds = 2200;
    DisPlayCurSpeeds = 22;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif     
}

void LHTurnlightSts()
{
#if (CAN_2ND)
    BCM_1_Door_Light.msg.bits.BCM_LHTurnlightSts = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0x96;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0xC8;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x02;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x0;
    DisPlayCurMotorSpds = 3300;
    DisPlayCurSpeeds = 33;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void HighBeamSts()
{
#if (CAN_2ND)
    BCM_1_Door_Light.msg.bits.BCM_HighBeamSts = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0x9F;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x60;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x02;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0xA0;
    DisPlayCurMotorSpds = 4400;
    DisPlayCurSpeeds = 44;

#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void DRLSts()
{
#if (CAN_2ND)
    BCM_1_Door_Light.msg.bits.BCM_DRLSts = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xA7;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0xF8;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x03;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x50;
    DisPlayCurMotorSpds = 5500;
    DisPlayCurSpeeds = 55;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}


void ParkLightSts()
{
#if (CAN_2ND)
    BCM_1_Door_Light.msg.bits.BCM_ParkLightSts = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xB0;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x90;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x04;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x0;
    DisPlayCurMotorSpds = 6600;
    DisPlayCurSpeeds = 66;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void RearFogLightSts()
{
#if (CAN_2ND)
    BCM_1_Door_Light.msg.bits.BCM_RearFogLightSts = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xB9;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x28;   
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x04;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0xA0;
    DisPlayCurMotorSpds = 7700;
    DisPlayCurSpeeds = 77;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void RegenerationLevelSts1()
{
#if (CAN_2ND)
    VCU_RegenerationLevelSts.msg.bits.VCU_RegenerationLevelSts = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xC1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0xC0;   
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x05;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x50;
    DisPlayCurMotorSpds = 8800;
    DisPlayCurSpeeds = 88;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void RegenerationLevelSts2()
{
#if (CAN_2ND)
    VCU_RegenerationLevelSts.msg.bits.VCU_RegenerationLevelSts = 0x2;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xCA;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x58;  
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x06;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x0;
    DisPlayCurMotorSpds = 9900;
    DisPlayCurSpeeds = 99;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void RegenerationLevelSts3()
{
#if (CAN_2ND)
    VCU_RegenerationLevelSts.msg.bits.VCU_RegenerationLevelSts = 0x3;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xD2;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0xF0;  
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x06;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x10;
    DisPlayCurMotorSpds = 11000;
    DisPlayCurSpeeds = 100;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void RHTurnlightSt()
{
#if (CAN_2ND)
    BCM_1_Door_Light.msg.bits.BCM_RHTurnlightSts = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xDA;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0xC0;  
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x06;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0xA0;
    DisPlayCurMotorSpds = 12000;
    DisPlayCurSpeeds = 110;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void BatTmpHiInd()
{
#if (CAN_2ND)
    BMS_6.msg.bits.BMS_BatTmpHiInd = 0x2;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xEA;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x60;  
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x07;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0xE0;
    DisPlayCurMotorSpds = 14000;
    DisPlayCurSpeeds = 130;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void LowSOCWarnLampSts()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_LowSOCWarnLampSts = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xF2;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x30;  
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x08;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x70;   
    DisPlayCurMotorSpds = 15000;
    DisPlayCurSpeeds = 140;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void ThermalCtrlWarning()
{
#if (CAN_2ND)
    BMS_6.msg.bits.BMS_ThermalCtrlWarning = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xFA;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x0;  
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x09;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x10;
    DisPlayCurMotorSpds = 16000;
    DisPlayCurSpeeds = 150;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void MotorTempWarning()
{
#if (CAN_2ND)
    MCU_MotorTempWarning.msg.bits.MCU_MotorTempWarning = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xFA;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x0;  
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x09;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0xB0;
    DisPlayCurMotorSpds = 16000;
    DisPlayCurSpeeds = 160;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void DCDCLVSysFltInd()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_DCDCLVSysFltInd = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xFA;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x0;  
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x09;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0xB0;
    DisPlayCurMotorSpds = 16000;
    DisPlayCurSpeeds = 160;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void ElectricDriveSysFaultDisp()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_ElectricDriveSysFaultDisp = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xFA;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x0;  
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x09;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0xB0;
    DisPlayCurMotorSpds = 16000;
    DisPlayCurSpeeds = 160;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void TirePressureSystemFailSts()
{
#if (CAN_2ND)
    TPMS_TirePressureSystemFailSts.msg.bits.TPMS_TirePressureSystemFailSts = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xFA;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x0;     
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x0A;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x50;
    DisPlayCurMotorSpds = 16000;
    DisPlayCurSpeeds = 170;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void SteeringAngleCalibrationSts()
{
#if (CAN_2ND)
    EPS_SteeringAngleCalibrationSts.msg.bits.EPS_EPSFailSts = 0x1;
    EPS_SteeringAngleCalibrationSts.msg.bits.EPS_SteeringAngleCalibrationSts = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xFA;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x0;  
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x0A;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0xE0;
    DisPlayCurMotorSpds = 16000;
    DisPlayCurSpeeds = 180;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void AuthFailWarn()
{
#if (CAN_2ND)
    IMMO_AuthFailWarn.msg.bits.IMMO_AuthFailWarn = 0x1;
    IMMO_AuthFailWarn.msg.bits.IMMO_AuthCodeWarn = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xFA;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x0;  
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x0B;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x80;
    DisPlayCurMotorSpds = 16000;
    DisPlayCurSpeeds = 190;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void SystemFaultDisp()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_SystemFaultDisp = 0x1;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0xFA;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_H = 0x0;  
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x0C;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x30;
    DisPlayCurMotorSpds = 16000;
    DisPlayCurSpeeds = 200;

#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void IsoResisLw()
{
#if (CAN_2ND)
    BMS_6.msg.bits.BMS_IsoResisLw = 0x2;
    MCU_MotorSpd.msg.bits.MCU_MotorSpd_L = 0; 
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_L = 0x0;
    ESP_ABS_FailSts.msg.bits.ESP_VehicleSpeedVSOSig_H = 0x0;
    DisPlayCurMotorSpds = 0;
    DisPlayCurSpeeds = 0;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L = 0x0 ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H = 0x0 ;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0x5;
    DisPlayCurPowers = 100;
    DisPlayCurElectricitys = 5;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}


void ReadySts()//Ready
{
#if (CAN_2ND)
    VCU_3_GearBrakePostion.msg.bits.VCU_ReadySts = 0x1;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L =0x14 ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H =0x0 ;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0xB;
    DisPlayCurPowers = 60;
    DisPlayCurElectricitys = 11;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void ECO()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_DriveMode_Disp = 0X1;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L =0x23 ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H =0x0 ;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0x16;
    DisPlayCurPowers = 30;
    DisPlayCurElectricitys = 22;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void ECOPlus()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_DriveMode_Disp = 0X0;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L =0x2A ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H =0x1 ;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0x21;
    DisPlayCurPowers = 15;
    DisPlayCurElectricitys = 33;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void NOR()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_DriveMode_Disp = 0X2;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L =0x32 ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H =0x0 ;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0x2C;
    DisPlayCurPowers = 0;
    DisPlayCurElectricitys = 44;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void SPT()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_DriveMode_Disp = 0X3;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L =0x37 ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H =0x1;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0x37;
    DisPlayCurPowers = 11;
    DisPlayCurElectricitys = 55;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void AirBagFailSts()
{
#if (CAN_2ND)
    ABM_AirBagFailSts.msg.bits.ABM_AirBagFailSts = 0x1;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L =0x3D ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H =0x0 ;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0x42;
    DisPlayCurPowers = 22;
    DisPlayCurElectricitys = 66;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void ABS_FailSts()
{
#if (CAN_2ND)
    ESP_ABS_FailSts.msg.bits.ESP_ABS_FailSts = 0x1;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L =0x42 ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H =0x1 ;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0x4D;
    DisPlayCurPowers = 33;
    DisPlayCurElectricitys = 77;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}


void DriverDoorSts()
{
#if (CAN_2ND)
    BCM_1_Door_Light.msg.bits.BCM_DriverDoorSts = 0x1;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L =0x48 ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H =0x0 ;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0x58;
    DisPlayCurPowers = 44;
    DisPlayCurElectricitys = 88;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}
void SmartSystemWarning_3_1()
{
#if (CAN_2ND)
    PEPS_1.msg.bits.PEPS_SmartSystemWarning_3_1 = 0x1;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L =0x4D ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H =0x1 ;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0x63;
    DisPlayCurPowers = 55;
    DisPlayCurElectricitys = 99;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void HVBatDiscWarn()
{
#if (CAN_2ND)
    BMS_6.msg.bits.BMS_HVBatDiscWarn = 0x1;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L =0x53 ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H =0x0 ;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0x64;
    DisPlayCurPowers = 66;
    DisPlayCurElectricitys = 100;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void PowerBattFaultDisp()
{
#if (CAN_2ND)
    VCU_4_ICMDisp.msg.bits.VCU_PowerBattFaultDisp = 0x1;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L =0x58 ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H =0x1 ;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0x64;
    DisPlayCurPowers = 77;
    DisPlayCurElectricitys = 100;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}

void VacuumPresWarn()
{
#if (CAN_2ND)
    VCU_3_GearBrakePostion.msg.bits.VCU_VacuumPresWarn = 0x1;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L =0x5E ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H =0x0 ;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0x64;
    DisPlayCurPowers = 88;
    DisPlayCurElectricitys = 100;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}
 
void ConnectSts()
{
#if (CAN_2ND)
    OBC_CC_ConnectSts.msg.bits.OBC_CC_ConnectSts = 0x1;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_L =0x64 ;
    VCU_PercentgPwrUsage.msg.bits.VCU_PercentgPwrUsage_H =0x0 ;
    BMS_HVBatSOC.msg.bits.BMS_HVBatSOC = 0x64;
    DisPlayCurPowers = 100;
    DisPlayCurElectricitys = 100;
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
#endif 
}


//��ǰ��/////////////////////
/////////////////////////////
////////////////////////////
// void SmartSystemWarning()
// {
// #if (CAN_2ND)
//     AVAS_SwitchFb.msg.bits.AVAS_SwitchFb = 0x1;
// #endif
// #if (CAN_3RD)   
//     AWD_01_20ms.AWD_ErrCodeVal = 0x1;           // 4WD DIAG
// #endif     
// }


void Four_WD_Lock()
{
#if (CAN_2ND)
    CAN_4WD11_.msg.bits.LOCK_ACT  = 0x1;        
#endif
#if (CAN_3RD)   
    AWD_01_20ms.AWD_OpModLkSta = 0x1;           // 4WD Lock
#endif     
} 


void ABS()
{
#if (CAN_2ND)
    TCS15.msg.bits.ABS_W_LAMP = 0x1;                //ABS
#endif
#if (CAN_3RD)   
    ABS_ESC_01_10ms.ABS_WrngLmpSta = 0x1;           //ABS
#endif 
}

uint8_t g_uiAirBagLedCheckFlag = 0;
void AirBag()
{
}


void AutoHoldGreen()
{
#if (CAN_2ND)
    TCS15.msg.bits.AVH_LAMP = 0x2;
#endif
#if (CAN_3RD)   
    ESC_01_10ms.AVH_LmpDis = 0x2;                           //AUTOHOLD  GREEN
#endif 
}

void AutoHoldWhite()
{
#if (CAN_2ND)
    TCS15.msg.bits.AVH_LAMP = 0x3;
#endif
#if (CAN_3RD)   
    ESC_01_10ms.AVH_LmpDis = 0x3;                           //AUTOHOLD  WHITE
#endif 
}

void AutoHoldYellow()
{
#if (CAN_2ND)
    TCS15.msg.bits.AVH_LAMP = 0x1;
#endif
#if (CAN_3RD)  
    ESC_01_10ms.AVH_LmpDis = 0x1;                           //AUTOHOLD  YELLOW
#endif    
}


void BatteryCharge()
{
#if (CAN_2ND)
    EMS19.msg.bits.BAT_LAMP_STAT = 0x1;             //��س�� Ӳ��
    HEV_PC2.msg.bits.CF_Ldc_AuxBatWrnLamp = 0x1;
#endif
#if (CAN_3RD)
    Port_SetPortPinLevel(0, 0, PortGpioHigh);           //Batter
    LDC_01_100ms.LDC_AuxBattWrnLmpReq =0x1;             //Batter Charge HEV/PHEV
    EMS_02_10ms.ENG_BattWrngLmpSta = 0x1;               //Batter Charge ICV
#endif 
}


void CheckEngine()
{
#if (CAN_2ND)
    CGW_PC2.msg.bits.L_MIL = 0x1;                   //���?����
    HEV_PC2.msg.bits.CF_Ems_MilReq = 0x1;
#endif
#if (CAN_3RD)   
    EMS_08_100ms.HEV_MilReq = 0x1;
    OBC_01_100ms.OBC_MilReq = 0x1;
#if (PRO_SG2)
#else
    EMS_05_100ms.ENG_MilSta = 0x1;                         //Check Engine
    EMS_08_100ms.HEV_MilReq = 0x1;
#endif
#endif 
}

void DAW_Blink()
{
#if (CAN_2ND)
#if (PRO_CN7C)
    LKA12.msg.bits.CF_DAW_Status = 0x6;
    LKA12.msg.bits.CF_DAW_Opt_USM_NEW = 0x1;
#else
    LKA12.msg.bits.CF_DAW_Status = 0x6;
#endif
#endif
#if (CAN_3RD)   
    FR_CMR_01_10ms.DAW_SysSta = 0x6;
#endif 
}


void DpfGpf()
{
#if (CAN_2ND)
    HEV_PC11.msg.bits.GPF_LAMP_STAT = 0x1;
    EMS19.msg.bits.DPF_LAMP_STAT = 0x1;             //DPF
    //����Ӳ�� Water separator������
#endif
#if (CAN_3RD)   
    EMS_02_10ms.ENG_DpfWrngSta = 0x1;                       //DPF &GPF
    EMS_11_10ms.HEV_GPF_WrnLamp = 0x1;
#endif 
}

void GreenZoneLamp()
{
#if (CAN_2ND)
    HEV_PC9.msg.bits.CF_Hcu_GreenZoneLamp = 0x1;
#endif
#if (CAN_3RD)   
    HCU_03_10ms.HCU_GreenZoneLmpDis = 0x1;
#endif 
}

void Ecall()
{
#if (CAN_2ND)
    ECALL_CLU_PE_01.eCall_SWL_Ind = 0x1;             //Ecall
#endif
#if (CAN_3RD)   
    ECALL_CLU_PE_01.eCall_SWL_Ind = 0x1;
#endif 
}

void FrontFog()
{
#if (CAN_2ND)
    CGW1.msg.bits.CF_Gway_Frt_Fog_Act = 0x1;         //ǰ���� 
    CGW2.msg.bits.CF_Gway_ExtTailAct = 0x1;         //ǰ���� 
#endif
#if (CAN_3RD)
    ICU_04_200ms.ExtLamp_FrFgLmpSta = 0x1;
    ICU_04_200ms.ExtLamp_ExtrnlTailLmpSta = 0x1;
#endif 
}

void EPB()
{
#if (CAN_2ND)
    EPB11.msg.bits.EPB_F_LAMP = 0x1;                //EPB
#endif
#if (CAN_3RD)   
    EPB_01_50ms.EPB_FlrLmpStaDis  = 0x1;                    //EPB
#endif 
}

void ESC()
{
#if (CAN_2ND)
    TCS15.msg.bits.TCS_LAMP = 0x1;                  //ESC
#endif
#if (CAN_3RD)   
    ESC_01_10ms.TCS_LmpSta  = 0x1;                          //ESC
#endif 
}

void EscOff()
{
#if (CAN_2ND)
    TCS15.msg.bits.TCS_OFF_LAMP = 0x1;              //ESC OFF
#endif
#if (CAN_3RD)   
    ESC_01_10ms.TCS_OffLmpSta = 0x1;                        //ESC OFF
#endif 
}

void EV_MODE()
{
#if (CAN_2ND)
    HEV_PC1.msg.bits.CR_Hcu_HevMod = 0x1;
    HEV_PC4.msg.bits.CF_Hcu_HevRdy = 0x1;
    HEV_PC1.msg.bits.CR_Hcu_HevMod = 0x2;
    HEV_PC1.msg.bits.CR_Hcu_HevMod = 0x6;
#endif
#if (CAN_3RD)   
    HCU_03_10ms.HCU_HevRdySta = 0x1;                        //EV MODE
    HCU_05_100ms.HCU_HevSysModSta = 0x1;
    HCU_05_100ms.HCU_HevSysModSta = 0x2;
    HCU_05_100ms.HCU_HevSysModSta = 0x6;
#endif     
}

void FcaYellow()
{
#if (CAN_2ND)
#if ((PRO_ONPE) || (PRO_LX2))
    FCA12.msg.bits.FCA_USM = 0x1;
    ADAS_CMD_10_2_200ms.msg.bits.FCA_OnOffEquipSta = 0x1;
    //ADAS_CMD_10_2_200ms.msg.bits.FCA_Regulation = 0x0;
#elif ((PRO_SP2C_PE) || (PRO_BC3) || (PRO_DL3C))
    FCA12.msg.bits.FCA_FrOnOffEquipSta =0x1;
    FCA12.msg.bits.FCA_Regulation = 0x1;
#elif (PRO_AC3_PE)
    FCA12.msg.bits.FCA_USM = 0x1;
    FCA12.msg.bits.FCA_Regulation = 0x1;
    FCA12.msg.bits.FCA_FrOnOffEquipSta =0x1;
#else
    FCA12.msg.bits.FCA_USM = 0x1;
    FCA12.msg.bits.FCA_Regulation = 0x1;
    //FCA11.msg.bits.FCA_Failinfo = 0x1;
#endif    
#endif
#if (CAN_3RD)
#if ((PRO_NQ5C) || (PRO_NQ5) || (PRO_GL3) || (PRO_NX4C))
    ADAS_CMD_10_20ms.FCA_SysFlrSta = 0x0;
    ADAS_CMD_10_20ms.FCA_OnOffEquipSta = 0x7;
#else    
    ADAS_CMD_10_20ms.FCA_OnOffEquipSta = 0x0;
    ADAS_CMD_10_20ms.FCA_Regulation = 0x1;
#endif
#endif
}

void FcaRed()
{
#if (CAN_2ND)

#if ((PRO_ONPE) || (PRO_LX2))
    FCA12.msg.bits.FCA_USM = 0x1;
    ADAS_CMD_10_2_200ms.msg.bits.FCA_OnOffEquipSta = 0x0;
    ADAS_CMD_10_2_200ms.msg.bits.FCA_Regulation = 0x2;
#elif ((PRO_SP2C_PE) || (PRO_BC3))
    FCA12.msg.bits.FCA_FrOnOffEquipSta =0x1;
    FCA12.msg.bits.FCA_Regulation = 0x2;
#else
    FCA12.msg.bits.FCA_USM = 0x0;
    FCA12.msg.bits.FCA_Regulation = 0x2;
#endif 
#endif
#if (CAN_3RD)   
    ADAS_CMD_10_20ms.FCA_OnOffEquipSta = 0x0;
    ADAS_CMD_10_20ms.FCA_Regulation = 0x2;
#endif 
}
//DMS==================================


void HBAGreen()
{
#if (CAN_2ND)
#if ((PRO_ONPE) || (PRO_LX2))
    FR_CMR_01_1_20ms.msg.bits.HBA_SysOptSta = 0x1;
    FR_CMR_01_1_20ms.msg.bits.HBA_IndLmpReq = 0x1;
#else
    LKA11.msg.bits.CF_HBA_Opt = 0x1;
    LKA11.msg.bits.CF_HBA_Lamp = 0x1;
#endif
#endif
#if (CAN_3RD)   
    FR_CMR_01_10ms.HBA_IndLmpReq = 0x1;                     //HBA
    FR_CMR_01_10ms.HBA_SysOptSta = 0x1;                     //HBAʹ��
#endif     
}

void HBAWhite()
{
#if (CAN_2ND)
#if ((PRO_ONPE) || (PRO_LX2))// 2.5 CAN
    FR_CMR_01_1_20ms.msg.bits.HBA_SysOptSta = 0x1;
    FR_CMR_01_1_20ms.msg.bits.HBA_IndLmpReq = 0x0;
    FR_CMR_01_1_20ms.msg.bits.HBA_IndLmpReq_New = 0x1;
#else// 2 CAN
    LKA11.msg.bits.CF_HBA_Opt = 0x1;
    LKA11.msg.bits.CF_HBA_Lamp = 0x0;
    LKA11.msg.bits.CF_HBA_Lamp_New = 0x1;
#endif
#endif
#if (CAN_3RD)   
    FR_CMR_01_10ms.HBA_IndLmpReq = 0x2;                     //HBA
    FR_CMR_01_10ms.HBA_SysOptSta = 0x1;                     //HBAʹ��
#endif    
}

uint8_t g_uiLPI_OnlyCheckFlag = 0;
uint8_t g_uiLPI_CheckFlag = 0;
void LPI_Only()
{ 
    g_uiLPI_CheckFlag = 1;
    g_uiLPI_OnlyCheckFlag = 1;
    g_uiLowFuelLedCheckFlag = 0;
    SetPressKeySequence(KEY_30,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(DMS_PREPARE_TIME);
#if (CAN_2ND)
#endif
#if (CAN_3RD)   
    EMS_02_10ms.ENG_LV_FUP_ENA_THD = 0x0;
#endif  
}

uint8_t g_uiLPI_OverCheckFlag = 0;
void LPI_Over()
{
    g_uiLPI_OverCheckFlag = 1;//LPI�����?����
    g_uiLowFuelLedCheckFlag = 2;
    SetPressKeySequence(KEY_30,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(DMS_PREPARE_TIME);
#if (CAN_2ND)
    CGW2.msg.bits.CF_Gway_ICUPowerAutoCutMode=0x0; //����ģʽ
#endif
#if (CAN_3RD)   
    ICU_08_200ms.ICU_PowerAutoCutModSta = 0x0;//����ģʽ
#endif  
}

void HighBeam()
{
#if (CAN_2ND)
    CGW1.msg.bits.CF_Gway_HeadLampHigh=0x1;         //Զ���? 
#endif
#if (CAN_3RD)
#if (PRO_NQ5)
    ICU_07_200ms.Lamp_HdLmpHiSta = 0x1;                     //HIGH_Beam
    BCM_07_200ms.Lamp_HdLmpHiOnReq = 0x1;
#else
    ICU_07_200ms.Lamp_HdLmpHiSta = 0x1; 
#endif 
#endif    
}

void HIGH_TEMP()
{
#if (CAN_2ND)
    HEV_PC1.msg.bits.CF_Ems_EHRSTemp = 0x1;
#endif
#if (CAN_3RD)   
    EMS_08_100ms.HEV_EhrsTempSta = 0x1;                     //HIGH_TEMP
#endif    
}

void Immobilizer()
{
#if (CAN_2ND)
    CGW2.msg.bits.CF_Gway_ImmoLp=0x1;               //IMMOBILIZER ������
#endif
#if (CAN_3RD)   
    SMK_04_200ms.Warn_ImmoLmpOnReq = 0x1;                   //IMMOBILIZER
#endif 
}
uint8_t g_uiISGLedCheckFlag = 0;
void IsgGreen()
{
    g_uiISGLedCheckFlag = 1;
#if (CAN_2ND)
    CGW_PC12.CF_Ems_ISG_Equipped = 0x01;
    CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x1;          //ISG ��
    CGW_PC5.msg.bits.CF_Ems_IsgStat2 = 0x0;         
#endif
#if (CAN_3RD)   
    //EMS_05_100ms.ENG_IsgEquipped = 0x1;
    EMS_01_10ms.ENG_IsgSta = 0x1;
    EMS_01_10ms.ENG_Isg2Sta = 0x0;
#endif 
}

void IsgYellow()
{
    g_uiISGLedCheckFlag = 1;
#if (CAN_2ND)
    CGW_PC12.CF_Ems_ISG_Equipped = 0x01;
    CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x4;          //ISG ��
    CGW_PC5.msg.bits.CF_Ems_IsgStat2 = 0x0;        
#endif
#if (CAN_3RD)   
    EMS_01_10ms.ENG_IsgSta = 0x4;
    EMS_01_10ms.ENG_Isg2Sta = 0x0;
#endif 
}

void IsgWhite()
{
    g_uiISGLedCheckFlag = 1;
#if (CAN_2ND)
    CGW_PC12.CF_Ems_ISG_Equipped = 0x1;
    CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x5;          //ISG ��
    CGW_PC5.msg.bits.CF_Ems_IsgStat2 = 0x0;         
#endif
#if (CAN_3RD)   
    EMS_01_10ms.ENG_IsgSta = 0x5;
    EMS_01_10ms.ENG_Isg2Sta = 0x0;
#endif 
}

void IsgGray()
{
    g_uiISGLedCheckFlag = 1;
#if (CAN_2ND)
    CGW_PC12.CF_Ems_ISG_Equipped = 0x01;
    CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x5;          //ISG ��
    CGW_PC5.msg.bits.CF_Ems_IsgStat2 = 0x0;         
#endif
#if (CAN_3RD)   
    EMS_01_10ms.ENG_IsgSta = 0x5;
    EMS_01_10ms.ENG_Isg2Sta = 0x0;
#endif 
}

//LKA  Gray
void LdwLkaGray()
{
#if (CAN_2ND)
#if ((PRO_ONPE) || (PRO_LX2))
    ADAS_CMD_30_1_10ms.msg.bits.LKA_SysIndReq = 0x1;
#else
    LKA11.msg.bits.CF_LKA_SymbolState = 0x1;
#endif
#endif
#if (CAN_3RD)   
    ADAS_CMD_30_10ms.LKA_SysIndReq = 0x1;                   
#endif 
}
//LKA  GREEN
void LdwLkaGreen()
{
#if (CAN_2ND)
#if ((PRO_ONPE) || (PRO_LX2))
    ADAS_CMD_30_1_10ms.msg.bits.LKA_SysIndReq = 0x2;
#else
    LKA11.msg.bits.CF_LKA_SymbolState = 0x2;
#endif
#endif
#if (CAN_3RD)   
    ADAS_CMD_30_10ms.LKA_SysIndReq = 0x2;                   
#endif 
}
 //LKA  White
void LdwLkaWhite()
{
#if (CAN_2ND)
#if ((PRO_ONPE) || (PRO_LX2))
    ADAS_CMD_30_1_10ms.msg.bits.LKA_SysIndReq = 0x1;
#else
    LKA11.msg.bits.CF_LKA_SymbolState = 0x1; 
#endif
#endif
#if (CAN_3RD)   
    ADAS_CMD_30_10ms.LKA_SysIndReq = 0x1;                  
#endif
}
//LKA  YELLOW
void LdwLkaYellow()
{
#if (CAN_2ND)
#if ((PRO_ONPE) || (PRO_LX2))
    ADAS_CMD_30_1_10ms.msg.bits.LKA_SysIndReq = 0x4;
#else
    LKA11.msg.bits.CF_LKA_SymbolState = 0x4;
#endif
#endif
#if (CAN_3RD)   
    ADAS_CMD_30_10ms.LKA_SysIndReq = 0x4;                   
#endif 
}

void LfaHdaGray()
{
#if (CAN_2ND)
#if ((PRO_ONPE) || (PRO_LX2))
    ADAS_CMD_31_1_50ms.msg.bits.HDA_LFA_SymSta = 0x1;
#else
    HDA11.msg.bits.CF_HDA_LFA_SymbolState = 0x1;
#endif
#endif
#if (CAN_3RD)   
    ADAS_CMD_31_50ms.HDA_LFA_SymSta = 0x1;                  //HDA gray
#endif 
}

void LfaHdaGreen()
{
#if (CAN_2ND)
#if ((PRO_ONPE) || (PRO_LX2))
    ADAS_CMD_31_1_50ms.msg.bits.HDA_LFA_SymSta = 0x2;
#else
    HDA11.msg.bits.CF_HDA_LFA_SymbolState = 0x2;
#endif
#endif
#if (CAN_3RD)   
    ADAS_CMD_31_50ms.HDA_LFA_SymSta = 0x2;                  //HDA GREEN
#endif 
}

void LfaHdaWhite()
{
#if (CAN_2ND)
#if ((PRO_ONPE) || (PRO_LX2))
    ADAS_CMD_31_1_50ms.msg.bits.HDA_LFA_SymSta = 0x3;
#else
    HDA11.msg.bits.CF_HDA_LFA_SymbolState = 0x3;
#endif
#endif
#if (CAN_3RD)   
#if (PRO_NX4C)
    ADAS_CMD_31_50ms.HDA_LFA_SymSta = 0x1;
#else
    ADAS_CMD_31_50ms.HDA_LFA_SymSta = 0x3;                  //HDA WHITE
#endif
#endif 
}

void LowBeam()
{
#if (CAN_2ND)
    CGW2.msg.bits.CF_Gway_ExtTailAct = 0x1;         //λ�õ�
    CGW1.msg.bits.CF_Gway_HeadLampHigh = 0x0;
    CGW1.msg.bits.CF_Gway_HeadLampLow = 0x1;        //�����?  
#endif
#if (CAN_3RD)
#if (PRO_NQ5)
    BCM_07_200ms.Lamp_HdLmpHiOnReq = 0x0;
    BCM_07_200ms.Lamp_HdLmpLoOnReq = 0x1;
    ICU_04_200ms.ExtLamp_ExtrnlTailLmpSta = 0x1;
    ICU_07_200ms.Lamp_HdLmpHiSta = 0x0;
    ICU_07_200ms.Lamp_HdLmpLoSta = 0x1;                     //LOW Beam
#else
    ICU_04_200ms.ExtLamp_ExtrnlTailLmpSta = 0x1;
    ICU_07_200ms.Lamp_HdLmpHiSta = 0x0;
    ICU_07_200ms.Lamp_HdLmpLoSta = 0x1;                     //LOW Beam
#endif 
#endif 
}
uint8_t g_uiLowFuelLedCheckFlag = 0;
void LowFuel(uint8_t uiFlag)
{
    g_uiLowFuelLedCheckFlag = uiFlag;
}

void MasterSymbol()
{
    //LampState_L.Lamps.RELAY_IGN1 = 1;
#if (CAN_2ND)
#if (PRO_KU)
    BCW11.msg.bits.CF_BCW_Stat = 0x3;
    g_uiBCWFlag = 1;
#else
    TPMS11.msg.bits.TREAD_W_LAMP = 0x1;             //Master
#endif
#endif
#if (CAN_3RD)       
#if (PRO_NX4C)
    RR_C_RDR_02_50ms.BCA_Sta = 0x4;
#else
    TPMS_01_200ms.TPMS_TreadWrngLmpSta = 0x1;       //Master
#endif
#endif 
}

void Mdps()
{
#if (CAN_2ND)
    MDPS11.msg.bits.CF_Mdps_WLmp = 0x2;             //MDPS 
#endif
#if (CAN_3RD)   
    MDPS_01_10ms.MDPS_WrngLmpSta = 0x2;                     //MDPS
#endif 
}
uint8_t g_uiOilPressureCheckFlag = 0;
void OilPressure()
{
    g_uiOilPressureCheckFlag = 1;
#if (CAN_2ND)
    //EMS19.msg.bits.BAT_LAMP_STAT = 0x1;
    EMS19.msg.bits.CF_Ems_OPSFail = 0x1;            //����ѹ��       
    //CGW_PC12.CF_Ems_ISG_Equipped = 0x01;
    //CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x4; 
    //CGW_PC5.msg.bits.CF_Ems_IsgStat2 = 0x1;
    HEV_PC11.msg.bits.CF_Ems_OPSFail = 0x1;
#endif
#if (CAN_3RD)   
    EMS_02_10ms.ENG_OilPrsrWrngLmpSta = 0x1;                //Oil pressure  ICV
    
    //EMS_07_10ms.HEV_EngOpSta = 0x2;
    EMS_08_100ms.HEV_OPSFail = 0x1;//Oil pressure  HEV
    //HCU_03_10ms.HCU_HevRdySta = 0x1;
#endif 
}

void ParkingBreak()
{
#if (CAN_2ND)
#if (PRO_KU)
    EVP11.CF_Evp_Stat = 0x1;
    EPB11.msg.bits.EPB_I_LAMP = 0x1;
    CGW2.msg.bits.CF_Gway_BrakeFluidSw = 0x1;
#elif (PRO_CN7)
    TCS15.msg.bits.EBD_W_LAMP = 0x1;                //פ���ƶ�������
    CGW2.msg.bits.CF_Gway_BrakeFluidSw = 0x1;
    EPB11.msg.bits.EPB_I_LAMP = 0x1;
    CGW1.msg.bits.CF_Gway_ParkBrakeSw = 0x1;
    ABS11.msg.bits.EBD_W_LAMP = 0x1;
    EVP11.CF_Evp_Stat = 0x1;
#else
    TCS15.msg.bits.EBD_W_LAMP = 0x1;                //פ���ƶ�������
    CGW2.msg.bits.CF_Gway_BrakeFluidSw = 0x1;
    EPB11.msg.bits.EPB_I_LAMP = 0x1;
    CGW1.msg.bits.CF_Gway_ParkBrakeSw = 0x1;
    ABS11.msg.bits.EBD_W_LAMP = 0x1;
  //  EVP11.CF_Evp_Stat = 0x1;
#endif
#endif
#if (CAN_3RD)   
    ICU_02_200ms.Warn_BrkFldSwSta = 0x1;                    //Parking break;
#endif 
}

void RBS()
{
#if (CAN_2ND)
    HEV_PC4.msg.bits.CF_Brk_RBSWLamp = 0x1;
#endif
#if (CAN_3RD)   
    IEB_01_10ms.IEB_RbsWrngLmpSta = 0x1;                    //RBS;
#endif 
}

void READY()
{
#if (CAN_2ND)
    HEV_PC11.msg.bits.CF_Hcu_HevRdyClu_new = 0x1;
#endif
#if (CAN_3RD)   
    HCU_03_10ms.HCU_HEVRdyDis = 0x1;
    HCU_03_10ms.HCU_HEVRdyDis = 0x3;                                   //READY;
#endif    
}

void RearFog()
{
#if (CAN_2ND)
    CGW2.msg.bits.CF_Gway_RearFogAct = 0x1;         //������ 
#endif
#if (CAN_3RD)   
    ICU_04_200ms.ExtLamp_RrFgLmpSta = 0x1;                  //Rear FOG
#endif 
}

void RSBR()
{
#if (CAN_3RD)   
    BCM_03_200ms.SBR_RrLftStBltWrngIndSta = 0x1;                  //RSBR
    BCM_03_200ms.SBR_RrCtrStBltIndSta = 0x1;
    BCM_03_200ms.SBR_RrRtStBltWrngIndSta = 0x1;
#endif     
}

void SeatBelt()
{
#if (CAN_2ND)
    CGW4.msg.bits.CF_Gway_DrvSeatBeltIND = 0x2;
    CGW7.msg.bits.CF_Gway_DrvSeatBeltInd = 0x2;
#endif
#if (CAN_3RD)   
    BCM_03_200ms.SBR_DrvStBltIndSta = 0x1;                  //Seat balt
#endif 
}

void ServiceLamp()
{
#if (CAN_2ND)
    HEV_PC1.msg.bits.CF_Hcu_SerLamp = 0x1;
    HEV_PC2.msg.bits.CF_Bms_ServiceLamp = 0x1;
    HEV_PC2.msg.bits.CF_Ldc_Srvlamp_Rqst = 0x1;
    HEV_PC2.msg.bits.CF_Tcu_ServiceLamp = 0x1;
#endif
#if (CAN_3RD)   
    HCU_05_100ms.HCU_SrvLmpDis = 0x1;                  //ServiceLamp
    BMS_02_100ms.xEV_SrvLmpReq = 0x1;
    LDC_01_100ms.LDC_SrvLmpReq = 0x1;
    HTCU_07_100ms.HTCU_SrvLmpReq = 0x1;
#endif    
}

void TailLamp()
{
#if (CAN_2ND)
    CGW2.msg.bits.CF_Gway_ExtTailAct = 0x1;         //λ�õ�
#endif
#if (CAN_3RD)   
    ICU_04_200ms.ExtLamp_ExtrnlTailLmpSta = 0x1;
#endif 
}

void Tpms()
{
#if (CAN_2ND)
    TPMS11.msg.bits.TPMS_W_LAMP = 0x0;              //̥ѹ��
    TPMS11.msg.bits.TREAD_W_LAMP = 0x1;             //Master
#if (PRO_DL3C)
    TPMS11.msg.bits.STATUS_TPMS = 0x2;
#endif
#endif
#if (CAN_3RD)   
    TPMS_01_200ms.TPMS_TreadWrngLmpSta = 0x1;               //TPMS
#endif 
}

void LeftTurn()
{
#if (CAN_2ND)
    CGW1.msg.bits.CF_Gway_TurnSigLh = 0x1;          //��ת��
#endif
#if (CAN_3RD)   
    ICU_04_200ms.ExtLamp_TrnSigLmpLftBlnkngSta = 0x1;
#endif
}

void RightTurn()
{
#if (CAN_2ND)
    CGW1.msg.bits.CF_Gway_TurnSigRh = 0x1;          //��ת��
#endif
#if (CAN_3RD)   
    ICU_04_200ms.ExtLamp_TrnSigLmpRtBlnkngSta = 0x1;
#endif 
}

void ISLA()
{
#if (CAN_2ND)
#if ((PRO_ONPE) || (PRO_LX2))
    FR_CMR_02_1_100ms.msg.bits.ISLW_SysSta = 0x2;
    FR_CMR_02_1_100ms.msg.bits.ISLA_OptUsmSta = 0x1;
#else
    LKA13.msg.bits.ISLA_OptUsmSta = 0x1;
    LKA12.msg.bits.CF_ISLW_Status = 0x1;
#endif
#endif
#if (CAN_3RD)   
    FR_CMR_02_100ms.ISLA_OptUsmSta = 0x1;
    FR_CMR_02_100ms.ISLW_SysSta = 0x1;
#endif 
}

uint8_t g_uiIceWarningLedCheckFlag = 0;
void IceWarning()
{
	g_uiIceWarningLedCheckFlag = 1;
#if (CAN_2ND)
#endif
#if (CAN_3RD)   
#endif 
}

void DBCGreen()
{
#if (CAN_2ND)
    TCS15.msg.bits.DBC_F_LAMP = 0x1;
#endif
#if (CAN_3RD)
#if ((PRO_NQ5) || (PRO_NX4C))
    ESC_01_10ms.DBC_FuncLmpSta = 0x1;
    ESC_01_10ms.DBC_Sta = 0x1;
#else
    ESC_01_10ms.DBC_FuncLmpSta = 0x1;
#endif 
#endif 
}

void DBCYellow()
{
#if (CAN_2ND)
    TCS15.msg.bits.DBC_W_LAMP = 0x1;
#endif
#if (CAN_3RD)
#if ((PRO_NQ5) || (PRO_NX4C))
    ESC_01_10ms.DBC_WrngLmpSta = 0x1;
    ESC_01_10ms.DBC_Sta = 0x1;
#else
    ESC_01_10ms.DBC_WrngLmpSta = 0x1;
#endif 
#endif 
}

uint8_t g_uiRSBRFlag = 0;
void RSBR_Red()
{
    g_uiRSBRFlag = 1;
#if (CAN_2ND)
#if (PRO_CN7C)
    CGW7.msg.bits.CF_Gway_RLSeatBeltInd = 0x2;
    CGW7.msg.bits.CF_Gway_RCSeatBeltInd = 0x2;
    CGW7.msg.bits.CF_Gway_RRSeatBeltInd = 0x2;
#elif (PRO_QYC)
    CGW4.msg.bits.CF_Gway_RLSeatBeltIND = 0x2;
    CGW4.msg.bits.CF_Gway_RCSeatBeltIND = 0x2;
    CGW4.msg.bits.CF_Gway_RRSeatBeltIND = 0x2;
#else
    CGW7.msg.bits.CF_Gway_RLSeatBeltInd = 0x2;
    CGW7.msg.bits.CF_Gway_RCSeatBeltInd = 0x2;
    CGW7.msg.bits.CF_Gway_RRSeatBeltInd = 0x2;
#endif
#endif
#if (CAN_3RD)    
    BCM_03_200ms.SBR_RrLftStBltWrngIndSta = 0x1;
    BCM_03_200ms.SBR_RrCtrStBltIndSta     = 0x1;
    BCM_03_200ms.SBR_RrRtStBltWrngIndSta  = 0x1;
#endif 
}

void LedLampFail()
{
#if (CAN_2ND)
    CGW5.msg.bits.CF_Afs_LedHLStat = 0x2;   
#endif
#if (CAN_3RD)
#if (PRO_NQ5)
    ILCU_RH_01_200ms.ILCURH_LowBeamLED_Sta = 0x1;
    ILCU_LH_01_200ms.ILCULH_LowBeamLED_Sta = 0x1;
    ILCU_RH_01_200ms.ILCURH_IFSOpt_Sta = 0x0;
    ICU_04_200ms.Lamp_LedHdLmpSta = 0x2;
#else
    ILCU_RH_01_200ms.ILCURH_IFSOpt_Sta = 0x0;
    ICU_04_200ms.Lamp_LedHdLmpSta = 0x2;
#endif
#endif 
}

void OverSpeed()
{
#if (CAN_2ND)
     WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1680;//����180
     WHL_SPD11.msg.bits.WHL_SPD_RL = 0x1680;//����180
#endif
#if (CAN_3RD)
     WHL_01_10ms.WHL_SpdFLVal = 0x1680;//����180
     WHL_01_10ms.WHL_SpdRLVal = 0x1680;//����180
#endif
}

void Glow()
{
#if (CAN_2ND)
    EMS16.msg.bits.GLOW_STAT = 0x1;   
#endif
#if (CAN_3RD)
    EMS_02_10ms.ENG_GlowLmpSta = 0x1;
#endif 
}

void SCR()
{
#if (CAN_2ND)
    EMS21.msg.bits.SCR_LEVEL_WARN_LAMP = 0x1;   
#endif
#if (CAN_3RD)
    EMS_05_100ms.SCR_UreaLvlSta = 0x1;
    EMS_05_100ms.SCR_LvlWrngLmpSta = 0x1;
#endif 
}

uint8_t g_uiWaterSaperatorLedCheckFlag = 0;
void WaterSaperator()
{
    g_uiWaterSaperatorLedCheckFlag = 1;
#if (CAN_2ND)
    Port_SetPortPinLevel(2, 1, PortGpioHigh);           //WaterSeparator
#endif
#if (CAN_3RD) 
    Port_SetPortPinLevel(2, 1, PortGpioHigh);           //WaterSeparator
#endif 
}

void TOW()//DSL
{
#if (CAN_2ND)                                               //TOW
    RCS1.msg.bits.CF_RCS_Towmode = 0x2;
    RCS1.msg.bits.CF_RCS_SwTyp   = 0x1;
#endif
#if (CAN_3RD)   
#endif 
}

void HotLamp()
{
#if (CAN_2ND)                                               //HotLamp
    EMS12.msg.bits.TEMP_ENG = 0xFF;
#endif
#if (CAN_3RD)   
#endif 
}

void CngFailure()
{
#if (CAN_2ND)                                               //CngFailure
    EMS_CNG11.msg.bits.CNG_SYS_Flag = 2; 
#endif
#if (CAN_3RD)   
#endif 
}

void LowCNG()
{
#if (CAN_2ND)                                               //LowCNG
    EMS_CNG11.msg.bits.CNG_FTL = 0x0; 
#endif
#if (CAN_3RD)   
#endif 
}

void FuleModeCHG()
{
#if (CAN_2ND)                                               //FuleModeCHG
    EMS_CNG11.msg.bits.CNG_EOM = 0x1; 
#endif
#if (CAN_3RD)   
#endif 
}

void FuleModePETROL()
{
#if (CAN_2ND)                                               //FuleModePETROL
    EMS_CNG11.msg.bits.CNG_EOM = 0x2;
#endif
#if (CAN_3RD)   
#endif 
}

void AFS()
{
#if (CAN_3RD)                                     //AFS
    ILCU_LH_01_200ms.ILCULH_IFSWarning_Sta = 0x2;
    ILCU_LH_01_200ms.ILCU_LH_Crc1Val = 0x1;
    ILCU_LH_01_200ms.ILCU_LH_AlvCnt1Val = 0x1;
    ILCU_LH_01_200ms.ILCULH_IFSOpt_Sta = 0x1;
    ILCU_RH_01_200ms.ILCURH_IFSOpt_Sta = 0x1;
#endif 
}

void MPH()
{
#if (CAN_2ND)
    HU_MON_PE_01.HU_OptionInfo_L = 0x2;
    HU_MON_PE_01.HU_Type = 0x60; 
    HU_GW_PE_01.HU_DistanceUnit = 0x1;
#endif
#if (CAN_3RD)
    HU_MON_PE_01.HU_OptionInfo = 0x2;
    HU_MON_PE_01.HU_Type = 0x60; 
    HU_GW_PE_01.HU_DistanceUnit = 0x1;
#endif
}

void EV_Plus()
{
#if (CAN_2ND)
#endif
#if (CAN_3RD)   
    HCU_05_100ms.HCU_PhevMod = 0x3;
#endif 
}

void HEV()
{
#if (CAN_2ND)
#endif
#if (CAN_3RD)   
    HCU_05_100ms.HCU_PhevMod = 0x1;
#endif 
}

void AUTO()
{
#if (CAN_2ND)
#endif
#if (CAN_3RD)   
    HCU_05_100ms.HCU_PhevMod = 0x2;
#endif 
}

void ExternalChargeCable()
{
 //LampState_L.Lamps.RELAY_IGN3 = 1;
#if (CAN_2ND)
#endif
#if (CAN_3RD)   
    OBC_01_100ms.OBC_AcConnSta = 0x1;
#endif 
}

void KEYOUT()
{
#if (CAN_2ND)
    CGW2.msg.bits.CF_Gway_KeyoutLp = 0x1;
#endif
#if (CAN_3RD)   
#endif 
}

void SunroofOpen()
{
#if (CAN_2ND)
    CGW1.msg.bits.C_SunRoofOpenState = 0x1;
    
#endif
#if (CAN_3RD)   
#endif 
}
void LedLampNotUse()
{
#if (CAN_2ND)
#endif
#if (CAN_3RD)   
#endif 
}

void SingleSegmentCodeLED()
{
    switch(InteriorLampTimer) {
        case 1:
            HBAGreen();
            break;
        case 2:
            HBAWhite();
            break;
    }
    LeftTurn();
    RightTurn();
    HighBeam();
    EPB();
    ParkingBreak();
    ABS();
    ESC();
    DpfGpf();
    BatteryCharge();
    CheckEngine();
    Mdps();
}

void DoubleSegmentCodeLED()
{
    switch(InteriorLampTimer) {
        case 1:
            DBCGreen();
            FcaYellow();
            break;
        case 2:
            DBCYellow();
            FcaRed();
            break;
    }
    LowBeam();
    RearFog();
    TailLamp();
    SeatBelt();
    EscOff();
    Immobilizer();
    Tpms();
    MasterSymbol();
    AirBag();
    OilPressure();
}
void AllLedOpen()
{
    LedCurrent.statu = FINISH;
            
    Send_7C6_Data.msg.bits.Byte0Data = 0x02;
    Send_7C6_Data.msg.bits.Byte1Data = 0x10;
    Send_7C6_Data.msg.bits.Byte2Data = 0x03;  
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_43, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3);
             
    Delay(5);//5ms
    Send_7C6_Data.msg.bits.Byte0Data = 0x04;
    Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
    Send_7C6_Data.msg.bits.Byte2Data = 0xB0;  
    Send_7C6_Data.msg.bits.Byte3Data = 0x01;
    Send_7C6_Data.msg.bits.Byte4Data = 0x03;
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_43, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 5);
}

uint8_t InteriorLampTimer = 0;
void InteriorLamp()
{
#if (HH12)
    //PowerLimitDisp();
#elif (PRO_CN7C)
    if (GetCluType() == SVC_CFG){
        switch(InteriorLampTimer) {
        case 1:
            AutoHoldGreen();
            LdwLkaGray();
            LfaHdaGray();
            IsgGreen();
            RSBR_Red();
            DAW_Blink();
            AUTO();
            FcaYellow();
            HBAGreen();
            HighBeam();
            break;
        case 2:
            AutoHoldWhite();
            LdwLkaGreen();
            LfaHdaGreen();
            IsgGray();
            GreenZoneLamp();
            HEV();
            FcaRed();
            HBAWhite();
            LowBeam();
            break;
        case 3:
            AutoHoldYellow();
            LdwLkaYellow();
            LfaHdaWhite();
            IsgWhite();
            EV_Plus();
            break;
        }
        ISLA();
        IceWarning();
        TOW();
        EPB();
        OverSpeed();
        LeftTurn();
        CheckEngine();
        AirBag();
        Tpms();
        RearFog();
        TailLamp();
        DpfGpf();
        SeatBelt();
        Mdps();
        RightTurn();
        Ecall();
        BatteryCharge();
        Immobilizer();
        ABS();
        OilPressure();
        ParkingBreak();
        MasterSymbol();
        ESC();  
        EscOff();
    }else {
        switch(InteriorLampTimer) {
        case 1:
            AutoHoldGreen();
            LdwLkaGray();
            LfaHdaGray();
            IsgGreen();
            RSBR_Red();
            DAW_Blink();
            AUTO();
            break;
        case 2:
            AutoHoldWhite();
            LdwLkaGreen();
            LfaHdaGreen();
            IsgGray();
            GreenZoneLamp();
            HEV();
            break;
        case 3:
            AutoHoldYellow();
            LdwLkaYellow();
            LfaHdaWhite();
            IsgWhite();
            EV_Plus();
            break;
        }
        ISLA();
        IceWarning();
        TOW();
    }
#elif (PRO_DL3C)
    switch(InteriorLampTimer) {
    case 1:
        AutoHoldGreen();
        LdwLkaGray();
        LfaHdaGray();
        IsgGreen();
        break;
    case 2:
        AutoHoldWhite();
        LdwLkaGreen();
        LfaHdaGreen();
        IsgGray();
        break;
    case 3:
        AutoHoldYellow();
        LdwLkaYellow();
        LfaHdaWhite();
        IsgWhite();
        break;
    }
    IceWarning();
    FcaYellow();
    HBAGreen();
    LedLampFail();
    EPB();
    Tpms();
    DpfGpf();
#elif (PRO_QYC)
    if (GetCluType() == SVC_CFG){
        switch(InteriorLampTimer) {
        case 1:
            LdwLkaGray();
            LfaHdaGreen();
            HBAGreen();
            HighBeam();
            FcaYellow();
            DBCGreen();
            break;
        case 2:
            LdwLkaGreen();
            LfaHdaGray();
            HBAWhite();
            LowBeam();
            FcaRed();
            DBCYellow();
            break;
        case 3:
            LdwLkaYellow();
            LfaHdaWhite();
            RSBR_Red();
            break;
    }
    OverSpeed();
    OilPressure();
    ABS();
    Immobilizer();
    RightTurn();
    CheckEngine();
    AirBag();
    Mdps();
    RearFog();
    FrontFog();
    TailLamp();
    DpfGpf();
    ISLA();
    IceWarning();
    Tpms();
    Ecall();
    SeatBelt();
    LeftTurn();
    BatteryCharge();
    ParkingBreak();
    MasterSymbol();
    ESC();  
    EscOff();
    }
    else {
        switch(InteriorLampTimer) {
        case 1:
            LdwLkaGray();
            LfaHdaGreen();
            break;
        case 2:
            LdwLkaGreen();
            LfaHdaGray();
            break;
        case 3:
            LdwLkaYellow();
            LfaHdaWhite();
            break;
        ISLA();
        IceWarning();
        RSBR_Red();
        }
    }
#elif (PRO_NX4C)
    if (GetCluType() == STD_CFG){
        switch(InteriorLampTimer) {
            case 1:
                AutoHoldGreen();
                LdwLkaWhite();
                IsgYellow();
                DBCGreen();
                break;
            case 2:
                AutoHoldWhite();
                LdwLkaGreen();
                LfaHdaGreen();
                IsgGreen();
                DBCYellow();
                break;
            case 3:
                AutoHoldYellow();
                LdwLkaYellow();
                LfaHdaWhite();
                IsgWhite();
                break;
        }
        IceWarning();
        FcaYellow();
        HIGH_TEMP();
        ServiceLamp();
    }
    else {
        switch(InteriorLampTimer) {
            case 1:
                AutoHoldGreen();
                LdwLkaWhite();
                IsgYellow();
                DBCGreen();
                HighBeam();
                break;
            case 2:
                AutoHoldWhite();
                LdwLkaGreen();
                LfaHdaGreen();
                IsgGreen();
                DBCYellow();
                LowBeam();
                break;
            case 3:
                AutoHoldYellow();
                LdwLkaYellow();
                LfaHdaWhite();
                IsgWhite();
                break;
        }
        IceWarning();
        FcaYellow();
        HIGH_TEMP();
        ServiceLamp();
        LeftTurn();
        SeatBelt();
        AirBag();
        OilPressure();
        BatteryCharge();
        Mdps();
        ParkingBreak();
        EPB();
        Tpms();
        ABS();
        RightTurn();
        TailLamp();
        HBAGreen();
        Four_WD_Lock();
        RearFog();
        CheckEngine();
        Four_WD_Diag();
        ESC();
        DpfGpf();
        MasterSymbol();
        EscOff();
        Immobilizer();
        READY();
        EV_MODE();
    }
#elif (PRO_NUPE)
    switch(InteriorLampTimer) {
        case 1:
            LdwLkaYellow();
            LfaHdaGray();
            break;
        case 2:
            LdwLkaGreen();
            LfaHdaGreen();
            break;
        case 3:
            LdwLkaWhite();
            break;
    }
#elif (PRO_ONPE)
    switch(InteriorLampTimer) {
        case 1:
            AutoHoldGreen();
            LdwLkaGray();
            LfaHdaGray();
            IsgYellow();
            break;
        case 2:
            AutoHoldWhite();
            LdwLkaGreen();
            LfaHdaGreen();
            IsgGray();
            break;
        case 3:
            AutoHoldYellow();
            LdwLkaYellow();
            LfaHdaWhite();
            IsgWhite();
            break;
    }
    ISLA();
    IceWarning();
    TOW();
#elif (PRO_PDEPE2)
    switch(InteriorLampTimer) {
        case 1:
            AutoHoldGreen();
            LdwLkaGray();
            LfaHdaGray();
            IsgYellow();
            break;
        case 2:
            AutoHoldWhite();
            LdwLkaGreen();
            LfaHdaGreen();
            IsgGreen();
            break;
        case 3:
            AutoHoldYellow();
            LdwLkaYellow();
            LfaHdaWhite();
            IsgWhite();
            break;
    }
    ISLA();
    IceWarning();
    DAW_Blink();
#elif (PRO_KY)
    switch(InteriorLampTimer) {
        case 1:
            IsgYellow();
            break;
        case 2:
            IsgGreen();
            break;
        case 3:
            IsgWhite();
            break;
    }
    IceWarning();
#elif (PRO_BDC_PE)
    if (GetCluType() == STD_CFG){
        switch(InteriorLampTimer) {
            case 1:
                AutoHoldGreen();
                LdwLkaWhite();
                IsgYellow();
                break;
            case 2:
                AutoHoldWhite();
                LdwLkaGreen();
                LfaHdaGreen();
                IsgGreen();
                break;
            case 3:
                AutoHoldYellow();
                LdwLkaYellow();
                LfaHdaWhite();
                IsgWhite();
                break;
        }
        IceWarning();
        FcaYellow();
    }
    else {
        switch(InteriorLampTimer) {
            case 1:
                AutoHoldGreen();
                LdwLkaGray();
                IsgYellow();
                LfaHdaGray();
                HighBeam();
                HBAGreen();
                break;
            case 2:
                AutoHoldWhite();
                LdwLkaGreen();
                LfaHdaGreen();
                IsgGreen();
                LowBeam();
                HBAWhite();
                break;
            case 3:
                AutoHoldYellow();
                LdwLkaYellow();
                LfaHdaWhite();
                IsgWhite();
                break;
        }
        IceWarning();
        FcaYellow();
        LeftTurn();
        SeatBelt();
        AirBag();
        OilPressure();
        BatteryCharge();
        Mdps();
        ParkingBreak();
        EPB();
        Tpms();
        ABS();
        RightTurn();
        TailLamp();
        HBAGreen();
        RearFog();
        CheckEngine();
        ESC();
        DpfGpf();
        MasterSymbol();
        EscOff();
        Immobilizer();
    }
#elif (PRO_BC3)
    switch(InteriorLampTimer) {
        case 1:
            IsgYellow();
            LdwLkaGray();
            LfaHdaGray();
            break;
        case 2:
            IsgGreen();
            LdwLkaGreen();
            LfaHdaGreen();
            break;
        case 3:
            IsgWhite();
            LdwLkaYellow();
            LfaHdaWhite();
            break;
    }
    IceWarning();
    ISLA();
    RSBR_Red();
    DAW_Blink();
#else
    switch(InteriorLampTimer) {
        case 1:
            AutoHoldGreen();
            LdwLkaGray();
            LfaHdaGray();
            IsgGreen();
            RSBR_Red();
            DAW_Blink();
            AUTO();
            break;
        case 2:
            AutoHoldWhite();
            LdwLkaGreen();
            LfaHdaGreen();
            IsgGray();
            GreenZoneLamp();
            HEV();
            break;
        case 3:
            AutoHoldYellow();
            LdwLkaYellow();
            LfaHdaWhite();
            IsgWhite();
            EV_Plus();
            break;
    }
    ISLA();
    IceWarning();
    TOW();
#endif
//    AutoHoldGreen();
//    AutoHoldWhite();
//    AutoHoldYellow();
//    LdwLkaGray();
//    LdwLkaGreen();
//    LdwLkaWhite();
//    LdwLkaYellow();
//    LfaHdaGray();
//    LfaHdaGreen();
//    LfaHdaWhite();
//    IsgGray();
//    IsgGreen();
//    IsgWhite();
//    IsgYellow();
//    DAW_Blink();
//    GreenZoneLamp();
//    RSBR_Red();
//    AUTO();
//    HEV();
//    EV_Plus();
}


void AllLedShutDown()
{
#if (CAN_2ND)
#endif
#if (CAN_3RD)   
#endif 
}
//DMS==================================
void DMS_RestoreDefault()
{
    switch(g_uiB_PlusResetWaitFlag){
        case 0:
            LowFuel(1);//ȼ�͵͸��ü�ʻģʽ�ָ�Ĭ��B+ Reset
            g_uiB_PlusResetWaitTimer = DMS_PREPARE_TIME;
            g_uiB_PlusResetWaitFlag = 1;
            g_uiDmsLedCheckFlag = 0;
            g_uiSmartComfortWaitFlag = 0;
            g_uiLowLevelTrigerFlag = 0;
#if ((PRO_PDEPE2) || (PRO_BN7R) || (PRO_US4) || (PRO_KY) || (PRO_KS) || (PRO_YB_PE) || (PRO_SK3_PE) || (PRO_GL3) || (PRO_BL7M) || (PRO_CN7) || (PRO_BN7I) || (PRO_BL7R) || (PRO_QYC) || (PRO_NX4C) || (PRO_BC3))
            PressGribCtrlSW_LowLevel();//��ʼ��GPIOΪ�͵�ƽ
#endif
            break;
        case 1:
            SetPressKeySequence(KEY_30,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_NONE,
                                KEY_NONE,
                                KEY_NONE,
                                KEY_NONE,
                                KEY_NONE,
                                KEY_NONE,
                                KEY_NONE);
            DoPressKeySimulation(DMS_PREPARE_TIME);
            break;    
    }
}

void DMS_Led_Low()
{
    g_uiDmsLedCheckFlag = 1;
    g_uiLowLevelTrigerFlag = 1;
#if (CAN_2ND)
    CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp = 0X0;
#endif    
#if (CAN_3RD)    
    TCU_01_10ms.TCU_DrvngModDis = 0x0;
#endif 
#if ((PRO_PDEPE2) || (PRO_BN7R) || (PRO_US4)|| (PRO_KY) || (PRO_KS)  || (PRO_YB_PE) || (PRO_SK3_PE) || (PRO_GL3)  || (PRO_BL7M) || (PRO_CN7) || (PRO_BN7I) || (PRO_BL7R) || (PRO_QYC) || (PRO_NX4C))
    SetPressKeySequence(KEY_GRIB_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
    DoPressKeySimulation(TIME_400);
}

void LightAll()
{
    LowFuelFlag = 0;
    if(LedCurrent.enable == 1)
    {
        LampState_L.Lamps.RELAY_F1 = 0;                  //���?
        LampState_L.Lamps.RELAY_F2 = 0;
        LampState_L.Lamps.RELAY_F3 = 0;
        LampState_L.Lamps.RELAY_F4 = 0;
        //LampState_L.Lamps.RELAY_IGN1 = 0;
        //LampState_L.Lamps.RELAY_B = 0;
        if(LedCurrent.Time > 1000)
        {
            //LampState_L.Lamps.RELAY_IGN1 = 1;
            //LampState_L.Lamps.RELAY_B = 1;
            LedCurrent.enable = 0;
        }
    }
    Send_7C6_Data.msg.bits.Byte0Data = 0x02;
    Send_7C6_Data.msg.bits.Byte1Data = 0x10;
    Send_7C6_Data.msg.bits.Byte2Data = 0x03;
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_41, TX_ISR_EN, (uint8_t *)&Send_7C6_Data.msg.data, 3);
    Delay(5);//5ms
    Send_7C6_Data.msg.bits.Byte0Data = 0x04;
    Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
    Send_7C6_Data.msg.bits.Byte2Data = 0xB0;
    Send_7C6_Data.msg.bits.Byte3Data = 0x01;
    Send_7C6_Data.msg.bits.Byte4Data = 0x01;
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_41, TX_ISR_EN, (uint8_t *)&Send_7C6_Data.msg.data, 5);
}

void SetTelltalePos(uint8_t *pLedName,fpFunc pFun)
{
    if(pFun != NULL){
        memcpy(g_stLedOut[g_uiLedNum].szFuncName,pLedName,strlen((const char *)pLedName) > FuncNameSize ? FuncNameSize : strlen((const char *)pLedName));
        g_stLedOut[g_uiLedNum].uiIndex = g_uiLedIdx++;
        g_stLedOut[g_uiLedNum].pFunc = pFun;
        g_uiLedNum++;
    }
}

void InitTelltaleOrder()
{
    if(g_uiLedNum > 0)
        return;

    g_uiLedNum = 0;
    g_uiLedIdx = 1;
#if (PRO_QX23)   
    InitTelltale_QX23();
#endif
}


void ResetLedFlag(void)
{
    if(g_uiLPI_OverCheckFlag == 1)
        g_uiLPI_OverCheckFlag = 0;
    if(g_uiLPI_OnlyCheckFlag == 1)
        g_uiLPI_OnlyCheckFlag = 0;
    if(g_uiLPI_CheckFlag == 1)
        g_uiLPI_CheckFlag = 0;
    if(g_uiHEV_CheckFlag == 1)
        g_uiHEV_CheckFlag = 0;
    if(g_uiDmsLedCheckFlag == 1)
        g_uiDmsLedCheckFlag = 0;
    if(g_uiAirBagLedCheckFlag == 1)
        g_uiAirBagLedCheckFlag = 0;
    if(g_uiISGLedCheckFlag == 1)
        g_uiISGLedCheckFlag = 0;
    if(g_uiIceWarningLedCheckFlag == 1)
        g_uiIceWarningLedCheckFlag = 0;
    if(g_uiB_PlusResetWaitFlag == 1)
        g_uiB_PlusResetWaitFlag = 0;
    if(g_uiSmartComfortWaitFlag == 1)
        g_uiSmartComfortWaitFlag = 0;
    if(g_uiOilPressureCheckFlag == 1)
        g_uiOilPressureCheckFlag = 0;
    if(g_uiLowLevelTrigerFlag == 1)
        g_uiLowLevelTrigerFlag = 0;
    if(g_uiBCWFlag == 1)
        g_uiBCWFlag = 0;
    if (g_uiWaterSaperatorLedCheckFlag == 1) {
        g_uiWaterSaperatorLedCheckFlag = 0;
        Port_SetPortPinLevel(2, 1, PortGpioLow);           //WaterSeparator
    }
    if (g_uiRSBRFlag == 1) {
        g_uiRSBRFlag = 0;
#if (CAN_2ND)
        CGW7.msg.bits.CF_Gway_RLSeatBeltInd = 0x1;
        CGW7.msg.bits.CF_Gway_RCSeatBeltInd = 0x1;
        CGW7.msg.bits.CF_Gway_RRSeatBeltInd = 0x1;
#endif
#if (CAN_3RD)    
        BCM_03_200ms.SBR_RrLftStBltWrngIndSta = 0x3;
        BCM_03_200ms.SBR_RrCtrStBltIndSta     = 0x3;
        BCM_03_200ms.SBR_RrRtStBltWrngIndSta  = 0x3;
#endif 
    }
}

void InitLedDsp(void)
{
    if(g_uiAirBagLedCheckFlag == 0) {
       //  Port_SetPortPinLevel(2, 0, PortGpioLow);
#if (CAN_2ND)
         ACU14.msg.bits.CF_SWL_Ind = 0x1;//Air Bag off
#endif
#if (CAN_3RD)       
         ACU_01_100ms.ACU_SysWrngLmpDis = 0x0;//Air Bag off
#endif 
    }
    if (g_uiISGLedCheckFlag == 0) {
#if (CAN_2ND)
        //CGW_PC12.CF_Ems_ISG_Equipped = 0x00;
        CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x4;          //ISG ��
        CGW_PC5.msg.bits.CF_Ems_IsgStat2 = 0x1;         //ISG ��
#endif
#if (CAN_3RD)   
        EMS_01_10ms.ENG_IsgSta = 0x4;
        EMS_01_10ms.ENG_Isg2Sta = 0x1;
#endif 
    }   
}

void APP_LED_OUTPUT(void)   //LED ���ķ���  һ������                                             
{
    Default_flag=1;
    LampState_L.Lamps.RELAY_F1 = 0;                  //���� 
    LampState_L.Lamps.RELAY_F2 = 0;
    LampState_L.Lamps.RELAY_F3 = 0;
    LampState_L.Lamps.RELAY_F4 = 1;

    switch(LedCurrent.count)   //LED
    {
        case 1://Ӳ�ߵ�ȫ��
            //  Port_SetPortPinLevel(2, 0, PortGpioHigh);           //Air Bag
            //  Port_SetPortPinLevel(2, 20,PortGpioHigh);           //����ѹ��
            //  Port_SetPortPinLevel(2, 1, PortGpioHigh);           //WaterSeparator
             Port_SetPortPinLevel(0, 0, PortGpioHigh); 
             Port_SetPortPinLevel(2, 13, PortGpioLow); 
             Port_SetPortPinLevel(2, 14, PortGpioLow);            //Batter
             break;  
        case 2://Ӳ�ߵ�ȫ��
            Port_SetPortPinLevel(0, 0, PortGpioLow);           //Batter
             //Port_SetPortPinLevel(2, 13, PortGpioHigh); 
             Port_SetPortPinLevel(2, 14, PortGpioLow);           //Air Bag
#if (PRO_CN7C)
             ACU14.msg.bits.CF_SWL_Ind = 0x1;
#endif
#if (PRO_QYC)
         if (GetCluType() == SVC_CFG){
             ACU14.msg.bits.CF_SWL_Ind = 0x1;
            }
#endif
            //  Port_SetPortPinLevel(2, 20,PortGpioLow);           //����ѹ��
            //  Port_SetPortPinLevel(2, 1, PortGpioLow);           //WaterSeparator
            //  Port_SetPortPinLevel(0, 0, PortGpioLow);           //Batter
#if ((PRO_NQ5) || (PRO_US4) || (PRO_NQ5C))
             LDC_01_100ms.LDC_AuxBattWrnLmpReq =0x0;                 //Batter Charge  HEV/PHEV
             EMS_02_10ms.ENG_BattWrngLmpSta = 0x0;                   //Batter Charge  ICV
             ACU_01_100ms.ACU_SysWrngLmpDis = 0x0;                   //Air Bag  
             EMS_08_100ms.HEV_OPSFail = 0x0;                         //Oil pressure  HEV
#elif (PRO_TAM)
         EMS19.msg.bits.BAT_LAMP_STAT = 0x0;
         EMS19.msg.bits.CF_Ems_OPSFail = 0x0;
         CGW2.msg.bits.CF_Gway_ImmoLp=0x0;
#elif (PRO_CN7)
             EMS19.msg.bits.BAT_LAMP_STAT = 0x0; 
             EMS19.msg.bits.CF_Ems_OPSFail = 0x0; 
             HEV_PC2.msg.bits.CF_Ldc_AuxBatWrnLamp = 0x0;
             HEV_PC11.msg.bits.CF_Ems_OPSFail = 0x0;
#elif (PRO_AC3_PE)
             EMS19.msg.bits.CF_Ems_OPSFail = 0x0;
             EMS19.msg.bits.BAT_LAMP_STAT = 0x0;
#elif ((PRO_SQFL) || (PRO_DL3C))
            ACU14.msg.bits.CF_SWL_Ind = 0x1;
#endif             
             break; 
#if (PRO_NU2)
        case 3:
            SingleSegmentCodeLED();
            break;
        case 4:
            DoubleSegmentCodeLED();
            break;
        case 5://����?������
             LedCurrent.statu = FINISH;
             Port_SetPortPinLevel(2, 0, PortGpioHigh);           //Air Bag
             
             Send_7C6_Data.msg.bits.Byte0Data = 0x02;
             Send_7C6_Data.msg.bits.Byte1Data = 0x10;
             Send_7C6_Data.msg.bits.Byte2Data = 0x03;  
             CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_43, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3);
             
             Delay(5);//5ms
             Send_7C6_Data.msg.bits.Byte0Data = 0x04;
             Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
             Send_7C6_Data.msg.bits.Byte2Data = 0xB0;  
             Send_7C6_Data.msg.bits.Byte3Data = 0x01;
             Send_7C6_Data.msg.bits.Byte4Data = 0x03;HJ_OtherKeyCurrent.count
             CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_43, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 5);
             break;
#else
       case 3://����?������
       Port_SetPortPinLevel(0, 0, PortGpioLow);  
       //Port_SetPortPinLevel(2, 13, PortGpioLow);  
       Port_SetPortPinLevel(2, 14, PortGpioHigh);  
            //  LedCurrent.statu = FINISH;
            //  Port_SetPortPinLevel(2, 0, PortGpioHigh);           //Air Bag
             
            //  Send_7C6_Data.msg.bits.Byte0Data = 0x02;
            //  Send_7C6_Data.msg.bits.Byte1Data = 0x10;
            //  Send_7C6_Data.msg.bits.Byte2Data = 0x03;  
            //  CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_43, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3);
             
            //  Delay(5);//5ms
            //  Send_7C6_Data.msg.bits.Byte0Data = 0x04;
            //  Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
            //  Send_7C6_Data.msg.bits.Byte2Data = 0xB0;  
            //  Send_7C6_Data.msg.bits.Byte3Data = 0x01;
            //  Send_7C6_Data.msg.bits.Byte4Data = 0x03;
            //  CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_43, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 5);
             break;
#endif
//#if (SEMI_AUTOMATIC_STAGE)
//       case 4://����?��Ϩ��
//            LedCurrent.statu = FINISH;
//             Port_SetPortPinLevel(2, 0, PortGpioLow);           //Air Bag
//             Port_SetPortPinLevel(2, 1, PortGpioLow);           //WaterSeparator
//             Send_7C6_Data.msg.bits.Byte0Data = 0x02;
//             Send_7C6_Data.msg.bits.Byte1Data = 0x10;
//             Send_7C6_Data.msg.bits.Byte2Data = 0x03;  
//             CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_43, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3);
//             
//             Delay(5);//5ms
//             Send_7C6_Data.msg.bits.Byte0Data = 0x04;
//             Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
//             Send_7C6_Data.msg.bits.Byte2Data = 0xB0;  
//             Send_7C6_Data.msg.bits.Byte3Data = 0x01;
//             Send_7C6_Data.msg.bits.Byte4Data = 0x00;
//             CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_43, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 5);
//            break;
//#endif
    }
}
void APP_LED_CLOS(void)
{
   // Port_SetPortPinLevel(2, 0, PortGpioLow);           //Air Bag
    Port_SetPortPinLevel(2, 1, PortGpioLow);           //WaterSeparator
    Send_7C6_Data.msg.bits.Byte0Data = 0x02;
    Send_7C6_Data.msg.bits.Byte1Data = 0x10;
    Send_7C6_Data.msg.bits.Byte2Data = 0x03;  
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_43, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3);

    Delay(5);//5ms
    Send_7C6_Data.msg.bits.Byte0Data = 0x04;
    Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
    Send_7C6_Data.msg.bits.Byte2Data = 0xB0;  
    Send_7C6_Data.msg.bits.Byte3Data = 0x01;
    Send_7C6_Data.msg.bits.Byte4Data = 0x00;
    CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_43, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 5);
}

