#include "common_include.h"

#ifndef __CANFD_320_DRIVER_H__
#define __CANFD_320_DRIVER_H__


#define CANFD_INSTANCE_COUNT (uint32_t)(sizeof(m_astcCanFDInstanceDataLut) / sizeof(m_astcCanFDInstanceDataLut[0]))


/* Enumeration to define an index for each enabled CAN-FD instance */
typedef enum en_canfd_instance_index
{
    CanFDInstanceIndexCanFD0,

    CanFDInstanceIndexCanFD1,

    CanFDInstanceIndexCanFD2,

    CanFDInstanceIndexCanFD3,

    CanFDInstanceIndexMax
} en_canfd_instance_index_t;
    
/* CAN-FD instance data type */
typedef struct stc_canfd_instance_data
{
    pstc_canfd_type_t       pstcInstance;    /* pointer to registers of an instance */
    stc_canfd_intern_data_t stcInternData;   /* module internal data of instance */
} stc_canfd_instance_data_t;
/* Look-up table for all enabled CAN-FD instances and their internal data */
static stc_canfd_instance_data_t m_astcCanFDInstanceDataLut[] =
{
    { 
        CANFD0_Type,    /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    { 
        CANFD1_Type,    /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    { 
        CANFD2_Type,    /* pstcInstance */
        { NULL }        /* stcInternData */
    },
    { 
        CANFD3_Type,    /* pstcInstance */
        { NULL }        /* stcInternData */
    },
};

/**
 *****************************************************************************
 ** ҪCANʼ˲
 **
 ** 
 *****************************************************************************/
typedef struct stc_canfd_standardFilter
{
  uint16_t standardFilter[127]; //׼˲
} stc_canfd_standardFilter_t;

#define                 BUF_0          0
#define                 BUF_1          1
#define                 BUF_2          2
#define                 BUF_3          3
#define                 BUF_4          4
#define                 BUF_5          5
#define                 BUF_6          6
#define                 BUF_7          7
#define                 BUF_8          8
#define                 BUF_9          9
#define                 BUF_10         10
#define                 BUF_11         11
#define                 BUF_12         12
#define                 BUF_13         13
#define                 BUF_14         14
#define                 BUF_15         15
#define                 BUF_16          16
#define                 BUF_17          17
#define                 BUF_18          18
#define                 BUF_19          19
#define                 BUF_20          20
#define                 BUF_21          21
#define                 BUF_22          22
#define                 BUF_23          23
#define                 BUF_24          24
#define                 BUF_25          25
#define                 BUF_26          26
#define                 BUF_27          27
#define                 BUF_28          28
#define                 BUF_29          29
#define                 BUF_30          30
#define                 BUF_31          31
#define                 BUF_32          32
#define                 BUF_33          33
#define                 BUF_34          34
#define                 BUF_35          35
#define                 BUF_36          36
#define                 BUF_37          37
#define                 BUF_38          38
#define                 BUF_39          39
#define                 BUF_40          40
#define                 BUF_41          41
#define                 BUF_42          42
#define                 BUF_43          43
#define                 BUF_44          44

#define                 TX_ISR_EN      1
#define                 TX_ISR_DIS     0


/**
 *****************************************************************************
 ** CanFDݳתͨݳ
 **
 ** 
 *****************************************************************************/
static const int CanDlcInCanFDDlc[] = {
	0,1,2,3,4,5,6,7,8,			
	12,			/*!<  9 DLC */
	16,			/*!< 10 DLC */
	20,			/*!< 11 DLC */
	24,			/*!< 12 DLC */
	32,			/*!< 13 DLC */
	48,			/*!< 14 DLC */
	64			/*!< 15 DLC */
};

/**
 *****************************************************************************
 ** CanFD Tx Buffer Data Field Size
 **
 ** 
 *****************************************************************************/
static const int CanTxBufferDataFieldSize[] = {
	8, 12, 16, 20,24, 32, 48, 64
};
extern   volatile    uint8_t   Can0_busoffTime;
    
extern   void          CanFD_Drive_Init(pstc_canfd_type_t pstcCanFD,stc_canfd_standardFilter_t* filterConfig); //CAN0-CAN5 ʼ
extern   void          BSP_CAN0_Init(void);
extern   void          CAN0_Wakup_Init(void);
extern   void          CAN0_Rx_CallBack(stc_canfd_msg_t* stc_msg);  //жϻص
extern   void          CAN0_Tx_CallBack(void);                                          //жϻص
extern   void          CAN0_Error_CallBack(en_canfd_error_t en_canfd_err);              //жϻص
static   void          CAN0_Wakup_CallBack(uint8_t channel);
extern   void          CAN0_FIFO_0_CallBack(stc_canfd_msg_t* stc_msg);
extern   void          CanFD_Busoff_Recover(uint8_t ch);                //CAN BUSOFF ָ    
extern   void          CAN1_Wakup_Init(void);
extern   void          CAN1_Rx_CallBack(stc_canfd_msg_t* stc_msg);  //жϻص
extern   void          CAN1_Tx_CallBack(void);                                          //жϻص//жϻص
extern   void          CAN1_Error_CallBack(en_canfd_error_t en_canfd_err);               //жϻص//жϻص
static   void          CAN1_Wakup_CallBack(uint8_t channel);
extern   void          CAN1_FIFO_0_CallBack(stc_canfd_msg_t* stc_msg);
    
extern   void          CanFD_Send_StandMsg(pstc_canfd_type_t pstcCanFD,uint16_t id,uint8_t bufIndex,uint8_t tx_isr_en,uint8_t* msg,uint8_t dlc); //ͱ׼֡Ϣ

//extern   void          Can2FD_Send_StandMsg(pstc_canfd_type_t pstcCanFD,uint16_t id,uint8_t bufIndex,uint8_t tx_isr_en,uint8_t* msg,uint8_t dlc); //ͱ׼֡Ϣ

extern   void          Copy_RxBufToRam(uint8_t* msg,stc_canfd_msg_t* stc_msg);
extern   void          Copy_RxFIFOToRam(uint8_t* msg,stc_canfd_msg_t* stc_msg);
    
    
extern   void          bsp_tx_msgbuf_abort(uint8_t channel);
extern   void          bsp_CAN_Sleep(uint8_t channel);
    
    
extern   __irq __arm     void    CanFD_chl0_isr(void);
extern   __irq __arm     void    CanFD_chl1_isr(void);
extern   __irq __arm     void    CanFD_chl2_isr(void);
extern   __irq __arm     void    CanFD_chl3_isr(void);
    extern                 uint8_t Shift_Fun(uint8_t data);
    extern  void          Byte_Shift_Fun(uint8_t *pdata);

    
#endif /*__CANFD_320_DRIVER_H__*/