#include "common_include.h"
#define PRESS_KEY_START    0
#define PRESS_KEY_DOWN     1
#define PRESS_KEY_DOWNING  2
#define PRESS_KEY_UP       3
#define PRESS_KEY_UPING    4
#define PRESS_KEY_END      5

uint8_t g_LastKeyType = 0;
uint8_t g_CurKeyType = 0;
uint8_t g_PressKeyStep = PRESS_KEY_START;

uint32_t g_uiLastPress = 0;
uint32_t g_uiCurPress  = 0;
ST_PRESS_KEY_STEP g_stPressKeyStep;
void Press30(uint8_t uiState)
{
    //LampState_L.Lamps.RELAY_B = uiState;
    //LampState_L.Lamps.RELAY_IGN1 = uiState;    
}

void Press15(uint8_t uiState)
{
   // LampState_L.Lamps.RELAY_B = 1;
    //LampState_L.Lamps.RELAY_IGN1 = uiState;    
}

void PressNone(void)
{
#if (PRO_SP2C_PE)    
    LampState_M.Lamps.TripSW1_1 = 0;
    LampState_M.Lamps.TripSW1_2 = 0;
    LampState_M.Lamps.TripSW1_3 = 0;
    LampState_M.Lamps.TripSW1_4 = 0;
    LampState_M.Lamps.TripSW1_5 = 0;
#elif ((PRO_GL3) || (PRO_SG2))
    SWRC_01_200ms.Cluster_TripOkSwSta=0x0;
    SWRC_01_200ms.Cluster_TripDnSwSta=0x0;
    SWRC_01_200ms.Cluster_TripUpSwSta=0x0;
    SWRC_01_200ms.Cluster_ModeSwSta=0x0;
#else
    LampState_M.Lamps.TripSW1_1 = 0;
    LampState_M.Lamps.TripSW1_2 = 0;
    LampState_M.Lamps.TripSW1_3 = 0;
    LampState_M.Lamps.TripSW1_4 = 0;
    LampState_M.Lamps.TripSW1_5 = 0; 
#endif 
}

void PressSW1_Menu(uint8_t uiState)
{
#if ((PRO_SP2C_PE) || (PRO_YB_PE))    
    LampState_M.Lamps.TripSW1_1 = uiState;
    LampState_M.Lamps.TripSW1_2 = 0;
    LampState_M.Lamps.TripSW1_3 = 0;
    LampState_M.Lamps.TripSW1_4 = 0;
    LampState_M.Lamps.TripSW1_5 = 0;
#elif ((PRO_GL3) || (PRO_SG2))
    SWRC_01_200ms.Cluster_TripOkSwSta=0x0;
    SWRC_01_200ms.Cluster_TripDnSwSta=0x0;
    SWRC_01_200ms.Cluster_TripUpSwSta=0x0;
    SWRC_01_200ms.Cluster_ModeSwSta=0x1;
#elif (PRO_SP2)
    if (JudgePartNum() == PartNum_SP2){
        LampState_M.Lamps.TripSW1_1 = uiState;
        LampState_M.Lamps.TripSW1_2 = 0;
        LampState_M.Lamps.TripSW1_3 = 0;
        LampState_M.Lamps.TripSW1_4 = 0;
        LampState_M.Lamps.TripSW1_5 = 0;
    }else if (JudgePartNum() == PartNum_SP2I){
        LampState_M.Lamps.TripSW1_1 = 0;
        LampState_M.Lamps.TripSW1_2 = uiState;
        LampState_M.Lamps.TripSW1_3 = 0;
        LampState_M.Lamps.TripSW1_4 = 0;
        LampState_M.Lamps.TripSW1_5 = 0; 
    }
#else
    LampState_M.Lamps.TripSW1_1 = uiState;
    LampState_M.Lamps.TripSW1_2 = 0;
    LampState_M.Lamps.TripSW1_3 = 0;
    LampState_M.Lamps.TripSW1_4 = 0;
    LampState_M.Lamps.TripSW1_5 = 0; 
#endif    
}

void PressSW1_Up(uint8_t uiState)
{
#if ((PRO_SP2C_PE) || (PRO_YB_PE))
    LampState_M.Lamps.TripSW1_1 = 0;
    LampState_M.Lamps.TripSW1_2 = uiState;
    LampState_M.Lamps.TripSW1_3 = 0;
    LampState_M.Lamps.TripSW1_4 = 0;
    LampState_M.Lamps.TripSW1_5 = 0;
#elif ((PRO_GL3) || (PRO_SG2))
    SWRC_01_200ms.Cluster_TripOkSwSta=0x0;
    SWRC_01_200ms.Cluster_TripDnSwSta=0x0;
    SWRC_01_200ms.Cluster_TripUpSwSta=0x1;
    SWRC_01_200ms.Cluster_ModeSwSta=0x0;
#elif (PRO_SP2)
    if (JudgePartNum() == PartNum_SP2){
        LampState_M.Lamps.TripSW1_1 = 0;
        LampState_M.Lamps.TripSW1_2 = uiState;
        LampState_M.Lamps.TripSW1_3 = 0;
        LampState_M.Lamps.TripSW1_4 = 0;
        LampState_M.Lamps.TripSW1_5 = 0;
    }else if (JudgePartNum() == PartNum_SP2I){
        LampState_M.Lamps.TripSW1_1 = 0;
        LampState_M.Lamps.TripSW1_2 = 0;
        LampState_M.Lamps.TripSW1_3 = uiState;
        LampState_M.Lamps.TripSW1_4 = 0;
        LampState_M.Lamps.TripSW1_5 = 0;
    }
#else
    LampState_M.Lamps.TripSW1_1 = 0;
    LampState_M.Lamps.TripSW1_2 = uiState;
    LampState_M.Lamps.TripSW1_3 = 0;
    LampState_M.Lamps.TripSW1_4 = 0;
    LampState_M.Lamps.TripSW1_5 = 0;
#endif    

}

void PressSW1_Down(uint8_t uiState)
{
#if ((PRO_SP2C_PE) || (PRO_YB_PE))
    LampState_M.Lamps.TripSW1_1 = 0;
    LampState_M.Lamps.TripSW1_2 = 0;
    LampState_M.Lamps.TripSW1_3 = uiState;
    LampState_M.Lamps.TripSW1_4 = 0;
    LampState_M.Lamps.TripSW1_5 = 0;
#elif ((PRO_GL3) || (PRO_SG2))
    SWRC_01_200ms.Cluster_TripOkSwSta=0x0;
    SWRC_01_200ms.Cluster_TripDnSwSta=0x1;
    SWRC_01_200ms.Cluster_TripUpSwSta=0x0;
    SWRC_01_200ms.Cluster_ModeSwSta=0x0;
#elif (PRO_SP2)
    if (JudgePartNum() == PartNum_SP2){
        LampState_M.Lamps.TripSW1_1 = 0;
        LampState_M.Lamps.TripSW1_2 = 0;
        LampState_M.Lamps.TripSW1_3 = uiState;
        LampState_M.Lamps.TripSW1_4 = 0;
        LampState_M.Lamps.TripSW1_5 = 0;
    }else if (JudgePartNum() == PartNum_SP2I){
        LampState_M.Lamps.TripSW1_1 = 0;
        LampState_M.Lamps.TripSW1_2 = 0;
        LampState_M.Lamps.TripSW1_3 = 0;
        LampState_M.Lamps.TripSW1_4 = uiState;
        LampState_M.Lamps.TripSW1_5 = 0;   
    }
#else
    LampState_M.Lamps.TripSW1_1 = 0;
    LampState_M.Lamps.TripSW1_2 = 0;
    LampState_M.Lamps.TripSW1_3 = uiState;
    LampState_M.Lamps.TripSW1_4 = 0;
    LampState_M.Lamps.TripSW1_5 = 0;    
#endif    
}

void PressSW1_Ok(uint8_t uiState)
{
#if ((PRO_SP2C_PE) || (PRO_YB_PE))
    LampState_M.Lamps.TripSW1_1 = 0;
    LampState_M.Lamps.TripSW1_2 = 0;
    LampState_M.Lamps.TripSW1_3 = 0;
    LampState_M.Lamps.TripSW1_4 = uiState;
    LampState_M.Lamps.TripSW1_5 = 0;
#elif ((PRO_GL3) || (PRO_SG2))
    SWRC_01_200ms.Cluster_TripOkSwSta=0x1;
    SWRC_01_200ms.Cluster_TripDnSwSta=0x0;
    SWRC_01_200ms.Cluster_TripUpSwSta=0x0;
    SWRC_01_200ms.Cluster_ModeSwSta=0x0;
#elif (PRO_SP2)
    if (JudgePartNum() == PartNum_SP2){
        LampState_M.Lamps.TripSW1_1 = 0;
        LampState_M.Lamps.TripSW1_2 = 0;
        LampState_M.Lamps.TripSW1_3 = 0;
        LampState_M.Lamps.TripSW1_4 = uiState;
        LampState_M.Lamps.TripSW1_5 = 0;
    }else if (JudgePartNum() == PartNum_SP2I){
        LampState_M.Lamps.TripSW1_1 = 0;
        LampState_M.Lamps.TripSW1_2 = 0;
        LampState_M.Lamps.TripSW1_3 = 0;
        LampState_M.Lamps.TripSW1_4 = 0;
        LampState_M.Lamps.TripSW1_5 = uiState;
    }
#else
    LampState_M.Lamps.TripSW1_1 = 0;
    LampState_M.Lamps.TripSW1_2 = 0;
    LampState_M.Lamps.TripSW1_3 = 0;
    LampState_M.Lamps.TripSW1_4 = 0;
    LampState_M.Lamps.TripSW1_5 = uiState;     
#endif     
}

void PressGribCtrlSW_Up(uint8_t uiState)
{

}


void PressGribCtrlSW_Down(uint8_t uiState)
{

}

void PressGribCtrlSW_Push(uint8_t uiState)
{

}

void PressGribCtrlSW_Cruise(uint8_t uiState)
{

}

void PressGribCtrlSW_LowLevel(void) 
{
    Port_SetPortPinLevel(2, 26, PortGpioLow);
}

void TrationModeSW_LowLevel(void) 
{
    Port_SetPortPinLevel(2, 14, PortGpioLow);
}
void TrationModeSW_HighLevel(void) 
{
    //Port_SetPortPinLevel(2, 14, PortGpioHigh);
}
void PressGribCtrlSW_HighLevel(void) 
{
    Port_SetPortPinLevel(2, 26, PortGpioHigh);
}


void PressStateReset(void)
{
    if(g_PressKeyStep == PRESS_KEY_END) {
        g_PressKeyStep = PRESS_KEY_START;
        KeyStruct.Time = 0;
    }
}

uint8_t GetPressUpOver(void)
{
    if(KeyStruct.Time == 0 && g_PressKeyStep == PRESS_KEY_END)
        return 1;
    else
        return 0;
}

void PressKey(uint32_t uiCurStepPress,uint8_t uiKeyType,uint8_t uiPressType)
{
    g_uiCurPress = uiCurStepPress;//µúʱͬuiCurStepPressʱg_PressKeyStepΪ0
    if(g_uiLastPress != g_uiCurPress) {
        g_PressKeyStep = PRESS_KEY_START;
    }
    switch(g_PressKeyStep)
    {
        case PRESS_KEY_START:
            KeyStruct.enable = 1;
            g_PressKeyStep = PRESS_KEY_DOWN;
            break;
        case PRESS_KEY_DOWN:
            if(uiPressType == TRIPSW_OK_LONG_PRESS) {
                KeyStruct.Time   = 7000;//ʹ
            }
            else if(uiPressType == TRIPSW_UP_LONG_PRESS) {
                KeyStruct.Time   = 2000;//ʦģʽʹ
            }
            else if(uiPressType == TRIPSW_SHORT_PRESS) {
                if (uiKeyType == KEY_SW1_OK)  
#if ((PRO_CN7C) || (PRO_QYC))
                    KeyStruct.Time   = 150;
#else
                    KeyStruct.Time   = 200;
#endif
                else
                    KeyStruct.Time   = 200;
            }
            else if(uiPressType == GRIB_LONG_PRESS) {
                KeyStruct.Time   = 400;
            }
            else if(uiPressType == GRIB_SHORT_PRESS) {
                KeyStruct.Time   = 300;
            }
            g_PressKeyStep = PRESS_KEY_DOWNING;
            break;
        case PRESS_KEY_DOWNING:
            if(KeyStruct.Time > 0) {
                if(uiKeyType == KEY_30) {
                    Press30(0);
                }
                else if(uiKeyType == KEY_15) {
                    Press15(0);
                }
                else if(uiKeyType == KEY_SW1_MENU) {
                    PressSW1_Menu(1);
                }  
                else if(uiKeyType == KEY_SW1_DOWN) {
                    PressSW1_Down(1);
                }  
                else if(uiKeyType == KEY_SW1_UP) {
                    PressSW1_Up(1);
                } 
                else if(uiKeyType == KEY_SW1_UP_LONG) {
                    PressSW1_Up(1);
                }  
                else if(uiKeyType == KEY_SW1_OK) {
                    //PressSW1_Ok(1);
                    Port_SetPortPinLevel(2, 12, PortGpioHigh);
                }
                else if(uiKeyType == KEY_SW2_CRUISE) {
                    PressGribCtrlSW_Cruise(1);
                } 
                else if(uiKeyType == KEY_GRIB_UP) {
                    PressGribCtrlSW_Up(1);
                }  
                else if(uiKeyType == KEY_GRIB_DOWN) {
                    PressGribCtrlSW_Down(1);
                }
                else if(uiKeyType == KEY_GRIB_PUSH) {
                    PressGribCtrlSW_Push(1);
                }
                else if(uiKeyType == KEY_GRIB_LOW) {
                    PressGribCtrlSW_HighLevel();
                }
                else if(uiKeyType == KEY_GRIB_TrationMode_LOW) {
                    TrationModeSW_HighLevel();
                }
            }
            else {
                g_PressKeyStep = PRESS_KEY_UP;
            }
            break;            
        case PRESS_KEY_UP:
            if (uiKeyType == KEY_SW1_MENU && uiPressType == TRIPSW_OK_LONG_PRESS)  
                KeyStruct.Time   = 3000;
            else if (uiKeyType == KEY_SW1_OK && uiPressType == TRIPSW_SHORT_PRESS)  
                KeyStruct.Time   = 50;
            else 
                KeyStruct.Time   = 50;
            g_PressKeyStep = PRESS_KEY_UPING;
            break;
        case PRESS_KEY_UPING:
            if(KeyStruct.Time >= 0) {
                if(uiKeyType == KEY_30) {
                    Press30(1);
                }
                else if(uiKeyType == KEY_15) {
                    Press15(1);
                }
                else if(uiKeyType == KEY_SW1_MENU) {
                    PressSW1_Menu(0);
                }  
                else if(uiKeyType == KEY_SW1_DOWN) {
                    PressSW1_Down(0);
                }  
                else if(uiKeyType == KEY_SW1_UP) {
                    PressSW1_Up(0);
                }  
                else if(uiKeyType == KEY_SW1_UP_LONG) {
                    PressSW1_Up(0);
                } 
                else if(uiKeyType == KEY_SW1_OK) {
                    PressSW1_Ok(0);
                    Port_SetPortPinLevel(2, 12, PortGpioLow);
                } 
                else if(uiKeyType == KEY_SW2_CRUISE) {
                    PressGribCtrlSW_Cruise(0);
                }                 
                else if(uiKeyType == KEY_GRIB_UP) {
                    PressGribCtrlSW_Up(0);
                }  
                else if(uiKeyType == KEY_GRIB_DOWN) {
                    PressGribCtrlSW_Down(0);
                }
                else if(uiKeyType == KEY_GRIB_PUSH) {
                    PressGribCtrlSW_Push(0);
                }  
                else if(uiKeyType == KEY_GRIB_LOW) {
                    PressGribCtrlSW_LowLevel();
                }
                else if(uiKeyType == KEY_GRIB_TrationMode_LOW) {
                    TrationModeSW_LowLevel();
                }
                g_PressKeyStep = PRESS_KEY_END;
            }
            else {
                g_PressKeyStep = PRESS_KEY_END;
            }
            break;            
        case PRESS_KEY_END:
            KeyStruct.enable = 0;
            KeyStruct.Time   = 0;
            break;            
    }
    g_uiLastPress = uiCurStepPress;
}
uint8_t g_uiSimulationStep = 0;
uint8_t  g_uiStepTimerEnable = 0;
uint32_t g_uiStepTimer = 0;
static void _InitPressKeySimulation(void)
{

}

void DoPressKey30(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_30,TRIPSW_SHORT_PRESS);
            break;   
   }
}

void DoPressKey15(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_15,TRIPSW_SHORT_PRESS);
            break;   
   }
}

void DoPressKeyMENU(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_SW1_MENU,TRIPSW_SHORT_PRESS);
            break;   
   }
}

void DoPressKeyUP(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_SW1_UP,TRIPSW_SHORT_PRESS);
            break;   
   }
}

void DoPressKeyUP_LONG(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_SW1_UP_LONG,TRIPSW_UP_LONG_PRESS);
            break;   
   }
}

void DoPressKeyDOWN(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_SW1_DOWN,TRIPSW_SHORT_PRESS);
            break;   
   }
}

void DoPressKeyOK(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_SW1_OK,TRIPSW_SHORT_PRESS);
            break;   
   }
}

void DoPressKeyOK_LONG(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_SW1_OK_LONG,TRIPSW_OK_LONG_PRESS);
            break;   
   }
}

void DoPressKeyGribUP(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_GRIB_UP,GRIB_SHORT_PRESS);
            break;   
   }
}

void DoPressKeyGribDOWN(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_GRIB_DOWN,GRIB_SHORT_PRESS);
            break;   
   }
}

void DoPressKeyGribPUSH(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_GRIB_PUSH,GRIB_SHORT_PRESS);
            break;   
   }
}
void DoPressKeyGribLow(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_GRIB_LOW,GRIB_SHORT_PRESS);
            break;   
   }
}

void DoPressKeyGribTrationModeLow(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_GRIB_TrationMode_LOW,GRIB_SHORT_PRESS);
            break;   
   }
}

void DoPressKeyCruise(void)
{
    switch(PressKeyStruct.count){
        case 0:
            PressKeyStruct.enable = 1;
            PressKeyStruct.Time = 0;
            PressKeyStruct.count = 1;
            PressStateReset();
            break;
        case 1:
            PressKey(PressKeyStruct.count,KEY_SW2_CRUISE,TRIPSW_SHORT_PRESS);
            break;   
   }
}


void AfterTimeGoNext(_StaticCurrent *pCur,uint32_t uiTime)
{
    if(pCur->Time > uiTime) {
        pCur->Time = 0;
        pCur->count++;
    } 
}

void EnableSimulation(uint8_t uiEnableFlag)
{
    g_uiStepTimerEnable = uiEnableFlag;
}

void InitPressKeySimulation(void)
{
     SetStepTimer(0);
     if(PressKeyStruct.count != 0) {
        PressKeyStruct.count = 0;
     }
}

void GotoNextStep(uint32_t uiTime)
{
    if(g_uiStepTimer >= uiTime) {
         //if(GetPressUpOver() == 1) {
             g_uiSimulationStep++;
             InitPressKeySimulation();
         //}
    }
}

void SetCurrentStep(uint8_t uiStep)
{
    g_uiSimulationStep = uiStep;
}

uint8_t GetCurrentStep(void)
{
    return g_uiSimulationStep;
}

void SetStepTimer(uint32_t uiStepTimer)
{
    g_uiStepTimer = uiStepTimer;
}

uint8_t GetStepTimer(void)
{
    return g_uiStepTimer;
}

void SelectSimulationKey(uint8_t uiKeyType)
{
    switch(uiKeyType)
    {
        case KEY_30:
            DoPressKey30();
            break;
        case KEY_15:
            DoPressKey15();
            break;
        case KEY_SW1_MENU:
            DoPressKeyMENU();
            break;
        case KEY_SW1_UP:
            DoPressKeyUP();
            break;
        case KEY_SW1_UP_LONG:
            DoPressKeyUP_LONG();
            break;
        case KEY_SW1_OK_LONG:
            DoPressKeyUP_LONG();
            break;
        case KEY_SW1_DOWN:
            DoPressKeyDOWN();
            break;
        case KEY_SW1_OK:
            DoPressKeyOK();
            break;    
        case KEY_GRIB_UP:
            DoPressKeyGribUP();
            break;            
        case KEY_GRIB_DOWN:
            DoPressKeyGribDOWN();
            break;
        case KEY_GRIB_PUSH:
            DoPressKeyGribPUSH();
            break;
        case KEY_GRIB_LOW:
            DoPressKeyGribLow();
            break;
        case KEY_SW2_CRUISE:
            DoPressKeyCruise();
            break;
        case KEY_GRIB_TrationMode_LOW:
            DoPressKeyGribTrationModeLow();
            break;
        case KEY_NONE:
            PressNone();
            break;
    }
}
//#if (PRO_QYC)
//#define DEFAULT_STEP_TIME TIME_1000
//#define DEFAULT_NONE_TIME TIME_100
//#define UP_LONG_PRESS_TIME TIME_2500
//#define OK_LONG_PRESS_TIME TIME_2500
//#else 
#define DEFAULT_STEP_TIME TIME_400
#define DEFAULT_NONE_TIME TIME_100
#define UP_LONG_PRESS_TIME TIME_2000
#define OK_LONG_PRESS_TIME TIME_2500
//#endif

void DoPressKeySimulation(uint32_t uiFirstStepWaitTime)
{
    switch(GetCurrentStep())
    {
        case 0:
            GotoNextStep(0);
            EnableSimulation(1);
            break;
        case 1:
            SelectSimulationKey(g_stPressKeyStep.uiStep1);
            if(uiFirstStepWaitTime == TIME_0)
                GotoNextStep(DEFAULT_STEP_TIME);
            else
                GotoNextStep(uiFirstStepWaitTime);
            break;    
        case 2:
            SelectSimulationKey(g_stPressKeyStep.uiStep2);
            if(g_stPressKeyStep.uiStep2 == KEY_NONE)
                GotoNextStep(DEFAULT_NONE_TIME);
            else if(g_stPressKeyStep.uiStep2 == KEY_SW1_UP_LONG)
                GotoNextStep(UP_LONG_PRESS_TIME);
            else if(g_stPressKeyStep.uiStep2 == KEY_SW1_OK_LONG)
                GotoNextStep(OK_LONG_PRESS_TIME);
            else
                GotoNextStep(DEFAULT_STEP_TIME);
            break;
        case 3:
            SelectSimulationKey(g_stPressKeyStep.uiStep3);
            if(g_stPressKeyStep.uiStep3 == KEY_NONE)
                GotoNextStep(DEFAULT_NONE_TIME);
            else if(g_stPressKeyStep.uiStep3 == KEY_SW1_UP_LONG)
                GotoNextStep(UP_LONG_PRESS_TIME);
            else if(g_stPressKeyStep.uiStep3 == KEY_SW1_OK_LONG)
                GotoNextStep(OK_LONG_PRESS_TIME);
            else
                GotoNextStep(DEFAULT_STEP_TIME);
            break;
        case 4:
            SelectSimulationKey(g_stPressKeyStep.uiStep4);
            if(g_stPressKeyStep.uiStep4 == KEY_NONE)
                GotoNextStep(DEFAULT_NONE_TIME);
            else if(g_stPressKeyStep.uiStep4 == KEY_SW1_UP_LONG)
                GotoNextStep(UP_LONG_PRESS_TIME);
            else if(g_stPressKeyStep.uiStep4 == KEY_SW1_OK_LONG)
                GotoNextStep(OK_LONG_PRESS_TIME);
            else
                GotoNextStep(DEFAULT_STEP_TIME);
            break;
        case 5:
            SelectSimulationKey(g_stPressKeyStep.uiStep5);
            if(g_stPressKeyStep.uiStep5 == KEY_NONE)
                GotoNextStep(DEFAULT_NONE_TIME);
            else if(g_stPressKeyStep.uiStep5 == KEY_SW1_UP_LONG)
                GotoNextStep(UP_LONG_PRESS_TIME);
            else if(g_stPressKeyStep.uiStep5 == KEY_SW1_OK_LONG)
                GotoNextStep(OK_LONG_PRESS_TIME);
            else
                GotoNextStep(DEFAULT_STEP_TIME);
            break;
        case 6:
            SelectSimulationKey(g_stPressKeyStep.uiStep6);
            if(g_stPressKeyStep.uiStep6 == KEY_NONE)
                GotoNextStep(DEFAULT_NONE_TIME);
            else if(g_stPressKeyStep.uiStep6 == KEY_SW1_UP_LONG)
                GotoNextStep(UP_LONG_PRESS_TIME);
            else if(g_stPressKeyStep.uiStep6 == KEY_SW1_OK_LONG)
                GotoNextStep(OK_LONG_PRESS_TIME);
            else
                GotoNextStep(DEFAULT_STEP_TIME);
            break;
        case 7:
            SelectSimulationKey(g_stPressKeyStep.uiStep7);
            if(g_stPressKeyStep.uiStep7 == KEY_NONE)
                GotoNextStep(DEFAULT_NONE_TIME);
            else if(g_stPressKeyStep.uiStep7 == KEY_SW1_UP_LONG)
                GotoNextStep(UP_LONG_PRESS_TIME);
            else if(g_stPressKeyStep.uiStep7 == KEY_SW1_OK_LONG)
                GotoNextStep(OK_LONG_PRESS_TIME);
            else
                GotoNextStep(DEFAULT_STEP_TIME);
            break;
        case 8:
            SelectSimulationKey(g_stPressKeyStep.uiStep8);
            if(g_stPressKeyStep.uiStep8 == KEY_NONE)
                GotoNextStep(DEFAULT_NONE_TIME);
            else if(g_stPressKeyStep.uiStep8 == KEY_SW1_UP_LONG)
                GotoNextStep(UP_LONG_PRESS_TIME);
            else if(g_stPressKeyStep.uiStep8 == KEY_SW1_OK_LONG)
                GotoNextStep(OK_LONG_PRESS_TIME);
            else
                GotoNextStep(DEFAULT_STEP_TIME);
            break;
        case 9:
            SelectSimulationKey(g_stPressKeyStep.uiStep9);
            if(g_stPressKeyStep.uiStep9 == KEY_NONE)
                GotoNextStep(DEFAULT_NONE_TIME);
            else if(g_stPressKeyStep.uiStep9 == KEY_SW1_UP_LONG)
                GotoNextStep(UP_LONG_PRESS_TIME);
            else if(g_stPressKeyStep.uiStep9 == KEY_SW1_OK_LONG)
                GotoNextStep(OK_LONG_PRESS_TIME);
            else
                GotoNextStep(DEFAULT_STEP_TIME);
            break;
        case 10:
            SelectSimulationKey(g_stPressKeyStep.uiStep10);
            if(g_stPressKeyStep.uiStep10 == KEY_NONE)
                GotoNextStep(DEFAULT_NONE_TIME);
            else if(g_stPressKeyStep.uiStep10 == KEY_SW1_UP_LONG)
                GotoNextStep(UP_LONG_PRESS_TIME);
            else if(g_stPressKeyStep.uiStep10 == KEY_SW1_OK_LONG)
                GotoNextStep(OK_LONG_PRESS_TIME);
            else
                GotoNextStep(DEFAULT_STEP_TIME);
            break;
        default:
            EnableSimulation(0);
            break;
    }
}



