#include "Common_include.h"

#if (CAN_2ND)
#pragma location="BACKUP_RAM_CONTENT"
SOFTWARE_VARIANT_CODING_STRUCT SoftwareVariantCoding;

#define ByteToWord(x, y, m, n) (uint32_t)(((x) << 24) + ((y) << 16) + ((m) << 8) + (n))
#define ByteToHalfWord(x, y) (uint16_t)(((x) << 8) + (y))
//CAN_DATA_STRUCT Can0DataStruct;
//CAN1_DATA_STRUCT Can1DataStruct;
//xxhh add
/*Send_Data Send_7CE_Data;
CGW2_     CGW2;
EMS11_    EMS11;
*/
//xxhh add end
CANFD_DATA_STRUCT CanFDDataStruct;
MMCAN_DATA_STRUCT MMCanDataStruct;
static const INIT_CAN_FRAME CanInit[] = {
        //SU2_C-CAN_RX
        /*ID        timeout    continueCnts                                                     */
        /*     peroid     lv1 2  3         analysis func                 timeoutfunc            */
        //{0x4F1,  20,  5000, 0 ,0, 0, 1, CanFrameAnlysisFunc_0x4F1, CanFrameTimeoutFunc_0x4F1, NULL},
        //{0x51b,  20,  5000, 0 ,0, 0, 1, CanFrameAnlysisFunc_0x51b, CanFrameTimeoutFunc_0x51b, NULL},
        //{0x4a6,  20,  5000, 0 ,0, 0, 1, CanFrameAnlysisFunc_0x4a6, CanFrameTimeoutFunc_0x4a6, NULL},
        //{0x541,  100,  5000, 0 ,0, 0, 1, CanFrameAnlysisFunc_0x541, CanFrameTimeoutFunc_0x541, NULL},
        //{0x52a,  200,  5000, 0 ,0, 0, 1, CanFrameAnlysisFunc_0x52a, CanFrameTimeoutFunc_0x52a, NULL},
        //{0x50e,  200,  5000, 0 ,0, 0, 1, CanFrameAnlysisFunc_0x50e, CanFrameTimeoutFunc_0x50e, NULL},
        //{0x553,  200,  5000, 0 ,0, 0, 1, CanFrameAnlysisFunc_0x553, CanFrameTimeoutFunc_0x553, NULL},
        //{0x5b0,  1000,  5000, 0 ,0, 0, 1, CanFrameAnlysisFunc_0x5b0, CanFrameTimeoutFunc_0x5b0, NULL},
        //DN8C_MM-CAN_RX end
        //{0x1DF,  100,  1000, 0 ,0, 0, 1, CanFrameAnlysisFunc_0x1DF, CanFrameTimeoutFunc_0x1DF, NULL},
        0
};
                             


void InitCanRecvModule(void)
{
	for (uint8_t i = 0; i < (sizeof (CanInit) / sizeof (CanInit[0])); i++) {
		InitCanFrame(i, (INIT_CAN_FRAME*)&CanInit[i]);
	}
}

void CanFrameAnlysisFunc_0x1DF(uint8_t *data)
{
	CLU_HU_PE_01_ *p = (CLU_HU_PE_01_*)data;

	CLU_HU_PE_01.Clu_DispStatus = p->Clu_DispStatus;
	CLU_HU_PE_01.Clu_RheostatLvl = p->Clu_RheostatLvl;
}
void CanFrameTimeoutFunc_0x1DF(uint8_t Lv)
{
    
}

/*-----------------------------NX4C_CanFD-------------------------*/
/*391*/
void CanFrameAnlysisFunc_0x391(uint8_t *data)
{    
  //CLU21_ *p = (CLU21_*)data;
  
  
  CanFDDataStruct.CF_Clu_PaddUpSwState = data[0] & 0x01;

  
 // CLU21.CF_Clu_Vanz  = p->CF_Clu_Vanz         ;
}
/*0x430*/
void CanFrameAnlysisFunc_0x430(uint8_t * data)
{
    ICM_DisplayVehicleSpeed_ *p = (ICM_DisplayVehicleSpeed_*)data;
    
	ICM_DisplayVehicleSpeed.msg.bits.ICM_DisplayVehicleSpeed_L = data[0] & 0x1F;
    ICM_DisplayVehicleSpeed.msg.bits.ICM_DisplayVehicleSpeed_H = data[1];
    ICM_DisplayVehicleSpeed.msg.bits.ICM_BatteryVoltage = data[2];
    ICM_DisplayVehicleSpeed.msg.bits.ICM_HandBrakeSystemSts = data[0] >> 5;
    ICM_DisplayVehicleSpeed.msg.bits.TotalOdometer_km_L = data[5] & 0xF0;
    ICM_DisplayVehicleSpeed.msg.bits.TotalOdometer_km_L2 = data[6];
    ICM_DisplayVehicleSpeed.msg.bits.TotalOdometer_km_L3 = data[7];
    ICM_DisplayVehicleSpeed.msg.bits.ICM_DriverSeatBeltSwitch = (data[3] >> 1) & 0x1;
    ICM_DisplayVehicleSpeed.msg.bits.ICM_Low_Brake_Fluid = data[3] & 0x1;
    ICM_DisplayVehicleSpeed.msg.bits.MessageCounter = (data[3] >> 4) & 0xF; 
    
}

/*0x452*/
void CanFrameAnlysisFunc_0x452(uint8_t * data)
{
    ICM_AirBagLampFailSts_Reserved_ *p = (ICM_AirBagLampFailSts_Reserved_*)data;
    
	ICM_AirBagLampFailSts_Reserved.msg.bits.ICM_AirBagLampFailSts_Reserved = data[1] ;
    
    
}


/*0x4F1*/
void CanFrameAnlysisFunc_0x4F1(uint8_t *data)
{    
	CLU11_ *p = (CLU11_*)data;
	
	
    CanFDDataStruct.CF_Clu_CruiseSwState = data[0] & 0x07;
    CanFDDataStruct.CF_Clu_CruiseSwMain  = data[0] >>3 & 0x01;
    CanFDDataStruct.CF_Clu_SldMainSW      = p->CF_Clu_SldMainSW    ;
    CanFDDataStruct.CF_Clu_ParityBit1    = data[0] >>5 & 0x01;
    CanFDDataStruct.CF_Clu_VanzDecimal   = data[0] >>6 & 0x03;
    CanFDDataStruct.CF_Clu_Vanz_L        = data[1] ;
    CanFDDataStruct.CF_Clu_Vanz_H        = data[2] & 0x01;
    CanFDDataStruct.CF_Clu_SPEED_UNIT    = data[2] >>1 & 0x01;
    CanFDDataStruct.CF_Clu_RheostatLevel = data[2] >>3 & 0x1F;
	CanFDDataStruct.CF_Clu_AliveCnt1      = p->CF_Clu_AliveCnt1    ;
	
	CLU11.CF_Clu_Vanz  = p->CF_Clu_Vanz         ;
}
void CanFrameTimeoutFunc_0x4F1(uint8_t Lv)
{
    
}

//void CanFrameAnlysisFunc_0x08B(uint8_t data[])
//{
//	SWRC_05_200ms_ p = {0};
//	memcpy((void*)&p.Data[0], data, sizeof(SWRC_05_200ms_));
//
//	CanDataStruct.SWRC_Crc5Val = (uint8_t)p.SWRC_Crc5Val;
//	CanDataStruct.SWRC_AlvCnt5Val = (uint8_t)p.SWRC_AlvCnt5Val;
//	CanDataStruct.SWRC_DriveModCWSwSta = (uint8_t)p.SWRC_DriveModCWSwSta;
//	CanDataStruct.SWRC_DriveModCCWSwSta = (uint8_t)p.SWRC_DriveModCCWSwSta;
//	CanDataStruct.SWRC_BoostSwSta = (uint8_t)p.SWRC_BoostSwSta;
//	CanDataStruct.SWRC_DriveModeSwSta = (uint8_t)p.SWRC_DriveModeSwSta;
//
//
//}
void CanFrameAnlysisFunc_0x51b(uint8_t *data)
{
    CanFDDataStruct.CF_Clu_TirePressUnitNValueSet = data[0] & 0x07;
    CanFDDataStruct.CF_Clu_FCAModeNValueSet = data[2] >>1 & 0x07;
    CanFDDataStruct.CF_Clu_USMReset = data[4] >> 7;                                 
}

void CanFrameTimeoutFunc_0x51b(uint8_t Lv)
{
}

void CanFrameAnlysisFunc_0x4a6(uint8_t *data)
{
    CanFDDataStruct.CF_AVN_FCANValueSet = data[0] & 0x07;
    CanFDDataStruct.CF_AVN_CluUSMReset = data[0] >> 3 & 0x01;
    CanFDDataStruct.CF_AVN_DAWModeNValueSet = data[1] >> 3 &0x07;
    CanFDDataStruct.CF_AVN_WarningTimingNValueSet = data[3] >> 5 & 0x07;
    CanFDDataStruct.CF_AVN_LVDANValueSet = data[4] & 0x03;
    CanFDDataStruct.CF_AVN_LkaModeNValueSet = data[6] >> 1 & 0x07;
    CanFDDataStruct.CF_AVN_HBANValueSet = data[6] >> 6 & 0x03;
    CanFDDataStruct.CF_AVN_DAWModeNValueSet_New = data[7] >> 3 & 0x03;
    CanFDDataStruct.CF_Clu_DawResetReq = data[7] >> 5 & 0x01;
}

void CanFrameTimeoutFunc_0x4a6(uint8_t Lv)
{
}



void CanFrameTimeoutFunc_0x541(uint8_t Lv)
{
}


//0x541
void CanFrameAnlysisFunc_0x541(uint8_t *data)
{
    CanFDDataStruct.CF_Gway_IGNSw = data[0] & 0x07;
    CanFDDataStruct.CF_Gway_RKECmd = data[0]>>3 &0x07;
    CanFDDataStruct.CF_Gway_DrvKeyLockSw = data[0]>>6 & 0x01;
    CanFDDataStruct.CF_Gway_DrvKeyUnlockSw = data[0]>>7;
    CanFDDataStruct.CF_Gway_DrvDrSw = data[1] & 0x03;
    CanFDDataStruct.CF_Gway_DrvSeatBeltSw = data[1] >> 2 & 0x03;
    CanFDDataStruct.CF_Gway_TrunkTgSw = data[1]>>4 & 0x03;
    CanFDDataStruct.CF_Gway_AstSeatBeltSw = data[1] >> 6 & 0x03;
    CanFDDataStruct.CF_Gway_SMKOption = data[2] &0x01;
    CanFDDataStruct.CF_Gway_HoodSw = data[2]>>1 & 0x03;
    CanFDDataStruct.CF_Gway_TurnSigLh = data[2] >> 3 & 0x03;
    CanFDDataStruct.CF_Gway_WiperIntT = data[2] >> 5 ;
    CanFDDataStruct.CF_Gway_WiperIntSw = data[3] & 0x01;
    CanFDDataStruct.CF_Gway_WiperLowSw = data[3]>>1 & 0x01;
    CanFDDataStruct.CF_Gway_WiperHighSw = data[3] >> 2 &0x01;
    CanFDDataStruct.CF_Gway_WiperAutoSw = data[3] >>3 & 0x01;
    CanFDDataStruct.CF_Gway_RainSnsState = data[3] >> 4 &0x07;
    CanFDDataStruct.CF_Gway_HeadLampLow = data[3] >> 7;
    CanFDDataStruct.CF_Gway_HeadLampHigh = data[4] & 0x01;
    CanFDDataStruct.CF_Gway_HazardSw = data[4] >> 1 & 0x03;
    CanFDDataStruct.CF_Gway_AstDrSw = data[4]>>3 &0x01;
    CanFDDataStruct.CF_Gway_DefoggerRly = data[4] >>4 &0x01;
    CanFDDataStruct.CF_Gway_ALightStat = data[4] >>5 &0x01;
    CanFDDataStruct.CF_Gway_LightSwState =data[4]>>6 & 0x03;
    CanFDDataStruct.CF_Gway_Frt_Fog_Act = data[5] & 0x01;
    CanFDDataStruct.CF_Gway_TSigRHSw = data[5] >> 1 &0x01;
    CanFDDataStruct.CF_Gway_TSigLHSw = data[5] >> 2 & 0x01;
    CanFDDataStruct.CF_Gway_DriveTypeOption = data[5] >>3 &0x01;
    CanFDDataStruct.CF_Gway_StarterRlyState = data[5] >> 4 & 0x01;
    CanFDDataStruct.CF_Gway_PassiveAccessLock = data[5] >> 5 &0x03;
    CanFDDataStruct.CF_Gway_PassiveAccessUnlock = data[6] &0x03;
    CanFDDataStruct.CF_Gway_PassingSW = data[6] >> 3 & 0x01;
    CanFDDataStruct.CF_Gway_HBAControlMode = data[6] >> 4 & 0x01;
    CanFDDataStruct.CF_Gway_HLpHighSw = data[6] >> 5 & 0x01;
    CanFDDataStruct.CF_Gway_InhibitRMT = data[6] >> 6 &0x03;
    CanFDDataStruct.C_SunRoofOpenState = data[7]>>1 & 0x01; 
    CanFDDataStruct.CF_Gway_ParkBrakeSw = data[7] >> 4 &0x03;
    CanFDDataStruct.CF_Gway_TurnSigRh = data[7]>>6 & 0x03;
}

void CanFrameTimeoutFunc_0x52a(uint8_t Lv)
{
  
}


//0x52a
void CanFrameAnlysisFunc_0x52a(uint8_t *data)
{
    CanFDDataStruct.CF_Clu_LanguageInfo = data[4] >> 1 & 0x1F;
    CanFDDataStruct.CF_Gway_RVMSw = data[5] >> 6 & 0x03;
}


void CanFrameAnlysisFunc_0x50e(uint8_t *data)
{
    CanFDDataStruct.CF_Gway_ClutchIgnLockSW = data[0]>>5 & 0x01;
    CanFDDataStruct.CF_Gway_RrDefoggerInd = data[2] >> 7 &0x01;
}

void CanFrameTimeoutFunc_0x553(uint8_t Lv)
{
  
}
void CanFrameAnlysisFunc_0x553(uint8_t *data)
{
    CanFDDataStruct.CF_Gway_AutoLightValue = data[2] & 0x01;
    CanFDDataStruct.CF_Gway_RRDrSw = data[2]>>7 & 0x01;
    CanFDDataStruct.CF_Gway_RLDrSw = data[3] & 0x01;
    CanFDDataStruct.CF_Gway_CountryCfg = data[3] >> 2 & 0x07;
    CanFDDataStruct.CF_Gway_WiperParkPosition = data[4] &0x01;
    CanFDDataStruct.CF_Gway_SJBDeliveryMode = data[6] >> 7 & 0x01;
}

void CanFrameTimeoutFunc_0x5b0(uint8_t Lv)
{
  
}

void CanFrameAnlysisFunc_0x5b0(uint8_t *data)
{
    CanFDDataStruct.CF_Clu_Odometer1 = data[0];
    CanFDDataStruct.CF_Clu_Odometer2 = data[1];
    CanFDDataStruct.CF_Clu_Odometer3 = data[2];
    CanFDDataStruct.CR_Clu_OutTempSns = data[3];
}


void CanFrameAnlysisFunc_0x1D4(uint8_t *data)
{
	CLU_HU_PE_05_ *p = (CLU_HU_PE_05_*)data;

        CLU_HU_PE_05.Clu_Usm_VoiceVolume = p->Clu_Usm_VoiceVolume;
        CLU_HU_PE_05.Clu_Usm_AutoinitFuelEconomy = p->Clu_Usm_AutoinitFuelEconomy;
        CLU_HU_PE_05.Clu_Usm_WelcomeSound = p->Clu_Usm_WelcomeSound;
        CLU_HU_PE_05.CLU_Usm_Roadinfoguide = p->CLU_Usm_Roadinfoguide;
        CLU_HU_PE_05.CLU_Usm_WiperLight = p->CLU_Usm_WiperLight;
        CLU_HU_PE_05.Clu_Usm_TransmissionDisp = p->Clu_Usm_TransmissionDisp;
        CLU_HU_PE_05.Clu_Usm_FuelEconUnit_km = p->Clu_Usm_FuelEconUnit_km;
        CLU_HU_PE_05.Clu_Usm_AdasVolume = p->Clu_Usm_AdasVolume;
        CLU_HU_PE_05.Clu_Usm_SubspeedometerDisp = p->Clu_Usm_SubspeedometerDisp;      
        CLU_HU_PE_05.Clu_Usm_FuelEconUnit_mi = p->Clu_Usm_FuelEconUnit_mi;  
        CLU_HU_PE_05.Warn_Sound_AdasVolumeFeedback = p->Warn_Sound_AdasVolumeFeedback;           
}
void CanFrameTimeoutFunc_0x1D4(uint8_t Lv)
{
   
  
  
  
  
}




//MMcan
/*---------------------------------------------------------------------------*/
void CanFrameAnlysisFunc_0x6B3(uint8_t *data)
{
    TP_CLU_BAIDUM_HU_ *p = (TP_CLU_BAIDUM_HU_*)data;
    MMCanDataStruct.Byte0_TCP_4ED  = p -> Byte0_TCP_4ED;
    MMCanDataStruct.Byte1_Data_4ED = p -> Byte1_Data_4ED;
    MMCanDataStruct.Byte2_Data_4ED = p -> Byte2_Data_4ED;
    MMCanDataStruct.Byte3_Data_4ED = p -> Byte3_Data_4ED;
    MMCanDataStruct.Byte4_Data_4ED = p -> Byte4_Data_4ED;
    MMCanDataStruct.Byte5_Data_4ED = p -> Byte5_Data_4ED;
    MMCanDataStruct.Byte6_Data_4ED = p -> Byte6_Data_4ED;
    MMCanDataStruct.Byte7_Data_4ED = p -> Byte7_Data_4ED;	
}
void CanFrameTimeoutFunc_0x6B3(uint8_t Lv)
{
	
}	
void CanFrameAnlysisFunc_0x6B4(uint8_t *data)
{
    TP_CLU_BTSONG_HU_ *p = (TP_CLU_BTSONG_HU_*)data;
    MMCanDataStruct.Byte0_TCP_4F7  = p -> Byte0_TCP_4F7;
    MMCanDataStruct.Byte1_Data_4F7 = p -> Byte1_Data_4F7;
    MMCanDataStruct.Byte2_Data_4F7 = p -> Byte2_Data_4F7;
    MMCanDataStruct.Byte3_Data_4F7 = p -> Byte3_Data_4F7;
    MMCanDataStruct.Byte4_Data_4F7 = p -> Byte4_Data_4F7;
    MMCanDataStruct.Byte5_Data_4F7 = p -> Byte5_Data_4F7;
    MMCanDataStruct.Byte6_Data_4F7 = p -> Byte6_Data_4F7;
    MMCanDataStruct.Byte7_Data_4F7 = p -> Byte7_Data_4F7;	
}
void CanFrameTimeoutFunc_0x6B4(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6B5(uint8_t *data)
{
    TP_CLU_CARLIFE_HU_ *p = (TP_CLU_CARLIFE_HU_*)data;
    MMCanDataStruct.Byte0_TCP_4F1  = p -> Byte0_TCP_4F1;
    MMCanDataStruct.Byte1_Data_4F1 = p -> Byte1_Data_4F1;
    MMCanDataStruct.Byte2_Data_4F1 = p -> Byte2_Data_4F1;
    MMCanDataStruct.Byte3_Data_4F1 = p -> Byte3_Data_4F1;
    MMCanDataStruct.Byte4_Data_4F1 = p -> Byte4_Data_4F1;
	MMCanDataStruct.Byte5_Data_4F1 = p -> Byte5_Data_4F1;
	MMCanDataStruct.Byte6_Data_4F1 = p -> Byte6_Data_4F1;
	MMCanDataStruct.Byte7_Data_4F1 = p -> Byte7_Data_4F1;	
}
void CanFrameTimeoutFunc_0x6B5(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6B6(uint8_t *data)
{
    TP_CLU_CARPLAY_HU_ *p = (TP_CLU_CARPLAY_HU_*)data;
    MMCanDataStruct.Byte0_TCP_4F3  = p -> Byte0_TCP_4F3;
    MMCanDataStruct.Byte1_Data_4F3 = p -> Byte1_Data_4F3;
    MMCanDataStruct.Byte2_Data_4F3 = p -> Byte2_Data_4F3;
    MMCanDataStruct.Byte3_Data_4F3 = p -> Byte3_Data_4F3;
    MMCanDataStruct.Byte4_Data_4F3 = p -> Byte4_Data_4F3;
	MMCanDataStruct.Byte5_Data_4F3 = p -> Byte5_Data_4F3;
	MMCanDataStruct.Byte6_Data_4F3 = p -> Byte6_Data_4F3;
	MMCanDataStruct.Byte7_Data_4F3 = p -> Byte7_Data_4F3;	
}
void CanFrameTimeoutFunc_0x6B6(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6BB(uint8_t *data)
{
    TP_CLU_FM_HU_ *p = (TP_CLU_FM_HU_*)data;
    MMCanDataStruct.Byte0_TCP_4E9  = p -> Byte0_TCP_4E9;
    MMCanDataStruct.Byte1_Data_4E9 = p -> Byte1_Data_4E9;
    MMCanDataStruct.Byte2_Data_4E9 = p -> Byte2_Data_4E9;
    MMCanDataStruct.Byte3_Data_4E9 = p -> Byte3_Data_4E9;
    MMCanDataStruct.Byte4_Data_4E9 = p -> Byte4_Data_4E9;
	MMCanDataStruct.Byte5_Data_4E9 = p -> Byte5_Data_4E9;
	MMCanDataStruct.Byte6_Data_4E9 = p -> Byte6_Data_4E9;
	MMCanDataStruct.Byte7_Data_4E9 = p -> Byte7_Data_4E9;	
}
void CanFrameTimeoutFunc_0x6BB(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6BC(uint8_t *data)
{
    TP_CLU_HFNAME_HU_ *p = (TP_CLU_HFNAME_HU_*)data;
    MMCanDataStruct.Byte0_TCP_4F9  = p -> Byte0_TCP_4F9;
    MMCanDataStruct.Byte1_Data_4F9 = p -> Byte1_Data_4F9;
    MMCanDataStruct.Byte2_Data_4F9 = p -> Byte2_Data_4F9;
    MMCanDataStruct.Byte3_Data_4F9 = p -> Byte3_Data_4F9;
    MMCanDataStruct.Byte4_Data_4F9 = p -> Byte4_Data_4F9;
	MMCanDataStruct.Byte5_Data_4F9 = p -> Byte5_Data_4F9;
	MMCanDataStruct.Byte6_Data_4F9 = p -> Byte6_Data_4F9;
	MMCanDataStruct.Byte7_Data_4F9 = p -> Byte7_Data_4F9;	
}
void CanFrameTimeoutFunc_0x6BC(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6BD(uint8_t *data)
{
    TP_CLU_HFNO_HU_ *p = (TP_CLU_HFNO_HU_*)data;
    MMCanDataStruct.Byte0_TCP_484  = p -> Byte0_TCP_484;
    MMCanDataStruct.Byte1_Data_484 = p -> Byte1_Data_484;
    MMCanDataStruct.Byte2_Data_484 = p -> Byte2_Data_484;
    MMCanDataStruct.Byte3_Data_484 = p -> Byte3_Data_484;
    MMCanDataStruct.Byte4_Data_484 = p -> Byte4_Data_484;
	MMCanDataStruct.Byte5_Data_484 = p -> Byte5_Data_484;
	MMCanDataStruct.Byte6_Data_484 = p -> Byte6_Data_484;
	MMCanDataStruct.Byte7_Data_484 = p -> Byte7_Data_484;	
}
void CanFrameTimeoutFunc_0x6BD(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6BE(uint8_t *data)
{
    TP_CLU_IBOX_HU_ *p = (TP_CLU_IBOX_HU_*)data;
    MMCanDataStruct.Byte0_TCP_4EF  = p -> Byte0_TCP_4EF;
    MMCanDataStruct.Byte1_Data_4EF = p -> Byte1_Data_4EF;
    MMCanDataStruct.Byte2_Data_4EF = p -> Byte2_Data_4EF;
    MMCanDataStruct.Byte3_Data_4EF = p -> Byte3_Data_4EF;
    MMCanDataStruct.Byte4_Data_4EF = p -> Byte4_Data_4EF;
    MMCanDataStruct.Byte5_Data_4EF = p -> Byte5_Data_4EF;
    MMCanDataStruct.Byte6_Data_4EF = p -> Byte6_Data_4EF;
    MMCanDataStruct.Byte7_Data_4EF = p -> Byte7_Data_4EF;
    
}
void CanFrameTimeoutFunc_0x6BE(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6BF(uint8_t *data)
{
    TP_CLU_Ipod_HU_ *p = (TP_CLU_Ipod_HU_*)data;
    MMCanDataStruct.Byte0_TCP_49A  = p -> Byte0_TCP_49A;
    MMCanDataStruct.Byte1_Data_49A = p -> Byte1_Data_49A;
    MMCanDataStruct.Byte2_Data_49A = p -> Byte2_Data_49A;
    MMCanDataStruct.Byte3_Data_49A = p -> Byte3_Data_49A;
    MMCanDataStruct.Byte4_Data_49A = p -> Byte4_Data_49A;
    MMCanDataStruct.Byte5_Data_49A = p -> Byte5_Data_49A;
    MMCanDataStruct.Byte6_Data_49A = p -> Byte6_Data_49A;
    MMCanDataStruct.Byte7_Data_49A = p -> Byte7_Data_49A;	
}
void CanFrameTimeoutFunc_0x6BF(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6C2(uint8_t *data)
{
    TP_CLU_KAOLA_HU_ *p = (TP_CLU_KAOLA_HU_*)data;
    MMCanDataStruct.Byte0_TCP_4E7  = p -> Byte0_TCP_4E7;
    MMCanDataStruct.Byte1_Data_4E7 = p -> Byte1_Data_4E7;
    MMCanDataStruct.Byte2_Data_4E7 = p -> Byte2_Data_4E7;
    MMCanDataStruct.Byte3_Data_4E7 = p -> Byte3_Data_4E7;
    MMCanDataStruct.Byte4_Data_4E7 = p -> Byte4_Data_4E7;
	MMCanDataStruct.Byte5_Data_4E7 = p -> Byte5_Data_4E7;
	MMCanDataStruct.Byte6_Data_4E7 = p -> Byte6_Data_4E7;
	MMCanDataStruct.Byte7_Data_4E7 = p -> Byte7_Data_4E7;	
}
void CanFrameTimeoutFunc_0x6C2(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6C5(uint8_t *data)
{
    TP_CLU_NAVI_HU_ *p = (TP_CLU_NAVI_HU_*)data;
    MMCanDataStruct.Byte0_TCP_48C  = p -> Byte0_TCP_48C;
    MMCanDataStruct.Byte1_Data_48C = p -> Byte1_Data_48C;
    MMCanDataStruct.Byte2_Data_48C = p -> Byte2_Data_48C;
    MMCanDataStruct.Byte3_Data_48C = p -> Byte3_Data_48C;
    MMCanDataStruct.Byte4_Data_48C = p -> Byte4_Data_48C;
	MMCanDataStruct.Byte5_Data_48C = p -> Byte5_Data_48C;
	MMCanDataStruct.Byte6_Data_48C = p -> Byte6_Data_48C;
	MMCanDataStruct.Byte7_Data_48C = p -> Byte7_Data_48C;	
}
void CanFrameTimeoutFunc_0x6C5(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6C6(uint8_t *data)
{
    TP_CLU_QQMUSIC_HU_ *p = (TP_CLU_QQMUSIC_HU_*)data;
    MMCanDataStruct.Byte0_TCP_4E5  = p -> Byte0_TCP_4E5;
    MMCanDataStruct.Byte1_Data_4E5 = p -> Byte1_Data_4E5;
    MMCanDataStruct.Byte2_Data_4E5 = p -> Byte2_Data_4E5;
    MMCanDataStruct.Byte3_Data_4E5 = p -> Byte3_Data_4E5;
    MMCanDataStruct.Byte4_Data_4E5 = p -> Byte4_Data_4E5;
	MMCanDataStruct.Byte5_Data_4E5 = p -> Byte5_Data_4E5;
	MMCanDataStruct.Byte6_Data_4E5 = p -> Byte6_Data_4E5;
	MMCanDataStruct.Byte7_Data_4E5 = p -> Byte7_Data_4E5;	
}
void CanFrameTimeoutFunc_0x6C6(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6C8(uint8_t *data)
{
    TP_CLU_USB_HU_ *p = (TP_CLU_USB_HU_*)data;
    MMCanDataStruct.Byte0_TCP_497  = p -> Byte0_TCP_497;
    MMCanDataStruct.Byte1_Data_497 = p -> Byte1_Data_497;
    MMCanDataStruct.Byte2_Data_497 = p -> Byte2_Data_497;
    MMCanDataStruct.Byte3_Data_497 = p -> Byte3_Data_497;
    MMCanDataStruct.Byte4_Data_497 = p -> Byte4_Data_497;
	MMCanDataStruct.Byte5_Data_497 = p -> Byte5_Data_497;
	MMCanDataStruct.Byte6_Data_497 = p -> Byte6_Data_497;
	MMCanDataStruct.Byte7_Data_497 = p -> Byte7_Data_497;	
}
void CanFrameTimeoutFunc_0x6C8(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x7DF(uint8_t *data)
{
    GST_ALL_ *p = (GST_ALL_*)data;
    MMCanDataStruct.GST_ALL_Byte0 = p -> GST_ALL_Byte0;
    MMCanDataStruct.GST_ALL_Byte1 = p -> GST_ALL_Byte1;
    MMCanDataStruct.GST_ALL_Byte2 = p -> GST_ALL_Byte2;
    MMCanDataStruct.GST_ALL_Byte3 = p -> GST_ALL_Byte3;
    MMCanDataStruct.GST_ALL_Byte4 = p -> GST_ALL_Byte4;
	MMCanDataStruct.GST_ALL_Byte5 = p -> GST_ALL_Byte5;
	MMCanDataStruct.GST_ALL_Byte6 = p -> GST_ALL_Byte6;
	MMCanDataStruct.GST_ALL_Byte7 = p -> GST_ALL_Byte7;	
}
void CanFrameTimeoutFunc_0x7DF(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x32A(uint8_t *data)
{
//    HU_BLE_PE_00_ *p = (HU_BLE_PE_00_*)data;
//    MMCanDataStruct.C_BLEOption = p -> C_BLEOption;
//    
//    MMCanDataStruct.C_BLEOption = p->C_BLEOption;
//    if (MMCanDataStruct.C_BLEOption == 1) {
//        if (SoftwareVariantCoding.ModuleBLERecvCnt < 1) {
//            SoftwareVariantCoding.ModuleBLERecvCnt++;
//        } 
//        if (SoftwareVariantCoding.ModuleBLERecvCnt >= 1) {
//            SoftwareVariantCoding.ModuleBLE = 1;
//        }
//    }
//    
//    MMCanDataStruct.C_BLE_ProfileIDRValue = p -> C_BLE_ProfileIDRValue;
//    MMCanDataStruct.C_BLEIDOut = p -> C_BLEIDOut;
//    MMCanDataStruct.C_BLEKeyreminder = p -> C_BLEKeyreminder;
}
void CanFrameTimeoutFunc_0x32A(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x115(uint8_t *data)
{
    HU_CLU_PE_02_ *p = (HU_CLU_PE_02_*)data;
    MMCanDataStruct.TBT_Display_Type = p->TBT_Display_Type;
    MMCanDataStruct.TBT_Side_Street = ByteToHalfWord(p->TBT_Side_Street_H, p->TBT_Side_Street_L);
    MMCanDataStruct.TBT_Direction = p->TBT_Direction;
    MMCanDataStruct.TBT_Distance_Turn_Point = ByteToHalfWord(p->TBT_Distance_Turn_Point_H, p->TBT_Distance_Turn_Point_L);
    MMCanDataStruct.TBT_Combined_Side_Street = p->TBT_Combined_Side_Street;
    MMCanDataStruct.TBT_Scale = p->TBT_Scale;
    MMCanDataStruct.TBT_DistancetoTurnPoint = p->TBT_DistancetoTurnPoint;
}
void CanFrameTimeoutFunc_0x4CC(uint8_t Lv)
{
    MMCanDataStruct.TBT_Display_Type = 0;
}

void CanFrameAnlysisFunc_0x4F2(uint8_t *data)
{
    HU_CLU_PE_05_ *p = (HU_CLU_PE_05_*)data;
    MMCanDataStruct.HU_LanguageInfo = p -> HU_LanguageInfo;
    MMCanDataStruct.HU_VolumeStatus = p -> HU_VolumeStatus;
    MMCanDataStruct.HU_MuteStatus = p -> HU_MuteStatus;
    MMCanDataStruct.HU_NaviStatus = p -> HU_NaviStatus;
    MMCanDataStruct.HU_NaviDisp = p -> HU_NaviDisp;
    MMCanDataStruct.HU_NaviCamSettingStatus = p -> HU_NaviCamSettingStatus;	
}
void CanFrameTimeoutFunc_0x4F2(uint8_t Lv)
{
    MMCanDataStruct.HU_NaviStatus = 0;	
}

/*void CanFrameTimeoutFunc_0x44E(uint8_t *data)
{
    CGW_PC14_ *p = (CGW_PC14_*)data;
    MMCanDataStruct.CF_Ems_IsgWarning = p -> CF_Ems_IsgWarning;
}*/

void CanFrameAnlysisFunc_0x4CE(uint8_t *data)
{
    HU_CLU_PE_06_ *p = (HU_CLU_PE_06_*)data;
    MMCanDataStruct. HU_OpState_New = p -> HU_OpState_New;
    MMCanDataStruct.FM_Decimal_Point = p -> FM_Decimal_Point;
    MMCanDataStruct.HU_FMFrequency_Offset_Type = p -> HU_FMFrequency_Offset_Type;
    MMCanDataStruct.HU_User_Input = p -> HU_User_Input;
    MMCanDataStruct.HU_Frequency_Unit = p -> HU_Frequency_Unit;
    MMCanDataStruct.HU_Track_Number_New = ByteToHalfWord(p -> HU_Track_Number_New_H,p -> HU_Track_Number_New_L);
    MMCanDataStruct.HU_Frequency_New =  ByteToHalfWord(p -> HU_Frequency_New_H,p -> HU_Frequency_New_L);
}
void CanFrameTimeoutFunc_0x4CE(uint8_t Lv)
{
    MMCanDataStruct.HU_User_Input = 0;
    MMCanDataStruct.HU_Frequency_New = 0x1fff;
    MMCanDataStruct.HU_Frequency_Unit = 0;
    MMCanDataStruct.HU_FMFrequency_Offset_Type = 0;
    MMCanDataStruct.FM_Decimal_Point = 3;
    MMCanDataStruct.HU_Track_Number_New = 0xffff;
}    

void CanFrameAnlysisFunc_0x640(uint8_t *data)
{
    HU_CLU_PE_07_ *p = (HU_CLU_PE_07_*)data;
    MMCanDataStruct.NV_Display_TG = p -> NV_Display_TG;
    MMCanDataStruct.TBT_BarGraph100Level = p -> TBT_BarGraph100Level;
}
void CanFrameTimeoutFunc_0x640(uint8_t Lv)
{
    MMCanDataStruct.TBT_BarGraph100Level = 0xff;
    MMCanDataStruct.NV_Display_TG = 0;
}

void CanFrameAnlysisFunc_0x641(uint8_t *data)
{
    HU_CLU_PE_10_ *p = (HU_CLU_PE_10_*)data;
    MMCanDataStruct.Navi_WarnDist_OverDec = p -> Navi_WarnDist_OverDec;
    MMCanDataStruct.Navi_WarnDist_Scale = p -> Navi_WarnDist_Scale;
    MMCanDataStruct.Navi_WarnDist_UnderDec = p -> Navi_WarnDist_UnderDec;
}
void CanFrameTimeoutFunc_0x641(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x4E7(uint8_t *data)
{
    HU_CLU_PE_11_ *p = (HU_CLU_PE_11_*)data;
    MMCanDataStruct.Navi_OverSpdAlarm = p -> Navi_OverSpdAlarm;
    MMCanDataStruct.Navi_WarningZone2 = p -> Navi_WarningZone2;
    MMCanDataStruct.Navi_NonSpdTrap = p -> Navi_NonSpdTrap;
    MMCanDataStruct.Navi_WarningZone3 = p -> Navi_WarningZone3;
    MMCanDataStruct.Navi_WarningZone = p -> Navi_WarningZone;
	MMCanDataStruct.Navi_CurveWarning = p -> Navi_CurveWarning;
	MMCanDataStruct.Navi_SpdInfo_Type = p -> Navi_SpdInfo_Type;
	MMCanDataStruct.Navi_SpdLimit_Unit = p -> Navi_SpdLimit_Unit;	
	MMCanDataStruct.Navi_SpdLimit_Type = p -> Navi_SpdLimit_Type;
    MMCanDataStruct.Navi_SpdLimit = p -> Navi_SpdLimit;
}		
void CanFrameTimeoutFunc_0x4E7(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x4E8(uint8_t *data)
{
    HU_CLU_PE_13_ *p = (HU_CLU_PE_13_*)data;
    if(p -> NV_EstDist_F > 0xa){
        p -> NV_EstDist_F = 0;
    }

     MMCanDataStruct.NV_EstDist_F    = p -> NV_EstDist_F;  
    MMCanDataStruct.NV_EstDist_Unit = p -> NV_EstDist_Unit;
    MMCanDataStruct.NV_EstHour = p -> NV_EstHour;
    MMCanDataStruct.NV_EstMin = p -> NV_EstMin;
    MMCanDataStruct.NV_Azimuth = p -> NV_Azimuth;
    MMCanDataStruct.NV_EstDist_I = ByteToHalfWord(p->NV_EstDist_I_H, p->NV_EstDist_I_L);
    MMCanDataStruct.NV_EstimTimeFormat = p -> NV_EstimTimeFormat;	
    MMCanDataStruct.NV_EstimTimeType = p -> NV_EstimTimeType;

      if ((MMCanDataStruct.NV_EstPointType != p->NV_EstPointType) && ((p->NV_EstPointType == 0) || (p->NV_EstPointType == 1) || (p->NV_EstPointType == 2) || (p->NV_EstPointType == 3) || (p->NV_EstPointType == 4))) {
//              MCanTpDataNewValid = MM_CAN_TP_DATA_DISPLAY_OFF_RENDERING;
	MMCanDataStruct.NV_EstPointType = p -> NV_EstPointType;
      }
}
void CanFrameTimeoutFunc_0x4E8(uint8_t Lv)
{
    MMCanDataStruct.NV_EstPointType = 0xf;
    MMCanDataStruct.NV_EstDist_Unit = 0xf;
    MMCanDataStruct.NV_EstDist_I = 0xffff;
    MMCanDataStruct.NV_EstimTimeType = 0;
    MMCanDataStruct.NV_EstimTimeFormat = 0;	
    MMCanDataStruct.NV_EstHour = 0;
    MMCanDataStruct.NV_EstMin = 0;
}

void CanFrameAnlysisFunc_0x4A1(uint8_t *data)
{
    HU_CNTL_E_01_ *p = (HU_CNTL_E_01_*)data;
    MMCanDataStruct.C_AstWindowCmdAVN = p -> C_AstWindowCmdAVN;
    MMCanDataStruct.C_DrvWindowCmdAVN = p -> C_DrvWindowCmdAVN;
    MMCanDataStruct.C_PTGCNTLCmdAVN = p -> C_PTGCNTLCmdAVN;
    MMCanDataStruct.C_StrgWhlHeatedCmdAVN = p -> C_StrgWhlHeatedCmdAVN;
    MMCanDataStruct.C_RrDefoggerCmdAVN = p -> C_RrDefoggerCmdAVN;
    MMCanDataStruct.C_AVNIMSButtonCmd = p -> C_AVNIMSButtonCmd;
    MMCanDataStruct.C_RRWindowCmdAVN = p -> C_RRWindowCmdAVN;
    MMCanDataStruct.C_RLWindowCmdAVN = p -> C_RLWindowCmdAVN;	
    MMCanDataStruct.C_BlindCmdAVN = p -> C_BlindCmdAVN;
    MMCanDataStruct.C_GlassCmdAVN = p -> C_GlassCmdAVN;
    MMCanDataStruct.C_CluDispCmdAVN = p -> C_CluDispCmdAVN;
}
void CanFrameTimeoutFunc_0x4A1(uint8_t Lv)
{
    
}

void CanFrameAnlysisFunc_0x4D7(uint8_t *data)
{
    HU_Car_PE_01_ *p = (HU_Car_PE_01_*)data;
    MMCanDataStruct.HU_VehiclePwr = p -> HU_VehiclePwr;
}
void CanFrameTimeoutFunc_0x4D7(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x49F(uint8_t *data)
{
    HU_DATC_E_02_ *p = (HU_DATC_E_02_*)data;
    MMCanDataStruct.HU_DATC_DrTempUpDn = p -> HU_DATC_DrTempUpDn;
    MMCanDataStruct.HU_DATC_MainBlower = p -> HU_DATC_MainBlower;
    MMCanDataStruct.HU_DATC_FrontModeSet = p -> HU_DATC_FrontModeSet;
    MMCanDataStruct.HU_DATC_IntakeSet = p -> HU_DATC_IntakeSet;
    MMCanDataStruct.HU_DATC_AutoSet = p -> HU_DATC_AutoSet;
	MMCanDataStruct.HU_DATC_FrontDefog = p -> HU_DATC_FrontDefog;
	MMCanDataStruct.HU_DATC_AcSet = p -> HU_DATC_AcSet;
	MMCanDataStruct.HU_DATC_AirCleaningSet = p -> HU_DATC_AirCleaningSet;	
    MMCanDataStruct.HU_DATC_MainBlowerUpDn = p -> HU_DATC_MainBlowerUpDn;
} 
void CanFrameTimeoutFunc_0x49F(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x4A0(uint8_t *data)
{
    HU_DATC_E_03_ *p = (HU_DATC_E_03_*)data;
    MMCanDataStruct.HU_DATC_DrTempSetC = p -> HU_DATC_DrTempSetC;
    MMCanDataStruct.HU_DATC_DrTempSetF = p -> HU_DATC_DrTempSetF;
}
void CanFrameTimeoutFunc_0x4A0(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x4F3(uint8_t *data)
{
    HU_DATC_PE_00_ *p = (HU_DATC_PE_00_*)data;
    MMCanDataStruct.HU_PhoneActivity = p -> HU_PhoneActivity;
    MMCanDataStruct.HU_VRActivity = p -> HU_VRActivity;	
}
void CanFrameTimeoutFunc_0x4F3(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x4D8(uint8_t *data)
{
    HU_GW_PE_01_ *p = (HU_GW_PE_01_*)data;
    MMCanDataStruct.HU_AliveStatus = p -> HU_AliveStatus;
    MMCanDataStruct.CF_AVN_ProfileIDRValue = p -> CF_AVN_ProfileIDRValue;
}
void CanFrameTimeoutFunc_0x4D8(uint8_t Lv)
{
    MMCanDataStruct.HU_AliveStatus = 0;
}

void CanFrameAnlysisFunc_0x4FE(uint8_t *data)
{
    HU_MON_PE_01_ *p = (HU_MON_PE_01_*)data;
    MMCanDataStruct.HU_Type = p -> HU_Type;
    MMCanDataStruct.HU_DistributeInfo = p -> HU_DistributeInfo;
    MMCanDataStruct.HU_OptionInfo = ByteToHalfWord(p->HU_OptionInfo_H, p->HU_OptionInfo_L);
    MMCanDataStruct.HU_AdasSupport = p -> HU_AdasSupport;	

    if (MMCanDataStruct.HU_Type == 0xfb) {
            SoftwareVariantCoding.ModuleAVN_AV = 1;
    }
//    if (MMCanDataStruct.HU_Type == 0xfc) {
//            SoftwareVariantCoding.ModuleAVN_TBT = 1;
//    }
    
    if ((MMCanDataStruct.HU_OptionInfo & 0x1) == 0x1) {
            SoftwareVariantCoding.ModuleAVN_TBT = 1;
    }
    if (MMCanDataStruct.HU_Type == 0xfe || MMCanDataStruct.HU_Type == 0xfd) {
        SoftwareVariantCoding.ModuleAVN_AV = 1;
        SoftwareVariantCoding.ModuleAVN_TBT = 1;
    }



}
void CanFrameTimeoutFunc_0x4FE(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x4DE(uint8_t *data)
{
    HU_NAVI_V2_POS_PE_ *p = (HU_NAVI_V2_POS_PE_*)data;
    MMCanDataStruct.POS_V2_Offset = p -> POS_V2_Offset;
    MMCanDataStruct.POS_V2_CyclicCounter = p -> POS_V2_CyclicCounter;
    MMCanDataStruct.POS_V2_RangeAvgSpeed = p -> POS_V2_RangeAvgSpeed;	
}
void CanFrameTimeoutFunc_0x4DE(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x4B8(uint8_t *data)
{
    HU_NAVI_V2_PROLONG_E_ *p = (HU_NAVI_V2_PROLONG_E_*)data;
    MMCanDataStruct.PROLONG_V2_Value = p -> PROLONG_V2_Value;
    MMCanDataStruct.PROLONG_V2_Offset = p -> PROLONG_V2_Offset;
    MMCanDataStruct.PROLONG_V2_CyclicCounter = p -> PROLONG_V2_CyclicCounter;
    MMCanDataStruct.PROLONG_V2_Update = p -> PROLONG_V2_Update;
    MMCanDataStruct.PROLONG_V2_ProfileType = p -> PROLONG_V2_ProfileType;	
}
void CanFrameTimeoutFunc_0x4B8(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x4B7(uint8_t *data)
{
    HU_NAVI_V2_PROSHORT_E_00_ *p = (HU_NAVI_V2_PROSHORT_E_00_*)data;
    MMCanDataStruct.PROSHORT_V2_Offset = p -> PROSHORT_V2_Offset;
    MMCanDataStruct.PROSHORT_V2_CyclicCounter = p -> PROSHORT_V2_CyclicCounter;
    MMCanDataStruct.PROSHORT_V2_Distance = p -> PROSHORT_V2_Distance;
    MMCanDataStruct.PROSHORT_V2_Value0 = p -> PROSHORT_V2_Value0;
    MMCanDataStruct.PROSHORT_V2_Value1 = p -> PROSHORT_V2_Value1;
    MMCanDataStruct.PROSHORT_V2_ProfileType = p -> PROSHORT_V2_ProfileType;	
}
void CanFrameTimeoutFunc_0x4B7(uint8_t Lv)
{
	
}

/*{
    ECALL_CLU_PE_01_ *p = (ECALL_CLU_PE_01_*)data;
    MMCanDataStruct.eCall_SWL_Ind = p -> eCall_SWL_Ind;
}*/

void CanFrameAnlysisFunc_0x4B4(uint8_t *data)
{
    HU_NAVI_V2_SEG_E_ *p = (HU_NAVI_V2_SEG_E_*)data;
    MMCanDataStruct.SEG_V2_Offset = p -> SEG_V2_Offset;
    MMCanDataStruct.SEG_V2_CyclicCounter = p -> SEG_V2_CyclicCounter;
    MMCanDataStruct.SEG_V2_Retransmission = p -> SEG_V2_Retransmission;
    MMCanDataStruct.SEG_V2_CalculatedRoute = p -> SEG_V2_CalculatedRoute;
    MMCanDataStruct.SEG_V2_FuncRoadClass = p -> SEG_V2_FuncRoadClass;
	MMCanDataStruct.SEG_V2_SpeedLimit = p -> SEG_V2_SpeedLimit;
	MMCanDataStruct.SEG_V2_FormOfWay = p -> SEG_V2_FormOfWay;
	MMCanDataStruct.SEG_V2_DirectionLanes = p -> SEG_V2_DirectionLanes;	
    MMCanDataStruct.SEG_V2_SpeedLimitUnder5 = p -> SEG_V2_SpeedLimitUnder5;
}
void CanFrameTimeoutFunc_0x4B4(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x4A3(uint8_t *data)
{
    HU_Navi_ISLW_PE_00_ *p = (HU_Navi_ISLW_PE_00_*)data;
    MMCanDataStruct.Navi_ISLW_LinkClass = p -> Navi_ISLW_LinkClass;
    MMCanDataStruct.Navi_ISLW_Frwinfo = p -> Navi_ISLW_Frwinfo;
    MMCanDataStruct.Navi_ISLW_SpdUnit = p -> Navi_ISLW_SpdUnit;
    MMCanDataStruct.Navi_ISLW_SpdLimit = p -> Navi_ISLW_SpdLimit;
    MMCanDataStruct.Navi_ISLW_CountryCode = p -> Navi_ISLW_CountryCode;
	MMCanDataStruct.Navi_ISLW_MapSource = p -> Navi_ISLW_MapSource;
	MMCanDataStruct.Navi_ISLW_TollExist = p -> Navi_ISLW_TollExist;
	MMCanDataStruct.Navi_ISLW_TunnelExist = p -> Navi_ISLW_TunnelExist;	
    MMCanDataStruct.Navi_ISLW_TimeSpd = p -> Navi_ISLW_TimeSpd;
}
void CanFrameTimeoutFunc_0x4A3(uint8_t Lv)
{
	
}
//void CanFrameAnlysisFunc_0xA3(uint8_t *data)
//{
//    ABS1 *p = (ABS1*)data;  
//}
//

void CanFrameAnlysisFunc_0x4A8(uint8_t *data)
{
    HU_USM_E_01_ *p = (HU_USM_E_01_*)data;   
//    Msg0x479Time.msgEvent = SEND_TYPE_MM_0x4A8;
//    AppMsgTime[MSG_0x472].msgEvent = 1;
//    
//    if (p->CF_AVN_AdasVolumeNValueSet != 7) {
//        if ((p->CF_AVN_AdasVolumeNValueSet != 1) && (p->CF_AVN_AdasVolumeNValueSet != 2) && (p->CF_AVN_AdasVolumeNValueSet != 3) && (p->CF_AVN_AdasVolumeNValueSet != 6)) {
//            p->CF_AVN_AdasVolumeNValueSet = 2;
//        }
//        
//        if ((GetCanFrameAliveTime(0x160) == CAN_FRAME_STATE_TIME_OUT) || (GetCanFrameAliveTime(0x1A0) == CAN_FRAME_STATE_TIME_OUT) || (GetCanFrameAliveTime(0x12A) == CAN_FRAME_STATE_TIME_OUT) || (GetCanFrameAliveTime(0x1E0) == CAN_FRAME_STATE_TIME_OUT) || (GetCanFrameAliveTime(0x1E5) == CAN_FRAME_STATE_TIME_OUT)) {
//            p->CF_AVN_AdasVolumeNValueSet = 0;
//        }
//    
//        if ((MMCanDataStruct.CF_AVN_AdasVolumeNValueSet != p->CF_AVN_AdasVolumeNValueSet) && ((p->CF_AVN_AdasVolumeNValueSet == 1) || (p->CF_AVN_AdasVolumeNValueSet == 2) || (p->CF_AVN_AdasVolumeNValueSet == 3) || (p->CF_AVN_AdasVolumeNValueSet == 6))) {
//                AdasVolumeFeedbackTimer = 800;
//        }
//        MMCanDataStruct.CF_AVN_AdasVolumeNValueSet = p -> CF_AVN_AdasVolumeNValueSet;
//        if (MMCanUsmPara.AVNAdasVolume != MMCanDataStruct.CF_AVN_AdasVolumeNValueSet) {
//            SaveMiscValid = 1;
//        }
//        if ((GetCanFrameAliveTime(0x160) != CAN_FRAME_STATE_TIME_OUT) || (GetCanFrameAliveTime(0x1A0) != CAN_FRAME_STATE_TIME_OUT) || (GetCanFrameAliveTime(0x12A) != CAN_FRAME_STATE_TIME_OUT) || (GetCanFrameAliveTime(0x1E0) != CAN_FRAME_STATE_TIME_OUT) || (GetCanFrameAliveTime(0x1E5) != CAN_FRAME_STATE_TIME_OUT)) {
//            MMCanUsmPara.AVNAdasVolume = MMCanDataStruct.CF_AVN_AdasVolumeNValueSet;
//            AppMsgTime[MSG_0x472].msgEvent = 1;
//        } else {
//            MMCanUsmPara.AVNAdasVolume = 0;
//        }
//    }
     
//    if (p->CF_AVN_HDANValueSet != 3) {
//        MMCanDataStruct.CF_AVN_HDANValueSet = p -> CF_AVN_HDANValueSet;
//    }
//    
//    if (p->CF_AVN_SCCDrvModeNValueSet != 7) {
//        MMCanDataStruct.CF_AVN_SCCDrvModeNValueSet = p -> CF_AVN_SCCDrvModeNValueSet;
//    }
//    
//    
//    if (p->CF_AVN_WarningTimingNValueSet != 7) {
//        MMCanDataStruct.CF_AVN_WarningTimingNValueSet = p -> CF_AVN_WarningTimingNValueSet;	
//    }
//    
//    if (p->CF_AVN_FCANValueSet != 7) {
//        MMCanDataStruct.CF_AVN_FCANValueSet = p -> CF_AVN_FCANValueSet; 
//    }
//    
//    if (p->CF_AVN_LkaModeNValueSet != 7) {
//        MMCanDataStruct.CF_AVN_LkaModeNValueSet = p -> CF_AVN_LkaModeNValueSet;
//        Msg0x46FTime.msgEvent = SEND_TYPE_MM_0x4A8;
//    }
//    
//    if (p->CF_AVN_SEANValueSet != 3) {
//        MMCanDataStruct.CF_AVN_SEANValueSet = p -> CF_AVN_SEANValueSet;
//    }
//    
//    if (p->CF_AVN_BCANValueSet != 7) {
//        MMCanDataStruct.CF_AVN_BCANValueSet = p -> CF_AVN_BCANValueSet;
//    }
//    
//   if (p->CF_AVN_NSCCCamNValueSet != 3) {
//        MMCanDataStruct.CF_AVN_NSCCCamNValueSet = p -> CF_AVN_NSCCCamNValueSet;
//    }
//    
//     /*NX4C ٹ·Զ */  
////    if (p->CF_AVN_NSCCCrvNValueSet != 3) {
////        MMCanDataStruct.CF_AVN_NSCCCrvNValueSet = p -> CF_AVN_NSCCCrvNValueSet;  
////    }
//    
//    if(p -> CF_AVN_RCCWNValueSet != 3){
//        MMCanDataStruct.CF_AVN_RCCWNValueSet = p -> CF_AVN_RCCWNValueSet;
//        Msg0x46FTime.msgEvent = SEND_TYPE_MM_0x4A8;
//    }
//    
//    
//    
//    
//    
//    MMCanDataStruct.CF_AVN_ISLWNValueSet = p -> CF_AVN_ISLWNValueSet;   
//    MMCanDataStruct.CF_AVN_BCWSndWanNValueSet = p -> CF_AVN_BCWSndWanNValueSet;
    
    
    
}
void CanFrameTimeoutFunc_0x4A8(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x4AB(uint8_t *data)
{
    //HU_USM_E_04_ *p = (HU_USM_E_04_*)data;

    /*SOUND C WELCOME SOUND*/
//    if (p->CF_AVN_CluWelcomeSnd != 3) {              
//            MMCanDataStruct.CF_AVN_CluWelcomeSnd = p->CF_AVN_CluWelcomeSnd;
//            if (MMCanDataStruct.CF_AVN_CluWelcomeSnd != MMCanUsmPara.AVNWelcomeSoundSt) {
//                SaveMiscValid = 1;
//            }
//            if (MMCanDataStruct.CF_AVN_CluWelcomeSnd == 1) {
//                MMCanUsmPara.AVNWelcomeSoundSt = WELCOME_SOUND_OFF;
//            } else {
//                MMCanUsmPara.AVNWelcomeSoundSt = WELCOME_SOUND_ON;
//            }
//     }
//
//      /*CONVENIENCE C TRAFFIC INFORMATION*/
//      if (p->CF_AVN_CluRoadInfoGuide != 3) {
//              MMCanDataStruct.CF_AVN_CluRoadInfoGuide = p->CF_AVN_CluRoadInfoGuide;
//              if (MMCanDataStruct.CF_AVN_CluRoadInfoGuide != MMCanUsmPara.AVNRoadInfoGuideSt) {
//                  SaveMiscValid = 1;
//              }
//              if (MMCanDataStruct.CF_AVN_CluRoadInfoGuide == 2) {
//                  MMCanUsmPara.AVNRoadInfoGuideSt = ROAD_INFO_GUIDE_ON;
//              } else {
//                  MMCanUsmPara.AVNRoadInfoGuideSt = ROAD_INFO_GUIDE_OFF;
//              }
//          }
//    
//     /*CONVENIENCE C WIPER_LIGHTS DISPLAY*/
//     if (p->CF_AVN_CluWiperLight != 3) {
//        MMCanDataStruct.CF_AVN_CluWiperLight = p->CF_AVN_CluWiperLight;
//        if (MMCanDataStruct.CF_AVN_CluWiperLight != MMCanUsmPara.AVNWiperLightSt) {
//            SaveMiscValid = 1;
//        }
//        if (MMCanDataStruct.CF_AVN_CluWiperLight == 1) {
//            MMCanUsmPara.AVNWiperLightSt = WIPER_LIGHT_OFF;
//        } else {
//            MMCanUsmPara.AVNWiperLightSt = WIPER_LIGHT_ON;
//        }
//    }
//
//     /*CONVENIENCE C GEAR POSITION POP-UP*/   /*λȡ*/
////      if (p->CF_AVN_CluTransmissionDisp != 3) {
////              MMCanDataStruct.CF_AVN_CluTransmissionDisp = p->CF_AVN_CluTransmissionDisp;
////              if (MMCanDataStruct.CF_AVN_CluTransmissionDisp != MMCanUsmPara.AVNTransmissionDisp) {
////                  SaveMiscValid = 1;
////              }
////              if (MMCanDataStruct.CF_AVN_CluTransmissionDisp == 1) {
////                  MMCanUsmPara.AVNTransmissionDisp = TRANSMISSION_DISP_OFF;
////              } else {
////                  MMCanUsmPara.AVNTransmissionDisp = TRANSMISSION_DISP_ON;
////              }
////          }
//    
//     /*OTHER C FUEL ECONOMY RESET*/
//    if (p->CF_AVN_CluAutoInitFuelEconomy != 7) {
//            MMCanDataStruct.CF_AVN_CluAutoInitFuelEconomy = p->CF_AVN_CluAutoInitFuelEconomy;
//            if (MMCanDataStruct.CF_AVN_CluAutoInitFuelEconomy != MMCanUsmPara.AVNAutoResetFuelEconomy) {
//                SaveMiscValid = 1;
//            }
//            if (MMCanDataStruct.CF_AVN_CluAutoInitFuelEconomy == 0) {
//                MMCanUsmPara.AVNAutoResetFuelEconomy = AFC_AUTO_RESET_ADD_FUEL;
//            } else if (MMCanDataStruct.CF_AVN_CluAutoInitFuelEconomy == 1) {
//                MMCanUsmPara.AVNAutoResetFuelEconomy = AFC_AUTO_RESET_OFF;
//            } else if (MMCanDataStruct.CF_AVN_CluAutoInitFuelEconomy == 2) {
//                MMCanUsmPara.AVNAutoResetFuelEconomy = AFC_AUTO_RESET_IGN_OFF_4HOUR;
//            } else if (MMCanDataStruct.CF_AVN_CluAutoInitFuelEconomy == 3) {
//                MMCanUsmPara.AVNAutoResetFuelEconomy = AFC_AUTO_RESET_ADD_FUEL;
//            }
//        }
//      /*OTHER C FUEL ECONOMY UNIT*/
//      MMCanDataStruct.CF_AVN_CluFuelEconUnit_km = p->CF_AVN_CluFuelEconUnit_km;
//          if (MMCanDataStruct.CF_AVN_CluFuelEconUnit_km == 0) {
//              if (MMCanUsmPara.AVNFuelEconomyUnit_km != FUEL_ECONOMY_UNIT_KM_L100KM) {
//                  SaveMiscValid = 1;
//              }
//              MMCanUsmPara.AVNFuelEconomyUnit_km = FUEL_ECONOMY_UNIT_KM_L100KM;
//          } else if (MMCanDataStruct.CF_AVN_CluFuelEconUnit_km == FUEL_ECONOMY_UNIT_KM_KML) {
//              if (MMCanUsmPara.AVNFuelEconomyUnit_km != FUEL_ECONOMY_UNIT_KM_KML) {
//                  SaveMiscValid = 1;
//              }
//              MMCanUsmPara.AVNFuelEconomyUnit_km = FUEL_ECONOMY_UNIT_KM_KML;
//          } else if (MMCanDataStruct.CF_AVN_CluFuelEconUnit_km == FUEL_ECONOMY_UNIT_KM_L100KM) {
//              if (MMCanUsmPara.AVNFuelEconomyUnit_km != FUEL_ECONOMY_UNIT_KM_L100KM) {
//                  SaveMiscValid = 1;
//              }
//              MMCanUsmPara.AVNFuelEconomyUnit_km = FUEL_ECONOMY_UNIT_KM_L100KM;
//          }
//
//          MMCanDataStruct.CF_AVN_CluFuelEconUnit_mi = p->CF_AVN_CluFuelEconUnit_mi;
//      
//      /*Reset*/
//      if (p->CF_AVN_CluUSMReset != 3) {
//        MMCanDataStruct.CF_AVN_CluUSMReset = p->CF_AVN_CluUSMReset;
//        if (MMCanDataStruct.CF_AVN_CluUSMReset == 1) {
//            MMCanUsmPara.ParaInited = 1;
//            Msg0x479Time.msgEvent = SEND_TYPE_CluUSMReset;
//            MMCanDataStruct.HU_LanguageInfo = LANGUAGE_CHINA;   //default:chinese
//            MMCanUsmPara.AVNLanguage = LANGUAGE_CHINA;   //default:chinese
//            MMCanUsmPara.AVNWelcomeSoundSt = WELCOME_SOUND_ON;          //default:on
//            MMCanUsmPara.AVNRoadInfoGuideSt = ROAD_INFO_GUIDE_ON;         //default:on
//            MMCanUsmPara.AVNWiperLightSt = WIPER_LIGHT_ON;            //default:on
//            MMCanUsmPara.AVNTransmissionDisp = TRANSMISSION_DISP_ON;        //default:on
//            MMCanUsmPara.AVNAutoResetFuelEconomy = AFC_AUTO_RESET_ADD_FUEL;    //default:refule
//            MMCanUsmPara.AVNAdasVolume = ADAS_VOLUME_2;              //default:2
//            SaveMiscValid = 1;
//        }
//    }
//
//     if (p->CF_AVN_UnitReset != 3) {
//        MMCanDataStruct.CF_AVN_UnitReset = p->CF_AVN_UnitReset;
//        if (MMCanDataStruct.CF_AVN_UnitReset == 1) {
//            MMCanUsmPara.AVNFuelEconomyUnit_km = FUEL_ECONOMY_UNIT_KM_L100KM;      //L/100km
//            SaveMiscValid = 1;
//        }
//    }
//
//    /*ȼ*/
//    MMCanDataStruct.CF_AVN_CluRheostatLvl = p->CF_AVN_CluRheostatLvl;
//    if ((p->CF_AVN_CluRheostatLvl >= 1) && (p->CF_AVN_CluRheostatLvl <= 0x15)) {
//        if (MMCanUsmPara.RheostatLv != MMCanDataStruct.CF_AVN_CluRheostatLvl) {
//            SaveMiscValid = 1;
//        }
//        MMCanUsmPara.RheostatLv = MMCanDataStruct.CF_AVN_CluRheostatLvl;
//        if (MMCanUsmPara.RheostatLv > 20) {
//            MMCanUsmPara.RheostatLv = 20;
//        }
//    }
//    
//    MMCanDataStruct.CF_AVN_CluVoiceVolume = p -> CF_AVN_CluVoiceVolume;
//    MMCanDataStruct.CF_AVN_CluServiceReminderSet = p -> CF_AVN_CluServiceReminderSet;
//    MMCanDataStruct.CF_AVN_CluUserSettingPeriod = p -> CF_AVN_CluUserSettingPeriod;
//    MMCanDataStruct.CF_AVN_CluSubspeedOdometerDisp = p -> CF_AVN_CluSubspeedOdometerDisp;
//    MMCanDataStruct.CF_AVN_CluFuelEconUnit_mi = p -> CF_AVN_CluFuelEconUnit_mi;
//    MMCanDataStruct.CF_AVN_CluUserSettingDistance = p -> CF_AVN_CluUserSettingDistance;
//    MMCanDataStruct.CF_AVN_UnitReset = p -> CF_AVN_UnitReset;
//    MMCanDataStruct.CF_AVN_CluServiceReminderReset = p -> CF_AVN_CluServiceReminderReset;	
}
void CanFrameTimeoutFunc_0x4AB(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x4AD(uint8_t *data)
{
    HU_USM_E_06_ *p = (HU_USM_E_06_*)data;
//    Msg0x479Time.msgEvent = SEND_TYPE_MM_0x4AD;
    
    if(p -> CF_AVN_DAWModeNValueSet_NEW != 7){
        MMCanDataStruct.CF_AVN_DAWModeNValueSet_NEW = p -> CF_AVN_DAWModeNValueSet_NEW;       
    }
      
    if(p -> CF_AVN_HBANValueSet){
        MMCanDataStruct.CF_AVN_HBANValueSet = p -> CF_AVN_HBANValueSet;
    }  
}
void CanFrameTimeoutFunc_0x4AD(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6D3(uint8_t *data)
{
    TP_HU_BAIDUM_CLU_ *p = (TP_HU_BAIDUM_CLU_*)data;
    MMCanDataStruct.Byte0_TCP_4EC = p -> Byte0_TCP_4EC;
    MMCanDataStruct.Byte1_Data_4EC = p -> Byte1_Data_4EC;
    MMCanDataStruct.Byte2_Data_4EC = p -> Byte2_Data_4EC;
    MMCanDataStruct.Byte3_Data_4EC = p -> Byte3_Data_4EC;
    MMCanDataStruct.Byte4_Data_4EC = p -> Byte4_Data_4EC;
	MMCanDataStruct.Byte5_Data_4EC = p -> Byte5_Data_4EC;
	MMCanDataStruct.Byte6_Data_4EC = p -> Byte6_Data_4EC;
	MMCanDataStruct.Byte7_Data_4EC = p -> Byte7_Data_4EC;	
}
void CanFrameTimeoutFunc_0x6D3(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6D4(uint8_t *data)
{
    TP_HU_BTSONG_CLU_ *p = (TP_HU_BTSONG_CLU_*)data;
    MMCanDataStruct.Byte0_TCP_4F6 = p -> Byte0_TCP_4F6;
    MMCanDataStruct.Byte1_Data_4F6 = p -> Byte1_Data_4F6;
    MMCanDataStruct.Byte2_Data_4F6 = p -> Byte2_Data_4F6;
    MMCanDataStruct.Byte3_Data_4F6 = p -> Byte3_Data_4F6;
    MMCanDataStruct.Byte4_Data_4F6 = p -> Byte4_Data_4F6;
	MMCanDataStruct.Byte5_Data_4F6 = p -> Byte5_Data_4F6;
	MMCanDataStruct.Byte6_Data_4F6 = p -> Byte6_Data_4F6;
	MMCanDataStruct.Byte7_Data_4F6 = p -> Byte7_Data_4F6;	
}
void CanFrameTimeoutFunc_0x6D4(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6D5(uint8_t *data)
{
    TP_HU_CARLIFE_CLU_ *p = (TP_HU_CARLIFE_CLU_*)data;
    MMCanDataStruct.Byte0_TCP_4F0 = p -> Byte0_TCP_4F0;
    MMCanDataStruct.Byte1_Data_4F0 = p -> Byte1_Data_4F0;
    MMCanDataStruct.Byte2_Data_4F0 = p -> Byte2_Data_4F0;
    MMCanDataStruct.Byte3_Data_4F0 = p -> Byte3_Data_4F0;
    MMCanDataStruct.Byte4_Data_4F0 = p -> Byte4_Data_4F0;
	MMCanDataStruct.Byte5_Data_4F0 = p -> Byte5_Data_4F0;
	MMCanDataStruct.Byte6_Data_4F0 = p -> Byte6_Data_4F0;
	MMCanDataStruct.Byte7_Data_4F0 = p -> Byte7_Data_4F0;	
}
void CanFrameTimeoutFunc_0x6D5(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6D6(uint8_t *data)
{
    TP_HU_CARPLAY_CLU_ *p = (TP_HU_CARPLAY_CLU_*)data;
    MMCanDataStruct.Byte0_TCP_4F2 = p -> Byte0_TCP_4F2;
    MMCanDataStruct.Byte1_Data_4F2 = p -> Byte1_Data_4F2;
    MMCanDataStruct.Byte2_Data_4F2 = p -> Byte2_Data_4F2;
    MMCanDataStruct.Byte3_Data_4F2 = p -> Byte3_Data_4F2;
    MMCanDataStruct.Byte4_Data_4F2 = p -> Byte4_Data_4F2;
	MMCanDataStruct.Byte5_Data_4F2 = p -> Byte5_Data_4F2;
	MMCanDataStruct.Byte6_Data_4F2 = p -> Byte6_Data_4F2;
	MMCanDataStruct.Byte7_Data_4F2 = p -> Byte7_Data_4F2;	
}
void CanFrameTimeoutFunc_0x6D6(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6DC(uint8_t *data)
{
    TP_HU_FM_CLU_ *p = (TP_HU_FM_CLU_*)data;
    MMCanDataStruct.Byte0_TCP_4E8 = p -> Byte0_TCP_4E8;
    MMCanDataStruct.Byte1_Data_4E8 = p -> Byte1_Data_4E8;
    MMCanDataStruct.Byte2_Data_4E8 = p -> Byte2_Data_4E8;
    MMCanDataStruct.Byte3_Data_4E8 = p -> Byte3_Data_4E8;
    MMCanDataStruct.Byte4_Data_4E8 = p -> Byte4_Data_4E8;
	MMCanDataStruct.Byte5_Data_4E8 = p -> Byte5_Data_4E8;
	MMCanDataStruct.Byte6_Data_4E8 = p -> Byte6_Data_4E8;
	MMCanDataStruct.Byte7_Data_4E8 = p -> Byte7_Data_4E8;	
}
void CanFrameTimeoutFunc_0x6DC(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6DD(uint8_t *data)
{
    TP_HU_HFNAME_CLU_ *p = (TP_HU_HFNAME_CLU_*)data;
    MMCanDataStruct.Byte0_TCP_4F8 = p -> Byte0_TCP_4F8;
    MMCanDataStruct.Byte1_Data_4F8 = p -> Byte1_Data_4F8;
    MMCanDataStruct.Byte2_Data_4F8 = p -> Byte2_Data_4F8;
    MMCanDataStruct.Byte3_Data_4F8 = p -> Byte3_Data_4F8;
    MMCanDataStruct.Byte4_Data_4F8 = p -> Byte4_Data_4F8;
	MMCanDataStruct.Byte5_Data_4F8 = p -> Byte5_Data_4F8;
	MMCanDataStruct.Byte6_Data_4F8 = p -> Byte6_Data_4F8;
	MMCanDataStruct.Byte7_Data_4F8 = p -> Byte7_Data_4F8;	
}
void CanFrameTimeoutFunc_0x6DD(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6DE(uint8_t *data)
{
    TP_HU_HFNO_CLU_ *p = (TP_HU_HFNO_CLU_*)data;
    MMCanDataStruct.Byte0_TCP_485 = p -> Byte0_TCP_485;
    MMCanDataStruct.Byte1_Data_485 = p -> Byte1_Data_485;
    MMCanDataStruct.Byte2_Data_485 = p -> Byte2_Data_485;
    MMCanDataStruct.Byte3_Data_485 = p -> Byte3_Data_485;
    MMCanDataStruct.Byte4_Data_485 = p -> Byte4_Data_485;
	MMCanDataStruct.Byte5_Data_485 = p -> Byte5_Data_485;
	MMCanDataStruct.Byte6_Data_485 = p -> Byte6_Data_485;
	MMCanDataStruct.Byte7_Data_485 = p -> Byte7_Data_485;	
}
void CanFrameTimeoutFunc_0x6DE(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6E0(uint8_t *data)
{
    TP_HU_IBOX_CLU_ *p = (TP_HU_IBOX_CLU_*)data;
    MMCanDataStruct.Byte0_TCP_4EE = p -> Byte0_TCP_4EE;
    MMCanDataStruct.Byte1_Data_4EE = p -> Byte1_Data_4EE;
    MMCanDataStruct.Byte2_Data_4EE = p -> Byte2_Data_4EE;
    MMCanDataStruct.Byte3_Data_4EE = p -> Byte3_Data_4EE;
    MMCanDataStruct.Byte4_Data_4EE = p -> Byte4_Data_4EE;
	MMCanDataStruct.Byte5_Data_4EE = p -> Byte5_Data_4EE;
	MMCanDataStruct.Byte6_Data_4EE = p -> Byte6_Data_4EE;
	MMCanDataStruct.Byte7_Data_4EE = p -> Byte7_Data_4EE;	
}
void CanFrameTimeoutFunc_0x6E0(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6E1(uint8_t *data)
{
    TP_HU_Ipod_CLU_ *p = (TP_HU_Ipod_CLU_*)data;
    MMCanDataStruct.Byte0_TCP_48F = p -> Byte0_TCP_48F;
    MMCanDataStruct.Byte1_Data_48F = p -> Byte1_Data_48F;
    MMCanDataStruct.Byte2_Data_48F = p -> Byte2_Data_48F;
    MMCanDataStruct.Byte3_Data_48F = p -> Byte3_Data_48F;
    MMCanDataStruct.Byte4_Data_48F = p -> Byte4_Data_48F;
	MMCanDataStruct.Byte5_Data_48F = p -> Byte5_Data_48F;
	MMCanDataStruct.Byte6_Data_48F = p -> Byte6_Data_48F;
	MMCanDataStruct.Byte7_Data_48F = p -> Byte7_Data_48F;	
}
void CanFrameTimeoutFunc_0x6E1(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6E4(uint8_t *data)
{
    TP_HU_KAOLA_CLU_ *p = (TP_HU_KAOLA_CLU_*)data;
    MMCanDataStruct.Byte0_TCP_4E6 = p -> Byte0_TCP_4E6;
    MMCanDataStruct.Byte1_Data_4E6 = p -> Byte1_Data_4E6;
    MMCanDataStruct.Byte2_Data_4E6 = p -> Byte2_Data_4E6;
    MMCanDataStruct.Byte3_Data_4E6 = p -> Byte3_Data_4E6;
    MMCanDataStruct.Byte4_Data_4E6 = p -> Byte4_Data_4E6;
	MMCanDataStruct.Byte5_Data_4E6 = p -> Byte5_Data_4E6;
	MMCanDataStruct.Byte6_Data_4E6 = p -> Byte6_Data_4E6;
	MMCanDataStruct.Byte7_Data_4E6 = p -> Byte7_Data_4E6;	
}
void CanFrameTimeoutFunc_0x6E4(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6E7(uint8_t *data)
{
    TP_HU_NAVI_CLU_ *p = (TP_HU_NAVI_CLU_*)data;
    MMCanDataStruct.Byte0_TCP_49B = p -> Byte0_TCP_49B;
    MMCanDataStruct.Byte1_Data_49B = p -> Byte1_Data_49B;
    MMCanDataStruct.Byte2_Data_49B = p -> Byte2_Data_49B;
    MMCanDataStruct.Byte3_Data_49B = p -> Byte3_Data_49B;
    MMCanDataStruct.Byte4_Data_49B = p -> Byte4_Data_49B;
	MMCanDataStruct.Byte5_Data_49B = p -> Byte5_Data_49B;
	MMCanDataStruct.Byte6_Data_49B = p -> Byte6_Data_49B;
	MMCanDataStruct.Byte7_Data_49B = p -> Byte7_Data_49B;	
}
void CanFrameTimeoutFunc_0x6E7(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6E8(uint8_t *data)
{
    TP_HU_QQMUSIC_CLU_ *p = (TP_HU_QQMUSIC_CLU_*)data;
    MMCanDataStruct.Byte0_TCP_4E4 = p -> Byte0_TCP_4E4;
    MMCanDataStruct.Byte1_Data_4E4 = p -> Byte1_Data_4E4;
    MMCanDataStruct.Byte2_Data_4E4 = p -> Byte2_Data_4E4;
    MMCanDataStruct.Byte3_Data_4E4 = p -> Byte3_Data_4E4;
    MMCanDataStruct.Byte4_Data_4E4 = p -> Byte4_Data_4E4;
	MMCanDataStruct.Byte5_Data_4E4 = p -> Byte5_Data_4E4;
	MMCanDataStruct.Byte6_Data_4E4 = p -> Byte6_Data_4E4;
	MMCanDataStruct.Byte7_Data_4E4 = p -> Byte7_Data_4E4;	
}
void CanFrameTimeoutFunc_0x6E8(uint8_t Lv)
{
	
}

void CanFrameAnlysisFunc_0x6EA(uint8_t *data)
{
    TP_HU_USB_CLU_ *p = (TP_HU_USB_CLU_*)data;
    MMCanDataStruct.Byte0_TCP_490 = p -> Byte0_TCP_490;
    MMCanDataStruct.Byte1_Data_490 = p -> Byte1_Data_490;
    MMCanDataStruct.Byte2_Data_490 = p -> Byte2_Data_490;
    MMCanDataStruct.Byte3_Data_490 = p -> Byte3_Data_490;
    MMCanDataStruct.Byte4_Data_490 = p -> Byte4_Data_490;
    MMCanDataStruct.Byte5_Data_490 = p -> Byte5_Data_490;
    MMCanDataStruct.Byte6_Data_490 = p -> Byte6_Data_490;
    MMCanDataStruct.Byte7_Data_490 = p -> Byte7_Data_490;	
}
void CanFrameTimeoutFunc_0x6EA(uint8_t Lv)
{
	
}
#endif
