#include "common_include.h"

#if (CAN_3RD)
uint8_t UDSSend;
uint8_t UDSSend_check;

static uint16_t CanList[120][3] = {0};
void CanCRCInint(void)
{
	CanList[0][0] = 0x030u; CanList[0][1] = PROFILE5; CanList[0][2] = 0u;
	CanList[1][0] = 0x040u; CanList[1][1] = PROFILE5; CanList[1][2] = 0u;
	CanList[2][0] = 0x045u; CanList[2][1] = PROFILE5; CanList[2][2] = 0u;
	CanList[3][0] = 0x060u; CanList[3][1] = PROFILE5; CanList[3][2] = 0u;
	CanList[4][0] = 0x065u; CanList[4][1] = PROFILE5; CanList[4][2] = 0u;
	CanList[5][0] = 0x06Au; CanList[5][1] = PROFILE5; CanList[5][2] = 0u;
	CanList[6][0] = 0x06Fu; CanList[6][1] = PROFILE5; CanList[6][2] = 0u;
	CanList[7][0] = 0x070u; CanList[7][1] = PROFILE5; CanList[7][2] = 0u;
	CanList[8][0] = 0x0A0u; CanList[8][1] = PROFILE5; CanList[8][2] = 0u;
	CanList[9][0] = 0x0B5u; CanList[9][1] = PROFILE5; CanList[9][2] = 0u;
	CanList[10][0] = 0x0BAu; CanList[10][1] = PROFILE5; CanList[10][2] = 0u;
	CanList[11][0] = 0x0E0u; CanList[11][1] = PROFILE5; CanList[11][2] = 0u;
	CanList[12][0] = 0x0EAu; CanList[12][1] = PROFILE5; CanList[12][2] = 0u;
	CanList[13][0] = 0x0FAu; CanList[13][1] = PROFILE5; CanList[13][2] = 0u;
	CanList[14][0] = 0x100u; CanList[14][1] = PROFILE5; CanList[14][2] = 0u;
	CanList[15][0] = 0x105u; CanList[15][1] = PROFILE5; CanList[15][2] = 0u;
	CanList[16][0] = 0x10Au; CanList[16][1] = PROFILE5; CanList[16][2] = 0u;
	CanList[17][0] = 0x11Au; CanList[17][1] = PROFILE5; CanList[17][2] = 0u;
	CanList[18][0] = 0x120u; CanList[18][1] = PROFILE5; CanList[18][2] = 0u;
	CanList[19][0] = 0x125u; CanList[19][1] = PROFILE5; CanList[19][2] = 0u;
	CanList[20][0] = 0x12Au; CanList[20][1] = PROFILE5; CanList[20][2] = 0u;
	CanList[21][0] = 0x130u; CanList[21][1] = PROFILE5; CanList[21][2] = 0u;
	CanList[22][0] = 0x135u; CanList[22][1] = PROFILE5; CanList[22][2] = 0u;
	CanList[23][0] = 0x145u; CanList[23][1] = PROFILE5; CanList[23][2] = 0u;
	CanList[24][0] = 0x15Au; CanList[24][1] = PROFILE5; CanList[24][2] = 0u;
	CanList[25][0] = 0x160u; CanList[25][1] = PROFILE5; CanList[25][2] = 0u;
	CanList[26][0] = 0x165u; CanList[26][1] = PROFILE5; CanList[26][2] = 0u;
	CanList[27][0] = 0x16Au; CanList[27][1] = PROFILE5; CanList[27][2] = 0u;
	CanList[28][0] = 0x170u; CanList[28][1] = PROFILE5; CanList[28][2] = 0u;
	CanList[29][0] = 0x1A0u; CanList[29][1] = PROFILE5; CanList[29][2] = 0u;
	CanList[30][0] = 0x1A5u; CanList[30][1] = PROFILE5; CanList[30][2] = 0u;
	CanList[31][0] = 0x1BAu; CanList[31][1] = PROFILE5; CanList[31][2] = 0u;
	CanList[32][0] = 0x1C5u; CanList[32][1] = PROFILE5; CanList[32][2] = 0u;
	CanList[33][0] = 0x1E0u; CanList[33][1] = PROFILE5; CanList[33][2] = 0u;
	CanList[34][0] = 0x1E5u; CanList[34][1] = PROFILE5; CanList[34][2] = 0u;
	CanList[35][0] = 0x1EAu; CanList[35][1] = PROFILE5; CanList[35][2] = 0u;
	CanList[36][0] = 0x1F0u; CanList[36][1] = PROFILE5; CanList[36][2] = 0u;
	CanList[37][0] = 0x1FAu; CanList[37][1] = PROFILE5; CanList[37][2] = 0u;
	CanList[38][0] = 0x200u; CanList[38][1] = PROFILE5; CanList[38][2] = 0u;
	CanList[39][0] = 0x205u; CanList[39][1] = PROFILE5; CanList[39][2] = 0u;
	CanList[40][0] = 0x20Au; CanList[40][1] = PROFILE5; CanList[40][2] = 0u;
	CanList[41][0] = 0x220u; CanList[41][1] = PROFILE5; CanList[41][2] = 0u;
	CanList[42][0] = 0x22Au; CanList[42][1] = PROFILE5; CanList[42][2] = 0u;
	CanList[43][0] = 0x230u; CanList[43][1] = PROFILE5; CanList[43][2] = 0u;
	CanList[44][0] = 0x235u; CanList[44][1] = PROFILE5; CanList[44][2] = 0u;
	CanList[45][0] = 0x24Au; CanList[45][1] = PROFILE5; CanList[45][2] = 0u;
	CanList[46][0] = 0x250u; CanList[46][1] = PROFILE5; CanList[46][2] = 0u;
	CanList[47][0] = 0x255u; CanList[47][1] = PROFILE5; CanList[47][2] = 0u;
	CanList[48][0] = 0x260u; CanList[48][1] = PROFILE5; CanList[48][2] = 0u;
	CanList[49][0] = 0x265u; CanList[49][1] = PROFILE5; CanList[49][2] = 0u;
	CanList[50][0] = 0x290u; CanList[50][1] = PROFILE5; CanList[50][2] = 0u;
	CanList[51][0] = 0x29Au; CanList[51][1] = PROFILE5; CanList[51][2] = 0u;
	CanList[52][0] = 0x2D0u; CanList[52][1] = PROFILE5; CanList[52][2] = 0u;
	CanList[53][0] = 0x2E5u; CanList[53][1] = PROFILE5; CanList[53][2] = 0u;
	CanList[54][0] = 0x2F5u; CanList[54][1] = PROFILENONE; CanList[54][2] = 0u;
	CanList[55][0] = 0x2FAu; CanList[55][1] = PROFILE5; CanList[55][2] = 0u;
	CanList[56][0] = 0x30Au; CanList[56][1] = PROFILENONE; CanList[56][2] = 0u;
	CanList[57][0] = 0x310u; CanList[57][1] = PROFILE5; CanList[57][2] = 0u;
	CanList[58][0] = 0x325u; CanList[58][1] = PROFILE5; CanList[58][2] = 0u;
	CanList[59][0] = 0x360u; CanList[59][1] = PROFILENONE; CanList[59][2] = 0u;
	CanList[60][0] = 0x382u; CanList[60][1] = PROFILE5; CanList[60][2] = 0u;
	CanList[61][0] = 0x385u; CanList[61][1] = PROFILENONE; CanList[61][2] = 0u;
	CanList[62][0] = 0x386u; CanList[62][1] = PROFILENONE; CanList[62][2] = 0u;
	CanList[63][0] = 0x391u; CanList[63][1] = PROFILE11; CanList[63][2] = 0u;
	CanList[64][0] = 0x394u; CanList[64][1] = PROFILE11; CanList[64][2] = 0u;
	CanList[65][0] = 0x39Du; CanList[65][1] = PROFILE5; CanList[65][2] = 0u;
	CanList[66][0] = 0x3A0u; CanList[66][1] = PROFILE5; CanList[66][2] = 0u;
	CanList[67][0] = 0x3A5u; CanList[67][1] = PROFILE5; CanList[67][2] = 0u;
	CanList[68][0] = 0x3A6u; CanList[68][1] = PROFILE11; CanList[68][2] = 0u;
	CanList[69][0] = 0x3B3u; CanList[69][1] = PROFILENONE; CanList[69][2] = 0u;
	CanList[70][0] = 0x3B5u; CanList[70][1] = PROFILENONE; CanList[70][2] = 0u;
	CanList[71][0] = 0x3BFu; CanList[71][1] = PROFILENONE; CanList[71][2] = 0u;
	CanList[72][0] = 0x3C0u; CanList[72][1] = PROFILENONE; CanList[72][2] = 0u;
	CanList[73][0] = 0x3C1u; CanList[73][1] = PROFILE11; CanList[73][2] = 0u;
	CanList[74][0] = 0x3C2u; CanList[74][1] = PROFILE11; CanList[74][2] = 0u;
	CanList[75][0] = 0x3C5u; CanList[75][1] = PROFILENONE; CanList[75][2] = 0u;
	CanList[76][0] = 0x3E1u; CanList[76][1] = PROFILE11; CanList[76][2] = 0u;
	CanList[77][0] = 0x3E2u; CanList[77][1] = PROFILE11; CanList[77][2] = 0u;
	CanList[78][0] = 0x3E5u; CanList[78][1] = PROFILE11; CanList[78][2] = 0u;
	CanList[79][0] = 0x3E6u; CanList[79][1] = PROFILE11; CanList[79][2] = 0u;
	CanList[80][0] = 0x3ECu; CanList[80][1] = PROFILENONE; CanList[80][2] = 0u;
	CanList[81][0] = 0x3FAu; CanList[81][1] = PROFILE5; CanList[81][2] = 0u;
	CanList[82][0] = 0x401u; CanList[82][1] = PROFILE11; CanList[82][2] = 0u;
	CanList[83][0] = 0x405u; CanList[83][1] = PROFILENONE; CanList[83][2] = 0u;
	CanList[84][0] = 0x408u; CanList[84][1] = PROFILENONE; CanList[84][2] = 0u;
	CanList[85][0] = 0x40Cu; CanList[85][1] = PROFILENONE; CanList[85][2] = 0u;
	CanList[86][0] = 0x410u; CanList[86][1] = PROFILE11; CanList[86][2] = 0u;
	CanList[87][0] = 0x411u; CanList[87][1] = PROFILE11; CanList[87][2] = 0u;
	CanList[88][0] = 0x412u; CanList[88][1] = PROFILE11; CanList[88][2] = 0u;
	CanList[89][0] = 0x413u; CanList[89][1] = PROFILE11; CanList[89][2] = 0u;
	CanList[90][0] = 0x414u; CanList[90][1] = PROFILE11; CanList[90][2] = 0u;
	CanList[91][0] = 0x416u; CanList[91][1] = PROFILE11; CanList[91][2] = 0u;
	CanList[92][0] = 0x417u; CanList[92][1] = PROFILE11; CanList[92][2] = 0u;
	CanList[93][0] = 0x418u; CanList[93][1] = PROFILE11; CanList[93][2] = 0u;
	CanList[94][0] = 0x41Au; CanList[94][1] = PROFILE11; CanList[94][2] = 0u;
	CanList[95][0] = 0x41Cu; CanList[95][1] = PROFILE11; CanList[95][2] = 0u;
	CanList[96][0] = 0x421u; CanList[96][1] = PROFILE11; CanList[96][2] = 0u;
	CanList[97][0] = 0x422u; CanList[97][1] = PROFILE11; CanList[97][2] = 0u;
	CanList[98][0] = 0x425u; CanList[98][1] = PROFILE11; CanList[98][2] = 0u;
	CanList[99][0] = 0x426u; CanList[99][1] = PROFILE11; CanList[99][2] = 0u;
	CanList[100][0] = 0x432u; CanList[100][1] = PROFILE11; CanList[100][2] = 0u;
	CanList[101][0] = 0x434u; CanList[101][1] = PROFILENONE; CanList[101][2] = 0u;
	CanList[102][0] = 0x437u; CanList[102][1] = PROFILENONE; CanList[102][2] = 0u;
	CanList[103][0] = 0x43Du; CanList[103][1] = PROFILENONE; CanList[103][2] = 0u;
	CanList[104][0] = 0x442u; CanList[104][1] = PROFILE11; CanList[104][2] = 0u;
	CanList[105][0] = 0x444u; CanList[105][1] = PROFILE11; CanList[105][2] = 0u;
	CanList[106][0] = 0x445u; CanList[106][1] = PROFILE11; CanList[106][2] = 0u;
	CanList[107][0] = 0x448u; CanList[107][1] = PROFILE11; CanList[107][2] = 0u;
	CanList[108][0] = 0x44Bu; CanList[108][1] = PROFILENONE; CanList[108][2] = 0u;
	CanList[109][0] = 0x455u; CanList[109][1] = PROFILENONE; CanList[109][2] = 0u;
	CanList[110][0] = 0x476u; CanList[110][1] = PROFILENONE; CanList[110][2] = 0u;
	CanList[111][0] = 0x477u; CanList[111][1] = PROFILENONE; CanList[111][2] = 0u;
	CanList[112][0] = 0x485u; CanList[112][1] = PROFILENONE; CanList[112][2] = 0u;
	CanList[113][0] = 0x488u; CanList[113][1] = PROFILE11; CanList[113][2] = 0u;
	CanList[114][0] = 0x489u; CanList[114][1] = PROFILE11; CanList[114][2] = 0u;
	CanList[115][0] = 0x48Fu; CanList[115][1] = PROFILE11; CanList[115][2] = 0u;
	CanList[116][0] = 0x4CBu; CanList[116][1] = PROFILENONE; CanList[116][2] = 0u;
	CanList[117][0] = 0x4CFu; CanList[117][1] = PROFILENONE; CanList[117][2] = 0u;
	CanList[118][0] = 0x4E4u; CanList[118][1] = PROFILE11; CanList[118][2] = 0u;
	CanList[119][0] = 0x4E5u; CanList[119][1] = PROFILE11; CanList[119][2] = 0u;
}


uint16_t Calculate_CRC16(uint8_t puchMsg[], uint32_t usDataLen)
{
    uint16_t wCRCin = 0xFFFFu;
    uint16_t wCPoly = 0x1021u;
    uint16_t wChar = 0u;
    uint8_t p = 0u;
    uint16_t tmp = 0u;
    
    while (usDataLen) 	
    {
        wChar = puchMsg[p];
        p++;
        wCRCin ^= (uint16_t)(wChar << 8u);
        for(uint8_t i = 0u;i < 8u;i++)
        {
            tmp = wCRCin & 0x8000u;
            if(tmp != 0u) {
                wCRCin = (uint16_t)(wCRCin << 1u) ^ (uint16_t)wCPoly;
            } else {
                wCRCin = (uint16_t)wCRCin << 1u;
            }
        }
        usDataLen--;
    }
    return (wCRCin) ;   
}

uint8_t Calculate_CRC8(uint8_t puchMsg[], uint32_t usDataLen)
{
    uint8_t wCRCin = 0u;
    uint8_t wCPoly = 0x1Du;
    uint8_t wChar = 0u;
    uint8_t p = 0u;
    uint8_t tmp = 0u;
    
    while (usDataLen) 	
    {
        wChar = puchMsg[p];
        p++;
        wCRCin ^= wChar;
        for(uint8_t i = 0u;i < 8u;i++)
        {
            tmp = wCRCin & 0x80u;
            if(tmp != 0u) {
                wCRCin = (wCRCin << 1u) ^ wCPoly;
            } else {
                wCRCin = wCRCin << 1u;
            }
        }
        usDataLen--;
    }
    wCRCin ^= 0xFFu;
    return (wCRCin) ;   
}

static uint16_t GetSendCrcVal(uint16_t ID, uint8_t DLC, uint8_t data[])
{
    uint16_t ret = 0u;
    uint8_t buf[64];
    memset(buf, 0, sizeof(buf));
    
    memcpy(buf, &data[2], DLC - 2);
    buf[DLC - 2u] = (uint8_t)(ID + 0xF800u);
    buf[DLC - 1u] = (uint8_t)((ID + 0xF800u) >> 8u);
    
    ret = Calculate_CRC16(buf, DLC);
    
    return ret;
}

void CalCrcVal(uint32_t ID, uint8_t Length, uint8_t data[]) 
{
    uint8_t i = 0u;
    uint8_t ret = 0u;
    uint8_t ret1 = 0u;
    uint8_t ret2 = 0u;
    uint8_t CrcBuf[64];
    uint16_t RevCrcVal = 0u;
    uint16_t CrcVal = 0u;
    
    
    memset(CrcBuf, 0 , sizeof(CrcBuf));
    
    for (i = 0u; i < (sizeof(CanList) / sizeof(uint16_t))/ (sizeof(CanList[0]) / sizeof(uint16_t)); i++) {
        if (ID == CanList[i][0]) {
            break;
        }
    }
    
    if (i >= ((sizeof(CanList) / sizeof(uint16_t))/ (sizeof(CanList[0]) / sizeof(uint16_t)))) {
        return;
    } else {
        if (CanList[i][1] == PROFILENONE) {
            return;
        } else {
            if (CanList[i][1] == PROFILE5) {
                RevCrcVal = ((data[1] << 8) | data[0]);
                if (CanList[i][2] == 0xffu) {
                    CanList[i][2] = 0;
                } else {
                    CanList[i][2]++;
                }
                data[2] = CanList[i][2];
                memcpy(CrcBuf,  &data[2], Length - 2);
                CrcBuf[Length -2] = (uint8_t)(ID + 0xF800u);
                CrcBuf[Length -1] = (uint8_t)((ID + 0xF800u) >> 8u);
                CrcVal = Calculate_CRC16(CrcBuf, Length);
                data[0] = CrcVal & 0xff;
                data[1] = (CrcVal >> 8) & 0xff;
                
            } else if (CanList[i][1] == PROFILE11) {
                if (CanList[i][2] == 0x0eu) {
                    CanList[i][2] = 0;
                } else {
                    CanList[i][2]++;
                }
                data[1] |= ((CanList[i][2] << 4) & 0xf0);
                CrcBuf[0] = (uint8_t)(ID + 0xF800u);
                CrcBuf[1] = (uint8_t)((ID + 0xF800u) >> 8u);
                memcpy(&CrcBuf[2],  &data[1], Length - 1);
                CrcVal = Calculate_CRC8(CrcBuf, Length + 1);
                data[0] = CrcVal;
            } else {
                return;
            }
        }
    }
}


void Can_Clear(uint8_t *data, uint8_t DataLen)
{
    uint8_t i;
    for(i = 0;i < DataLen;i++)
    {
        data[i] = 0;
    }
}

void SetCan1Mode(uint8_t n)
{
    if (n) {
        Port_SetPortPinLevel(1, 2, PortGpioLow);   //stb
    } else {
        Port_SetPortPinLevel(1, 2, PortGpioHigh); //stb
    }
}

void SetCan0Mode(uint8_t n)
{
    if (n) {
        Port_SetPortPinLevel(0, 29, PortGpioLow);
    } else {
        Port_SetPortPinLevel(0, 29, PortGpioHigh);
    }
}

//void CANInit(void)
//{
//#if (CAN_3RD)
//    InitCanRecvModule();
//    Can1_Init();
//    bsp_CAN0_Init();
//    bsp_CAN1_Init();
//#if (HARD_WARE_VERSION_2_1_7)
////    SetCan0Mode(1);   
////    SetCan1Mode(1);
//    Port_SetPortPinLevel(0, 29, PortGpioLow);
//    Port_SetPortPinLevel(1, 2, PortGpioLow);   //stb
//#endif
//#if (HARD_WARE_VERSION_2_2_0)
////    SetCan0Mode(0);   
////    SetCan1Mode(0);
//    Port_SetPortPinLevel(0, 29, PortGpioHigh);
//    Port_SetPortPinLevel(1, 2, PortGpioHigh); //stb
//#endif
//#endif
//}
void SendCan0Message(void)
{
    if ((Timer10msCnts > SendCanMessage10msTimer) && ((Timer10msCnts - SendCanMessage10msTimer) >= 10)) {        
         //10ms 
        SendCanMessage10msTimer = Timer10msCnts; 
        InitBuf();
//        if (g_SEAT_BELT_Sound_Check == 1) {
//            CanSendCan0Msg(0x3E1,   BCM_03_200ms,  8, 0);
//        } else {
//            CanSendCan0Msg(0x3E1,   BCM_03_200ms,  8, 1);
//        }
        CanSendCan0Msg(0x3E1,   BCM_03_200ms,  8, 1);
        CanSendCan1Msg(0x3BF,   ECALL_CLU_PE_01, 8, 1);
        //CanSendCan0Msg(0x0E0,   HCU_02_10ms, 32, 1);
        CanSendCan0Msg(0x1C5,   EMS_11_10ms, 32, 1);
        CanSendCan0Msg(0x105,   EMS_07_10ms, 32, 1);
        CanSendCan0Msg(0x0B5,   EMS_01_10ms, 32, 1);
        CanSendCan0Msg(0x045,   HTCU_04_10ms, 24, 1);
        //CanSendCan0Msg(0x0E0,   HCU_02_10ms, 32, 1);
        //CanSendCan0Msg(0x15A,   SCU_FF_01_10ms, 8, 1);
        CanSendCan0Msg(0x0FA,   HCU_03_10ms, 32, 1);
        //CanSendCan0Msg(0x130,   SBW_SHFTR_FF_01_10ms, 16, 1);
        CanSendCan0Msg(0x11A,   FR_CMR_01_10ms, 16, 1);
        CanSendCan0Msg(0x065,   IEB_01_10ms, 32, 1);
        //HU_USM_E_04.CF_AVN_CluVoiceVolume = 0x3;

        if(ButtomCurrent.count == 9 || g_Stage == STAGE_LCDCheck) {
            CanSendCan1Msg(0x4AB,   HU_USM_E_04, 8, 0);
        } else {
            CanSendCan1Msg(0x4AB,   HU_USM_E_04, 8, 1);
        }
        
        if(g_uiIceWarningLedCheckFlag == 1) {
            DATC_01_20ms.DATC_OutTempSnsrVal = 0;//Ǳ*0.5 * 88 -40 = 5ȣС4 ߴ 6 ʾ
            CanSendCan0Msg(0x145,   DATC_01_20ms, 32, 1);    
        }
        else {
            //ĵ߲ʾ
        }
        

        CRC001.Byte0Data = 0xFE;
        CanSendCan0Msg(0x001,   CRC001.mdata, 1,0);/*EVP     */
        
        CanSendCan0Msg(0x0A0,   WHL_01_10ms, 24, 1);
        if(g_uiDmsLedCheckFlag == 1) {
            TCU_01_10ms.TCU_SmrtShftSta = 0x1;//SMART ʻģʽʹ
        }
        TCU_01_10ms.TCU_Typ=0x2;
        CanSendCan0Msg(0x040,   TCU_01_10ms, 32, 1);
        
//        CanSendCan0Msg(0x070,   HTCU_05_10ms, 32, 1);//λ
        CanSendCan0Msg(0x070,   HTCU_05_10ms, 32, 0);
        CanSendCan0Msg(0x060,   ESC_01_10ms, 32, 1);
        CanSendCan0Msg(0x06F,   ABS_ESC_01_10ms, 8, 1);
        if (g_uiLPI_OnlyCheckFlag == 0) {
            EMS_02_10ms.ENG_LV_FUP_ENA_THD = 0x1;
        }
        CanSendCan0Msg(0x100,   EMS_02_10ms, 32, 1);    
        
        CanSendCan0Msg(0x12A,   ADAS_CMD_30_10ms, 16, 1);
        CanSendCan0Msg(0x0EA,   MDPS_01_10ms, 24, 1);
        //CanSendCan0Msg(0x030,   EMS_03_10ms, 24, 1);
         
        if(g_uiOtherCheckCurStep == AUTO_STATIC) {
            Send_7DF_ectype_Data.msg.bits.Byte0Data = 0xfd;
            CanSendCan0Msg(0x7DF, Send_7DF_ectype_Data, 1,0);
        }
        else  if((g_Stage == STAGE_TFTCheck && g_TftCheckDeriction == 1) || g_TestModeBackDoorFlag == 1 ){
            Send_7DF_ectype_Data.msg.bits.Byte0Data = 0xfb;
            CanSendCan0Msg(0x7DF, Send_7DF_ectype_Data, 1,0);
            g_TestModeBackDoorFlag = 0;
        } 
        else {
            if (g_uiBackDoorFlag == 1) {
                Send_7DF_Data.msg.bits.Byte0Data = 0x02;
                Send_7DF_Data.msg.bits.Byte1Data = 0x3E;   
                Send_7DF_Data.msg.bits.Byte1Data = 0x80; 
                CanSendCan0Msg(0x7DF, Send_7DF_Data, 3,0);
            }
        }
    }
    else if ((Timer10msCnts > SendCanMessage20msTimer) && ((Timer10msCnts - SendCanMessage20msTimer) >= 20)) {
        //20ms
        SendCanMessage20msTimer = Timer10msCnts;
        InitBuf(); 

        CanSendCan0Msg(0x1A0,   ADAS_CMD_20_20ms, 32, 1);
        CanSendCan0Msg(0x1A5,   AWD_01_20ms, 32, 1);
        CanSendCan0Msg(0x160,   ADAS_CMD_10_20ms, 16, 1);
        //CanSendCan0Msg(0x165,   ADAS_PRK_20_20ms, 24, 1);
    }
    else if ((Timer10msCnts > SendCanMessage50msTimer) && ((Timer10msCnts - SendCanMessage50msTimer) >= 50)) {
        // 50ms
        SendCanMessage50msTimer = Timer10msCnts;
        InitBuf(); 
        CanSendCan0Msg(0x1F0,   EPB_01_50ms, 16, 1);
        CanSendCan0Msg(0x1E0,   ADAS_CMD_31_50ms, 16, 1);
        CanSendCan0Msg(0x1E5,   RR_C_RDR_01_50ms, 16, 1);
        CanSendCan0Msg(0x448,   SWRC_01_200ms, 8, 1);
        CanSendCan0Msg(0x1BA,   RR_C_RDR_02_50ms, 24, 1);
    }
    else if ((Timer10msCnts > SendCanMessage100msTimer) && ((Timer10msCnts - SendCanMessage100msTimer) >= 98)) {
        //100ms
        SendCanMessage100msTimer = Timer10msCnts;
        InitBuf(); 
        CanSendCan0Msg(0x230,   HCU_05_100ms, 32, 1);
        CanSendCan0Msg(0x22A,   HCU_04_100ms, 32, 1);
        CanSendCan0Msg(0x325,   BMS_06_100ms, 32, 1);
        CanSendCan0Msg(0x2FA,   BMS_02_100ms, 32, 1);
        CanSendCan0Msg(0x290,   HTCU_06_100ms, 32, 1);
        CanSendCan0Msg(0x2E5,   OBC_01_100ms, 32, 1);
        
        CanSendCan0Msg(0x265,   EMS_08_100ms, 32, 1);

        CanSendCan0Msg(0x1FA,   FR_CMR_02_100ms, 32, 1);
        CanSendCan0Msg(0x255,   LDC_01_100ms, 32, 1);
        CanSendCan0Msg(0x3FA,   HTCU_07_100ms, 16, 1);
        CanSendCan0Msg(0x2D0,   TCU_03_100ms, 32, 1);
        CanSendCan0Msg(0x20A,   ACU_01_100ms, 16, 1);
        CanSendCan0Msg(0x220,   ECS_01_100ms, 16, 1);
        CanSendCan0Msg(0x260,   EMS_05_100ms, 32, 1);
        CanSendCan0Msg(0x2F5,   LDC48V_01_100ms, 32, 1);
        //CanSendCan0Msg(0x3C5,   BMS_13_48V_100ms , 32, 1);
        CanSendCan0Msg(0x3A5,   SCU_FF_02_100ms, 8, 1);
        //CanSendCan0Msg(0x4CF,   IFS_01_200ms,  8, 1);
    }
    else if ((Timer10msCnts > SendCanMessage200msTimer) && ((Timer10msCnts - SendCanMessage200msTimer) >= 190)) {
        // 200ms
        SendCanMessage200msTimer = Timer10msCnts;
        InitBuf();  
        CanSendCan0Msg(0x3B3,   EVP_01_200ms, 8, 1);
        CanSendCan0Msg(0x41C,   BCM_09_200ms,  8, 1);
        CanSendCan0Msg(0x3E5,   BCM_05_200ms,  8, 1);
     //   ILCU_LH_01_200ms.ILCULH_IFSOpt_Sta=0x1;
#if (PRO_NQ5)
        CanSendCan0Msg(0x426,   ILCU_RH_01_200ms,  8, 1);
        CanSendCan0Msg(0x421,   ILCU_LH_01_200ms,  8, 1);
#endif
        

        CanSendCan0Msg(0x3E6,   BCM_06_200ms,  8, 1);
        //CanSendCan0Msg(0x488,   IBU_MFSW_01_200ms,  8, 1);
        //CanSendCan0Msg(0x489,   IBU_MFSW_02_200ms,  8, 1);
        //CanSendCan0Msg(0x422,   BCM_10_200ms,  8, 1);
        CanSendCan0Msg(0x41A,   BCM_07_200ms,  8, 1);
//        CanSendCan0Msg(0x3E1,   BCM_03_200ms,  8, 1);
        CanSendCan0Msg(0x413,   ICU_04_200ms,  8, 1);
        CanSendCan0Msg(0x414,   ICU_05_200ms,  8, 1);
        CanSendCan0Msg(0x417,   ICU_07_200ms,  8, 1);
        CanSendCan0Msg(0x425,   SMK_04_200ms,  8, 1);
       // ICU_02_200ms.Warn_DrvDrSwSta = 0x1;
        CanSendCan0Msg(0x411,   ICU_02_200ms,  8, 1);
        CanSendCan0Msg(0x3A0,   TPMS_01_200ms, 16, 1);
        CanSendCan0Msg(0x3E2,   BCM_04_200ms,  8, 1);
        //CanSendCan0Msg(0x416,   ICU_06_200ms,  8, 1);
        if (g_uiLPI_OverCheckFlag == 0) {
            ICU_08_200ms.ICU_PowerAutoCutModSta = 0x2;
        }
        CanSendCan0Msg(0x418,   ICU_08_200ms,  8, 1);
        //CanSendCan0Msg(0x434,   IAU_16_200ms,  8, 1);
        CanSendCan0Msg(0x405,   ICU_12_200ms,  8, 1);
        //CanSendCan0Msg(0x442,   BCM_12_200ms,  8, 1);
//        if (g_DriveModeFlag == 1){
//            CanSendCan0Msg(0x08B,   SWRC_05_200ms,  8, 0);
//            g_DriveModeFlag++;
//        }

        CanSendCan1Msg(0x4CE,   HU_CLU_PE_06,  8, 1);
        CanSendCan0Msg(0x39D,   EMS_14_200ms,  8, 1);
        CanSendCan1Msg(0x4F2,   HU_CLU_PE_05, 8,1);
    }
    else if ((Timer10msCnts > SendCanMessage500msTimer) && ((Timer10msCnts - SendCanMessage500msTimer) >= 500)) {
        // 500ms
        SendCanMessage500msTimer = Timer10msCnts;
        InitBuf();
    }
    else if ((Timer10msCnts > SendCanMessage1000msTimer) && ((Timer10msCnts - SendCanMessage1000msTimer) >= 1000)) {
        // 1000ms
        SendCanMessage1000msTimer = Timer10msCnts;
        InitBuf();  
        CanSendCan1Msg(0x4AC,   HU_USM_E_05, 8, 0); 
        CanSendCan1Msg(0x4D8,   HU_GW_PE_01, 8, 1);
        
    }
    else if ((Timer10msCnts > SendCanMessage2000msTimer) && ((Timer10msCnts - SendCanMessage2000msTimer) >= 2000)) {
        // 2000ms
        SendCanMessage2000msTimer = Timer10msCnts;
        InitBuf(); 
        CanSendCan1Msg(0x4FE,   HU_MON_PE_01, 8, 1);
    }
}


#endif
