/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_PRGCRC_H
#define __S6J3360_PRGCRC_H

#include "s6j3360io_basetypes.h"

/* CRC0 base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define CRC0	stcCRC0
#else /* __IO_DEFINE */
#define CRC0	(*((volatile stc_crc0_t*)0xB8018000))
#endif /* __IO_DEFINE */

/* POLY */
#define CRC0_POLY	(CRC0.unPOLY.u32Register)  /*@rg@*/
#define CRC0_POLY_POLY	CRC0_POLY  /*@bfrg@*/

typedef union un_crc0_poly{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_crc0_poly_t;

/* SEED */
#define CRC0_SEED	(CRC0.unSEED.u32Register)  /*@rg@*/
#define CRC0_SEED_SEED	CRC0_SEED  /*@bfrg@*/

typedef union un_crc0_seed{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_crc0_seed_t;

/* FXOR */
#define CRC0_FXOR	(CRC0.unFXOR.u32Register)  /*@rg@*/
#define CRC0_FXOR_FXOR	CRC0_FXOR  /*@bfrg@*/

typedef union un_crc0_fxor{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_crc0_fxor_t;

/* CFG */
#define CRC0_CFG	(CRC0.unCFG.u32Register)  /*@rg@*/
#define CRC0_CFG_CIRQCLR	(CRC0.unCFG.stcField.u1CIRQCLR)  /*@bf@*/
#define CRC0_CFG_ROBYT	(CRC0.unCFG.stcField.u1ROBYT)  /*@bf@*/
#define CRC0_CFG_ROBIT	(CRC0.unCFG.stcField.u1ROBIT)  /*@bf@*/
#define CRC0_CFG_RIBYT	(CRC0.unCFG.stcField.u1RIBYT)  /*@bf@*/
#define CRC0_CFG_RIBIT	(CRC0.unCFG.stcField.u1RIBIT)  /*@bf@*/
#define CRC0_CFG_LEN	(CRC0.unCFG.stcField.u6LEN)  /*@bf@*/
#define CRC0_CFG_SZ	(CRC0.unCFG.stcField.u2SZ)  /*@bf@*/
#define CRC0_CFG_CIRQ	(CRC0.unCFG.stcField.u1CIRQ)  /*@bf@*/
#define CRC0_CFG_CIEN	(CRC0.unCFG.stcField.u1CIEN)  /*@bf@*/
#define CRC0_CFG_CDEN	(CRC0.unCFG.stcField.u1CDEN)  /*@bf@*/
#define CRC0_CFG_LOCK	(CRC0.unCFG.stcField.u1LOCK)  /*@bf@*/

typedef struct stc_crc0_cfg_field{
    uint_io32_t		u1CIRQCLR:1;
    uint_io32_t		:7;
    uint_io32_t		u1ROBYT:1;
    uint_io32_t		u1ROBIT:1;
    uint_io32_t		u1RIBYT:1;
    uint_io32_t		u1RIBIT:1;
    uint_io32_t		:4;
    uint_io32_t		u6LEN:6;
    uint_io32_t		u2SZ:2;
    uint_io32_t		u1CIRQ:1;
    uint_io32_t		u1CIEN:1;
    uint_io32_t		u1CDEN:1;
    uint_io32_t		:1;
    uint_io32_t		u1LOCK:1;
    uint_io32_t		:3;
}stc_crc0_cfg_field_t;

typedef union un_crc0_cfg{
    uint_io32_t		u32Register;
    stc_crc0_cfg_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_crc0_cfg_t;

/* WR */
#define CRC0_WR	(CRC0.unWR.u32Register)  /*@rg@*/
#define CRC0_WR_CRCWR	CRC0_WR  /*@bfrg@*/

typedef union un_crc0_wr{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_crc0_wr_t;

/* RD */
#define CRC0_RD	(CRC0.unRD.u32Register)  /*@rg@*/
#define CRC0_RD_CRCRD	CRC0_RD  /*@bfrg@*/

typedef union un_crc0_rd{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_crc0_rd_t;


typedef struct stc_crc0{
    un_crc0_poly_t	unPOLY;	/* 0x00000000 */
    un_crc0_seed_t	unSEED;	/* 0x00000004 */
    un_crc0_fxor_t	unFXOR;	/* 0x00000008 */
    un_crc0_cfg_t	unCFG;	/* 0x0000000C */
    un_crc0_wr_t	unWR;	/* 0x00000010 */
    un_crc0_rd_t	unRD;	/* 0x00000014 */
    uint_io8_t	au8Reserved0[1000];	/* 0x00000018 */
}stc_crc0_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_crc0_t	stcCRC0;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_PRGCRC_H */
