#ifndef __APP_USM_H__
#define __APP_USM_H__

#define USM_OP_FORWARD 0
#define USM_OP_BACKWARD 1

#define USM_VALID       1
#define USM_INVALID     0

#define USM_DEPTH1_PARA                         0
#define USM_DEPTH2_DRIVERASSIST_                1
#define USM_DEPTH3_DRIVERASSIST_DAW             2
#define USM_DEPTH3_DRIVERASSIST_LANESAFETY      3
#define USM_DEPTH3_DRIVERASSIST_FORWARDSAFETY   4
#define USM_DEPTH2_DOOR                         5
#define USM_DEPTH3_DOOR_AUTOLOCK                6
#define USM_DEPTH3_DOOR_AUTOUNLOCK              7
#define USM_DEPTH2_LIGHT                        8
#define USM_DEPTH3_LIGHT_OTTS                   9
#define USM_DEPTH2_CONVENIENCE                  10
#define USM_DEPTH2_SERVICEINTERVAL              11
#define USM_DEPTH2_OTHER                        12
#define USM_DEPTH3_OTHER_FUELECONOMYRESET       13
#define USM_DEPTH3_OTHER_TEMPERATUREUNIT        14
#define USM_DEPTH2_LANGUAGE                     15

#define USM_PARK_POPUP          0
#define USM_PARK_SERVICE_POPUP  1
#define USM_PARK_NORMAL         2

//menu 1
enum {
    USM_TITLE,
    USM_HUD,
    USM_ESC_OFF,
    USM_DRIVE_ASSIST,
    USM_DOOR,
    USM_LIGHT,
    USM_SOUND,
    USM_CONVENIENCE,
    USM_SERVICE_INTERVAL,
    USM_OTHER,
    USM_LANGUAGE,
    USM_RESET,
    USM_DEPTH1_TOTAL,
};



//menu 2
enum {
    USM_DRIVE_ASSIST_TITLE,
    USM_DRIVE_ASSIST_RETURN,
    USM_DRIVE_ASSIST_DAW,
    USM_DRIVE_ASSIST_SCC_RESPONSE,
    USM_DRIVE_ASSIST_AEB,
    USM_DRIVE_ASSIST_FCW,
    USM_DRIVER_ASSIST_SCC_REACTION,
    USM_DRIVER_ASSIST_DAW,
    USM_DRIVER_ASSIST_LANE_SAFETY,
    USM_DRIVER_ASSIST_FORWARD_SAFETY,
    USM_DRIVE_ASSIST_TOTAL,
};

//menu 3
enum {
    USM_DRIVER_ASSIST_SCC_REACTION_TITLE,
    USM_DRIVER_ASSIST_SCC_REACTION_RETURN,
    USM_DRIVER_ASSIST_SCC_REACTION_FAST,
    USM_DRIVER_ASSIST_SCC_REACTION_NORMAL,
    USM_DRIVER_ASSIST_SCC_REACTION_LOW,
    USM_DRIVER_ASSIST_SCC_REACTION_TOTAL,
};

//menu 3
enum {
    USM_DRIVER_ASSIST_DAW_TITLE,
    USM_DRIVER_ASSIST_DAW_RETURN,
    USM_DRIVER_ASSIST_DAW_HIGH,
    USM_DRIVER_ASSIST_DAW_NORMAL,
    USM_DRIVER_ASSIST_DAW_CLOSE,
    USM_DRIVER_ASSIST_DAW_TOTAL,
};

//menu 3
enum {
    USM_DRIVER_ASSIST_LANE_SAFETY_TITLE,
    USM_DRIVER_ASSIST_LANE_SAFETY_RETURN,
    USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_CENTER,
    USM_DRIVER_ASSIST_LANE_SAFETY_KEEP_ASSIST,
    USM_DRIVER_ASSIST_LANE_SAFETY_DEVIATION_WARNING,
    USM_DRIVER_ASSIST_LANE_SAFETY_CLOSE,
    USM_DRIVER_ASSIST_LANE_SAFETY_TOTAL,
};

//menu 3
enum {
    USM_DRIVER_ASSIST_FORWARD_SAFETY_TITLE,
    USM_DRIVER_ASSIST_FORWARD_SAFETY_RETURN,
    USM_DRIVER_ASSIST_FORWARD_SAFETY_ANTI_COLLISION_ASSIST,
    USM_DRIVER_ASSIST_FORWARD_SAFETY_CONFLICT_WARNING,
    USM_DRIVER_ASSIST_FORWARD_SAFETY_CLOSE,
    USM_DRIVER_ASSIST_FORWARD_SAFETY_TOTAL,
};



//menu 2
enum {
    USM_DOOR_TITLE,
    USM_DOOR_RETURN,
    USM_DOOR_AUTO_LOCK,
    USM_DOOR_AUTO_UNLOCK,
    USM_DOOR_SMART_SUITCASE,
    USM_DOOR_HORN_FEEDBACK,
    USM_DOOR_WALKAWAY_LCOK,
    USM_DOOR_TOTAL,
};

//menu 3
enum {
    USM_DOOR_AUTO_LOCK_TITLE,
    USM_DOOR_AUTO_LOCK_RETURN,
    USM_DOOR_AUTO_LOCK_CLOSE,
    USM_DOOR_AUTO_LOCK_WHEN_DRIVE,
    USM_DOOR_AUTO_LOCK_WHEN_RND,
    USM_DOOR_AUTO_LOCK_TOTAL,
};

//menu 3
enum {
    USM_DOOR_AUTO_UNLOCK_TITLE,
    USM_DOOR_AUTO_UNLOCK_RETURN,
    USM_DOOR_AUTO_UNLOCK_CLOSE,
    USM_DOOR_AUTO_UNLOCK_WHEN_POWER_DOWN,
    USM_DOOR_AUTO_UNLOCK_DRIVER,
    USM_DOOR_AUTO_UNLOCK_WHEN_P,
    USM_DOOR_AUTO_UNLOCK_TOTAL,
};



//menu 2
enum {
    USM_LIGHT_TITLE,
    USM_LIGHT_RETURN,
    USM_LIGHT_ONE_TOUCH_TURN_SIGNAL,
    USM_LIGHT_HEADLIGHT_DELAY,
    USM_LIGHT_TOTAL,
};

//menu 3
enum {
    USM_LIGHT_OTTS_TITLE,
    USM_LIGHT_OTTS_RETURN,
    USM_LIGHT_OTTS_CLOSE,
    USM_LIGHT_OTTS_TIMES_3,
    USM_LIGHT_OTTS_TIMES_5,
    USM_LIGHT_OTTS_TIMES_7,
    USM_LIGHT_OTTS_TOTAL,
};



//menu 2
enum {
    USM_SOUND_TITLE,
    USM_SOUND_RETURN,
    USM_SOUND_CLUSTER_VOICE_GUIDANCE_VOLUME,
    USM_SOUND_PARK_ASSIST_VOLUME,
    USM_SOUND_WELCOME_SOUND,
    USM_SOUND_TOTAL,
};

//menu 3
enum {
    USM_SOUND_VPV_TITLE,
    USM_SOUND_VPV_RETURN,
    USM_SOUND_VPV_VOLUME_LV1,
    USM_SOUND_VPV_VOLUME_LV2,
    USM_SOUND_VPV_VOLUME_LV3,
    USM_SOUND_VPV_VOLUME_MUTE,
    USM_SOUND_VPV_TOTAL,
};

//menu 3
enum {
    USM_SOUND_PDWV_TITLE,
    USM_SOUND_PDWV_RETURN,
    USM_SOUND_PDWV_VOLUME_LV1,
    USM_SOUND_PDWV_VOLUME_LV2,
    USM_SOUND_PDWV_VOLUME_LV3,
    USM_SOUND_PDWV_TOTAL,
};



//menu 2
enum {
    USM_CONVENIENCE_TITLE,
    USM_CONVENIENCE_RETURN,
    USM_CONVENIENCE_WELCOME_MIRROR_LIGHT,
    USM_CONVENIENCE_WIPER_LIGHTS_DISPLAY,
    USM_CONVENIENCE_AUTO_REAR_WIPER,
    USM_CONVENIENCE_GEAR_POSITION_POP_UP,
    USM_CONVENIENCE_WIRELESS_CHARGING_SYSTEM,
    USM_CONVENIENCE_TOTAL,
};

//menu 3
enum {
    USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_TITLE,
    USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_RETURN,
    USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DOOR_UNLOCK,
    USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_DRIVER_CLOSE,
    USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_TOTAL,
};


//menu 2
enum {
    USM_SERVICE_INTERVAL_TITLE,
    USM_SERVICE_INTERVAL_RETURN,
    USM_SERVICE_INTERVAL_TIPS,
    USM_SERVICE_INTERVAL_SETTING,
    USM_SERVICE_INTERVAL_RESET,
    USM_SERVICE_INTERVAL_TOTAL,
};


//menu 2
enum {
    USM_OTHER_TITLE,
    USM_OTHER_RETURN,
    USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT,
    USM_OTHER_FUEL_ECONOMY_RESET,
    USM_OTHER_TRAILER_SUBSCALE,
    USM_OTHER_FONT_SIZE,
    USM_OTHER_SPEED_SIZE,
    USM_OTHER_SPEED_UNIT,
    USM_OTHER_FUEL_ECONOMY_UNIT,
    USM_OTHER_TEMPERATURE_UNIT,
    USM_OTHER_TIRE_PRESSSURE_UNIT,
    USM_OTHER_TOTAL,
};

//menu 3
enum {
    USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_TITLE,
    USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_RETURN,
    USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_SIMPLE,
    USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_CLASSICS,
    USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_DETAIL,
    USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_TOTAL,
};

//menu 3
enum {
    USM_OTHER_FUEL_ECONOMY_RESET_TITLE,
    USM_OTHER_FUEL_ECONOMY_RESET_RETURN,
    USM_OTHER_FUEL_ECONOMY_RESET_CLOSE,
    USM_OTHER_FUEL_ECONOMY_RESET_EVERY_START,
    USM_OTHER_FUEL_ECONOMY_RESET_EVERY_REFUEL,
    USM_OTHER_FUEL_ECONOMY_RESET_TOTAL,
};

//menu 3
enum {
    USM_OTHER_FONT_SIZE_TITLE,
    USM_OTHER_FONT_SIZE_RETURN,
    USM_OTHER_FONT_SIZE_MID,
    USM_OTHER_FONT_SIZE_BIG,
    USM_OTHER_FONT_SIZE_TOTAL,
};

//menu 3
enum {
    USM_OTHER_SPEED_SIZE_TITLE,
    USM_OTHER_SPEED_SIZE_RETURN,
    USM_OTHER_SPEED_SIZE_MID,
    USM_OTHER_SPEED_SIZE_BIG,
    USM_OTHER_SPEED_SIZE_TOTAL,
};

//menu 3
enum {
    USM_OTHER_SPEED_UNIT_TITLE,
    USM_OTHER_SPEED_UNIT_RETURN,
    USM_OTHER_SPEED_UNIT_KMH,
    USM_OTHER_SPEED_UNIT_MPH,
    USM_OTHER_SPEED_UNIT_TOTAL,
};

//menu 3
enum {
    USM_OTHER_FUEL_ECONOMY_UNIT_TITLE,
    USM_OTHER_FUEL_ECONOMY_UNIT_RETURN,
    USM_OTHER_FUEL_ECONOMY_UNIT_KML,
    USM_OTHER_FUEL_ECONOMY_UNIT_L100KM,
    USM_OTHER_FUEL_ECONOMY_UNIT_TOTAL,
};

//menu 3
enum {
    USM_OTHER_TEMPERATURE_UNIT_TITLE,
    USM_OTHER_TEMPERATURE_UNIT_RETURN,
    USM_OTHER_TEMPERATURE_UNIT_C,
    USM_OTHER_TEMPERATURE_UNIT_F,
    USM_OTHER_TEMPERATURE_UNIT_TOTAL,
};

//menu 3
enum {
    USM_OTHER_TIRE_PRESSSURE_UNIT_TITLE,
    USM_OTHER_TIRE_PRESSSURE_UNIT_RETURN,
    USM_OTHER_TIRE_PRESSSURE_UNIT_PSI,
    USM_OTHER_TIRE_PRESSSURE_UNIT_KPA,
    USM_OTHER_TIRE_PRESSSURE_UNIT_BAR,
    USM_OTHER_TIRE_PRESSSURE_UNIT_TOTAL,
};



//menu 2
enum {
    USM_LANGUAGE_TITLE,
    USM_LANGUAGE_RETURN,
    USM_LANGUAGE_CHINESE,
    USM_LANGUAGE_KOREAN,
    USM_LANGUAGE_ENGLISH,
    USM_LANGUAGE_TOTAL,
};

enum {
    USM_LIST_DEPTH1_ROOT,
    USM_LIST_DEPTH2_DRIVER_ASSIST,
    USM_LIST_DEPTH3_DRIVE_ASSIST_SCCREACTION,
    USM_LIST_DEPTH3_DRIVE_ASSIST_DAW,
    USM_LIST_DEPTH3_DRIVE_ASSIST_LANESAFETY,
    USM_LIST_DEPTH3_DRIVE_ASSIST_FORWARDSAFETY,
    USM_LIST_DEPTH2_DOOR,
    USM_LIST_DEPTH3_DOOR_AUTO_LOCK,
    USM_LIST_DEPTH3_DOOR_AUTO_UNLOCK,
    USM_LIST_DEPTH2_LIGHT,
    USM_LIST_DEPTH3_LIGHT_OTTS,
    USM_LIST_DEPTH2_SOUND,
    USM_LIST_DEPTH3_SOUND_VPV,
    USM_LIST_DEPTH3_SOUND_PDWV,
    USM_LIST_DEPTH2_CONVENIENCE,
    USM_LIST_DEPTH3_CONVENIENCE_WELCOME_MIRROR_LIGHT,
    USM_LIST_DEPTH2_OTHER,
    USM_LIST_DEPTH3_OTHER_INSTRUMENT_CLUSTER_LAYOUT,
    USM_LIST_DEPTH3_OTHER_FUEL_ECONOMY_RESET,
    USM_LIST_DEPTH3_OTHER_FONT_SIZE,
    USM_LIST_DEPTH3_OTHER_SPEED_SIZE,
    USM_LIST_DEPTH3_OTHER_SPEED_UNIT,
    USM_LIST_DEPTH3_OTHER_FUEL_ECONOMY_UNIT,
    USM_LIST_DEPTH3_OTHER_TEMPERATURE_UNIT,
    USM_LIST_DEPTH3_OTHER_TIREPRESSSURE_UNIT,
    USM_LIST_DEPTH2_LANGUAGE,
};

enum {
    USM_ITEM_TYPE_ARROW = 1,
    USM_TIEM_TYPE_CHECK_BOX,
    USM_ITEM_TYPE_RADIO_BOX,
};

typedef struct{
    uint32_t WhitePic;
    uint32_t GrayPic;
    uint32_t AllPic;
    uint32_t HelpPic;
}USM_PIC_ITEM;

typedef struct {
    USM_PIC_ITEM Pic;
    uint8_t Type;         //ұ
    uint8_t Invalid;      //Ч־Ƿʾ
    uint8_t Attribute;    //ʾ
    uint8_t Disabled;     //ñ־ɫ
    uint16_t ALL_Length;  //ȫֿ
    uint8_t HelpLine;     //ͼƬм
    uint8_t HelpTitleLine; //ͼƬıм
    void (*CurUSMFunc)(void); 
}USM_ITEM;

typedef struct {
    uint32_t USMID;
    USM_ITEM *pCurUSM;
    uint8_t CurUSMMaxItem;
    uint8_t CurUSMValidNum;
    uint8_t LastUSMValidNum;
}CUR_USM_PARA;

typedef struct {
    int16_t StartNum;
    int16_t CurNum;
    int16_t EndNum;
}USM_DATA_WINDOW;

typedef struct{
    uint32_t HelpPic;
    uint8_t TotalHelpLine;
    uint8_t CurHelpLine;
    int16_t EveryOffsetPixel;
    uint8_t OffsetStep;
    uint8_t HelpTitleLine;
}USM_HELP_PARA;
extern USM_HELP_PARA USMHelpPara;

typedef struct{
    uint8_t ParaInited;
	uint8_t Language;
    uint8_t Flag_WiperLight_Display;    //default:on
    uint8_t Flag_GearPositionPopUp;     //default:on
    uint8_t FuelEconomyResetState;    //default:refule
}USM_SELF_PARA;
extern USM_SELF_PARA UsmSelfPara;

extern CUR_USM_PARA CurUSMPara[];
extern uint8_t CurUSM;
extern uint8_t LastUSM;
extern uint8_t USMOp;
extern uint32_t LastUSMTransitionTime;
extern uint8_t Flag_USM_Help;
extern USM_ITEM USMDepth1Para[USM_DEPTH1_TOTAL];
extern USM_ITEM USMDepth2DriveAssist[USM_DRIVE_ASSIST_TOTAL];
extern USM_ITEM USMDepth3DriveAssistSccReaction[USM_DRIVER_ASSIST_SCC_REACTION_TOTAL];
extern USM_ITEM USMDepth3DriveAssistDAW[USM_DRIVER_ASSIST_DAW_TOTAL];
extern USM_ITEM USMDepth3DriveAssistLaneSafety[USM_DRIVER_ASSIST_LANE_SAFETY_TOTAL];
extern USM_ITEM USMDepth3DriveAssistForwardSafety[USM_DRIVER_ASSIST_FORWARD_SAFETY_TOTAL];
extern USM_ITEM USMDepth2Door[USM_DOOR_TOTAL];
extern USM_ITEM USMDepth3DoorAutoLock[USM_DOOR_AUTO_LOCK_TOTAL];
extern USM_ITEM USMDepth3DoorAutoUnlock[USM_DOOR_AUTO_UNLOCK_TOTAL];
extern USM_ITEM USMDepth2Light[USM_LIGHT_TOTAL];
extern USM_ITEM USMDepth3LightOTTS[USM_LIGHT_OTTS_TOTAL];
extern USM_ITEM USMDepth2Sound[USM_SOUND_TOTAL];
extern USM_ITEM USMDepth3SoundVPV[USM_SOUND_VPV_TOTAL];
extern USM_ITEM USMDepth3SoundPDWV[USM_SOUND_PDWV_TOTAL];
extern USM_ITEM USMDepth2Convenience[USM_CONVENIENCE_TOTAL];
extern USM_ITEM USMDepth3ConvenienceWelcomeMirrorLight[USM_CONVENIENCE_WELCOME_MIRROR_LIGHT_TOTAL];
extern USM_ITEM USMDepth2Other[USM_OTHER_TOTAL];
extern USM_ITEM USMDepth3OtherInstrumentClusterLayout[USM_OTHER_INSTRUMENT_CLUSTER_LAYOUT_TOTAL];
extern USM_ITEM USMDepth3OtherFuelEconomyReset[USM_OTHER_FUEL_ECONOMY_RESET_TOTAL];
extern USM_ITEM USMDepth3OtherFontSize[USM_OTHER_FONT_SIZE_TOTAL];
extern USM_ITEM USMDepth3OtherSpeedSize[USM_OTHER_SPEED_SIZE_TOTAL];
extern USM_ITEM USMDepth3OtherSpeedUnit[USM_OTHER_SPEED_UNIT_TOTAL];
extern USM_ITEM USMDepth3OtherFuelEconomyUnit[USM_OTHER_FUEL_ECONOMY_UNIT_TOTAL];
extern USM_ITEM USMDepth3OtherTemperatureUnit[USM_OTHER_TEMPERATURE_UNIT_TOTAL];
extern USM_ITEM USMDepth3OtherTirePresssureUnit[USM_OTHER_TIRE_PRESSSURE_UNIT_TOTAL];
extern USM_ITEM USMDepth2Language[USM_LANGUAGE_TOTAL];
extern USM_DATA_WINDOW USMDataWindow[4];

extern int8_t USMSelectMovePoint;
extern int8_t USMTextMovePoint;
extern uint8_t Flag_Reset;
extern uint8_t Flag_Reset_OK;
extern uint8_t Flag_Reset_Cancel;
extern uint8_t Flag_USM_Park;
extern uint8_t Flag_USM_Popup;
extern uint8_t USM_Park_Step;
extern uint8_t Flag_USMBackToTop;
extern uint8_t Flag_ServiceReset;
extern uint8_t ServiceResetSetNum;

extern void USMHelpRightBarPro(void);
extern void USMHelpPro(uint8_t Key);
extern void USMHelpInit(CUR_USM_PARA *CurUSM, uint8_t DataWindow);
extern void UpdateUSMHelp(void);
extern void USMParkPro(uint8_t Key);
extern void UpdataUSMPark(void);
extern void CheckUsmSetState(void);
extern void UpdataUSMReset(void);
extern void USMResetFunc(uint8_t Key);
extern void UpdataUSMServiceIntervalSetting(void);
extern void RunUSMHandler(CUR_USM_PARA *CurUSM, uint8_t DataWindow);
extern uint8_t CheckUSMDisabled(CUR_USM_PARA *CurUSM, uint8_t DataWindow);
extern void UpdateUSMItem(CUR_USM_PARA *CurUSM, uint8_t DataWindow);
extern void USMOptionPro(void);
extern uint8_t FindUSMID(uint8_t op);
extern uint8_t SearchUSMHelp(CUR_USM_PARA *CurUSM, uint8_t DataWindow);
extern void USMChange(uint8_t CurDepth, uint8_t DestUSM, uint8_t op);
extern void CalcUSMDataWindow(uint8_t CurUSMDataWindow, CUR_USM_PARA *CurUSM, uint8_t op, uint8_t start, uint8_t cur);
extern void CalcUSMDataWindow_ServiceInterval(uint8_t CurUSMDataWindow, CUR_USM_PARA *CurUSM, uint8_t op, uint8_t start, uint8_t cur);
extern void InitUSMPara(uint8_t Languate, uint8_t ReInit);
extern void UpdateUSM(CUR_USM_PARA *CurUSM, uint8_t DataWindow, uint8_t Transition, int16_t TransitionXOffset);
extern void DisplayUSMTransitionPic(CENTER_AREA_DISPLAY_ITEM *DisplayItem, int16_t Xoffset);
extern void UpdataUSMServiceReset(void);  /* qitiancun 2018-9-3 */

#endif