/******************************************************************************
 * $Revision: 423 $
 * $Date:: 2017-04-07 16:03:30 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************
 ** \file mfs_i2c_generated.c
 **
 ** Generated file for i2c.c module, including variables and functions
 ** for internal data and interrupt handling. The individual ISRs for each
 ** peripheral are calling the generic handler in i2c.c.
 **
 ** \note This file must not be added to the build files - it will be included
 **       by i2c.c automatically!
 **
 ** History:
 **   - 2014-11-25  1.0  Initial Version for Traveo I2C
 *****************************************************************************/

#ifndef __I2C_GENERATED_C__
#define __I2C_GENERATED_C__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include <interrupts.h>

/*****************************************************************************/
/* Local pre-processor symbols/macros ('#define')                            */
/*****************************************************************************/

/* Macro to return the number of enabled I2C instances */
#define I2C_INSTANCE_COUNT (uint32_t)(sizeof(m_astcI2cInstanceDataLut) / sizeof(m_astcI2cInstanceDataLut[0]))

/*****************************************************************************/
/* Global variable definitions (declared in header file with 'extern')       */
/*****************************************************************************/


/*****************************************************************************/
/* Local type definitions ('typedef')                                        */
/*****************************************************************************/

/** Enumeration to define an index for each enabled I2C instance */
typedef enum en_i2c_instance_index
{
    #if (PDL_PERIPHERAL_ENABLE_I2C0 == PDL_ON)
    I2cInstanceIndexI2c0,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C1 == PDL_ON)
    I2cInstanceIndexI2c1,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C2 == PDL_ON)
    I2cInstanceIndexI2c2,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C3 == PDL_ON)
    I2cInstanceIndexI2c3,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C4 == PDL_ON)
    I2cInstanceIndexI2c4,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C5 == PDL_ON)
    I2cInstanceIndexI2c5,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C6 == PDL_ON)
    I2cInstanceIndexI2c6,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C7 == PDL_ON)
    I2cInstanceIndexI2c7,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C8 == PDL_ON)
    I2cInstanceIndexI2c8,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C9 == PDL_ON)
    I2cInstanceIndexI2c9,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C10 == PDL_ON)
    I2cInstanceIndexI2c10,
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C11 == PDL_ON)
    I2cInstanceIndexI2c11,
    #endif
    I2cInstanceIndexMax
} en_i2c_instance_index_t;

/** I2C instance data type */
typedef struct stc_i2c_instance_data
{
    volatile stc_cpg_mfsn_i2c_t*     pstcInstance;   /*!< pointer to registers of an instance */
    stc_i2c_intern_data_t            stcInternData;  /*!< module internal data of instance */
} stc_i2c_instance_data_t;

/*****************************************************************************/
/* Local variable definitions ('static')                                     */
/*****************************************************************************/

/** Look-up table for all enabled I2C instances and their internal data */
static stc_i2c_instance_data_t m_astcI2cInstanceDataLut[I2cInstanceIndexMax] =
{
    #if (PDL_PERIPHERAL_ENABLE_I2C0 == PDL_ON)
    {
        &CPG_MFS00_I2C,   /* pstcInstance */
        {NULL}            /* stc_i2c_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C1 == PDL_ON)
    {
        &CPG_MFS01_I2C,   /* pstcInstance */
        {NULL}            /* stc_i2c_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C2 == PDL_ON)
    {
        &CPG_MFS02_I2C,   /* pstcInstance */
        {NULL}            /* stc_i2c_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C3 == PDL_ON)
    {
        &CPG_MFS03_I2C,   /* pstcInstance */
        {NULL}            /* stc_i2c_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C4 == PDL_ON)
    {
        &CPG_MFS04_I2C,   /* pstcInstance */
        {NULL}            /* stc_i2c_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C5 == PDL_ON)
    {
        &CPG_MFS05_I2C,   /* pstcInstance */
        {NULL}            /* stc_i2c_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C6 == PDL_ON)
    {
        &CPG_MFS06_I2C,   /* pstcInstance */
        {NULL}            /* stc_i2c_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C7 == PDL_ON)
    {
        &CPG_MFS07_I2C,   /* pstcInstance */
        {NULL}            /* stc_i2c_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C8 == PDL_ON)
    {
        &CPG_MFS08_I2C,   /* pstcInstance */
        {NULL}            /* stc_i2c_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C9 == PDL_ON)
    {
        &CPG_MFS09_I2C,   /* pstcInstance */
        {NULL}            /* stc_i2c_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C10 == PDL_ON)
    {
        &CPG_MFS10_I2C,   /* pstcInstance */
        {NULL}            /* stc_i2c_intern_data_t */
    },
    #endif
    #if (PDL_PERIPHERAL_ENABLE_I2C11 == PDL_ON)
    {
        &CPG_MFS11_I2C,   /* pstcInstance */
        {NULL}            /* stc_i2c_intern_data_t */
    },
    #endif
};

/*****************************************************************************/
/* Local function prototypes ('static')                                      */
/*****************************************************************************/

/*****************************************************************************/
/* Function implementation - global ('extern') and local ('static')          */
/*****************************************************************************/

/**
 ******************************************************************************
 ** \brief Return the internal data for a certain I2C instance.
 **
 ** \param pstcI2c Pointer to I2C instance
 **
 ** \return Pointer to internal data or NULL if instance is not enabled (or not known)
 **
 ******************************************************************************/
static stc_i2c_intern_data_t* I2cGetInternDataPtr(volatile stc_cpg_mfsn_i2c_t* pstcI2c)
{
    stc_i2c_intern_data_t *pstcInternData = NULL;
    uint32_t               u32Instance;

    if (pstcI2c != NULL)
    {
        for (u32Instance = 0; u32Instance < (uint32_t)I2cInstanceIndexMax; u32Instance++)
        {
            if (pstcI2c == m_astcI2cInstanceDataLut[u32Instance].pstcInstance)
            {
                pstcInternData = &m_astcI2cInstanceDataLut[u32Instance].stcInternData;
                break;
            }
        }
    }
    return pstcInternData;
} /*I2cGetInternDataPtr*/

/*
 * Definition of ISR for each enabled I2C instance.
 * The individual ISR calls the generic IRQ handler with
 * the instance pointer and its internal data to handle the interrupt.
 */

#if (PDL_PERIPHERAL_ENABLE_I2C0 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c0_Status, INTERRUPTS_IRQ_NUMBER_222)
{
    I2cIrqHandler(&CPG_MFS00_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c0].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c0_Tx, INTERRUPTS_IRQ_NUMBER_47)
{
    I2cIrqHandlerTx(&CPG_MFS00_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c0].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c0_Rx, INTERRUPTS_IRQ_NUMBER_46)
{
    I2cIrqHandlerRx(&CPG_MFS00_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c0].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif 


#if (PDL_PERIPHERAL_ENABLE_I2C1 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c1_Status, INTERRUPTS_IRQ_NUMBER_223)
{
    I2cIrqHandler(&CPG_MFS01_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c1].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c1_Tx, INTERRUPTS_IRQ_NUMBER_49)
{
    I2cIrqHandlerTx(&CPG_MFS01_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c1].stcInternData));
}
FN_IRQ_DEFINE_END()


FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c1_Rx, INTERRUPTS_IRQ_NUMBER_48)
{
    I2cIrqHandlerRx(&CPG_MFS01_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c1].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif 


#if (PDL_PERIPHERAL_ENABLE_I2C2 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c2_Status, INTERRUPTS_IRQ_NUMBER_224)
{
    I2cIrqHandler(&CPG_MFS02_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c2].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c2_Tx, INTERRUPTS_IRQ_NUMBER_51)
{
    I2cIrqHandlerTx(&CPG_MFS02_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c2].stcInternData));
}
FN_IRQ_DEFINE_END()


FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c2_Rx, INTERRUPTS_IRQ_NUMBER_50)
{
    I2cIrqHandlerRx(&CPG_MFS02_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c2].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif 


#if (PDL_PERIPHERAL_ENABLE_I2C3 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c3_Status, INTERRUPTS_IRQ_NUMBER_225)
{
    I2cIrqHandler(&CPG_MFS03_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c3].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c3_Tx, INTERRUPTS_IRQ_NUMBER_53)
{
    I2cIrqHandlerTx(&CPG_MFS03_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c3].stcInternData));
}
FN_IRQ_DEFINE_END()


FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c3_Rx, INTERRUPTS_IRQ_NUMBER_52)
{
    I2cIrqHandlerRx(&CPG_MFS03_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c3].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif 


#if (PDL_PERIPHERAL_ENABLE_I2C4 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c4_Status, INTERRUPTS_IRQ_NUMBER_226)
{
    I2cIrqHandler(&CPG_MFS04_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c4].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c4_Tx, INTERRUPTS_IRQ_NUMBER_55)
{
    I2cIrqHandlerTx(&CPG_MFS04_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c4].stcInternData));
}
FN_IRQ_DEFINE_END()


FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c4_Rx, INTERRUPTS_IRQ_NUMBER_54)
{
    I2cIrqHandlerRx(&CPG_MFS04_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c4].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif 


#if (PDL_PERIPHERAL_ENABLE_I2C5 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c5_Status, INTERRUPTS_IRQ_NUMBER_227)
{
    I2cIrqHandler(&CPG_MFS05_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c5].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c5_Tx, INTERRUPTS_IRQ_NUMBER_57)
{
    I2cIrqHandlerTx(&CPG_MFS05_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c5].stcInternData));
}
FN_IRQ_DEFINE_END()


FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c5_Rx, INTERRUPTS_IRQ_NUMBER_56)
{
    I2cIrqHandlerRx(&CPG_MFS05_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c5].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif 


#if (PDL_PERIPHERAL_ENABLE_I2C6 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c6_Status, INTERRUPTS_IRQ_NUMBER_228)
{
    I2cIrqHandler(&CPG_MFS06_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c6].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c6_Tx, INTERRUPTS_IRQ_NUMBER_59)
{
    I2cIrqHandlerTx(&CPG_MFS06_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c6].stcInternData));
}
FN_IRQ_DEFINE_END()


FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c6_Rx, INTERRUPTS_IRQ_NUMBER_58)
{
    I2cIrqHandlerRx(&CPG_MFS06_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c6].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif 


#if (PDL_PERIPHERAL_ENABLE_I2C7 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c7_Status, INTERRUPTS_IRQ_NUMBER_229)
{
    I2cIrqHandler(&CPG_MFS07_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c7].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c7_Tx, INTERRUPTS_IRQ_NUMBER_61)
{
    I2cIrqHandlerTx(&CPG_MFS07_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c7].stcInternData));
}
FN_IRQ_DEFINE_END()


FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c7_Rx, INTERRUPTS_IRQ_NUMBER_60)
{
    I2cIrqHandlerRx(&CPG_MFS07_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c7].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif 


#if (PDL_PERIPHERAL_ENABLE_I2C8 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c8_Status, INTERRUPTS_IRQ_NUMBER_230)
{
    I2cIrqHandler(&CPG_MFS08_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c8].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c8_Tx, INTERRUPTS_IRQ_NUMBER_63)
{
    I2cIrqHandlerTx(&CPG_MFS08_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c8].stcInternData));
}
FN_IRQ_DEFINE_END()


FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c8_Rx, INTERRUPTS_IRQ_NUMBER_62)
{
    I2cIrqHandlerRx(&CPG_MFS08_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c8].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif 


#if (PDL_PERIPHERAL_ENABLE_I2C9 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c9_Status, INTERRUPTS_IRQ_NUMBER_231)
{
    I2cIrqHandler(&CPG_MFS09_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c9].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c9_Tx, INTERRUPTS_IRQ_NUMBER_65)
{
    I2cIrqHandlerTx(&CPG_MFS09_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c9].stcInternData));
}
FN_IRQ_DEFINE_END()


FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c9_Rx, INTERRUPTS_IRQ_NUMBER_64)
{
    I2cIrqHandlerRx(&CPG_MFS09_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c9].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif 


#if (PDL_PERIPHERAL_ENABLE_I2C10 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c10_Status, INTERRUPTS_IRQ_NUMBER_232)
{
    I2cIrqHandler(&CPG_MFS10_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c10].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c10_Tx, INTERRUPTS_IRQ_NUMBER_67)
{
    I2cIrqHandlerTx(&CPG_MFS10_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c10].stcInternData));
}
FN_IRQ_DEFINE_END()


FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c10_Rx, INTERRUPTS_IRQ_NUMBER_66)
{
    I2cIrqHandlerRx(&CPG_MFS10_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c10].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif 


#if (PDL_PERIPHERAL_ENABLE_I2C11 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c11_Status, INTERRUPTS_IRQ_NUMBER_233)
{
    I2cIrqHandler(&CPG_MFS11_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c11].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c11_Tx, INTERRUPTS_IRQ_NUMBER_69)
{
    I2cIrqHandlerTx(&CPG_MFS11_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c11].stcInternData));
}
FN_IRQ_DEFINE_END()

FN_IRQ_DEFINE_BEGIN(I2c_Isr_I2c11_Rx, INTERRUPTS_IRQ_NUMBER_68)
{
    I2cIrqHandlerRx(&CPG_MFS11_I2C, &(m_astcI2cInstanceDataLut[I2cInstanceIndexI2c11].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif 


#endif  // __I2C_GENERATED_C__

