#include "common_include.h"


uint8_t SaveAFCValid = 0;//save
uint8_t SaveAfterAFCValid = 0;
uint8_t SaveODOValid = 0;
uint8_t SaveDentifierValid = 0;
uint8_t SaveMiscValid = 0;
uint8_t SaveIMSValid = 0;
uint8_t SaveVINValid = 0;
uint8_t SaveEolValid = 0;

uint8_t TestPartNum[16] = {0};
static void UpdateSAFPack(void)
{
    //SAVE_AFC_INFO data;
    
    memcpy(&SAFPack.PartNum[0], &TestPartNum[0], 10);
    memcpy(&SAFPack.PartNum_AssemblyWorkshop[0], &PartNum_AssemblyWorkshop[0], 10);
	SAFPack.ClusterID = ClusterID;
	SAFPack.BarcodeDate = BarcodeDate;
    memcpy(&SAFPack.SerialNumber[0], &SerialNumber[0], 4);
    SAFPack.Crc32Check = 0xFFFFFFFF;
    CRC32_cal(&SAFPack.Crc32Check, (uint8_t*)&SAFPack, sizeof(WK_SERVICE_ACCUMULATED_PACK) - 4u);
}

extern uint16_t Diaplay_test;
static void UpdateUsmUserPack(void)
{
    UsmUserRecordPack.DateTime = tmpBarcodeDate;
    UsmUserRecordPack.Diaplay_test = tmpClusterID;
	
    memcpy(&UsmUserRecordPack.CheckResult[0], CheckResult, sizeof(CheckResult));
    
    UsmUserRecordPack.Crc32Check = 0xFFFFFFFF;
    CRC32_cal(&UsmUserRecordPack.Crc32Check, (uint8_t*)&UsmUserRecordPack, WK_USM_USER_PACK_LENGTH - 4u);
}

static void UpdateEolUdsPack(void)
{
    //WkEolUdsPack.Eol = EolStruct; 
    //WkEolUdsPack.EolResult = EolResult; 
    //WkEolUdsPack.EolCounts = EolCounts; 
    
    //memcpy(&WkEolUdsPack.VIN[0], &VIN_NumberBuf[0], 17);
    //WkEolUdsPack.VIN_State = VIN_State;
    
    //memcpy((void*)&WkEolUdsPack.DealerID[0], &Dentifierdata.DenData.DealerID[0], 5);
    //memcpy((void*)&WkEolUdsPack.ChangeData[0], &Dentifierdata.DenData.ChangeData[0], 4);
    //memcpy((void*)&WkEolUdsPack.ODO[0], &Dentifierdata.DenData.ODO[0], 4);
    //WkEolUdsPack.Sum = Dentifierdata.DenData.Sum;
    //WkEolUdsPack.ChangeTimes = Dentifierdata.ChangeTimes;
    //WkEolUdsPack.ODO_State = ODO_State;
    //
    //WkEolUdsPack.Checkflag   = JumpToAppReg.Checkflag; 		
    //WkEolUdsPack.AppExist    = JumpToAppReg.AppExist; 		
    //WkEolUdsPack.SessionType = JumpToAppReg.SessionType; 	
    //
    //WkEolUdsPack.Crc32Check = 0xFFFFFFFF;
    //CRC32_cal(&WkEolUdsPack.Crc32Check, (uint8_t*)&WkEolUdsPack, WK_EOL_UDS_PACK_LENGTH - 4u);
}

static void RequestResetMCU(void)
{
    //if((Flag_ResetMCU == 1u) && (WorkFlashCheckIdleState() == 1u))
    //{
    //    for (int i = 0; i < 10000; i++) 
    //    {
    //        NOP();
    //        ClearHWatchdog();
    //    }  
    //    IRQ_DISABLE_LOCAL();
    //    HWDG_TRG0 = 123456;
    //    HWDG_TRG1 = 123456;
    //    IRQ_RESTORE();
    //}
}


uint8_t WorkFlashWriteBlock = 0;
uint32_t TripCParaTotalODO = 0;
void ReadDataFormWorkFlash(void)
{
    TripCParaTotalODO = ReadODORecord();
    //ReadEolUdsRecord((uint8_t *)&WkEolUdsPack, WK_EOL_UDS_PACK_LENGTH);
    
    ReadUsmUserRecord((uint8_t *)&UsmUserRecordPack, WK_USM_USER_PACK_LENGTH);
    
    ReadSAFRecord((uint8_t *)&SAFPack, WK_SAF_PACK_LENGTH);
}

uint32_t ClearOdoState1 = 0;
uint32_t ClearOdoState2 = 0;
void SaveDataByWorkFlash(void)
{
    uint16_t AbnormalPowerCheckVol = 0;

    AbnormalPowerCheckVol = 1200;

    WK_SetVoltageState(AbnormalPowerCheckVol, AbnormalPowerCondition == ABNORMAL_POWER_CONDITION_UNDER? 1 : 0);
    
    if((ClearOdoState1 != 0x22334455) || (ClearOdoState2 != 0xEEFFDDCC))
    {
        if(WorkFlashWriteBlock == WORK_FLASH_BLOCK_NONE)
        {
            if (SaveODOValid != 0u) 
            {
                WorkFlashWriteBlock = WORK_FLASH_BLOCK_ODO;
            } 
            else if (SaveAFCValid != 0u) 
            {
                WorkFlashWriteBlock = WORK_FLASH_BLOCK_SAF;
            } 
            else if (SaveMiscValid != 0u) 
            {
                WorkFlashWriteBlock = WORK_FLASH_BLOCK_USM;
            } 
            else if ((SaveEolValid != 0u) || (SaveVINValid != 0u) || (SaveDentifierValid != 0u)) 
            {
                WorkFlashWriteBlock = WORK_FLASH_BLOCK_EOL;
            }  
            else 
            {
                /* Intentionally Empty */
            }
        }
        
        switch(WorkFlashWriteBlock)
        {
        case WORK_FLASH_BLOCK_ODO:
            if(StoreODOIntoWorkFlash(TripCParaTotalODO) == WFLASH_WRITE_OK)
            {
                SaveODOValid = 0u;
                WorkFlashWriteBlock = WORK_FLASH_BLOCK_NONE;
            }
            break;
        case WORK_FLASH_BLOCK_SAF:
            UpdateSAFPack();
            if(StoreSAFIntoWorkFlash((uint8_t *)&SAFPack, WK_SAF_PACK_LENGTH) == WFLASH_WRITE_OK)
            {
                SaveAFCValid = 0u;
                WorkFlashWriteBlock = WORK_FLASH_BLOCK_NONE;
            }
            break;
        case WORK_FLASH_BLOCK_USM:
            UpdateUsmUserPack();
            if(StoreUsmUserIntoWorkFlash((uint8_t *)&UsmUserRecordPack, WK_USM_USER_PACK_LENGTH) == WFLASH_WRITE_OK)
            {
                SaveMiscValid = 0u;
                WorkFlashWriteBlock = WORK_FLASH_BLOCK_NONE;
            }
            break;
        case WORK_FLASH_BLOCK_EOL:
            UpdateEolUdsPack();
            if(StoreEolUdsIntoWorkFlash((uint8_t *)&WkEolUdsPack, WK_EOL_UDS_PACK_LENGTH) == WFLASH_WRITE_OK)
            {
                SaveEolValid = 0u; 
                SaveVINValid = 0u; 
                SaveDentifierValid = 0u;
                WorkFlashWriteBlock = WORK_FLASH_BLOCK_NONE;
                RequestResetMCU();
            }
            break;
        default:
            WorkFlashWriteBlock = WORK_FLASH_BLOCK_NONE;
            SaveEolValid = 0u; 
            SaveVINValid = 0u; 
            SaveDentifierValid = 0u;
            SaveMiscValid = 0u;
            SaveAFCValid = 0u;
            SaveODOValid = 0u;
            break;
        }
    }
    
    WorkFlashErasePro();
}